"use strict";
var apiLoader = require("./raml1/apiLoader");
var path = require("path");
var PromiseConstructor = require('promise-polyfill');
/**
 * RAML 1.0 top-level AST interfaces.
 */
exports.api10 = require("./raml1/artifacts/raml10parserapi");
/**
 * RAML 0.8 top-level AST interfaces.
 */
exports.api08 = require("./raml1/artifacts/raml08parserapi");
function loadApiSync(apiPath, arg1, arg2) {
    return apiLoader.loadApi(apiPath, arg1, arg2).getOrElse(null);
}
exports.loadApiSync = loadApiSync;
function loadRAMLSync(ramlPath, arg1, arg2) {
    return apiLoader.loadApi(ramlPath, arg1, arg2).getOrElse(null);
}
exports.loadRAMLSync = loadRAMLSync;
function optionsForContent(content, arg2, filePath) {
    return {
        fsResolver: {
            content: function (pathStr) {
                if (pathStr === (filePath || path.resolve("/", "#local.raml")).replace(/\\/, "/")) {
                    return content;
                }
                if (arg2) {
                    if (arg2.fsResolver) {
                        return arg2.fsResolver.content(pathStr);
                    }
                }
            },
            contentAsync: function (pathStr) {
                if (pathStr === (filePath || path.resolve("/", "#local.raml")).replace(/\\/, "/")) {
                    return Promise.resolve(content);
                }
                if (arg2) {
                    if (arg2.fsResolver) {
                        return arg2.fsResolver.contentAsync(pathStr);
                    }
                }
            }
        },
        httpResolver: arg2 ? arg2.httpResolver : null,
        rejectOnErrors: arg2 ? arg2.rejectOnErrors : false,
        attributeDefaults: arg2 ? arg2.attributeDefaults : true
    };
}
/**
 * Load RAML synchronously. May load both Api and Typed fragments. If the 'rejectOnErrors' option is set to true, [[ApiLoadingError]] is thrown for RAML which contains errors.
 * @param content content of the raml
 * @param options Load options  (note you should path a resolvers if you want includes to be resolved)
 * @return RAMLLanguageElement instance.
 **/
function parseRAMLSync(content, arg2) {
    var filePath = null;
    if (arg2 && arg2.filePath)
        filePath = arg2.filePath;
    return apiLoader.loadApi(filePath || "/#local.raml", [], optionsForContent(content, arg2, filePath)).getOrElse(null);
}
exports.parseRAMLSync = parseRAMLSync;
/**
 * Load RAML asynchronously. May load both Api and Typed fragments. If the 'rejectOnErrors' option is set to true, [[ApiLoadingError]] is thrown for RAML which contains errors.
 * @param content content of the raml
 * @param options Load options  (note you should path a resolvers if you want includes to be resolved)
 * @return RAMLLanguageElement instance.
 **/
function parseRAML(content, arg2) {
    var filePath = null;
    if (arg2 && arg2.filePath)
        filePath = arg2.filePath;
    return apiLoader.loadApiAsync(filePath || "/#local.raml", [], optionsForContent(content, arg2, filePath));
}
exports.parseRAML = parseRAML;
function loadApi(apiPath, arg1, arg2) {
    return apiLoader.loadApiAsync(apiPath, arg1, arg2);
}
exports.loadApi = loadApi;
function loadRAML(ramlPath, arg1, arg2) {
    return apiLoader.loadRAMLAsync(ramlPath, arg1, arg2);
}
exports.loadRAML = loadRAML;
/**
 * Gets AST node by runtime type, if runtime type matches any.
 * @param runtimeType - runtime type to find the match for
 */
function getLanguageElementByRuntimeType(runtimeType) {
    return apiLoader.getLanguageElementByRuntimeType(runtimeType);
}
exports.getLanguageElementByRuntimeType = getLanguageElementByRuntimeType;
/**
 * Check if the AST node represents fragment
 */
function isFragment(node) {
    return exports.api10.isFragment(node);
}
exports.isFragment = isFragment;
/**
 * Convert fragment representing node to FragmentDeclaration instance.
 */
function asFragment(node) {
    return exports.api10.asFragment(node);
}
exports.asFragment = asFragment;
/**
 * High-level AST interfaces.
 */
exports.hl = require("./raml1/highLevelAST");
/**
 * Low-level AST interfaces.
 */
exports.ll = require("./raml1/lowLevelAST");
/**
 * Search functionality, operates on high AST level.
 */
exports.search = require("./searchProxy");
/**
 * High-level stub node factory methods.
 */
exports.stubs = require("./stubProxy");
exports.utils = require("./utils");
/**
 * Low-level project factory.
 */
exports.project = require("./project");
/**
 * Helpers for classification of high-level AST entity types.
 */
exports.universeHelpers = require("./raml1/tools/universeHelpers");
/**
 * Definition system.
 */
exports.ds = require("raml-definition-system");
/**
 * Schema utilities.
 */
exports.schema = require("./schema");
/**
 * A set of constants describing definition system entities.
 * @hidden
 **/
exports.universes = exports.ds.universesInfo;
/**
 * Exposed parser model modification methods. Operate on high-level.
 */
exports.parser = require("./parser");
/**
 * Applies traits and resources types to API on high-level.
 * Top-level expansion should be performed via calling expand() method of API node.
 */
exports.expander = require("./expanderStub");
/**
 * Exposed part of custom methods applied to top-level AST during generation.
 * Not to be used by parser clients.
 */
exports.wrapperHelper = require("./wrapperHelperStub");
if (typeof Promise === 'undefined' && typeof window !== 'undefined') {
    window.Promise = PromiseConstructor;
}
//# sourceMappingURL=index.js.map