"use strict";
var parser10impl = require("./raml1/artifacts/raml10parser");
var defSys = require("raml-definition-system");
var jsyaml = require("./raml1/jsyaml/jsyaml2lowLevel");
var ll = require("./raml1/lowLevelAST");
function createTypeDeclaration(typeName) {
    return new parser10impl.TypeDeclarationImpl(typeName);
}
exports.createTypeDeclaration = createTypeDeclaration;
function createObjectTypeDeclaration(typeName) {
    return new parser10impl.ObjectTypeDeclarationImpl(typeName);
}
exports.createObjectTypeDeclaration = createObjectTypeDeclaration;
//TODO it would be probably better to generate modification interface too
function setTypeDeclarationSchema(type, schema) {
    type.setSchema(schema);
}
exports.setTypeDeclarationSchema = setTypeDeclarationSchema;
function setTypeDeclarationExample(type, example) {
    var exampleSpecType = defSys.getUniverse("RAML10").type(defSys.universesInfo.Universe10.ExampleSpec.name);
    var examplePropName = defSys.universesInfo.Universe10.TypeDeclaration.properties.example.name;
    var hlParent = type.highLevel();
    var llParent = hlParent.lowLevel();
    var exampleNodes = hlParent.children().filter(function (x) { return x.lowLevel().key() == examplePropName; });
    var llNode = jsyaml.createNode(examplePropName);
    ll.setAttr(llNode, example);
    if (exampleNodes.length > 0) {
        ll.removeNode(llParent, exampleNodes[0].lowLevel());
        exampleNodes[0]._node = llNode;
        ll.insertNode(llParent, llNode);
    }
    hlParent.createAttr && hlParent.createAttr(examplePropName, example);
}
exports.setTypeDeclarationExample = setTypeDeclarationExample;
function addChild(parent, child) {
    parent.add(child);
}
exports.addChild = addChild;
//# sourceMappingURL=parserMod.js.map