"use strict";
/**
 * Custom type guard for Api. Returns true if node is instance of Api. Returns false otherwise.
 * Also returns false for super interfaces of Api.
 */
function isApi(node) {
    return node.kind() == "Api" && node.RAMLVersion() == "RAML08";
}
exports.isApi = isApi;
/**
 * Custom type guard for FullUriTemplateString. Returns true if node is instance of FullUriTemplateString. Returns false otherwise.
 * Also returns false for super interfaces of FullUriTemplateString.
 */
function isFullUriTemplateString(node) {
    return node.kind() == "FullUriTemplateString" && node.RAMLVersion() == "RAML08";
}
exports.isFullUriTemplateString = isFullUriTemplateString;
/**
 * Custom type guard for UriTemplate. Returns true if node is instance of UriTemplate. Returns false otherwise.
 * Also returns false for super interfaces of UriTemplate.
 */
function isUriTemplate(node) {
    return node.kind() == "UriTemplate" && node.RAMLVersion() == "RAML08";
}
exports.isUriTemplate = isUriTemplate;
/**
 * Custom type guard for StringType. Returns true if node is instance of StringType. Returns false otherwise.
 * Also returns false for super interfaces of StringType.
 */
function isStringType(node) {
    return node.kind() == "StringType" && node.RAMLVersion() == "RAML08";
}
exports.isStringType = isStringType;
/**
 * Custom type guard for ValueType. Returns true if node is instance of ValueType. Returns false otherwise.
 * Also returns false for super interfaces of ValueType.
 */
function isValueType(node) {
    return node.kind() == "ValueType" && node.RAMLVersion() == "RAML08";
}
exports.isValueType = isValueType;
/**
 * Custom type guard for AnyType. Returns true if node is instance of AnyType. Returns false otherwise.
 * Also returns false for super interfaces of AnyType.
 */
function isAnyType(node) {
    return node.kind() == "AnyType" && node.RAMLVersion() == "RAML08";
}
exports.isAnyType = isAnyType;
/**
 * Custom type guard for NumberType. Returns true if node is instance of NumberType. Returns false otherwise.
 * Also returns false for super interfaces of NumberType.
 */
function isNumberType(node) {
    return node.kind() == "NumberType" && node.RAMLVersion() == "RAML08";
}
exports.isNumberType = isNumberType;
/**
 * Custom type guard for BooleanType. Returns true if node is instance of BooleanType. Returns false otherwise.
 * Also returns false for super interfaces of BooleanType.
 */
function isBooleanType(node) {
    return node.kind() == "BooleanType" && node.RAMLVersion() == "RAML08";
}
exports.isBooleanType = isBooleanType;
/**
 * Custom type guard for Reference. Returns true if node is instance of Reference. Returns false otherwise.
 * Also returns false for super interfaces of Reference.
 */
function isReference(node) {
    return node.kind() == "Reference" && node.RAMLVersion() == "RAML08";
}
exports.isReference = isReference;
/**
 * Custom type guard for ResourceTypeRef. Returns true if node is instance of ResourceTypeRef. Returns false otherwise.
 * Also returns false for super interfaces of ResourceTypeRef.
 */
function isResourceTypeRef(node) {
    return node.kind() == "ResourceTypeRef" && node.RAMLVersion() == "RAML08";
}
exports.isResourceTypeRef = isResourceTypeRef;
/**
 * Custom type guard for ResourceType. Returns true if node is instance of ResourceType. Returns false otherwise.
 * Also returns false for super interfaces of ResourceType.
 */
function isResourceType(node) {
    return node.kind() == "ResourceType" && node.RAMLVersion() == "RAML08";
}
exports.isResourceType = isResourceType;
/**
 * Custom type guard for Method. Returns true if node is instance of Method. Returns false otherwise.
 * Also returns false for super interfaces of Method.
 */
function isMethod(node) {
    return node.kind() == "Method" && node.RAMLVersion() == "RAML08";
}
exports.isMethod = isMethod;
/**
 * Custom type guard for MethodBase. Returns true if node is instance of MethodBase. Returns false otherwise.
 * Also returns false for super interfaces of MethodBase.
 */
function isMethodBase(node) {
    return node.kind() == "MethodBase" && node.RAMLVersion() == "RAML08";
}
exports.isMethodBase = isMethodBase;
/**
 * Custom type guard for Response. Returns true if node is instance of Response. Returns false otherwise.
 * Also returns false for super interfaces of Response.
 */
function isResponse(node) {
    return node.kind() == "Response" && node.RAMLVersion() == "RAML08";
}
exports.isResponse = isResponse;
/**
 * Custom type guard for StatusCodeString. Returns true if node is instance of StatusCodeString. Returns false otherwise.
 * Also returns false for super interfaces of StatusCodeString.
 */
function isStatusCodeString(node) {
    return node.kind() == "StatusCodeString" && node.RAMLVersion() == "RAML08";
}
exports.isStatusCodeString = isStatusCodeString;
/**
 * Custom type guard for Parameter. Returns true if node is instance of Parameter. Returns false otherwise.
 * Also returns false for super interfaces of Parameter.
 */
function isParameter(node) {
    return node.kind() == "Parameter" && node.RAMLVersion() == "RAML08";
}
exports.isParameter = isParameter;
/**
 * Custom type guard for ParameterLocation. Returns true if node is instance of ParameterLocation. Returns false otherwise.
 * Also returns false for super interfaces of ParameterLocation.
 */
function isParameterLocation(node) {
    return node.kind() == "ParameterLocation" && node.RAMLVersion() == "RAML08";
}
exports.isParameterLocation = isParameterLocation;
/**
 * Custom type guard for MarkdownString. Returns true if node is instance of MarkdownString. Returns false otherwise.
 * Also returns false for super interfaces of MarkdownString.
 */
function isMarkdownString(node) {
    return node.kind() == "MarkdownString" && node.RAMLVersion() == "RAML08";
}
exports.isMarkdownString = isMarkdownString;
/**
 * Custom type guard for StringTypeDeclaration. Returns true if node is instance of StringTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of StringTypeDeclaration.
 */
function isStringTypeDeclaration(node) {
    return node.kind() == "StringTypeDeclaration" && node.RAMLVersion() == "RAML08";
}
exports.isStringTypeDeclaration = isStringTypeDeclaration;
/**
 * Custom type guard for BooleanTypeDeclaration. Returns true if node is instance of BooleanTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of BooleanTypeDeclaration.
 */
function isBooleanTypeDeclaration(node) {
    return node.kind() == "BooleanTypeDeclaration" && node.RAMLVersion() == "RAML08";
}
exports.isBooleanTypeDeclaration = isBooleanTypeDeclaration;
/**
 * Custom type guard for NumberTypeDeclaration. Returns true if node is instance of NumberTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of NumberTypeDeclaration.
 */
function isNumberTypeDeclaration(node) {
    return node.kind() == "NumberTypeDeclaration" && node.RAMLVersion() == "RAML08";
}
exports.isNumberTypeDeclaration = isNumberTypeDeclaration;
/**
 * Custom type guard for IntegerTypeDeclaration. Returns true if node is instance of IntegerTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of IntegerTypeDeclaration.
 */
function isIntegerTypeDeclaration(node) {
    return node.kind() == "IntegerTypeDeclaration" && node.RAMLVersion() == "RAML08";
}
exports.isIntegerTypeDeclaration = isIntegerTypeDeclaration;
/**
 * Custom type guard for DateTypeDeclaration. Returns true if node is instance of DateTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of DateTypeDeclaration.
 */
function isDateTypeDeclaration(node) {
    return node.kind() == "DateTypeDeclaration" && node.RAMLVersion() == "RAML08";
}
exports.isDateTypeDeclaration = isDateTypeDeclaration;
/**
 * Custom type guard for FileTypeDeclaration. Returns true if node is instance of FileTypeDeclaration. Returns false otherwise.
 * Also returns false for super interfaces of FileTypeDeclaration.
 */
function isFileTypeDeclaration(node) {
    return node.kind() == "FileTypeDeclaration" && node.RAMLVersion() == "RAML08";
}
exports.isFileTypeDeclaration = isFileTypeDeclaration;
/**
 * Custom type guard for BodyLike. Returns true if node is instance of BodyLike. Returns false otherwise.
 * Also returns false for super interfaces of BodyLike.
 */
function isBodyLike(node) {
    return node.kind() == "BodyLike" && node.RAMLVersion() == "RAML08";
}
exports.isBodyLike = isBodyLike;
/**
 * Custom type guard for SchemaString. Returns true if node is instance of SchemaString. Returns false otherwise.
 * Also returns false for super interfaces of SchemaString.
 */
function isSchemaString(node) {
    return node.kind() == "SchemaString" && node.RAMLVersion() == "RAML08";
}
exports.isSchemaString = isSchemaString;
/**
 * Custom type guard for JSonSchemaString. Returns true if node is instance of JSonSchemaString. Returns false otherwise.
 * Also returns false for super interfaces of JSonSchemaString.
 */
function isJSonSchemaString(node) {
    return node.kind() == "JSonSchemaString" && node.RAMLVersion() == "RAML08";
}
exports.isJSonSchemaString = isJSonSchemaString;
/**
 * Custom type guard for XMLSchemaString. Returns true if node is instance of XMLSchemaString. Returns false otherwise.
 * Also returns false for super interfaces of XMLSchemaString.
 */
function isXMLSchemaString(node) {
    return node.kind() == "XMLSchemaString" && node.RAMLVersion() == "RAML08";
}
exports.isXMLSchemaString = isXMLSchemaString;
/**
 * Custom type guard for ExampleString. Returns true if node is instance of ExampleString. Returns false otherwise.
 * Also returns false for super interfaces of ExampleString.
 */
function isExampleString(node) {
    return node.kind() == "ExampleString" && node.RAMLVersion() == "RAML08";
}
exports.isExampleString = isExampleString;
/**
 * Custom type guard for JSONExample. Returns true if node is instance of JSONExample. Returns false otherwise.
 * Also returns false for super interfaces of JSONExample.
 */
function isJSONExample(node) {
    return node.kind() == "JSONExample" && node.RAMLVersion() == "RAML08";
}
exports.isJSONExample = isJSONExample;
/**
 * Custom type guard for XMLExample. Returns true if node is instance of XMLExample. Returns false otherwise.
 * Also returns false for super interfaces of XMLExample.
 */
function isXMLExample(node) {
    return node.kind() == "XMLExample" && node.RAMLVersion() == "RAML08";
}
exports.isXMLExample = isXMLExample;
/**
 * Custom type guard for XMLBody. Returns true if node is instance of XMLBody. Returns false otherwise.
 * Also returns false for super interfaces of XMLBody.
 */
function isXMLBody(node) {
    return node.kind() == "XMLBody" && node.RAMLVersion() == "RAML08";
}
exports.isXMLBody = isXMLBody;
/**
 * Custom type guard for JSONBody. Returns true if node is instance of JSONBody. Returns false otherwise.
 * Also returns false for super interfaces of JSONBody.
 */
function isJSONBody(node) {
    return node.kind() == "JSONBody" && node.RAMLVersion() == "RAML08";
}
exports.isJSONBody = isJSONBody;
/**
 * Custom type guard for SecuritySchemeRef. Returns true if node is instance of SecuritySchemeRef. Returns false otherwise.
 * Also returns false for super interfaces of SecuritySchemeRef.
 */
function isSecuritySchemeRef(node) {
    return node.kind() == "SecuritySchemeRef" && node.RAMLVersion() == "RAML08";
}
exports.isSecuritySchemeRef = isSecuritySchemeRef;
/**
 * Custom type guard for AbstractSecurityScheme. Returns true if node is instance of AbstractSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of AbstractSecurityScheme.
 */
function isAbstractSecurityScheme(node) {
    return node.kind() == "AbstractSecurityScheme" && node.RAMLVersion() == "RAML08";
}
exports.isAbstractSecurityScheme = isAbstractSecurityScheme;
/**
 * Custom type guard for SecuritySchemePart. Returns true if node is instance of SecuritySchemePart. Returns false otherwise.
 * Also returns false for super interfaces of SecuritySchemePart.
 */
function isSecuritySchemePart(node) {
    return node.kind() == "SecuritySchemePart" && node.RAMLVersion() == "RAML08";
}
exports.isSecuritySchemePart = isSecuritySchemePart;
/**
 * Custom type guard for TraitRef. Returns true if node is instance of TraitRef. Returns false otherwise.
 * Also returns false for super interfaces of TraitRef.
 */
function isTraitRef(node) {
    return node.kind() == "TraitRef" && node.RAMLVersion() == "RAML08";
}
exports.isTraitRef = isTraitRef;
/**
 * Custom type guard for Trait. Returns true if node is instance of Trait. Returns false otherwise.
 * Also returns false for super interfaces of Trait.
 */
function isTrait(node) {
    return node.kind() == "Trait" && node.RAMLVersion() == "RAML08";
}
exports.isTrait = isTrait;
/**
 * Custom type guard for SecuritySchemeSettings. Returns true if node is instance of SecuritySchemeSettings. Returns false otherwise.
 * Also returns false for super interfaces of SecuritySchemeSettings.
 */
function isSecuritySchemeSettings(node) {
    return node.kind() == "SecuritySchemeSettings" && node.RAMLVersion() == "RAML08";
}
exports.isSecuritySchemeSettings = isSecuritySchemeSettings;
/**
 * Custom type guard for OAuth1SecuritySchemeSettings. Returns true if node is instance of OAuth1SecuritySchemeSettings. Returns false otherwise.
 * Also returns false for super interfaces of OAuth1SecuritySchemeSettings.
 */
function isOAuth1SecuritySchemeSettings(node) {
    return node.kind() == "OAuth1SecuritySchemeSettings" && node.RAMLVersion() == "RAML08";
}
exports.isOAuth1SecuritySchemeSettings = isOAuth1SecuritySchemeSettings;
/**
 * Custom type guard for FixedUri. Returns true if node is instance of FixedUri. Returns false otherwise.
 * Also returns false for super interfaces of FixedUri.
 */
function isFixedUri(node) {
    return node.kind() == "FixedUri" && node.RAMLVersion() == "RAML08";
}
exports.isFixedUri = isFixedUri;
/**
 * Custom type guard for OAuth2SecuritySchemeSettings. Returns true if node is instance of OAuth2SecuritySchemeSettings. Returns false otherwise.
 * Also returns false for super interfaces of OAuth2SecuritySchemeSettings.
 */
function isOAuth2SecuritySchemeSettings(node) {
    return node.kind() == "OAuth2SecuritySchemeSettings" && node.RAMLVersion() == "RAML08";
}
exports.isOAuth2SecuritySchemeSettings = isOAuth2SecuritySchemeSettings;
/**
 * Custom type guard for OAuth2SecurityScheme. Returns true if node is instance of OAuth2SecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of OAuth2SecurityScheme.
 */
function isOAuth2SecurityScheme(node) {
    return node.kind() == "OAuth2SecurityScheme" && node.RAMLVersion() == "RAML08";
}
exports.isOAuth2SecurityScheme = isOAuth2SecurityScheme;
/**
 * Custom type guard for OAuth1SecurityScheme. Returns true if node is instance of OAuth1SecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of OAuth1SecurityScheme.
 */
function isOAuth1SecurityScheme(node) {
    return node.kind() == "OAuth1SecurityScheme" && node.RAMLVersion() == "RAML08";
}
exports.isOAuth1SecurityScheme = isOAuth1SecurityScheme;
/**
 * Custom type guard for BasicSecurityScheme. Returns true if node is instance of BasicSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of BasicSecurityScheme.
 */
function isBasicSecurityScheme(node) {
    return node.kind() == "BasicSecurityScheme" && node.RAMLVersion() == "RAML08";
}
exports.isBasicSecurityScheme = isBasicSecurityScheme;
/**
 * Custom type guard for DigestSecurityScheme. Returns true if node is instance of DigestSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of DigestSecurityScheme.
 */
function isDigestSecurityScheme(node) {
    return node.kind() == "DigestSecurityScheme" && node.RAMLVersion() == "RAML08";
}
exports.isDigestSecurityScheme = isDigestSecurityScheme;
/**
 * Custom type guard for CustomSecurityScheme. Returns true if node is instance of CustomSecurityScheme. Returns false otherwise.
 * Also returns false for super interfaces of CustomSecurityScheme.
 */
function isCustomSecurityScheme(node) {
    return node.kind() == "CustomSecurityScheme" && node.RAMLVersion() == "RAML08";
}
exports.isCustomSecurityScheme = isCustomSecurityScheme;
/**
 * Custom type guard for MimeType. Returns true if node is instance of MimeType. Returns false otherwise.
 * Also returns false for super interfaces of MimeType.
 */
function isMimeType(node) {
    return node.kind() == "MimeType" && node.RAMLVersion() == "RAML08";
}
exports.isMimeType = isMimeType;
/**
 * Custom type guard for RelativeUriString. Returns true if node is instance of RelativeUriString. Returns false otherwise.
 * Also returns false for super interfaces of RelativeUriString.
 */
function isRelativeUriString(node) {
    return node.kind() == "RelativeUriString" && node.RAMLVersion() == "RAML08";
}
exports.isRelativeUriString = isRelativeUriString;
/**
 * Custom type guard for GlobalSchema. Returns true if node is instance of GlobalSchema. Returns false otherwise.
 * Also returns false for super interfaces of GlobalSchema.
 */
function isGlobalSchema(node) {
    return node.kind() == "GlobalSchema" && node.RAMLVersion() == "RAML08";
}
exports.isGlobalSchema = isGlobalSchema;
/**
 * Custom type guard for RAMLSimpleElement. Returns true if node is instance of RAMLSimpleElement. Returns false otherwise.
 * Also returns false for super interfaces of RAMLSimpleElement.
 */
function isRAMLSimpleElement(node) {
    return node.kind() == "RAMLSimpleElement" && node.RAMLVersion() == "RAML08";
}
exports.isRAMLSimpleElement = isRAMLSimpleElement;
/**
 * Custom type guard for DocumentationItem. Returns true if node is instance of DocumentationItem. Returns false otherwise.
 * Also returns false for super interfaces of DocumentationItem.
 */
function isDocumentationItem(node) {
    return node.kind() == "DocumentationItem" && node.RAMLVersion() == "RAML08";
}
exports.isDocumentationItem = isDocumentationItem;
/**
 * Custom type guard for Resource. Returns true if node is instance of Resource. Returns false otherwise.
 * Also returns false for super interfaces of Resource.
 */
function isResource(node) {
    return node.kind() == "Resource" && node.RAMLVersion() == "RAML08";
}
exports.isResource = isResource;
//# sourceMappingURL=raml08parserapi.js.map