/**
 * <p>See <a href="http://raml.org">http://raml.org</a> for more information about RAML.</p>
 *
 * <p>This parser is at a beta state of development, as part of the API Workbench development cycle (<a href="http://apiworkbench.com">http://apiworkbench.com</a>).</p>
 *
 * <p><a href="https://github.com/raml-org/raml-js-parser-2/blob/master/documentation/GettingStarted.md">Getting Started Guide</a> describes the first steps with the parser.</p>
 *
 * <h2>Installation</h2>
 *
 * <pre><code>git clone https://github.com/raml-org/raml-js-parser-2
 *
 * cd raml-js-parser-2
 *
 * npm install
 *
 * node test/test.js  //here you should observe JSON representation of XKCD API in your console
 *
 * node test/testAsync.js  //same as above but in asynchronous mode
 * </code></pre>
 *
 * <h2>Usage</h2>
 *
 * <ul>
 * <li>For parser usage example refer to <code>test/test.js</code></li>
 * <li>For asynchrounous usage example refer to <code>test/testAsync.js</code></li>
 * </ul>
 **/
"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var stubs = require("../../raml1/stubs");
var def = require("raml-definition-system");
var core = require("../../raml1/wrapped-ast/parserCore");
var apiLoader = require("../../raml1/apiLoader");
var helper = require("../../raml1/wrapped-ast/wrapperHelper");
var AnnotableImpl = (function (_super) {
    __extends(AnnotableImpl, _super);
    function AnnotableImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    AnnotableImpl.prototype.annotations = function () {
        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    AnnotableImpl.prototype.wrapperClassName = function () { return "AnnotableImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    AnnotableImpl.prototype.kind = function () { return "Annotable"; };
    /**
     * @return RAML version of the node
     **/
    AnnotableImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    AnnotableImpl.prototype.scalarsAnnotations = function () { return new AnnotableScalarsAnnotationsImpl(this.highLevel()); };
    return AnnotableImpl;
}(core.BasicNodeImpl));
exports.AnnotableImpl = AnnotableImpl;
var ValueTypeImpl = (function (_super) {
    __extends(ValueTypeImpl, _super);
    function ValueTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ValueTypeImpl.prototype.wrapperClassName = function () { return "ValueTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ValueTypeImpl.prototype.kind = function () { return "ValueType"; };
    /**
     * @return RAML version of the node
     **/
    ValueTypeImpl.prototype.RAMLVersion = function () { return "undefined"; };
    /**
     * @return JS representation of the node value
     **/
    ValueTypeImpl.prototype.value = function () { return this.attr.value(); };
    return ValueTypeImpl;
}(core.AttributeNodeImpl));
exports.ValueTypeImpl = ValueTypeImpl;
var StringTypeImpl = (function (_super) {
    __extends(StringTypeImpl, _super);
    function StringTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    StringTypeImpl.prototype.wrapperClassName = function () { return "StringTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    StringTypeImpl.prototype.kind = function () { return "StringType"; };
    /**
     * @return RAML version of the node
     **/
    StringTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * @return String representation of the node value
     **/
    StringTypeImpl.prototype.value = function () { return this.attr.value(); };
    return StringTypeImpl;
}(ValueTypeImpl));
exports.StringTypeImpl = StringTypeImpl;
/**
 * This type currently serves both for absolute and relative urls
 **/
var UriTemplateImpl = (function (_super) {
    __extends(UriTemplateImpl, _super);
    function UriTemplateImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    UriTemplateImpl.prototype.wrapperClassName = function () { return "UriTemplateImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    UriTemplateImpl.prototype.kind = function () { return "UriTemplate"; };
    /**
     * @return RAML version of the node
     **/
    UriTemplateImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return UriTemplateImpl;
}(StringTypeImpl));
exports.UriTemplateImpl = UriTemplateImpl;
/**
 * This  type describes relative uri templates
 **/
var RelativeUriStringImpl = (function (_super) {
    __extends(RelativeUriStringImpl, _super);
    function RelativeUriStringImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    RelativeUriStringImpl.prototype.wrapperClassName = function () { return "RelativeUriStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    RelativeUriStringImpl.prototype.kind = function () { return "RelativeUriString"; };
    /**
     * @return RAML version of the node
     **/
    RelativeUriStringImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return RelativeUriStringImpl;
}(UriTemplateImpl));
exports.RelativeUriStringImpl = RelativeUriStringImpl;
/**
 * This  type describes absolute uri templates
 **/
var FullUriTemplateStringImpl = (function (_super) {
    __extends(FullUriTemplateStringImpl, _super);
    function FullUriTemplateStringImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FullUriTemplateStringImpl.prototype.wrapperClassName = function () { return "FullUriTemplateStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FullUriTemplateStringImpl.prototype.kind = function () { return "FullUriTemplateString"; };
    /**
     * @return RAML version of the node
     **/
    FullUriTemplateStringImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return FullUriTemplateStringImpl;
}(UriTemplateImpl));
exports.FullUriTemplateStringImpl = FullUriTemplateStringImpl;
var StatusCodeStringImpl = (function (_super) {
    __extends(StatusCodeStringImpl, _super);
    function StatusCodeStringImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    StatusCodeStringImpl.prototype.wrapperClassName = function () { return "StatusCodeStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    StatusCodeStringImpl.prototype.kind = function () { return "StatusCodeString"; };
    /**
     * @return RAML version of the node
     **/
    StatusCodeStringImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return StatusCodeStringImpl;
}(StringTypeImpl));
exports.StatusCodeStringImpl = StatusCodeStringImpl;
/**
 * This  type describes fixed uris
 **/
var FixedUriStringImpl = (function (_super) {
    __extends(FixedUriStringImpl, _super);
    function FixedUriStringImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FixedUriStringImpl.prototype.wrapperClassName = function () { return "FixedUriStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FixedUriStringImpl.prototype.kind = function () { return "FixedUriString"; };
    /**
     * @return RAML version of the node
     **/
    FixedUriStringImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return FixedUriStringImpl;
}(StringTypeImpl));
exports.FixedUriStringImpl = FixedUriStringImpl;
var ContentTypeImpl = (function (_super) {
    __extends(ContentTypeImpl, _super);
    function ContentTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ContentTypeImpl.prototype.wrapperClassName = function () { return "ContentTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ContentTypeImpl.prototype.kind = function () { return "ContentType"; };
    /**
     * @return RAML version of the node
     **/
    ContentTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return ContentTypeImpl;
}(StringTypeImpl));
exports.ContentTypeImpl = ContentTypeImpl;
/**
 * [GitHub Flavored Markdown](https://help.github.com/articles/github-flavored-markdown/)
 **/
var MarkdownStringImpl = (function (_super) {
    __extends(MarkdownStringImpl, _super);
    function MarkdownStringImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MarkdownStringImpl.prototype.wrapperClassName = function () { return "MarkdownStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MarkdownStringImpl.prototype.kind = function () { return "MarkdownString"; };
    /**
     * @return RAML version of the node
     **/
    MarkdownStringImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return MarkdownStringImpl;
}(StringTypeImpl));
exports.MarkdownStringImpl = MarkdownStringImpl;
/**
 * Schema at this moment only two subtypes are supported (json schema and xsd)
 **/
var SchemaStringImpl = (function (_super) {
    __extends(SchemaStringImpl, _super);
    function SchemaStringImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SchemaStringImpl.prototype.wrapperClassName = function () { return "SchemaStringImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SchemaStringImpl.prototype.kind = function () { return "SchemaString"; };
    /**
     * @return RAML version of the node
     **/
    SchemaStringImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return SchemaStringImpl;
}(StringTypeImpl));
exports.SchemaStringImpl = SchemaStringImpl;
/**
 * This sub type of the string represents mime types
 **/
var MimeTypeImpl = (function (_super) {
    __extends(MimeTypeImpl, _super);
    function MimeTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MimeTypeImpl.prototype.wrapperClassName = function () { return "MimeTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MimeTypeImpl.prototype.kind = function () { return "MimeType"; };
    /**
     * @return RAML version of the node
     **/
    MimeTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return MimeTypeImpl;
}(StringTypeImpl));
exports.MimeTypeImpl = MimeTypeImpl;
var AnyTypeImpl = (function (_super) {
    __extends(AnyTypeImpl, _super);
    function AnyTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    AnyTypeImpl.prototype.wrapperClassName = function () { return "AnyTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    AnyTypeImpl.prototype.kind = function () { return "AnyType"; };
    /**
     * @return RAML version of the node
     **/
    AnyTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return AnyTypeImpl;
}(ValueTypeImpl));
exports.AnyTypeImpl = AnyTypeImpl;
var NumberTypeImpl = (function (_super) {
    __extends(NumberTypeImpl, _super);
    function NumberTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    NumberTypeImpl.prototype.wrapperClassName = function () { return "NumberTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    NumberTypeImpl.prototype.kind = function () { return "NumberType"; };
    /**
     * @return RAML version of the node
     **/
    NumberTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * @return Number representation of the node value
     **/
    NumberTypeImpl.prototype.value = function () { return this.attr.value(); };
    return NumberTypeImpl;
}(ValueTypeImpl));
exports.NumberTypeImpl = NumberTypeImpl;
var IntegerTypeImpl = (function (_super) {
    __extends(IntegerTypeImpl, _super);
    function IntegerTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    IntegerTypeImpl.prototype.wrapperClassName = function () { return "IntegerTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    IntegerTypeImpl.prototype.kind = function () { return "IntegerType"; };
    /**
     * @return RAML version of the node
     **/
    IntegerTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return IntegerTypeImpl;
}(ValueTypeImpl));
exports.IntegerTypeImpl = IntegerTypeImpl;
var NullTypeImpl = (function (_super) {
    __extends(NullTypeImpl, _super);
    function NullTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    NullTypeImpl.prototype.wrapperClassName = function () { return "NullTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    NullTypeImpl.prototype.kind = function () { return "NullType"; };
    /**
     * @return RAML version of the node
     **/
    NullTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return NullTypeImpl;
}(ValueTypeImpl));
exports.NullTypeImpl = NullTypeImpl;
var TimeOnlyTypeImpl = (function (_super) {
    __extends(TimeOnlyTypeImpl, _super);
    function TimeOnlyTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    TimeOnlyTypeImpl.prototype.wrapperClassName = function () { return "TimeOnlyTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    TimeOnlyTypeImpl.prototype.kind = function () { return "TimeOnlyType"; };
    /**
     * @return RAML version of the node
     **/
    TimeOnlyTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return TimeOnlyTypeImpl;
}(ValueTypeImpl));
exports.TimeOnlyTypeImpl = TimeOnlyTypeImpl;
var DateOnlyTypeImpl = (function (_super) {
    __extends(DateOnlyTypeImpl, _super);
    function DateOnlyTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DateOnlyTypeImpl.prototype.wrapperClassName = function () { return "DateOnlyTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DateOnlyTypeImpl.prototype.kind = function () { return "DateOnlyType"; };
    /**
     * @return RAML version of the node
     **/
    DateOnlyTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return DateOnlyTypeImpl;
}(ValueTypeImpl));
exports.DateOnlyTypeImpl = DateOnlyTypeImpl;
var DateTimeOnlyTypeImpl = (function (_super) {
    __extends(DateTimeOnlyTypeImpl, _super);
    function DateTimeOnlyTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DateTimeOnlyTypeImpl.prototype.wrapperClassName = function () { return "DateTimeOnlyTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DateTimeOnlyTypeImpl.prototype.kind = function () { return "DateTimeOnlyType"; };
    /**
     * @return RAML version of the node
     **/
    DateTimeOnlyTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return DateTimeOnlyTypeImpl;
}(ValueTypeImpl));
exports.DateTimeOnlyTypeImpl = DateTimeOnlyTypeImpl;
var DateTimeTypeImpl = (function (_super) {
    __extends(DateTimeTypeImpl, _super);
    function DateTimeTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DateTimeTypeImpl.prototype.wrapperClassName = function () { return "DateTimeTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DateTimeTypeImpl.prototype.kind = function () { return "DateTimeType"; };
    /**
     * @return RAML version of the node
     **/
    DateTimeTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return DateTimeTypeImpl;
}(ValueTypeImpl));
exports.DateTimeTypeImpl = DateTimeTypeImpl;
var FileTypeImpl = (function (_super) {
    __extends(FileTypeImpl, _super);
    function FileTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FileTypeImpl.prototype.wrapperClassName = function () { return "FileTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FileTypeImpl.prototype.kind = function () { return "FileType"; };
    /**
     * @return RAML version of the node
     **/
    FileTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return FileTypeImpl;
}(ValueTypeImpl));
exports.FileTypeImpl = FileTypeImpl;
var BooleanTypeImpl = (function (_super) {
    __extends(BooleanTypeImpl, _super);
    function BooleanTypeImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    BooleanTypeImpl.prototype.wrapperClassName = function () { return "BooleanTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    BooleanTypeImpl.prototype.kind = function () { return "BooleanType"; };
    /**
     * @return RAML version of the node
     **/
    BooleanTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * @return Boolean representation of the node value
     **/
    BooleanTypeImpl.prototype.value = function () { return this.attr.value(); };
    return BooleanTypeImpl;
}(ValueTypeImpl));
exports.BooleanTypeImpl = BooleanTypeImpl;
/**
 * Elements to which this Annotation can be applied (enum)
 **/
var AnnotationTargetImpl = (function (_super) {
    __extends(AnnotationTargetImpl, _super);
    function AnnotationTargetImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    AnnotationTargetImpl.prototype.wrapperClassName = function () { return "AnnotationTargetImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    AnnotationTargetImpl.prototype.kind = function () { return "AnnotationTarget"; };
    /**
     * @return RAML version of the node
     **/
    AnnotationTargetImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return AnnotationTargetImpl;
}(ValueTypeImpl));
exports.AnnotationTargetImpl = AnnotationTargetImpl;
var ReferenceImpl = (function (_super) {
    __extends(ReferenceImpl, _super);
    function ReferenceImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ReferenceImpl.prototype.wrapperClassName = function () { return "ReferenceImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ReferenceImpl.prototype.kind = function () { return "Reference"; };
    /**
     * @return RAML version of the node
     **/
    ReferenceImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * @return StructuredValue object representing the node value
     **/
    ReferenceImpl.prototype.value = function () { return core.toStructuredValue(this.attr); };
    ReferenceImpl.prototype.structuredValue = function () {
        return helper.structuredValue(this);
    };
    ReferenceImpl.prototype.name = function () {
        return helper.referenceName(this);
    };
    return ReferenceImpl;
}(core.AttributeNodeImpl));
exports.ReferenceImpl = ReferenceImpl;
var TraitRefImpl = (function (_super) {
    __extends(TraitRefImpl, _super);
    function TraitRefImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    TraitRefImpl.prototype.wrapperClassName = function () { return "TraitRefImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    TraitRefImpl.prototype.kind = function () { return "TraitRef"; };
    /**
     * @return RAML version of the node
     **/
    TraitRefImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    TraitRefImpl.prototype.trait = function () {
        return helper.referencedTrait(this);
    };
    return TraitRefImpl;
}(ReferenceImpl));
exports.TraitRefImpl = TraitRefImpl;
var OperationImpl = (function (_super) {
    __extends(OperationImpl, _super);
    function OperationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createOperation(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * An APIs resources MAY be filtered (to return a subset of results) or altered (such as transforming  a response body from JSON to XML format) by the use of query strings. If the resource or its method supports a query string, the query string MUST be defined by the queryParameters property
     **/
    OperationImpl.prototype.queryParameters = function () {
        return _super.prototype.elements.call(this, 'queryParameters');
    };
    /**
     * Headers that allowed at this position
     **/
    OperationImpl.prototype.headers = function () {
        return _super.prototype.elements.call(this, 'headers');
    };
    /**
     * Specifies the query string needed by this method. Mutually exclusive with queryParameters.
     **/
    OperationImpl.prototype.queryString = function () {
        return _super.prototype.element.call(this, 'queryString');
    };
    /**
     * Information about the expected responses to a request
     **/
    OperationImpl.prototype.responses = function () {
        return _super.prototype.elements.call(this, 'responses');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OperationImpl.prototype.wrapperClassName = function () { return "OperationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OperationImpl.prototype.kind = function () { return "Operation"; };
    /**
     * @return RAML version of the node
     **/
    OperationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return OperationImpl;
}(AnnotableImpl));
exports.OperationImpl = OperationImpl;
var TypeDeclarationImpl = (function (_super) {
    __extends(TypeDeclarationImpl, _super);
    function TypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * name of the parameter
     **/
    TypeDeclarationImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    TypeDeclarationImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * The displayName attribute specifies the type display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    TypeDeclarationImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    TypeDeclarationImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * When extending from a type you can define new facets (which can then be set to concrete values by subtypes).
     **/
    TypeDeclarationImpl.prototype.facets = function () {
        return _super.prototype.elements.call(this, 'facets');
    };
    /**
     * Alias for the equivalent "type" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "type" property, as the "schema" alias for that property name may be removed in a future RAML version. The "type" property allows for XML and JSON schemas.
     * @hidden
     **/
    TypeDeclarationImpl.prototype.schema_original = function () {
        return _super.prototype.attributes.call(this, 'schema', this.toString);
    };
    /**
     * @hidden
     * Set schema value
     **/
    TypeDeclarationImpl.prototype.setSchema = function (param) {
        this.highLevel().attrOrCreate("schema").setValue("" + param);
        return this;
    };
    /**
     * A base type which the current type extends, or more generally a type expression.
     * @hidden
     **/
    TypeDeclarationImpl.prototype.type_original = function () {
        return _super.prototype.attributes.call(this, 'type', this.toString);
    };
    /**
     * @hidden
     * Set type value
     **/
    TypeDeclarationImpl.prototype.setType = function (param) {
        this.highLevel().attrOrCreate("type").setValue("" + param);
        return this;
    };
    /**
     * Location of the parameter (can not be edited by user)
     **/
    TypeDeclarationImpl.prototype.location = function () {
        return _super.prototype.attribute.call(this, 'location', function (attr) { return new ModelLocationImpl(attr); });
    };
    /**
     * Kind of location
     **/
    TypeDeclarationImpl.prototype.locationKind = function () {
        return _super.prototype.attribute.call(this, 'locationKind', function (attr) { return new LocationKindImpl(attr); });
    };
    /**
     * Provides default value for a property
     **/
    TypeDeclarationImpl.prototype["default"] = function () {
        return _super.prototype.attribute.call(this, 'default', this.toAny);
    };
    /**
     * @hidden
     * Set default value
     **/
    TypeDeclarationImpl.prototype.setDefault = function (param) {
        this.highLevel().attrOrCreate("default").setValue("" + param);
        return this;
    };
    /**
     * An example of this type instance represented as string or yaml map/sequence. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the examples property is present.
     * @hidden
     **/
    TypeDeclarationImpl.prototype.example_original = function () {
        return _super.prototype.element.call(this, 'example');
    };
    /**
     * An example of this type instance represented as string. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the example property is present.
     * @hidden
     **/
    TypeDeclarationImpl.prototype.examples_original = function () {
        return _super.prototype.elements.call(this, 'examples');
    };
    /**
     * Sets if property is optional or not
     **/
    TypeDeclarationImpl.prototype.required = function () {
        return _super.prototype.attribute.call(this, 'required', this.toBoolean);
    };
    /**
     * @hidden
     * Set required value
     **/
    TypeDeclarationImpl.prototype.setRequired = function (param) {
        this.highLevel().attrOrCreate("required").setValue("" + param);
        return this;
    };
    /**
     * A longer, human-friendly description of the type
     **/
    TypeDeclarationImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    TypeDeclarationImpl.prototype.xml = function () {
        return _super.prototype.element.call(this, 'xml');
    };
    /**
     * Restrictions on where annotations of this type can be applied. If this property is specified, annotations of this type may only be applied on a property corresponding to one of the target names specified as the value of this property.
     **/
    TypeDeclarationImpl.prototype.allowedTargets = function () {
        return _super.prototype.attributes.call(this, 'allowedTargets', function (attr) { return new AnnotationTargetImpl(attr); });
    };
    /**
     * Whether the type represents annotation
     **/
    TypeDeclarationImpl.prototype.isAnnotation = function () {
        return _super.prototype.attribute.call(this, 'isAnnotation', this.toBoolean);
    };
    /**
     * @hidden
     * Set isAnnotation value
     **/
    TypeDeclarationImpl.prototype.setIsAnnotation = function (param) {
        this.highLevel().attrOrCreate("isAnnotation").setValue("" + param);
        return this;
    };
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    TypeDeclarationImpl.prototype.annotations = function () {
        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
    };
    TypeDeclarationImpl.prototype.uses = function () {
        return _super.prototype.elements.call(this, 'uses');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    TypeDeclarationImpl.prototype.wrapperClassName = function () { return "TypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    TypeDeclarationImpl.prototype.kind = function () { return "TypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    TypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Runtime representation of type represented by this AST node
     **/
    TypeDeclarationImpl.prototype.runtimeType = function () {
        return helper.runtimeType(this);
    };
    /**
     * validate an instance against type
     **/
    TypeDeclarationImpl.prototype.validateInstance = function (value) {
        return helper.validateInstance(this, value);
    };
    /**
     * validate an instance against type
     **/
    TypeDeclarationImpl.prototype.validateInstanceWithDetailedStatuses = function (value) {
        return helper.validateInstanceWithDetailedStatuses(this, value);
    };
    /**
     * An example of this type instance represented as string or yaml map/sequence. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the examples property is present.
     **/
    TypeDeclarationImpl.prototype.example = function () {
        return helper.getTypeExample(this);
    };
    /**
     * An example of this type instance represented as string. This can be used, e.g., by documentation generators to generate sample values for an object of this type. Cannot be present if the example property is present.
     **/
    TypeDeclarationImpl.prototype.examples = function () {
        return helper.getTypeExamples(this);
    };
    TypeDeclarationImpl.prototype.fixedFacets = function () {
        return helper.typeFixedFacets(this);
    };
    /**
     * A base type which the current type extends, or more generally a type expression.
     **/
    TypeDeclarationImpl.prototype["type"] = function () {
        return helper.typeValue(this);
    };
    /**
     * Alias for the equivalent "type" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "type" property, as the "schema" alias for that property name may be removed in a future RAML version. The "type" property allows for XML and JSON schemas.
     **/
    TypeDeclarationImpl.prototype.schema = function () {
        return helper.schemaValue(this);
    };
    /**
     * Inlined supertype definition.
     **/
    TypeDeclarationImpl.prototype.structuredType = function () {
        return helper.typeStructuredValue(this);
    };
    TypeDeclarationImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    TypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new TypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return TypeDeclarationImpl;
}(AnnotableImpl));
exports.TypeDeclarationImpl = TypeDeclarationImpl;
var ModelLocationImpl = (function () {
    function ModelLocationImpl(attr) {
        this.attr = attr;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ModelLocationImpl.prototype.wrapperClassName = function () { return "ModelLocationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ModelLocationImpl.prototype.kind = function () { return "ModelLocation"; };
    /**
     * @return RAML version of the node
     **/
    ModelLocationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return ModelLocationImpl;
}());
exports.ModelLocationImpl = ModelLocationImpl;
var LocationKindImpl = (function () {
    function LocationKindImpl(attr) {
        this.attr = attr;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    LocationKindImpl.prototype.wrapperClassName = function () { return "LocationKindImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    LocationKindImpl.prototype.kind = function () { return "LocationKind"; };
    /**
     * @return RAML version of the node
     **/
    LocationKindImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return LocationKindImpl;
}());
exports.LocationKindImpl = LocationKindImpl;
var UsesDeclarationImpl = (function (_super) {
    __extends(UsesDeclarationImpl, _super);
    function UsesDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createUsesDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Name prefix (without dot) used to refer imported declarations
     **/
    UsesDeclarationImpl.prototype.key = function () {
        return _super.prototype.attribute.call(this, 'key', this.toString);
    };
    /**
     * @hidden
     * Set key value
     **/
    UsesDeclarationImpl.prototype.setKey = function (param) {
        this.highLevel().attrOrCreate("key").setValue("" + param);
        return this;
    };
    /**
     * Content of the schema
     **/
    UsesDeclarationImpl.prototype.value = function () {
        return _super.prototype.attribute.call(this, 'value', this.toString);
    };
    /**
     * @hidden
     * Set value value
     **/
    UsesDeclarationImpl.prototype.setValue = function (param) {
        this.highLevel().attrOrCreate("value").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    UsesDeclarationImpl.prototype.wrapperClassName = function () { return "UsesDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    UsesDeclarationImpl.prototype.kind = function () { return "UsesDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    UsesDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Returns the root node of the AST, uses statement refers.
     **/
    UsesDeclarationImpl.prototype.ast = function () {
        return helper.referencedNode(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    UsesDeclarationImpl.prototype.scalarsAnnotations = function () { return new UsesDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return UsesDeclarationImpl;
}(AnnotableImpl));
exports.UsesDeclarationImpl = UsesDeclarationImpl;
/**
 * Annotable scalar properties annotations accessor
 **/
var AnnotableScalarsAnnotationsImpl = (function () {
    function AnnotableScalarsAnnotationsImpl(node) {
        this.node = node;
    }
    /**
     * Annotable.annotations annotations
     **/
    AnnotableScalarsAnnotationsImpl.prototype.annotations = function () {
        var attrs = this.node.attributes("annotations");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return AnnotableScalarsAnnotationsImpl;
}());
exports.AnnotableScalarsAnnotationsImpl = AnnotableScalarsAnnotationsImpl;
/**
 * UsesDeclaration scalar properties annotations accessor
 **/
var UsesDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(UsesDeclarationScalarsAnnotationsImpl, _super);
    function UsesDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * UsesDeclaration.value annotations
     **/
    UsesDeclarationScalarsAnnotationsImpl.prototype.value = function () {
        var attr = this.node.attr("value");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return UsesDeclarationScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.UsesDeclarationScalarsAnnotationsImpl = UsesDeclarationScalarsAnnotationsImpl;
var XMLFacetInfoImpl = (function (_super) {
    __extends(XMLFacetInfoImpl, _super);
    function XMLFacetInfoImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createXMLFacetInfo(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * If attribute is set to true, a type instance should be serialized as an XML attribute. It can only be true for scalar types.
     **/
    XMLFacetInfoImpl.prototype.attribute = function () {
        return _super.prototype.attribute.call(this, 'attribute', this.toBoolean);
    };
    /**
     * @hidden
     * Set attribute value
     **/
    XMLFacetInfoImpl.prototype.setAttribute = function (param) {
        this.highLevel().attrOrCreate("attribute").setValue("" + param);
        return this;
    };
    /**
     * If wrapped is set to true, a type instance should be wrapped in its own XML element. It can not be true for scalar types and it can not be true at the same moment when attribute is true.
     **/
    XMLFacetInfoImpl.prototype.wrapped = function () {
        return _super.prototype.attribute.call(this, 'wrapped', this.toBoolean);
    };
    /**
     * @hidden
     * Set wrapped value
     **/
    XMLFacetInfoImpl.prototype.setWrapped = function (param) {
        this.highLevel().attrOrCreate("wrapped").setValue("" + param);
        return this;
    };
    /**
     * Allows to override the name of the XML element or XML attribute in it's XML representation.
     **/
    XMLFacetInfoImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    XMLFacetInfoImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * Allows to configure the name of the XML namespace.
     **/
    XMLFacetInfoImpl.prototype.namespace = function () {
        return _super.prototype.attribute.call(this, 'namespace', this.toString);
    };
    /**
     * @hidden
     * Set namespace value
     **/
    XMLFacetInfoImpl.prototype.setNamespace = function (param) {
        this.highLevel().attrOrCreate("namespace").setValue("" + param);
        return this;
    };
    /**
     * Allows to configure the prefix which will be used during serialization to XML.
     **/
    XMLFacetInfoImpl.prototype.prefix = function () {
        return _super.prototype.attribute.call(this, 'prefix', this.toString);
    };
    /**
     * @hidden
     * Set prefix value
     **/
    XMLFacetInfoImpl.prototype.setPrefix = function (param) {
        this.highLevel().attrOrCreate("prefix").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    XMLFacetInfoImpl.prototype.wrapperClassName = function () { return "XMLFacetInfoImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    XMLFacetInfoImpl.prototype.kind = function () { return "XMLFacetInfo"; };
    /**
     * @return RAML version of the node
     **/
    XMLFacetInfoImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    XMLFacetInfoImpl.prototype.scalarsAnnotations = function () { return new XMLFacetInfoScalarsAnnotationsImpl(this.highLevel()); };
    return XMLFacetInfoImpl;
}(AnnotableImpl));
exports.XMLFacetInfoImpl = XMLFacetInfoImpl;
/**
 * XMLFacetInfo scalar properties annotations accessor
 **/
var XMLFacetInfoScalarsAnnotationsImpl = (function (_super) {
    __extends(XMLFacetInfoScalarsAnnotationsImpl, _super);
    function XMLFacetInfoScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * XMLFacetInfo.attribute annotations
     **/
    XMLFacetInfoScalarsAnnotationsImpl.prototype.attribute = function () {
        var attr = this.node.attr("attribute");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * XMLFacetInfo.wrapped annotations
     **/
    XMLFacetInfoScalarsAnnotationsImpl.prototype.wrapped = function () {
        var attr = this.node.attr("wrapped");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * XMLFacetInfo.name annotations
     **/
    XMLFacetInfoScalarsAnnotationsImpl.prototype.name = function () {
        var attr = this.node.attr("name");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * XMLFacetInfo.namespace annotations
     **/
    XMLFacetInfoScalarsAnnotationsImpl.prototype.namespace = function () {
        var attr = this.node.attr("namespace");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * XMLFacetInfo.prefix annotations
     **/
    XMLFacetInfoScalarsAnnotationsImpl.prototype.prefix = function () {
        var attr = this.node.attr("prefix");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return XMLFacetInfoScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.XMLFacetInfoScalarsAnnotationsImpl = XMLFacetInfoScalarsAnnotationsImpl;
var ArrayTypeDeclarationImpl = (function (_super) {
    __extends(ArrayTypeDeclarationImpl, _super);
    function ArrayTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createArrayTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Should items in array be unique
     **/
    ArrayTypeDeclarationImpl.prototype.uniqueItems = function () {
        return _super.prototype.attribute.call(this, 'uniqueItems', this.toBoolean);
    };
    /**
     * @hidden
     * Set uniqueItems value
     **/
    ArrayTypeDeclarationImpl.prototype.setUniqueItems = function (param) {
        this.highLevel().attrOrCreate("uniqueItems").setValue("" + param);
        return this;
    };
    /**
     * Array component type.
     * @hidden
     **/
    ArrayTypeDeclarationImpl.prototype.items_original = function () {
        return _super.prototype.element.call(this, 'items');
    };
    /**
     * Minimum amount of items in array
     **/
    ArrayTypeDeclarationImpl.prototype.minItems = function () {
        return _super.prototype.attribute.call(this, 'minItems', this.toNumber);
    };
    /**
     * @hidden
     * Set minItems value
     **/
    ArrayTypeDeclarationImpl.prototype.setMinItems = function (param) {
        this.highLevel().attrOrCreate("minItems").setValue("" + param);
        return this;
    };
    /**
     * Maximum amount of items in array
     **/
    ArrayTypeDeclarationImpl.prototype.maxItems = function () {
        return _super.prototype.attribute.call(this, 'maxItems', this.toNumber);
    };
    /**
     * @hidden
     * Set maxItems value
     **/
    ArrayTypeDeclarationImpl.prototype.setMaxItems = function (param) {
        this.highLevel().attrOrCreate("maxItems").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ArrayTypeDeclarationImpl.prototype.wrapperClassName = function () { return "ArrayTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ArrayTypeDeclarationImpl.prototype.kind = function () { return "ArrayTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    ArrayTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Array component type.
     **/
    ArrayTypeDeclarationImpl.prototype.items = function () {
        return helper.getItems(this);
    };
    /**
     * Returns anonymous type defined by "items" keyword, or a component type if declaration can be found.
     * Does not resolve type expressions. Only returns component type declaration if it is actually defined
     * somewhere in AST.
     **/
    ArrayTypeDeclarationImpl.prototype.findComponentTypeDeclaration = function () {
        return helper.findComponentTypeDeclaration(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    ArrayTypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new ArrayTypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return ArrayTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.ArrayTypeDeclarationImpl = ArrayTypeDeclarationImpl;
/**
 * TypeDeclaration scalar properties annotations accessor
 **/
var TypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(TypeDeclarationScalarsAnnotationsImpl, _super);
    function TypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * TypeDeclaration.displayName annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.displayName = function () {
        var attr = this.node.attr("displayName");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * TypeDeclaration.schema annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.schema = function () {
        var attrs = this.node.attributes("schema");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * TypeDeclaration.type annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype["type"] = function () {
        var attrs = this.node.attributes("type");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * TypeDeclaration.location annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.location = function () {
        var attr = this.node.attr("location");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * TypeDeclaration.locationKind annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.locationKind = function () {
        var attr = this.node.attr("locationKind");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * TypeDeclaration.default annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype["default"] = function () {
        var attr = this.node.attr("default");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * TypeDeclaration.required annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.required = function () {
        var attr = this.node.attr("required");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * TypeDeclaration.description annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.description = function () {
        var attr = this.node.attr("description");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * TypeDeclaration.allowedTargets annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.allowedTargets = function () {
        var attrs = this.node.attributes("allowedTargets");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * TypeDeclaration.isAnnotation annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.isAnnotation = function () {
        var attr = this.node.attr("isAnnotation");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * TypeDeclaration.annotations annotations
     **/
    TypeDeclarationScalarsAnnotationsImpl.prototype.annotations = function () {
        var attrs = this.node.attributes("annotations");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return TypeDeclarationScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.TypeDeclarationScalarsAnnotationsImpl = TypeDeclarationScalarsAnnotationsImpl;
/**
 * ArrayTypeDeclaration scalar properties annotations accessor
 **/
var ArrayTypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(ArrayTypeDeclarationScalarsAnnotationsImpl, _super);
    function ArrayTypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * ArrayTypeDeclaration.uniqueItems annotations
     **/
    ArrayTypeDeclarationScalarsAnnotationsImpl.prototype.uniqueItems = function () {
        var attr = this.node.attr("uniqueItems");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ArrayTypeDeclaration.minItems annotations
     **/
    ArrayTypeDeclarationScalarsAnnotationsImpl.prototype.minItems = function () {
        var attr = this.node.attr("minItems");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ArrayTypeDeclaration.maxItems annotations
     **/
    ArrayTypeDeclarationScalarsAnnotationsImpl.prototype.maxItems = function () {
        var attr = this.node.attr("maxItems");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return ArrayTypeDeclarationScalarsAnnotationsImpl;
}(TypeDeclarationScalarsAnnotationsImpl));
exports.ArrayTypeDeclarationScalarsAnnotationsImpl = ArrayTypeDeclarationScalarsAnnotationsImpl;
var UnionTypeDeclarationImpl = (function (_super) {
    __extends(UnionTypeDeclarationImpl, _super);
    function UnionTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createUnionTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    UnionTypeDeclarationImpl.prototype.wrapperClassName = function () { return "UnionTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    UnionTypeDeclarationImpl.prototype.kind = function () { return "UnionTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    UnionTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return UnionTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.UnionTypeDeclarationImpl = UnionTypeDeclarationImpl;
var ObjectTypeDeclarationImpl = (function (_super) {
    __extends(ObjectTypeDeclarationImpl, _super);
    function ObjectTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createObjectTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * The properties that instances of this type may or must have.
     **/
    ObjectTypeDeclarationImpl.prototype.properties = function () {
        return _super.prototype.elements.call(this, 'properties');
    };
    /**
     * The minimum number of properties allowed for instances of this type.
     **/
    ObjectTypeDeclarationImpl.prototype.minProperties = function () {
        return _super.prototype.attribute.call(this, 'minProperties', this.toNumber);
    };
    /**
     * @hidden
     * Set minProperties value
     **/
    ObjectTypeDeclarationImpl.prototype.setMinProperties = function (param) {
        this.highLevel().attrOrCreate("minProperties").setValue("" + param);
        return this;
    };
    /**
     * The maximum number of properties allowed for instances of this type.
     **/
    ObjectTypeDeclarationImpl.prototype.maxProperties = function () {
        return _super.prototype.attribute.call(this, 'maxProperties', this.toNumber);
    };
    /**
     * @hidden
     * Set maxProperties value
     **/
    ObjectTypeDeclarationImpl.prototype.setMaxProperties = function (param) {
        this.highLevel().attrOrCreate("maxProperties").setValue("" + param);
        return this;
    };
    /**
     * A Boolean that indicates if an object instance has additional properties.
     **/
    ObjectTypeDeclarationImpl.prototype.additionalProperties = function () {
        return _super.prototype.attribute.call(this, 'additionalProperties', this.toBoolean);
    };
    /**
     * @hidden
     * Set additionalProperties value
     **/
    ObjectTypeDeclarationImpl.prototype.setAdditionalProperties = function (param) {
        this.highLevel().attrOrCreate("additionalProperties").setValue("" + param);
        return this;
    };
    /**
     * Type property name to be used as discriminator, or boolean
     **/
    ObjectTypeDeclarationImpl.prototype.discriminator = function () {
        return _super.prototype.attribute.call(this, 'discriminator', this.toString);
    };
    /**
     * @hidden
     * Set discriminator value
     **/
    ObjectTypeDeclarationImpl.prototype.setDiscriminator = function (param) {
        this.highLevel().attrOrCreate("discriminator").setValue("" + param);
        return this;
    };
    /**
     * The value of discriminator for the type.
     **/
    ObjectTypeDeclarationImpl.prototype.discriminatorValue = function () {
        return _super.prototype.attribute.call(this, 'discriminatorValue', this.toString);
    };
    /**
     * @hidden
     * Set discriminatorValue value
     **/
    ObjectTypeDeclarationImpl.prototype.setDiscriminatorValue = function (param) {
        this.highLevel().attrOrCreate("discriminatorValue").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ObjectTypeDeclarationImpl.prototype.wrapperClassName = function () { return "ObjectTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ObjectTypeDeclarationImpl.prototype.kind = function () { return "ObjectTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    ObjectTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    ObjectTypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new ObjectTypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return ObjectTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.ObjectTypeDeclarationImpl = ObjectTypeDeclarationImpl;
/**
 * ObjectTypeDeclaration scalar properties annotations accessor
 **/
var ObjectTypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(ObjectTypeDeclarationScalarsAnnotationsImpl, _super);
    function ObjectTypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * ObjectTypeDeclaration.minProperties annotations
     **/
    ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.minProperties = function () {
        var attr = this.node.attr("minProperties");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ObjectTypeDeclaration.maxProperties annotations
     **/
    ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.maxProperties = function () {
        var attr = this.node.attr("maxProperties");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ObjectTypeDeclaration.additionalProperties annotations
     **/
    ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.additionalProperties = function () {
        var attr = this.node.attr("additionalProperties");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ObjectTypeDeclaration.discriminator annotations
     **/
    ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.discriminator = function () {
        var attr = this.node.attr("discriminator");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ObjectTypeDeclaration.discriminatorValue annotations
     **/
    ObjectTypeDeclarationScalarsAnnotationsImpl.prototype.discriminatorValue = function () {
        var attr = this.node.attr("discriminatorValue");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return ObjectTypeDeclarationScalarsAnnotationsImpl;
}(TypeDeclarationScalarsAnnotationsImpl));
exports.ObjectTypeDeclarationScalarsAnnotationsImpl = ObjectTypeDeclarationScalarsAnnotationsImpl;
/**
 * Value must be a string
 **/
var StringTypeDeclarationImpl = (function (_super) {
    __extends(StringTypeDeclarationImpl, _super);
    function StringTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createStringTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Regular expression that this string should path
     **/
    StringTypeDeclarationImpl.prototype.pattern = function () {
        return _super.prototype.attribute.call(this, 'pattern', this.toString);
    };
    /**
     * @hidden
     * Set pattern value
     **/
    StringTypeDeclarationImpl.prototype.setPattern = function (param) {
        this.highLevel().attrOrCreate("pattern").setValue("" + param);
        return this;
    };
    /**
     * Minimum length of the string
     **/
    StringTypeDeclarationImpl.prototype.minLength = function () {
        return _super.prototype.attribute.call(this, 'minLength', this.toNumber);
    };
    /**
     * @hidden
     * Set minLength value
     **/
    StringTypeDeclarationImpl.prototype.setMinLength = function (param) {
        this.highLevel().attrOrCreate("minLength").setValue("" + param);
        return this;
    };
    /**
     * Maximum length of the string
     **/
    StringTypeDeclarationImpl.prototype.maxLength = function () {
        return _super.prototype.attribute.call(this, 'maxLength', this.toNumber);
    };
    /**
     * @hidden
     * Set maxLength value
     **/
    StringTypeDeclarationImpl.prototype.setMaxLength = function (param) {
        this.highLevel().attrOrCreate("maxLength").setValue("" + param);
        return this;
    };
    /**
     * (Optional, applicable only for parameters of type string) The enum attribute provides an enumeration of the parameter's valid values. This MUST be an array. If the enum attribute is defined, API clients and servers MUST verify that a parameter's value matches a value in the enum array. If there is no matching value, the clients and servers MUST treat this as an error.
     **/
    StringTypeDeclarationImpl.prototype.enum = function () {
        return _super.prototype.attributes.call(this, 'enum', this.toString);
    };
    /**
     * @hidden
     * Set enum value
     **/
    StringTypeDeclarationImpl.prototype.setEnum = function (param) {
        this.highLevel().attrOrCreate("enum").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    StringTypeDeclarationImpl.prototype.wrapperClassName = function () { return "StringTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    StringTypeDeclarationImpl.prototype.kind = function () { return "StringTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    StringTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    StringTypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new StringTypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return StringTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.StringTypeDeclarationImpl = StringTypeDeclarationImpl;
/**
 * StringTypeDeclaration scalar properties annotations accessor
 **/
var StringTypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(StringTypeDeclarationScalarsAnnotationsImpl, _super);
    function StringTypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * StringTypeDeclaration.pattern annotations
     **/
    StringTypeDeclarationScalarsAnnotationsImpl.prototype.pattern = function () {
        var attr = this.node.attr("pattern");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * StringTypeDeclaration.minLength annotations
     **/
    StringTypeDeclarationScalarsAnnotationsImpl.prototype.minLength = function () {
        var attr = this.node.attr("minLength");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * StringTypeDeclaration.maxLength annotations
     **/
    StringTypeDeclarationScalarsAnnotationsImpl.prototype.maxLength = function () {
        var attr = this.node.attr("maxLength");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * StringTypeDeclaration.enum annotations
     **/
    StringTypeDeclarationScalarsAnnotationsImpl.prototype.enum = function () {
        var attrs = this.node.attributes("enum");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return StringTypeDeclarationScalarsAnnotationsImpl;
}(TypeDeclarationScalarsAnnotationsImpl));
exports.StringTypeDeclarationScalarsAnnotationsImpl = StringTypeDeclarationScalarsAnnotationsImpl;
/**
 * Value must be a boolean
 **/
var BooleanTypeDeclarationImpl = (function (_super) {
    __extends(BooleanTypeDeclarationImpl, _super);
    function BooleanTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createBooleanTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    BooleanTypeDeclarationImpl.prototype.wrapperClassName = function () { return "BooleanTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    BooleanTypeDeclarationImpl.prototype.kind = function () { return "BooleanTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    BooleanTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return BooleanTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.BooleanTypeDeclarationImpl = BooleanTypeDeclarationImpl;
/**
 * Value MUST be a number. Indicate floating point numbers as defined by YAML.
 **/
var NumberTypeDeclarationImpl = (function (_super) {
    __extends(NumberTypeDeclarationImpl, _super);
    function NumberTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createNumberTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * (Optional, applicable only for parameters of type number or integer) The minimum attribute specifies the parameter's minimum value.
     **/
    NumberTypeDeclarationImpl.prototype.minimum = function () {
        return _super.prototype.attribute.call(this, 'minimum', this.toNumber);
    };
    /**
     * @hidden
     * Set minimum value
     **/
    NumberTypeDeclarationImpl.prototype.setMinimum = function (param) {
        this.highLevel().attrOrCreate("minimum").setValue("" + param);
        return this;
    };
    /**
     * (Optional, applicable only for parameters of type number or integer) The maximum attribute specifies the parameter's maximum value.
     **/
    NumberTypeDeclarationImpl.prototype.maximum = function () {
        return _super.prototype.attribute.call(this, 'maximum', this.toNumber);
    };
    /**
     * @hidden
     * Set maximum value
     **/
    NumberTypeDeclarationImpl.prototype.setMaximum = function (param) {
        this.highLevel().attrOrCreate("maximum").setValue("" + param);
        return this;
    };
    /**
     * (Optional, applicable only for parameters of type string) The enum attribute provides an enumeration of the parameter's valid values. This MUST be an array. If the enum attribute is defined, API clients and servers MUST verify that a parameter's value matches a value in the enum array. If there is no matching value, the clients and servers MUST treat this as an error.
     **/
    NumberTypeDeclarationImpl.prototype.enum = function () {
        return _super.prototype.attributes.call(this, 'enum', this.toString);
    };
    /**
     * @hidden
     * Set enum value
     **/
    NumberTypeDeclarationImpl.prototype.setEnum = function (param) {
        this.highLevel().attrOrCreate("enum").setValue("" + param);
        return this;
    };
    /**
     * Value format
     **/
    NumberTypeDeclarationImpl.prototype.format = function () {
        return _super.prototype.attribute.call(this, 'format', this.toString);
    };
    /**
     * @hidden
     * Set format value
     **/
    NumberTypeDeclarationImpl.prototype.setFormat = function (param) {
        this.highLevel().attrOrCreate("format").setValue("" + param);
        return this;
    };
    /**
     * A numeric instance is valid against "multipleOf" if the result of the division of the instance by this keyword's value is an integer.
     **/
    NumberTypeDeclarationImpl.prototype.multipleOf = function () {
        return _super.prototype.attribute.call(this, 'multipleOf', this.toNumber);
    };
    /**
     * @hidden
     * Set multipleOf value
     **/
    NumberTypeDeclarationImpl.prototype.setMultipleOf = function (param) {
        this.highLevel().attrOrCreate("multipleOf").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    NumberTypeDeclarationImpl.prototype.wrapperClassName = function () { return "NumberTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    NumberTypeDeclarationImpl.prototype.kind = function () { return "NumberTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    NumberTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    NumberTypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new NumberTypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return NumberTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.NumberTypeDeclarationImpl = NumberTypeDeclarationImpl;
/**
 * Value MUST be a integer.
 **/
var IntegerTypeDeclarationImpl = (function (_super) {
    __extends(IntegerTypeDeclarationImpl, _super);
    function IntegerTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createIntegerTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Value format
     **/
    IntegerTypeDeclarationImpl.prototype.format = function () {
        return _super.prototype.attribute.call(this, 'format', this.toString);
    };
    /**
     * @hidden
     * Set format value
     **/
    IntegerTypeDeclarationImpl.prototype.setFormat = function (param) {
        this.highLevel().attrOrCreate("format").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    IntegerTypeDeclarationImpl.prototype.wrapperClassName = function () { return "IntegerTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    IntegerTypeDeclarationImpl.prototype.kind = function () { return "IntegerTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    IntegerTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    IntegerTypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new IntegerTypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return IntegerTypeDeclarationImpl;
}(NumberTypeDeclarationImpl));
exports.IntegerTypeDeclarationImpl = IntegerTypeDeclarationImpl;
/**
 * NumberTypeDeclaration scalar properties annotations accessor
 **/
var NumberTypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(NumberTypeDeclarationScalarsAnnotationsImpl, _super);
    function NumberTypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * NumberTypeDeclaration.minimum annotations
     **/
    NumberTypeDeclarationScalarsAnnotationsImpl.prototype.minimum = function () {
        var attr = this.node.attr("minimum");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * NumberTypeDeclaration.maximum annotations
     **/
    NumberTypeDeclarationScalarsAnnotationsImpl.prototype.maximum = function () {
        var attr = this.node.attr("maximum");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * NumberTypeDeclaration.enum annotations
     **/
    NumberTypeDeclarationScalarsAnnotationsImpl.prototype.enum = function () {
        var attrs = this.node.attributes("enum");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * NumberTypeDeclaration.format annotations
     **/
    NumberTypeDeclarationScalarsAnnotationsImpl.prototype.format = function () {
        var attr = this.node.attr("format");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * NumberTypeDeclaration.multipleOf annotations
     **/
    NumberTypeDeclarationScalarsAnnotationsImpl.prototype.multipleOf = function () {
        var attr = this.node.attr("multipleOf");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return NumberTypeDeclarationScalarsAnnotationsImpl;
}(TypeDeclarationScalarsAnnotationsImpl));
exports.NumberTypeDeclarationScalarsAnnotationsImpl = NumberTypeDeclarationScalarsAnnotationsImpl;
/**
 * IntegerTypeDeclaration scalar properties annotations accessor
 **/
var IntegerTypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(IntegerTypeDeclarationScalarsAnnotationsImpl, _super);
    function IntegerTypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * IntegerTypeDeclaration.format annotations
     **/
    IntegerTypeDeclarationScalarsAnnotationsImpl.prototype.format = function () {
        var attr = this.node.attr("format");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return IntegerTypeDeclarationScalarsAnnotationsImpl;
}(NumberTypeDeclarationScalarsAnnotationsImpl));
exports.IntegerTypeDeclarationScalarsAnnotationsImpl = IntegerTypeDeclarationScalarsAnnotationsImpl;
/**
 * the "full-date" notation of RFC3339, namely yyyy-mm-dd (no implications about time or timezone-offset)
 **/
var DateOnlyTypeDeclarationImpl = (function (_super) {
    __extends(DateOnlyTypeDeclarationImpl, _super);
    function DateOnlyTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createDateOnlyTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DateOnlyTypeDeclarationImpl.prototype.wrapperClassName = function () { return "DateOnlyTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DateOnlyTypeDeclarationImpl.prototype.kind = function () { return "DateOnlyTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    DateOnlyTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return DateOnlyTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.DateOnlyTypeDeclarationImpl = DateOnlyTypeDeclarationImpl;
/**
 * the "partial-time" notation of RFC3339, namely hh:mm:ss[.ff...] (no implications about date or timezone-offset)
 **/
var TimeOnlyTypeDeclarationImpl = (function (_super) {
    __extends(TimeOnlyTypeDeclarationImpl, _super);
    function TimeOnlyTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createTimeOnlyTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    TimeOnlyTypeDeclarationImpl.prototype.wrapperClassName = function () { return "TimeOnlyTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    TimeOnlyTypeDeclarationImpl.prototype.kind = function () { return "TimeOnlyTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    TimeOnlyTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return TimeOnlyTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.TimeOnlyTypeDeclarationImpl = TimeOnlyTypeDeclarationImpl;
/**
 * combined date-only and time-only with a separator of "T", namely yyyy-mm-ddThh:mm:ss[.ff...] (no implications about timezone-offset)
 **/
var DateTimeOnlyTypeDeclarationImpl = (function (_super) {
    __extends(DateTimeOnlyTypeDeclarationImpl, _super);
    function DateTimeOnlyTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createDateTimeOnlyTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DateTimeOnlyTypeDeclarationImpl.prototype.wrapperClassName = function () { return "DateTimeOnlyTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DateTimeOnlyTypeDeclarationImpl.prototype.kind = function () { return "DateTimeOnlyTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    DateTimeOnlyTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return DateTimeOnlyTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.DateTimeOnlyTypeDeclarationImpl = DateTimeOnlyTypeDeclarationImpl;
/**
 * a timestamp, either in the "date-time" notation of RFC3339, if format is omitted or is set to rfc3339, or in the format defined in RFC2616, if format is set to rfc2616.
 **/
var DateTimeTypeDeclarationImpl = (function (_super) {
    __extends(DateTimeTypeDeclarationImpl, _super);
    function DateTimeTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createDateTimeTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Format used for this date time rfc3339 or rfc2616
     **/
    DateTimeTypeDeclarationImpl.prototype.format = function () {
        return _super.prototype.attribute.call(this, 'format', this.toString);
    };
    /**
     * @hidden
     * Set format value
     **/
    DateTimeTypeDeclarationImpl.prototype.setFormat = function (param) {
        this.highLevel().attrOrCreate("format").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DateTimeTypeDeclarationImpl.prototype.wrapperClassName = function () { return "DateTimeTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DateTimeTypeDeclarationImpl.prototype.kind = function () { return "DateTimeTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    DateTimeTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    DateTimeTypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new DateTimeTypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return DateTimeTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.DateTimeTypeDeclarationImpl = DateTimeTypeDeclarationImpl;
/**
 * DateTimeTypeDeclaration scalar properties annotations accessor
 **/
var DateTimeTypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(DateTimeTypeDeclarationScalarsAnnotationsImpl, _super);
    function DateTimeTypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * DateTimeTypeDeclaration.format annotations
     **/
    DateTimeTypeDeclarationScalarsAnnotationsImpl.prototype.format = function () {
        var attr = this.node.attr("format");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return DateTimeTypeDeclarationScalarsAnnotationsImpl;
}(TypeDeclarationScalarsAnnotationsImpl));
exports.DateTimeTypeDeclarationScalarsAnnotationsImpl = DateTimeTypeDeclarationScalarsAnnotationsImpl;
/**
 * (Applicable only to Form properties) Value is a file. Client generators SHOULD use this type to handle file uploads correctly.
 **/
var FileTypeDeclarationImpl = (function (_super) {
    __extends(FileTypeDeclarationImpl, _super);
    function FileTypeDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createFileTypeDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * It should also include a new property: fileTypes, which should be a list of valid content-type strings for the file. The file type * /* should be a valid value.
     **/
    FileTypeDeclarationImpl.prototype.fileTypes = function () {
        return _super.prototype.attributes.call(this, 'fileTypes', function (attr) { return new ContentTypeImpl(attr); });
    };
    /**
     * The minLength attribute specifies the parameter value's minimum number of bytes.
     **/
    FileTypeDeclarationImpl.prototype.minLength = function () {
        return _super.prototype.attribute.call(this, 'minLength', this.toNumber);
    };
    /**
     * @hidden
     * Set minLength value
     **/
    FileTypeDeclarationImpl.prototype.setMinLength = function (param) {
        this.highLevel().attrOrCreate("minLength").setValue("" + param);
        return this;
    };
    /**
     * The maxLength attribute specifies the parameter value's maximum number of bytes.
     **/
    FileTypeDeclarationImpl.prototype.maxLength = function () {
        return _super.prototype.attribute.call(this, 'maxLength', this.toNumber);
    };
    /**
     * @hidden
     * Set maxLength value
     **/
    FileTypeDeclarationImpl.prototype.setMaxLength = function (param) {
        this.highLevel().attrOrCreate("maxLength").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FileTypeDeclarationImpl.prototype.wrapperClassName = function () { return "FileTypeDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FileTypeDeclarationImpl.prototype.kind = function () { return "FileTypeDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    FileTypeDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    FileTypeDeclarationImpl.prototype.scalarsAnnotations = function () { return new FileTypeDeclarationScalarsAnnotationsImpl(this.highLevel()); };
    return FileTypeDeclarationImpl;
}(TypeDeclarationImpl));
exports.FileTypeDeclarationImpl = FileTypeDeclarationImpl;
/**
 * FileTypeDeclaration scalar properties annotations accessor
 **/
var FileTypeDeclarationScalarsAnnotationsImpl = (function (_super) {
    __extends(FileTypeDeclarationScalarsAnnotationsImpl, _super);
    function FileTypeDeclarationScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * FileTypeDeclaration.fileTypes annotations
     **/
    FileTypeDeclarationScalarsAnnotationsImpl.prototype.fileTypes = function () {
        var attrs = this.node.attributes("fileTypes");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * FileTypeDeclaration.minLength annotations
     **/
    FileTypeDeclarationScalarsAnnotationsImpl.prototype.minLength = function () {
        var attr = this.node.attr("minLength");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * FileTypeDeclaration.maxLength annotations
     **/
    FileTypeDeclarationScalarsAnnotationsImpl.prototype.maxLength = function () {
        var attr = this.node.attr("maxLength");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return FileTypeDeclarationScalarsAnnotationsImpl;
}(TypeDeclarationScalarsAnnotationsImpl));
exports.FileTypeDeclarationScalarsAnnotationsImpl = FileTypeDeclarationScalarsAnnotationsImpl;
var ResponseImpl = (function (_super) {
    __extends(ResponseImpl, _super);
    function ResponseImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createResponse(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Responses MUST be a map of one or more HTTP status codes, where each status code itself is a map that describes that status code.
     **/
    ResponseImpl.prototype.code = function () {
        return _super.prototype.attribute.call(this, 'code', function (attr) { return new StatusCodeStringImpl(attr); });
    };
    /**
     * Detailed information about any response headers returned by this method
     **/
    ResponseImpl.prototype.headers = function () {
        return _super.prototype.elements.call(this, 'headers');
    };
    /**
     * The body of the response: a body declaration
     **/
    ResponseImpl.prototype.body = function () {
        return _super.prototype.elements.call(this, 'body');
    };
    /**
     * A longer, human-friendly description of the response
     **/
    ResponseImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    ResponseImpl.prototype.annotations = function () {
        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResponseImpl.prototype.wrapperClassName = function () { return "ResponseImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResponseImpl.prototype.kind = function () { return "Response"; };
    /**
     * @return RAML version of the node
     **/
    ResponseImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * true for codes < 400 and false otherwise
     **/
    ResponseImpl.prototype.isOkRange = function () {
        return helper.isOkRange(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    ResponseImpl.prototype.scalarsAnnotations = function () { return new ResponseScalarsAnnotationsImpl(this.highLevel()); };
    return ResponseImpl;
}(AnnotableImpl));
exports.ResponseImpl = ResponseImpl;
/**
 * Response scalar properties annotations accessor
 **/
var ResponseScalarsAnnotationsImpl = (function (_super) {
    __extends(ResponseScalarsAnnotationsImpl, _super);
    function ResponseScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Response.description annotations
     **/
    ResponseScalarsAnnotationsImpl.prototype.description = function () {
        var attr = this.node.attr("description");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Response.annotations annotations
     **/
    ResponseScalarsAnnotationsImpl.prototype.annotations = function () {
        var attrs = this.node.attributes("annotations");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return ResponseScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.ResponseScalarsAnnotationsImpl = ResponseScalarsAnnotationsImpl;
var SecuritySchemePartImpl = (function (_super) {
    __extends(SecuritySchemePartImpl, _super);
    function SecuritySchemePartImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemePart(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Annotations to be applied to this security scheme part. Annotations are any property whose key begins with "(" and ends with ")" and whose name (the part between the beginning and ending parentheses) is a declared annotation name.
     **/
    SecuritySchemePartImpl.prototype.annotations = function () {
        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SecuritySchemePartImpl.prototype.wrapperClassName = function () { return "SecuritySchemePartImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SecuritySchemePartImpl.prototype.kind = function () { return "SecuritySchemePart"; };
    /**
     * @return RAML version of the node
     **/
    SecuritySchemePartImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    SecuritySchemePartImpl.prototype.scalarsAnnotations = function () { return new SecuritySchemePartScalarsAnnotationsImpl(this.highLevel()); };
    return SecuritySchemePartImpl;
}(OperationImpl));
exports.SecuritySchemePartImpl = SecuritySchemePartImpl;
/**
 * SecuritySchemePart scalar properties annotations accessor
 **/
var SecuritySchemePartScalarsAnnotationsImpl = (function (_super) {
    __extends(SecuritySchemePartScalarsAnnotationsImpl, _super);
    function SecuritySchemePartScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * SecuritySchemePart.annotations annotations
     **/
    SecuritySchemePartScalarsAnnotationsImpl.prototype.annotations = function () {
        var attrs = this.node.attributes("annotations");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return SecuritySchemePartScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.SecuritySchemePartScalarsAnnotationsImpl = SecuritySchemePartScalarsAnnotationsImpl;
var MethodBaseImpl = (function (_super) {
    __extends(MethodBaseImpl, _super);
    function MethodBaseImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createMethodBase(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Some method verbs expect the resource to be sent as a request body. For example, to create a resource, the request must include the details of the resource to create. Resources CAN have alternate representations. For example, an API might support both JSON and XML representations. A method's body is defined in the body property as a hashmap, in which the key MUST be a valid media type.
     **/
    MethodBaseImpl.prototype.body = function () {
        return _super.prototype.elements.call(this, 'body');
    };
    /**
     * A method can override the protocols specified in the resource or at the API root, by employing this property.
     **/
    MethodBaseImpl.prototype.protocols = function () {
        return _super.prototype.attributes.call(this, 'protocols', this.toString);
    };
    /**
     * @hidden
     * Set protocols value
     **/
    MethodBaseImpl.prototype.setProtocols = function (param) {
        this.highLevel().attrOrCreate("protocols").setValue("" + param);
        return this;
    };
    /**
     * Instantiation of applyed traits
     **/
    MethodBaseImpl.prototype.is = function () {
        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
    };
    /**
     * securityScheme may also be applied to a resource by using the securedBy key, which is equivalent to applying the securityScheme to all methods that may be declared, explicitly or implicitly, by defining the resourceTypes or traits property for that resource. To indicate that the method may be called without applying any securityScheme, the method may be annotated with the null securityScheme.
     **/
    MethodBaseImpl.prototype.securedBy = function () {
        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemeRefImpl(attr); });
    };
    MethodBaseImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    MethodBaseImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    MethodBaseImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MethodBaseImpl.prototype.wrapperClassName = function () { return "MethodBaseImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MethodBaseImpl.prototype.kind = function () { return "MethodBase"; };
    /**
     * @return RAML version of the node
     **/
    MethodBaseImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    MethodBaseImpl.prototype.scalarsAnnotations = function () { return new MethodBaseScalarsAnnotationsImpl(this.highLevel()); };
    return MethodBaseImpl;
}(OperationImpl));
exports.MethodBaseImpl = MethodBaseImpl;
var SecuritySchemeRefImpl = (function (_super) {
    __extends(SecuritySchemeRefImpl, _super);
    function SecuritySchemeRefImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SecuritySchemeRefImpl.prototype.wrapperClassName = function () { return "SecuritySchemeRefImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SecuritySchemeRefImpl.prototype.kind = function () { return "SecuritySchemeRef"; };
    /**
     * @return RAML version of the node
     **/
    SecuritySchemeRefImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    SecuritySchemeRefImpl.prototype.securitySchemeName = function () {
        return helper.securitySchemeName(this);
    };
    SecuritySchemeRefImpl.prototype.securityScheme = function () {
        return helper.securityScheme(this);
    };
    return SecuritySchemeRefImpl;
}(ReferenceImpl));
exports.SecuritySchemeRefImpl = SecuritySchemeRefImpl;
/**
 * Declares globally referable security scheme definition
 **/
var AbstractSecuritySchemeImpl = (function (_super) {
    __extends(AbstractSecuritySchemeImpl, _super);
    function AbstractSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createAbstractSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Name of the security scheme
     **/
    AbstractSecuritySchemeImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    AbstractSecuritySchemeImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * The securitySchemes property MUST be used to specify an API's security mechanisms, including the required settings and the authentication methods that the API supports. one authentication method is allowed if the API supports them.
     **/
    AbstractSecuritySchemeImpl.prototype["type"] = function () {
        return _super.prototype.attribute.call(this, 'type', this.toString);
    };
    /**
     * @hidden
     * Set type value
     **/
    AbstractSecuritySchemeImpl.prototype.setType = function (param) {
        this.highLevel().attrOrCreate("type").setValue("" + param);
        return this;
    };
    /**
     * The description MAY be used to describe a securityScheme.
     **/
    AbstractSecuritySchemeImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * A description of the request components related to Security that are determined by the scheme: the headers, query parameters or responses. As a best practice, even for standard security schemes, API designers SHOULD describe these properties of security schemes. Including the security scheme description completes an API documentation.
     **/
    AbstractSecuritySchemeImpl.prototype.describedBy = function () {
        return _super.prototype.element.call(this, 'describedBy');
    };
    /**
     * The displayName attribute specifies the security scheme display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    AbstractSecuritySchemeImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    AbstractSecuritySchemeImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * The settings attribute MAY be used to provide security scheme-specific information. The required attributes vary depending on the type of security scheme is being declared. It describes the minimum set of properties which any processing application MUST provide and validate if it chooses to implement the security scheme. Processing applications MAY choose to recognize other properties for things such as token lifetime, preferred cryptographic algorithms, and more.
     **/
    AbstractSecuritySchemeImpl.prototype.settings = function () {
        return _super.prototype.element.call(this, 'settings');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    AbstractSecuritySchemeImpl.prototype.wrapperClassName = function () { return "AbstractSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    AbstractSecuritySchemeImpl.prototype.kind = function () { return "AbstractSecurityScheme"; };
    /**
     * @return RAML version of the node
     **/
    AbstractSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    AbstractSecuritySchemeImpl.prototype.scalarsAnnotations = function () { return new AbstractSecuritySchemeScalarsAnnotationsImpl(this.highLevel()); };
    return AbstractSecuritySchemeImpl;
}(AnnotableImpl));
exports.AbstractSecuritySchemeImpl = AbstractSecuritySchemeImpl;
var SecuritySchemeSettingsImpl = (function (_super) {
    __extends(SecuritySchemeSettingsImpl, _super);
    function SecuritySchemeSettingsImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createSecuritySchemeSettings(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () { return "SecuritySchemeSettingsImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    SecuritySchemeSettingsImpl.prototype.kind = function () { return "SecuritySchemeSettings"; };
    /**
     * @return RAML version of the node
     **/
    SecuritySchemeSettingsImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return SecuritySchemeSettingsImpl;
}(AnnotableImpl));
exports.SecuritySchemeSettingsImpl = SecuritySchemeSettingsImpl;
var OAuth1SecuritySchemeSettingsImpl = (function (_super) {
    __extends(OAuth1SecuritySchemeSettingsImpl, _super);
    function OAuth1SecuritySchemeSettingsImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth1SecuritySchemeSettings(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * The URI of the Temporary Credential Request endpoint as defined in RFC5849 Section 2.1
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.requestTokenUri = function () {
        return _super.prototype.attribute.call(this, 'requestTokenUri', function (attr) { return new FixedUriStringImpl(attr); });
    };
    /**
     * The URI of the Resource Owner Authorization endpoint as defined in RFC5849 Section 2.2
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriStringImpl(attr); });
    };
    /**
     * The URI of the Token Request endpoint as defined in RFC5849 Section 2.3
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.tokenCredentialsUri = function () {
        return _super.prototype.attribute.call(this, 'tokenCredentialsUri', function (attr) { return new FixedUriStringImpl(attr); });
    };
    /**
     * List of the signature methods used by the server. Available methods: HMAC-SHA1, RSA-SHA1, PLAINTEXT
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.signatures = function () {
        return _super.prototype.attributes.call(this, 'signatures', this.toString);
    };
    /**
     * @hidden
     * Set signatures value
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.setSignatures = function (param) {
        this.highLevel().attrOrCreate("signatures").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () { return "OAuth1SecuritySchemeSettingsImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.kind = function () { return "OAuth1SecuritySchemeSettings"; };
    /**
     * @return RAML version of the node
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    OAuth1SecuritySchemeSettingsImpl.prototype.scalarsAnnotations = function () { return new OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl(this.highLevel()); };
    return OAuth1SecuritySchemeSettingsImpl;
}(SecuritySchemeSettingsImpl));
exports.OAuth1SecuritySchemeSettingsImpl = OAuth1SecuritySchemeSettingsImpl;
/**
 * OAuth1SecuritySchemeSettings scalar properties annotations accessor
 **/
var OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl = (function (_super) {
    __extends(OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl, _super);
    function OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * OAuth1SecuritySchemeSettings.requestTokenUri annotations
     **/
    OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.requestTokenUri = function () {
        var attr = this.node.attr("requestTokenUri");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * OAuth1SecuritySchemeSettings.authorizationUri annotations
     **/
    OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.authorizationUri = function () {
        var attr = this.node.attr("authorizationUri");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * OAuth1SecuritySchemeSettings.tokenCredentialsUri annotations
     **/
    OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.tokenCredentialsUri = function () {
        var attr = this.node.attr("tokenCredentialsUri");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * OAuth1SecuritySchemeSettings.signatures annotations
     **/
    OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.signatures = function () {
        var attrs = this.node.attributes("signatures");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl = OAuth1SecuritySchemeSettingsScalarsAnnotationsImpl;
var OAuth2SecuritySchemeSettingsImpl = (function (_super) {
    __extends(OAuth2SecuritySchemeSettingsImpl, _super);
    function OAuth2SecuritySchemeSettingsImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth2SecuritySchemeSettings(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * The URI of the Token Endpoint as defined in RFC6749 Section 3.2. Not required forby implicit grant type.
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.accessTokenUri = function () {
        return _super.prototype.attribute.call(this, 'accessTokenUri', function (attr) { return new FixedUriStringImpl(attr); });
    };
    /**
     * The URI of the Authorization Endpoint as defined in RFC6749 Section 3.1. Required forby authorization_code and implicit grant types.
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationUri = function () {
        return _super.prototype.attribute.call(this, 'authorizationUri', function (attr) { return new FixedUriStringImpl(attr); });
    };
    /**
     * A list of the Authorization grants supported by the API as defined in RFC6749 Sections 4.1, 4.2, 4.3 and 4.4, can be any of: authorization_code, password, client_credentials, implicit, or any absolute url.
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.authorizationGrants = function () {
        return _super.prototype.attributes.call(this, 'authorizationGrants', this.toString);
    };
    /**
     * @hidden
     * Set authorizationGrants value
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.setAuthorizationGrants = function (param) {
        this.highLevel().attrOrCreate("authorizationGrants").setValue("" + param);
        return this;
    };
    /**
     * A list of scopes supported by the security scheme as defined in RFC6749 Section 3.3
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.scopes = function () {
        return _super.prototype.attributes.call(this, 'scopes', this.toString);
    };
    /**
     * @hidden
     * Set scopes value
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.setScopes = function (param) {
        this.highLevel().attrOrCreate("scopes").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.wrapperClassName = function () { return "OAuth2SecuritySchemeSettingsImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.kind = function () { return "OAuth2SecuritySchemeSettings"; };
    /**
     * @return RAML version of the node
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    OAuth2SecuritySchemeSettingsImpl.prototype.scalarsAnnotations = function () { return new OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl(this.highLevel()); };
    return OAuth2SecuritySchemeSettingsImpl;
}(SecuritySchemeSettingsImpl));
exports.OAuth2SecuritySchemeSettingsImpl = OAuth2SecuritySchemeSettingsImpl;
/**
 * OAuth2SecuritySchemeSettings scalar properties annotations accessor
 **/
var OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl = (function (_super) {
    __extends(OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl, _super);
    function OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * OAuth2SecuritySchemeSettings.accessTokenUri annotations
     **/
    OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.accessTokenUri = function () {
        var attr = this.node.attr("accessTokenUri");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * OAuth2SecuritySchemeSettings.authorizationUri annotations
     **/
    OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.authorizationUri = function () {
        var attr = this.node.attr("authorizationUri");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * OAuth2SecuritySchemeSettings.authorizationGrants annotations
     **/
    OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.authorizationGrants = function () {
        var attrs = this.node.attributes("authorizationGrants");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * OAuth2SecuritySchemeSettings.scopes annotations
     **/
    OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl.prototype.scopes = function () {
        var attrs = this.node.attributes("scopes");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl = OAuth2SecuritySchemeSettingsScalarsAnnotationsImpl;
/**
 * Declares globally referable security scheme definition
 **/
var OAuth2SecuritySchemeImpl = (function (_super) {
    __extends(OAuth2SecuritySchemeImpl, _super);
    function OAuth2SecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth2SecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    OAuth2SecuritySchemeImpl.prototype.settings = function () {
        return _super.prototype.element.call(this, 'settings');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth2SecuritySchemeImpl.prototype.wrapperClassName = function () { return "OAuth2SecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth2SecuritySchemeImpl.prototype.kind = function () { return "OAuth2SecurityScheme"; };
    /**
     * @return RAML version of the node
     **/
    OAuth2SecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return OAuth2SecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.OAuth2SecuritySchemeImpl = OAuth2SecuritySchemeImpl;
/**
 * Declares globally referable security scheme definition
 **/
var OAuth1SecuritySchemeImpl = (function (_super) {
    __extends(OAuth1SecuritySchemeImpl, _super);
    function OAuth1SecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createOAuth1SecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    OAuth1SecuritySchemeImpl.prototype.settings = function () {
        return _super.prototype.element.call(this, 'settings');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OAuth1SecuritySchemeImpl.prototype.wrapperClassName = function () { return "OAuth1SecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OAuth1SecuritySchemeImpl.prototype.kind = function () { return "OAuth1SecurityScheme"; };
    /**
     * @return RAML version of the node
     **/
    OAuth1SecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return OAuth1SecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.OAuth1SecuritySchemeImpl = OAuth1SecuritySchemeImpl;
/**
 * Declares globally referable security scheme definition
 **/
var PassThroughSecuritySchemeImpl = (function (_super) {
    __extends(PassThroughSecuritySchemeImpl, _super);
    function PassThroughSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createPassThroughSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    PassThroughSecuritySchemeImpl.prototype.settings = function () {
        return _super.prototype.element.call(this, 'settings');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    PassThroughSecuritySchemeImpl.prototype.wrapperClassName = function () { return "PassThroughSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    PassThroughSecuritySchemeImpl.prototype.kind = function () { return "PassThroughSecurityScheme"; };
    /**
     * @return RAML version of the node
     **/
    PassThroughSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return PassThroughSecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.PassThroughSecuritySchemeImpl = PassThroughSecuritySchemeImpl;
/**
 * Declares globally referable security scheme definition
 **/
var BasicSecuritySchemeImpl = (function (_super) {
    __extends(BasicSecuritySchemeImpl, _super);
    function BasicSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createBasicSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    BasicSecuritySchemeImpl.prototype.wrapperClassName = function () { return "BasicSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    BasicSecuritySchemeImpl.prototype.kind = function () { return "BasicSecurityScheme"; };
    /**
     * @return RAML version of the node
     **/
    BasicSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return BasicSecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.BasicSecuritySchemeImpl = BasicSecuritySchemeImpl;
/**
 * Declares globally referable security scheme definition
 **/
var DigestSecuritySchemeImpl = (function (_super) {
    __extends(DigestSecuritySchemeImpl, _super);
    function DigestSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createDigestSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DigestSecuritySchemeImpl.prototype.wrapperClassName = function () { return "DigestSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DigestSecuritySchemeImpl.prototype.kind = function () { return "DigestSecurityScheme"; };
    /**
     * @return RAML version of the node
     **/
    DigestSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return DigestSecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.DigestSecuritySchemeImpl = DigestSecuritySchemeImpl;
/**
 * Declares globally referable security scheme definition
 **/
var CustomSecuritySchemeImpl = (function (_super) {
    __extends(CustomSecuritySchemeImpl, _super);
    function CustomSecuritySchemeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createCustomSecurityScheme(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    CustomSecuritySchemeImpl.prototype.wrapperClassName = function () { return "CustomSecuritySchemeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    CustomSecuritySchemeImpl.prototype.kind = function () { return "CustomSecurityScheme"; };
    /**
     * @return RAML version of the node
     **/
    CustomSecuritySchemeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return CustomSecuritySchemeImpl;
}(AbstractSecuritySchemeImpl));
exports.CustomSecuritySchemeImpl = CustomSecuritySchemeImpl;
/**
 * AbstractSecurityScheme scalar properties annotations accessor
 **/
var AbstractSecuritySchemeScalarsAnnotationsImpl = (function (_super) {
    __extends(AbstractSecuritySchemeScalarsAnnotationsImpl, _super);
    function AbstractSecuritySchemeScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * AbstractSecurityScheme.type annotations
     **/
    AbstractSecuritySchemeScalarsAnnotationsImpl.prototype["type"] = function () {
        var attr = this.node.attr("type");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * AbstractSecurityScheme.description annotations
     **/
    AbstractSecuritySchemeScalarsAnnotationsImpl.prototype.description = function () {
        var attr = this.node.attr("description");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * AbstractSecurityScheme.displayName annotations
     **/
    AbstractSecuritySchemeScalarsAnnotationsImpl.prototype.displayName = function () {
        var attr = this.node.attr("displayName");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return AbstractSecuritySchemeScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.AbstractSecuritySchemeScalarsAnnotationsImpl = AbstractSecuritySchemeScalarsAnnotationsImpl;
var MethodImpl = (function (_super) {
    __extends(MethodImpl, _super);
    function MethodImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createMethod(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Method that can be called
     **/
    MethodImpl.prototype.method = function () {
        return _super.prototype.attribute.call(this, 'method', this.toString);
    };
    /**
     * @hidden
     * Set method value
     **/
    MethodImpl.prototype.setMethod = function (param) {
        this.highLevel().attrOrCreate("method").setValue("" + param);
        return this;
    };
    /**
     * The displayName attribute specifies the method display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    MethodImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    MethodImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    MethodImpl.prototype.wrapperClassName = function () { return "MethodImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    MethodImpl.prototype.kind = function () { return "Method"; };
    /**
     * @return RAML version of the node
     **/
    MethodImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * For methods of Resources returns parent resource. For methods of ResourceTypes returns null.
     **/
    MethodImpl.prototype.parentResource = function () {
        return helper.parentResource(this);
    };
    /**
     * Api owning the resource as a sibling
     **/
    MethodImpl.prototype.ownerApi = function () {
        return helper.ownerApi(this);
    };
    /**
     * For methods of Resources: `{parent Resource relative path} {methodName}`.
     * For methods of ResourceTypes: `{parent ResourceType name} {methodName}`.
     * For other methods throws Exception.
     **/
    MethodImpl.prototype.methodId = function () {
        return helper.methodId(this);
    };
    /**
     * Returns security schemes, resource or method is secured with. If no security schemes are set at resource or method level,
     * returns schemes defined with `securedBy` at API level.
     * @deprecated
     **/
    MethodImpl.prototype.allSecuredBy = function () {
        return helper.allSecuredBy(this);
    };
    MethodImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    MethodImpl.prototype.scalarsAnnotations = function () { return new MethodScalarsAnnotationsImpl(this.highLevel()); };
    return MethodImpl;
}(MethodBaseImpl));
exports.MethodImpl = MethodImpl;
/**
 * MethodBase scalar properties annotations accessor
 **/
var MethodBaseScalarsAnnotationsImpl = (function (_super) {
    __extends(MethodBaseScalarsAnnotationsImpl, _super);
    function MethodBaseScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * MethodBase.protocols annotations
     **/
    MethodBaseScalarsAnnotationsImpl.prototype.protocols = function () {
        var attrs = this.node.attributes("protocols");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * MethodBase.is annotations
     **/
    MethodBaseScalarsAnnotationsImpl.prototype.is = function () {
        var attrs = this.node.attributes("is");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * MethodBase.securedBy annotations
     **/
    MethodBaseScalarsAnnotationsImpl.prototype.securedBy = function () {
        var attrs = this.node.attributes("securedBy");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * MethodBase.description annotations
     **/
    MethodBaseScalarsAnnotationsImpl.prototype.description = function () {
        var attr = this.node.attr("description");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * MethodBase.displayName annotations
     **/
    MethodBaseScalarsAnnotationsImpl.prototype.displayName = function () {
        var attr = this.node.attr("displayName");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return MethodBaseScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.MethodBaseScalarsAnnotationsImpl = MethodBaseScalarsAnnotationsImpl;
/**
 * Method scalar properties annotations accessor
 **/
var MethodScalarsAnnotationsImpl = (function (_super) {
    __extends(MethodScalarsAnnotationsImpl, _super);
    function MethodScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Method.displayName annotations
     **/
    MethodScalarsAnnotationsImpl.prototype.displayName = function () {
        var attr = this.node.attr("displayName");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return MethodScalarsAnnotationsImpl;
}(MethodBaseScalarsAnnotationsImpl));
exports.MethodScalarsAnnotationsImpl = MethodScalarsAnnotationsImpl;
var TraitImpl = (function (_super) {
    __extends(TraitImpl, _super);
    function TraitImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createTrait(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Name of the trait
     **/
    TraitImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    TraitImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * Instructions on how and when the trait should be used.
     **/
    TraitImpl.prototype.usage = function () {
        return _super.prototype.attribute.call(this, 'usage', this.toString);
    };
    /**
     * @hidden
     * Set usage value
     **/
    TraitImpl.prototype.setUsage = function (param) {
        this.highLevel().attrOrCreate("usage").setValue("" + param);
        return this;
    };
    /**
     * The displayName attribute specifies the trait display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    TraitImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    TraitImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    TraitImpl.prototype.uses = function () {
        return _super.prototype.elements.call(this, 'uses');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    TraitImpl.prototype.wrapperClassName = function () { return "TraitImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    TraitImpl.prototype.kind = function () { return "Trait"; };
    /**
     * @return RAML version of the node
     **/
    TraitImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    TraitImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    TraitImpl.prototype.scalarsAnnotations = function () { return new TraitScalarsAnnotationsImpl(this.highLevel()); };
    return TraitImpl;
}(MethodBaseImpl));
exports.TraitImpl = TraitImpl;
/**
 * Trait scalar properties annotations accessor
 **/
var TraitScalarsAnnotationsImpl = (function (_super) {
    __extends(TraitScalarsAnnotationsImpl, _super);
    function TraitScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Trait.usage annotations
     **/
    TraitScalarsAnnotationsImpl.prototype.usage = function () {
        var attr = this.node.attr("usage");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Trait.displayName annotations
     **/
    TraitScalarsAnnotationsImpl.prototype.displayName = function () {
        var attr = this.node.attr("displayName");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return TraitScalarsAnnotationsImpl;
}(MethodBaseScalarsAnnotationsImpl));
exports.TraitScalarsAnnotationsImpl = TraitScalarsAnnotationsImpl;
var ResourceTypeRefImpl = (function (_super) {
    __extends(ResourceTypeRefImpl, _super);
    function ResourceTypeRefImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResourceTypeRefImpl.prototype.wrapperClassName = function () { return "ResourceTypeRefImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResourceTypeRefImpl.prototype.kind = function () { return "ResourceTypeRef"; };
    /**
     * @return RAML version of the node
     **/
    ResourceTypeRefImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    ResourceTypeRefImpl.prototype.resourceType = function () {
        return helper.referencedResourceType(this);
    };
    return ResourceTypeRefImpl;
}(ReferenceImpl));
exports.ResourceTypeRefImpl = ResourceTypeRefImpl;
var ResourceBaseImpl = (function (_super) {
    __extends(ResourceBaseImpl, _super);
    function ResourceBaseImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createResourceBase(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Methods that are part of this resource type definition
     **/
    ResourceBaseImpl.prototype.methods = function () {
        return _super.prototype.elements.call(this, 'methods');
    };
    /**
     * A list of the traits to apply to all methods declared (implicitly or explicitly) for this resource. Individual methods may override this declaration
     **/
    ResourceBaseImpl.prototype.is = function () {
        return _super.prototype.attributes.call(this, 'is', function (attr) { return new TraitRefImpl(attr); });
    };
    /**
     * The resource type which this resource inherits.
     **/
    ResourceBaseImpl.prototype["type"] = function () {
        return _super.prototype.attribute.call(this, 'type', function (attr) { return new ResourceTypeRefImpl(attr); });
    };
    ResourceBaseImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * The security schemes that apply to all methods declared (implicitly or explicitly) for this resource.
     **/
    ResourceBaseImpl.prototype.securedBy = function () {
        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemeRefImpl(attr); });
    };
    /**
     * Detailed information about any URI parameters of this resource
     * @hidden
     **/
    ResourceBaseImpl.prototype.uriParameters_original = function () {
        return _super.prototype.elements.call(this, 'uriParameters');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResourceBaseImpl.prototype.wrapperClassName = function () { return "ResourceBaseImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResourceBaseImpl.prototype.kind = function () { return "ResourceBase"; };
    /**
     * @return RAML version of the node
     **/
    ResourceBaseImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Detailed information about any URI parameters of this resource
     **/
    ResourceBaseImpl.prototype.uriParameters = function () {
        return helper.uriParametersPrimary(this);
    };
    /**
     * Retrieve an ordered list of all uri parameters including those which are not described in the `uriParameters` node.
     * Consider a fragment of RAML specification:
     * ```yaml
     * /resource/{objectId}/{propertyId}:
     * uriParameters:
     * objectId:
     * ```
     * Here `propertyId` uri parameter is not described in the `uriParameters` node,
     * but it is among Resource.allUriParameters().
     * @deprecated
     **/
    ResourceBaseImpl.prototype.allUriParameters = function () {
        return helper.uriParameters(this);
    };
    /**
     * Returns security schemes, resource or method is secured with. If no security schemes are set at resource or method level,
     * returns schemes defined with `securedBy` at API level.
     * @deprecated
     **/
    ResourceBaseImpl.prototype.allSecuredBy = function () {
        return helper.allSecuredBy(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    ResourceBaseImpl.prototype.scalarsAnnotations = function () { return new ResourceBaseScalarsAnnotationsImpl(this.highLevel()); };
    return ResourceBaseImpl;
}(AnnotableImpl));
exports.ResourceBaseImpl = ResourceBaseImpl;
var ResourceImpl = (function (_super) {
    __extends(ResourceImpl, _super);
    function ResourceImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createResource(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Relative URL of this resource from the parent resource
     **/
    ResourceImpl.prototype.relativeUri = function () {
        return _super.prototype.attribute.call(this, 'relativeUri', function (attr) { return new RelativeUriStringImpl(attr); });
    };
    /**
     * The displayName attribute specifies the resource display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    ResourceImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    ResourceImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * A nested resource is identified as any property whose name begins with a slash ("/") and is therefore treated as a relative URI.
     **/
    ResourceImpl.prototype.resources = function () {
        return _super.prototype.elements.call(this, 'resources');
    };
    /**
     * A longer, human-friendly description of the resource.
     **/
    ResourceImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    ResourceImpl.prototype.annotations = function () {
        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResourceImpl.prototype.wrapperClassName = function () { return "ResourceImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResourceImpl.prototype.kind = function () { return "Resource"; };
    /**
     * @return RAML version of the node
     **/
    ResourceImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Path relative to API root
     **/
    ResourceImpl.prototype.completeRelativeUri = function () {
        return helper.completeRelativeUri(this);
    };
    /**
     * baseUri of owning Api concatenated with completeRelativeUri
     **/
    ResourceImpl.prototype.absoluteUri = function () {
        return helper.absoluteUri(this);
    };
    /**
     * Parent resource for non top level resources
     **/
    ResourceImpl.prototype.parentResource = function () {
        return helper.parent(this);
    };
    /**
     * Get child resource by its relative path
     **/
    ResourceImpl.prototype.childResource = function (relPath) {
        return helper.childResource(this, relPath);
    };
    /**
     * Get child method by its name
     **/
    ResourceImpl.prototype.childMethod = function (method) {
        return helper.childMethod(this, method);
    };
    /**
     * Api owning the resource as a sibling
     **/
    ResourceImpl.prototype.ownerApi = function () {
        return helper.ownerApi(this);
    };
    /**
     * Retrieve an ordered list of all absolute uri parameters. Returns a union of `Api.baseUriParameters()`
     * for `Api` owning the `Resource` and `Resource.uriParameters()`.
     **/
    ResourceImpl.prototype.absoluteUriParameters = function () {
        return helper.absoluteUriParameters(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    ResourceImpl.prototype.scalarsAnnotations = function () { return new ResourceScalarsAnnotationsImpl(this.highLevel()); };
    return ResourceImpl;
}(ResourceBaseImpl));
exports.ResourceImpl = ResourceImpl;
/**
 * ResourceBase scalar properties annotations accessor
 **/
var ResourceBaseScalarsAnnotationsImpl = (function (_super) {
    __extends(ResourceBaseScalarsAnnotationsImpl, _super);
    function ResourceBaseScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * ResourceBase.is annotations
     **/
    ResourceBaseScalarsAnnotationsImpl.prototype.is = function () {
        var attrs = this.node.attributes("is");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * ResourceBase.type annotations
     **/
    ResourceBaseScalarsAnnotationsImpl.prototype["type"] = function () {
        var attr = this.node.attr("type");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ResourceBase.description annotations
     **/
    ResourceBaseScalarsAnnotationsImpl.prototype.description = function () {
        var attr = this.node.attr("description");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ResourceBase.securedBy annotations
     **/
    ResourceBaseScalarsAnnotationsImpl.prototype.securedBy = function () {
        var attrs = this.node.attributes("securedBy");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return ResourceBaseScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.ResourceBaseScalarsAnnotationsImpl = ResourceBaseScalarsAnnotationsImpl;
/**
 * Resource scalar properties annotations accessor
 **/
var ResourceScalarsAnnotationsImpl = (function (_super) {
    __extends(ResourceScalarsAnnotationsImpl, _super);
    function ResourceScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Resource.displayName annotations
     **/
    ResourceScalarsAnnotationsImpl.prototype.displayName = function () {
        var attr = this.node.attr("displayName");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Resource.description annotations
     **/
    ResourceScalarsAnnotationsImpl.prototype.description = function () {
        var attr = this.node.attr("description");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Resource.annotations annotations
     **/
    ResourceScalarsAnnotationsImpl.prototype.annotations = function () {
        var attrs = this.node.attributes("annotations");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return ResourceScalarsAnnotationsImpl;
}(ResourceBaseScalarsAnnotationsImpl));
exports.ResourceScalarsAnnotationsImpl = ResourceScalarsAnnotationsImpl;
var ResourceTypeImpl = (function (_super) {
    __extends(ResourceTypeImpl, _super);
    function ResourceTypeImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createResourceType(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * The displayName attribute specifies the resource type display name. It is a friendly name used only for  display or documentation purposes. If displayName is not specified, it defaults to the element's key (the name of the property itself).
     **/
    ResourceTypeImpl.prototype.displayName = function () {
        return _super.prototype.attribute.call(this, 'displayName', this.toString);
    };
    /**
     * @hidden
     * Set displayName value
     **/
    ResourceTypeImpl.prototype.setDisplayName = function (param) {
        this.highLevel().attrOrCreate("displayName").setValue("" + param);
        return this;
    };
    /**
     * Name of the resource type
     **/
    ResourceTypeImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    ResourceTypeImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * Instructions on how and when the resource type should be used.
     **/
    ResourceTypeImpl.prototype.usage = function () {
        return _super.prototype.attribute.call(this, 'usage', this.toString);
    };
    /**
     * @hidden
     * Set usage value
     **/
    ResourceTypeImpl.prototype.setUsage = function (param) {
        this.highLevel().attrOrCreate("usage").setValue("" + param);
        return this;
    };
    ResourceTypeImpl.prototype.uses = function () {
        return _super.prototype.elements.call(this, 'uses');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ResourceTypeImpl.prototype.wrapperClassName = function () { return "ResourceTypeImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ResourceTypeImpl.prototype.kind = function () { return "ResourceType"; };
    /**
     * @return RAML version of the node
     **/
    ResourceTypeImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    ResourceTypeImpl.prototype.parametrizedProperties = function () {
        return helper.getTemplateParametrizedProperties(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    ResourceTypeImpl.prototype.scalarsAnnotations = function () { return new ResourceTypeScalarsAnnotationsImpl(this.highLevel()); };
    return ResourceTypeImpl;
}(ResourceBaseImpl));
exports.ResourceTypeImpl = ResourceTypeImpl;
/**
 * ResourceType scalar properties annotations accessor
 **/
var ResourceTypeScalarsAnnotationsImpl = (function (_super) {
    __extends(ResourceTypeScalarsAnnotationsImpl, _super);
    function ResourceTypeScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * ResourceType.displayName annotations
     **/
    ResourceTypeScalarsAnnotationsImpl.prototype.displayName = function () {
        var attr = this.node.attr("displayName");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * ResourceType.usage annotations
     **/
    ResourceTypeScalarsAnnotationsImpl.prototype.usage = function () {
        var attr = this.node.attr("usage");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return ResourceTypeScalarsAnnotationsImpl;
}(ResourceBaseScalarsAnnotationsImpl));
exports.ResourceTypeScalarsAnnotationsImpl = ResourceTypeScalarsAnnotationsImpl;
/**
 * Annotations allow you to attach information to your API
 **/
var AnnotationRefImpl = (function (_super) {
    __extends(AnnotationRefImpl, _super);
    function AnnotationRefImpl() {
        _super.apply(this, arguments);
    }
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    AnnotationRefImpl.prototype.wrapperClassName = function () { return "AnnotationRefImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    AnnotationRefImpl.prototype.kind = function () { return "AnnotationRef"; };
    /**
     * @return RAML version of the node
     **/
    AnnotationRefImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    AnnotationRefImpl.prototype.annotation = function () {
        return helper.referencedAnnotation(this);
    };
    return AnnotationRefImpl;
}(ReferenceImpl));
exports.AnnotationRefImpl = AnnotationRefImpl;
var DocumentationItemImpl = (function (_super) {
    __extends(DocumentationItemImpl, _super);
    function DocumentationItemImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createDocumentationItem(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Title of documentation section
     **/
    DocumentationItemImpl.prototype.title = function () {
        return _super.prototype.attribute.call(this, 'title', this.toString);
    };
    /**
     * @hidden
     * Set title value
     **/
    DocumentationItemImpl.prototype.setTitle = function (param) {
        this.highLevel().attrOrCreate("title").setValue("" + param);
        return this;
    };
    /**
     * Content of documentation section
     **/
    DocumentationItemImpl.prototype.content = function () {
        return _super.prototype.attribute.call(this, 'content', function (attr) { return new MarkdownStringImpl(attr); });
    };
    DocumentationItemImpl.prototype.uses = function () {
        return _super.prototype.elements.call(this, 'uses');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    DocumentationItemImpl.prototype.wrapperClassName = function () { return "DocumentationItemImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    DocumentationItemImpl.prototype.kind = function () { return "DocumentationItem"; };
    /**
     * @return RAML version of the node
     **/
    DocumentationItemImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    DocumentationItemImpl.prototype.scalarsAnnotations = function () { return new DocumentationItemScalarsAnnotationsImpl(this.highLevel()); };
    return DocumentationItemImpl;
}(AnnotableImpl));
exports.DocumentationItemImpl = DocumentationItemImpl;
/**
 * DocumentationItem scalar properties annotations accessor
 **/
var DocumentationItemScalarsAnnotationsImpl = (function (_super) {
    __extends(DocumentationItemScalarsAnnotationsImpl, _super);
    function DocumentationItemScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * DocumentationItem.title annotations
     **/
    DocumentationItemScalarsAnnotationsImpl.prototype.title = function () {
        var attr = this.node.attr("title");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * DocumentationItem.content annotations
     **/
    DocumentationItemScalarsAnnotationsImpl.prototype.content = function () {
        var attr = this.node.attr("content");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return DocumentationItemScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.DocumentationItemScalarsAnnotationsImpl = DocumentationItemScalarsAnnotationsImpl;
var FragmentDeclarationImpl = (function (_super) {
    __extends(FragmentDeclarationImpl, _super);
    function FragmentDeclarationImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createFragmentDeclaration(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    FragmentDeclarationImpl.prototype.uses = function () {
        return _super.prototype.elements.call(this, 'uses');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    FragmentDeclarationImpl.prototype.wrapperClassName = function () { return "FragmentDeclarationImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    FragmentDeclarationImpl.prototype.kind = function () { return "FragmentDeclaration"; };
    /**
     * @return RAML version of the node
     **/
    FragmentDeclarationImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    return FragmentDeclarationImpl;
}(AnnotableImpl));
exports.FragmentDeclarationImpl = FragmentDeclarationImpl;
var LibraryBaseImpl = (function (_super) {
    __extends(LibraryBaseImpl, _super);
    function LibraryBaseImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createLibraryBase(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Alias for the equivalent "types" property, for compatibility with RAML 0.8. Deprecated - API definitions should use the "types" property, as the "schemas" alias for that property name may be removed in a future RAML version. The "types" property allows for XML and JSON schemas.
     **/
    LibraryBaseImpl.prototype.schemas = function () {
        return _super.prototype.elements.call(this, 'schemas');
    };
    /**
     * Declarations of (data) types for use within this API
     **/
    LibraryBaseImpl.prototype.types = function () {
        return _super.prototype.elements.call(this, 'types');
    };
    /**
     * Declarations of traits for use within this API
     * @hidden
     **/
    LibraryBaseImpl.prototype.traits_original = function () {
        return _super.prototype.elements.call(this, 'traits');
    };
    /**
     * Declarations of resource types for use within this API
     * @hidden
     **/
    LibraryBaseImpl.prototype.resourceTypes_original = function () {
        return _super.prototype.elements.call(this, 'resourceTypes');
    };
    /**
     * Declarations of annotation types for use by annotations
     **/
    LibraryBaseImpl.prototype.annotationTypes = function () {
        return _super.prototype.elements.call(this, 'annotationTypes');
    };
    /**
     * Declarations of security schemes for use within this API.
     **/
    LibraryBaseImpl.prototype.securitySchemes = function () {
        return _super.prototype.elements.call(this, 'securitySchemes');
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    LibraryBaseImpl.prototype.wrapperClassName = function () { return "LibraryBaseImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    LibraryBaseImpl.prototype.kind = function () { return "LibraryBase"; };
    /**
     * @return RAML version of the node
     **/
    LibraryBaseImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Declarations of traits for use within this API
     **/
    LibraryBaseImpl.prototype.traits = function () {
        return helper.traitsPrimary(this);
    };
    /**
     * Retrieve all traits including those defined in libraries
     * @deprecated
     **/
    LibraryBaseImpl.prototype.allTraits = function () {
        return helper.allTraits(this);
    };
    /**
     * Declarations of resource types for use within this API
     **/
    LibraryBaseImpl.prototype.resourceTypes = function () {
        return helper.resourceTypesPrimary(this);
    };
    /**
     * Retrieve all resource types including those defined in libraries
     * @deprecated
     **/
    LibraryBaseImpl.prototype.allResourceTypes = function () {
        return helper.allResourceTypes(this);
    };
    return LibraryBaseImpl;
}(FragmentDeclarationImpl));
exports.LibraryBaseImpl = LibraryBaseImpl;
var LibraryImpl = (function (_super) {
    __extends(LibraryImpl, _super);
    function LibraryImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createLibrary(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * contains description of why library exist
     **/
    LibraryImpl.prototype.usage = function () {
        return _super.prototype.attribute.call(this, 'usage', this.toString);
    };
    /**
     * @hidden
     * Set usage value
     **/
    LibraryImpl.prototype.setUsage = function (param) {
        this.highLevel().attrOrCreate("usage").setValue("" + param);
        return this;
    };
    /**
     * Namespace which the library is imported under
     **/
    LibraryImpl.prototype.name = function () {
        return _super.prototype.attribute.call(this, 'name', this.toString);
    };
    /**
     * @hidden
     * Set name value
     **/
    LibraryImpl.prototype.setName = function (param) {
        this.highLevel().attrOrCreate("name").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    LibraryImpl.prototype.wrapperClassName = function () { return "LibraryImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    LibraryImpl.prototype.kind = function () { return "Library"; };
    /**
     * @return RAML version of the node
     **/
    LibraryImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    LibraryImpl.prototype.scalarsAnnotations = function () { return new LibraryScalarsAnnotationsImpl(this.highLevel()); };
    return LibraryImpl;
}(LibraryBaseImpl));
exports.LibraryImpl = LibraryImpl;
/**
 * Library scalar properties annotations accessor
 **/
var LibraryScalarsAnnotationsImpl = (function (_super) {
    __extends(LibraryScalarsAnnotationsImpl, _super);
    function LibraryScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Library.usage annotations
     **/
    LibraryScalarsAnnotationsImpl.prototype.usage = function () {
        var attr = this.node.attr("usage");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return LibraryScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.LibraryScalarsAnnotationsImpl = LibraryScalarsAnnotationsImpl;
var ApiImpl = (function (_super) {
    __extends(ApiImpl, _super);
    function ApiImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createApi(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * Short plain-text label for the API
     **/
    ApiImpl.prototype.title = function () {
        return _super.prototype.attribute.call(this, 'title', this.toString);
    };
    /**
     * @hidden
     * Set title value
     **/
    ApiImpl.prototype.setTitle = function (param) {
        this.highLevel().attrOrCreate("title").setValue("" + param);
        return this;
    };
    /**
     * A longer, human-friendly description of the API
     **/
    ApiImpl.prototype.description = function () {
        return _super.prototype.attribute.call(this, 'description', function (attr) { return new MarkdownStringImpl(attr); });
    };
    /**
     * The version of the API, e.g. 'v1'
     **/
    ApiImpl.prototype.version = function () {
        return _super.prototype.attribute.call(this, 'version', this.toString);
    };
    /**
     * @hidden
     * Set version value
     **/
    ApiImpl.prototype.setVersion = function (param) {
        this.highLevel().attrOrCreate("version").setValue("" + param);
        return this;
    };
    /**
     * A URI that's to be used as the base of all the resources' URIs. Often used as the base of the URL of each resource, containing the location of the API. Can be a template URI.
     **/
    ApiImpl.prototype.baseUri = function () {
        return _super.prototype.attribute.call(this, 'baseUri', function (attr) { return new FullUriTemplateStringImpl(attr); });
    };
    /**
     * Named parameters used in the baseUri (template)
     * @hidden
     **/
    ApiImpl.prototype.baseUriParameters_original = function () {
        return _super.prototype.elements.call(this, 'baseUriParameters');
    };
    /**
     * The protocols supported by the API
     **/
    ApiImpl.prototype.protocols = function () {
        return _super.prototype.attributes.call(this, 'protocols', this.toString);
    };
    /**
     * @hidden
     * Set protocols value
     **/
    ApiImpl.prototype.setProtocols = function (param) {
        this.highLevel().attrOrCreate("protocols").setValue("" + param);
        return this;
    };
    /**
     * The default media type to use for request and response bodies (payloads), e.g. "application/json"
     **/
    ApiImpl.prototype.mediaType = function () {
        return _super.prototype.attributes.call(this, 'mediaType', function (attr) { return new MimeTypeImpl(attr); });
    };
    /**
     * The security schemes that apply to every resource and method in the API
     **/
    ApiImpl.prototype.securedBy = function () {
        return _super.prototype.attributes.call(this, 'securedBy', function (attr) { return new SecuritySchemeRefImpl(attr); });
    };
    /**
     * The resources of the API, identified as relative URIs that begin with a slash (/). Every property whose key begins with a slash (/), and is either at the root of the API definition or is the child property of a resource property, is a resource property, e.g.: /users, /{groupId}, etc
     **/
    ApiImpl.prototype.resources = function () {
        return _super.prototype.elements.call(this, 'resources');
    };
    /**
     * Additional overall documentation for the API
     **/
    ApiImpl.prototype.documentation = function () {
        return _super.prototype.elements.call(this, 'documentation');
    };
    /**
     * Most of RAML model elements may have attached annotations decribing additional meta data about this element
     **/
    ApiImpl.prototype.annotations = function () {
        return _super.prototype.attributes.call(this, 'annotations', function (attr) { return new AnnotationRefImpl(attr); });
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ApiImpl.prototype.wrapperClassName = function () { return "ApiImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ApiImpl.prototype.kind = function () { return "Api"; };
    /**
     * @return RAML version of the node
     * @hidden
     **/
    ApiImpl.prototype.RAMLVersion_original = function () { return "RAML10"; };
    /**
     * Equivalent API with traits and resource types expanded
     * @expLib whether to apply library expansion or not
     **/
    ApiImpl.prototype.expand = function (expLib) {
        if (expLib === void 0) { expLib = false; }
        return helper.expandSpec(this, expLib);
    };
    /**
     * Get child resource by its relative path
     **/
    ApiImpl.prototype.childResource = function (relPath) {
        return helper.childResource(this, relPath);
    };
    /**
     * Retrieve all resources of the Api
     **/
    ApiImpl.prototype.allResources = function () {
        return helper.allResources(this);
    };
    /**
     * Named parameters used in the baseUri (template)
     **/
    ApiImpl.prototype.baseUriParameters = function () {
        return helper.baseUriParametersPrimary(this);
    };
    /**
     * Retrieve an ordered list of all base uri parameters regardless of whether they are described in `baseUriParameters` or not
     * Consider a fragment of RAML specification:
     * ```yaml
     * version: v1
     * baseUri: https://{organization}.example.com/{version}/{service}
     * baseUriParameters:
     * service:
     * ```
     * Here `version` and `organization` are base uri parameters which are not described in the `baseUriParameters` node,
     * but they are among `Api.allBaseUriParameters()`.
     * @deprecated
     **/
    ApiImpl.prototype.allBaseUriParameters = function () {
        return helper.baseUriParameters(this);
    };
    /**
     * Protocols used by the API. Returns the `protocols` property value if it is specified.
     * Otherwise, returns protocol, specified in the base URI.
     * @deprecated
     **/
    ApiImpl.prototype.allProtocols = function () {
        return helper.allProtocols(this);
    };
    /**
     * @return RAML version of the node
     **/
    ApiImpl.prototype.RAMLVersion = function () {
        return helper.RAMLVersion(this);
    };
    /**
     * Scalar properties annotations accessor
     **/
    ApiImpl.prototype.scalarsAnnotations = function () { return new ApiScalarsAnnotationsImpl(this.highLevel()); };
    return ApiImpl;
}(LibraryBaseImpl));
exports.ApiImpl = ApiImpl;
var OverlayImpl = (function (_super) {
    __extends(OverlayImpl, _super);
    function OverlayImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createOverlay(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * contains description of why overlay exist
     **/
    OverlayImpl.prototype.usage = function () {
        return _super.prototype.attribute.call(this, 'usage', this.toString);
    };
    /**
     * @hidden
     * Set usage value
     **/
    OverlayImpl.prototype.setUsage = function (param) {
        this.highLevel().attrOrCreate("usage").setValue("" + param);
        return this;
    };
    /**
     * Location of a valid RAML API definition (or overlay or extension), the overlay is applied to.
     **/
    OverlayImpl.prototype.extends = function () {
        return _super.prototype.attribute.call(this, 'extends', this.toString);
    };
    /**
     * @hidden
     * Set extends value
     **/
    OverlayImpl.prototype.setExtends = function (param) {
        this.highLevel().attrOrCreate("extends").setValue("" + param);
        return this;
    };
    /**
     * Short plain-text label for the API
     **/
    OverlayImpl.prototype.title = function () {
        return _super.prototype.attribute.call(this, 'title', this.toString);
    };
    /**
     * @hidden
     * Set title value
     **/
    OverlayImpl.prototype.setTitle = function (param) {
        this.highLevel().attrOrCreate("title").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    OverlayImpl.prototype.wrapperClassName = function () { return "OverlayImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    OverlayImpl.prototype.kind = function () { return "Overlay"; };
    /**
     * @return RAML version of the node
     **/
    OverlayImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    OverlayImpl.prototype.scalarsAnnotations = function () { return new OverlayScalarsAnnotationsImpl(this.highLevel()); };
    return OverlayImpl;
}(ApiImpl));
exports.OverlayImpl = OverlayImpl;
/**
 * Api scalar properties annotations accessor
 **/
var ApiScalarsAnnotationsImpl = (function (_super) {
    __extends(ApiScalarsAnnotationsImpl, _super);
    function ApiScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Api.title annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.title = function () {
        var attr = this.node.attr("title");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Api.description annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.description = function () {
        var attr = this.node.attr("description");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Api.version annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.version = function () {
        var attr = this.node.attr("version");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Api.baseUri annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.baseUri = function () {
        var attr = this.node.attr("baseUri");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Api.protocols annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.protocols = function () {
        var attrs = this.node.attributes("protocols");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * Api.mediaType annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.mediaType = function () {
        var attrs = this.node.attributes("mediaType");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * Api.securedBy annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.securedBy = function () {
        var attrs = this.node.attributes("securedBy");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    /**
     * Api.annotations annotations
     **/
    ApiScalarsAnnotationsImpl.prototype.annotations = function () {
        var attrs = this.node.attributes("annotations");
        return attrs.map(function (x) {
            var annotationAttrs = x.annotations();
            var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
            return result;
        });
    };
    return ApiScalarsAnnotationsImpl;
}(AnnotableScalarsAnnotationsImpl));
exports.ApiScalarsAnnotationsImpl = ApiScalarsAnnotationsImpl;
/**
 * Overlay scalar properties annotations accessor
 **/
var OverlayScalarsAnnotationsImpl = (function (_super) {
    __extends(OverlayScalarsAnnotationsImpl, _super);
    function OverlayScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Overlay.usage annotations
     **/
    OverlayScalarsAnnotationsImpl.prototype.usage = function () {
        var attr = this.node.attr("usage");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Overlay.extends annotations
     **/
    OverlayScalarsAnnotationsImpl.prototype.extends = function () {
        var attr = this.node.attr("extends");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Overlay.title annotations
     **/
    OverlayScalarsAnnotationsImpl.prototype.title = function () {
        var attr = this.node.attr("title");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return OverlayScalarsAnnotationsImpl;
}(ApiScalarsAnnotationsImpl));
exports.OverlayScalarsAnnotationsImpl = OverlayScalarsAnnotationsImpl;
var ExtensionImpl = (function (_super) {
    __extends(ExtensionImpl, _super);
    function ExtensionImpl(nodeOrKey, setAsTopLevel) {
        if (setAsTopLevel === void 0) { setAsTopLevel = true; }
        _super.call(this, (typeof nodeOrKey == "string") ? createExtension(nodeOrKey) : nodeOrKey, setAsTopLevel);
        this.nodeOrKey = nodeOrKey;
        this.setAsTopLevel = setAsTopLevel;
    }
    /**
     * contains description of why extension exist
     **/
    ExtensionImpl.prototype.usage = function () {
        return _super.prototype.attribute.call(this, 'usage', this.toString);
    };
    /**
     * @hidden
     * Set usage value
     **/
    ExtensionImpl.prototype.setUsage = function (param) {
        this.highLevel().attrOrCreate("usage").setValue("" + param);
        return this;
    };
    /**
     * Location of a valid RAML API definition (or overlay or extension), the extension is applied to
     **/
    ExtensionImpl.prototype.extends = function () {
        return _super.prototype.attribute.call(this, 'extends', this.toString);
    };
    /**
     * @hidden
     * Set extends value
     **/
    ExtensionImpl.prototype.setExtends = function (param) {
        this.highLevel().attrOrCreate("extends").setValue("" + param);
        return this;
    };
    /**
     * Short plain-text label for the API
     **/
    ExtensionImpl.prototype.title = function () {
        return _super.prototype.attribute.call(this, 'title', this.toString);
    };
    /**
     * @hidden
     * Set title value
     **/
    ExtensionImpl.prototype.setTitle = function (param) {
        this.highLevel().attrOrCreate("title").setValue("" + param);
        return this;
    };
    /**
     * @hidden
     * @return Actual name of instance class
     **/
    ExtensionImpl.prototype.wrapperClassName = function () { return "ExtensionImpl"; };
    /**
     * @return Actual name of instance interface
     **/
    ExtensionImpl.prototype.kind = function () { return "Extension"; };
    /**
     * @return RAML version of the node
     **/
    ExtensionImpl.prototype.RAMLVersion = function () { return "RAML10"; };
    /**
     * Scalar properties annotations accessor
     **/
    ExtensionImpl.prototype.scalarsAnnotations = function () { return new ExtensionScalarsAnnotationsImpl(this.highLevel()); };
    return ExtensionImpl;
}(ApiImpl));
exports.ExtensionImpl = ExtensionImpl;
/**
 * Extension scalar properties annotations accessor
 **/
var ExtensionScalarsAnnotationsImpl = (function (_super) {
    __extends(ExtensionScalarsAnnotationsImpl, _super);
    function ExtensionScalarsAnnotationsImpl() {
        _super.apply(this, arguments);
    }
    /**
     * Extension.usage annotations
     **/
    ExtensionScalarsAnnotationsImpl.prototype.usage = function () {
        var attr = this.node.attr("usage");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Extension.extends annotations
     **/
    ExtensionScalarsAnnotationsImpl.prototype.extends = function () {
        var attr = this.node.attr("extends");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    /**
     * Extension.title annotations
     **/
    ExtensionScalarsAnnotationsImpl.prototype.title = function () {
        var attr = this.node.attr("title");
        if (attr == null) {
            return [];
        }
        var annotationAttrs = attr.annotations();
        var result = core.attributesToValues(annotationAttrs, function (a) { return new AnnotationRefImpl(a); });
        return result;
    };
    return ExtensionScalarsAnnotationsImpl;
}(ApiScalarsAnnotationsImpl));
exports.ExtensionScalarsAnnotationsImpl = ExtensionScalarsAnnotationsImpl;
/**
 * @hidden
 **/
function createApi(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Api");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createLibraryBase(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("LibraryBase");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createFragmentDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("FragmentDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createAnnotable(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Annotable");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTypeInstance(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("TypeInstance");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTypeInstanceProperty(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("TypeInstanceProperty");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTrait(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Trait");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createMethodBase(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("MethodBase");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOperation(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Operation");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("TypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createExampleSpec(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("ExampleSpec");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createUsesDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("UsesDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createXMLFacetInfo(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("XMLFacetInfo");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createArrayTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("ArrayTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createUnionTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("UnionTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createObjectTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("ObjectTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createStringTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("StringTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createBooleanTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("BooleanTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createNumberTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("NumberTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createIntegerTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("IntegerTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDateOnlyTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("DateOnlyTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createTimeOnlyTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("TimeOnlyTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDateTimeOnlyTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("DateTimeOnlyTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDateTimeTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("DateTimeTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createFileTypeDeclaration(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("FileTypeDeclaration");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createResponse(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Response");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createSecuritySchemePart(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("SecuritySchemePart");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createAbstractSecurityScheme(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("AbstractSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createSecuritySchemeSettings(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("SecuritySchemeSettings");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth1SecuritySchemeSettings(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("OAuth1SecuritySchemeSettings");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth2SecuritySchemeSettings(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("OAuth2SecuritySchemeSettings");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth2SecurityScheme(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("OAuth2SecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOAuth1SecurityScheme(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("OAuth1SecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createPassThroughSecurityScheme(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("PassThroughSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createBasicSecurityScheme(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("BasicSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDigestSecurityScheme(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("DigestSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createCustomSecurityScheme(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("CustomSecurityScheme");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createMethod(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Method");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createResourceType(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("ResourceType");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createResourceBase(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("ResourceBase");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createResource(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Resource");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createDocumentationItem(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("DocumentationItem");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createLibrary(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Library");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createOverlay(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Overlay");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
/**
 * @hidden
 **/
function createExtension(key) {
    var universe = def.getUniverse("RAML10");
    var nc = universe.type("Extension");
    var node = stubs.createStubNode(nc, null, key);
    return node;
}
function loadApiSync(apiPath, arg1, arg2) {
    return apiLoader.loadApi(apiPath, arg1, arg2).getOrElse(null);
}
exports.loadApiSync = loadApiSync;
function loadRAMLSync(ramlPath, arg1, arg2) {
    return apiLoader.loadApi(ramlPath, arg1, arg2).getOrElse(null);
}
exports.loadRAMLSync = loadRAMLSync;
function loadApi(apiPath, arg1, arg2) {
    return apiLoader.loadApiAsync(apiPath, arg1, arg2);
}
exports.loadApi = loadApi;
function loadRAML(ramlPath, arg1, arg2) {
    return apiLoader.loadRAMLAsync(ramlPath, arg1, arg2);
}
exports.loadRAML = loadRAML;
/**
 * Gets AST node by runtime type, if runtime type matches any.
 * @param runtimeType - runtime type to find the match for
 */
function getLanguageElementByRuntimeType(runtimeType) {
    return apiLoader.getLanguageElementByRuntimeType(runtimeType);
}
exports.getLanguageElementByRuntimeType = getLanguageElementByRuntimeType;
//# sourceMappingURL=raml10parser.js.map