
import ll = require("../lowLevelAST");
import hl = require("../highLevelAST");
import yaml = require("yaml-ast-parser");
import refResolvers = require("../jsyaml/includeRefResolvers");
export declare class LowLevelProxyNode implements ll.ILowLevelASTNode {
    protected _parent: ll.ILowLevelASTNode;
    protected _transformer: ValueTransformer;
    protected ramlVersion: string;
    constructor(_parent: ll.ILowLevelASTNode, _transformer: ValueTransformer, ramlVersion: string);
    protected _originalNode: ll.ILowLevelASTNode;
    private _highLevelNode;
    private _highLevelParseResult;
    protected _keyOverride: string;
    protected _valueOverride: string;
    hasInnerIncludeError(): boolean;
    keyKind(): yaml.Kind;
    primaryNode(): ll.ILowLevelASTNode;
    isAnnotatedScalar(): boolean;
    actual(): any;
    transformer(): ValueTransformer;
    originalNode(): ll.ILowLevelASTNode;
    start(): number;
    end(): number;
    value(toString?: boolean): any;
    includeErrors(): string[];
    includePath(): string;
    includeReference(): refResolvers.IncludeReference;
    setKeyOverride(_key: string): void;
    setValueOverride(value: any): void;
    key(raw?: boolean): string;
    optional(): boolean;
    children(): ll.ILowLevelASTNode[];
    parent(): ll.ILowLevelASTNode;
    unit(): ll.ICompilationUnit;
    includeBaseUnit(): ll.ICompilationUnit;
    anchorId(): string;
    errors(): Error[];
    anchoredFrom(): ll.ILowLevelASTNode;
    includedFrom(): ll.ILowLevelASTNode;
    visit(v: ll.ASTVisitor): void;
    addChild(n: ll.ILowLevelASTNode): void;
    execute(cmd: ll.CompositeCommand): void;
    dump(): string;
    dumpToObject(): any;
    keyStart(): number;
    keyEnd(): number;
    valueStart(): number;
    valueEnd(): number;
    isValueLocal(): boolean;
    kind(): yaml.Kind;
    valueKind(): yaml.Kind;
    anchorValueKind(): yaml.Kind;
    show(msg: string): void;
    setHighLevelParseResult(highLevelParseResult: hl.IParseResult): void;
    highLevelParseResult(): hl.IParseResult;
    setHighLevelNode(highLevel: hl.IHighLevelNode): void;
    highLevelNode(): hl.IHighLevelNode;
    text(unitText: string): string;
    copy(): LowLevelCompositeNode;
    markup(json?: boolean): string;
    nodeDefinition(): hl.INodeDefinition;
    includesContents(): boolean;
}
export declare class LowLevelCompositeNode extends LowLevelProxyNode {
    private isPrimary;
    constructor(node: ll.ILowLevelASTNode, parent: LowLevelCompositeNode, transformer: ValueTransformer, ramlVersion: string, isPrimary?: boolean);
    protected _adoptedNodes: LowLevelValueTransformingNode[];
    protected _children: LowLevelCompositeNode[];
    protected _preserveAnnotations: boolean;
    protected isInsideResource: boolean;
    adoptedNodes(): ll.ILowLevelASTNode[];
    primaryNode(): LowLevelValueTransformingNode;
    parent(): LowLevelCompositeNode;
    adopt(node: ll.ILowLevelASTNode, transformer: ValueTransformer): void;
    value(toString?: boolean): any;
    children(): ll.ILowLevelASTNode[];
    private buildKey(y);
    private collectChildrenWithKeys();
    private isResource();
    private skipKey(key, isPrimary);
    valueKind(): yaml.Kind;
    includePath(): string;
    includeBaseUnit(): ll.ICompilationUnit;
    includeReference(): refResolvers.IncludeReference;
    optional(): boolean;
    replaceChild(oldNode: ll.ILowLevelASTNode, newNode: ll.ILowLevelASTNode, isPrimary?: boolean, transformer?: ValueTransformer): LowLevelCompositeNode;
    removeChild(oldNode: ll.ILowLevelASTNode): LowLevelCompositeNode;
    setChildren(nodes: ll.ILowLevelASTNode[]): LowLevelCompositeNode;
    preserveAnnotations(): void;
    filterChildren(): void;
}
export declare class LowLevelValueTransformingNode extends LowLevelProxyNode {
    constructor(node: ll.ILowLevelASTNode, parent: ll.ILowLevelASTNode, transformer: ValueTransformer, ramlVersion: string);
    value(toString?: boolean): any;
    children(): LowLevelValueTransformingNode[];
    valueKind(): yaml.Kind;
    parent(): LowLevelValueTransformingNode;
    key(raw?: boolean): string;
}
export interface ValueTransformer {
    transform(value: any, toString?: boolean): {
        value: any;
        errors: hl.ValidationIssue[];
    };
    children(node: ll.ILowLevelASTNode): ll.ILowLevelASTNode[];
    valueKind(node: ll.ILowLevelASTNode): yaml.Kind;
}
