"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var yaml = require("yaml-ast-parser");
var json = require("../jsyaml/json2lowLevel");
var stringify = require("json-stable-stringify");
var impl = require("../jsyaml/jsyaml2lowLevel");
var util = require("../../util/index");
var universes = require("../tools/universe");
var def = require("raml-definition-system");
var universeHelpers = require("../tools/universeHelpers");
var _ = require("underscore");
var LowLevelProxyNode = (function () {
    function LowLevelProxyNode(_parent, _transformer, ramlVersion) {
        this._parent = _parent;
        this._transformer = _transformer;
        this.ramlVersion = ramlVersion;
    }
    LowLevelProxyNode.prototype.hasInnerIncludeError = function () {
        return this._originalNode.hasInnerIncludeError();
    };
    LowLevelProxyNode.prototype.keyKind = function () {
        return this._originalNode.keyKind();
    };
    LowLevelProxyNode.prototype.primaryNode = function () {
        return null;
    };
    LowLevelProxyNode.prototype.isAnnotatedScalar = function () {
        return this._originalNode.isAnnotatedScalar();
    };
    LowLevelProxyNode.prototype.actual = function () {
        if (this._originalNode) {
            return this._originalNode.actual();
        }
        return this;
    };
    LowLevelProxyNode.prototype.transformer = function () { return this._transformer; };
    LowLevelProxyNode.prototype.originalNode = function () {
        return this._originalNode;
    };
    LowLevelProxyNode.prototype.start = function () { return this._originalNode.start(); };
    LowLevelProxyNode.prototype.end = function () { return this._originalNode.end(); };
    LowLevelProxyNode.prototype.value = function (toString) {
        throw new Error('The method must be overridden');
    };
    LowLevelProxyNode.prototype.includeErrors = function () { return this._originalNode.includeErrors(); };
    LowLevelProxyNode.prototype.includePath = function () { return this._originalNode.includePath(); };
    LowLevelProxyNode.prototype.includeReference = function () { return this._originalNode.includeReference(); };
    LowLevelProxyNode.prototype.setKeyOverride = function (_key) {
        this._keyOverride = _key;
    };
    LowLevelProxyNode.prototype.setValueOverride = function (value) {
        this._valueOverride = value;
    };
    LowLevelProxyNode.prototype.key = function (raw) {
        if (raw === void 0) { raw = false; }
        if (this._keyOverride) {
            return this._keyOverride;
        }
        return this._originalNode.key(raw);
    };
    LowLevelProxyNode.prototype.optional = function () {
        return this.originalNode().optional();
    };
    LowLevelProxyNode.prototype.children = function () {
        throw new Error('The method must be overridden');
    };
    LowLevelProxyNode.prototype.parent = function () { return this._parent; };
    LowLevelProxyNode.prototype.unit = function () { return this._originalNode.unit(); };
    LowLevelProxyNode.prototype.includeBaseUnit = function () { return this._originalNode.unit(); };
    LowLevelProxyNode.prototype.anchorId = function () { return this._originalNode.anchorId(); };
    LowLevelProxyNode.prototype.errors = function () { return this._originalNode.errors(); };
    LowLevelProxyNode.prototype.anchoredFrom = function () { return this._originalNode.anchoredFrom(); };
    LowLevelProxyNode.prototype.includedFrom = function () { return this._originalNode.includedFrom(); };
    LowLevelProxyNode.prototype.visit = function (v) {
        if (v(this)) {
            this.children().forEach(function (x) { return x.visit(v); });
        }
    };
    //TODO
    LowLevelProxyNode.prototype.addChild = function (n) { };
    //TODO
    LowLevelProxyNode.prototype.execute = function (cmd) { };
    //TODO
    LowLevelProxyNode.prototype.dump = function () { return null; };
    LowLevelProxyNode.prototype.dumpToObject = function () {
        var serialized = json.serialize2(this, false);
        //var serialized = json.serialize(this);
        if (this.kind() == yaml.Kind.MAPPING) {
            var obj = {};
            obj[this.key(true)] = serialized;
            return obj;
        }
        return serialized;
    };
    LowLevelProxyNode.prototype.keyStart = function () { return this._originalNode.keyStart(); };
    LowLevelProxyNode.prototype.keyEnd = function () { return this._originalNode.keyEnd(); };
    LowLevelProxyNode.prototype.valueStart = function () { return this._originalNode.valueStart(); };
    LowLevelProxyNode.prototype.valueEnd = function () { return this._originalNode.valueEnd(); };
    LowLevelProxyNode.prototype.isValueLocal = function () { return this._originalNode.isValueLocal(); };
    LowLevelProxyNode.prototype.kind = function () { return this._originalNode.kind(); };
    LowLevelProxyNode.prototype.valueKind = function () { return this._originalNode.valueKind(); };
    LowLevelProxyNode.prototype.anchorValueKind = function () { return this._originalNode.anchorValueKind(); };
    LowLevelProxyNode.prototype.show = function (msg) { this._originalNode.show(msg); };
    LowLevelProxyNode.prototype.setHighLevelParseResult = function (highLevelParseResult) {
        this._highLevelParseResult = highLevelParseResult;
    };
    LowLevelProxyNode.prototype.highLevelParseResult = function () {
        return this._highLevelParseResult;
    };
    LowLevelProxyNode.prototype.setHighLevelNode = function (highLevel) {
        this._highLevelNode = highLevel;
    };
    LowLevelProxyNode.prototype.highLevelNode = function () {
        if (this._highLevelNode) {
            return this._highLevelNode;
        }
        return this._originalNode.highLevelNode();
    };
    LowLevelProxyNode.prototype.text = function (unitText) {
        throw new Error("not implemented");
    };
    LowLevelProxyNode.prototype.copy = function () {
        throw new Error("not implemented");
    };
    LowLevelProxyNode.prototype.markup = function (json) {
        throw new Error("not implemented");
    };
    LowLevelProxyNode.prototype.nodeDefinition = function () {
        return impl.getDefinitionForLowLevelNode(this);
    };
    LowLevelProxyNode.prototype.includesContents = function () {
        return this._originalNode.includesContents();
    };
    return LowLevelProxyNode;
}());
exports.LowLevelProxyNode = LowLevelProxyNode;
var LowLevelCompositeNode = (function (_super) {
    __extends(LowLevelCompositeNode, _super);
    function LowLevelCompositeNode(node, parent, transformer, ramlVersion, isPrimary) {
        if (isPrimary === void 0) { isPrimary = true; }
        _super.call(this, parent, transformer, ramlVersion);
        this.isPrimary = isPrimary;
        //Colliding nodes of the initioal AST
        this._adoptedNodes = [];
        this._preserveAnnotations = false;
        var originalParent = this.parent() ? this.parent().originalNode() : null;
        if (node instanceof LowLevelValueTransformingNode) {
            this._originalNode = node;
        }
        else {
            this._originalNode = new LowLevelValueTransformingNode(node, originalParent, transformer, this.ramlVersion);
        }
        this._adoptedNodes.push(this._originalNode);
    }
    LowLevelCompositeNode.prototype.adoptedNodes = function () {
        return this._adoptedNodes;
    };
    LowLevelCompositeNode.prototype.primaryNode = function () {
        return this.isPrimary ? this._originalNode : null;
    };
    LowLevelCompositeNode.prototype.parent = function () { return this._parent; };
    LowLevelCompositeNode.prototype.adopt = function (node, transformer) {
        if (!transformer) {
            transformer = this._transformer;
        }
        var originalParent = this.parent() ? this.parent().originalNode() : null;
        var tNode = new LowLevelValueTransformingNode(node, originalParent, transformer, this.ramlVersion);
        this._adoptedNodes.push(tNode);
        if (this._children) {
            this._children.forEach(function (x) { return x._parent = null; });
        }
        this._children = null;
        if (this.highLevelNode()) {
            this.highLevelNode().resetChildren();
        }
    };
    LowLevelCompositeNode.prototype.value = function (toString) {
        if (this._valueOverride) {
            return this._valueOverride;
        }
        var val;
        var valuableNodes = this._adoptedNodes.filter(function (x) { return x.value() != null; });
        if (valuableNodes.length > 0) {
            val = valuableNodes[0].value(toString);
        }
        else {
            val = this._originalNode.value(toString);
        }
        if (val instanceof LowLevelValueTransformingNode) {
            this._valueOverride = val;
        }
        return val;
    };
    LowLevelCompositeNode.prototype.children = function () {
        var _this = this;
        if (this._children) {
            return this._children;
        }
        var result = [];
        var canBeMap = false;
        var canBeSeq = false;
        for (var _i = 0, _a = this._adoptedNodes; _i < _a.length; _i++) {
            var x = _a[_i];
            var adoptedNodeChildren = x.children();
            if (adoptedNodeChildren && adoptedNodeChildren.length > 0) {
                canBeSeq = true;
                if (adoptedNodeChildren[0].key()) {
                    if (this.originalNode().valueKind() != yaml.Kind.SEQ) {
                        canBeMap = true;
                    }
                }
            }
        }
        if (canBeMap) {
            result = this.collectChildrenWithKeys();
        }
        else if (canBeSeq) {
            result = this.collectChildrenWithKeys();
            var map = {};
            this._adoptedNodes.forEach(function (x) { return x.children().filter(function (y) { return !y.key(); }).forEach(function (y) {
                var isPrimary = x == _this.primaryNode();
                var key = _this.buildKey(y);
                if (!isPrimary && map[key]) {
                    //filtering away values with repeating keys
                    //primary node is not subjected to filtration
                    return;
                }
                map[key] = true;
                var transformer = x.transformer() ? x.transformer() : _this.transformer();
                var ch = (y instanceof LowLevelValueTransformingNode)
                    ? y.originalNode() : y;
                result.push(new LowLevelCompositeNode(ch, _this, transformer, _this.ramlVersion, isPrimary));
            }); });
        }
        else {
            result = [];
        }
        this._children = result;
        return result;
    };
    LowLevelCompositeNode.prototype.buildKey = function (y) {
        var obj = json.serialize(y);
        var def = this.nodeDefinition();
        if (def && (def.key() == universes.Universe08.TraitRef || def.key() == universes.Universe08.ResourceTypeRef
            || def.key() == universes.Universe10.TraitRef || def.key() == universes.Universe10.ResourceTypeRef)) {
            if (obj && typeof obj == 'object') {
                var keys = Object.keys(obj);
                if (keys.length > 0) {
                    obj = keys[0];
                }
            }
        }
        if (obj == null)
            return "";
        return stringify(obj);
    };
    LowLevelCompositeNode.prototype.collectChildrenWithKeys = function () {
        var _this = this;
        var result = [];
        var m = {};
        for (var _i = 0, _a = this._adoptedNodes; _i < _a.length; _i++) {
            var x = _a[_i];
            var isPrimary = x == this.primaryNode();
            for (var _b = 0, _c = x.children(); _b < _c.length; _b++) {
                var y = _c[_b];
                var key = y.originalNode().key();
                if (key && x.transformer()) {
                    var isAnnotation = key != null
                        && (this._preserveAnnotations || this.isResource())
                        && util.stringStartsWith(key, "(")
                        && util.stringEndsWith(key, ")");
                    if (!isAnnotation) {
                        key = x.transformer().transform(key).value;
                    }
                }
                if (this.skipKey(key, isPrimary)) {
                    continue;
                }
                if (!key) {
                    continue;
                }
                var arr = m[key];
                if (!arr) {
                    arr = [];
                    m[key] = arr;
                }
                arr.push({ node: y.originalNode(), transformer: x.transformer(), isPrimary: isPrimary });
            }
        }
        var ramlVersion = this.unit().highLevel().root().definition().universe().version();
        var isResource = this.key() && this.key()[0] == "/";
        var methodType = def.getUniverse("RAML10").type(universes.Universe10.Method.name);
        var options = methodType.property(universes.Universe10.Method.properties.method.name).enumOptions();
        Object.keys(m).forEach(function (key) {
            var arr = m[key];
            var allOptional = true;
            var hasPrimaryChildren = false;
            var isMethod = options.indexOf(key) >= 0;
            arr.forEach(function (x) {
                var isOpt = x.node.optional() &&
                    (ramlVersion != "RAML10" ||
                        (isResource && isMethod));
                allOptional = allOptional && isOpt;
                hasPrimaryChildren = hasPrimaryChildren || x.isPrimary;
            });
            if (hasPrimaryChildren) {
                var primaryChildren = [];
                arr.filter(function (x) { return x.isPrimary; }).forEach(function (x) {
                    var tr = x.transformer ? x.transformer : _this.transformer();
                    primaryChildren.push(new LowLevelCompositeNode(x.node, _this, tr, _this.ramlVersion, true));
                });
                var primaryChild = primaryChildren[0];
                arr.filter(function (x) { return !x.isPrimary; }).forEach(function (x) {
                    primaryChild.adopt(x.node, x.transformer);
                });
                primaryChildren.forEach(function (x) { return result.push(x); });
            }
            else if (!allOptional) {
                var tr = arr[0].transformer ? arr[0].transformer : _this.transformer();
                var primaryChild = new LowLevelCompositeNode(arr[0].node, _this, tr, _this.ramlVersion, false);
                for (var i = 1; i < arr.length; i++) {
                    primaryChild.adopt(arr[i].node, arr[i].transformer);
                }
                result.push(primaryChild);
            }
        });
        return result;
    };
    LowLevelCompositeNode.prototype.isResource = function () {
        return this.highLevelNode() && universeHelpers.isResourceType(this.highLevelNode().definition());
    };
    LowLevelCompositeNode.prototype.skipKey = function (key, isPrimary) {
        if (isPrimary) {
            return false;
        }
        if (this.ramlVersion != 'RAML08') {
            return false;
        }
        var methodDef = universes.Universe08.Method;
        var resourceDef = universes.Universe08.Resource;
        //if(key==hasNormalParametersDef.properties.displayName.name
        //    &&this.highLevelNode().definition().key().name==methodDef.name){
        //    return true;
        //}
        //if(key==resourceDef.properties.displayName.name
        //    &&this.highLevelNode().definition().key().name==resourceDef.name){
        //    return true;
        //}
        return false;
    };
    LowLevelCompositeNode.prototype.valueKind = function () {
        if (this._originalNode.kind() != yaml.Kind.MAPPING) {
            return null;
        }
        for (var i = 0; i < this._adoptedNodes.length; i++) {
            var node = this._adoptedNodes[i];
            var yamlNode = node.originalNode().actual();
            if (yamlNode && yamlNode.value != null) {
                return node.valueKind();
            }
        }
        return null;
    };
    LowLevelCompositeNode.prototype.includePath = function () {
        for (var i = 0; i < this._adoptedNodes.length; i++) {
            var node = this._adoptedNodes[i];
            var includePath = node.includePath();
            if (includePath != null) {
                return includePath;
            }
        }
        return null;
    };
    LowLevelCompositeNode.prototype.includeBaseUnit = function () {
        for (var i = 0; i < this._adoptedNodes.length; i++) {
            var node = this._adoptedNodes[i];
            var includePath = node.includePath();
            if (includePath != null) {
                return node.unit();
            }
        }
        return _super.prototype.includeBaseUnit.call(this);
    };
    LowLevelCompositeNode.prototype.includeReference = function () {
        for (var i = 0; i < this._adoptedNodes.length; i++) {
            var node = this._adoptedNodes[i];
            if (node.value() != null) {
                return node.includeReference();
            }
        }
        return null;
    };
    LowLevelCompositeNode.prototype.optional = function () {
        return _.all(this._adoptedNodes, function (x) { return x.optional(); });
    };
    LowLevelCompositeNode.prototype.replaceChild = function (oldNode, newNode, isPrimary, transformer) {
        if (isPrimary === void 0) { isPrimary = false; }
        if (transformer === void 0) { transformer = null; }
        if (!this._children) {
            this._children = [];
        }
        var newCNode = new LowLevelCompositeNode(newNode, this, null, this.ramlVersion);
        if (oldNode == null) {
            this._children.push(newCNode);
            return newCNode;
        }
        var ind = this._children.indexOf(oldNode);
        if (ind >= 0) {
            this._children[ind] = newCNode;
        }
        else {
            this._children.push(newCNode);
        }
        return newCNode;
    };
    LowLevelCompositeNode.prototype.removeChild = function (oldNode) {
        if (!this._children || oldNode == null) {
            return;
        }
        var ind = this._children.indexOf(oldNode);
        if (ind >= 0) {
            for (var i = ind; i < this._children.length - 1; i++) {
                this._children[i] = this._children[i + 1];
            }
            this._children.pop();
        }
    };
    LowLevelCompositeNode.prototype.setChildren = function (nodes) {
        var _this = this;
        if (nodes == null) {
            this._children = null;
            return;
        }
        this._children = nodes.map(function (x) {
            if (x instanceof LowLevelCompositeNode) {
                return x;
            }
            return new LowLevelCompositeNode(x, _this, null, _this.ramlVersion);
        });
    };
    LowLevelCompositeNode.prototype.preserveAnnotations = function () {
        if (!this._preserveAnnotations) {
            if (this.isInsideResource === undefined) {
                this.isInsideResource = false;
                if (!this.isResource()) {
                    var parent = this._parent;
                    while (parent) {
                        if (parent.isResource()) {
                            this.isInsideResource = true;
                            break;
                        }
                        parent = parent.parent();
                    }
                }
            }
            if (this.isInsideResource) {
                this._preserveAnnotations = true;
                this._children = null;
            }
        }
    };
    LowLevelCompositeNode.prototype.filterChildren = function () {
        this.children();
        var map = {};
        var filtered = [];
        this._children.forEach(function (x) {
            if (x.key() != null) {
                filtered.push(x);
                return;
            }
            var key = JSON.stringify(json.serialize(x));
            if (map[key]) {
                return;
            }
            map[key] = true;
            filtered.push(x);
        });
        this._children = filtered;
    };
    return LowLevelCompositeNode;
}(LowLevelProxyNode));
exports.LowLevelCompositeNode = LowLevelCompositeNode;
var LowLevelValueTransformingNode = (function (_super) {
    __extends(LowLevelValueTransformingNode, _super);
    function LowLevelValueTransformingNode(node, parent, transformer, ramlVersion) {
        _super.call(this, parent, transformer, ramlVersion);
        this._originalNode = node;
    }
    LowLevelValueTransformingNode.prototype.value = function (toString) {
        var val = this.originalNode().value(toString);
        var t = this.transformer();
        if (t) {
            var transformationResult = t.transform(val, toString);
            val = transformationResult.value;
        }
        if (val && typeof val === "object") {
            return new LowLevelValueTransformingNode(val, this._parent, this._transformer, this.ramlVersion);
        }
        return val;
    };
    LowLevelValueTransformingNode.prototype.children = function () {
        var _this = this;
        var childNodes = null;
        var originalNode = this.originalNode();
        if (this._transformer != null) {
            var substitution = this._transformer.children(originalNode);
            if (substitution != null) {
                childNodes = substitution;
            }
        }
        if (childNodes == null) {
            childNodes = originalNode.children();
        }
        return childNodes.map(function (x) { return new LowLevelValueTransformingNode(x, _this, _this._transformer, _this.ramlVersion); });
    };
    LowLevelValueTransformingNode.prototype.valueKind = function () {
        var kind = this._transformer && this._transformer.valueKind(this.originalNode());
        if (kind != null) {
            return kind;
        }
        return _super.prototype.valueKind.call(this);
    };
    LowLevelValueTransformingNode.prototype.parent = function () { return this._parent; };
    LowLevelValueTransformingNode.prototype.key = function (raw) {
        if (raw === void 0) { raw = false; }
        var key = _super.prototype.key.call(this, raw);
        if (this.transformer() != null) {
            return this.transformer().transform(key).value;
        }
        return key;
    };
    return LowLevelValueTransformingNode;
}(LowLevelProxyNode));
exports.LowLevelValueTransformingNode = LowLevelValueTransformingNode;
//# sourceMappingURL=LowLevelASTProxy.js.map