
import ll = require("../lowLevelAST");
import hl = require("../highLevelAST");
import hlimpl = require("../highLevelImpl");
import yaml = require("yaml-ast-parser");
import proxy = require("./LowLevelASTProxy");
import RamlWrapper = require("../artifacts/raml10parserapi");
import RamlWrapper08 = require("../artifacts/raml08parserapi");
import core = require("../wrapped-ast/parserCore");
import referencePatcher = require("./referencePatcher");
export declare function expandTraitsAndResourceTypes<T>(api: T): T;
export declare function expandLibraries(api: RamlWrapper.Api): RamlWrapper.Api;
export declare function mergeAPIs(masterUnit: ll.ICompilationUnit, extensionsAndOverlays: ll.ICompilationUnit[], mergeMode: hlimpl.OverlayMergeMode): hl.IHighLevelNode;
export declare class TraitsAndResourceTypesExpander {
    private globalTraits;
    private globalResourceTypes;
    private ramlVersion;
    private namespaceResolver;
    expandTraitsAndResourceTypes(api: RamlWrapper.Api | RamlWrapper08.Api, rp?: referencePatcher.ReferencePatcher, forceProxy?: boolean): RamlWrapper.Api | RamlWrapper08.Api;
    init(api: RamlWrapper08.Api | RamlWrapper.Api): void;
    expandHighLevelNode(hlNode: hl.IHighLevelNode, rp: referencePatcher.ReferencePatcher, api: core.BasicNodeImpl): RamlWrapper.Api | RamlWrapper08.Api;
    private getTemplate<T>(name, context, cache, globalList);
    createHighLevelNode(_api: hl.IHighLevelNode, merge?: boolean, rp?: referencePatcher.ReferencePatcher, forceProxy?: boolean): hlimpl.ASTNodeImpl;
    private processResource(resource, _nodes?);
    private collectResourceData(original, obj, arr?, transformer?, nodesChain?, occuredResourceTypes?);
    private extractTraits(obj, _transformer, nodesChain, occuredTraits?);
    private readGenerictData(r, obj, context, template, transformer, unitsChain?);
    private appendTraitReferences(m, traits);
}
export declare class LibraryExpander {
    expandLibraries(_api: RamlWrapper.Api): RamlWrapper.Api;
    processNode(rp: referencePatcher.ReferencePatcher, hlNode: hl.IHighLevelNode): void;
}
export declare function toUnits(node: hl.IParseResult): ll.ICompilationUnit[];
export declare function getTransformNames(): string[];
export declare function getTransformersForOccurence(occurence: string): any[];
export declare class ValueTransformer implements proxy.ValueTransformer {
    templateKind: string;
    templateName: string;
    unitsChain: ll.ICompilationUnit[];
    params: {
        [key: string]: string;
    };
    structuredParams: {
        [key: string]: ll.ILowLevelASTNode;
    };
    vDelegate: ValueTransformer;
    constructor(templateKind: string, templateName: string, unitsChain: ll.ICompilationUnit[], params?: {
        [key: string]: string;
    }, structuredParams?: {
        [key: string]: ll.ILowLevelASTNode;
    }, vDelegate?: ValueTransformer);
    transform(obj: any, toString?: boolean, doBreak?: () => boolean, callback?: (obj: any, transformer: DefaultTransformer) => any): {
        value: any;
        errors: hl.ValidationIssue[];
    };
    private paramUpperBound(str, pos);
    children(node: ll.ILowLevelASTNode): ll.ILowLevelASTNode[];
    valueKind(node: ll.ILowLevelASTNode): yaml.Kind;
    private substitutionNode(node);
    private paramName(node);
}
export declare class DefaultTransformer extends ValueTransformer {
    constructor(owner: RamlWrapper.ResourceBase | RamlWrapper.MethodBase | RamlWrapper08.Resource | RamlWrapper08.MethodBase, delegate: ValueTransformer, unitsChain: ll.ICompilationUnit[]);
    owner: RamlWrapper.ResourceBase | RamlWrapper.MethodBase | RamlWrapper08.Resource | RamlWrapper08.MethodBase;
    delegate: ValueTransformer;
    transform(obj: any, toString?: boolean, doContinue?: () => boolean, callback?: (obj: any, transformer: DefaultTransformer) => any): any;
    private initParams();
    children(node: ll.ILowLevelASTNode): ll.ILowLevelASTNode[];
    valueKind(node: ll.ILowLevelASTNode): yaml.Kind;
}
