"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var hlimpl = require("../highLevelImpl");
var yaml = require("yaml-ast-parser");
var util = require("../../util/index");
var proxy = require("./LowLevelASTProxy");
var RamlWrapperImpl = require("../artifacts/raml10parser");
var RamlWrapper08Impl = require("../artifacts/raml08parser");
var wrapperHelper = require("../wrapped-ast/wrapperHelper");
var wrapperHelper08 = require("../wrapped-ast/wrapperHelper08");
var pluralize = require("pluralize");
var universeDef = require("../tools/universe");
var _ = require("underscore");
var referencePatcher = require("./referencePatcher");
var namespaceResolver = require("./namespaceResolver");
var universeHelpers = require("../tools/universeHelpers");
var changeCase = require('change-case');
function expandTraitsAndResourceTypes(api) {
    if (!(api instanceof RamlWrapperImpl.ApiImpl || api instanceof RamlWrapper08Impl.ApiImpl)) {
        return null;
    }
    return new TraitsAndResourceTypesExpander()
        .expandTraitsAndResourceTypes(api);
}
exports.expandTraitsAndResourceTypes = expandTraitsAndResourceTypes;
function expandLibraries(api) {
    return new LibraryExpander().expandLibraries(api);
}
exports.expandLibraries = expandLibraries;
function mergeAPIs(masterUnit, extensionsAndOverlays, mergeMode) {
    var masterApi = hlimpl.fromUnit(masterUnit);
    if (!masterApi)
        throw new Error("couldn't load api from " + masterUnit.absolutePath());
    if (!extensionsAndOverlays || extensionsAndOverlays.length == 0) {
        return masterApi;
    }
    var highLevelNodes = [];
    for (var i = 0; i < extensionsAndOverlays.length; i++) {
        var unit = extensionsAndOverlays[i];
        var hlNode = hlimpl.fromUnit(unit);
        if (!hlNode) {
            throw new Error("couldn't load api from " + unit.absolutePath());
        }
        highLevelNodes.push(hlNode);
    }
    var lastExtensionOrOverlay = mergeHighLevelNodes(masterApi, highLevelNodes, mergeMode);
    return lastExtensionOrOverlay;
}
exports.mergeAPIs = mergeAPIs;
function mergeHighLevelNodes(masterApi, highLevelNodes, mergeMode, rp, expand) {
    if (rp === void 0) { rp = null; }
    if (expand === void 0) { expand = false; }
    var currentMaster = masterApi;
    for (var _i = 0, highLevelNodes_1 = highLevelNodes; _i < highLevelNodes_1.length; _i++) {
        var currentApi = highLevelNodes_1[_i];
        if (expand && (currentMaster.lowLevel() instanceof proxy.LowLevelProxyNode)) {
            currentMaster = new TraitsAndResourceTypesExpander().expandHighLevelNode(currentMaster, rp, masterApi.wrapperNode()).highLevel();
        }
        currentApi.overrideMaster(currentMaster);
        currentApi.setMergeMode(mergeMode);
        currentMaster = currentApi;
    }
    return currentMaster;
}
;
var TraitsAndResourceTypesExpander = (function () {
    function TraitsAndResourceTypesExpander() {
        this.namespaceResolver = new namespaceResolver.NamespaceResolver();
    }
    TraitsAndResourceTypesExpander.prototype.expandTraitsAndResourceTypes = function (api, rp, forceProxy) {
        if (rp === void 0) { rp = null; }
        if (forceProxy === void 0) { forceProxy = false; }
        this.init(api);
        if (!api.highLevel().lowLevel()) {
            return api;
        }
        var unit = api.highLevel().lowLevel().unit();
        var hasFragments = unit.project().namespaceResolver().hasFragments(unit);
        var hasTemplates = this.globalTraits.length != 0 || this.globalResourceTypes.length != 0;
        if (!(hasTemplates || hasFragments) && !forceProxy) {
            return api;
        }
        var hlNode = this.createHighLevelNode(api.highLevel(), false, rp);
        if (api.definition().key() == universeDef.Universe10.Overlay) {
            return hlNode.wrapperNode();
        }
        var result = this.expandHighLevelNode(hlNode, rp, api);
        return result;
    };
    TraitsAndResourceTypesExpander.prototype.init = function (api) {
        this.ramlVersion = api.highLevel().definition().universe().version();
        this.globalTraits = this.ramlVersion == "RAML10"
            ? wrapperHelper.allTraits(api)
            : wrapperHelper08.allTraits(api);
        this.globalResourceTypes = this.ramlVersion == "RAML10"
            ? wrapperHelper.allResourceTypes(api)
            : wrapperHelper08.allResourceTypes(api);
    };
    TraitsAndResourceTypesExpander.prototype.expandHighLevelNode = function (hlNode, rp, api) {
        var _this = this;
        this.init(api);
        var result = hlNode.wrapperNode();
        result.setAttributeDefaults(api.getDefaultsCalculator().isEnabled());
        result.highLevel().setMergeMode(api.highLevel().getMergeMode());
        var resources = result.resources();
        resources.forEach(function (x) { return _this.processResource(x); });
        if (this.ramlVersion == "RAML10") {
            rp = rp || new referencePatcher.ReferencePatcher();
            rp.process(hlNode);
            hlNode.lowLevel().actual().referencePatcher = rp;
        }
        return result;
    };
    TraitsAndResourceTypesExpander.prototype.getTemplate = function (name, context, cache, globalList) {
        var unitPath = context.lowLevel().unit().path();
        var unitCache = cache[unitPath];
        if (!unitCache) {
            unitCache = {};
            cache[unitPath] = unitCache;
        }
        var val = unitCache[name];
        if (val !== undefined) {
            return val;
        }
        val = null;
        val = _.find(globalList, function (x) { return hlimpl.qName(x.highLevel(), context) == name; });
        if (!val) {
            val = null;
        }
        unitCache[name] = val;
        return val;
    };
    TraitsAndResourceTypesExpander.prototype.createHighLevelNode = function (_api, merge, rp, forceProxy) {
        if (merge === void 0) { merge = true; }
        if (rp === void 0) { rp = null; }
        if (forceProxy === void 0) { forceProxy = false; }
        var api = _api;
        var highLevelNodes = [];
        var node = api;
        while (node) {
            var llNode = node.lowLevel();
            var topComposite;
            if (api.definition().key() != universeDef.Universe10.Overlay || forceProxy) {
                topComposite = new proxy.LowLevelCompositeNode(llNode, null, null, this.ramlVersion);
            }
            else {
                topComposite = llNode;
            }
            var nodeType = node.definition();
            var newNode = new hlimpl.ASTNodeImpl(topComposite, null, nodeType, null);
            highLevelNodes.push(newNode);
            if (!merge) {
                break;
            }
            node = node.getMaster();
        }
        var masterApi = highLevelNodes.pop();
        highLevelNodes = highLevelNodes.reverse();
        var mergeMode = api.getMergeMode();
        return mergeHighLevelNodes(masterApi, highLevelNodes, mergeMode, rp, forceProxy);
    };
    TraitsAndResourceTypesExpander.prototype.processResource = function (resource, _nodes) {
        var _this = this;
        if (_nodes === void 0) { _nodes = []; }
        var nodes = _nodes.concat(resource.highLevel());
        var resourceData = this.collectResourceData(resource, resource, undefined, undefined, nodes);
        var resourceLowLevel = resource.highLevel().lowLevel();
        resourceData.filter(function (x) { return x.resourceType != null; }).forEach(function (x) {
            var resourceTypeLowLevel = x.resourceType.node.highLevel().lowLevel();
            var resourceTypeTransformer = x.resourceType.transformer;
            resourceTypeTransformer.owner = resource;
            resourceLowLevel.adopt(resourceTypeLowLevel, resourceTypeTransformer);
        });
        var methods = resource.methods();
        methods.forEach(function (m) {
            var methodLowLevel = m.highLevel().lowLevel();
            var name = m.method();
            var allTraits = [];
            resourceData.forEach(function (x) {
                var methodTraits = x.methodTraits[name];
                if (methodTraits) {
                    allTraits = allTraits.concat(methodTraits);
                    methodTraits.forEach(function (x) {
                        var traitLowLevel = x.node.highLevel().lowLevel();
                        var traitTransformer = x.transformer;
                        traitTransformer.owner = m;
                        methodLowLevel.adopt(traitLowLevel, traitTransformer);
                    });
                }
                var resourceTraits = x.traits;
                if (resourceTraits) {
                    allTraits = allTraits.concat(resourceTraits);
                    resourceTraits.forEach(function (x) {
                        var traitLowLevel = x.node.highLevel().lowLevel();
                        var traitTransformer = x.transformer;
                        traitTransformer.owner = m;
                        methodLowLevel.adopt(traitLowLevel, traitTransformer);
                    });
                }
            });
            // if(resource.definition().universe().version()=="RAML10") {
            //     this.appendTraitReferences(m, allTraits);
            // }
        });
        var resources = resource.resources();
        resources.forEach(function (x) { return _this.processResource(x, nodes); });
    };
    TraitsAndResourceTypesExpander.prototype.collectResourceData = function (original, obj, arr, transformer, nodesChain, occuredResourceTypes) {
        var _this = this;
        if (arr === void 0) { arr = []; }
        if (nodesChain === void 0) { nodesChain = []; }
        if (occuredResourceTypes === void 0) { occuredResourceTypes = {}; }
        nodesChain = nodesChain.concat([obj.highLevel()]);
        var ownTraits = this.extractTraits(obj, transformer, nodesChain);
        var methodTraitsMap = {};
        var methods = obj.methods();
        methods.forEach(function (x) {
            var methodTraits = _this.extractTraits(x, transformer, nodesChain);
            if (methodTraits && methodTraits.length > 0) {
                methodTraitsMap[x.method()] = methodTraits;
            }
        });
        var rtData;
        var rtRef = obj.type();
        if (rtRef != null) {
            var units = toUnits1(nodesChain);
            rtData = this.readGenerictData(original, rtRef, obj.highLevel(), 'resource type', transformer, units);
        }
        var result = {
            resourceType: rtData,
            traits: ownTraits,
            methodTraits: methodTraitsMap
        };
        arr.push(result);
        if (rtData) {
            var rt = rtData.node;
            var qName = hlimpl.qName(rt.highLevel(), original.highLevel());
            if (!occuredResourceTypes[qName]) {
                occuredResourceTypes[qName] = true;
                this.collectResourceData(original, rt, arr, rtData.transformer, nodesChain, occuredResourceTypes);
            }
            else {
                result.resourceType = null;
            }
        }
        return arr;
    };
    TraitsAndResourceTypesExpander.prototype.extractTraits = function (obj, _transformer, nodesChain, occuredTraits) {
        var _this = this;
        if (occuredTraits === void 0) { occuredTraits = {}; }
        nodesChain = nodesChain.concat([obj.highLevel()]);
        var arr = [];
        for (var i = -1; i < arr.length; i++) {
            var gd = i < 0 ? null : arr[i];
            var _obj = gd ? gd.node : obj;
            var units = gd ? gd.unitsChain : toUnits1(nodesChain);
            var transformer = gd ? gd.transformer : _transformer;
            if (!_obj['is']) {
                continue;
            }
            _obj.is().forEach(function (x) {
                var unitsChain = toUnits2(units, x.highLevel());
                var traitData = _this.readGenerictData(obj, x, _obj.highLevel(), 'trait', transformer, unitsChain);
                if (traitData) {
                    var name = traitData.name;
                    //if (!occuredTraits[name]) {
                    occuredTraits[name] = true;
                    arr.push(traitData);
                }
            });
        }
        return arr;
    };
    TraitsAndResourceTypesExpander.prototype.readGenerictData = function (r, obj, context, template, transformer, unitsChain) {
        if (unitsChain === void 0) { unitsChain = []; }
        var value = obj.value();
        var propName = pluralize.plural(changeCase.camelCase(template));
        if (typeof (value) == 'string') {
            if (transformer) {
                value = transformer.transform(value).value;
            }
            var _node = referencePatcher.getDeclaration(value, propName, this.namespaceResolver, unitsChain);
            if (_node) {
                var node = _node.wrapperNode();
                return {
                    name: value,
                    transformer: null,
                    parentTransformer: transformer,
                    node: node,
                    ref: obj,
                    unitsChain: unitsChain
                };
            }
        }
        else if (value instanceof hlimpl.StructuredValue) {
            var sv = value;
            var name = sv.valueName();
            if (transformer) {
                name = transformer.transform(name).value;
            }
            var scalarParams = {};
            var structuredParams = {};
            var _node = referencePatcher.getDeclaration(name, propName, this.namespaceResolver, unitsChain);
            if (_node) {
                var node = _node.wrapperNode();
                if (this.ramlVersion == 'RAML08') {
                    sv.children().forEach(function (x) { return scalarParams[x.valueName()] = x.lowLevel().value(); });
                }
                else {
                    sv.children().forEach(function (x) {
                        var llNode = x.lowLevel();
                        if (llNode.valueKind() == yaml.Kind.SCALAR) {
                            scalarParams[x.valueName()] = llNode.value();
                        }
                        else if (llNode.valueKind() == yaml.Kind.INCLUDE_REF) {
                            if (llNode.children().length == 0) {
                                scalarParams[x.valueName()] = llNode.value();
                            }
                            else {
                                structuredParams[x.valueName()] = llNode;
                            }
                        }
                        else {
                            structuredParams[x.valueName()] = llNode;
                        }
                    });
                }
                var ds = new DefaultTransformer(r, null, unitsChain);
                Object.keys(scalarParams).forEach(function (x) {
                    var q = ds.transform(scalarParams[x]);
                    //if (q.value){
                    if (q) {
                        if (typeof q !== "object") {
                            scalarParams[x] = q;
                        }
                    }
                    //}
                });
                var valTransformer = new ValueTransformer(template, name, unitsChain, scalarParams, structuredParams, transformer);
                var resourceTypeTransformer = new DefaultTransformer(null, valTransformer, unitsChain);
                return {
                    name: name,
                    transformer: resourceTypeTransformer,
                    parentTransformer: transformer,
                    node: node,
                    ref: obj,
                    unitsChain: unitsChain
                };
            }
        }
        return null;
    };
    TraitsAndResourceTypesExpander.prototype.appendTraitReferences = function (m, traits) {
        if (traits.length == 0) {
            return;
        }
        var traitsData = traits.map(function (x) {
            return {
                node: x.ref.highLevel().lowLevel(),
                transformer: x.parentTransformer
            };
        });
        referencePatcher.patchMethodIs(m.highLevel(), traitsData);
    };
    return TraitsAndResourceTypesExpander;
}());
exports.TraitsAndResourceTypesExpander = TraitsAndResourceTypesExpander;
var LibraryExpander = (function () {
    function LibraryExpander() {
    }
    LibraryExpander.prototype.expandLibraries = function (_api) {
        var api = _api;
        if (api == null) {
            return null;
        }
        if (api.highLevel().lowLevel() instanceof proxy.LowLevelCompositeNode) {
            api = api.highLevel().lowLevel().unit().highLevel().asElement().wrapperNode();
        }
        var expander = new TraitsAndResourceTypesExpander();
        var rp = new referencePatcher.ReferencePatcher();
        var hlNode = expander.createHighLevelNode(api.highLevel(), true, rp, true);
        var result = expander.expandHighLevelNode(hlNode, rp, api);
        this.processNode(rp, result.highLevel());
        return result;
    };
    LibraryExpander.prototype.processNode = function (rp, hlNode) {
        if (hlNode == null) {
            return;
        }
        var master = hlNode.getMaster();
        this.processNode(rp, master);
        if (universeHelpers.isOverlayType(hlNode.definition())) {
            rp.process(hlNode);
        }
        rp.expandLibraries(hlNode);
    };
    return LibraryExpander;
}());
exports.LibraryExpander = LibraryExpander;
function toUnits1(nodes) {
    var result = [];
    for (var _i = 0, nodes_1 = nodes; _i < nodes_1.length; _i++) {
        var n = nodes_1[_i];
        toUnits2(result, n, true);
    }
    return result;
}
function toUnits2(chainStart, node, append) {
    if (append === void 0) { append = false; }
    var result = append ? chainStart : chainStart.concat([]);
    var unit = node.lowLevel().unit();
    if (unit == null) {
        return result;
    }
    if (result.length == 0) {
        result.push(unit);
    }
    else {
        var prevPath = result[result.length - 1].absolutePath();
        if (unit.absolutePath() != prevPath) {
            result.push(unit);
        }
    }
    return result;
}
function toUnits(node) {
    var nodes = [];
    while (node) {
        nodes.push(node);
        node = node.parent();
    }
    return toUnits1(nodes);
}
exports.toUnits = toUnits;
var TransformMatches = (function () {
    function TransformMatches(name, transformer) {
        this.name = name;
        this.regexp = new RegExp(TransformMatches.leftTransformRegexp.source + name + TransformMatches.rightTransformRegexp.source);
        this.transformer = transformer;
    }
    TransformMatches.leftTransformRegexp = /\s*!\s*/;
    TransformMatches.rightTransformRegexp = /\s*$/;
    return TransformMatches;
}());
var transformers = [
    new TransformMatches("singularize", function (arg) { return pluralize.singular(arg); }),
    new TransformMatches("pluralize", function (arg) { return pluralize.plural(arg); }),
    new TransformMatches("uppercase", function (arg) { return arg ? arg.toUpperCase() : arg; }),
    new TransformMatches("lowercase", function (arg) { return arg ? arg.toLowerCase() : arg; }),
    new TransformMatches("lowercamelcase", function (arg) {
        if (!arg) {
            return arg;
        }
        return changeCase.camelCase(arg);
    }),
    new TransformMatches("uppercamelcase", function (arg) {
        if (!arg) {
            return arg;
        }
        var lowerCamelCase = changeCase.camelCase(arg);
        return lowerCamelCase[0].toUpperCase() + lowerCamelCase.substring(1, lowerCamelCase.length);
    }),
    new TransformMatches("lowerunderscorecase", function (arg) {
        if (!arg) {
            return arg;
        }
        var snakeCase = changeCase.snake(arg);
        return snakeCase.toLowerCase();
    }),
    new TransformMatches("upperunderscorecase", function (arg) {
        if (!arg) {
            return arg;
        }
        var snakeCase = changeCase.snake(arg);
        return snakeCase.toUpperCase();
    }),
    new TransformMatches("lowerhyphencase", function (arg) {
        if (!arg) {
            return arg;
        }
        var paramCase = changeCase.param(arg);
        return paramCase.toLowerCase();
    }),
    new TransformMatches("upperhyphencase", function (arg) {
        if (!arg) {
            return arg;
        }
        var paramCase = changeCase.param(arg);
        return paramCase.toUpperCase();
    })
];
function getTransformNames() {
    return transformers.map(function (transformer) { return transformer.name; });
}
exports.getTransformNames = getTransformNames;
function getTransformersForOccurence(occurence) {
    var result = [];
    var functions = occurence.split("|").slice(1);
    for (var _i = 0, functions_1 = functions; _i < functions_1.length; _i++) {
        var f = functions_1[_i];
        for (var i = 0; i < transformers.length; i++) {
            if (f.match(transformers[i].regexp)) {
                result.push(transformers[i].transformer);
                break;
            }
        }
    }
    return result;
}
exports.getTransformersForOccurence = getTransformersForOccurence;
var TransformationBuffer = (function () {
    function TransformationBuffer() {
        this.buf = null;
    }
    TransformationBuffer.prototype.append = function (value) {
        if (value !== "") {
            if (this.buf != null) {
                if (value != null) {
                    if (typeof (this.buf) != "string") {
                        this.buf = "" + this.buf;
                    }
                    this.buf += value;
                }
            }
            else if (value !== "") {
                this.buf = value;
            }
        }
    };
    TransformationBuffer.prototype.value = function () {
        return this.buf != null ? this.buf : "";
    };
    return TransformationBuffer;
}());
var ValueTransformer = (function () {
    function ValueTransformer(templateKind, templateName, unitsChain, params, structuredParams, vDelegate) {
        this.templateKind = templateKind;
        this.templateName = templateName;
        this.unitsChain = unitsChain;
        this.params = params;
        this.structuredParams = structuredParams;
        this.vDelegate = vDelegate;
    }
    ValueTransformer.prototype.transform = function (obj, toString, doBreak, callback) {
        var undefParams = {};
        var errors = [];
        if (typeof (obj) === 'string') {
            if (this.structuredParams && util.stringStartsWith(obj, "<<") && util.stringEndsWith(obj, ">>")) {
                var paramName = obj.substring(2, obj.length - 2);
                var structuredValue = this.structuredParams[paramName];
                if (structuredValue != null) {
                    return { value: structuredValue.value(toString), errors: errors };
                }
            }
            var str = obj;
            var buf = new TransformationBuffer();
            var prev = 0;
            for (var i = str.indexOf('<<'); i >= 0; i = str.indexOf('<<', prev)) {
                buf.append(str.substring(prev, i));
                var i0 = i;
                i += '<<'.length;
                prev = this.paramUpperBound(str, i);
                if (prev == -1) {
                    break;
                }
                var paramOccurence = str.substring(i, prev);
                prev += '>>'.length;
                var originalString = str.substring(i0, prev);
                var val;
                var paramName;
                var transformers = getTransformersForOccurence(paramOccurence);
                if (transformers.length > 0) {
                    var ind = paramOccurence.indexOf('|');
                    paramName = paramOccurence.substring(0, ind).trim();
                    val = this.params[paramName];
                    if (val && typeof (val) == "string" && val.indexOf("<<") >= 0 && this.vDelegate) {
                        val = this.vDelegate.transform(val, toString, doBreak, callback).value;
                    }
                    if (val) {
                        for (var _i = 0, transformers_1 = transformers; _i < transformers_1.length; _i++) {
                            var tr = transformers_1[_i];
                            val = tr(val);
                        }
                    }
                }
                else {
                    paramName = paramOccurence.trim();
                    val = this.params[paramName];
                    if (val && typeof (val) == "string" && val.indexOf("<<") >= 0 && this.vDelegate) {
                        val = this.vDelegate.transform(val, toString, doBreak, callback).value;
                    }
                }
                if (val === null || val === undefined) {
                    undefParams[paramName] = true;
                    val = originalString;
                }
                buf.append(val);
            }
            // var upArr = Object.keys(undefParams);
            // if(upArr.length>0){
            //     var errStr = upArr.join(', ').trim();
            //     var message = `Undefined ${this.templateKind} parameter${upArr.length>1?'s':''}: ${errStr}`;
            //     var error = {
            //         code: hl.IssueCode.MISSING_REQUIRED_PROPERTY,
            //         isWarning: false,
            //         message: message,
            //         node: null,
            //         start: -1,
            //         end: -1,
            //         path: null
            //     }
            //     errors.push(error);
            // }
            buf.append(str.substring(prev, str.length));
            return { value: buf.value(), errors: errors };
        }
        else {
            return { value: obj, errors: errors };
        }
    };
    ValueTransformer.prototype.paramUpperBound = function (str, pos) {
        var count = 0;
        for (var i = pos; i < str.length; i++) {
            if (util.stringStartsWith(str, "<<", i)) {
                count++;
                i++;
            }
            else if (util.stringStartsWith(str, ">>", i)) {
                if (count == 0) {
                    return i;
                }
                count--;
                i++;
            }
        }
        return str.length;
    };
    ValueTransformer.prototype.children = function (node) {
        var substitution = this.substitutionNode(node);
        if (substitution) {
            return substitution.children();
        }
        return null;
    };
    ValueTransformer.prototype.valueKind = function (node) {
        var substitution = this.substitutionNode(node);
        if (substitution) {
            return substitution.valueKind();
        }
        return null;
    };
    ValueTransformer.prototype.substitutionNode = function (node) {
        var paramName = this.paramName(node);
        return paramName && this.structuredParams[paramName];
    };
    ValueTransformer.prototype.paramName = function (node) {
        var paramName = null;
        if (node.valueKind() == yaml.Kind.SCALAR) {
            var val = ("" + node.value()).trim();
            if (util.stringStartsWith(val, "<<") && util.stringEndsWith(val, ">>")) {
                paramName = val.substring(2, val.length - 2);
            }
        }
        return paramName;
    };
    return ValueTransformer;
}());
exports.ValueTransformer = ValueTransformer;
var DefaultTransformer = (function (_super) {
    __extends(DefaultTransformer, _super);
    function DefaultTransformer(owner, delegate, unitsChain) {
        _super.call(this, delegate != null ? delegate.templateKind : "", delegate != null ? delegate.templateName : "", unitsChain);
        this.owner = owner;
        this.delegate = delegate;
    }
    DefaultTransformer.prototype.transform = function (obj, toString, doContinue, callback) {
        if (obj == null || (doContinue != null && !doContinue())) {
            return {
                value: obj,
                errors: []
            };
        }
        var ownResult = {
            value: obj,
            errors: []
        };
        var gotDefaultParam = false;
        defaultParameters.forEach(function (x) { return gotDefaultParam = gotDefaultParam || obj.toString().indexOf('<<' + x) >= 0; });
        if (gotDefaultParam) {
            this.initParams();
            ownResult = _super.prototype.transform.call(this, obj, toString, doContinue, callback);
        }
        var result = this.delegate != null
            ? this.delegate.transform(ownResult.value, toString, doContinue, callback)
            : ownResult.value;
        if (doContinue != null && doContinue() && callback != null) {
            result.value = callback(result.value, this);
        }
        return result;
    };
    DefaultTransformer.prototype.initParams = function () {
        var methodName;
        var resourcePath = "";
        var resourcePathName;
        var ll = this.owner.highLevel().lowLevel();
        var node = ll;
        var last = null;
        while (node) {
            var key = node.key();
            if (key != null) {
                if (util.stringStartsWith(key, '/')) {
                    if (!resourcePathName) {
                        var arr = key.split('/');
                        for (var i = arr.length - 1; i >= 0; i--) {
                            var seg = arr[i];
                            if (seg.indexOf('{') == -1) {
                                resourcePathName = arr[i];
                                break;
                            }
                            if (seg.length > 0) {
                                last = seg;
                            }
                        }
                    }
                    resourcePath = key + resourcePath;
                }
                else {
                    methodName = key;
                }
            }
            node = node.parent();
        }
        if (!resourcePathName) {
            if (last) {
                resourcePathName = "";
            }
        }
        this.params = {
            resourcePath: resourcePath,
            resourcePathName: resourcePathName
        };
        if (methodName) {
            this.params['methodName'] = methodName;
        }
    };
    DefaultTransformer.prototype.children = function (node) {
        return this.delegate != null ? this.delegate.children(node) : null;
    };
    DefaultTransformer.prototype.valueKind = function (node) {
        return this.delegate != null ? this.delegate.valueKind(node) : null;
    };
    return DefaultTransformer;
}(ValueTransformer));
exports.DefaultTransformer = DefaultTransformer;
var defaultParameters = ['resourcePath', 'resourcePathName', 'methodName'];
//# sourceMappingURL=expander.js.map