/// <reference path="../../../typings/main.d.ts" />
"use strict";
var linter = require("./linter");
var messageRegistry = require("../../../resources/errorMessages");
function escapeUri(u) {
    var ss = "";
    var level = 0;
    for (var i = 0; i < u.length; i++) {
        var c = u.charAt(i);
        if (level == 0) {
            ss = ss + c;
        }
        if (c == '{') {
            level++;
        }
        if (c == '}') {
            level--;
        }
    }
    return ss;
}
var OverloadingValidator = (function () {
    function OverloadingValidator() {
        this.uriToResources = {};
        this.conflictingUriToResources = {};
    }
    OverloadingValidator.prototype.validateApi = function (api, acceptor) {
        var _this = this;
        var resources = api.resources();
        resources.forEach(function (resource) {
            _this.acceptResource(resource);
            var subResources = resource.resources();
            subResources.forEach(function (subResource) { return _this.acceptResource(subResource); });
        });
        for (var uri in this.conflictingUriToResources) {
            var resources = this.conflictingUriToResources[uri];
            if (resources.length > 1) {
                //we should be only reporting resources, which have different keys or parent.
                //otherwise it is handled by the general key validator
                //thus performing additional filtering
                var idToSimilarResources = {};
                resources.forEach(function (resource) {
                    var highLevel = resource.highLevel();
                    var complexId = "";
                    if (highLevel.parent() != null) {
                        complexId += highLevel.parent().id() + ".";
                    }
                    complexId += highLevel.localId();
                    var resourcesWithId = idToSimilarResources[complexId];
                    if (resourcesWithId == null) {
                        resourcesWithId = [];
                        idToSimilarResources[complexId] = resourcesWithId;
                    }
                    resourcesWithId.push(resource);
                });
                //var isTemplateOverlap=uri.indexOf('{')!=-1;
                var ids = Object.keys(idToSimilarResources);
                if (ids.length > 1) {
                    //if we have more than a single id of conflicting resources
                    resources.forEach(function (resource) {
                        acceptor.accept(linter.createIssue1(messageRegistry.RESOURCES_SHARE_SAME_URI, {}, resource.highLevel(), false));
                    });
                }
            }
        }
    };
    OverloadingValidator.prototype.acceptResource = function (resource) {
        var uri = resource.absoluteUri();
        var resources = this.uriToResources[uri];
        if (!resources) {
            resources = [];
            this.uriToResources[uri] = resources;
        }
        resources.push(resource);
        if (resources.length > 1) {
            this.conflictingUriToResources[uri] = resources;
        }
        //resource.methods().forEach(m=>{
        //    this.acceptMethod(resource,m);
        //})
    };
    return OverloadingValidator;
}());
module.exports = OverloadingValidator;
//# sourceMappingURL=overloadingValidator.js.map