
import ll = require("../lowLevelAST");
import hl = require("../highLevelAST");
import jsyaml = require("../jsyaml/jsyaml2lowLevel");
import proxy = require("./LowLevelASTProxy");
import namespaceResolver = require("./namespaceResolver");
import def = require("raml-definition-system");
export declare enum PatchMode {
    DEFAULT = 0,
    PATH = 1,
}
export declare class ReferencePatcher {
    protected mode: PatchMode;
    constructor(mode?: PatchMode);
    private _outerDependencies;
    private _libModels;
    process(hlNode: hl.IHighLevelNode, rootNode?: hl.IHighLevelNode, removeUses?: boolean, patchNodeName?: boolean): void;
    patchReferences(node: hl.IHighLevelNode, rootNode?: hl.IHighLevelNode, resolver?: namespaceResolver.NamespaceResolver, units?: ll.ICompilationUnit[]): void;
    patchReferenceAttr(attr: hl.IAttribute, rootNode: hl.IHighLevelNode, resolver: namespaceResolver.NamespaceResolver, units: ll.ICompilationUnit[]): void;
    patchType(node: hl.IHighLevelNode, rootNode: hl.IHighLevelNode, resolver: namespaceResolver.NamespaceResolver, units: ll.ICompilationUnit[]): void;
    private resolveReferenceValue(stringToPatch, rootUnit, units, resolver, transformer, range, patchTransformedValue?);
    patchNodeName(hlNode: hl.IHighLevelNode, rootUnit: ll.ICompilationUnit, resolver: namespaceResolver.NamespaceResolver): void;
    resolveReferenceValueBasic(_value: string, rootUnit: ll.ICompilationUnit, resolver: namespaceResolver.NamespaceResolver, units: ll.ICompilationUnit[], range: def.ITypeDefinition): PatchedReference;
    patchUses(node: ll.ILowLevelASTNode, resolver: namespaceResolver.NamespaceResolver): void;
    removeUses(node: ll.ILowLevelASTNode): void;
    resetTypes(hlNode: hl.IHighLevelNode): void;
    appendUnitIfNeeded(node: hl.IParseResult | ll.ICompilationUnit, units: ll.ICompilationUnit[]): boolean;
    popUnitIfNeeded(units: ll.ICompilationUnit[], appended: boolean): void;
    registerPatchedReference(ref: PatchedReference): void;
    private collectionName(range);
    expandLibraries(api: hl.IHighLevelNode): void;
    private patchDependencies(api);
    private removeUnusedDependencies(api);
    private contributeCollection(llApi, collection);
    private extractLibModel(unit);
    private isCompoundValue(str);
}
export declare function patchMethodIs(node: hl.IHighLevelNode, traits: {
    node: ll.ILowLevelASTNode;
    transformer: proxy.ValueTransformer;
}[]): proxy.LowLevelCompositeNode;
export declare function prepareTraitRefNode(llNode: ll.ILowLevelASTNode, llParent: ll.ILowLevelASTNode): jsyaml.ASTNode;
export declare class PatchedReference {
    private _namespace;
    private _name;
    private _collectionName;
    private _referencedUnit;
    private _mode;
    constructor(_namespace: string, _name: string, _collectionName: string, _referencedUnit: ll.ICompilationUnit, _mode: PatchMode);
    referencedNode: ll.ILowLevelASTNode;
    namespace(): string;
    name(): string;
    collectionName(): string;
    referencedUnit(): ll.ICompilationUnit;
    mode(): PatchMode;
    value(): string;
}
export declare function instanceOfPatchedReference(instance: any): instance is PatchedReference;
export declare function getDeclaration(elementName: string, typeName: string, resolver: namespaceResolver.NamespaceResolver, units: ll.ICompilationUnit[]): hl.IHighLevelNode;
