"use strict";
/// <reference path="../../../typings/main.d.ts" />
var ll = require("../lowLevelAST");
var hlimpl = require("../highLevelImpl");
var yaml = require("yaml-ast-parser");
var jsyaml = require("../jsyaml/jsyaml2lowLevel");
var util = require("../../util/index");
var proxy = require("./LowLevelASTProxy");
var universeDef = require("../tools/universe");
var _ = require("underscore");
var universeHelpers = require("../tools/universeHelpers");
var namespaceResolver = require("./namespaceResolver");
var def = require("raml-definition-system");
var typeExpressions = def.rt.typeExpressions;
(function (PatchMode) {
    PatchMode[PatchMode["DEFAULT"] = 0] = "DEFAULT";
    PatchMode[PatchMode["PATH"] = 1] = "PATH";
})(exports.PatchMode || (exports.PatchMode = {}));
var PatchMode = exports.PatchMode;
var ReferencePatcher = (function () {
    function ReferencePatcher(mode) {
        if (mode === void 0) { mode = PatchMode.DEFAULT; }
        this.mode = mode;
        this._outerDependencies = {};
        this._libModels = {};
    }
    ReferencePatcher.prototype.process = function (hlNode, rootNode, removeUses, patchNodeName) {
        if (rootNode === void 0) { rootNode = hlNode; }
        if (removeUses === void 0) { removeUses = false; }
        if (patchNodeName === void 0) { patchNodeName = false; }
        if (hlNode.lowLevel()["libProcessed"]) {
            return;
        }
        var resolver = hlNode.lowLevel().unit().project().namespaceResolver();
        this.patchReferences(hlNode, rootNode, resolver);
        if (patchNodeName) {
            this.patchNodeName(hlNode, rootNode.lowLevel().unit(), resolver);
        }
        if (removeUses) {
            this.removeUses(hlNode.lowLevel());
        }
        else {
            this.patchUses(hlNode.lowLevel(), resolver);
        }
        this.resetTypes(hlNode);
        hlNode.resetChildren();
        hlNode.lowLevel()["libProcessed"] = true;
    };
    ReferencePatcher.prototype.patchReferences = function (node, rootNode, resolver, units) {
        if (rootNode === void 0) { rootNode = node; }
        if (resolver === void 0) { resolver = new namespaceResolver.NamespaceResolver(); }
        if (units === void 0) { units = [rootNode.lowLevel().unit()]; }
        var isNode;
        if (node.definition().property(universeDef.Universe10.TypeDeclaration.properties.annotations.name) != null) {
            var cNode = node.lowLevel();
            if (!(cNode instanceof proxy.LowLevelCompositeNode)) {
                return;
            }
            var isPropertyName = universeDef.Universe10.MethodBase.properties.is.name;
            var traitNodes = node.attributes(isPropertyName);
            cNode.preserveAnnotations();
            node.resetChildren();
            if (traitNodes.length != 0) {
                isNode = patchMethodIs(node, traitNodes.map(function (x) { return x.lowLevel(); }).map(function (x) {
                    return {
                        node: x,
                        transformer: x.transformer()
                    };
                }));
            }
        }
        var attrs = node.attrs();
        for (var _i = 0, attrs_1 = attrs; _i < attrs_1.length; _i++) {
            var attr = attrs_1[_i];
            var appended = this.appendUnitIfNeeded(attr, units);
            this.patchReferenceAttr(attr, rootNode, resolver, units);
            this.popUnitIfNeeded(units, appended);
        }
        if (universeHelpers.isTypeDeclarationDescendant(node.definition())) {
            var appended = this.appendUnitIfNeeded(node, units);
            this.patchType(node, rootNode, resolver, units);
            this.popUnitIfNeeded(units, appended);
        }
        var childNodes = node.elements();
        for (var _a = 0, childNodes_1 = childNodes; _a < childNodes_1.length; _a++) {
            var ch = childNodes_1[_a];
            var appended = this.appendUnitIfNeeded(ch, units);
            this.patchReferences(ch, rootNode, resolver, units);
            this.popUnitIfNeeded(units, appended);
        }
        if (isNode) {
            isNode.filterChildren();
        }
    };
    ReferencePatcher.prototype.patchReferenceAttr = function (attr, rootNode, resolver, units) {
        var property = attr.property();
        var range = property.range();
        if (!range.isAssignableFrom(universeDef.Universe10.Reference.name)) {
            return;
        }
        var value = attr.value();
        if (value == null) {
            return;
        }
        var llNode = attr.lowLevel();
        if (!(llNode instanceof proxy.LowLevelProxyNode)) {
            return;
        }
        var transformer = llNode.transformer();
        var isAnnotation = universeHelpers.isAnnotationsProperty(property);
        if (typeof value == "string") {
            var stringToPatch = value;
            if (transformer != null) {
                var actualNode = toOriginal(llNode);
                stringToPatch = actualNode.value();
            }
            if (isAnnotation) {
                stringToPatch = stringToPatch.substring(1, stringToPatch.length - 1);
            }
            var newValue = this.resolveReferenceValue(stringToPatch, rootNode.lowLevel().unit(), units, resolver, transformer, range);
            if (newValue != null) {
                var newValue1 = isAnnotation ? "(" + newValue.value() + ")" : newValue.value();
                attr.lowLevel().setValueOverride(newValue1);
                this.registerPatchedReference(newValue);
            }
        }
        else {
            var sValue = value;
            var key = sValue.lowLevel().key();
            var stringToPatch = key;
            if (transformer != null) {
                var actualNode = toOriginal(sValue.lowLevel());
                stringToPatch = actualNode.key();
            }
            if (key != null) {
                if (isAnnotation) {
                    stringToPatch = stringToPatch.substring(1, stringToPatch.length - 1);
                }
                var newValue = this.resolveReferenceValue(stringToPatch, rootNode.lowLevel().unit(), units, resolver, transformer, range);
                if (newValue != null) {
                    var newValue1 = isAnnotation ? "(" + newValue.value() + ")" : newValue.value();
                    sValue.lowLevel().setKeyOverride(newValue1);
                    this.registerPatchedReference(newValue);
                }
            }
        }
    };
    ReferencePatcher.prototype.patchType = function (node, rootNode, resolver, units) {
        var _this = this;
        var nodeType = node.definition();
        var isExternal = node.localType().isExternal();
        if (!isExternal) {
            for (var _i = 0, _a = node.localType().allSuperTypes(); _i < _a.length; _i++) {
                var st = _a[_i];
                isExternal = st.isExternal();
                if (isExternal) {
                    break;
                }
            }
        }
        if (!isExternal) {
            var rootUnit = rootNode.lowLevel().unit();
            var rootPath = rootUnit.absolutePath();
            //if(rootPath != localPath) {
            var typeAttributes = node.attributes(universeDef.Universe10.TypeDeclaration.properties.type.name);
            if (typeAttributes.length == 0) {
                typeAttributes = node.attributes(universeDef.Universe10.TypeDeclaration.properties.schema.name);
            }
            for (var _b = 0, typeAttributes_1 = typeAttributes; _b < typeAttributes_1.length; _b++) {
                var typeAttr = typeAttributes_1[_b];
                var llNode = typeAttr.lowLevel();
                if (!(llNode instanceof proxy.LowLevelProxyNode)) {
                    continue;
                }
                var localUnit = typeAttr.lowLevel().unit();
                var localPath = localUnit.absolutePath();
                var value = typeAttr.value();
                if (typeof value == "string") {
                    var gotExpression = checkExpression(value);
                    var transformer = llNode.transformer();
                    var stringToPatch = value;
                    var escapeData = { status: ParametersEscapingStatus.NOT_REQUIRED };
                    var additionalUnits = transformer ? transformer.unitsChain : null;
                    if (transformer != null || value.indexOf("<<") >= 0) {
                        var actualNode = toOriginal(llNode);
                        var actualValue = actualNode.value();
                        escapeData = escapeTemplateParameters(actualValue);
                        if (escapeData.status == ParametersEscapingStatus.OK) {
                            if (gotExpression) {
                                stringToPatch = escapeData.resultingString;
                            }
                            else {
                                stringToPatch = actualValue;
                            }
                        }
                        else {
                            transformer = null;
                        }
                    }
                    var appendedAdditional;
                    if (additionalUnits) {
                        appendedAdditional = [];
                        for (var _c = 0, additionalUnits_1 = additionalUnits; _c < additionalUnits_1.length; _c++) {
                            var u = additionalUnits_1[_c];
                            appendedAdditional.push(this.appendUnitIfNeeded(u, units));
                        }
                    }
                    var appendedAttrUnit = this.appendUnitIfNeeded(typeAttr, units);
                    var newValue;
                    if (gotExpression) {
                        var expressionPatchFailed = false;
                        var expr = typeExpressions.parse(stringToPatch);
                        var gotPatch = false;
                        typeExpressions.visit(expr, function (x) {
                            if (x.type == "name") {
                                var lit = x;
                                var typeName = lit.value;
                                var unescapeData = { status: ParametersEscapingStatus.NOT_REQUIRED };
                                var unescaped;
                                if (escapeData.status == ParametersEscapingStatus.OK) {
                                    unescaped = escapeData.substitutions[typeName];
                                    if (unescaped == null) {
                                        unescapeData = unescapeTemplateParameters(typeName, escapeData.substitutions);
                                        if (unescapeData.status == ParametersEscapingStatus.OK) {
                                            typeName = unescapeData.resultingString;
                                        }
                                        else if (unescapeData.status == ParametersEscapingStatus.ERROR) {
                                            expressionPatchFailed = true;
                                            return;
                                        }
                                    }
                                    else {
                                        typeName = unescaped;
                                    }
                                }
                                if (transformer == null && (unescaped != null || unescapeData.status == ParametersEscapingStatus.OK)) {
                                    lit.value = typeName;
                                    return;
                                }
                                var patchTransformedValue = true;
                                if (typeName.indexOf("<<") >= 0 && _this.isCompoundValue(typeName)) {
                                    patchTransformedValue = false;
                                }
                                var patched = _this.resolveReferenceValue(typeName, rootUnit, units, resolver, transformer, nodeType, patchTransformedValue);
                                if (patched != null) {
                                    lit.value = patched.value();
                                    gotPatch = true;
                                    _this.registerPatchedReference(patched);
                                }
                            }
                        });
                        if (gotPatch && !expressionPatchFailed) {
                            newValue = typeExpressions.serializeToString(expr);
                        }
                        else {
                            newValue = value;
                        }
                    }
                    else if (!(escapeData.status == ParametersEscapingStatus.OK && transformer == null)) {
                        if (stringToPatch.indexOf("<<") >= 0 && this.isCompoundValue(stringToPatch)) {
                            stringToPatch = value;
                            transformer = null;
                        }
                        var patched = this.resolveReferenceValue(stringToPatch, rootUnit, units, resolver, transformer, nodeType);
                        if (patched != null) {
                            this.registerPatchedReference(patched);
                            newValue = patched.value();
                        }
                    }
                    if (newValue != null) {
                        typeAttr.lowLevel().setValueOverride(newValue);
                        typeAttr.overrideValue(null);
                    }
                    this.popUnitIfNeeded(units, appendedAttrUnit);
                    if (appendedAdditional) {
                        for (var _d = 0, _e = appendedAdditional.reverse(); _d < _e.length; _d++) {
                            var ap = _e[_d];
                            this.popUnitIfNeeded(units, ap);
                        }
                    }
                }
                else {
                    var llTypeNode = _.find(node.lowLevel().children(), function (x) { return x.key() == "type"; });
                    if (llTypeNode) {
                        var def = node.definition().universe().type(universeDef.Universe10.TypeDeclaration.name);
                        var newNode = new hlimpl.ASTNodeImpl(llTypeNode, null, def, null);
                        var appended = this.appendUnitIfNeeded(newNode, units);
                        this.patchReferences(newNode, rootNode, resolver, units);
                        this.popUnitIfNeeded(units, appended);
                    }
                }
            }
        }
    };
    ReferencePatcher.prototype.resolveReferenceValue = function (stringToPatch, rootUnit, units, resolver, transformer, range, patchTransformedValue) {
        var _this = this;
        if (patchTransformedValue === void 0) { patchTransformedValue = true; }
        var isAnnotation = universeHelpers.isAnnotationRefTypeOrDescendant(range);
        var newValue;
        if (transformer) {
            if (stringToPatch && stringToPatch.indexOf("<<") >= 0) {
                var doContinue = true;
                var types = rootUnit.highLevel().types();
                var newValue1 = transformer.transform(stringToPatch, true, function () { return doContinue; }, function (val, tr) {
                    var newVal = _this.resolveReferenceValueBasic(val, rootUnit, resolver, tr.unitsChain, range);
                    if (newVal == null) {
                        newVal = new PatchedReference(null, val, _this.collectionName(range), rootUnit, PatchMode.DEFAULT);
                    }
                    if (isAnnotation) {
                        if (types.getAnnotationType(newVal.value()) != null) {
                            doContinue = false;
                        }
                        else {
                            doContinue = false;
                        }
                    }
                    else if (types.getType(newVal.value()) != null) {
                        doContinue = false;
                    }
                    else {
                        doContinue = false;
                    }
                    return newVal;
                });
                newValue = newValue1.value;
            }
        }
        if (newValue === undefined || !instanceOfPatchedReference(newValue)) {
            newValue = this.resolveReferenceValueBasic(stringToPatch, rootUnit, resolver, units, range);
        }
        return newValue;
    };
    ReferencePatcher.prototype.patchNodeName = function (hlNode, rootUnit, resolver) {
        var llNode = hlNode.lowLevel();
        var key = llNode.key();
        var range = hlNode.definition();
        if (universeHelpers.isTypeDeclarationSibling(range)) {
            var localType = hlNode.localType();
            if (localType.isAnnotationType()) {
                range = localType;
            }
        }
        var patched = this.resolveReferenceValueBasic(key, rootUnit, resolver, [llNode.unit()], range);
        if (patched != null) {
            llNode.setKeyOverride(patched.value());
        }
    };
    ReferencePatcher.prototype.resolveReferenceValueBasic = function (_value, rootUnit, resolver, units, range) {
        if (_value == null || typeof (_value) != "string") {
            return null;
        }
        var isType = universeHelpers.isTypeDeclarationDescendant(range);
        var gotQuestion = isType && util.stringEndsWith(_value, "?");
        var value = gotQuestion ? _value.substring(0, _value.length - 1) : _value;
        var ind = value.lastIndexOf(".");
        var referencedUnit;
        var plainName;
        if (ind >= 0) {
            var oldNS = value.substring(0, ind);
            plainName = value.substring(ind + 1);
            for (var i = units.length; i > 0; i--) {
                var localUnit = units[i - 1];
                var nsMap = resolver.nsMap(localUnit);
                if (nsMap == null) {
                    continue;
                }
                var info = nsMap[oldNS];
                if (info == null) {
                    continue;
                }
                referencedUnit = info.unit;
                if (referencedUnit != null) {
                    break;
                }
            }
        }
        else {
            if (isType && def.rt.builtInTypes().get(value) != null) {
                return null;
            }
            plainName = value;
            referencedUnit = units[units.length - 1];
        }
        var collectionName = this.collectionName(range);
        if (referencedUnit == null || referencedUnit.absolutePath() == rootUnit.absolutePath()) {
            return null;
        }
        if (this.mode == PatchMode.PATH) {
            if (resolver.resolveNamespace(rootUnit, referencedUnit) == null) {
                return null;
            }
            var aPath = referencedUnit.absolutePath().replace(/\\/g, "/");
            if (!ll.isWebPath(aPath)) {
                aPath = "file://" + aPath;
            }
            newNS = aPath + "#/" + collectionName;
        }
        else {
            var newNS = resolver.resolveNamespace(rootUnit, referencedUnit);
            if (newNS == null) {
                return null;
            }
        }
        if (gotQuestion) {
            plainName += "?";
        }
        return new PatchedReference(newNS, plainName, collectionName, referencedUnit, this.mode);
    };
    ReferencePatcher.prototype.patchUses = function (node, resolver) {
        if (!(node instanceof proxy.LowLevelCompositeNode)) {
            return;
        }
        var unit = node.unit();
        var extendedUnitMap = resolver.expandedPathMap(unit);
        if (extendedUnitMap == null) {
            return;
        }
        var unitMap = resolver.pathMap(unit);
        if (!unitMap) {
            unitMap = {};
        }
        var cNode = node;
        var originalChildren = node.children();
        var usesNodes = originalChildren.filter(function (x) {
            return x.key() == universeDef.Universe10.FragmentDeclaration.properties.uses.name;
        });
        var oNode = toOriginal(node);
        var yamlNode = oNode;
        while (yamlNode instanceof proxy.LowLevelProxyNode) {
            yamlNode = yamlNode.originalNode();
        }
        var usesInfos = Object.keys(unitMap).map(function (x) { return extendedUnitMap[x]; });
        var extendedUsesInfos = Object.keys(extendedUnitMap).map(function (x) { return extendedUnitMap[x]; })
            .filter(function (x) { return !unitMap[x.absolutePath()]; } /*&&this.usedNamespaces[x.namespace()]*/ /*&&this.usedNamespaces[x.namespace()]*/);
        var u = node.unit();
        var unitPath = u.absolutePath();
        var existingLibs = {};
        var usesNode;
        if (usesNodes.length > 0) {
            usesNode = usesNodes[0];
            usesNode.children().forEach(function (x) { return existingLibs[x.key()] = true; });
        }
        else {
            var newUses = jsyaml.createMapNode("uses");
            newUses["_parent"] = yamlNode;
            newUses.setUnit(yamlNode.unit());
            usesNode = cNode.replaceChild(null, newUses);
        }
        for (var _i = 0, _a = usesInfos.concat(extendedUsesInfos); _i < _a.length; _i++) {
            var ui = _a[_i];
            var up = ui.absolutePath();
            if (existingLibs[ui.namespace()]) {
                continue;
            }
            var ip = ui.includePath;
            var mapping = jsyaml.createMapping(ui.namespace(), ip);
            mapping.setUnit(yamlNode.unit());
            usesNode.replaceChild(null, mapping);
        }
    };
    ReferencePatcher.prototype.removeUses = function (node) {
        if (!(node instanceof proxy.LowLevelCompositeNode)) {
            return;
        }
        var cNode = node;
        var originalChildren = node.children();
        var usesNodes = originalChildren.filter(function (x) {
            return x.key() == universeDef.Universe10.FragmentDeclaration.properties.uses.name;
        });
        if (usesNodes.length > 0) {
            cNode.removeChild(usesNodes[0]);
        }
    };
    ReferencePatcher.prototype.resetTypes = function (hlNode) {
        for (var _i = 0, _a = hlNode.elements(); _i < _a.length; _i++) {
            var ch = _a[_i];
            this.resetTypes(ch);
        }
        delete hlNode.lowLevel().actual().types;
        delete hlNode["_ptype"];
        delete hlNode["_types"];
        hlNode.setAssociatedType(null);
    };
    ;
    ReferencePatcher.prototype.appendUnitIfNeeded = function (node, units) {
        if (node instanceof jsyaml.CompilationUnit) {
            var unit = node;
            if (unit.absolutePath() != units[units.length - 1].absolutePath()) {
                units.push(unit);
                return true;
            }
            return false;
        }
        var originalNode = toOriginal(node.lowLevel());
        var originalUnit = originalNode.unit();
        if (originalNode.valueKind() == yaml.Kind.INCLUDE_REF) {
            var ref = originalNode.includePath();
            var includedUnit = originalUnit.resolve(ref);
            units.push(includedUnit);
            return true;
        }
        else {
            if (originalUnit.absolutePath() != units[units.length - 1].absolutePath()) {
                units.push(originalUnit);
                return true;
            }
            return false;
        }
    };
    ReferencePatcher.prototype.popUnitIfNeeded = function (units, appended) {
        if (appended) {
            units.pop();
        }
    };
    ReferencePatcher.prototype.registerPatchedReference = function (ref) {
        var collectionName = ref.collectionName();
        if (!collectionName) {
            return;
        }
        var aPath = ref.referencedUnit().absolutePath();
        var libMap = this._outerDependencies[aPath];
        if (libMap == null) {
            libMap = {};
            this._outerDependencies[aPath] = libMap;
        }
        var collectionMap = libMap[collectionName];
        if (collectionMap == null) {
            collectionMap = {};
            libMap[collectionName] = collectionMap;
        }
        collectionMap[ref.name()] = ref;
    };
    ReferencePatcher.prototype.collectionName = function (range) {
        var collectionName;
        if (universeHelpers.isResourceTypeRefType(range) || universeHelpers.isResourceTypeType(range)) {
            collectionName = def.universesInfo.Universe10.LibraryBase.properties.resourceTypes.name;
        }
        else if (universeHelpers.isTraitRefType(range) || universeHelpers.isTraitType(range)) {
            collectionName = def.universesInfo.Universe10.LibraryBase.properties.traits.name;
        }
        else if (universeHelpers.isSecuritySchemeRefType(range) || universeHelpers.isSecuritySchemaTypeDescendant(range)) {
            collectionName = def.universesInfo.Universe10.LibraryBase.properties.securitySchemes.name;
        }
        else if (universeHelpers.isAnnotationRefTypeOrDescendant(range) || range.isAnnotationType()) {
            collectionName = def.universesInfo.Universe10.LibraryBase.properties.annotationTypes.name;
        }
        else if (universeHelpers.isTypeDeclarationDescendant(range)) {
            collectionName = def.universesInfo.Universe10.LibraryBase.properties.types.name;
        }
        return collectionName;
    };
    ReferencePatcher.prototype.expandLibraries = function (api) {
        if (api.lowLevel().actual().libExpanded) {
            return;
        }
        var llNode = api.lowLevel();
        var unit = llNode.unit();
        var rootPath = unit.absolutePath();
        var project = unit.project();
        var libModels = [];
        var resolver = llNode.unit().project().namespaceResolver();
        var expandedPathMap = resolver.expandedPathMap(unit);
        if (expandedPathMap != null) {
            var libPaths = Object.keys(expandedPathMap).sort();
            for (var _i = 0, libPaths_1 = libPaths; _i < libPaths_1.length; _i++) {
                var ns = libPaths_1[_i];
                var libModel = this._libModels[ns];
                if (libModel == null) {
                    var libUnit = project.unit(ns, true);
                    if (libUnit && resolver.resolveNamespace(unit, libUnit) != null) {
                        libModel = this.extractLibModel(libUnit);
                    }
                }
                if (libModel) {
                    libModels.push(libModel);
                }
            }
            var gotContribution = false;
            for (var _a = 0, libModels_1 = libModels; _a < libModels_1.length; _a++) {
                var libModel = libModels_1[_a];
                for (var _b = 0, _c = Object.keys(libModel); _b < _c.length; _b++) {
                    var cName = _c[_b];
                    var collection = libModel[cName];
                    if (collection instanceof ElementsCollection) {
                        gotContribution = this.contributeCollection(api.lowLevel(), collection) || gotContribution;
                    }
                }
            }
            this.resetTypes(api);
            api.resetChildren();
            if (gotContribution) {
                var gotPatch = false;
                do {
                    gotPatch = this.patchDependencies(api);
                } while (gotPatch);
                this.removeUnusedDependencies(api);
            }
        }
        this.removeUses(api.lowLevel());
        api.lowLevel().actual().libExpanded = true;
        this.resetTypes(api);
        api.resetChildren();
    };
    ReferencePatcher.prototype.patchDependencies = function (api) {
        var result = false;
        var apiPath = api.lowLevel().unit().absolutePath();
        for (var _i = 0, _a = api.children(); _i < _a.length; _i++) {
            var ch = _a[_i];
            if (!ch.isElement() || ch.lowLevel()["libProcessed"]) {
                continue;
            }
            var chNode = ch.asElement();
            this.removeUses(chNode.lowLevel());
            var chPath = ch.lowLevel().unit().absolutePath();
            if (chPath == apiPath && ch.lowLevel().includePath() == null) {
                continue;
            }
            var dependencies = this._outerDependencies[chPath];
            if (dependencies == null) {
                continue;
            }
            var pName = chNode.property().nameId();
            var depCollection = dependencies[pName];
            if (depCollection == null) {
                continue;
            }
            var chName = chNode.name();
            if (depCollection[chName] == null) {
                continue;
            }
            this.process(chNode, api, true, true);
            result = true;
        }
        return result;
    };
    ReferencePatcher.prototype.removeUnusedDependencies = function (api) {
        var llNode = api.lowLevel();
        var apiPath = llNode.unit().absolutePath();
        var children = [].concat(api.children());
        for (var _i = 0, children_1 = children; _i < children_1.length; _i++) {
            var ch = children_1[_i];
            var chLl = ch.lowLevel();
            if (ch.isElement() && chLl["libProcessed"]) {
                continue;
            }
            var chPath = chLl.unit().absolutePath();
            if (chPath == apiPath) {
                continue;
            }
            chLl.parent().removeChild(chLl);
        }
    };
    ReferencePatcher.prototype.contributeCollection = function (llApi, collection) {
        var name = collection.name;
        var llNode = _.find(llApi.children(), function (x) { return x.key() == name; });
        if (llNode == null) {
            var n = jsyaml.createMapNode(name);
            llNode = llApi.replaceChild(null, n);
        }
        var result = false;
        for (var _i = 0, _a = collection.array; _i < _a.length; _i++) {
            var e = _a[_i];
            if (llNode.children().some(function (x) {
                var oNode = toOriginal(x);
                if (oNode.unit().absolutePath() != e.lowLevel().unit().absolutePath()) {
                    return false;
                }
                return e.lowLevel().key() == oNode.key() && e.lowLevel().unit().absolutePath() == oNode.unit().absolutePath();
            })) {
                continue;
            }
            llNode.replaceChild(null, e.lowLevel());
            result = true;
        }
        return result;
    };
    ReferencePatcher.prototype.extractLibModel = function (unit) {
        var result = this._libModels[unit.absolutePath()];
        if (result != null) {
            return result;
        }
        result = new LibModel(unit);
        this._libModels[unit.absolutePath()] = result;
        var hlNode = unit.highLevel();
        if (hlNode && hlNode.isElement()) {
            for (var _i = 0, _a = ["resourceTypes", "traits", "types", "annotationTypes", "securitySchemes"]; _i < _a.length; _i++) {
                var cName = _a[_i];
                var collection = new ElementsCollection(cName);
                for (var _b = 0, _c = hlNode.asElement().elementsOfKind(cName); _b < _c.length; _b++) {
                    var el = _c[_b];
                    collection.array.push(el);
                }
                result[cName] = collection;
            }
        }
        return result;
    };
    ReferencePatcher.prototype.isCompoundValue = function (str) {
        var i0 = str.indexOf("<<");
        if (i0 < 0) {
            return false;
        }
        if (i0 != 0) {
            return true;
        }
        var i1 = str.indexOf(">>", i0);
        if (i1 + ">>".length != str.length) {
            return true;
        }
        return false;
    };
    return ReferencePatcher;
}());
exports.ReferencePatcher = ReferencePatcher;
var ParametersEscapingStatus;
(function (ParametersEscapingStatus) {
    ParametersEscapingStatus[ParametersEscapingStatus["OK"] = 0] = "OK";
    ParametersEscapingStatus[ParametersEscapingStatus["NOT_REQUIRED"] = 1] = "NOT_REQUIRED";
    ParametersEscapingStatus[ParametersEscapingStatus["ERROR"] = 2] = "ERROR";
})(ParametersEscapingStatus || (ParametersEscapingStatus = {}));
var PARAM_OCCURENCE_STR = "__P_A_R_A_M_E_T_E_R__";
function escapeTemplateParameters(str) {
    if (str == null || typeof str != "string") {
        return { status: ParametersEscapingStatus.NOT_REQUIRED };
    }
    var resultingString = "";
    var map = {};
    var prev = 0;
    for (var i = str.indexOf("<<"); i >= 0; i = str.indexOf("<<", prev)) {
        resultingString += str.substring(prev, i);
        prev = str.indexOf(">>", i);
        if (prev < 0) {
            return { status: ParametersEscapingStatus.ERROR };
        }
        prev += ">>".length;
        var paramStr = str.substring(i, prev);
        var substitution = PARAM_OCCURENCE_STR + i + PARAM_OCCURENCE_STR;
        map[substitution] = paramStr;
        resultingString += substitution;
    }
    if (resultingString.length == 0) {
        return { status: ParametersEscapingStatus.NOT_REQUIRED };
    }
    resultingString += str.substring(prev, str.length);
    return {
        resultingString: resultingString,
        substitutions: map,
        status: ParametersEscapingStatus.OK
    };
}
function unescapeTemplateParameters(str, substitutions) {
    if (str == null) {
        return { status: ParametersEscapingStatus.NOT_REQUIRED };
    }
    var resultingString = "";
    var prev = 0;
    for (var i = str.indexOf(PARAM_OCCURENCE_STR); i >= 0; i = str.indexOf(PARAM_OCCURENCE_STR, prev)) {
        prev = str.indexOf(PARAM_OCCURENCE_STR, i + 1);
        prev += PARAM_OCCURENCE_STR.length;
        if (prev < 0) {
            return { status: ParametersEscapingStatus.ERROR };
        }
        var substitution = str.substring(i, prev);
        var originalParamOccurence = substitutions[substitution];
        if (originalParamOccurence == null) {
            return { status: ParametersEscapingStatus.ERROR };
        }
        resultingString += originalParamOccurence;
    }
    if (resultingString.length == 0) {
        return { status: ParametersEscapingStatus.NOT_REQUIRED };
    }
    resultingString += str.substring(prev, str.length);
    return {
        resultingString: resultingString,
        substitutions: substitutions,
        status: ParametersEscapingStatus.OK
    };
}
function checkExpression(value) {
    var gotExpression = false;
    for (var i = 0; i < value.length; i++) {
        var ch = value.charAt(i);
        if (ch == "|" || ch == "(" || ch == "[") {
            gotExpression = true;
            break;
        }
    }
    return gotExpression;
}
;
function patchMethodIs(node, traits) {
    var llMethod = node.lowLevel();
    var ramlVersion = node.definition().universe().version();
    var originalLlMethod = toOriginal(llMethod);
    var isPropertyName = universeDef.Universe10.MethodBase.properties.is.name;
    var isNode = _.find(llMethod.children(), function (x) { return x.key() == isPropertyName; });
    if (isNode == null) {
        var newLLIsNode = new jsyaml.ASTNode(yaml.newMapping(yaml.newScalar(isPropertyName), yaml.newItems()), originalLlMethod.unit(), originalLlMethod, null, null);
        isNode = llMethod.replaceChild(null, newLLIsNode);
    }
    var originalIsNode = _.find(originalLlMethod.children(), function (x) { return x.key() == isPropertyName; });
    var childrenToPreserve = originalIsNode != null ? originalIsNode.children() : [];
    var newTraits = childrenToPreserve.concat(traits.map(function (x) {
        var llChNode = prepareTraitRefNode(x.node, isNode);
        if (llChNode != null) {
            var cNode = new proxy.LowLevelCompositeNode(llChNode, isNode, x.transformer, ramlVersion);
            return cNode;
        }
        return null;
    })).filter(function (x) { return x != null; });
    isNode.setChildren(newTraits);
    isNode.filterChildren();
    return isNode;
}
exports.patchMethodIs = patchMethodIs;
function prepareTraitRefNode(llNode, llParent) {
    llParent = toOriginal(llParent);
    llNode = toOriginal(llNode);
    var yNode = llNode.actual();
    if (yNode == null) {
        return null;
    }
    if (llNode.key() == universeDef.Universe10.MethodBase.properties.is.name) {
        yNode = llNode.yamlNode().value;
    }
    if (yNode == null) {
        return null;
    }
    if (yNode.kind == yaml.Kind.SEQ) {
        yNode = yNode.items[0];
    }
    if (yNode == null) {
        return null;
    }
    var result = new jsyaml.ASTNode(yNode, llNode.unit(), llParent, null, null);
    return result;
}
exports.prepareTraitRefNode = prepareTraitRefNode;
function toOriginal(node) {
    for (var i = 0; i < 2 && node instanceof proxy.LowLevelProxyNode; i++) {
        node = node.originalNode();
    }
    return node;
}
var PatchedReference = (function () {
    function PatchedReference(_namespace, _name, _collectionName, _referencedUnit, _mode) {
        this._namespace = _namespace;
        this._name = _name;
        this._collectionName = _collectionName;
        this._referencedUnit = _referencedUnit;
        this._mode = _mode;
    }
    PatchedReference.prototype.namespace = function () { return this._namespace; };
    PatchedReference.prototype.name = function () { return this._name; };
    PatchedReference.prototype.collectionName = function () { return this._collectionName; };
    PatchedReference.prototype.referencedUnit = function () { return this._referencedUnit; };
    PatchedReference.prototype.mode = function () { return this._mode; };
    PatchedReference.prototype.value = function () {
        if (this._namespace == null) {
            return this._name;
        }
        var delim = this._mode == PatchMode.PATH ? "/" : ".";
        return this._namespace + delim + this._name;
    };
    return PatchedReference;
}());
exports.PatchedReference = PatchedReference;
function instanceOfPatchedReference(instance) {
    if (!instance)
        return false;
    return instance.namespace != null && typeof (instance.namespace) == "function" &&
        instance.name != null && typeof (instance.name) == "function" &&
        instance.collectionName != null && typeof (instance.collectionName) == "function" &&
        instance.referencedUnit != null && typeof (instance.referencedUnit) == "function" &&
        instance.mode != null && typeof (instance.mode) == "function";
}
exports.instanceOfPatchedReference = instanceOfPatchedReference;
var ElementsCollection = (function () {
    function ElementsCollection(name) {
        this.name = name;
        this.array = [];
    }
    return ElementsCollection;
}());
var LibModel = (function () {
    function LibModel(unit) {
        this.unit = unit;
    }
    return LibModel;
}());
function getDeclaration(elementName, typeName, resolver, units) {
    if (!elementName) {
        return null;
    }
    var ns = "";
    var name = elementName;
    var ind = elementName.lastIndexOf(".");
    if (ind >= 0) {
        ns = elementName.substring(0, ind);
        name = elementName.substring(ind + 1);
    }
    var result;
    var gotLibrary = false;
    for (var i = units.length; i > 0; i--) {
        var u = units[i - 1];
        var hl = u.highLevel();
        if (hl.isElement()) {
            if (universeHelpers.isLibraryType(hl.asElement().definition())) {
                if (gotLibrary) {
                    break;
                }
                gotLibrary = true;
            }
        }
        var actualUnit = u;
        if (ns) {
            actualUnit = null;
            var map = resolver.nsMap(u);
            if (map) {
                var info = map[ns];
                if (info) {
                    actualUnit = info.unit;
                }
            }
        }
        if (!actualUnit) {
            continue;
        }
        var ahl = actualUnit.highLevel();
        if (!ahl || !ahl.isElement()) {
            continue;
        }
        result = _.find(ahl.asElement().elementsOfKind(typeName), function (x) { return x.name() == name; });
        if (result) {
            break;
        }
    }
    return result;
}
exports.getDeclaration = getDeclaration;
//# sourceMappingURL=referencePatcher.js.map