"use strict";
var jsyaml = require("./jsyaml/jsyaml2lowLevel");
var hlimpl = require("./highLevelImpl");
var yaml = require("yaml-ast-parser");
//*** THis is not needed any more *///
function createStub0(parent, property, key) {
    var p = parent.definition().property(property);
    if (!p)
        return null;
    var nc = p.range();
    var node = createStubNode(nc, p, key);
    return node;
}
exports.createStub0 = createStub0;
function genStructuredValue(type, name, mappings, parent) {
    var map = yaml.newMap(mappings.map(function (mapping) { return yaml.newMapping(yaml.newScalar(mapping.key), yaml.newScalar(mapping.value)); }));
    var node = new jsyaml.ASTNode(map, (parent ? parent.lowLevel().unit() : null), parent ? parent.lowLevel() : null, null, null);
    return new hlimpl.StructuredValue(node, parent, parent ? parent.definition().property(type) : null, name);
}
exports.genStructuredValue = genStructuredValue;
function createStub(parent, property, key) {
    var p = parent.definition().property(property);
    if (!p)
        return null;
    var nc = p.range();
    var su = parent.lowLevel().unit().stub();
    var node = createStubNode(nc, p, key, su);
    node.isInEdit = true;
    node.lowLevel()._unit = su;
    node._parent = parent.copy();
    node._parent.lowLevel()._unit = su;
    return node;
}
exports.createStub = createStub;
function createResourceStub(parent, key) {
    return createStub(parent, "resources", key);
}
exports.createResourceStub = createResourceStub;
function createMethodStub(parent, key) {
    return createStub(parent, 'methods', key);
}
exports.createMethodStub = createMethodStub;
function createResponseStub(parent, key) {
    return createStub(parent, 'responses', key);
}
exports.createResponseStub = createResponseStub;
function createBodyStub(parent, key) {
    return createStub(parent, 'body', key);
}
exports.createBodyStub = createBodyStub;
function createUriParameterStub(parent, key) {
    return createStub(parent, 'uriParameters', key);
}
exports.createUriParameterStub = createUriParameterStub;
function createQueryParameterStub(parent, key) {
    return createStub(parent, 'queryParameters', key);
}
exports.createQueryParameterStub = createQueryParameterStub;
function createAttr(_property, val) {
    var lowLevel = jsyaml.createMapping(_property.nameId(), val);
    var nm = new hlimpl.ASTPropImpl(lowLevel, null, _property.range(), _property);
    return nm;
}
exports.createAttr = createAttr;
function createStubNode(t, p, key, unit) {
    if (key === void 0) { key = null; }
    var lowLevel = jsyaml.createNode(key ? key : "key", null, unit);
    var nm = new hlimpl.ASTNodeImpl(lowLevel, null, t, p);
    if (!lowLevel.unit()) {
        lowLevel._unit = unit;
    }
    nm.children();
    return nm;
}
exports.createStubNode = createStubNode;
//# sourceMappingURL=stubs.js.map