"use strict";
/// <reference path="../../../../typings/main.d.ts" />
var fs = require("fs");
var path = require("path");
var mkdirp = require('mkdirp');
var simplet = require('simplet');
var ServerGenerator = (function () {
    function ServerGenerator(templateDir) {
        this.templateDir = templateDir;
    }
    ServerGenerator.prototype.copyfile = function (source, dest) {
        fs.createReadStream(source).pipe(fs.createWriteStream(dest));
    };
    ServerGenerator.prototype.copy = function (targetDir) {
        var _this = this;
        ServerGenerator.Files.forEach(function (file) {
            var source = path.resolve(_this.templateDir, file);
            var dest = path.resolve(targetDir, file);
            _this.copyfile(source, dest);
        });
    };
    ServerGenerator.prototype.render = function (source, context) {
        var engine = new simplet();
        var template = fs.readFileSync(source, 'utf-8');
        engine.template('model-template', template);
        var text = engine.render('model-template', context);
        engine.clear('model-template');
        return text;
    };
    ServerGenerator.prototype.renderFile = function (source, dest, context) {
        var text = this.render(source, context);
        //console.log('generated: ' + text);
        fs.writeFileSync(dest, text, 'utf-8');
    };
    ServerGenerator.prototype.generateSchema = function (type) {
        var schema = {};
        //xtitle: {type: String, required: true},
        //author: {type: String, required: true},
        //description: {type: String, required: true},
        type.properties().forEach(function (prop) {
            var p = prop;
            var po = {};
            var type = ServerGenerator.TypeMap[p.type()[0]];
            if (!type)
                type = 'String';
            po['type'] = type;
            var optional = p.optional();
            if (optional == null || optional == undefined)
                optional = false;
            po['required'] = !optional;
            schema[p.name()] = po;
        });
        return schema;
    };
    ServerGenerator.prototype.generateImports = function (name) {
        var res = '';
        res += "var " + name + " = require('./model/" + name + "');\n";
        return res;
    };
    ServerGenerator.prototype.generateRoutes = function (name) {
        var res = '';
        res += "app.use('/" + name + "', " + name + ");\n";
        return res;
    };
    ServerGenerator.prototype.generateMain = function (targetDir, type) {
        var templateFile = path.resolve(this.templateDir, 'src/main-template.js');
        //var template = fs.readFileSync(templateFile, 'utf-8');
        //console.log('template: \n' + template);
        //engine.template('model-template', template);
        var name = type.name().toLowerCase();
        var outputFile = path.resolve(targetDir, 'src/main.js');
        //var pluralName = pluralize(name);
        //var schema = JSON.stringify(this.generateSchema(type), null, 2);
        var context = {
            imports: this.generateImports(name),
            routes: this.generateRoutes(name)
        };
        this.renderFile(templateFile, outputFile, context);
    };
    ServerGenerator.prototype.generateModel = function (targetDir, type) {
        //var engine = simplet();
        var templateFile = path.resolve(this.templateDir, 'src/model/model-template.js');
        //var template = fs.readFileSync(templateFile, 'utf-8');
        //console.log('template: \n' + template);
        //engine.template('model-template', template);
        var name = type.name().toLowerCase();
        var outputFile = path.resolve(targetDir, 'src/model/' + name + '.js');
        //var pluralName = pluralize(name);
        var schema = JSON.stringify(this.generateSchema(type), null, 2);
        var context = {
            name: name,
            //pluralName: pluralName,
            schema: schema
        };
        this.renderFile(templateFile, outputFile, context);
    };
    ServerGenerator.prototype.generate = function (targetDir, type) {
        console.log('template: ' + this.templateDir);
        console.log('output  : ' + targetDir);
        mkdirp.sync(targetDir);
        mkdirp.sync(path.resolve(targetDir, 'src'));
        mkdirp.sync(path.resolve(targetDir, 'src/model'));
        this.copy(targetDir);
        this.generateModel(targetDir, type);
        this.generateMain(targetDir, type);
    };
    ServerGenerator.Files = [
        'package.json'
    ];
    ServerGenerator.TypeMap = {
        'string': 'String',
        'number': 'Number',
        'boolean': 'Boolean'
    };
    return ServerGenerator;
}());
exports.ServerGenerator = ServerGenerator;
//# sourceMappingURL=servergen.js.map