import hl = require("../highLevelAST");
import ll = require("../lowLevelAST");
import hlImpl = require("../highLevelImpl");
import def = require("raml-definition-system");
import rt = def.rt;
import defaultCalculator = require("./defaultCalculator");
import tckDumper = require("../../util/TCKDumper");
import parserCoreApi = require("./parserCoreApi");
export declare type AbstractWrapperNode = hl.AbstractWrapperNode;
export declare type BasicNode = hl.BasicNode;
export declare type SerializeOptions = hl.SerializeOptions;
export declare type ValueMetadata = hl.ValueMetadata;
export declare class BasicNodeImpl implements hl.BasicNode {
    protected _node: hl.IHighLevelNode;
    private defaultsCalculator;
    _meta: NodeMetadataImpl;
    /**
     * @hidden
     **/
    constructor(_node: hl.IHighLevelNode, setAsWrapper?: boolean);
    /**
     * @hidden
     **/
    wrapperClassName(): string;
    kind(): string;
    /**
     * @return Direct ancestor in RAML hierarchy
     **/
    parent(): BasicNode;
    /**
     * @hidden
     * @return Underlying node of the High Level model
     **/
    highLevel(): hl.IHighLevelNode;
    /**
     * @hidden
     * Replace underlying high level node
     **/
    patchNode(node: hl.IHighLevelNode): void;
    /**
     * @hidden
     **/
    protected attributes(name: string, constr?: (attr: hl.IAttribute) => any): any[];
    /**
     * @hidden
     **/
    protected attribute(name: string, constr?: (attr: hl.IAttribute) => any): any;
    /**
     * @hidden
     **/
    protected elements(name: string): any[];
    /**
     * @hidden
     **/
    protected element(name: string): any;
    /**
     * Append node as child
     * @param node node to be appended
     **/
    add(node: BasicNodeImpl): void;
    /**
     * Append node as property value
     * @param node node to be set as property value
     * @param prop name of property to set value for
     **/
    addToProp(node: BasicNodeImpl, prop: string): void;
    /**
     * Remove node from children set
     * @param node node to be removed
     **/
    remove(node: BasicNodeImpl): void;
    /**
     * @return YAML string representing the node
     **/
    dump(): string;
    toString(arg: any): string;
    toAny(arg: any): any;
    toBoolean(arg: any): boolean;
    toNumber(arg: any): any;
    /**
     * @return Array of errors
     **/
    errors(): RamlParserError[];
    private filterErrors(rawErrors);
    private basicError(x);
    /**
     * @return object representing class of the node
     **/
    definition(): hl.ITypeDefinition;
    /**
     * @return for user class instances returns object representing actual user class
     **/
    runtimeDefinition(): hl.ITypeDefinition;
    toJSON(serializeOptions?: tckDumper.SerializeOptions): any;
    /**
     * @return Whether the element is an optional sibling of trait or resource type
     **/
    optional(): boolean;
    /**
     * @return For siblings of traits or resource types returns an array of optional properties names.
     **/
    optionalProperties(): string[];
    /**
     * @hidden
     **/
    getDefaultsCalculator(): defaultCalculator.AttributeDefaultsCalculator;
    /**
     * @hidden
     **/
    setAttributeDefaults(attributeDefaults: boolean): void;
    attributeDefaults(): boolean;
    meta(): NodeMetadata;
    RAMLVersion(): string;
}
export declare class AttributeNodeImpl implements parserCoreApi.AttributeNode {
    protected attr: hl.IAttribute;
    protected _meta: ValueMetadataImpl;
    constructor(attr: hl.IAttribute);
    /**
     * @return Underlying High Level attribute node
     **/
    highLevel(): hl.IAttribute;
    /**
     * @hidden
     **/
    wrapperClassName(): string;
    kind(): string;
    /**
     * @return Whether the element is an optional sibling of trait or resource type
     **/
    optional(): boolean;
    meta(): ValueMetadataImpl;
    RAMLVersion(): string;
    parent(): BasicNode;
    toJSON(serializeOptions?: tckDumper.SerializeOptions): any;
}
/**
 * @hidden
 **/
export declare function toStructuredValue(node: hl.IAttribute): hlImpl.StructuredValue;
export declare type RamlParserError = hl.RamlParserError;
export interface ApiLoadingError extends Error {
    parserErrors: RamlParserError[];
}
export declare class TypeInstanceImpl {
    protected type: rt.IParsedType;
    constructor(nodes: ll.ILowLevelASTNode | ll.ILowLevelASTNode[], type?: rt.IParsedType);
    protected node: ll.ILowLevelASTNode;
    protected children: ll.ILowLevelASTNode[];
    properties(): TypeInstancePropertyImpl[];
    private getChildren();
    value(): any;
    isScalar(): boolean;
    toJSON(): any;
    isArray(): boolean;
    items(): TypeInstanceImpl[];
}
export declare class TypeInstancePropertyImpl {
    protected node: ll.ILowLevelASTNode;
    constructor(node: ll.ILowLevelASTNode);
    name(): string;
    value(): TypeInstanceImpl;
    values(): TypeInstanceImpl[];
    isArray(): boolean;
}
export declare type ValueMetaData = hl.ValueMetadata;
export declare type NodeMetadata = hl.NodeMetadata;
export declare class ValueMetadataImpl implements ValueMetadata {
    protected _insertedAsDefault: boolean;
    protected _calculated: boolean;
    protected _optional: boolean;
    constructor(_insertedAsDefault?: boolean, _calculated?: boolean, _optional?: boolean);
    calculated(): boolean;
    insertedAsDefault(): boolean;
    setCalculated(): void;
    setInsertedAsDefault(): void;
    setOptional(): void;
    optional(): boolean;
    isDefault(): boolean;
    toJSON(): {};
}
export declare class NodeMetadataImpl extends ValueMetadataImpl implements NodeMetadata {
    valuesMeta: {
        [key: string]: ValueMetadata;
    };
    primitiveValuesMeta(): {
        [key: string]: ValueMetadata;
    };
    registerInsertedAsDefaultValue(propName: string): void;
    registerCalculatedValue(propName: string): void;
    registerOptionalValue(propName: string): void;
    resetPrimitiveValuesMeta(): void;
    isDefault(): boolean;
    toJSON(): {};
}
export declare function fillElementMeta(node: BasicNodeImpl): NodeMetadataImpl;
export declare function attributesToValues(attrs: hl.IAttribute[], constr?: (attr: hl.IAttribute) => any): any[];
