"use strict";
var __extends = (this && this.__extends) || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
};
var hlimpl = require("./raml1/highLevelImpl");
var jsyaml = require("./raml1/jsyaml/jsyaml2lowLevel");
var stubs = require("./raml1/stubs");
function createStubNode(t, p, key, unit) {
    if (key === void 0) { key = null; }
    return stubs.createStubNode(t, p, key, unit);
}
exports.createStubNode = createStubNode;
function createStub(parent, property, key) {
    return stubs.createStub(parent, property, key);
}
exports.createStub = createStub;
function createStubNoParentPatch(parent, property, key) {
    return stubs.createStub0(parent, property, key);
}
exports.createStubNoParentPatch = createStubNoParentPatch;
function createResourceStub(parent, key) {
    return stubs.createResourceStub(parent, key);
}
exports.createResourceStub = createResourceStub;
function createMethodStub(parent, key) {
    return stubs.createMethodStub(parent, key);
}
exports.createMethodStub = createMethodStub;
function createResponseStub(parent, key) {
    return stubs.createResponseStub(parent, key);
}
exports.createResponseStub = createResponseStub;
function createBodyStub(parent, key) {
    return stubs.createBodyStub(parent, key);
}
exports.createBodyStub = createBodyStub;
function createUriParameterStub(parent, key) {
    return stubs.createUriParameterStub(parent, key);
}
exports.createUriParameterStub = createUriParameterStub;
function createQueryParameterStub(parent, key) {
    return stubs.createQueryParameterStub(parent, key);
}
exports.createQueryParameterStub = createQueryParameterStub;
function createASTPropImpl(node, parent, _def, _prop, fk) {
    if (fk === void 0) { fk = false; }
    return new hlimpl.ASTPropImpl(node, parent, _def, _prop, fk);
}
exports.createASTPropImpl = createASTPropImpl;
function createASTNodeImpl(node, parent, _def, _prop) {
    return new hlimpl.ASTNodeImpl(node, parent, _def, _prop);
}
exports.createASTNodeImpl = createASTNodeImpl;
function createVirtualASTPropImpl(node, parent, _def, _prop) {
    return new VirtualAttr(node, parent, _def, _prop);
}
exports.createVirtualASTPropImpl = createVirtualASTPropImpl;
function createVirtualNodeImpl(node, parent, _def, _prop) {
    return new VirtualNode(node, parent, _def, _prop);
}
exports.createVirtualNodeImpl = createVirtualNodeImpl;
var VirtualAttr = (function (_super) {
    __extends(VirtualAttr, _super);
    function VirtualAttr() {
        _super.apply(this, arguments);
    }
    VirtualAttr.prototype.value = function () {
        return "";
    };
    return VirtualAttr;
}(hlimpl.ASTPropImpl));
var VirtualNode = (function (_super) {
    __extends(VirtualNode, _super);
    function VirtualNode() {
        _super.apply(this, arguments);
    }
    VirtualNode.prototype.value = function () {
        return "";
    };
    return VirtualNode;
}(hlimpl.ASTNodeImpl));
function createMapping(name, value) {
    return jsyaml.createMapping(name, value);
}
exports.createMapping = createMapping;
function createMap() {
    return jsyaml.createMap([]);
}
exports.createMap = createMap;
function createAttr(_property, val) {
    return stubs.createAttr(_property, val);
}
exports.createAttr = createAttr;
//# sourceMappingURL=stubProxy.js.map