"use strict";
/// <reference path="../../typings/main.d.ts" />
var fs = require("fs");
var mkdirp = require("mkdirp");
var path = require("path");
var util = require("./index");
function copyDirSyncRecursive(to, from, opt, pathFilter, contentFilter) {
    opt = opt || {};
    if (path.resolve(to) == path.resolve(from)) {
        return;
    }
    if (opt.ignore && new RegExp(opt.ignore).exec(from) != null) {
        return;
    }
    var fd = opt.forceDelete;
    if (!fs.lstatSync(from).isDirectory()) {
        to = patch(to, to, opt.pathReplacements, opt.pathPatternReplacements);
        if (!fd && fs.existsSync(to)) {
            return;
        }
        mkdirp.sync(path.dirname(to));
        var buffer = fs.readFileSync(from);
        if (opt.contentReplacements || opt.contentPatternReplacements || contentFilter) {
            var content = buffer.toString();
            var contentLegal = contentFilter ? contentFilter(content) : true;
            if (contentLegal) {
                content = patch(to, content, opt.contentReplacements, opt.contentPatternReplacements);
                fs.writeFileSync(to, content);
            }
        }
        else {
            fs.writeFileSync(to, buffer);
        }
        return;
    }
    fs.readdirSync(from).forEach(function (x) {
        var fromChild = path.resolve(from, x);
        if (pathFilter && !pathFilter(fromChild)) {
            return;
        }
        var toChild = path.resolve(to, x);
        copyDirSyncRecursive(toChild, fromChild, opt, pathFilter, contentFilter);
    });
}
exports.copyDirSyncRecursive = copyDirSyncRecursive;
function removeDirSyncRecursive(dirPath) {
    if (!fs.existsSync(dirPath)) {
        return;
    }
    if (!fs.lstatSync(dirPath).isDirectory()) {
        fs.unlinkSync(dirPath);
        return;
    }
    fs.readdirSync(dirPath).map(function (x) { return path.resolve(dirPath, x); }).forEach(function (x) { return removeDirSyncRecursive(x); });
    fs.rmdirSync(dirPath);
}
exports.removeDirSyncRecursive = removeDirSyncRecursive;
var patch = function (filePath, target, replacements, patternReplacements) {
    if (patternReplacements) {
        var regexps = Object.keys(patternReplacements);
        for (var i = 0; i < regexps.length; i++) {
            var str = regexps[i];
            var regexp = patternReplacements[str].regexp;
            if (regexp == null) {
                regexp = new RegExp(str);
                patternReplacements[str].regexp = regexp;
            }
            if (regexp.exec(filePath) != null) {
                return util.replaceMap(target, patternReplacements[str].map);
            }
        }
    }
    if (replacements) {
        return util.replaceMap(target, replacements);
    }
    return target;
};
function copyFileSync(sourcePath, targetPath) {
    var bufferLength = 16384;
    var buffer = new Buffer(bufferLength);
    var sourceDescriptor = fs.openSync(sourcePath, 'r');
    var targetDescriptor = fs.openSync(targetPath, 'w');
    var numBytes = fs.readSync(sourceDescriptor, buffer, 0, bufferLength, 0);
    var currentPosition = 0;
    while (numBytes > 0) {
        fs.writeSync(targetDescriptor, buffer, 0, numBytes);
        currentPosition += numBytes;
        numBytes = fs.readSync(sourceDescriptor, buffer, 0, bufferLength, currentPosition);
    }
    fs.closeSync(sourceDescriptor);
    fs.closeSync(targetDescriptor);
}
exports.copyFileSync = copyFileSync;
//# sourceMappingURL=fsutil.js.map