"use strict";
var contentprovider = require('./contentprovider');
var def = require('raml-definition-system');
var su = def.getSchemaUtils();
function isScheme(content) {
    try {
        var schemeObject = JSON.parse(content);
        return schemeObject['$schema'];
    }
    catch (exception) {
        return false;
    }
}
exports.isScheme = isScheme;
function startDownloadingReferencesAsync(schemaContent, unit) {
    var schemaObject = su.getJSONSchema(schemaContent, new contentprovider.ContentProvider(unit));
    var missedReferences = schemaObject.getMissingReferences([]).map(function (reference) { return schemaObject.contentAsync(reference); });
    if (missedReferences.length === 0) {
        return Promise.resolve(unit);
    }
    var allReferences = Promise.all(missedReferences);
    var result = getRefs(allReferences, schemaObject);
    return result.then(function () { return unit; });
}
exports.startDownloadingReferencesAsync = startDownloadingReferencesAsync;
function getReferences(schemaContent, unit) {
    var schemaObject = su.getJSONSchema(schemaContent, new contentprovider.ContentProvider(unit));
    return schemaObject.getMissingReferences([], true);
}
exports.getReferences = getReferences;
function getRefs(promise, schemaObject) {
    return promise.then(function (references) {
        if (references.length > 0) {
            var missedRefs = schemaObject.getMissingReferences(references);
            if (missedRefs.length === 0) {
                return [];
            }
            var promises = [];
            missedRefs.forEach(function (ref) {
                promises.push(schemaObject.contentAsync(ref));
            });
            return getRefs(Promise.all(promises.concat(references)), schemaObject);
        }
        return Promise.resolve([]);
    });
}
//# sourceMappingURL=schemaAsync.js.map