
/**
* @preserve
* RapiDoc 9.3.8 - WebComponent to View OpenAPI docs
* License: MIT
* Repo   : https://github.com/rapi-doc/RapiDoc
* Author : Mrinmoy Majumdar
*/
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ 557:
/***/ ((__unused_webpack_module, __unused_webpack___webpack_exports__, __webpack_require__) => {

"use strict";

// UNUSED EXPORTS: JsonSchemaViewer, OAuthReceiver, RapiDocMini, default

;// ./node_modules/@lit/reactive-element/css-tag.js
/**
 * @license
 * Copyright 2019 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const t=globalThis,e=t.ShadowRoot&&(void 0===t.ShadyCSS||t.ShadyCSS.nativeShadow)&&"adoptedStyleSheets"in Document.prototype&&"replace"in CSSStyleSheet.prototype,s=Symbol(),o=new WeakMap;class n{constructor(t,e,o){if(this._$cssResult$=!0,o!==s)throw Error("CSSResult is not constructable. Use `unsafeCSS` or `css` instead.");this.cssText=t,this.t=e}get styleSheet(){let t=this.o;const s=this.t;if(e&&void 0===t){const e=void 0!==s&&1===s.length;e&&(t=o.get(s)),void 0===t&&((this.o=t=new CSSStyleSheet).replaceSync(this.cssText),e&&o.set(s,t))}return t}toString(){return this.cssText}}const r=t=>new n("string"==typeof t?t:t+"",void 0,s),i=(t,...e)=>{const o=1===t.length?t[0]:e.reduce(((e,s,o)=>e+(t=>{if(!0===t._$cssResult$)return t.cssText;if("number"==typeof t)return t;throw Error("Value passed to 'css' function must be a 'css' function result: "+t+". Use 'unsafeCSS' to pass non-literal values, but take care to ensure page security.")})(s)+t[o+1]),t[0]);return new n(o,t,s)},S=(s,o)=>{if(e)s.adoptedStyleSheets=o.map((t=>t instanceof CSSStyleSheet?t:t.styleSheet));else for(const e of o){const o=document.createElement("style"),n=t.litNonce;void 0!==n&&o.setAttribute("nonce",n),o.textContent=e.cssText,s.appendChild(o)}},c=e?t=>t:t=>t instanceof CSSStyleSheet?(t=>{let e="";for(const s of t.cssRules)e+=s.cssText;return r(e)})(t):t;
//# sourceMappingURL=css-tag.js.map

;// ./node_modules/@lit/reactive-element/reactive-element.js

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const{is:reactive_element_i,defineProperty:reactive_element_e,getOwnPropertyDescriptor:reactive_element_r,getOwnPropertyNames:h,getOwnPropertySymbols:reactive_element_o,getPrototypeOf:reactive_element_n}=Object,a=globalThis,reactive_element_c=a.trustedTypes,l=reactive_element_c?reactive_element_c.emptyScript:"",p=a.reactiveElementPolyfillSupport,d=(t,s)=>t,u={toAttribute(t,s){switch(s){case Boolean:t=t?l:null;break;case Object:case Array:t=null==t?t:JSON.stringify(t)}return t},fromAttribute(t,s){let i=t;switch(s){case Boolean:i=null!==t;break;case Number:i=null===t?null:Number(t);break;case Object:case Array:try{i=JSON.parse(t)}catch(t){i=null}}return i}},f=(t,s)=>!reactive_element_i(t,s),y={attribute:!0,type:String,converter:u,reflect:!1,hasChanged:f};Symbol.metadata??=Symbol("metadata"),a.litPropertyMetadata??=new WeakMap;class b extends HTMLElement{static addInitializer(t){this._$Ei(),(this.l??=[]).push(t)}static get observedAttributes(){return this.finalize(),this._$Eh&&[...this._$Eh.keys()]}static createProperty(t,s=y){if(s.state&&(s.attribute=!1),this._$Ei(),this.elementProperties.set(t,s),!s.noAccessor){const i=Symbol(),r=this.getPropertyDescriptor(t,i,s);void 0!==r&&reactive_element_e(this.prototype,t,r)}}static getPropertyDescriptor(t,s,i){const{get:e,set:h}=reactive_element_r(this.prototype,t)??{get(){return this[s]},set(t){this[s]=t}};return{get(){return e?.call(this)},set(s){const r=e?.call(this);h.call(this,s),this.requestUpdate(t,r,i)},configurable:!0,enumerable:!0}}static getPropertyOptions(t){return this.elementProperties.get(t)??y}static _$Ei(){if(this.hasOwnProperty(d("elementProperties")))return;const t=reactive_element_n(this);t.finalize(),void 0!==t.l&&(this.l=[...t.l]),this.elementProperties=new Map(t.elementProperties)}static finalize(){if(this.hasOwnProperty(d("finalized")))return;if(this.finalized=!0,this._$Ei(),this.hasOwnProperty(d("properties"))){const t=this.properties,s=[...h(t),...reactive_element_o(t)];for(const i of s)this.createProperty(i,t[i])}const t=this[Symbol.metadata];if(null!==t){const s=litPropertyMetadata.get(t);if(void 0!==s)for(const[t,i]of s)this.elementProperties.set(t,i)}this._$Eh=new Map;for(const[t,s]of this.elementProperties){const i=this._$Eu(t,s);void 0!==i&&this._$Eh.set(i,t)}this.elementStyles=this.finalizeStyles(this.styles)}static finalizeStyles(s){const i=[];if(Array.isArray(s)){const e=new Set(s.flat(1/0).reverse());for(const s of e)i.unshift(c(s))}else void 0!==s&&i.push(c(s));return i}static _$Eu(t,s){const i=s.attribute;return!1===i?void 0:"string"==typeof i?i:"string"==typeof t?t.toLowerCase():void 0}constructor(){super(),this._$Ep=void 0,this.isUpdatePending=!1,this.hasUpdated=!1,this._$Em=null,this._$Ev()}_$Ev(){this._$ES=new Promise((t=>this.enableUpdating=t)),this._$AL=new Map,this._$E_(),this.requestUpdate(),this.constructor.l?.forEach((t=>t(this)))}addController(t){(this._$EO??=new Set).add(t),void 0!==this.renderRoot&&this.isConnected&&t.hostConnected?.()}removeController(t){this._$EO?.delete(t)}_$E_(){const t=new Map,s=this.constructor.elementProperties;for(const i of s.keys())this.hasOwnProperty(i)&&(t.set(i,this[i]),delete this[i]);t.size>0&&(this._$Ep=t)}createRenderRoot(){const t=this.shadowRoot??this.attachShadow(this.constructor.shadowRootOptions);return S(t,this.constructor.elementStyles),t}connectedCallback(){this.renderRoot??=this.createRenderRoot(),this.enableUpdating(!0),this._$EO?.forEach((t=>t.hostConnected?.()))}enableUpdating(t){}disconnectedCallback(){this._$EO?.forEach((t=>t.hostDisconnected?.()))}attributeChangedCallback(t,s,i){this._$AK(t,i)}_$EC(t,s){const i=this.constructor.elementProperties.get(t),e=this.constructor._$Eu(t,i);if(void 0!==e&&!0===i.reflect){const r=(void 0!==i.converter?.toAttribute?i.converter:u).toAttribute(s,i.type);this._$Em=t,null==r?this.removeAttribute(e):this.setAttribute(e,r),this._$Em=null}}_$AK(t,s){const i=this.constructor,e=i._$Eh.get(t);if(void 0!==e&&this._$Em!==e){const t=i.getPropertyOptions(e),r="function"==typeof t.converter?{fromAttribute:t.converter}:void 0!==t.converter?.fromAttribute?t.converter:u;this._$Em=e,this[e]=r.fromAttribute(s,t.type),this._$Em=null}}requestUpdate(t,s,i){if(void 0!==t){if(i??=this.constructor.getPropertyOptions(t),!(i.hasChanged??f)(this[t],s))return;this.P(t,s,i)}!1===this.isUpdatePending&&(this._$ES=this._$ET())}P(t,s,i){this._$AL.has(t)||this._$AL.set(t,s),!0===i.reflect&&this._$Em!==t&&(this._$Ej??=new Set).add(t)}async _$ET(){this.isUpdatePending=!0;try{await this._$ES}catch(t){Promise.reject(t)}const t=this.scheduleUpdate();return null!=t&&await t,!this.isUpdatePending}scheduleUpdate(){return this.performUpdate()}performUpdate(){if(!this.isUpdatePending)return;if(!this.hasUpdated){if(this.renderRoot??=this.createRenderRoot(),this._$Ep){for(const[t,s]of this._$Ep)this[t]=s;this._$Ep=void 0}const t=this.constructor.elementProperties;if(t.size>0)for(const[s,i]of t)!0!==i.wrapped||this._$AL.has(s)||void 0===this[s]||this.P(s,this[s],i)}let t=!1;const s=this._$AL;try{t=this.shouldUpdate(s),t?(this.willUpdate(s),this._$EO?.forEach((t=>t.hostUpdate?.())),this.update(s)):this._$EU()}catch(s){throw t=!1,this._$EU(),s}t&&this._$AE(s)}willUpdate(t){}_$AE(t){this._$EO?.forEach((t=>t.hostUpdated?.())),this.hasUpdated||(this.hasUpdated=!0,this.firstUpdated(t)),this.updated(t)}_$EU(){this._$AL=new Map,this.isUpdatePending=!1}get updateComplete(){return this.getUpdateComplete()}getUpdateComplete(){return this._$ES}shouldUpdate(t){return!0}update(t){this._$Ej&&=this._$Ej.forEach((t=>this._$EC(t,this[t]))),this._$EU()}updated(t){}firstUpdated(t){}}b.elementStyles=[],b.shadowRootOptions={mode:"open"},b[d("elementProperties")]=new Map,b[d("finalized")]=new Map,p?.({ReactiveElement:b}),(a.reactiveElementVersions??=[]).push("2.0.4");
//# sourceMappingURL=reactive-element.js.map

;// ./node_modules/lit-html/lit-html.js
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const lit_html_n=globalThis,lit_html_c=lit_html_n.trustedTypes,lit_html_h=lit_html_c?lit_html_c.createPolicy("lit-html",{createHTML:t=>t}):void 0,lit_html_f="$lit$",v=`lit$${Math.random().toFixed(9).slice(2)}$`,m="?"+v,_=`<${m}>`,w=document,lt=()=>w.createComment(""),st=t=>null===t||"object"!=typeof t&&"function"!=typeof t,g=Array.isArray,$=t=>g(t)||"function"==typeof t?.[Symbol.iterator],x="[ \t\n\f\r]",T=/<(?:(!--|\/[^a-zA-Z])|(\/?[a-zA-Z][^>\s]*)|(\/?$))/g,E=/-->/g,k=/>/g,O=RegExp(`>|${x}(?:([^\\s"'>=/]+)(${x}*=${x}*(?:[^ \t\n\f\r"'\`<>=]|("|')|))|$)`,"g"),lit_html_S=/'/g,j=/"/g,M=/^(?:script|style|textarea|title)$/i,P=t=>(i,...s)=>({_$litType$:t,strings:i,values:s}),ke=P(1),Oe=P(2),Se=P(3),R=Symbol.for("lit-noChange"),D=Symbol.for("lit-nothing"),V=new WeakMap,I=w.createTreeWalker(w,129);function N(t,i){if(!g(t)||!t.hasOwnProperty("raw"))throw Error("invalid template strings array");return void 0!==lit_html_h?lit_html_h.createHTML(i):i}const U=(t,i)=>{const s=t.length-1,e=[];let h,o=2===i?"<svg>":3===i?"<math>":"",n=T;for(let i=0;i<s;i++){const s=t[i];let r,l,c=-1,a=0;for(;a<s.length&&(n.lastIndex=a,l=n.exec(s),null!==l);)a=n.lastIndex,n===T?"!--"===l[1]?n=E:void 0!==l[1]?n=k:void 0!==l[2]?(M.test(l[2])&&(h=RegExp("</"+l[2],"g")),n=O):void 0!==l[3]&&(n=O):n===O?">"===l[0]?(n=h??T,c=-1):void 0===l[1]?c=-2:(c=n.lastIndex-l[2].length,r=l[1],n=void 0===l[3]?O:'"'===l[3]?j:lit_html_S):n===j||n===lit_html_S?n=O:n===E||n===k?n=T:(n=O,h=void 0);const u=n===O&&t[i+1].startsWith("/>")?" ":"";o+=n===T?s+_:c>=0?(e.push(r),s.slice(0,c)+lit_html_f+s.slice(c)+v+u):s+v+(-2===c?i:u)}return[N(t,o+(t[s]||"<?>")+(2===i?"</svg>":3===i?"</math>":"")),e]};class B{constructor({strings:t,_$litType$:i},s){let e;this.parts=[];let h=0,o=0;const n=t.length-1,r=this.parts,[l,a]=U(t,i);if(this.el=B.createElement(l,s),I.currentNode=this.el.content,2===i||3===i){const t=this.el.content.firstChild;t.replaceWith(...t.childNodes)}for(;null!==(e=I.nextNode())&&r.length<n;){if(1===e.nodeType){if(e.hasAttributes())for(const t of e.getAttributeNames())if(t.endsWith(lit_html_f)){const i=a[o++],s=e.getAttribute(t).split(v),n=/([.?@])?(.*)/.exec(i);r.push({type:1,index:h,name:n[2],strings:s,ctor:"."===n[1]?Y:"?"===n[1]?Z:"@"===n[1]?q:G}),e.removeAttribute(t)}else t.startsWith(v)&&(r.push({type:6,index:h}),e.removeAttribute(t));if(M.test(e.tagName)){const t=e.textContent.split(v),i=t.length-1;if(i>0){e.textContent=lit_html_c?lit_html_c.emptyScript:"";for(let s=0;s<i;s++)e.append(t[s],lt()),I.nextNode(),r.push({type:2,index:++h});e.append(t[i],lt())}}}else if(8===e.nodeType)if(e.data===m)r.push({type:2,index:h});else{let t=-1;for(;-1!==(t=e.data.indexOf(v,t+1));)r.push({type:7,index:h}),t+=v.length-1}h++}}static createElement(t,i){const s=w.createElement("template");return s.innerHTML=t,s}}function z(t,i,s=t,e){if(i===R)return i;let h=void 0!==e?s.o?.[e]:s.l;const o=st(i)?void 0:i._$litDirective$;return h?.constructor!==o&&(h?._$AO?.(!1),void 0===o?h=void 0:(h=new o(t),h._$AT(t,s,e)),void 0!==e?(s.o??=[])[e]=h:s.l=h),void 0!==h&&(i=z(t,h._$AS(t,i.values),h,e)),i}class F{constructor(t,i){this._$AV=[],this._$AN=void 0,this._$AD=t,this._$AM=i}get parentNode(){return this._$AM.parentNode}get _$AU(){return this._$AM._$AU}u(t){const{el:{content:i},parts:s}=this._$AD,e=(t?.creationScope??w).importNode(i,!0);I.currentNode=e;let h=I.nextNode(),o=0,n=0,r=s[0];for(;void 0!==r;){if(o===r.index){let i;2===r.type?i=new et(h,h.nextSibling,this,t):1===r.type?i=new r.ctor(h,r.name,r.strings,this,t):6===r.type&&(i=new K(h,this,t)),this._$AV.push(i),r=s[++n]}o!==r?.index&&(h=I.nextNode(),o++)}return I.currentNode=w,e}p(t){let i=0;for(const s of this._$AV)void 0!==s&&(void 0!==s.strings?(s._$AI(t,s,i),i+=s.strings.length-2):s._$AI(t[i])),i++}}class et{get _$AU(){return this._$AM?._$AU??this.v}constructor(t,i,s,e){this.type=2,this._$AH=D,this._$AN=void 0,this._$AA=t,this._$AB=i,this._$AM=s,this.options=e,this.v=e?.isConnected??!0}get parentNode(){let t=this._$AA.parentNode;const i=this._$AM;return void 0!==i&&11===t?.nodeType&&(t=i.parentNode),t}get startNode(){return this._$AA}get endNode(){return this._$AB}_$AI(t,i=this){t=z(this,t,i),st(t)?t===D||null==t||""===t?(this._$AH!==D&&this._$AR(),this._$AH=D):t!==this._$AH&&t!==R&&this._(t):void 0!==t._$litType$?this.$(t):void 0!==t.nodeType?this.T(t):$(t)?this.k(t):this._(t)}O(t){return this._$AA.parentNode.insertBefore(t,this._$AB)}T(t){this._$AH!==t&&(this._$AR(),this._$AH=this.O(t))}_(t){this._$AH!==D&&st(this._$AH)?this._$AA.nextSibling.data=t:this.T(w.createTextNode(t)),this._$AH=t}$(t){const{values:i,_$litType$:s}=t,e="number"==typeof s?this._$AC(t):(void 0===s.el&&(s.el=B.createElement(N(s.h,s.h[0]),this.options)),s);if(this._$AH?._$AD===e)this._$AH.p(i);else{const t=new F(e,this),s=t.u(this.options);t.p(i),this.T(s),this._$AH=t}}_$AC(t){let i=V.get(t.strings);return void 0===i&&V.set(t.strings,i=new B(t)),i}k(t){g(this._$AH)||(this._$AH=[],this._$AR());const i=this._$AH;let s,e=0;for(const h of t)e===i.length?i.push(s=new et(this.O(lt()),this.O(lt()),this,this.options)):s=i[e],s._$AI(h),e++;e<i.length&&(this._$AR(s&&s._$AB.nextSibling,e),i.length=e)}_$AR(t=this._$AA.nextSibling,i){for(this._$AP?.(!1,!0,i);t&&t!==this._$AB;){const i=t.nextSibling;t.remove(),t=i}}setConnected(t){void 0===this._$AM&&(this.v=t,this._$AP?.(t))}}class G{get tagName(){return this.element.tagName}get _$AU(){return this._$AM._$AU}constructor(t,i,s,e,h){this.type=1,this._$AH=D,this._$AN=void 0,this.element=t,this.name=i,this._$AM=e,this.options=h,s.length>2||""!==s[0]||""!==s[1]?(this._$AH=Array(s.length-1).fill(new String),this.strings=s):this._$AH=D}_$AI(t,i=this,s,e){const h=this.strings;let o=!1;if(void 0===h)t=z(this,t,i,0),o=!st(t)||t!==this._$AH&&t!==R,o&&(this._$AH=t);else{const e=t;let n,r;for(t=h[0],n=0;n<h.length-1;n++)r=z(this,e[s+n],i,n),r===R&&(r=this._$AH[n]),o||=!st(r)||r!==this._$AH[n],r===D?t=D:t!==D&&(t+=(r??"")+h[n+1]),this._$AH[n]=r}o&&!e&&this.j(t)}j(t){t===D?this.element.removeAttribute(this.name):this.element.setAttribute(this.name,t??"")}}class Y extends G{constructor(){super(...arguments),this.type=3}j(t){this.element[this.name]=t===D?void 0:t}}class Z extends G{constructor(){super(...arguments),this.type=4}j(t){this.element.toggleAttribute(this.name,!!t&&t!==D)}}class q extends G{constructor(t,i,s,e,h){super(t,i,s,e,h),this.type=5}_$AI(t,i=this){if((t=z(this,t,i,0)??D)===R)return;const s=this._$AH,e=t===D&&s!==D||t.capture!==s.capture||t.once!==s.once||t.passive!==s.passive,h=t!==D&&(s===D||e);e&&this.element.removeEventListener(this.name,this,s),h&&this.element.addEventListener(this.name,this,t),this._$AH=t}handleEvent(t){"function"==typeof this._$AH?this._$AH.call(this.options?.host??this.element,t):this._$AH.handleEvent(t)}}class K{constructor(t,i,s){this.element=t,this.type=6,this._$AN=void 0,this._$AM=i,this.options=s}get _$AU(){return this._$AM._$AU}_$AI(t){z(this,t)}}const si={M:lit_html_f,P:v,A:m,C:1,L:U,R:F,D:$,V:z,I:et,H:G,N:Z,U:q,B:Y,F:K},Re=lit_html_n.litHtmlPolyfillSupport;Re?.(B,et),(lit_html_n.litHtmlVersions??=[]).push("3.2.0");const Q=(t,i,s)=>{const e=s?.renderBefore??i;let h=e._$litPart$;if(void 0===h){const t=s?.renderBefore??null;e._$litPart$=h=new et(i.insertBefore(lt(),t),t,void 0,s??{})}return h._$AI(t),h};
//# sourceMappingURL=lit-html.js.map

;// ./node_modules/lit-element/lit-element.js

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */class lit_element_h extends b{constructor(){super(...arguments),this.renderOptions={host:this},this.o=void 0}createRenderRoot(){const t=super.createRenderRoot();return this.renderOptions.renderBefore??=t.firstChild,t}update(t){const e=this.render();this.hasUpdated||(this.renderOptions.isConnected=this.isConnected),super.update(t),this.o=Q(e,this.renderRoot,this.renderOptions)}connectedCallback(){super.connectedCallback(),this.o?.setConnected(!0)}disconnectedCallback(){super.disconnectedCallback(),this.o?.setConnected(!1)}render(){return R}}lit_element_h._$litElement$=!0,lit_element_h["finalized"]=!0,globalThis.litElementHydrateSupport?.({LitElement:lit_element_h});const lit_element_f=globalThis.litElementPolyfillSupport;lit_element_f?.({LitElement:lit_element_h});const lit_element_x={_$AK:(t,e,s)=>{t._$AK(e,s)},_$AL:t=>t._$AL};(globalThis.litElementVersions??=[]).push("4.1.0");
//# sourceMappingURL=lit-element.js.map

;// ./node_modules/lit/index.js

//# sourceMappingURL=index.js.map

;// ./node_modules/marked/lib/marked.esm.js
/**
 * marked v4.3.0 - a markdown parser
 * Copyright (c) 2011-2023, Christopher Jeffrey. (MIT Licensed)
 * https://github.com/markedjs/marked
 */

/**
 * DO NOT EDIT THIS FILE
 * The code in this file is generated from files in ./src/
 */

function getDefaults() {
  return {
    async: false,
    baseUrl: null,
    breaks: false,
    extensions: null,
    gfm: true,
    headerIds: true,
    headerPrefix: '',
    highlight: null,
    hooks: null,
    langPrefix: 'language-',
    mangle: true,
    pedantic: false,
    renderer: null,
    sanitize: false,
    sanitizer: null,
    silent: false,
    smartypants: false,
    tokenizer: null,
    walkTokens: null,
    xhtml: false
  };
}

let defaults = getDefaults();

function changeDefaults(newDefaults) {
  defaults = newDefaults;
}

/**
 * Helpers
 */
const escapeTest = /[&<>"']/;
const escapeReplace = new RegExp(escapeTest.source, 'g');
const escapeTestNoEncode = /[<>"']|&(?!(#\d{1,7}|#[Xx][a-fA-F0-9]{1,6}|\w+);)/;
const escapeReplaceNoEncode = new RegExp(escapeTestNoEncode.source, 'g');
const escapeReplacements = {
  '&': '&amp;',
  '<': '&lt;',
  '>': '&gt;',
  '"': '&quot;',
  "'": '&#39;'
};
const getEscapeReplacement = (ch) => escapeReplacements[ch];
function marked_esm_escape(html, encode) {
  if (encode) {
    if (escapeTest.test(html)) {
      return html.replace(escapeReplace, getEscapeReplacement);
    }
  } else {
    if (escapeTestNoEncode.test(html)) {
      return html.replace(escapeReplaceNoEncode, getEscapeReplacement);
    }
  }

  return html;
}

const unescapeTest = /&(#(?:\d+)|(?:#x[0-9A-Fa-f]+)|(?:\w+));?/ig;

/**
 * @param {string} html
 */
function marked_esm_unescape(html) {
  // explicitly match decimal, hex, and named HTML entities
  return html.replace(unescapeTest, (_, n) => {
    n = n.toLowerCase();
    if (n === 'colon') return ':';
    if (n.charAt(0) === '#') {
      return n.charAt(1) === 'x'
        ? String.fromCharCode(parseInt(n.substring(2), 16))
        : String.fromCharCode(+n.substring(1));
    }
    return '';
  });
}

const caret = /(^|[^\[])\^/g;

/**
 * @param {string | RegExp} regex
 * @param {string} opt
 */
function edit(regex, opt) {
  regex = typeof regex === 'string' ? regex : regex.source;
  opt = opt || '';
  const obj = {
    replace: (name, val) => {
      val = val.source || val;
      val = val.replace(caret, '$1');
      regex = regex.replace(name, val);
      return obj;
    },
    getRegex: () => {
      return new RegExp(regex, opt);
    }
  };
  return obj;
}

const nonWordAndColonTest = /[^\w:]/g;
const originIndependentUrl = /^$|^[a-z][a-z0-9+.-]*:|^[?#]/i;

/**
 * @param {boolean} sanitize
 * @param {string} base
 * @param {string} href
 */
function cleanUrl(sanitize, base, href) {
  if (sanitize) {
    let prot;
    try {
      prot = decodeURIComponent(marked_esm_unescape(href))
        .replace(nonWordAndColonTest, '')
        .toLowerCase();
    } catch (e) {
      return null;
    }
    if (prot.indexOf('javascript:') === 0 || prot.indexOf('vbscript:') === 0 || prot.indexOf('data:') === 0) {
      return null;
    }
  }
  if (base && !originIndependentUrl.test(href)) {
    href = resolveUrl(base, href);
  }
  try {
    href = encodeURI(href).replace(/%25/g, '%');
  } catch (e) {
    return null;
  }
  return href;
}

const baseUrls = {};
const justDomain = /^[^:]+:\/*[^/]*$/;
const protocol = /^([^:]+:)[\s\S]*$/;
const domain = /^([^:]+:\/*[^/]*)[\s\S]*$/;

/**
 * @param {string} base
 * @param {string} href
 */
function resolveUrl(base, href) {
  if (!baseUrls[' ' + base]) {
    // we can ignore everything in base after the last slash of its path component,
    // but we might need to add _that_
    // https://tools.ietf.org/html/rfc3986#section-3
    if (justDomain.test(base)) {
      baseUrls[' ' + base] = base + '/';
    } else {
      baseUrls[' ' + base] = rtrim(base, '/', true);
    }
  }
  base = baseUrls[' ' + base];
  const relativeBase = base.indexOf(':') === -1;

  if (href.substring(0, 2) === '//') {
    if (relativeBase) {
      return href;
    }
    return base.replace(protocol, '$1') + href;
  } else if (href.charAt(0) === '/') {
    if (relativeBase) {
      return href;
    }
    return base.replace(domain, '$1') + href;
  } else {
    return base + href;
  }
}

const noopTest = { exec: function noopTest() {} };

function splitCells(tableRow, count) {
  // ensure that every cell-delimiting pipe has a space
  // before it to distinguish it from an escaped pipe
  const row = tableRow.replace(/\|/g, (match, offset, str) => {
      let escaped = false,
        curr = offset;
      while (--curr >= 0 && str[curr] === '\\') escaped = !escaped;
      if (escaped) {
        // odd number of slashes means | is escaped
        // so we leave it alone
        return '|';
      } else {
        // add space before unescaped |
        return ' |';
      }
    }),
    cells = row.split(/ \|/);
  let i = 0;

  // First/last cell in a row cannot be empty if it has no leading/trailing pipe
  if (!cells[0].trim()) { cells.shift(); }
  if (cells.length > 0 && !cells[cells.length - 1].trim()) { cells.pop(); }

  if (cells.length > count) {
    cells.splice(count);
  } else {
    while (cells.length < count) cells.push('');
  }

  for (; i < cells.length; i++) {
    // leading or trailing whitespace is ignored per the gfm spec
    cells[i] = cells[i].trim().replace(/\\\|/g, '|');
  }
  return cells;
}

/**
 * Remove trailing 'c's. Equivalent to str.replace(/c*$/, '').
 * /c*$/ is vulnerable to REDOS.
 *
 * @param {string} str
 * @param {string} c
 * @param {boolean} invert Remove suffix of non-c chars instead. Default falsey.
 */
function rtrim(str, c, invert) {
  const l = str.length;
  if (l === 0) {
    return '';
  }

  // Length of suffix matching the invert condition.
  let suffLen = 0;

  // Step left until we fail to match the invert condition.
  while (suffLen < l) {
    const currChar = str.charAt(l - suffLen - 1);
    if (currChar === c && !invert) {
      suffLen++;
    } else if (currChar !== c && invert) {
      suffLen++;
    } else {
      break;
    }
  }

  return str.slice(0, l - suffLen);
}

function findClosingBracket(str, b) {
  if (str.indexOf(b[1]) === -1) {
    return -1;
  }
  const l = str.length;
  let level = 0,
    i = 0;
  for (; i < l; i++) {
    if (str[i] === '\\') {
      i++;
    } else if (str[i] === b[0]) {
      level++;
    } else if (str[i] === b[1]) {
      level--;
      if (level < 0) {
        return i;
      }
    }
  }
  return -1;
}

function checkSanitizeDeprecation(opt) {
  if (opt && opt.sanitize && !opt.silent) {
    console.warn('marked(): sanitize and sanitizer parameters are deprecated since version 0.7.0, should not be used and will be removed in the future. Read more here: https://marked.js.org/#/USING_ADVANCED.md#options');
  }
}

// copied from https://stackoverflow.com/a/5450113/806777
/**
 * @param {string} pattern
 * @param {number} count
 */
function repeatString(pattern, count) {
  if (count < 1) {
    return '';
  }
  let result = '';
  while (count > 1) {
    if (count & 1) {
      result += pattern;
    }
    count >>= 1;
    pattern += pattern;
  }
  return result + pattern;
}

function outputLink(cap, link, raw, lexer) {
  const href = link.href;
  const title = link.title ? marked_esm_escape(link.title) : null;
  const text = cap[1].replace(/\\([\[\]])/g, '$1');

  if (cap[0].charAt(0) !== '!') {
    lexer.state.inLink = true;
    const token = {
      type: 'link',
      raw,
      href,
      title,
      text,
      tokens: lexer.inlineTokens(text)
    };
    lexer.state.inLink = false;
    return token;
  }
  return {
    type: 'image',
    raw,
    href,
    title,
    text: marked_esm_escape(text)
  };
}

function indentCodeCompensation(raw, text) {
  const matchIndentToCode = raw.match(/^(\s+)(?:```)/);

  if (matchIndentToCode === null) {
    return text;
  }

  const indentToCode = matchIndentToCode[1];

  return text
    .split('\n')
    .map(node => {
      const matchIndentInNode = node.match(/^\s+/);
      if (matchIndentInNode === null) {
        return node;
      }

      const [indentInNode] = matchIndentInNode;

      if (indentInNode.length >= indentToCode.length) {
        return node.slice(indentToCode.length);
      }

      return node;
    })
    .join('\n');
}

/**
 * Tokenizer
 */
class Tokenizer {
  constructor(options) {
    this.options = options || defaults;
  }

  space(src) {
    const cap = this.rules.block.newline.exec(src);
    if (cap && cap[0].length > 0) {
      return {
        type: 'space',
        raw: cap[0]
      };
    }
  }

  code(src) {
    const cap = this.rules.block.code.exec(src);
    if (cap) {
      const text = cap[0].replace(/^ {1,4}/gm, '');
      return {
        type: 'code',
        raw: cap[0],
        codeBlockStyle: 'indented',
        text: !this.options.pedantic
          ? rtrim(text, '\n')
          : text
      };
    }
  }

  fences(src) {
    const cap = this.rules.block.fences.exec(src);
    if (cap) {
      const raw = cap[0];
      const text = indentCodeCompensation(raw, cap[3] || '');

      return {
        type: 'code',
        raw,
        lang: cap[2] ? cap[2].trim().replace(this.rules.inline._escapes, '$1') : cap[2],
        text
      };
    }
  }

  heading(src) {
    const cap = this.rules.block.heading.exec(src);
    if (cap) {
      let text = cap[2].trim();

      // remove trailing #s
      if (/#$/.test(text)) {
        const trimmed = rtrim(text, '#');
        if (this.options.pedantic) {
          text = trimmed.trim();
        } else if (!trimmed || / $/.test(trimmed)) {
          // CommonMark requires space before trailing #s
          text = trimmed.trim();
        }
      }

      return {
        type: 'heading',
        raw: cap[0],
        depth: cap[1].length,
        text,
        tokens: this.lexer.inline(text)
      };
    }
  }

  hr(src) {
    const cap = this.rules.block.hr.exec(src);
    if (cap) {
      return {
        type: 'hr',
        raw: cap[0]
      };
    }
  }

  blockquote(src) {
    const cap = this.rules.block.blockquote.exec(src);
    if (cap) {
      const text = cap[0].replace(/^ *>[ \t]?/gm, '');
      const top = this.lexer.state.top;
      this.lexer.state.top = true;
      const tokens = this.lexer.blockTokens(text);
      this.lexer.state.top = top;
      return {
        type: 'blockquote',
        raw: cap[0],
        tokens,
        text
      };
    }
  }

  list(src) {
    let cap = this.rules.block.list.exec(src);
    if (cap) {
      let raw, istask, ischecked, indent, i, blankLine, endsWithBlankLine,
        line, nextLine, rawLine, itemContents, endEarly;

      let bull = cap[1].trim();
      const isordered = bull.length > 1;

      const list = {
        type: 'list',
        raw: '',
        ordered: isordered,
        start: isordered ? +bull.slice(0, -1) : '',
        loose: false,
        items: []
      };

      bull = isordered ? `\\d{1,9}\\${bull.slice(-1)}` : `\\${bull}`;

      if (this.options.pedantic) {
        bull = isordered ? bull : '[*+-]';
      }

      // Get next list item
      const itemRegex = new RegExp(`^( {0,3}${bull})((?:[\t ][^\\n]*)?(?:\\n|$))`);

      // Check if current bullet point can start a new List Item
      while (src) {
        endEarly = false;
        if (!(cap = itemRegex.exec(src))) {
          break;
        }

        if (this.rules.block.hr.test(src)) { // End list if bullet was actually HR (possibly move into itemRegex?)
          break;
        }

        raw = cap[0];
        src = src.substring(raw.length);

        line = cap[2].split('\n', 1)[0].replace(/^\t+/, (t) => ' '.repeat(3 * t.length));
        nextLine = src.split('\n', 1)[0];

        if (this.options.pedantic) {
          indent = 2;
          itemContents = line.trimLeft();
        } else {
          indent = cap[2].search(/[^ ]/); // Find first non-space char
          indent = indent > 4 ? 1 : indent; // Treat indented code blocks (> 4 spaces) as having only 1 indent
          itemContents = line.slice(indent);
          indent += cap[1].length;
        }

        blankLine = false;

        if (!line && /^ *$/.test(nextLine)) { // Items begin with at most one blank line
          raw += nextLine + '\n';
          src = src.substring(nextLine.length + 1);
          endEarly = true;
        }

        if (!endEarly) {
          const nextBulletRegex = new RegExp(`^ {0,${Math.min(3, indent - 1)}}(?:[*+-]|\\d{1,9}[.)])((?:[ \t][^\\n]*)?(?:\\n|$))`);
          const hrRegex = new RegExp(`^ {0,${Math.min(3, indent - 1)}}((?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$)`);
          const fencesBeginRegex = new RegExp(`^ {0,${Math.min(3, indent - 1)}}(?:\`\`\`|~~~)`);
          const headingBeginRegex = new RegExp(`^ {0,${Math.min(3, indent - 1)}}#`);

          // Check if following lines should be included in List Item
          while (src) {
            rawLine = src.split('\n', 1)[0];
            nextLine = rawLine;

            // Re-align to follow commonmark nesting rules
            if (this.options.pedantic) {
              nextLine = nextLine.replace(/^ {1,4}(?=( {4})*[^ ])/g, '  ');
            }

            // End list item if found code fences
            if (fencesBeginRegex.test(nextLine)) {
              break;
            }

            // End list item if found start of new heading
            if (headingBeginRegex.test(nextLine)) {
              break;
            }

            // End list item if found start of new bullet
            if (nextBulletRegex.test(nextLine)) {
              break;
            }

            // Horizontal rule found
            if (hrRegex.test(src)) {
              break;
            }

            if (nextLine.search(/[^ ]/) >= indent || !nextLine.trim()) { // Dedent if possible
              itemContents += '\n' + nextLine.slice(indent);
            } else {
              // not enough indentation
              if (blankLine) {
                break;
              }

              // paragraph continuation unless last line was a different block level element
              if (line.search(/[^ ]/) >= 4) { // indented code block
                break;
              }
              if (fencesBeginRegex.test(line)) {
                break;
              }
              if (headingBeginRegex.test(line)) {
                break;
              }
              if (hrRegex.test(line)) {
                break;
              }

              itemContents += '\n' + nextLine;
            }

            if (!blankLine && !nextLine.trim()) { // Check if current line is blank
              blankLine = true;
            }

            raw += rawLine + '\n';
            src = src.substring(rawLine.length + 1);
            line = nextLine.slice(indent);
          }
        }

        if (!list.loose) {
          // If the previous item ended with a blank line, the list is loose
          if (endsWithBlankLine) {
            list.loose = true;
          } else if (/\n *\n *$/.test(raw)) {
            endsWithBlankLine = true;
          }
        }

        // Check for task list items
        if (this.options.gfm) {
          istask = /^\[[ xX]\] /.exec(itemContents);
          if (istask) {
            ischecked = istask[0] !== '[ ] ';
            itemContents = itemContents.replace(/^\[[ xX]\] +/, '');
          }
        }

        list.items.push({
          type: 'list_item',
          raw,
          task: !!istask,
          checked: ischecked,
          loose: false,
          text: itemContents
        });

        list.raw += raw;
      }

      // Do not consume newlines at end of final item. Alternatively, make itemRegex *start* with any newlines to simplify/speed up endsWithBlankLine logic
      list.items[list.items.length - 1].raw = raw.trimRight();
      list.items[list.items.length - 1].text = itemContents.trimRight();
      list.raw = list.raw.trimRight();

      const l = list.items.length;

      // Item child tokens handled here at end because we needed to have the final item to trim it first
      for (i = 0; i < l; i++) {
        this.lexer.state.top = false;
        list.items[i].tokens = this.lexer.blockTokens(list.items[i].text, []);

        if (!list.loose) {
          // Check if list should be loose
          const spacers = list.items[i].tokens.filter(t => t.type === 'space');
          const hasMultipleLineBreaks = spacers.length > 0 && spacers.some(t => /\n.*\n/.test(t.raw));

          list.loose = hasMultipleLineBreaks;
        }
      }

      // Set all items to loose if list is loose
      if (list.loose) {
        for (i = 0; i < l; i++) {
          list.items[i].loose = true;
        }
      }

      return list;
    }
  }

  html(src) {
    const cap = this.rules.block.html.exec(src);
    if (cap) {
      const token = {
        type: 'html',
        raw: cap[0],
        pre: !this.options.sanitizer
          && (cap[1] === 'pre' || cap[1] === 'script' || cap[1] === 'style'),
        text: cap[0]
      };
      if (this.options.sanitize) {
        const text = this.options.sanitizer ? this.options.sanitizer(cap[0]) : marked_esm_escape(cap[0]);
        token.type = 'paragraph';
        token.text = text;
        token.tokens = this.lexer.inline(text);
      }
      return token;
    }
  }

  def(src) {
    const cap = this.rules.block.def.exec(src);
    if (cap) {
      const tag = cap[1].toLowerCase().replace(/\s+/g, ' ');
      const href = cap[2] ? cap[2].replace(/^<(.*)>$/, '$1').replace(this.rules.inline._escapes, '$1') : '';
      const title = cap[3] ? cap[3].substring(1, cap[3].length - 1).replace(this.rules.inline._escapes, '$1') : cap[3];
      return {
        type: 'def',
        tag,
        raw: cap[0],
        href,
        title
      };
    }
  }

  table(src) {
    const cap = this.rules.block.table.exec(src);
    if (cap) {
      const item = {
        type: 'table',
        header: splitCells(cap[1]).map(c => { return { text: c }; }),
        align: cap[2].replace(/^ *|\| *$/g, '').split(/ *\| */),
        rows: cap[3] && cap[3].trim() ? cap[3].replace(/\n[ \t]*$/, '').split('\n') : []
      };

      if (item.header.length === item.align.length) {
        item.raw = cap[0];

        let l = item.align.length;
        let i, j, k, row;
        for (i = 0; i < l; i++) {
          if (/^ *-+: *$/.test(item.align[i])) {
            item.align[i] = 'right';
          } else if (/^ *:-+: *$/.test(item.align[i])) {
            item.align[i] = 'center';
          } else if (/^ *:-+ *$/.test(item.align[i])) {
            item.align[i] = 'left';
          } else {
            item.align[i] = null;
          }
        }

        l = item.rows.length;
        for (i = 0; i < l; i++) {
          item.rows[i] = splitCells(item.rows[i], item.header.length).map(c => { return { text: c }; });
        }

        // parse child tokens inside headers and cells

        // header child tokens
        l = item.header.length;
        for (j = 0; j < l; j++) {
          item.header[j].tokens = this.lexer.inline(item.header[j].text);
        }

        // cell child tokens
        l = item.rows.length;
        for (j = 0; j < l; j++) {
          row = item.rows[j];
          for (k = 0; k < row.length; k++) {
            row[k].tokens = this.lexer.inline(row[k].text);
          }
        }

        return item;
      }
    }
  }

  lheading(src) {
    const cap = this.rules.block.lheading.exec(src);
    if (cap) {
      return {
        type: 'heading',
        raw: cap[0],
        depth: cap[2].charAt(0) === '=' ? 1 : 2,
        text: cap[1],
        tokens: this.lexer.inline(cap[1])
      };
    }
  }

  paragraph(src) {
    const cap = this.rules.block.paragraph.exec(src);
    if (cap) {
      const text = cap[1].charAt(cap[1].length - 1) === '\n'
        ? cap[1].slice(0, -1)
        : cap[1];
      return {
        type: 'paragraph',
        raw: cap[0],
        text,
        tokens: this.lexer.inline(text)
      };
    }
  }

  text(src) {
    const cap = this.rules.block.text.exec(src);
    if (cap) {
      return {
        type: 'text',
        raw: cap[0],
        text: cap[0],
        tokens: this.lexer.inline(cap[0])
      };
    }
  }

  escape(src) {
    const cap = this.rules.inline.escape.exec(src);
    if (cap) {
      return {
        type: 'escape',
        raw: cap[0],
        text: marked_esm_escape(cap[1])
      };
    }
  }

  tag(src) {
    const cap = this.rules.inline.tag.exec(src);
    if (cap) {
      if (!this.lexer.state.inLink && /^<a /i.test(cap[0])) {
        this.lexer.state.inLink = true;
      } else if (this.lexer.state.inLink && /^<\/a>/i.test(cap[0])) {
        this.lexer.state.inLink = false;
      }
      if (!this.lexer.state.inRawBlock && /^<(pre|code|kbd|script)(\s|>)/i.test(cap[0])) {
        this.lexer.state.inRawBlock = true;
      } else if (this.lexer.state.inRawBlock && /^<\/(pre|code|kbd|script)(\s|>)/i.test(cap[0])) {
        this.lexer.state.inRawBlock = false;
      }

      return {
        type: this.options.sanitize
          ? 'text'
          : 'html',
        raw: cap[0],
        inLink: this.lexer.state.inLink,
        inRawBlock: this.lexer.state.inRawBlock,
        text: this.options.sanitize
          ? (this.options.sanitizer
            ? this.options.sanitizer(cap[0])
            : marked_esm_escape(cap[0]))
          : cap[0]
      };
    }
  }

  link(src) {
    const cap = this.rules.inline.link.exec(src);
    if (cap) {
      const trimmedUrl = cap[2].trim();
      if (!this.options.pedantic && /^</.test(trimmedUrl)) {
        // commonmark requires matching angle brackets
        if (!(/>$/.test(trimmedUrl))) {
          return;
        }

        // ending angle bracket cannot be escaped
        const rtrimSlash = rtrim(trimmedUrl.slice(0, -1), '\\');
        if ((trimmedUrl.length - rtrimSlash.length) % 2 === 0) {
          return;
        }
      } else {
        // find closing parenthesis
        const lastParenIndex = findClosingBracket(cap[2], '()');
        if (lastParenIndex > -1) {
          const start = cap[0].indexOf('!') === 0 ? 5 : 4;
          const linkLen = start + cap[1].length + lastParenIndex;
          cap[2] = cap[2].substring(0, lastParenIndex);
          cap[0] = cap[0].substring(0, linkLen).trim();
          cap[3] = '';
        }
      }
      let href = cap[2];
      let title = '';
      if (this.options.pedantic) {
        // split pedantic href and title
        const link = /^([^'"]*[^\s])\s+(['"])(.*)\2/.exec(href);

        if (link) {
          href = link[1];
          title = link[3];
        }
      } else {
        title = cap[3] ? cap[3].slice(1, -1) : '';
      }

      href = href.trim();
      if (/^</.test(href)) {
        if (this.options.pedantic && !(/>$/.test(trimmedUrl))) {
          // pedantic allows starting angle bracket without ending angle bracket
          href = href.slice(1);
        } else {
          href = href.slice(1, -1);
        }
      }
      return outputLink(cap, {
        href: href ? href.replace(this.rules.inline._escapes, '$1') : href,
        title: title ? title.replace(this.rules.inline._escapes, '$1') : title
      }, cap[0], this.lexer);
    }
  }

  reflink(src, links) {
    let cap;
    if ((cap = this.rules.inline.reflink.exec(src))
        || (cap = this.rules.inline.nolink.exec(src))) {
      let link = (cap[2] || cap[1]).replace(/\s+/g, ' ');
      link = links[link.toLowerCase()];
      if (!link) {
        const text = cap[0].charAt(0);
        return {
          type: 'text',
          raw: text,
          text
        };
      }
      return outputLink(cap, link, cap[0], this.lexer);
    }
  }

  emStrong(src, maskedSrc, prevChar = '') {
    let match = this.rules.inline.emStrong.lDelim.exec(src);
    if (!match) return;

    // _ can't be between two alphanumerics. \p{L}\p{N} includes non-english alphabet/numbers as well
    if (match[3] && prevChar.match(/[\p{L}\p{N}]/u)) return;

    const nextChar = match[1] || match[2] || '';

    if (!nextChar || (nextChar && (prevChar === '' || this.rules.inline.punctuation.exec(prevChar)))) {
      const lLength = match[0].length - 1;
      let rDelim, rLength, delimTotal = lLength, midDelimTotal = 0;

      const endReg = match[0][0] === '*' ? this.rules.inline.emStrong.rDelimAst : this.rules.inline.emStrong.rDelimUnd;
      endReg.lastIndex = 0;

      // Clip maskedSrc to same section of string as src (move to lexer?)
      maskedSrc = maskedSrc.slice(-1 * src.length + lLength);

      while ((match = endReg.exec(maskedSrc)) != null) {
        rDelim = match[1] || match[2] || match[3] || match[4] || match[5] || match[6];

        if (!rDelim) continue; // skip single * in __abc*abc__

        rLength = rDelim.length;

        if (match[3] || match[4]) { // found another Left Delim
          delimTotal += rLength;
          continue;
        } else if (match[5] || match[6]) { // either Left or Right Delim
          if (lLength % 3 && !((lLength + rLength) % 3)) {
            midDelimTotal += rLength;
            continue; // CommonMark Emphasis Rules 9-10
          }
        }

        delimTotal -= rLength;

        if (delimTotal > 0) continue; // Haven't found enough closing delimiters

        // Remove extra characters. *a*** -> *a*
        rLength = Math.min(rLength, rLength + delimTotal + midDelimTotal);

        const raw = src.slice(0, lLength + match.index + (match[0].length - rDelim.length) + rLength);

        // Create `em` if smallest delimiter has odd char count. *a***
        if (Math.min(lLength, rLength) % 2) {
          const text = raw.slice(1, -1);
          return {
            type: 'em',
            raw,
            text,
            tokens: this.lexer.inlineTokens(text)
          };
        }

        // Create 'strong' if smallest delimiter has even char count. **a***
        const text = raw.slice(2, -2);
        return {
          type: 'strong',
          raw,
          text,
          tokens: this.lexer.inlineTokens(text)
        };
      }
    }
  }

  codespan(src) {
    const cap = this.rules.inline.code.exec(src);
    if (cap) {
      let text = cap[2].replace(/\n/g, ' ');
      const hasNonSpaceChars = /[^ ]/.test(text);
      const hasSpaceCharsOnBothEnds = /^ /.test(text) && / $/.test(text);
      if (hasNonSpaceChars && hasSpaceCharsOnBothEnds) {
        text = text.substring(1, text.length - 1);
      }
      text = marked_esm_escape(text, true);
      return {
        type: 'codespan',
        raw: cap[0],
        text
      };
    }
  }

  br(src) {
    const cap = this.rules.inline.br.exec(src);
    if (cap) {
      return {
        type: 'br',
        raw: cap[0]
      };
    }
  }

  del(src) {
    const cap = this.rules.inline.del.exec(src);
    if (cap) {
      return {
        type: 'del',
        raw: cap[0],
        text: cap[2],
        tokens: this.lexer.inlineTokens(cap[2])
      };
    }
  }

  autolink(src, mangle) {
    const cap = this.rules.inline.autolink.exec(src);
    if (cap) {
      let text, href;
      if (cap[2] === '@') {
        text = marked_esm_escape(this.options.mangle ? mangle(cap[1]) : cap[1]);
        href = 'mailto:' + text;
      } else {
        text = marked_esm_escape(cap[1]);
        href = text;
      }

      return {
        type: 'link',
        raw: cap[0],
        text,
        href,
        tokens: [
          {
            type: 'text',
            raw: text,
            text
          }
        ]
      };
    }
  }

  url(src, mangle) {
    let cap;
    if (cap = this.rules.inline.url.exec(src)) {
      let text, href;
      if (cap[2] === '@') {
        text = marked_esm_escape(this.options.mangle ? mangle(cap[0]) : cap[0]);
        href = 'mailto:' + text;
      } else {
        // do extended autolink path validation
        let prevCapZero;
        do {
          prevCapZero = cap[0];
          cap[0] = this.rules.inline._backpedal.exec(cap[0])[0];
        } while (prevCapZero !== cap[0]);
        text = marked_esm_escape(cap[0]);
        if (cap[1] === 'www.') {
          href = 'http://' + cap[0];
        } else {
          href = cap[0];
        }
      }
      return {
        type: 'link',
        raw: cap[0],
        text,
        href,
        tokens: [
          {
            type: 'text',
            raw: text,
            text
          }
        ]
      };
    }
  }

  inlineText(src, smartypants) {
    const cap = this.rules.inline.text.exec(src);
    if (cap) {
      let text;
      if (this.lexer.state.inRawBlock) {
        text = this.options.sanitize ? (this.options.sanitizer ? this.options.sanitizer(cap[0]) : marked_esm_escape(cap[0])) : cap[0];
      } else {
        text = marked_esm_escape(this.options.smartypants ? smartypants(cap[0]) : cap[0]);
      }
      return {
        type: 'text',
        raw: cap[0],
        text
      };
    }
  }
}

/**
 * Block-Level Grammar
 */
const block = {
  newline: /^(?: *(?:\n|$))+/,
  code: /^( {4}[^\n]+(?:\n(?: *(?:\n|$))*)?)+/,
  fences: /^ {0,3}(`{3,}(?=[^`\n]*(?:\n|$))|~{3,})([^\n]*)(?:\n|$)(?:|([\s\S]*?)(?:\n|$))(?: {0,3}\1[~`]* *(?=\n|$)|$)/,
  hr: /^ {0,3}((?:-[\t ]*){3,}|(?:_[ \t]*){3,}|(?:\*[ \t]*){3,})(?:\n+|$)/,
  heading: /^ {0,3}(#{1,6})(?=\s|$)(.*)(?:\n+|$)/,
  blockquote: /^( {0,3}> ?(paragraph|[^\n]*)(?:\n|$))+/,
  list: /^( {0,3}bull)([ \t][^\n]+?)?(?:\n|$)/,
  html: '^ {0,3}(?:' // optional indentation
    + '<(script|pre|style|textarea)[\\s>][\\s\\S]*?(?:</\\1>[^\\n]*\\n+|$)' // (1)
    + '|comment[^\\n]*(\\n+|$)' // (2)
    + '|<\\?[\\s\\S]*?(?:\\?>\\n*|$)' // (3)
    + '|<![A-Z][\\s\\S]*?(?:>\\n*|$)' // (4)
    + '|<!\\[CDATA\\[[\\s\\S]*?(?:\\]\\]>\\n*|$)' // (5)
    + '|</?(tag)(?: +|\\n|/?>)[\\s\\S]*?(?:(?:\\n *)+\\n|$)' // (6)
    + '|<(?!script|pre|style|textarea)([a-z][\\w-]*)(?:attribute)*? */?>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)' // (7) open tag
    + '|</(?!script|pre|style|textarea)[a-z][\\w-]*\\s*>(?=[ \\t]*(?:\\n|$))[\\s\\S]*?(?:(?:\\n *)+\\n|$)' // (7) closing tag
    + ')',
  def: /^ {0,3}\[(label)\]: *(?:\n *)?([^<\s][^\s]*|<.*?>)(?:(?: +(?:\n *)?| *\n *)(title))? *(?:\n+|$)/,
  table: noopTest,
  lheading: /^((?:.|\n(?!\n))+?)\n {0,3}(=+|-+) *(?:\n+|$)/,
  // regex template, placeholders will be replaced according to different paragraph
  // interruption rules of commonmark and the original markdown spec:
  _paragraph: /^([^\n]+(?:\n(?!hr|heading|lheading|blockquote|fences|list|html|table| +\n)[^\n]+)*)/,
  text: /^[^\n]+/
};

block._label = /(?!\s*\])(?:\\.|[^\[\]\\])+/;
block._title = /(?:"(?:\\"?|[^"\\])*"|'[^'\n]*(?:\n[^'\n]+)*\n?'|\([^()]*\))/;
block.def = edit(block.def)
  .replace('label', block._label)
  .replace('title', block._title)
  .getRegex();

block.bullet = /(?:[*+-]|\d{1,9}[.)])/;
block.listItemStart = edit(/^( *)(bull) */)
  .replace('bull', block.bullet)
  .getRegex();

block.list = edit(block.list)
  .replace(/bull/g, block.bullet)
  .replace('hr', '\\n+(?=\\1?(?:(?:- *){3,}|(?:_ *){3,}|(?:\\* *){3,})(?:\\n+|$))')
  .replace('def', '\\n+(?=' + block.def.source + ')')
  .getRegex();

block._tag = 'address|article|aside|base|basefont|blockquote|body|caption'
  + '|center|col|colgroup|dd|details|dialog|dir|div|dl|dt|fieldset|figcaption'
  + '|figure|footer|form|frame|frameset|h[1-6]|head|header|hr|html|iframe'
  + '|legend|li|link|main|menu|menuitem|meta|nav|noframes|ol|optgroup|option'
  + '|p|param|section|source|summary|table|tbody|td|tfoot|th|thead|title|tr'
  + '|track|ul';
block._comment = /<!--(?!-?>)[\s\S]*?(?:-->|$)/;
block.html = edit(block.html, 'i')
  .replace('comment', block._comment)
  .replace('tag', block._tag)
  .replace('attribute', / +[a-zA-Z:_][\w.:-]*(?: *= *"[^"\n]*"| *= *'[^'\n]*'| *= *[^\s"'=<>`]+)?/)
  .getRegex();

block.paragraph = edit(block._paragraph)
  .replace('hr', block.hr)
  .replace('heading', ' {0,3}#{1,6} ')
  .replace('|lheading', '') // setex headings don't interrupt commonmark paragraphs
  .replace('|table', '')
  .replace('blockquote', ' {0,3}>')
  .replace('fences', ' {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n')
  .replace('list', ' {0,3}(?:[*+-]|1[.)]) ') // only lists starting from 1 can interrupt
  .replace('html', '</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)')
  .replace('tag', block._tag) // pars can be interrupted by type (6) html blocks
  .getRegex();

block.blockquote = edit(block.blockquote)
  .replace('paragraph', block.paragraph)
  .getRegex();

/**
 * Normal Block Grammar
 */

block.normal = { ...block };

/**
 * GFM Block Grammar
 */

block.gfm = {
  ...block.normal,
  table: '^ *([^\\n ].*\\|.*)\\n' // Header
    + ' {0,3}(?:\\| *)?(:?-+:? *(?:\\| *:?-+:? *)*)(?:\\| *)?' // Align
    + '(?:\\n((?:(?! *\\n|hr|heading|blockquote|code|fences|list|html).*(?:\\n|$))*)\\n*|$)' // Cells
};

block.gfm.table = edit(block.gfm.table)
  .replace('hr', block.hr)
  .replace('heading', ' {0,3}#{1,6} ')
  .replace('blockquote', ' {0,3}>')
  .replace('code', ' {4}[^\\n]')
  .replace('fences', ' {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n')
  .replace('list', ' {0,3}(?:[*+-]|1[.)]) ') // only lists starting from 1 can interrupt
  .replace('html', '</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)')
  .replace('tag', block._tag) // tables can be interrupted by type (6) html blocks
  .getRegex();

block.gfm.paragraph = edit(block._paragraph)
  .replace('hr', block.hr)
  .replace('heading', ' {0,3}#{1,6} ')
  .replace('|lheading', '') // setex headings don't interrupt commonmark paragraphs
  .replace('table', block.gfm.table) // interrupt paragraphs with table
  .replace('blockquote', ' {0,3}>')
  .replace('fences', ' {0,3}(?:`{3,}(?=[^`\\n]*\\n)|~{3,})[^\\n]*\\n')
  .replace('list', ' {0,3}(?:[*+-]|1[.)]) ') // only lists starting from 1 can interrupt
  .replace('html', '</?(?:tag)(?: +|\\n|/?>)|<(?:script|pre|style|textarea|!--)')
  .replace('tag', block._tag) // pars can be interrupted by type (6) html blocks
  .getRegex();
/**
 * Pedantic grammar (original John Gruber's loose markdown specification)
 */

block.pedantic = {
  ...block.normal,
  html: edit(
    '^ *(?:comment *(?:\\n|\\s*$)'
    + '|<(tag)[\\s\\S]+?</\\1> *(?:\\n{2,}|\\s*$)' // closed tag
    + '|<tag(?:"[^"]*"|\'[^\']*\'|\\s[^\'"/>\\s]*)*?/?> *(?:\\n{2,}|\\s*$))')
    .replace('comment', block._comment)
    .replace(/tag/g, '(?!(?:'
      + 'a|em|strong|small|s|cite|q|dfn|abbr|data|time|code|var|samp|kbd|sub'
      + '|sup|i|b|u|mark|ruby|rt|rp|bdi|bdo|span|br|wbr|ins|del|img)'
      + '\\b)\\w+(?!:|[^\\w\\s@]*@)\\b')
    .getRegex(),
  def: /^ *\[([^\]]+)\]: *<?([^\s>]+)>?(?: +(["(][^\n]+[")]))? *(?:\n+|$)/,
  heading: /^(#{1,6})(.*)(?:\n+|$)/,
  fences: noopTest, // fences not supported
  lheading: /^(.+?)\n {0,3}(=+|-+) *(?:\n+|$)/,
  paragraph: edit(block.normal._paragraph)
    .replace('hr', block.hr)
    .replace('heading', ' *#{1,6} *[^\n]')
    .replace('lheading', block.lheading)
    .replace('blockquote', ' {0,3}>')
    .replace('|fences', '')
    .replace('|list', '')
    .replace('|html', '')
    .getRegex()
};

/**
 * Inline-Level Grammar
 */
const inline = {
  escape: /^\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/,
  autolink: /^<(scheme:[^\s\x00-\x1f<>]*|email)>/,
  url: noopTest,
  tag: '^comment'
    + '|^</[a-zA-Z][\\w:-]*\\s*>' // self-closing tag
    + '|^<[a-zA-Z][\\w-]*(?:attribute)*?\\s*/?>' // open tag
    + '|^<\\?[\\s\\S]*?\\?>' // processing instruction, e.g. <?php ?>
    + '|^<![a-zA-Z]+\\s[\\s\\S]*?>' // declaration, e.g. <!DOCTYPE html>
    + '|^<!\\[CDATA\\[[\\s\\S]*?\\]\\]>', // CDATA section
  link: /^!?\[(label)\]\(\s*(href)(?:\s+(title))?\s*\)/,
  reflink: /^!?\[(label)\]\[(ref)\]/,
  nolink: /^!?\[(ref)\](?:\[\])?/,
  reflinkSearch: 'reflink|nolink(?!\\()',
  emStrong: {
    lDelim: /^(?:\*+(?:([punct_])|[^\s*]))|^_+(?:([punct*])|([^\s_]))/,
    //        (1) and (2) can only be a Right Delimiter. (3) and (4) can only be Left.  (5) and (6) can be either Left or Right.
    //          () Skip orphan inside strong                                      () Consume to delim     (1) #***                (2) a***#, a***                             (3) #***a, ***a                 (4) ***#              (5) #***#                 (6) a***a
    rDelimAst: /^(?:[^_*\\]|\\.)*?\_\_(?:[^_*\\]|\\.)*?\*(?:[^_*\\]|\\.)*?(?=\_\_)|(?:[^*\\]|\\.)+(?=[^*])|[punct_](\*+)(?=[\s]|$)|(?:[^punct*_\s\\]|\\.)(\*+)(?=[punct_\s]|$)|[punct_\s](\*+)(?=[^punct*_\s])|[\s](\*+)(?=[punct_])|[punct_](\*+)(?=[punct_])|(?:[^punct*_\s\\]|\\.)(\*+)(?=[^punct*_\s])/,
    rDelimUnd: /^(?:[^_*\\]|\\.)*?\*\*(?:[^_*\\]|\\.)*?\_(?:[^_*\\]|\\.)*?(?=\*\*)|(?:[^_\\]|\\.)+(?=[^_])|[punct*](\_+)(?=[\s]|$)|(?:[^punct*_\s\\]|\\.)(\_+)(?=[punct*\s]|$)|[punct*\s](\_+)(?=[^punct*_\s])|[\s](\_+)(?=[punct*])|[punct*](\_+)(?=[punct*])/ // ^- Not allowed for _
  },
  code: /^(`+)([^`]|[^`][\s\S]*?[^`])\1(?!`)/,
  br: /^( {2,}|\\)\n(?!\s*$)/,
  del: noopTest,
  text: /^(`+|[^`])(?:(?= {2,}\n)|[\s\S]*?(?:(?=[\\<!\[`*_]|\b_|$)|[^ ](?= {2,}\n)))/,
  punctuation: /^([\spunctuation])/
};

// list of punctuation marks from CommonMark spec
// without * and _ to handle the different emphasis markers * and _
inline._punctuation = '!"#$%&\'()+\\-.,/:;<=>?@\\[\\]`^{|}~';
inline.punctuation = edit(inline.punctuation).replace(/punctuation/g, inline._punctuation).getRegex();

// sequences em should skip over [title](link), `code`, <html>
inline.blockSkip = /\[[^\]]*?\]\([^\)]*?\)|`[^`]*?`|<[^>]*?>/g;
// lookbehind is not available on Safari as of version 16
// inline.escapedEmSt = /(?<=(?:^|[^\\)(?:\\[^])*)\\[*_]/g;
inline.escapedEmSt = /(?:^|[^\\])(?:\\\\)*\\[*_]/g;

inline._comment = edit(block._comment).replace('(?:-->|$)', '-->').getRegex();

inline.emStrong.lDelim = edit(inline.emStrong.lDelim)
  .replace(/punct/g, inline._punctuation)
  .getRegex();

inline.emStrong.rDelimAst = edit(inline.emStrong.rDelimAst, 'g')
  .replace(/punct/g, inline._punctuation)
  .getRegex();

inline.emStrong.rDelimUnd = edit(inline.emStrong.rDelimUnd, 'g')
  .replace(/punct/g, inline._punctuation)
  .getRegex();

inline._escapes = /\\([!"#$%&'()*+,\-./:;<=>?@\[\]\\^_`{|}~])/g;

inline._scheme = /[a-zA-Z][a-zA-Z0-9+.-]{1,31}/;
inline._email = /[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+(@)[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)+(?![-_])/;
inline.autolink = edit(inline.autolink)
  .replace('scheme', inline._scheme)
  .replace('email', inline._email)
  .getRegex();

inline._attribute = /\s+[a-zA-Z:_][\w.:-]*(?:\s*=\s*"[^"]*"|\s*=\s*'[^']*'|\s*=\s*[^\s"'=<>`]+)?/;

inline.tag = edit(inline.tag)
  .replace('comment', inline._comment)
  .replace('attribute', inline._attribute)
  .getRegex();

inline._label = /(?:\[(?:\\.|[^\[\]\\])*\]|\\.|`[^`]*`|[^\[\]\\`])*?/;
inline._href = /<(?:\\.|[^\n<>\\])+>|[^\s\x00-\x1f]*/;
inline._title = /"(?:\\"?|[^"\\])*"|'(?:\\'?|[^'\\])*'|\((?:\\\)?|[^)\\])*\)/;

inline.link = edit(inline.link)
  .replace('label', inline._label)
  .replace('href', inline._href)
  .replace('title', inline._title)
  .getRegex();

inline.reflink = edit(inline.reflink)
  .replace('label', inline._label)
  .replace('ref', block._label)
  .getRegex();

inline.nolink = edit(inline.nolink)
  .replace('ref', block._label)
  .getRegex();

inline.reflinkSearch = edit(inline.reflinkSearch, 'g')
  .replace('reflink', inline.reflink)
  .replace('nolink', inline.nolink)
  .getRegex();

/**
 * Normal Inline Grammar
 */

inline.normal = { ...inline };

/**
 * Pedantic Inline Grammar
 */

inline.pedantic = {
  ...inline.normal,
  strong: {
    start: /^__|\*\*/,
    middle: /^__(?=\S)([\s\S]*?\S)__(?!_)|^\*\*(?=\S)([\s\S]*?\S)\*\*(?!\*)/,
    endAst: /\*\*(?!\*)/g,
    endUnd: /__(?!_)/g
  },
  em: {
    start: /^_|\*/,
    middle: /^()\*(?=\S)([\s\S]*?\S)\*(?!\*)|^_(?=\S)([\s\S]*?\S)_(?!_)/,
    endAst: /\*(?!\*)/g,
    endUnd: /_(?!_)/g
  },
  link: edit(/^!?\[(label)\]\((.*?)\)/)
    .replace('label', inline._label)
    .getRegex(),
  reflink: edit(/^!?\[(label)\]\s*\[([^\]]*)\]/)
    .replace('label', inline._label)
    .getRegex()
};

/**
 * GFM Inline Grammar
 */

inline.gfm = {
  ...inline.normal,
  escape: edit(inline.escape).replace('])', '~|])').getRegex(),
  _extended_email: /[A-Za-z0-9._+-]+(@)[a-zA-Z0-9-_]+(?:\.[a-zA-Z0-9-_]*[a-zA-Z0-9])+(?![-_])/,
  url: /^((?:ftp|https?):\/\/|www\.)(?:[a-zA-Z0-9\-]+\.?)+[^\s<]*|^email/,
  _backpedal: /(?:[^?!.,:;*_'"~()&]+|\([^)]*\)|&(?![a-zA-Z0-9]+;$)|[?!.,:;*_'"~)]+(?!$))+/,
  del: /^(~~?)(?=[^\s~])([\s\S]*?[^\s~])\1(?=[^~]|$)/,
  text: /^([`~]+|[^`~])(?:(?= {2,}\n)|(?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)|[\s\S]*?(?:(?=[\\<!\[`*~_]|\b_|https?:\/\/|ftp:\/\/|www\.|$)|[^ ](?= {2,}\n)|[^a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-](?=[a-zA-Z0-9.!#$%&'*+\/=?_`{\|}~-]+@)))/
};

inline.gfm.url = edit(inline.gfm.url, 'i')
  .replace('email', inline.gfm._extended_email)
  .getRegex();
/**
 * GFM + Line Breaks Inline Grammar
 */

inline.breaks = {
  ...inline.gfm,
  br: edit(inline.br).replace('{2,}', '*').getRegex(),
  text: edit(inline.gfm.text)
    .replace('\\b_', '\\b_| {2,}\\n')
    .replace(/\{2,\}/g, '*')
    .getRegex()
};

/**
 * smartypants text replacement
 * @param {string} text
 */
function smartypants(text) {
  return text
    // em-dashes
    .replace(/---/g, '\u2014')
    // en-dashes
    .replace(/--/g, '\u2013')
    // opening singles
    .replace(/(^|[-\u2014/(\[{"\s])'/g, '$1\u2018')
    // closing singles & apostrophes
    .replace(/'/g, '\u2019')
    // opening doubles
    .replace(/(^|[-\u2014/(\[{\u2018\s])"/g, '$1\u201c')
    // closing doubles
    .replace(/"/g, '\u201d')
    // ellipses
    .replace(/\.{3}/g, '\u2026');
}

/**
 * mangle email addresses
 * @param {string} text
 */
function mangle(text) {
  let out = '',
    i,
    ch;

  const l = text.length;
  for (i = 0; i < l; i++) {
    ch = text.charCodeAt(i);
    if (Math.random() > 0.5) {
      ch = 'x' + ch.toString(16);
    }
    out += '&#' + ch + ';';
  }

  return out;
}

/**
 * Block Lexer
 */
class Lexer {
  constructor(options) {
    this.tokens = [];
    this.tokens.links = Object.create(null);
    this.options = options || defaults;
    this.options.tokenizer = this.options.tokenizer || new Tokenizer();
    this.tokenizer = this.options.tokenizer;
    this.tokenizer.options = this.options;
    this.tokenizer.lexer = this;
    this.inlineQueue = [];
    this.state = {
      inLink: false,
      inRawBlock: false,
      top: true
    };

    const rules = {
      block: block.normal,
      inline: inline.normal
    };

    if (this.options.pedantic) {
      rules.block = block.pedantic;
      rules.inline = inline.pedantic;
    } else if (this.options.gfm) {
      rules.block = block.gfm;
      if (this.options.breaks) {
        rules.inline = inline.breaks;
      } else {
        rules.inline = inline.gfm;
      }
    }
    this.tokenizer.rules = rules;
  }

  /**
   * Expose Rules
   */
  static get rules() {
    return {
      block,
      inline
    };
  }

  /**
   * Static Lex Method
   */
  static lex(src, options) {
    const lexer = new Lexer(options);
    return lexer.lex(src);
  }

  /**
   * Static Lex Inline Method
   */
  static lexInline(src, options) {
    const lexer = new Lexer(options);
    return lexer.inlineTokens(src);
  }

  /**
   * Preprocessing
   */
  lex(src) {
    src = src
      .replace(/\r\n|\r/g, '\n');

    this.blockTokens(src, this.tokens);

    let next;
    while (next = this.inlineQueue.shift()) {
      this.inlineTokens(next.src, next.tokens);
    }

    return this.tokens;
  }

  /**
   * Lexing
   */
  blockTokens(src, tokens = []) {
    if (this.options.pedantic) {
      src = src.replace(/\t/g, '    ').replace(/^ +$/gm, '');
    } else {
      src = src.replace(/^( *)(\t+)/gm, (_, leading, tabs) => {
        return leading + '    '.repeat(tabs.length);
      });
    }

    let token, lastToken, cutSrc, lastParagraphClipped;

    while (src) {
      if (this.options.extensions
        && this.options.extensions.block
        && this.options.extensions.block.some((extTokenizer) => {
          if (token = extTokenizer.call({ lexer: this }, src, tokens)) {
            src = src.substring(token.raw.length);
            tokens.push(token);
            return true;
          }
          return false;
        })) {
        continue;
      }

      // newline
      if (token = this.tokenizer.space(src)) {
        src = src.substring(token.raw.length);
        if (token.raw.length === 1 && tokens.length > 0) {
          // if there's a single \n as a spacer, it's terminating the last line,
          // so move it there so that we don't get unecessary paragraph tags
          tokens[tokens.length - 1].raw += '\n';
        } else {
          tokens.push(token);
        }
        continue;
      }

      // code
      if (token = this.tokenizer.code(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        // An indented code block cannot interrupt a paragraph.
        if (lastToken && (lastToken.type === 'paragraph' || lastToken.type === 'text')) {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.text;
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else {
          tokens.push(token);
        }
        continue;
      }

      // fences
      if (token = this.tokenizer.fences(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // heading
      if (token = this.tokenizer.heading(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // hr
      if (token = this.tokenizer.hr(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // blockquote
      if (token = this.tokenizer.blockquote(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // list
      if (token = this.tokenizer.list(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // html
      if (token = this.tokenizer.html(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // def
      if (token = this.tokenizer.def(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && (lastToken.type === 'paragraph' || lastToken.type === 'text')) {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.raw;
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else if (!this.tokens.links[token.tag]) {
          this.tokens.links[token.tag] = {
            href: token.href,
            title: token.title
          };
        }
        continue;
      }

      // table (gfm)
      if (token = this.tokenizer.table(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // lheading
      if (token = this.tokenizer.lheading(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // top-level paragraph
      // prevent paragraph consuming extensions by clipping 'src' to extension start
      cutSrc = src;
      if (this.options.extensions && this.options.extensions.startBlock) {
        let startIndex = Infinity;
        const tempSrc = src.slice(1);
        let tempStart;
        this.options.extensions.startBlock.forEach(function(getStartIndex) {
          tempStart = getStartIndex.call({ lexer: this }, tempSrc);
          if (typeof tempStart === 'number' && tempStart >= 0) { startIndex = Math.min(startIndex, tempStart); }
        });
        if (startIndex < Infinity && startIndex >= 0) {
          cutSrc = src.substring(0, startIndex + 1);
        }
      }
      if (this.state.top && (token = this.tokenizer.paragraph(cutSrc))) {
        lastToken = tokens[tokens.length - 1];
        if (lastParagraphClipped && lastToken.type === 'paragraph') {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.text;
          this.inlineQueue.pop();
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else {
          tokens.push(token);
        }
        lastParagraphClipped = (cutSrc.length !== src.length);
        src = src.substring(token.raw.length);
        continue;
      }

      // text
      if (token = this.tokenizer.text(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && lastToken.type === 'text') {
          lastToken.raw += '\n' + token.raw;
          lastToken.text += '\n' + token.text;
          this.inlineQueue.pop();
          this.inlineQueue[this.inlineQueue.length - 1].src = lastToken.text;
        } else {
          tokens.push(token);
        }
        continue;
      }

      if (src) {
        const errMsg = 'Infinite loop on byte: ' + src.charCodeAt(0);
        if (this.options.silent) {
          console.error(errMsg);
          break;
        } else {
          throw new Error(errMsg);
        }
      }
    }

    this.state.top = true;
    return tokens;
  }

  inline(src, tokens = []) {
    this.inlineQueue.push({ src, tokens });
    return tokens;
  }

  /**
   * Lexing/Compiling
   */
  inlineTokens(src, tokens = []) {
    let token, lastToken, cutSrc;

    // String with links masked to avoid interference with em and strong
    let maskedSrc = src;
    let match;
    let keepPrevChar, prevChar;

    // Mask out reflinks
    if (this.tokens.links) {
      const links = Object.keys(this.tokens.links);
      if (links.length > 0) {
        while ((match = this.tokenizer.rules.inline.reflinkSearch.exec(maskedSrc)) != null) {
          if (links.includes(match[0].slice(match[0].lastIndexOf('[') + 1, -1))) {
            maskedSrc = maskedSrc.slice(0, match.index) + '[' + repeatString('a', match[0].length - 2) + ']' + maskedSrc.slice(this.tokenizer.rules.inline.reflinkSearch.lastIndex);
          }
        }
      }
    }
    // Mask out other blocks
    while ((match = this.tokenizer.rules.inline.blockSkip.exec(maskedSrc)) != null) {
      maskedSrc = maskedSrc.slice(0, match.index) + '[' + repeatString('a', match[0].length - 2) + ']' + maskedSrc.slice(this.tokenizer.rules.inline.blockSkip.lastIndex);
    }

    // Mask out escaped em & strong delimiters
    while ((match = this.tokenizer.rules.inline.escapedEmSt.exec(maskedSrc)) != null) {
      maskedSrc = maskedSrc.slice(0, match.index + match[0].length - 2) + '++' + maskedSrc.slice(this.tokenizer.rules.inline.escapedEmSt.lastIndex);
      this.tokenizer.rules.inline.escapedEmSt.lastIndex--;
    }

    while (src) {
      if (!keepPrevChar) {
        prevChar = '';
      }
      keepPrevChar = false;

      // extensions
      if (this.options.extensions
        && this.options.extensions.inline
        && this.options.extensions.inline.some((extTokenizer) => {
          if (token = extTokenizer.call({ lexer: this }, src, tokens)) {
            src = src.substring(token.raw.length);
            tokens.push(token);
            return true;
          }
          return false;
        })) {
        continue;
      }

      // escape
      if (token = this.tokenizer.escape(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // tag
      if (token = this.tokenizer.tag(src)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && token.type === 'text' && lastToken.type === 'text') {
          lastToken.raw += token.raw;
          lastToken.text += token.text;
        } else {
          tokens.push(token);
        }
        continue;
      }

      // link
      if (token = this.tokenizer.link(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // reflink, nolink
      if (token = this.tokenizer.reflink(src, this.tokens.links)) {
        src = src.substring(token.raw.length);
        lastToken = tokens[tokens.length - 1];
        if (lastToken && token.type === 'text' && lastToken.type === 'text') {
          lastToken.raw += token.raw;
          lastToken.text += token.text;
        } else {
          tokens.push(token);
        }
        continue;
      }

      // em & strong
      if (token = this.tokenizer.emStrong(src, maskedSrc, prevChar)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // code
      if (token = this.tokenizer.codespan(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // br
      if (token = this.tokenizer.br(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // del (gfm)
      if (token = this.tokenizer.del(src)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // autolink
      if (token = this.tokenizer.autolink(src, mangle)) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // url (gfm)
      if (!this.state.inLink && (token = this.tokenizer.url(src, mangle))) {
        src = src.substring(token.raw.length);
        tokens.push(token);
        continue;
      }

      // text
      // prevent inlineText consuming extensions by clipping 'src' to extension start
      cutSrc = src;
      if (this.options.extensions && this.options.extensions.startInline) {
        let startIndex = Infinity;
        const tempSrc = src.slice(1);
        let tempStart;
        this.options.extensions.startInline.forEach(function(getStartIndex) {
          tempStart = getStartIndex.call({ lexer: this }, tempSrc);
          if (typeof tempStart === 'number' && tempStart >= 0) { startIndex = Math.min(startIndex, tempStart); }
        });
        if (startIndex < Infinity && startIndex >= 0) {
          cutSrc = src.substring(0, startIndex + 1);
        }
      }
      if (token = this.tokenizer.inlineText(cutSrc, smartypants)) {
        src = src.substring(token.raw.length);
        if (token.raw.slice(-1) !== '_') { // Track prevChar before string of ____ started
          prevChar = token.raw.slice(-1);
        }
        keepPrevChar = true;
        lastToken = tokens[tokens.length - 1];
        if (lastToken && lastToken.type === 'text') {
          lastToken.raw += token.raw;
          lastToken.text += token.text;
        } else {
          tokens.push(token);
        }
        continue;
      }

      if (src) {
        const errMsg = 'Infinite loop on byte: ' + src.charCodeAt(0);
        if (this.options.silent) {
          console.error(errMsg);
          break;
        } else {
          throw new Error(errMsg);
        }
      }
    }

    return tokens;
  }
}

/**
 * Renderer
 */
class Renderer {
  constructor(options) {
    this.options = options || defaults;
  }

  code(code, infostring, escaped) {
    const lang = (infostring || '').match(/\S*/)[0];
    if (this.options.highlight) {
      const out = this.options.highlight(code, lang);
      if (out != null && out !== code) {
        escaped = true;
        code = out;
      }
    }

    code = code.replace(/\n$/, '') + '\n';

    if (!lang) {
      return '<pre><code>'
        + (escaped ? code : marked_esm_escape(code, true))
        + '</code></pre>\n';
    }

    return '<pre><code class="'
      + this.options.langPrefix
      + marked_esm_escape(lang)
      + '">'
      + (escaped ? code : marked_esm_escape(code, true))
      + '</code></pre>\n';
  }

  /**
   * @param {string} quote
   */
  blockquote(quote) {
    return `<blockquote>\n${quote}</blockquote>\n`;
  }

  html(html) {
    return html;
  }

  /**
   * @param {string} text
   * @param {string} level
   * @param {string} raw
   * @param {any} slugger
   */
  heading(text, level, raw, slugger) {
    if (this.options.headerIds) {
      const id = this.options.headerPrefix + slugger.slug(raw);
      return `<h${level} id="${id}">${text}</h${level}>\n`;
    }

    // ignore IDs
    return `<h${level}>${text}</h${level}>\n`;
  }

  hr() {
    return this.options.xhtml ? '<hr/>\n' : '<hr>\n';
  }

  list(body, ordered, start) {
    const type = ordered ? 'ol' : 'ul',
      startatt = (ordered && start !== 1) ? (' start="' + start + '"') : '';
    return '<' + type + startatt + '>\n' + body + '</' + type + '>\n';
  }

  /**
   * @param {string} text
   */
  listitem(text) {
    return `<li>${text}</li>\n`;
  }

  checkbox(checked) {
    return '<input '
      + (checked ? 'checked="" ' : '')
      + 'disabled="" type="checkbox"'
      + (this.options.xhtml ? ' /' : '')
      + '> ';
  }

  /**
   * @param {string} text
   */
  paragraph(text) {
    return `<p>${text}</p>\n`;
  }

  /**
   * @param {string} header
   * @param {string} body
   */
  table(header, body) {
    if (body) body = `<tbody>${body}</tbody>`;

    return '<table>\n'
      + '<thead>\n'
      + header
      + '</thead>\n'
      + body
      + '</table>\n';
  }

  /**
   * @param {string} content
   */
  tablerow(content) {
    return `<tr>\n${content}</tr>\n`;
  }

  tablecell(content, flags) {
    const type = flags.header ? 'th' : 'td';
    const tag = flags.align
      ? `<${type} align="${flags.align}">`
      : `<${type}>`;
    return tag + content + `</${type}>\n`;
  }

  /**
   * span level renderer
   * @param {string} text
   */
  strong(text) {
    return `<strong>${text}</strong>`;
  }

  /**
   * @param {string} text
   */
  em(text) {
    return `<em>${text}</em>`;
  }

  /**
   * @param {string} text
   */
  codespan(text) {
    return `<code>${text}</code>`;
  }

  br() {
    return this.options.xhtml ? '<br/>' : '<br>';
  }

  /**
   * @param {string} text
   */
  del(text) {
    return `<del>${text}</del>`;
  }

  /**
   * @param {string} href
   * @param {string} title
   * @param {string} text
   */
  link(href, title, text) {
    href = cleanUrl(this.options.sanitize, this.options.baseUrl, href);
    if (href === null) {
      return text;
    }
    let out = '<a href="' + href + '"';
    if (title) {
      out += ' title="' + title + '"';
    }
    out += '>' + text + '</a>';
    return out;
  }

  /**
   * @param {string} href
   * @param {string} title
   * @param {string} text
   */
  image(href, title, text) {
    href = cleanUrl(this.options.sanitize, this.options.baseUrl, href);
    if (href === null) {
      return text;
    }

    let out = `<img src="${href}" alt="${text}"`;
    if (title) {
      out += ` title="${title}"`;
    }
    out += this.options.xhtml ? '/>' : '>';
    return out;
  }

  text(text) {
    return text;
  }
}

/**
 * TextRenderer
 * returns only the textual part of the token
 */
class TextRenderer {
  // no need for block level renderers
  strong(text) {
    return text;
  }

  em(text) {
    return text;
  }

  codespan(text) {
    return text;
  }

  del(text) {
    return text;
  }

  html(text) {
    return text;
  }

  text(text) {
    return text;
  }

  link(href, title, text) {
    return '' + text;
  }

  image(href, title, text) {
    return '' + text;
  }

  br() {
    return '';
  }
}

/**
 * Slugger generates header id
 */
class Slugger {
  constructor() {
    this.seen = {};
  }

  /**
   * @param {string} value
   */
  serialize(value) {
    return value
      .toLowerCase()
      .trim()
      // remove html tags
      .replace(/<[!\/a-z].*?>/ig, '')
      // remove unwanted chars
      .replace(/[\u2000-\u206F\u2E00-\u2E7F\\'!"#$%&()*+,./:;<=>?@[\]^`{|}~]/g, '')
      .replace(/\s/g, '-');
  }

  /**
   * Finds the next safe (unique) slug to use
   * @param {string} originalSlug
   * @param {boolean} isDryRun
   */
  getNextSafeSlug(originalSlug, isDryRun) {
    let slug = originalSlug;
    let occurenceAccumulator = 0;
    if (this.seen.hasOwnProperty(slug)) {
      occurenceAccumulator = this.seen[originalSlug];
      do {
        occurenceAccumulator++;
        slug = originalSlug + '-' + occurenceAccumulator;
      } while (this.seen.hasOwnProperty(slug));
    }
    if (!isDryRun) {
      this.seen[originalSlug] = occurenceAccumulator;
      this.seen[slug] = 0;
    }
    return slug;
  }

  /**
   * Convert string to unique id
   * @param {object} [options]
   * @param {boolean} [options.dryrun] Generates the next unique slug without
   * updating the internal accumulator.
   */
  slug(value, options = {}) {
    const slug = this.serialize(value);
    return this.getNextSafeSlug(slug, options.dryrun);
  }
}

/**
 * Parsing & Compiling
 */
class Parser {
  constructor(options) {
    this.options = options || defaults;
    this.options.renderer = this.options.renderer || new Renderer();
    this.renderer = this.options.renderer;
    this.renderer.options = this.options;
    this.textRenderer = new TextRenderer();
    this.slugger = new Slugger();
  }

  /**
   * Static Parse Method
   */
  static parse(tokens, options) {
    const parser = new Parser(options);
    return parser.parse(tokens);
  }

  /**
   * Static Parse Inline Method
   */
  static parseInline(tokens, options) {
    const parser = new Parser(options);
    return parser.parseInline(tokens);
  }

  /**
   * Parse Loop
   */
  parse(tokens, top = true) {
    let out = '',
      i,
      j,
      k,
      l2,
      l3,
      row,
      cell,
      header,
      body,
      token,
      ordered,
      start,
      loose,
      itemBody,
      item,
      checked,
      task,
      checkbox,
      ret;

    const l = tokens.length;
    for (i = 0; i < l; i++) {
      token = tokens[i];

      // Run any renderer extensions
      if (this.options.extensions && this.options.extensions.renderers && this.options.extensions.renderers[token.type]) {
        ret = this.options.extensions.renderers[token.type].call({ parser: this }, token);
        if (ret !== false || !['space', 'hr', 'heading', 'code', 'table', 'blockquote', 'list', 'html', 'paragraph', 'text'].includes(token.type)) {
          out += ret || '';
          continue;
        }
      }

      switch (token.type) {
        case 'space': {
          continue;
        }
        case 'hr': {
          out += this.renderer.hr();
          continue;
        }
        case 'heading': {
          out += this.renderer.heading(
            this.parseInline(token.tokens),
            token.depth,
            marked_esm_unescape(this.parseInline(token.tokens, this.textRenderer)),
            this.slugger);
          continue;
        }
        case 'code': {
          out += this.renderer.code(token.text,
            token.lang,
            token.escaped);
          continue;
        }
        case 'table': {
          header = '';

          // header
          cell = '';
          l2 = token.header.length;
          for (j = 0; j < l2; j++) {
            cell += this.renderer.tablecell(
              this.parseInline(token.header[j].tokens),
              { header: true, align: token.align[j] }
            );
          }
          header += this.renderer.tablerow(cell);

          body = '';
          l2 = token.rows.length;
          for (j = 0; j < l2; j++) {
            row = token.rows[j];

            cell = '';
            l3 = row.length;
            for (k = 0; k < l3; k++) {
              cell += this.renderer.tablecell(
                this.parseInline(row[k].tokens),
                { header: false, align: token.align[k] }
              );
            }

            body += this.renderer.tablerow(cell);
          }
          out += this.renderer.table(header, body);
          continue;
        }
        case 'blockquote': {
          body = this.parse(token.tokens);
          out += this.renderer.blockquote(body);
          continue;
        }
        case 'list': {
          ordered = token.ordered;
          start = token.start;
          loose = token.loose;
          l2 = token.items.length;

          body = '';
          for (j = 0; j < l2; j++) {
            item = token.items[j];
            checked = item.checked;
            task = item.task;

            itemBody = '';
            if (item.task) {
              checkbox = this.renderer.checkbox(checked);
              if (loose) {
                if (item.tokens.length > 0 && item.tokens[0].type === 'paragraph') {
                  item.tokens[0].text = checkbox + ' ' + item.tokens[0].text;
                  if (item.tokens[0].tokens && item.tokens[0].tokens.length > 0 && item.tokens[0].tokens[0].type === 'text') {
                    item.tokens[0].tokens[0].text = checkbox + ' ' + item.tokens[0].tokens[0].text;
                  }
                } else {
                  item.tokens.unshift({
                    type: 'text',
                    text: checkbox
                  });
                }
              } else {
                itemBody += checkbox;
              }
            }

            itemBody += this.parse(item.tokens, loose);
            body += this.renderer.listitem(itemBody, task, checked);
          }

          out += this.renderer.list(body, ordered, start);
          continue;
        }
        case 'html': {
          // TODO parse inline content if parameter markdown=1
          out += this.renderer.html(token.text);
          continue;
        }
        case 'paragraph': {
          out += this.renderer.paragraph(this.parseInline(token.tokens));
          continue;
        }
        case 'text': {
          body = token.tokens ? this.parseInline(token.tokens) : token.text;
          while (i + 1 < l && tokens[i + 1].type === 'text') {
            token = tokens[++i];
            body += '\n' + (token.tokens ? this.parseInline(token.tokens) : token.text);
          }
          out += top ? this.renderer.paragraph(body) : body;
          continue;
        }

        default: {
          const errMsg = 'Token with "' + token.type + '" type was not found.';
          if (this.options.silent) {
            console.error(errMsg);
            return;
          } else {
            throw new Error(errMsg);
          }
        }
      }
    }

    return out;
  }

  /**
   * Parse Inline Tokens
   */
  parseInline(tokens, renderer) {
    renderer = renderer || this.renderer;
    let out = '',
      i,
      token,
      ret;

    const l = tokens.length;
    for (i = 0; i < l; i++) {
      token = tokens[i];

      // Run any renderer extensions
      if (this.options.extensions && this.options.extensions.renderers && this.options.extensions.renderers[token.type]) {
        ret = this.options.extensions.renderers[token.type].call({ parser: this }, token);
        if (ret !== false || !['escape', 'html', 'link', 'image', 'strong', 'em', 'codespan', 'br', 'del', 'text'].includes(token.type)) {
          out += ret || '';
          continue;
        }
      }

      switch (token.type) {
        case 'escape': {
          out += renderer.text(token.text);
          break;
        }
        case 'html': {
          out += renderer.html(token.text);
          break;
        }
        case 'link': {
          out += renderer.link(token.href, token.title, this.parseInline(token.tokens, renderer));
          break;
        }
        case 'image': {
          out += renderer.image(token.href, token.title, token.text);
          break;
        }
        case 'strong': {
          out += renderer.strong(this.parseInline(token.tokens, renderer));
          break;
        }
        case 'em': {
          out += renderer.em(this.parseInline(token.tokens, renderer));
          break;
        }
        case 'codespan': {
          out += renderer.codespan(token.text);
          break;
        }
        case 'br': {
          out += renderer.br();
          break;
        }
        case 'del': {
          out += renderer.del(this.parseInline(token.tokens, renderer));
          break;
        }
        case 'text': {
          out += renderer.text(token.text);
          break;
        }
        default: {
          const errMsg = 'Token with "' + token.type + '" type was not found.';
          if (this.options.silent) {
            console.error(errMsg);
            return;
          } else {
            throw new Error(errMsg);
          }
        }
      }
    }
    return out;
  }
}

class Hooks {
  constructor(options) {
    this.options = options || defaults;
  }

  static passThroughHooks = new Set([
    'preprocess',
    'postprocess'
  ]);

  /**
   * Process markdown before marked
   */
  preprocess(markdown) {
    return markdown;
  }

  /**
   * Process HTML after marked is finished
   */
  postprocess(html) {
    return html;
  }
}

function onError(silent, async, callback) {
  return (e) => {
    e.message += '\nPlease report this to https://github.com/markedjs/marked.';

    if (silent) {
      const msg = '<p>An error occurred:</p><pre>'
        + marked_esm_escape(e.message + '', true)
        + '</pre>';
      if (async) {
        return Promise.resolve(msg);
      }
      if (callback) {
        callback(null, msg);
        return;
      }
      return msg;
    }

    if (async) {
      return Promise.reject(e);
    }
    if (callback) {
      callback(e);
      return;
    }
    throw e;
  };
}

function parseMarkdown(lexer, parser) {
  return (src, opt, callback) => {
    if (typeof opt === 'function') {
      callback = opt;
      opt = null;
    }

    const origOpt = { ...opt };
    opt = { ...marked.defaults, ...origOpt };
    const throwError = onError(opt.silent, opt.async, callback);

    // throw error in case of non string input
    if (typeof src === 'undefined' || src === null) {
      return throwError(new Error('marked(): input parameter is undefined or null'));
    }
    if (typeof src !== 'string') {
      return throwError(new Error('marked(): input parameter is of type '
        + Object.prototype.toString.call(src) + ', string expected'));
    }

    checkSanitizeDeprecation(opt);

    if (opt.hooks) {
      opt.hooks.options = opt;
    }

    if (callback) {
      const highlight = opt.highlight;
      let tokens;

      try {
        if (opt.hooks) {
          src = opt.hooks.preprocess(src);
        }
        tokens = lexer(src, opt);
      } catch (e) {
        return throwError(e);
      }

      const done = function(err) {
        let out;

        if (!err) {
          try {
            if (opt.walkTokens) {
              marked.walkTokens(tokens, opt.walkTokens);
            }
            out = parser(tokens, opt);
            if (opt.hooks) {
              out = opt.hooks.postprocess(out);
            }
          } catch (e) {
            err = e;
          }
        }

        opt.highlight = highlight;

        return err
          ? throwError(err)
          : callback(null, out);
      };

      if (!highlight || highlight.length < 3) {
        return done();
      }

      delete opt.highlight;

      if (!tokens.length) return done();

      let pending = 0;
      marked.walkTokens(tokens, function(token) {
        if (token.type === 'code') {
          pending++;
          setTimeout(() => {
            highlight(token.text, token.lang, function(err, code) {
              if (err) {
                return done(err);
              }
              if (code != null && code !== token.text) {
                token.text = code;
                token.escaped = true;
              }

              pending--;
              if (pending === 0) {
                done();
              }
            });
          }, 0);
        }
      });

      if (pending === 0) {
        done();
      }

      return;
    }

    if (opt.async) {
      return Promise.resolve(opt.hooks ? opt.hooks.preprocess(src) : src)
        .then(src => lexer(src, opt))
        .then(tokens => opt.walkTokens ? Promise.all(marked.walkTokens(tokens, opt.walkTokens)).then(() => tokens) : tokens)
        .then(tokens => parser(tokens, opt))
        .then(html => opt.hooks ? opt.hooks.postprocess(html) : html)
        .catch(throwError);
    }

    try {
      if (opt.hooks) {
        src = opt.hooks.preprocess(src);
      }
      const tokens = lexer(src, opt);
      if (opt.walkTokens) {
        marked.walkTokens(tokens, opt.walkTokens);
      }
      let html = parser(tokens, opt);
      if (opt.hooks) {
        html = opt.hooks.postprocess(html);
      }
      return html;
    } catch (e) {
      return throwError(e);
    }
  };
}

/**
 * Marked
 */
function marked(src, opt, callback) {
  return parseMarkdown(Lexer.lex, Parser.parse)(src, opt, callback);
}

/**
 * Options
 */

marked.options =
marked.setOptions = function(opt) {
  marked.defaults = { ...marked.defaults, ...opt };
  changeDefaults(marked.defaults);
  return marked;
};

marked.getDefaults = getDefaults;

marked.defaults = defaults;

/**
 * Use Extension
 */

marked.use = function(...args) {
  const extensions = marked.defaults.extensions || { renderers: {}, childTokens: {} };

  args.forEach((pack) => {
    // copy options to new object
    const opts = { ...pack };

    // set async to true if it was set to true before
    opts.async = marked.defaults.async || opts.async || false;

    // ==-- Parse "addon" extensions --== //
    if (pack.extensions) {
      pack.extensions.forEach((ext) => {
        if (!ext.name) {
          throw new Error('extension name required');
        }
        if (ext.renderer) { // Renderer extensions
          const prevRenderer = extensions.renderers[ext.name];
          if (prevRenderer) {
            // Replace extension with func to run new extension but fall back if false
            extensions.renderers[ext.name] = function(...args) {
              let ret = ext.renderer.apply(this, args);
              if (ret === false) {
                ret = prevRenderer.apply(this, args);
              }
              return ret;
            };
          } else {
            extensions.renderers[ext.name] = ext.renderer;
          }
        }
        if (ext.tokenizer) { // Tokenizer Extensions
          if (!ext.level || (ext.level !== 'block' && ext.level !== 'inline')) {
            throw new Error("extension level must be 'block' or 'inline'");
          }
          if (extensions[ext.level]) {
            extensions[ext.level].unshift(ext.tokenizer);
          } else {
            extensions[ext.level] = [ext.tokenizer];
          }
          if (ext.start) { // Function to check for start of token
            if (ext.level === 'block') {
              if (extensions.startBlock) {
                extensions.startBlock.push(ext.start);
              } else {
                extensions.startBlock = [ext.start];
              }
            } else if (ext.level === 'inline') {
              if (extensions.startInline) {
                extensions.startInline.push(ext.start);
              } else {
                extensions.startInline = [ext.start];
              }
            }
          }
        }
        if (ext.childTokens) { // Child tokens to be visited by walkTokens
          extensions.childTokens[ext.name] = ext.childTokens;
        }
      });
      opts.extensions = extensions;
    }

    // ==-- Parse "overwrite" extensions --== //
    if (pack.renderer) {
      const renderer = marked.defaults.renderer || new Renderer();
      for (const prop in pack.renderer) {
        const prevRenderer = renderer[prop];
        // Replace renderer with func to run extension, but fall back if false
        renderer[prop] = (...args) => {
          let ret = pack.renderer[prop].apply(renderer, args);
          if (ret === false) {
            ret = prevRenderer.apply(renderer, args);
          }
          return ret;
        };
      }
      opts.renderer = renderer;
    }
    if (pack.tokenizer) {
      const tokenizer = marked.defaults.tokenizer || new Tokenizer();
      for (const prop in pack.tokenizer) {
        const prevTokenizer = tokenizer[prop];
        // Replace tokenizer with func to run extension, but fall back if false
        tokenizer[prop] = (...args) => {
          let ret = pack.tokenizer[prop].apply(tokenizer, args);
          if (ret === false) {
            ret = prevTokenizer.apply(tokenizer, args);
          }
          return ret;
        };
      }
      opts.tokenizer = tokenizer;
    }

    // ==-- Parse Hooks extensions --== //
    if (pack.hooks) {
      const hooks = marked.defaults.hooks || new Hooks();
      for (const prop in pack.hooks) {
        const prevHook = hooks[prop];
        if (Hooks.passThroughHooks.has(prop)) {
          hooks[prop] = (arg) => {
            if (marked.defaults.async) {
              return Promise.resolve(pack.hooks[prop].call(hooks, arg)).then(ret => {
                return prevHook.call(hooks, ret);
              });
            }

            const ret = pack.hooks[prop].call(hooks, arg);
            return prevHook.call(hooks, ret);
          };
        } else {
          hooks[prop] = (...args) => {
            let ret = pack.hooks[prop].apply(hooks, args);
            if (ret === false) {
              ret = prevHook.apply(hooks, args);
            }
            return ret;
          };
        }
      }
      opts.hooks = hooks;
    }

    // ==-- Parse WalkTokens extensions --== //
    if (pack.walkTokens) {
      const walkTokens = marked.defaults.walkTokens;
      opts.walkTokens = function(token) {
        let values = [];
        values.push(pack.walkTokens.call(this, token));
        if (walkTokens) {
          values = values.concat(walkTokens.call(this, token));
        }
        return values;
      };
    }

    marked.setOptions(opts);
  });
};

/**
 * Run callback for every token
 */

marked.walkTokens = function(tokens, callback) {
  let values = [];
  for (const token of tokens) {
    values = values.concat(callback.call(marked, token));
    switch (token.type) {
      case 'table': {
        for (const cell of token.header) {
          values = values.concat(marked.walkTokens(cell.tokens, callback));
        }
        for (const row of token.rows) {
          for (const cell of row) {
            values = values.concat(marked.walkTokens(cell.tokens, callback));
          }
        }
        break;
      }
      case 'list': {
        values = values.concat(marked.walkTokens(token.items, callback));
        break;
      }
      default: {
        if (marked.defaults.extensions && marked.defaults.extensions.childTokens && marked.defaults.extensions.childTokens[token.type]) { // Walk any extensions
          marked.defaults.extensions.childTokens[token.type].forEach(function(childTokens) {
            values = values.concat(marked.walkTokens(token[childTokens], callback));
          });
        } else if (token.tokens) {
          values = values.concat(marked.walkTokens(token.tokens, callback));
        }
      }
    }
  }
  return values;
};

/**
 * Parse Inline
 * @param {string} src
 */
marked.parseInline = parseMarkdown(Lexer.lexInline, Parser.parseInline);

/**
 * Expose
 */
marked.Parser = Parser;
marked.parser = Parser.parse;
marked.Renderer = Renderer;
marked.TextRenderer = TextRenderer;
marked.Lexer = Lexer;
marked.lexer = Lexer.lex;
marked.Tokenizer = Tokenizer;
marked.Slugger = Slugger;
marked.Hooks = Hooks;
marked.parse = marked;

const options = marked.options;
const setOptions = marked.setOptions;
const use = marked.use;
const walkTokens = marked.walkTokens;
const parseInline = marked.parseInline;
const parse = (/* unused pure expression or super */ null && (marked));
const parser = Parser.parse;
const lexer = Lexer.lex;



// EXTERNAL MODULE: ./node_modules/prismjs/prism.js
var prism = __webpack_require__(848);
var prism_default = /*#__PURE__*/__webpack_require__.n(prism);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-css.js
var prism_css = __webpack_require__(113);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-yaml.js
var prism_yaml = __webpack_require__(83);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-go.js
var prism_go = __webpack_require__(378);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-java.js
var prism_java = __webpack_require__(976);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-json.js
var prism_json = __webpack_require__(514);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-bash.js
var prism_bash = __webpack_require__(22);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-python.js
var prism_python = __webpack_require__(342);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-http.js
var prism_http = __webpack_require__(784);
// EXTERNAL MODULE: ./node_modules/prismjs/components/prism-csharp.js
var prism_csharp = __webpack_require__(651);
;// ./src/styles/font-styles.js

/* harmony default export */ const font_styles = (i`
  .hover-bg:hover {
    background: var(--bg3);
  }
  ::selection {
    background: var(--selection-bg);
    color: var(--selection-fg);
  }
  .regular-font { 
    font-family:var(--font-regular); 
  }
  .mono-font { 
    font-family:var(--font-mono); 
  }
  .title { 
    font-size: calc(var(--font-size-small) + 18px);
    font-weight: normal 
  }
  .sub-title{ font-size: 20px; }
  .req-res-title {
    font-family: var(--font-regular);
    font-size: calc(var(--font-size-small) + 4px);
    font-weight:bold;
    margin-bottom:8px;
    text-align:left;
  }
  .tiny-title { 
    font-size:calc(var(--font-size-small) + 1px); 
    font-weight:bold; 
  }
  .regular-font-size { font-size: var(--font-size-regular); }
  .small-font-size { font-size: var(--font-size-small); }
  .upper { text-transform: uppercase; }
  .primary-text { color: var(--primary-color); }
  .bold-text { font-weight:bold; }
  .gray-text { color: var(--light-fg); }
  .red-text { color: var(--red) }
  .blue-text { color: var(--blue) }
  .multiline {
    overflow: scroll;
    max-height: var(--resp-area-height, 400px);
    color: var(--fg3);  
  }
  .method-fg.put { color: var(--orange); }
  .method-fg.post { color: var(--green); }
  .method-fg.get { color: var(--blue); }
  .method-fg.delete { color: var(--red); }
  .method-fg.options, 
  .method-fg.head, 
  .method-fg.patch { 
    color: var(--yellow); 
  }

  h1 { font-family:var(--font-regular); font-size:28px; padding-top: 10px; letter-spacing:normal; font-weight:normal; }
  h2 { font-family:var(--font-regular); font-size:24px; padding-top: 10px; letter-spacing:normal; font-weight:normal; }
  h3 { font-family:var(--font-regular); font-size:18px; padding-top: 10px; letter-spacing:normal; font-weight:normal; }
  h4 { font-family:var(--font-regular); font-size:16px; padding-top: 10px; letter-spacing:normal; font-weight:normal; }
  h5 { font-family:var(--font-regular); font-size:14px; padding-top: 10px; letter-spacing:normal; font-weight:normal; }
  h6 { font-family:var(--font-regular); font-size:14px; padding-top: 10px; letter-spacing:normal; font-weight:normal; }

  h1,h2,h3,h4,h5,h5 {
    margin-block-end: 0.2em;
  }
  p { margin-block-start: 0.5em; }
  a { color: var(--blue); cursor:pointer; }
  a.inactive-link { 
    color:var(--fg);
    text-decoration: none;
    cursor:text;
  }
  
  code,
  pre {
    margin: 0px;
    font-family: var(--font-mono);
    font-size: calc(var(--font-size-mono) - 1px);
  }

  .m-markdown,
  .m-markdown-small {
    display:block;
  }

  .m-markdown p,
  .m-markdown span {
    font-size: var(--font-size-regular);
    line-height:calc(var(--font-size-regular) + 8px);
  }
  .m-markdown li {
    font-size: var(--font-size-regular);
    line-height:calc(var(--font-size-regular) + 10px);
  }
  
  .m-markdown-small p,
  .m-markdown-small span,
  .m-markdown-small li {
    font-size: var(--font-size-small);
    line-height: calc(var(--font-size-small) + 6px);
  }
  .m-markdown-small li {
    line-height: calc(var(--font-size-small) + 8px);
  }

  .m-markdown p:not(:first-child) {
    margin-block-start: 24px;
  }

  .m-markdown-small p:not(:first-child) {
    margin-block-start: 12px;
  }
  .m-markdown-small p:first-child {
    margin-block-start: 0;
  }

  .m-markdown p,
  .m-markdown-small p {
    margin-block-end: 0
  }

  .m-markdown code span {
    font-size:var(--font-size-mono);
  }

  .m-markdown-small code,
  .m-markdown code {
    padding: 1px 6px;
    border-radius: 2px;
    color: var(--inline-code-fg);
    background-color: var(--bg3);
    font-size: calc(var(--font-size-mono));
    line-height: 1.2;
  }

  .m-markdown-small code {
    font-size: calc(var(--font-size-mono) - 1px);
  }

  .m-markdown-small pre,
  .m-markdown pre {
    white-space: pre-wrap;
    overflow-x: auto;
    line-height: normal;
    border-radius: 2px;
    border: 1px solid var(--code-border-color);
  }

  .m-markdown pre {
    padding: 12px;
    background-color: var(--code-bg);
    color:var(--code-fg);
  }

  .m-markdown-small pre {
    margin-top: 4px;
    padding: 2px 4px;
    background-color: var(--bg3);
    color: var(--fg2);
  }

  .m-markdown-small pre code,
  .m-markdown pre code {
    border:none;
    padding:0;
  }

  .m-markdown pre code {
    color: var(--code-fg);
    background-color: var(--code-bg);
    background-color: transparent;
  }

  .m-markdown-small pre code {
    color: var(--fg2);
    background-color: var(--bg3);
  }

  .m-markdown ul,
  .m-markdown ol {
    padding-inline-start: 30px;
  }

  .m-markdown-small ul,
  .m-markdown-small ol {
    padding-inline-start: 20px;
  }

  .m-markdown-small a,
  .m-markdown a {
    color:var(--blue);
  }

  .m-markdown-small img,
  .m-markdown img { 
    max-width: 100%; 
  }

  /* Markdown table */

  .m-markdown-small table,
  .m-markdown table {
    border-spacing: 0;
    margin: 10px 0;
    border-collapse: separate;
    border: 1px solid var(--border-color);
    border-radius: var(--border-radius);
    font-size: calc(var(--font-size-small) + 1px);
    line-height: calc(var(--font-size-small) + 4px);
    max-width: 100%;
  }

  .m-markdown-small table {
    font-size: var(--font-size-small);
    line-height: calc(var(--font-size-small) + 2px);
    margin: 8px 0;
  }

  .m-markdown-small td, 
  .m-markdown-small th,
  .m-markdown td, 
  .m-markdown th {
    vertical-align: top;
    border-top: 1px solid var(--border-color);
    line-height: calc(var(--font-size-small) + 4px);
  }

  .m-markdown-small tr:first-child th,
  .m-markdown tr:first-child th {
    border-top: 0 none;
  }

  .m-markdown th, 
  .m-markdown td { 
    padding: 10px 12px; 
  }

  .m-markdown-small th,
  .m-markdown-small td { 
    padding: 8px 8px; 
  }

  .m-markdown th,
  .m-markdown-small th {
    font-weight: 600;
    background-color: var(--bg2);
    vertical-align: middle;
  }

  .m-markdown-small table code {
    font-size: calc(var(--font-size-mono) - 2px);
  }

  .m-markdown table code {
    font-size: calc(var(--font-size-mono) - 1px);
  }

  .m-markdown blockquote,
  .m-markdown-small blockquote {
    margin-inline-start: 0;
    margin-inline-end: 0;
    border-left: 3px solid var(--border-color);
    padding: 6px 0 6px 6px;
  }
  .m-markdown hr{
    border: 1px solid var(--border-color);
  }
`);
;// ./src/styles/input-styles.js


/* eslint-disable max-len */
/* harmony default export */ const input_styles = (i`
/* Button */
.m-btn {
  border-radius: var(--border-radius);
  font-weight: 600;
  display: inline-block;
  padding: 6px 16px;
  font-size: var(--font-size-small);
  outline: 0;
  line-height: 1;
  text-align: center;
  white-space: nowrap;
  border: 2px solid var(--primary-color);
  background-color:transparent;
  user-select: none;
  cursor: pointer;
  box-shadow: 0 1px 3px rgba(0,0,0,0.12), 0 1px 2px rgba(0,0,0,0.24);
  transition-duration: 0.75s;
}
.m-btn.primary {
  background-color: var(--primary-color);
  color: var(--primary-color-invert);
}
.m-btn.thin-border { border-width: 1px; }
.m-btn.large { padding:8px 14px; }
.m-btn.small { padding:5px 12px; }
.m-btn.tiny { padding:5px 6px; }
.m-btn.circle { border-radius: 50%; }
.m-btn:hover { 
  background-color: var(--primary-color);
  color: var(--primary-color-invert);
}
.m-btn.nav { border: 2px solid var(--nav-accent-color); }
.m-btn.nav:hover { 
  background-color: var(--nav-accent-color);
}
.m-btn:disabled { 
  background-color: var(--bg3);
  color: var(--fg3);
  border-color: var(--fg3);
  cursor: not-allowed;
  opacity: 0.4;
}
.m-btn:active {
  filter: brightness(75%);
  transform: scale(0.95);
  transition:scale 0s;
}
.toolbar-btn {
  cursor: pointer;
  padding: 4px;
  margin:0 2px;
  font-size: var(--font-size-small);
  min-width: 50px;
  color: var(--primary-color-invert);
  border-radius: 2px;
  border: none;
  background-color: var(--primary-color);
}

input, textarea, select, button, pre {
  color:var(--fg);
  outline: none;
  background-color: var(--input-bg);
  border: 1px solid var(--border-color);
  border-radius: var(--border-radius);
}
button {
  font-family: var(--font-regular);
}

/* Form Inputs */
pre,
select,
textarea,
input[type="file"],
input[type="text"],
input[type="password"] {
  font-family: var(--font-mono);
  font-weight: 400;
  font-size: var(--font-size-small);
  transition: border .2s;
  padding: 6px 5px;
}

select {
  font-family: var(--font-regular);
  padding: 5px 30px 5px 5px;
  background-image: url("data:image/svg+xml;charset=utf8,%3Csvg%20xmlns%3D%22http%3A%2F%2Fwww.w3.org%2F2000%2Fsvg%22%20width%3D%2212%22%20height%3D%2212%22%3E%3Cpath%20d%3D%22M10.3%203.3L6%207.6%201.7%203.3A1%201%200%2000.3%204.7l5%205a1%201%200%20001.4%200l5-5a1%201%200%2010-1.4-1.4z%22%20fill%3D%22%23777777%22%2F%3E%3C%2Fsvg%3E"); 
  background-position: calc(100% - 5px) center;
  background-repeat: no-repeat;  
  background-size: 10px;
  -webkit-appearance: none;
  -moz-appearance: none;
  appearance: none;
  cursor: pointer;
}

select:hover {
  border-color: var(--primary-color);
}

textarea::placeholder,
input[type="text"]::placeholder,
input[type="password"]::placeholder {
  color: var(--placeholder-color);
  opacity:1;
}


input[type="file"]{
  font-family: var(--font-regular);
  padding:2px;
  cursor:pointer;
  border: 1px solid var(--primary-color);
  min-height: calc(var(--font-size-small) + 18px);
}

input[type="file"]::-webkit-file-upload-button {
  font-family: var(--font-regular);
  font-size: var(--font-size-small);
  outline: none;
  cursor:pointer;
  padding: 3px 8px;
  border: 1px solid var(--primary-color);
  background-color: var(--primary-color);
  color: var(--primary-color-invert);
  border-radius: var(--border-radius);;
  -webkit-appearance: none;
}

pre,
textarea {
  scrollbar-width: thin;
  scrollbar-color: var(--border-color) var(--input-bg);
}

pre::-webkit-scrollbar,
textarea::-webkit-scrollbar {
  width: 8px;
  height: 8px;
}

pre::-webkit-scrollbar-track,
textarea::-webkit-scrollbar-track {
  background:var(--input-bg);
}
 
pre::-webkit-scrollbar-thumb,
textarea::-webkit-scrollbar-thumb {
  border-radius: 2px;
  background-color: var(--border-color);
}

.link {
  font-size:var(--font-size-small);
  text-decoration: underline;
  color:var(--blue);
  font-family:var(--font-mono);
  margin-bottom:2px;
}

/* Toggle Body */
input[type="checkbox"] {
  appearance: none;
  display: inline-block;
  background-color: var(--light-bg);
  border: 1px solid var(--light-bg);
  border-radius: 9px;
  cursor: pointer;
  height: 18px;
  position: relative;
  transition: border .25s .15s, box-shadow .25s .3s, padding .25s;
  min-width: 36px;
  width: 36px;
  vertical-align: top;
}
/* Toggle Thumb */
input[type="checkbox"]:after {
  position: absolute;
  background-color: var(--bg);
  border: 1px solid var(--light-bg);
  border-radius: 8px;
  content: '';
  top: 0px;
  left: 0px;
  right: 16px;
  display: block;
  height: 16px;
  transition: border .25s .15s, left .25s .1s, right .15s .175s;
}

/* Toggle Body - Checked */
input[type="checkbox"]:checked {
  background-color: var(--green);
  border-color: var(--green);
}
/* Toggle Thumb - Checked*/
input[type="checkbox"]:checked:after {
  border: 1px solid var(--green);
  left: 16px;
  right: 1px;
  transition: border .25s, left .15s .25s, right .25s .175s;
}`);
;// ./src/styles/flex-styles.js

/* harmony default export */ const flex_styles = (i`
.row, .col {
  display:flex;
} 
.row {
  align-items:center;
  flex-direction: row;
}
.col {
  align-items:stretch;
  flex-direction: column;
}
`);
;// ./src/styles/table-styles.js

/* harmony default export */ const table_styles = (i`
.m-table {
  border-spacing: 0;  
  border-collapse: separate;
  border: 1px solid var(--light-border-color);
  border-radius: var(--border-radius);
  margin: 0;
  max-width: 100%;
  direction: ltr;
}
.m-table tr:first-child td,
.m-table tr:first-child th {
    border-top: 0 none;
}
.m-table td, 
.m-table th {
  font-size: var(--font-size-small);
  line-height: calc(var(--font-size-small) + 4px);
  padding: 4px 5px 4px;
  vertical-align: top;
}

.m-table.padded-12 td, 
.m-table.padded-12 th {
  padding: 12px;
}

.m-table td:not([align]), 
.m-table th:not([align]) {
  text-align: left;
}

.m-table th {
  color: var(--fg2);
  font-size: var(--font-size-small);
  line-height: calc(var(--font-size-small) + 18px);
  font-weight: 600;
  letter-spacing: normal;
  background-color: var(--bg2);
  vertical-align: bottom;
  border-bottom: 1px solid var(--light-border-color);
}

.m-table > tbody > tr > td,
.m-table > tr > td {
  border-top: 1px solid var(--light-border-color);
  text-overflow: ellipsis;
  overflow: hidden;
}
.table-title {
  font-size:var(--font-size-small);
  font-weight:bold;
  vertical-align: middle;
  margin: 12px 0 4px 0;
}
`);
;// ./src/styles/endpoint-styles.js

/* harmony default export */ const endpoint_styles = (i`
:host {
  container-type: inline-size;
}
.only-large-screen { display:none; }
.endpoint-head .path {
  display: flex;
  font-family:var(--font-mono);
  font-size: var(--font-size-small);
  align-items: center;
  overflow-wrap: break-word;
  word-break: break-all;
}

.endpoint-head .descr {
  font-size: var(--font-size-small);
  color:var(--light-fg);
  font-weight:400;
  align-items: center;
  overflow-wrap: break-word;
  word-break: break-all;
  display:none;
}

.m-endpoint.expanded { margin-bottom:16px; }
.m-endpoint > .endpoint-head{
  border-width:1px 1px 1px 5px;
  border-style:solid;
  border-color:transparent;
  border-top-color:var(--light-border-color);
  display:flex;
  padding:6px 16px;
  align-items: center;
  cursor: pointer;
}
.m-endpoint > .endpoint-head.put:hover,
.m-endpoint > .endpoint-head.put.expanded {
  border-color:var(--orange); 
  background-color:var(--light-orange); 
}
.m-endpoint > .endpoint-head.post:hover,
.m-endpoint > .endpoint-head.post.expanded {
  border-color:var(--green); 
  background-color:var(--light-green); 
}
.m-endpoint > .endpoint-head.get:hover,
.m-endpoint > .endpoint-head.get.expanded {
  border-color:var(--blue); 
  background-color:var(--light-blue); 
}
.m-endpoint > .endpoint-head.delete:hover,
.m-endpoint > .endpoint-head.delete.expanded {
  border-color:var(--red); 
  background-color:var(--light-red); 
}

.m-endpoint > .endpoint-head.head:hover,
.m-endpoint > .endpoint-head.head.expanded,
.m-endpoint > .endpoint-head.patch:hover,
.m-endpoint > .endpoint-head.patch.expanded,
.m-endpoint > .endpoint-head.options:hover,
.m-endpoint > .endpoint-head.options.expanded {
  border-color:var(--yellow); 
  background-color:var(--light-yellow); 
}

.m-endpoint > .endpoint-head.deprecated:hover,
.m-endpoint > .endpoint-head.deprecated.expanded {
  border-color:var(--border-color); 
  filter:opacity(0.6);
}

.m-endpoint .endpoint-body {
  flex-wrap:wrap;
  padding:16px 0px 0 0px;
  border-width:0px 1px 1px 5px;
  border-style:solid;
  box-shadow: 0px 4px 3px -3px rgba(0, 0, 0, 0.15);
}
.m-endpoint .endpoint-body.delete{ border-color:var(--red); }
.m-endpoint .endpoint-body.put{ border-color:var(--orange); }
.m-endpoint .endpoint-body.post { border-color:var(--green); }
.m-endpoint .endpoint-body.get { border-color:var(--blue); }
.m-endpoint .endpoint-body.head,
.m-endpoint .endpoint-body.patch,
.m-endpoint .endpoint-body.options { 
  border-color:var(--yellow); 
}

.m-endpoint .endpoint-body.deprecated { 
  border-color:var(--border-color);
  filter:opacity(0.6);
}

.endpoint-head .deprecated {
  color: var(--light-fg);
  filter:opacity(0.6);
}

.summary{
  padding:8px 8px;
}
.summary .title {
  font-size:calc(var(--font-size-regular) + 2px);
  margin-bottom: 6px;
  word-break: break-all;
}

.endpoint-head .method {
  padding:2px 5px;
  vertical-align: middle;
  font-size:var(--font-size-small);
  height: calc(var(--font-size-small) + 16px);
  line-height: calc(var(--font-size-small) + 8px);
  width: 60px;
  border-radius: 2px;
  display:inline-block;
  text-align: center;
  font-weight: bold;
  text-transform:uppercase;
  margin-right:5px;
}
.endpoint-head .method.delete{ border: 2px solid var(--red);}
.endpoint-head .method.put{ border: 2px solid var(--orange); }
.endpoint-head .method.post{ border: 2px solid var(--green); }
.endpoint-head .method.get{ border: 2px solid var(--blue); }
.endpoint-head .method.get.deprecated{ border: 2px solid var(--border-color); }
.endpoint-head .method.head,
.endpoint-head .method.patch,
.endpoint-head .method.options { 
  border: 2px solid var(--yellow); 
}

.req-resp-container {
  display: flex;
  margin-top:16px;
  align-items: stretch;
  flex-wrap: wrap;
  flex-direction: column;
  border-top:1px solid var(--light-border-color);
}

.view-mode-request,
api-response.view-mode {
  flex:1; 
  min-height:100px;
  padding:16px 8px;
  overflow:hidden;
}
.view-mode-request {
  border-width:0 0 1px 0;
  border-style:dashed;
}

.head .view-mode-request,
.patch .view-mode-request,
.options .view-mode-request { 
  border-color:var(--yellow); 
}
.put .view-mode-request { 
  border-color:var(--orange); 
}
.post .view-mode-request { 
  border-color:var(--green); 
}
.get .view-mode-request { 
  border-color:var(--blue); 
}
.delete .view-mode-request { 
  border-color:var(--red); 
}

@container (min-width: 1024px) {
  .only-large-screen { display:block; }
  .endpoint-head .path{
    font-size: var(--font-size-regular);
  }
  .endpoint-head .descr{
    display: flex;
  }
  .endpoint-head .m-markdown-small,
  .descr .m-markdown-small{
    display:block;
  }
  .req-resp-container{
    flex-direction: var(--layout, row);
    flex-wrap: nowrap;
  }
  api-response.view-mode {
    padding:16px;
  }
  .view-mode-request.row-layout {
    border-width:0 1px 0 0;
    padding:16px;
  }
  .summary{
    padding:8px 16px;
  }
}
`);
;// ./src/styles/prism-styles.js

/* harmony default export */ const prism_styles = (i`
code[class*="language-"],
pre[class*="language-"] {
  text-align: left;
  white-space: pre;
  word-spacing: normal;
  word-break: normal;
  word-wrap: normal;
  line-height: 1.5;
  tab-size: 2;

  -webkit-hyphens: none;
  -moz-hyphens: none;
  -ms-hyphens: none;
  hyphens: none;
}

/* Code blocks */
pre[class*="language-"] {
  padding: 1em;
  margin: .5em 0;
  overflow: auto;
}

/* Inline code */
:not(pre) > code[class*="language-"] {
  white-space: normal;
}

.token.comment,
.token.block-comment,
.token.prolog,
.token.doctype,
.token.cdata {
  color: var(--light-fg)
}

.token.punctuation {
  color: var(--fg);
}

.token.tag,
.token.attr-name,
.token.namespace,
.token.deleted {
  color:var(--pink);
}

.token.function-name {
  color: var(--blue);
}

.token.boolean,
.token.number,
.token.function {
  color: var(--red);
}

.token.property,
.token.class-name,
.token.constant,
.token.symbol {
  color: var(--code-property-color);
}

.token.selector,
.token.important,
.token.atrule,
.token.keyword,
.token.builtin {
  color: var(--code-keyword-color);
}

.token.string,
.token.char,
.token.attr-value,
.token.regex,
.token.variable { 
  color: var(--green);
}

.token.operator,
.token.entity,
.token.url {
  color: var(--code-operator-color);
}

.token.important,
.token.bold {
  font-weight: bold;
}
.token.italic {
  font-style: italic;
}

.token.entity {
  cursor: help;
}

.token.inserted {
  color: green;
}
`);
;// ./src/styles/tab-styles.js

/* harmony default export */ const tab_styles = (i`
.tab-panel {
  border: none;
}
.tab-buttons {
  height:30px;
  padding: 4px 4px 0 4px;
  border-bottom: 1px solid var(--light-border-color) ;
  align-items: stretch;
  overflow-y: hidden;
  overflow-x: auto;
  scrollbar-width: thin;
}
.tab-buttons::-webkit-scrollbar {
  height: 1px;
  background-color: var(--border-color);
}
.tab-btn {
  border: none;
  border-bottom: 3px solid transparent; 
  color: var(--light-fg);
  background-color: transparent;
  white-space: nowrap;
  cursor:pointer;
  outline:none;
  font-family:var(--font-regular); 
  font-size:var(--font-size-small);
  margin-right:16px;
  padding:1px;
}
.tab-btn.active {
  border-bottom: 3px solid var(--primary-color); 
  font-weight:bold;
  color:var(--primary-color);
}

.tab-btn:hover {
  color:var(--primary-color);
}
.tab-content {
  margin:-1px 0 0 0;
  position:relative;
  min-height: 50px;
}
`);
;// ./src/styles/nav-styles.js

/* harmony default export */ const nav_styles = (i`
.nav-bar-info:focus-visible,
.nav-bar-tag:focus-visible,
.nav-bar-path:focus-visible {
  outline: 1px solid;
  box-shadow: none;
  outline-offset: -4px;
}
.nav-bar-expand-all:focus-visible,
.nav-bar-collapse-all:focus-visible,
.nav-bar-tag-icon:focus-visible {
  outline: 1px solid;
  box-shadow: none;
  outline-offset: 2px;
}
.nav-bar {
  width:0;
  height:100%;
  overflow: hidden;
  color:var(--nav-text-color);
  background-color: var(--nav-bg-color);
  background-blend-mode: multiply;
  line-height: calc(var(--font-size-small) + 4px);
  display:none;
  position:relative;
  flex-direction:column;
  flex-wrap:nowrap;
  word-break:break-word;
}
::slotted([slot=nav-logo]) {
  padding:16px 16px 0 16px;
}
.nav-scroll {
  overflow-x: hidden;
  overflow-y: auto;
  overflow-y: overlay;
  scrollbar-width: thin;
  scrollbar-color: var(--nav-hover-bg-color) transparent;
}

.nav-bar-tag {
  display: flex;
  align-items: center;
  justify-content: space-between;
  flex-direction: row;
}
.nav-bar.read .nav-bar-tag-icon {
  display:none;
}
.nav-bar-paths-under-tag {
  overflow:hidden;
  transition: max-height .2s ease-out, visibility .3s;
}
.collapsed .nav-bar-paths-under-tag {
  visibility: hidden;
}

.nav-bar-expand-all {
  transform: rotate(90deg); 
  cursor:pointer; 
  margin-right:10px;
}
.nav-bar-collapse-all {
  transform: rotate(270deg); 
  cursor:pointer;
}
.nav-bar-expand-all:hover, .nav-bar-collapse-all:hover {
  color: var(--primary-color);
}

.nav-bar-tag-icon {
  color: var(--nav-text-color);
  font-size: 20px; 
}
.nav-bar-tag-icon:hover {
  color:var(--nav-hover-text-color);
}
.nav-bar.focused .nav-bar-tag-and-paths.collapsed .nav-bar-tag-icon::after {
  content: '⌵';
  width:16px;
  height:16px;
  text-align: center;
  display: inline-block;
  transform: rotate(-90deg);
  transition: transform 0.2s ease-out 0s;
}
.nav-bar.focused .nav-bar-tag-and-paths.expanded .nav-bar-tag-icon::after {
  content: '⌵';
  width:16px;
  height:16px;
  text-align: center;
  display: inline-block;
  transition: transform 0.2s ease-out 0s;
}
.nav-scroll::-webkit-scrollbar {
  width: var(--scroll-bar-width, 8px);
}
.nav-scroll::-webkit-scrollbar-track {
  background:transparent;
}
.nav-scroll::-webkit-scrollbar-thumb {
  background-color: var(--nav-hover-bg-color);
}

.nav-bar-tag {
  font-size: var(--font-size-regular);
  color: var(--nav-accent-color);
  border-left:4px solid transparent;
  font-weight:bold;
  padding: 15px 15px 15px 10px;
  text-transform: capitalize;
}

.nav-bar-components,
.nav-bar-h1,
.nav-bar-h2,
.nav-bar-info,
.nav-bar-tag,
.nav-bar-path {
  display:flex;
  cursor: pointer;
  width: 100%;
  border: none;
  border-radius:4px; 
  color: var(--nav-text-color);
  background: transparent;
  border-left:4px solid transparent;
}

.nav-bar-h1,
.nav-bar-h2,
.nav-bar-path {
  font-size: calc(var(--font-size-small) + 1px);
  padding: var(--nav-item-padding);
}
.nav-bar-path.small-font {
  font-size: var(--font-size-small);
}

.nav-bar-info {
  font-size: var(--font-size-regular);
  padding: 16px 10px;
  font-weight:bold;
}
.nav-bar-section {
  display: flex;
  flex-direction: row;
  justify-content: space-between;
  font-size: var(--font-size-small);
  color: var(--nav-text-color);
  padding: var(--nav-item-padding);
  font-weight:bold;
}
.nav-bar-section.operations {
  cursor:pointer;
}
.nav-bar-section.operations:hover {
  color:var(--nav-hover-text-color);
  background-color:var(--nav-hover-bg-color);
}

.nav-bar-section:first-child {
  display: none;
}
.nav-bar-h2 {margin-left:12px;}

.nav-bar-h1.left-bar.active,
.nav-bar-h2.left-bar.active,
.nav-bar-info.left-bar.active,
.nav-bar-tag.left-bar.active,
.nav-bar-path.left-bar.active,
.nav-bar-section.left-bar.operations.active {
  border-left:4px solid var(--nav-accent-color);
  color:var(--nav-hover-text-color);
}

.nav-bar-h1.colored-block.active,
.nav-bar-h2.colored-block.active,
.nav-bar-info.colored-block.active,
.nav-bar-tag.colored-block.active,
.nav-bar-path.colored-block.active,
.nav-bar-section.colored-block.operations.active {
  background-color: var(--nav-accent-color);
  color: var(--nav-accent-text-color);
  border-radius: 0;
}

.nav-bar-h1:hover,
.nav-bar-h2:hover,
.nav-bar-info:hover,
.nav-bar-tag:hover,
.nav-bar-path:hover {
  color:var(--nav-hover-text-color);
  background-color:var(--nav-hover-bg-color);
}
`);
;// ./src/styles/info-styles.js

/* harmony default export */ const info_styles = (i`
#api-info {
  font-size: calc(var(--font-size-regular) - 1px);
  margin-top: 8px;
  margin-left: -15px;
}

#api-info span:before {
  content: "|";
  display: inline-block;
  opacity: 0.5;
  width: 15px;
  text-align: center;
}
#api-info span:first-child:before {
  content: "";
  width: 0px;
}
`);
;// ./src/styles/custom-styles.js


/*
This file is reserved for any custom css that developers want to add to
customize their theme. Simply add your css to this file and yarn build.
*/

/* harmony default export */ const custom_styles = (i`

`);
;// ./src/utils/common-utils.js
/* For Delayed Event Handler Execution */
function debounce(fn, delay) {
  let timeoutID = null;
  return (...args) => {
    clearTimeout(timeoutID);
    const that = this;
    timeoutID = setTimeout(() => {
      fn.apply(that, args);
    }, delay);
  };
}
const invalidCharsRegEx = /[\s#:?&={}]/g; // used for generating valid html element ids by replacing the invalid chars with hyphen (-)
const rapidocApiKey = '_rapidoc_api_key';
function sleep(ms) {
  // eslint-disable-next-line no-promise-executor-return
  return new Promise(resolve => setTimeout(resolve, ms));
}
function copyToClipboard(data, e) {
  const btnEl = e.target;
  const textArea = document.createElement('textarea');
  textArea.value = data;
  textArea.style.position = 'fixed'; // avoid scrolling to bottom
  document.body.appendChild(textArea);
  textArea.focus();
  textArea.select();
  try {
    document.execCommand('copy');
    btnEl.innerText = 'Copied';
    setTimeout(() => {
      btnEl.innerText = 'Copy';
    }, 5000);
  } catch (err) {
    console.error('Unable to copy', err); // eslint-disable-line no-console
  }
  document.body.removeChild(textArea);
}
function getBaseUrlFromUrl(url) {
  const pathArray = url.split('/');
  return `${pathArray[0]}//${pathArray[2]}`;
}
async function wait(ms) {
  return new Promise(resolve => {
    setTimeout(resolve, ms);
  });
}
function getMatchedComponents(searchVal, component) {
  return component.name.toLowerCase().includes(searchVal.toLowerCase());
}
function getMatchedPaths(searchVal, path, tagName = '') {
  const stringToSearch = `${path.method} ${path.path} ${path.summary || ''} ${path.description || ''} ${path.operationId || ''} ${tagName}`.toLowerCase();
  return stringToSearch.includes(searchVal.toLowerCase());
}
function schemaKeys(schemaProps, result = new Set()) {
  if (!schemaProps) {
    return result;
  }
  Object.keys(schemaProps).forEach(key => {
    var _schemaProps$key$item;
    result.add(key);
    if (schemaProps[key].properties) {
      schemaKeys(schemaProps[key].properties, result);
    } else if ((_schemaProps$key$item = schemaProps[key].items) !== null && _schemaProps$key$item !== void 0 && _schemaProps$key$item.properties) {
      var _schemaProps$key$item2;
      schemaKeys((_schemaProps$key$item2 = schemaProps[key].items) === null || _schemaProps$key$item2 === void 0 ? void 0 : _schemaProps$key$item2.properties, result);
    }
  });
  return result;
}
function advancedSearch(searchVal, allSpecTags, searchOptions = []) {
  if (!searchVal.trim() || searchOptions.length === 0) {
    return;
  }
  const pathsMatched = [];
  allSpecTags.forEach(tag => {
    tag.paths.forEach(path => {
      let stringToSearch = '';
      if (searchOptions.includes('search-api-path')) {
        stringToSearch = path.path;
      }
      if (searchOptions.includes('search-api-descr')) {
        stringToSearch = `${stringToSearch} ${(path.summary || '') + (path.description || '')}`;
      }
      if (searchOptions.includes('search-api-params')) {
        var _path$parameters;
        stringToSearch = `${stringToSearch} ${((_path$parameters = path.parameters) === null || _path$parameters === void 0 ? void 0 : _path$parameters.map(v => v.name).join(' ')) || ''}`;
      }
      if (searchOptions.includes('search-api-request-body') && path.requestBody) {
        let schemaKeySet = new Set();
        for (const contentType in (_path$requestBody = path.requestBody) === null || _path$requestBody === void 0 ? void 0 : _path$requestBody.content) {
          var _path$requestBody, _path$requestBody$con;
          if ((_path$requestBody$con = path.requestBody.content[contentType].schema) !== null && _path$requestBody$con !== void 0 && _path$requestBody$con.properties) {
            var _path$requestBody$con2;
            schemaKeySet = schemaKeys((_path$requestBody$con2 = path.requestBody.content[contentType].schema) === null || _path$requestBody$con2 === void 0 ? void 0 : _path$requestBody$con2.properties);
          }
          stringToSearch = `${stringToSearch} ${[...schemaKeySet].join(' ')}`;
        }
      }
      if (searchOptions.includes('search-api-resp-descr')) {
        stringToSearch = `${stringToSearch} ${Object.values(path.responses).map(v => v.description || '').join(' ')}`;
      }
      if (stringToSearch.toLowerCase().includes(searchVal.trim().toLowerCase())) {
        pathsMatched.push({
          elementId: path.elementId,
          method: path.method,
          path: path.path,
          summary: path.summary || path.description || '',
          deprecated: path.deprecated
        });
      }
    });
  });
  return pathsMatched;
}

/*
export function prettyXml(sourceXmlString) {
  const xmlDoc = new DOMParser().parseFromString(sourceXmlString, 'text/xml');
  const xsltDoc = new DOMParser().parseFromString([
    // describes how we want to modify the XML - indent everything
    `<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
      <xsl:strip-space elements="*"/>
        <xsl:template match="para[content-style][not(text())]">
          <xsl:value-of select="normalize-space(.)"/>
        </xsl:template>
        <xsl:template match="node()|@*">
          <xsl:copy><xsl:apply-templates select="node()|@*"/></xsl:copy>
        </xsl:template>
        <xsl:output indent="yes"/>
      </xsl:stylesheet>`,
  ].join('\n'), 'application/xml');
  const xsltProcessor = new XSLTProcessor();
  xsltProcessor.importStylesheet(xsltDoc);
  const resultDoc = xsltProcessor.transformToDocument(xmlDoc);
  return new XMLSerializer().serializeToString(resultDoc);
}
*/

function downloadResource(url, fileName) {
  if (url) {
    const a = document.createElement('a');
    document.body.appendChild(a);
    a.style = 'display: none';
    a.href = url;
    a.download = fileName;
    a.click();
    a.remove();
  }
}
function viewResource(url) {
  if (url) {
    const a = document.createElement('a');
    document.body.appendChild(a);
    a.style = 'display: none';
    a.href = url;
    a.target = '_blank';
    a.click();
    a.remove();
  }
}
;// ./node_modules/@apitools/openapi-parser/dist/openapi-parser.mjs
const openapi_parser_e=Object.freeze({url:"/"}),{fetch:openapi_parser_t,Response:openapi_parser_r,Headers:openapi_parser_n,Request:openapi_parser_s,FormData:openapi_parser_i,File:openapi_parser_o,Blob:openapi_parser_c}=globalThis;function openapi_parser_a(e,t){return t||"undefined"==typeof navigator||(t=navigator),t&&"ReactNative"===t.product?!(!e||"object"!=typeof e||"string"!=typeof e.uri):"undefined"!=typeof File&&e instanceof File||("undefined"!=typeof Blob&&e instanceof Blob||(!!ArrayBuffer.isView(e)||null!==e&&"object"==typeof e&&"function"==typeof e.pipe))}function openapi_parser_u(e,t){return Array.isArray(e)&&e.some((e=>openapi_parser_a(e,t)))}void 0===globalThis.fetch&&(globalThis.fetch=openapi_parser_t),void 0===globalThis.Headers&&(globalThis.Headers=openapi_parser_n),void 0===globalThis.Request&&(globalThis.Request=openapi_parser_s),void 0===globalThis.Response&&(globalThis.Response=openapi_parser_r),void 0===globalThis.FormData&&(globalThis.FormData=openapi_parser_i),void 0===globalThis.File&&(globalThis.File=openapi_parser_o),void 0===globalThis.Blob&&(globalThis.Blob=openapi_parser_c);class openapi_parser_l extends File{constructor(e,t="",r={}){super([e],t,r),this.data=e}valueOf(){return this.data}toString(){return this.valueOf()}}function openapi_parser_h(e,t="reserved"){return[...e].map((e=>{if((e=>/^[a-z0-9\-._~]+$/i.test(e))(e))return e;if((e=>":/?#[]@!$&'()*+,;=".indexOf(e)>-1)(e)&&"unsafe"===t)return e;const r=new TextEncoder;return Array.from(r.encode(e)).map((e=>`0${e.toString(16).toUpperCase()}`.slice(-2))).map((e=>`%${e}`)).join("")})).join("")}function openapi_parser_f(e){const{value:t}=e;return Array.isArray(t)?function({key:e,value:t,style:r,explode:n,escape:s}){if("simple"===r)return t.map((e=>openapi_parser_p(e,s))).join(",");if("label"===r)return`.${t.map((e=>openapi_parser_p(e,s))).join(".")}`;if("matrix"===r)return t.map((e=>openapi_parser_p(e,s))).reduce(((t,r)=>!t||n?`${t||""};${e}=${r}`:`${t},${r}`),"");if("form"===r){const r=n?`&${e}=`:",";return t.map((e=>openapi_parser_p(e,s))).join(r)}if("spaceDelimited"===r){const r=n?`${e}=`:"";return t.map((e=>openapi_parser_p(e,s))).join(` ${r}`)}if("pipeDelimited"===r){const r=n?`${e}=`:"";return t.map((e=>openapi_parser_p(e,s))).join(`|${r}`)}return}(e):"object"==typeof t?function({key:e,value:t,style:r,explode:n,escape:s}){const i=Object.keys(t);if("simple"===r)return i.reduce(((e,r)=>{const i=openapi_parser_p(t[r],s);return`${e?`${e},`:""}${r}${n?"=":","}${i}`}),"");if("label"===r)return i.reduce(((e,r)=>{const i=openapi_parser_p(t[r],s);return`${e?`${e}.`:"."}${r}${n?"=":"."}${i}`}),"");if("matrix"===r&&n)return i.reduce(((e,r)=>`${e?`${e};`:";"}${r}=${openapi_parser_p(t[r],s)}`),"");if("matrix"===r)return i.reduce(((r,n)=>{const i=openapi_parser_p(t[n],s);return`${r?`${r},`:`;${e}=`}${n},${i}`}),"");if("form"===r)return i.reduce(((e,r)=>{const i=openapi_parser_p(t[r],s);return`${e?`${e}${n?"&":","}`:""}${r}${n?"=":","}${i}`}),"");return}(e):function({key:e,value:t,style:r,escape:n}){if("simple"===r)return openapi_parser_p(t,n);if("label"===r)return`.${openapi_parser_p(t,n)}`;if("matrix"===r)return`;${e}=${openapi_parser_p(t,n)}`;if("form"===r)return openapi_parser_p(t,n);if("deepObject"===r)return openapi_parser_p(t,n);return}(e)}function openapi_parser_p(e,t=!1){return Array.isArray(e)||null!==e&&"object"==typeof e?e=JSON.stringify(e):"number"!=typeof e&&"boolean"!=typeof e||(e=String(e)),t&&e.length>0?openapi_parser_h(e,t):e}const openapi_parser_d={form:",",spaceDelimited:"%20",pipeDelimited:"|"},openapi_parser_m={csv:",",ssv:"%20",tsv:"%09",pipes:"|"};function openapi_parser_v(e,t,r=!1){const{collectionFormat:n,allowEmptyValue:s,serializationOption:i,encoding:o}=t,c="object"!=typeof t||Array.isArray(t)?t:t.value,h=r?e=>e.toString():e=>encodeURIComponent(e),f=h(e);if(void 0===c&&s)return[[f,""]];if(openapi_parser_a(c)||openapi_parser_u(c))return[[f,c]];if(i)return openapi_parser_y(e,c,r,i);if(o){if([typeof o.style,typeof o.explode,typeof o.allowReserved].some((e=>"undefined"!==e))){const{style:t,explode:n,allowReserved:s}=o;return openapi_parser_y(e,c,r,{style:t,explode:n,allowReserved:s})}if("string"==typeof o.contentType){if(o.contentType.startsWith("application/json")){const e=h("string"==typeof c?c:JSON.stringify(c));return[[f,new openapi_parser_l(e,"blob",{type:o.contentType})]]}const e=h(String(c));return[[f,new openapi_parser_l(e,"blob",{type:o.contentType})]]}return"object"!=typeof c?[[f,h(c)]]:Array.isArray(c)&&c.every((e=>"object"!=typeof e))?[[f,c.map(h).join(",")]]:[[f,h(JSON.stringify(c))]]}return"object"!=typeof c?[[f,h(c)]]:Array.isArray(c)?"multi"===n?[[f,c.map(h)]]:[[f,c.map(h).join(openapi_parser_m[n||"csv"])]]:[[f,""]]}function openapi_parser_y(e,t,r,n){const s=n.style||"form",i=void 0===n.explode?"form"===s:n.explode,o=!r&&(n&&n.allowReserved?"unsafe":"reserved"),c=e=>openapi_parser_p(e,o),a=r?e=>e:e=>c(e);return"object"!=typeof t?[[a(e),c(t)]]:Array.isArray(t)?i?[[a(e),t.map(c)]]:[[a(e),t.map(c).join(openapi_parser_d[s])]]:"deepObject"===s?Object.keys(t).map((r=>[a(`${e}[${r}]`),c(t[r])])):i?Object.keys(t).map((e=>[a(e),c(t[e])])):[[a(e),Object.keys(t).map((e=>[`${a(e)},${c(t[e])}`])).join(",")]]}function openapi_parser_b(e){return((e,{encode:t=!0}={})=>{const r=(e,t,n)=>(null==n?e.append(t,""):Array.isArray(n)?n.reduce(((n,s)=>r(e,t,s)),e):n instanceof Date?e.append(t,n.toISOString()):"object"==typeof n?Object.entries(n).reduce(((n,[s,i])=>r(e,`${t}[${s}]`,i)),e):e.append(t,n),e),n=Object.entries(e).reduce(((e,[t,n])=>r(e,t,n)),new URLSearchParams),s=String(n);return t?s:decodeURIComponent(s)})(Object.keys(e).reduce(((t,r)=>{for(const[n,s]of openapi_parser_v(r,e[r]))t[n]=s instanceof openapi_parser_l?s.valueOf():s;return t}),{}),{encode:!1})}function openapi_parser_g(e={}){const{url:t="",query:r,form:n}=e;if(n){const t=Object.keys(n).some((e=>{const{value:t}=n[e];return openapi_parser_a(t)||openapi_parser_u(t)})),r=e.headers["content-type"]||e.headers["Content-Type"];if(t||/multipart\/form-data/i.test(r)){const t=(s=e.form,Object.entries(s).reduce(((e,[t,r])=>{for(const[n,s]of openapi_parser_v(t,r,!0))if(Array.isArray(s))for(const t of s)if(ArrayBuffer.isView(t)){const r=new Blob([t]);e.append(n,r)}else e.append(n,t);else if(ArrayBuffer.isView(s)){const t=new Blob([s]);e.append(n,t)}else e.append(n,s);return e}),new FormData));e.formdata=t,e.body=t}else e.body=openapi_parser_b(n);delete e.form}var s;if(r){const[n,s]=t.split("?");let i="";if(s){const e=new URLSearchParams(s);Object.keys(r).forEach((t=>e.delete(t))),i=String(e)}const o=((...e)=>{const t=e.filter((e=>e)).join("&");return t?`?${t}`:""})(i,openapi_parser_b(r));e.url=n+o,delete e.query}return e}
/*! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */function openapi_parser_w(e){return null==e}var openapi_parser_x=function(e,t){var r,n,s,i;if(t)for(r=0,n=(i=Object.keys(t)).length;r<n;r+=1)e[s=i[r]]=t[s];return e},openapi_parser_j={isNothing:openapi_parser_w,isObject:function(e){return"object"==typeof e&&null!==e},toArray:function(e){return Array.isArray(e)?e:openapi_parser_w(e)?[]:[e]},repeat:function(e,t){var r,n="";for(r=0;r<t;r+=1)n+=e;return n},isNegativeZero:function(e){return 0===e&&Number.NEGATIVE_INFINITY===1/e},extend:openapi_parser_x};function openapi_parser_E(e,t){var r="",n=e.reason||"(unknown reason)";return e.mark?(e.mark.name&&(r+='in "'+e.mark.name+'" '),r+="("+(e.mark.line+1)+":"+(e.mark.column+1)+")",!t&&e.mark.snippet&&(r+="\n\n"+e.mark.snippet),n+" "+r):n}function openapi_parser_$(e,t){Error.call(this),this.name="YAMLException",this.reason=e,this.mark=t,this.message=openapi_parser_E(this,!1),Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=(new Error).stack||""}openapi_parser_$.prototype=Object.create(Error.prototype),openapi_parser_$.prototype.constructor=openapi_parser_$,openapi_parser_$.prototype.toString=function(e){return this.name+": "+openapi_parser_E(this,e)};var openapi_parser_O=openapi_parser_$;function openapi_parser_S(e,t,r,n,s){var i="",o="",c=Math.floor(s/2)-1;return n-t>c&&(t=n-c+(i=" ... ").length),r-n>c&&(r=n+c-(o=" ...").length),{str:i+e.slice(t,r).replace(/\t/g,"→")+o,pos:n-t+i.length}}function A(e,t){return openapi_parser_j.repeat(" ",t-e.length)+e}var openapi_parser_P=function(e,t){if(t=Object.create(t||null),!e.buffer)return null;t.maxLength||(t.maxLength=79),"number"!=typeof t.indent&&(t.indent=1),"number"!=typeof t.linesBefore&&(t.linesBefore=3),"number"!=typeof t.linesAfter&&(t.linesAfter=2);for(var r,n=/\r?\n|\r|\0/g,s=[0],i=[],o=-1;r=n.exec(e.buffer);)i.push(r.index),s.push(r.index+r[0].length),e.position<=r.index&&o<0&&(o=s.length-2);o<0&&(o=s.length-1);var c,a,u="",l=Math.min(e.line+t.linesAfter,i.length).toString().length,h=t.maxLength-(t.indent+l+3);for(c=1;c<=t.linesBefore&&!(o-c<0);c++)a=openapi_parser_S(e.buffer,s[o-c],i[o-c],e.position-(s[o]-s[o-c]),h),u=openapi_parser_j.repeat(" ",t.indent)+A((e.line-c+1).toString(),l)+" | "+a.str+"\n"+u;for(a=openapi_parser_S(e.buffer,s[o],i[o],e.position,h),u+=openapi_parser_j.repeat(" ",t.indent)+A((e.line+1).toString(),l)+" | "+a.str+"\n",u+=openapi_parser_j.repeat("-",t.indent+l+3+a.pos)+"^\n",c=1;c<=t.linesAfter&&!(o+c>=i.length);c++)a=openapi_parser_S(e.buffer,s[o+c],i[o+c],e.position-(s[o]-s[o+c]),h),u+=openapi_parser_j.repeat(" ",t.indent)+A((e.line+c+1).toString(),l)+" | "+a.str+"\n";return u.replace(/\n$/,"")},openapi_parser_T=["kind","multi","resolve","construct","instanceOf","predicate","represent","representName","defaultStyle","styleAliases"],openapi_parser_k=["scalar","sequence","mapping"];var openapi_parser_F=function(e,t){if(t=t||{},Object.keys(t).forEach((function(t){if(-1===openapi_parser_T.indexOf(t))throw new openapi_parser_O('Unknown option "'+t+'" is met in definition of "'+e+'" YAML type.')})),this.options=t,this.tag=e,this.kind=t.kind||null,this.resolve=t.resolve||function(){return!0},this.construct=t.construct||function(e){return e},this.instanceOf=t.instanceOf||null,this.predicate=t.predicate||null,this.represent=t.represent||null,this.representName=t.representName||null,this.defaultStyle=t.defaultStyle||null,this.multi=t.multi||!1,this.styleAliases=function(e){var t={};return null!==e&&Object.keys(e).forEach((function(r){e[r].forEach((function(e){t[String(e)]=r}))})),t}(t.styleAliases||null),-1===openapi_parser_k.indexOf(this.kind))throw new openapi_parser_O('Unknown kind "'+this.kind+'" is specified for "'+e+'" YAML type.')};function openapi_parser_I(e,t){var r=[];return e[t].forEach((function(e){var t=r.length;r.forEach((function(r,n){r.tag===e.tag&&r.kind===e.kind&&r.multi===e.multi&&(t=n)})),r[t]=e})),r}function openapi_parser_R(e){return this.extend(e)}openapi_parser_R.prototype.extend=function(e){var t=[],r=[];if(e instanceof openapi_parser_F)r.push(e);else if(Array.isArray(e))r=r.concat(e);else{if(!e||!Array.isArray(e.implicit)&&!Array.isArray(e.explicit))throw new openapi_parser_O("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");e.implicit&&(t=t.concat(e.implicit)),e.explicit&&(r=r.concat(e.explicit))}t.forEach((function(e){if(!(e instanceof openapi_parser_F))throw new openapi_parser_O("Specified list of YAML types (or a single Type object) contains a non-Type object.");if(e.loadKind&&"scalar"!==e.loadKind)throw new openapi_parser_O("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");if(e.multi)throw new openapi_parser_O("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.")})),r.forEach((function(e){if(!(e instanceof openapi_parser_F))throw new openapi_parser_O("Specified list of YAML types (or a single Type object) contains a non-Type object.")}));var n=Object.create(openapi_parser_R.prototype);return n.implicit=(this.implicit||[]).concat(t),n.explicit=(this.explicit||[]).concat(r),n.compiledImplicit=openapi_parser_I(n,"implicit"),n.compiledExplicit=openapi_parser_I(n,"explicit"),n.compiledTypeMap=function(){var e,t,r={scalar:{},sequence:{},mapping:{},fallback:{},multi:{scalar:[],sequence:[],mapping:[],fallback:[]}};function n(e){e.multi?(r.multi[e.kind].push(e),r.multi.fallback.push(e)):r[e.kind][e.tag]=r.fallback[e.tag]=e}for(e=0,t=arguments.length;e<t;e+=1)arguments[e].forEach(n);return r}(n.compiledImplicit,n.compiledExplicit),n};var openapi_parser_D=openapi_parser_R,openapi_parser_=new openapi_parser_F("tag:yaml.org,2002:str",{kind:"scalar",construct:function(e){return null!==e?e:""}}),C=new openapi_parser_F("tag:yaml.org,2002:seq",{kind:"sequence",construct:function(e){return null!==e?e:[]}}),openapi_parser_M=new openapi_parser_F("tag:yaml.org,2002:map",{kind:"mapping",construct:function(e){return null!==e?e:{}}}),openapi_parser_N=new openapi_parser_D({explicit:[openapi_parser_,C,openapi_parser_M]});var openapi_parser_q=new openapi_parser_F("tag:yaml.org,2002:null",{kind:"scalar",resolve:function(e){if(null===e)return!0;var t=e.length;return 1===t&&"~"===e||4===t&&("null"===e||"Null"===e||"NULL"===e)},construct:function(){return null},predicate:function(e){return null===e},represent:{canonical:function(){return"~"},lowercase:function(){return"null"},uppercase:function(){return"NULL"},camelcase:function(){return"Null"},empty:function(){return""}},defaultStyle:"lowercase"});var openapi_parser_B=new openapi_parser_F("tag:yaml.org,2002:bool",{kind:"scalar",resolve:function(e){if(null===e)return!1;var t=e.length;return 4===t&&("true"===e||"True"===e||"TRUE"===e)||5===t&&("false"===e||"False"===e||"FALSE"===e)},construct:function(e){return"true"===e||"True"===e||"TRUE"===e},predicate:function(e){return"[object Boolean]"===Object.prototype.toString.call(e)},represent:{lowercase:function(e){return e?"true":"false"},uppercase:function(e){return e?"TRUE":"FALSE"},camelcase:function(e){return e?"True":"False"}},defaultStyle:"lowercase"});function L(e){return 48<=e&&e<=55}function openapi_parser_U(e){return 48<=e&&e<=57}var J=new openapi_parser_F("tag:yaml.org,2002:int",{kind:"scalar",resolve:function(e){if(null===e)return!1;var t,r,n=e.length,s=0,i=!1;if(!n)return!1;if("-"!==(t=e[s])&&"+"!==t||(t=e[++s]),"0"===t){if(s+1===n)return!0;if("b"===(t=e[++s])){for(s++;s<n;s++)if("_"!==(t=e[s])){if("0"!==t&&"1"!==t)return!1;i=!0}return i&&"_"!==t}if("x"===t){for(s++;s<n;s++)if("_"!==(t=e[s])){if(!(48<=(r=e.charCodeAt(s))&&r<=57||65<=r&&r<=70||97<=r&&r<=102))return!1;i=!0}return i&&"_"!==t}if("o"===t){for(s++;s<n;s++)if("_"!==(t=e[s])){if(!L(e.charCodeAt(s)))return!1;i=!0}return i&&"_"!==t}}if("_"===t)return!1;for(;s<n;s++)if("_"!==(t=e[s])){if(!openapi_parser_U(e.charCodeAt(s)))return!1;i=!0}return!(!i||"_"===t)},construct:function(e){var t,r=e,n=1;if(-1!==r.indexOf("_")&&(r=r.replace(/_/g,"")),"-"!==(t=r[0])&&"+"!==t||("-"===t&&(n=-1),t=(r=r.slice(1))[0]),"0"===r)return 0;if("0"===t){if("b"===r[1])return n*parseInt(r.slice(2),2);if("x"===r[1])return n*parseInt(r.slice(2),16);if("o"===r[1])return n*parseInt(r.slice(2),8)}return n*parseInt(r,10)},predicate:function(e){return"[object Number]"===Object.prototype.toString.call(e)&&e%1==0&&!openapi_parser_j.isNegativeZero(e)},represent:{binary:function(e){return e>=0?"0b"+e.toString(2):"-0b"+e.toString(2).slice(1)},octal:function(e){return e>=0?"0o"+e.toString(8):"-0o"+e.toString(8).slice(1)},decimal:function(e){return e.toString(10)},hexadecimal:function(e){return e>=0?"0x"+e.toString(16).toUpperCase():"-0x"+e.toString(16).toUpperCase().slice(1)}},defaultStyle:"decimal",styleAliases:{binary:[2,"bin"],octal:[8,"oct"],decimal:[10,"dec"],hexadecimal:[16,"hex"]}}),openapi_parser_V=new RegExp("^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");var openapi_parser_G=/^[-+]?[0-9]+e/;var H=new openapi_parser_F("tag:yaml.org,2002:float",{kind:"scalar",resolve:function(e){return null!==e&&!(!openapi_parser_V.test(e)||"_"===e[e.length-1])},construct:function(e){var t,r;return r="-"===(t=e.replace(/_/g,"").toLowerCase())[0]?-1:1,"+-".indexOf(t[0])>=0&&(t=t.slice(1)),".inf"===t?1===r?Number.POSITIVE_INFINITY:Number.NEGATIVE_INFINITY:".nan"===t?NaN:r*parseFloat(t,10)},predicate:function(e){return"[object Number]"===Object.prototype.toString.call(e)&&(e%1!=0||openapi_parser_j.isNegativeZero(e))},represent:function(e,t){var r;if(isNaN(e))switch(t){case"lowercase":return".nan";case"uppercase":return".NAN";case"camelcase":return".NaN"}else if(Number.POSITIVE_INFINITY===e)switch(t){case"lowercase":return".inf";case"uppercase":return".INF";case"camelcase":return".Inf"}else if(Number.NEGATIVE_INFINITY===e)switch(t){case"lowercase":return"-.inf";case"uppercase":return"-.INF";case"camelcase":return"-.Inf"}else if(openapi_parser_j.isNegativeZero(e))return"-0.0";return r=e.toString(10),openapi_parser_G.test(r)?r.replace("e",".e"):r},defaultStyle:"lowercase"}),openapi_parser_z=openapi_parser_N.extend({implicit:[openapi_parser_q,openapi_parser_B,J,H]}),X=openapi_parser_z,W=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"),openapi_parser_Y=new RegExp("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$");var openapi_parser_Z=new openapi_parser_F("tag:yaml.org,2002:timestamp",{kind:"scalar",resolve:function(e){return null!==e&&(null!==W.exec(e)||null!==openapi_parser_Y.exec(e))},construct:function(e){var t,r,n,s,i,o,c,a,u=0,l=null;if(null===(t=W.exec(e))&&(t=openapi_parser_Y.exec(e)),null===t)throw new Error("Date resolve error");if(r=+t[1],n=+t[2]-1,s=+t[3],!t[4])return new Date(Date.UTC(r,n,s));if(i=+t[4],o=+t[5],c=+t[6],t[7]){for(u=t[7].slice(0,3);u.length<3;)u+="0";u=+u}return t[9]&&(l=6e4*(60*+t[10]+ +(t[11]||0)),"-"===t[9]&&(l=-l)),a=new Date(Date.UTC(r,n,s,i,o,c,u)),l&&a.setTime(a.getTime()-l),a},instanceOf:Date,represent:function(e){return e.toISOString()}});var openapi_parser_K=new openapi_parser_F("tag:yaml.org,2002:merge",{kind:"scalar",resolve:function(e){return"<<"===e||null===e}}),openapi_parser_Q="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";var ee=new openapi_parser_F("tag:yaml.org,2002:binary",{kind:"scalar",resolve:function(e){if(null===e)return!1;var t,r,n=0,s=e.length,i=openapi_parser_Q;for(r=0;r<s;r++)if(!((t=i.indexOf(e.charAt(r)))>64)){if(t<0)return!1;n+=6}return n%8==0},construct:function(e){var t,r,n=e.replace(/[\r\n=]/g,""),s=n.length,i=openapi_parser_Q,o=0,c=[];for(t=0;t<s;t++)t%4==0&&t&&(c.push(o>>16&255),c.push(o>>8&255),c.push(255&o)),o=o<<6|i.indexOf(n.charAt(t));return 0===(r=s%4*6)?(c.push(o>>16&255),c.push(o>>8&255),c.push(255&o)):18===r?(c.push(o>>10&255),c.push(o>>2&255)):12===r&&c.push(o>>4&255),new Uint8Array(c)},predicate:function(e){return"[object Uint8Array]"===Object.prototype.toString.call(e)},represent:function(e){var t,r,n="",s=0,i=e.length,o=openapi_parser_Q;for(t=0;t<i;t++)t%3==0&&t&&(n+=o[s>>18&63],n+=o[s>>12&63],n+=o[s>>6&63],n+=o[63&s]),s=(s<<8)+e[t];return 0===(r=i%3)?(n+=o[s>>18&63],n+=o[s>>12&63],n+=o[s>>6&63],n+=o[63&s]):2===r?(n+=o[s>>10&63],n+=o[s>>4&63],n+=o[s<<2&63],n+=o[64]):1===r&&(n+=o[s>>2&63],n+=o[s<<4&63],n+=o[64],n+=o[64]),n}}),te=Object.prototype.hasOwnProperty,re=Object.prototype.toString;var ne=new openapi_parser_F("tag:yaml.org,2002:omap",{kind:"sequence",resolve:function(e){if(null===e)return!0;var t,r,n,s,i,o=[],c=e;for(t=0,r=c.length;t<r;t+=1){if(n=c[t],i=!1,"[object Object]"!==re.call(n))return!1;for(s in n)if(te.call(n,s)){if(i)return!1;i=!0}if(!i)return!1;if(-1!==o.indexOf(s))return!1;o.push(s)}return!0},construct:function(e){return null!==e?e:[]}}),se=Object.prototype.toString;var ie=new openapi_parser_F("tag:yaml.org,2002:pairs",{kind:"sequence",resolve:function(e){if(null===e)return!0;var t,r,n,s,i,o=e;for(i=new Array(o.length),t=0,r=o.length;t<r;t+=1){if(n=o[t],"[object Object]"!==se.call(n))return!1;if(1!==(s=Object.keys(n)).length)return!1;i[t]=[s[0],n[s[0]]]}return!0},construct:function(e){if(null===e)return[];var t,r,n,s,i,o=e;for(i=new Array(o.length),t=0,r=o.length;t<r;t+=1)n=o[t],s=Object.keys(n),i[t]=[s[0],n[s[0]]];return i}}),oe=Object.prototype.hasOwnProperty;var ce=new openapi_parser_F("tag:yaml.org,2002:set",{kind:"mapping",resolve:function(e){if(null===e)return!0;var t,r=e;for(t in r)if(oe.call(r,t)&&null!==r[t])return!1;return!0},construct:function(e){return null!==e?e:{}}}),ae=X.extend({implicit:[openapi_parser_Z,openapi_parser_K],explicit:[ee,ne,ie,ce]}),ue=Object.prototype.hasOwnProperty,le=/[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/,he=/[\x85\u2028\u2029]/,fe=/[,\[\]\{\}]/,pe=/^(?:!|!!|![a-z\-]+!)$/i,de=/^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;function me(e){return Object.prototype.toString.call(e)}function ve(e){return 10===e||13===e}function ye(e){return 9===e||32===e}function be(e){return 9===e||32===e||10===e||13===e}function ge(e){return 44===e||91===e||93===e||123===e||125===e}function we(e){var t;return 48<=e&&e<=57?e-48:97<=(t=32|e)&&t<=102?t-97+10:-1}function xe(e){return 48===e?"\0":97===e?"":98===e?"\b":116===e||9===e?"\t":110===e?"\n":118===e?"\v":102===e?"\f":114===e?"\r":101===e?"":32===e?" ":34===e?'"':47===e?"/":92===e?"\\":78===e?"":95===e?" ":76===e?"\u2028":80===e?"\u2029":""}function je(e){return e<=65535?String.fromCharCode(e):String.fromCharCode(55296+(e-65536>>10),56320+(e-65536&1023))}for(var Ee=new Array(256),$e=new Array(256),openapi_parser_Oe=0;openapi_parser_Oe<256;openapi_parser_Oe++)Ee[openapi_parser_Oe]=xe(openapi_parser_Oe)?1:0,$e[openapi_parser_Oe]=xe(openapi_parser_Oe);function openapi_parser_Se(e,t){this.input=e,this.filename=t.filename||null,this.schema=t.schema||ae,this.onWarning=t.onWarning||null,this.legacy=t.legacy||!1,this.json=t.json||!1,this.listener=t.listener||null,this.implicitTypes=this.schema.compiledImplicit,this.typeMap=this.schema.compiledTypeMap,this.length=e.length,this.position=0,this.line=0,this.lineStart=0,this.lineIndent=0,this.firstTabInLine=-1,this.documents=[]}function Ae(e,t){var r={name:e.filename,buffer:e.input.slice(0,-1),position:e.position,line:e.line,column:e.position-e.lineStart};return r.snippet=openapi_parser_P(r),new openapi_parser_O(t,r)}function Pe(e,t){throw Ae(e,t)}function Te(e,t){e.onWarning&&e.onWarning.call(null,Ae(e,t))}var openapi_parser_ke={YAML:function(e,t,r){var n,s,i;null!==e.version&&Pe(e,"duplication of %YAML directive"),1!==r.length&&Pe(e,"YAML directive accepts exactly one argument"),null===(n=/^([0-9]+)\.([0-9]+)$/.exec(r[0]))&&Pe(e,"ill-formed argument of the YAML directive"),s=parseInt(n[1],10),i=parseInt(n[2],10),1!==s&&Pe(e,"unacceptable YAML version of the document"),e.version=r[0],e.checkLineBreaks=i<2,1!==i&&2!==i&&Te(e,"unsupported YAML version of the document")},TAG:function(e,t,r){var n,s;2!==r.length&&Pe(e,"TAG directive accepts exactly two arguments"),n=r[0],s=r[1],pe.test(n)||Pe(e,"ill-formed tag handle (first argument) of the TAG directive"),ue.call(e.tagMap,n)&&Pe(e,'there is a previously declared suffix for "'+n+'" tag handle'),de.test(s)||Pe(e,"ill-formed tag prefix (second argument) of the TAG directive");try{s=decodeURIComponent(s)}catch(t){Pe(e,"tag prefix is malformed: "+s)}e.tagMap[n]=s}};function Fe(e,t,r,n){var s,i,o,c;if(t<r){if(c=e.input.slice(t,r),n)for(s=0,i=c.length;s<i;s+=1)9===(o=c.charCodeAt(s))||32<=o&&o<=1114111||Pe(e,"expected valid JSON character");else le.test(c)&&Pe(e,"the stream contains non-printable characters");e.result+=c}}function Ie(e,t,r,n){var s,i,o,c;for(openapi_parser_j.isObject(r)||Pe(e,"cannot merge mappings; the provided source object is unacceptable"),o=0,c=(s=Object.keys(r)).length;o<c;o+=1)i=s[o],ue.call(t,i)||(t[i]=r[i],n[i]=!0)}function openapi_parser_Re(e,t,r,n,s,i,o,c,a){var u,l;if(Array.isArray(s))for(u=0,l=(s=Array.prototype.slice.call(s)).length;u<l;u+=1)Array.isArray(s[u])&&Pe(e,"nested arrays are not supported inside keys"),"object"==typeof s&&"[object Object]"===me(s[u])&&(s[u]="[object Object]");if("object"==typeof s&&"[object Object]"===me(s)&&(s="[object Object]"),s=String(s),null===t&&(t={}),"tag:yaml.org,2002:merge"===n)if(Array.isArray(i))for(u=0,l=i.length;u<l;u+=1)Ie(e,t,i[u],r);else Ie(e,t,i,r);else e.json||ue.call(r,s)||!ue.call(t,s)||(e.line=o||e.line,e.lineStart=c||e.lineStart,e.position=a||e.position,Pe(e,"duplicated mapping key")),"__proto__"===s?Object.defineProperty(t,s,{configurable:!0,enumerable:!0,writable:!0,value:i}):t[s]=i,delete r[s];return t}function De(e){var t;10===(t=e.input.charCodeAt(e.position))?e.position++:13===t?(e.position++,10===e.input.charCodeAt(e.position)&&e.position++):Pe(e,"a line break is expected"),e.line+=1,e.lineStart=e.position,e.firstTabInLine=-1}function _e(e,t,r){for(var n=0,s=e.input.charCodeAt(e.position);0!==s;){for(;ye(s);)9===s&&-1===e.firstTabInLine&&(e.firstTabInLine=e.position),s=e.input.charCodeAt(++e.position);if(t&&35===s)do{s=e.input.charCodeAt(++e.position)}while(10!==s&&13!==s&&0!==s);if(!ve(s))break;for(De(e),s=e.input.charCodeAt(e.position),n++,e.lineIndent=0;32===s;)e.lineIndent++,s=e.input.charCodeAt(++e.position)}return-1!==r&&0!==n&&e.lineIndent<r&&Te(e,"deficient indentation"),n}function Ce(e){var t,r=e.position;return!(45!==(t=e.input.charCodeAt(r))&&46!==t||t!==e.input.charCodeAt(r+1)||t!==e.input.charCodeAt(r+2)||(r+=3,0!==(t=e.input.charCodeAt(r))&&!be(t)))}function Me(e,t){1===t?e.result+=" ":t>1&&(e.result+=openapi_parser_j.repeat("\n",t-1))}function Ne(e,t){var r,n,s=e.tag,i=e.anchor,o=[],c=!1;if(-1!==e.firstTabInLine)return!1;for(null!==e.anchor&&(e.anchorMap[e.anchor]=o),n=e.input.charCodeAt(e.position);0!==n&&(-1!==e.firstTabInLine&&(e.position=e.firstTabInLine,Pe(e,"tab characters must not be used in indentation")),45===n)&&be(e.input.charCodeAt(e.position+1));)if(c=!0,e.position++,_e(e,!0,-1)&&e.lineIndent<=t)o.push(null),n=e.input.charCodeAt(e.position);else if(r=e.line,Le(e,t,3,!1,!0),o.push(e.result),_e(e,!0,-1),n=e.input.charCodeAt(e.position),(e.line===r||e.lineIndent>t)&&0!==n)Pe(e,"bad indentation of a sequence entry");else if(e.lineIndent<t)break;return!!c&&(e.tag=s,e.anchor=i,e.kind="sequence",e.result=o,!0)}function qe(e){var t,r,n,s,i=!1,o=!1;if(33!==(s=e.input.charCodeAt(e.position)))return!1;if(null!==e.tag&&Pe(e,"duplication of a tag property"),60===(s=e.input.charCodeAt(++e.position))?(i=!0,s=e.input.charCodeAt(++e.position)):33===s?(o=!0,r="!!",s=e.input.charCodeAt(++e.position)):r="!",t=e.position,i){do{s=e.input.charCodeAt(++e.position)}while(0!==s&&62!==s);e.position<e.length?(n=e.input.slice(t,e.position),s=e.input.charCodeAt(++e.position)):Pe(e,"unexpected end of the stream within a verbatim tag")}else{for(;0!==s&&!be(s);)33===s&&(o?Pe(e,"tag suffix cannot contain exclamation marks"):(r=e.input.slice(t-1,e.position+1),pe.test(r)||Pe(e,"named tag handle cannot contain such characters"),o=!0,t=e.position+1)),s=e.input.charCodeAt(++e.position);n=e.input.slice(t,e.position),fe.test(n)&&Pe(e,"tag suffix cannot contain flow indicator characters")}n&&!de.test(n)&&Pe(e,"tag name cannot contain such characters: "+n);try{n=decodeURIComponent(n)}catch(t){Pe(e,"tag name is malformed: "+n)}return i?e.tag=n:ue.call(e.tagMap,r)?e.tag=e.tagMap[r]+n:"!"===r?e.tag="!"+n:"!!"===r?e.tag="tag:yaml.org,2002:"+n:Pe(e,'undeclared tag handle "'+r+'"'),!0}function Be(e){var t,r;if(38!==(r=e.input.charCodeAt(e.position)))return!1;for(null!==e.anchor&&Pe(e,"duplication of an anchor property"),r=e.input.charCodeAt(++e.position),t=e.position;0!==r&&!be(r)&&!ge(r);)r=e.input.charCodeAt(++e.position);return e.position===t&&Pe(e,"name of an anchor node must contain at least one character"),e.anchor=e.input.slice(t,e.position),!0}function Le(e,t,r,n,s){var i,o,c,a,u,l,h,f,p,d=1,m=!1,v=!1;if(null!==e.listener&&e.listener("open",e),e.tag=null,e.anchor=null,e.kind=null,e.result=null,i=o=c=4===r||3===r,n&&_e(e,!0,-1)&&(m=!0,e.lineIndent>t?d=1:e.lineIndent===t?d=0:e.lineIndent<t&&(d=-1)),1===d)for(;qe(e)||Be(e);)_e(e,!0,-1)?(m=!0,c=i,e.lineIndent>t?d=1:e.lineIndent===t?d=0:e.lineIndent<t&&(d=-1)):c=!1;if(c&&(c=m||s),1!==d&&4!==r||(f=1===r||2===r?t:t+1,p=e.position-e.lineStart,1===d?c&&(Ne(e,p)||function(e,t,r){var n,s,i,o,c,a,u,l=e.tag,h=e.anchor,f={},p=Object.create(null),d=null,m=null,v=null,y=!1,b=!1;if(-1!==e.firstTabInLine)return!1;for(null!==e.anchor&&(e.anchorMap[e.anchor]=f),u=e.input.charCodeAt(e.position);0!==u;){if(y||-1===e.firstTabInLine||(e.position=e.firstTabInLine,Pe(e,"tab characters must not be used in indentation")),n=e.input.charCodeAt(e.position+1),i=e.line,63!==u&&58!==u||!be(n)){if(o=e.line,c=e.lineStart,a=e.position,!Le(e,r,2,!1,!0))break;if(e.line===i){for(u=e.input.charCodeAt(e.position);ye(u);)u=e.input.charCodeAt(++e.position);if(58===u)be(u=e.input.charCodeAt(++e.position))||Pe(e,"a whitespace character is expected after the key-value separator within a block mapping"),y&&(openapi_parser_Re(e,f,p,d,m,null,o,c,a),d=m=v=null),b=!0,y=!1,s=!1,d=e.tag,m=e.result;else{if(!b)return e.tag=l,e.anchor=h,!0;Pe(e,"can not read an implicit mapping pair; a colon is missed")}}else{if(!b)return e.tag=l,e.anchor=h,!0;Pe(e,"can not read a block mapping entry; a multiline key may not be an implicit key")}}else 63===u?(y&&(openapi_parser_Re(e,f,p,d,m,null,o,c,a),d=m=v=null),b=!0,y=!0,s=!0):y?(y=!1,s=!0):Pe(e,"incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line"),e.position+=1,u=n;if((e.line===i||e.lineIndent>t)&&(y&&(o=e.line,c=e.lineStart,a=e.position),Le(e,t,4,!0,s)&&(y?m=e.result:v=e.result),y||(openapi_parser_Re(e,f,p,d,m,v,o,c,a),d=m=v=null),_e(e,!0,-1),u=e.input.charCodeAt(e.position)),(e.line===i||e.lineIndent>t)&&0!==u)Pe(e,"bad indentation of a mapping entry");else if(e.lineIndent<t)break}return y&&openapi_parser_Re(e,f,p,d,m,null,o,c,a),b&&(e.tag=l,e.anchor=h,e.kind="mapping",e.result=f),b}(e,p,f))||function(e,t){var r,n,s,i,o,c,a,u,l,h,f,p,d=!0,m=e.tag,v=e.anchor,y=Object.create(null);if(91===(p=e.input.charCodeAt(e.position)))o=93,u=!1,i=[];else{if(123!==p)return!1;o=125,u=!0,i={}}for(null!==e.anchor&&(e.anchorMap[e.anchor]=i),p=e.input.charCodeAt(++e.position);0!==p;){if(_e(e,!0,t),(p=e.input.charCodeAt(e.position))===o)return e.position++,e.tag=m,e.anchor=v,e.kind=u?"mapping":"sequence",e.result=i,!0;d?44===p&&Pe(e,"expected the node content, but found ','"):Pe(e,"missed comma between flow collection entries"),f=null,c=a=!1,63===p&&be(e.input.charCodeAt(e.position+1))&&(c=a=!0,e.position++,_e(e,!0,t)),r=e.line,n=e.lineStart,s=e.position,Le(e,t,1,!1,!0),h=e.tag,l=e.result,_e(e,!0,t),p=e.input.charCodeAt(e.position),!a&&e.line!==r||58!==p||(c=!0,p=e.input.charCodeAt(++e.position),_e(e,!0,t),Le(e,t,1,!1,!0),f=e.result),u?openapi_parser_Re(e,i,y,h,l,f,r,n,s):c?i.push(openapi_parser_Re(e,null,y,h,l,f,r,n,s)):i.push(l),_e(e,!0,t),44===(p=e.input.charCodeAt(e.position))?(d=!0,p=e.input.charCodeAt(++e.position)):d=!1}Pe(e,"unexpected end of the stream within a flow collection")}(e,f)?v=!0:(o&&function(e,t){var r,n,s,i,o,c=1,a=!1,u=!1,l=t,h=0,f=!1;if(124===(i=e.input.charCodeAt(e.position)))n=!1;else{if(62!==i)return!1;n=!0}for(e.kind="scalar",e.result="";0!==i;)if(43===(i=e.input.charCodeAt(++e.position))||45===i)1===c?c=43===i?3:2:Pe(e,"repeat of a chomping mode identifier");else{if(!((s=48<=(o=i)&&o<=57?o-48:-1)>=0))break;0===s?Pe(e,"bad explicit indentation width of a block scalar; it cannot be less than one"):u?Pe(e,"repeat of an indentation width identifier"):(l=t+s-1,u=!0)}if(ye(i)){do{i=e.input.charCodeAt(++e.position)}while(ye(i));if(35===i)do{i=e.input.charCodeAt(++e.position)}while(!ve(i)&&0!==i)}for(;0!==i;){for(De(e),e.lineIndent=0,i=e.input.charCodeAt(e.position);(!u||e.lineIndent<l)&&32===i;)e.lineIndent++,i=e.input.charCodeAt(++e.position);if(!u&&e.lineIndent>l&&(l=e.lineIndent),ve(i))h++;else{if(e.lineIndent<l){3===c?e.result+=openapi_parser_j.repeat("\n",a?1+h:h):1===c&&a&&(e.result+="\n");break}for(n?ye(i)?(f=!0,e.result+=openapi_parser_j.repeat("\n",a?1+h:h)):f?(f=!1,e.result+=openapi_parser_j.repeat("\n",h+1)):0===h?a&&(e.result+=" "):e.result+=openapi_parser_j.repeat("\n",h):e.result+=openapi_parser_j.repeat("\n",a?1+h:h),a=!0,u=!0,h=0,r=e.position;!ve(i)&&0!==i;)i=e.input.charCodeAt(++e.position);Fe(e,r,e.position,!1)}}return!0}(e,f)||function(e,t){var r,n,s;if(39!==(r=e.input.charCodeAt(e.position)))return!1;for(e.kind="scalar",e.result="",e.position++,n=s=e.position;0!==(r=e.input.charCodeAt(e.position));)if(39===r){if(Fe(e,n,e.position,!0),39!==(r=e.input.charCodeAt(++e.position)))return!0;n=e.position,e.position++,s=e.position}else ve(r)?(Fe(e,n,s,!0),Me(e,_e(e,!1,t)),n=s=e.position):e.position===e.lineStart&&Ce(e)?Pe(e,"unexpected end of the document within a single quoted scalar"):(e.position++,s=e.position);Pe(e,"unexpected end of the stream within a single quoted scalar")}(e,f)||function(e,t){var r,n,s,i,o,c,a;if(34!==(c=e.input.charCodeAt(e.position)))return!1;for(e.kind="scalar",e.result="",e.position++,r=n=e.position;0!==(c=e.input.charCodeAt(e.position));){if(34===c)return Fe(e,r,e.position,!0),e.position++,!0;if(92===c){if(Fe(e,r,e.position,!0),ve(c=e.input.charCodeAt(++e.position)))_e(e,!1,t);else if(c<256&&Ee[c])e.result+=$e[c],e.position++;else if((o=120===(a=c)?2:117===a?4:85===a?8:0)>0){for(s=o,i=0;s>0;s--)(o=we(c=e.input.charCodeAt(++e.position)))>=0?i=(i<<4)+o:Pe(e,"expected hexadecimal character");e.result+=je(i),e.position++}else Pe(e,"unknown escape sequence");r=n=e.position}else ve(c)?(Fe(e,r,n,!0),Me(e,_e(e,!1,t)),r=n=e.position):e.position===e.lineStart&&Ce(e)?Pe(e,"unexpected end of the document within a double quoted scalar"):(e.position++,n=e.position)}Pe(e,"unexpected end of the stream within a double quoted scalar")}(e,f)?v=!0:!function(e){var t,r,n;if(42!==(n=e.input.charCodeAt(e.position)))return!1;for(n=e.input.charCodeAt(++e.position),t=e.position;0!==n&&!be(n)&&!ge(n);)n=e.input.charCodeAt(++e.position);return e.position===t&&Pe(e,"name of an alias node must contain at least one character"),r=e.input.slice(t,e.position),ue.call(e.anchorMap,r)||Pe(e,'unidentified alias "'+r+'"'),e.result=e.anchorMap[r],_e(e,!0,-1),!0}(e)?function(e,t,r){var n,s,i,o,c,a,u,l,h=e.kind,f=e.result;if(be(l=e.input.charCodeAt(e.position))||ge(l)||35===l||38===l||42===l||33===l||124===l||62===l||39===l||34===l||37===l||64===l||96===l)return!1;if((63===l||45===l)&&(be(n=e.input.charCodeAt(e.position+1))||r&&ge(n)))return!1;for(e.kind="scalar",e.result="",s=i=e.position,o=!1;0!==l;){if(58===l){if(be(n=e.input.charCodeAt(e.position+1))||r&&ge(n))break}else if(35===l){if(be(e.input.charCodeAt(e.position-1)))break}else{if(e.position===e.lineStart&&Ce(e)||r&&ge(l))break;if(ve(l)){if(c=e.line,a=e.lineStart,u=e.lineIndent,_e(e,!1,-1),e.lineIndent>=t){o=!0,l=e.input.charCodeAt(e.position);continue}e.position=i,e.line=c,e.lineStart=a,e.lineIndent=u;break}}o&&(Fe(e,s,i,!1),Me(e,e.line-c),s=i=e.position,o=!1),ye(l)||(i=e.position+1),l=e.input.charCodeAt(++e.position)}return Fe(e,s,i,!1),!!e.result||(e.kind=h,e.result=f,!1)}(e,f,1===r)&&(v=!0,null===e.tag&&(e.tag="?")):(v=!0,null===e.tag&&null===e.anchor||Pe(e,"alias node should not have any properties")),null!==e.anchor&&(e.anchorMap[e.anchor]=e.result)):0===d&&(v=c&&Ne(e,p))),null===e.tag)null!==e.anchor&&(e.anchorMap[e.anchor]=e.result);else if("?"===e.tag){for(null!==e.result&&"scalar"!==e.kind&&Pe(e,'unacceptable node kind for !<?> tag; it should be "scalar", not "'+e.kind+'"'),a=0,u=e.implicitTypes.length;a<u;a+=1)if((h=e.implicitTypes[a]).resolve(e.result)){e.result=h.construct(e.result),e.tag=h.tag,null!==e.anchor&&(e.anchorMap[e.anchor]=e.result);break}}else if("!"!==e.tag){if(ue.call(e.typeMap[e.kind||"fallback"],e.tag))h=e.typeMap[e.kind||"fallback"][e.tag];else for(h=null,a=0,u=(l=e.typeMap.multi[e.kind||"fallback"]).length;a<u;a+=1)if(e.tag.slice(0,l[a].tag.length)===l[a].tag){h=l[a];break}h||Pe(e,"unknown tag !<"+e.tag+">"),null!==e.result&&h.kind!==e.kind&&Pe(e,"unacceptable node kind for !<"+e.tag+'> tag; it should be "'+h.kind+'", not "'+e.kind+'"'),h.resolve(e.result,e.tag)?(e.result=h.construct(e.result,e.tag),null!==e.anchor&&(e.anchorMap[e.anchor]=e.result)):Pe(e,"cannot resolve a node with !<"+e.tag+"> explicit tag")}return null!==e.listener&&e.listener("close",e),null!==e.tag||null!==e.anchor||v}function Ue(e){var t,r,n,s,i=e.position,o=!1;for(e.version=null,e.checkLineBreaks=e.legacy,e.tagMap=Object.create(null),e.anchorMap=Object.create(null);0!==(s=e.input.charCodeAt(e.position))&&(_e(e,!0,-1),s=e.input.charCodeAt(e.position),!(e.lineIndent>0||37!==s));){for(o=!0,s=e.input.charCodeAt(++e.position),t=e.position;0!==s&&!be(s);)s=e.input.charCodeAt(++e.position);for(n=[],(r=e.input.slice(t,e.position)).length<1&&Pe(e,"directive name must not be less than one character in length");0!==s;){for(;ye(s);)s=e.input.charCodeAt(++e.position);if(35===s){do{s=e.input.charCodeAt(++e.position)}while(0!==s&&!ve(s));break}if(ve(s))break;for(t=e.position;0!==s&&!be(s);)s=e.input.charCodeAt(++e.position);n.push(e.input.slice(t,e.position))}0!==s&&De(e),ue.call(openapi_parser_ke,r)?openapi_parser_ke[r](e,r,n):Te(e,'unknown document directive "'+r+'"')}_e(e,!0,-1),0===e.lineIndent&&45===e.input.charCodeAt(e.position)&&45===e.input.charCodeAt(e.position+1)&&45===e.input.charCodeAt(e.position+2)?(e.position+=3,_e(e,!0,-1)):o&&Pe(e,"directives end mark is expected"),Le(e,e.lineIndent-1,4,!1,!0),_e(e,!0,-1),e.checkLineBreaks&&he.test(e.input.slice(i,e.position))&&Te(e,"non-ASCII line breaks are interpreted as content"),e.documents.push(e.result),e.position===e.lineStart&&Ce(e)?46===e.input.charCodeAt(e.position)&&(e.position+=3,_e(e,!0,-1)):e.position<e.length-1&&Pe(e,"end of the stream or a document separator is expected")}function Je(e,t){t=t||{},0!==(e=String(e)).length&&(10!==e.charCodeAt(e.length-1)&&13!==e.charCodeAt(e.length-1)&&(e+="\n"),65279===e.charCodeAt(0)&&(e=e.slice(1)));var r=new openapi_parser_Se(e,t),n=e.indexOf("\0");for(-1!==n&&(r.position=n,Pe(r,"null byte is not allowed in input")),r.input+="\0";32===r.input.charCodeAt(r.position);)r.lineIndent+=1,r.position+=1;for(;r.position<r.length-1;)Ue(r);return r.documents}var Ve=function(e,t,r){null!==t&&"object"==typeof t&&void 0===r&&(r=t,t=null);var n=Je(e,r);if("function"!=typeof t)return n;for(var s=0,i=n.length;s<i;s+=1)t(n[s])},Ge={loadAll:Ve,load:function(e,t){var r=Je(e,t);if(0!==r.length){if(1===r.length)return r[0];throw new openapi_parser_O("expected a single document in the stream, but found more")}}},He=Object.prototype.toString,ze=Object.prototype.hasOwnProperty,Xe={0:"\\0",7:"\\a",8:"\\b",9:"\\t",10:"\\n",11:"\\v",12:"\\f",13:"\\r",27:"\\e",34:'\\"',92:"\\\\",133:"\\N",160:"\\_",8232:"\\L",8233:"\\P"},We=["y","Y","yes","Yes","YES","on","On","ON","n","N","no","No","NO","off","Off","OFF"],Ye=/^[-+]?[0-9_]+(?::[0-9_]+)+(?:\.[0-9_]*)?$/;function Ze(e){var t,r,n;if(t=e.toString(16).toUpperCase(),e<=255)r="x",n=2;else if(e<=65535)r="u",n=4;else{if(!(e<=4294967295))throw new openapi_parser_O("code point within a string may not be greater than 0xFFFFFFFF");r="U",n=8}return"\\"+r+openapi_parser_j.repeat("0",n-t.length)+t}function Ke(e){this.schema=e.schema||ae,this.indent=Math.max(1,e.indent||2),this.noArrayIndent=e.noArrayIndent||!1,this.skipInvalid=e.skipInvalid||!1,this.flowLevel=openapi_parser_j.isNothing(e.flowLevel)?-1:e.flowLevel,this.styleMap=function(e,t){var r,n,s,i,o,c,a;if(null===t)return{};for(r={},s=0,i=(n=Object.keys(t)).length;s<i;s+=1)o=n[s],c=String(t[o]),"!!"===o.slice(0,2)&&(o="tag:yaml.org,2002:"+o.slice(2)),(a=e.compiledTypeMap.fallback[o])&&ze.call(a.styleAliases,c)&&(c=a.styleAliases[c]),r[o]=c;return r}(this.schema,e.styles||null),this.sortKeys=e.sortKeys||!1,this.lineWidth=e.lineWidth||80,this.noRefs=e.noRefs||!1,this.noCompatMode=e.noCompatMode||!1,this.condenseFlow=e.condenseFlow||!1,this.quotingType='"'===e.quotingType?2:1,this.forceQuotes=e.forceQuotes||!1,this.replacer="function"==typeof e.replacer?e.replacer:null,this.implicitTypes=this.schema.compiledImplicit,this.explicitTypes=this.schema.compiledExplicit,this.tag=null,this.result="",this.duplicates=[],this.usedDuplicates=null}function Qe(e,t){for(var r,n=openapi_parser_j.repeat(" ",t),s=0,i=-1,o="",c=e.length;s<c;)-1===(i=e.indexOf("\n",s))?(r=e.slice(s),s=c):(r=e.slice(s,i+1),s=i+1),r.length&&"\n"!==r&&(o+=n),o+=r;return o}function openapi_parser_et(e,t){return"\n"+openapi_parser_j.repeat(" ",e.indent*t)}function tt(e){return 32===e||9===e}function rt(e){return 32<=e&&e<=126||161<=e&&e<=55295&&8232!==e&&8233!==e||57344<=e&&e<=65533&&65279!==e||65536<=e&&e<=1114111}function nt(e){return rt(e)&&65279!==e&&13!==e&&10!==e}function openapi_parser_st(e,t,r){var n=nt(e),s=n&&!tt(e);return(r?n:n&&44!==e&&91!==e&&93!==e&&123!==e&&125!==e)&&35!==e&&!(58===t&&!s)||nt(t)&&!tt(t)&&35===e||58===t&&s}function it(e,t){var r,n=e.charCodeAt(t);return n>=55296&&n<=56319&&t+1<e.length&&(r=e.charCodeAt(t+1))>=56320&&r<=57343?1024*(n-55296)+r-56320+65536:n}function ot(e){return/^\n* /.test(e)}function ct(e,t,r,n,s,i,o,c){var a,u,l=0,h=null,f=!1,p=!1,d=-1!==n,m=-1,v=rt(u=it(e,0))&&65279!==u&&!tt(u)&&45!==u&&63!==u&&58!==u&&44!==u&&91!==u&&93!==u&&123!==u&&125!==u&&35!==u&&38!==u&&42!==u&&33!==u&&124!==u&&61!==u&&62!==u&&39!==u&&34!==u&&37!==u&&64!==u&&96!==u&&function(e){return!tt(e)&&58!==e}(it(e,e.length-1));if(t||o)for(a=0;a<e.length;l>=65536?a+=2:a++){if(!rt(l=it(e,a)))return 5;v=v&&openapi_parser_st(l,h,c),h=l}else{for(a=0;a<e.length;l>=65536?a+=2:a++){if(10===(l=it(e,a)))f=!0,d&&(p=p||a-m-1>n&&" "!==e[m+1],m=a);else if(!rt(l))return 5;v=v&&openapi_parser_st(l,h,c),h=l}p=p||d&&a-m-1>n&&" "!==e[m+1]}return f||p?r>9&&ot(e)?5:o?2===i?5:2:p?4:3:!v||o||s(e)?2===i?5:2:1}function at(e,t,r,n,s){e.dump=function(){if(0===t.length)return 2===e.quotingType?'""':"''";if(!e.noCompatMode&&(-1!==We.indexOf(t)||Ye.test(t)))return 2===e.quotingType?'"'+t+'"':"'"+t+"'";var i=e.indent*Math.max(1,r),o=-1===e.lineWidth?-1:Math.max(Math.min(e.lineWidth,40),e.lineWidth-i),c=n||e.flowLevel>-1&&r>=e.flowLevel;switch(ct(t,c,e.indent,o,(function(t){return function(e,t){var r,n;for(r=0,n=e.implicitTypes.length;r<n;r+=1)if(e.implicitTypes[r].resolve(t))return!0;return!1}(e,t)}),e.quotingType,e.forceQuotes&&!n,s)){case 1:return t;case 2:return"'"+t.replace(/'/g,"''")+"'";case 3:return"|"+ut(t,e.indent)+openapi_parser_lt(Qe(t,i));case 4:return">"+ut(t,e.indent)+openapi_parser_lt(Qe(function(e,t){var r,n,s=/(\n+)([^\n]*)/g,i=(c=e.indexOf("\n"),c=-1!==c?c:e.length,s.lastIndex=c,ht(e.slice(0,c),t)),o="\n"===e[0]||" "===e[0];var c;for(;n=s.exec(e);){var a=n[1],u=n[2];r=" "===u[0],i+=a+(o||r||""===u?"":"\n")+ht(u,t),o=r}return i}(t,o),i));case 5:return'"'+function(e){for(var t,r="",n=0,s=0;s<e.length;n>=65536?s+=2:s++)n=it(e,s),!(t=Xe[n])&&rt(n)?(r+=e[s],n>=65536&&(r+=e[s+1])):r+=t||Ze(n);return r}(t)+'"';default:throw new openapi_parser_O("impossible error: invalid scalar style")}}()}function ut(e,t){var r=ot(e)?String(t):"",n="\n"===e[e.length-1];return r+(n&&("\n"===e[e.length-2]||"\n"===e)?"+":n?"":"-")+"\n"}function openapi_parser_lt(e){return"\n"===e[e.length-1]?e.slice(0,-1):e}function ht(e,t){if(""===e||" "===e[0])return e;for(var r,n,s=/ [^ ]/g,i=0,o=0,c=0,a="";r=s.exec(e);)(c=r.index)-i>t&&(n=o>i?o:c,a+="\n"+e.slice(i,n),i=n+1),o=c;return a+="\n",e.length-i>t&&o>i?a+=e.slice(i,o)+"\n"+e.slice(o+1):a+=e.slice(i),a.slice(1)}function ft(e,t,r,n){var s,i,o,c="",a=e.tag;for(s=0,i=r.length;s<i;s+=1)o=r[s],e.replacer&&(o=e.replacer.call(r,String(s),o)),(dt(e,t+1,o,!0,!0,!1,!0)||void 0===o&&dt(e,t+1,null,!0,!0,!1,!0))&&(n&&""===c||(c+=openapi_parser_et(e,t)),e.dump&&10===e.dump.charCodeAt(0)?c+="-":c+="- ",c+=e.dump);e.tag=a,e.dump=c||"[]"}function pt(e,t,r){var n,s,i,o,c,a;for(i=0,o=(s=r?e.explicitTypes:e.implicitTypes).length;i<o;i+=1)if(((c=s[i]).instanceOf||c.predicate)&&(!c.instanceOf||"object"==typeof t&&t instanceof c.instanceOf)&&(!c.predicate||c.predicate(t))){if(r?c.multi&&c.representName?e.tag=c.representName(t):e.tag=c.tag:e.tag="?",c.represent){if(a=e.styleMap[c.tag]||c.defaultStyle,"[object Function]"===He.call(c.represent))n=c.represent(t,a);else{if(!ze.call(c.represent,a))throw new openapi_parser_O("!<"+c.tag+'> tag resolver accepts not "'+a+'" style');n=c.represent[a](t,a)}e.dump=n}return!0}return!1}function dt(e,t,r,n,s,i,o){e.tag=null,e.dump=r,pt(e,r,!1)||pt(e,r,!0);var c,a=He.call(e.dump),u=n;n&&(n=e.flowLevel<0||e.flowLevel>t);var l,h,f="[object Object]"===a||"[object Array]"===a;if(f&&(h=-1!==(l=e.duplicates.indexOf(r))),(null!==e.tag&&"?"!==e.tag||h||2!==e.indent&&t>0)&&(s=!1),h&&e.usedDuplicates[l])e.dump="*ref_"+l;else{if(f&&h&&!e.usedDuplicates[l]&&(e.usedDuplicates[l]=!0),"[object Object]"===a)n&&0!==Object.keys(e.dump).length?(!function(e,t,r,n){var s,i,o,c,a,u,l="",h=e.tag,f=Object.keys(r);if(!0===e.sortKeys)f.sort();else if("function"==typeof e.sortKeys)f.sort(e.sortKeys);else if(e.sortKeys)throw new openapi_parser_O("sortKeys must be a boolean or a function");for(s=0,i=f.length;s<i;s+=1)u="",n&&""===l||(u+=openapi_parser_et(e,t)),c=r[o=f[s]],e.replacer&&(c=e.replacer.call(r,o,c)),dt(e,t+1,o,!0,!0,!0)&&((a=null!==e.tag&&"?"!==e.tag||e.dump&&e.dump.length>1024)&&(e.dump&&10===e.dump.charCodeAt(0)?u+="?":u+="? "),u+=e.dump,a&&(u+=openapi_parser_et(e,t)),dt(e,t+1,c,!0,a)&&(e.dump&&10===e.dump.charCodeAt(0)?u+=":":u+=": ",l+=u+=e.dump));e.tag=h,e.dump=l||"{}"}(e,t,e.dump,s),h&&(e.dump="&ref_"+l+e.dump)):(!function(e,t,r){var n,s,i,o,c,a="",u=e.tag,l=Object.keys(r);for(n=0,s=l.length;n<s;n+=1)c="",""!==a&&(c+=", "),e.condenseFlow&&(c+='"'),o=r[i=l[n]],e.replacer&&(o=e.replacer.call(r,i,o)),dt(e,t,i,!1,!1)&&(e.dump.length>1024&&(c+="? "),c+=e.dump+(e.condenseFlow?'"':"")+":"+(e.condenseFlow?"":" "),dt(e,t,o,!1,!1)&&(a+=c+=e.dump));e.tag=u,e.dump="{"+a+"}"}(e,t,e.dump),h&&(e.dump="&ref_"+l+" "+e.dump));else if("[object Array]"===a)n&&0!==e.dump.length?(e.noArrayIndent&&!o&&t>0?ft(e,t-1,e.dump,s):ft(e,t,e.dump,s),h&&(e.dump="&ref_"+l+e.dump)):(!function(e,t,r){var n,s,i,o="",c=e.tag;for(n=0,s=r.length;n<s;n+=1)i=r[n],e.replacer&&(i=e.replacer.call(r,String(n),i)),(dt(e,t,i,!1,!1)||void 0===i&&dt(e,t,null,!1,!1))&&(""!==o&&(o+=","+(e.condenseFlow?"":" ")),o+=e.dump);e.tag=c,e.dump="["+o+"]"}(e,t,e.dump),h&&(e.dump="&ref_"+l+" "+e.dump));else{if("[object String]"!==a){if("[object Undefined]"===a)return!1;if(e.skipInvalid)return!1;throw new openapi_parser_O("unacceptable kind of an object to dump "+a)}"?"!==e.tag&&at(e,e.dump,t,i,u)}null!==e.tag&&"?"!==e.tag&&(c=encodeURI("!"===e.tag[0]?e.tag.slice(1):e.tag).replace(/!/g,"%21"),c="!"===e.tag[0]?"!"+c:"tag:yaml.org,2002:"===c.slice(0,18)?"!!"+c.slice(18):"!<"+c+">",e.dump=c+" "+e.dump)}return!0}function mt(e,t){var r,n,s=[],i=[];for(vt(e,s,i),r=0,n=i.length;r<n;r+=1)t.duplicates.push(s[i[r]]);t.usedDuplicates=new Array(n)}function vt(e,t,r){var n,s,i;if(null!==e&&"object"==typeof e)if(-1!==(s=t.indexOf(e)))-1===r.indexOf(s)&&r.push(s);else if(t.push(e),Array.isArray(e))for(s=0,i=e.length;s<i;s+=1)vt(e[s],t,r);else for(s=0,i=(n=Object.keys(e)).length;s<i;s+=1)vt(e[n[s]],t,r)}function yt(e,t){return function(){throw new Error("Function yaml."+e+" is removed in js-yaml 4. Use yaml."+t+" instead, which is now safe by default.")}}var bt=openapi_parser_F,gt=openapi_parser_D,wt=openapi_parser_N,xt=openapi_parser_z,jt=X,Et=ae,$t=Ge.load,Ot=Ge.loadAll,St={dump:function(e,t){var r=new Ke(t=t||{});r.noRefs||mt(e,r);var n=e;return r.replacer&&(n=r.replacer.call({"":n},"",n)),dt(r,0,n,!0,!0)?r.dump+"\n":""}}.dump,At=openapi_parser_O,Pt={binary:ee,float:H,map:openapi_parser_M,null:openapi_parser_q,pairs:ie,set:ce,timestamp:openapi_parser_Z,bool:openapi_parser_B,int:J,merge:openapi_parser_K,omap:ne,seq:C,str:openapi_parser_},Tt=yt("safeLoad","load"),kt=yt("safeLoadAll","loadAll"),Ft=yt("safeDump","dump"),It={Type:bt,Schema:gt,FAILSAFE_SCHEMA:wt,JSON_SCHEMA:xt,CORE_SCHEMA:jt,DEFAULT_SCHEMA:Et,load:$t,loadAll:Ot,dump:St,YAMLException:At,types:Pt,safeLoad:Tt,safeLoadAll:kt,safeDump:Ft};function Rt(e={}){return"function"!=typeof e.entries?{}:Array.from(e.entries()).reduce(((e,[t,r])=>(e[t]=function(e){return e.includes(", ")?e.split(", "):e}(r),e)),{})}function Dt(e,t,{loadSpec:r=!1}={}){const n={ok:e.ok,url:e.url||t,status:e.status,statusText:e.statusText,headers:Rt(e.headers)},s=n.headers["content-type"],i=r||((e="")=>/(json|xml|yaml|text)\b/.test(e))(s);return(i?e.text:e.blob||e.buffer).call(e).then((e=>{if(n.text=e,n.data=e,i)try{const t=function(e,t){return t&&(0===t.indexOf("application/json")||t.indexOf("+json")>0)?JSON.parse(e):It.load(e)}(e,s);n.body=t,n.obj=t}catch(e){n.parseError=e}return n}))}async function _t(e,t={}){"object"==typeof e&&(e=(t=e).url),t.headers=t.headers||{},(t=openapi_parser_g(t)).headers&&Object.keys(t.headers).forEach((e=>{const r=t.headers[e];"string"==typeof r&&(t.headers[e]=r.replace(/\n+/g," "))})),t.requestInterceptor&&(t=await t.requestInterceptor(t)||t);const r=t.headers["content-type"]||t.headers["Content-Type"];let n;/multipart\/form-data/i.test(r)&&(delete t.headers["content-type"],delete t.headers["Content-Type"]);try{n=await(t.userFetch||fetch)(t.url,t),n=await Dt(n,e,t),t.responseInterceptor&&(n=await t.responseInterceptor(n)||n)}catch(e){if(!n)throw e;const t=new Error(n.statusText||`response status is ${n.status}`);throw t.status=n.status,t.statusCode=n.status,t.responseError=e,t}if(!n.ok){const e=new Error(n.statusText||`response status is ${n.status}`);throw e.status=n.status,e.statusCode=n.status,e.response=n,e}return n}function Ct(e,t={}){const{requestInterceptor:r,responseInterceptor:n}=t,s=e.withCredentials?"include":"same-origin";return t=>e({url:t,loadSpec:!0,requestInterceptor:r,responseInterceptor:n,headers:{Accept:"application/json, application/yaml"},credentials:s}).then((e=>e.body))}const Mt=e=>{var t,r;const{baseDoc:n,url:s}=e,i=null!==(t=null!=n?n:s)&&void 0!==t?t:"";return"string"==typeof(null===(r=globalThis.document)||void 0===r?void 0:r.baseURI)?String(new URL(i,globalThis.document.baseURI)):i},Nt=e=>{const{fetch:t,http:r}=e;return t||r||_t};
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017-2022 Joachim Wester
 * MIT licensed
 */
var qt,Bt=(qt=function(e,t){return qt=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var r in t)t.hasOwnProperty(r)&&(e[r]=t[r])},qt(e,t)},function(e,t){function r(){this.constructor=e}qt(e,t),e.prototype=null===t?Object.create(t):(r.prototype=t.prototype,new r)}),Lt=Object.prototype.hasOwnProperty;function Ut(e,t){return Lt.call(e,t)}function Jt(e){if(Array.isArray(e)){for(var t=new Array(e.length),r=0;r<t.length;r++)t[r]=""+r;return t}if(Object.keys)return Object.keys(e);var n=[];for(var s in e)Ut(e,s)&&n.push(s);return n}function Vt(e){switch(typeof e){case"object":return JSON.parse(JSON.stringify(e));case"undefined":return null;default:return e}}function Gt(e){for(var t,r=0,n=e.length;r<n;){if(!((t=e.charCodeAt(r))>=48&&t<=57))return!1;r++}return!0}function Ht(e){return-1===e.indexOf("/")&&-1===e.indexOf("~")?e:e.replace(/~/g,"~0").replace(/\//g,"~1")}function zt(e){return e.replace(/~1/g,"/").replace(/~0/g,"~")}function Xt(e){if(void 0===e)return!0;if(e)if(Array.isArray(e)){for(var t=0,r=e.length;t<r;t++)if(Xt(e[t]))return!0}else if("object"==typeof e)for(var n=Jt(e),s=n.length,i=0;i<s;i++)if(Xt(e[n[i]]))return!0;return!1}function Wt(e,t){var r=[e];for(var n in t){var s="object"==typeof t[n]?JSON.stringify(t[n],null,2):t[n];void 0!==s&&r.push(n+": "+s)}return r.join("\n")}var Yt=function(e){function t(t,r,n,s,i){var o=this.constructor,c=e.call(this,Wt(t,{name:r,index:n,operation:s,tree:i}))||this;return c.name=r,c.index=n,c.operation=s,c.tree=i,Object.setPrototypeOf(c,o.prototype),c.message=Wt(t,{name:r,index:n,operation:s,tree:i}),c}return Bt(t,e),t}(Error),Zt=Yt,Kt=Vt,Qt={add:function(e,t,r){return e[t]=this.value,{newDocument:r}},remove:function(e,t,r){var n=e[t];return delete e[t],{newDocument:r,removed:n}},replace:function(e,t,r){var n=e[t];return e[t]=this.value,{newDocument:r,removed:n}},move:function(e,t,r){var n=tr(r,this.path);n&&(n=Vt(n));var s=rr(r,{op:"remove",path:this.from}).removed;return rr(r,{op:"add",path:this.path,value:s}),{newDocument:r,removed:n}},copy:function(e,t,r){var n=tr(r,this.from);return rr(r,{op:"add",path:this.path,value:Vt(n)}),{newDocument:r}},test:function(e,t,r){return{newDocument:r,test:or(e[t],this.value)}},_get:function(e,t,r){return this.value=e[t],{newDocument:r}}},er={add:function(e,t,r){return Gt(t)?e.splice(t,0,this.value):e[t]=this.value,{newDocument:r,index:t}},remove:function(e,t,r){return{newDocument:r,removed:e.splice(t,1)[0]}},replace:function(e,t,r){var n=e[t];return e[t]=this.value,{newDocument:r,removed:n}},move:Qt.move,copy:Qt.copy,test:Qt.test,_get:Qt._get};function tr(e,t){if(""==t)return e;var r={op:"_get",path:t};return rr(e,r),r.value}function rr(e,t,r,n,s,i){if(void 0===r&&(r=!1),void 0===n&&(n=!0),void 0===s&&(s=!0),void 0===i&&(i=0),r&&("function"==typeof r?r(t,0,e,t.path):sr(t,0)),""===t.path){var o={newDocument:e};if("add"===t.op)return o.newDocument=t.value,o;if("replace"===t.op)return o.newDocument=t.value,o.removed=e,o;if("move"===t.op||"copy"===t.op)return o.newDocument=tr(e,t.from),"move"===t.op&&(o.removed=e),o;if("test"===t.op){if(o.test=or(e,t.value),!1===o.test)throw new Zt("Test operation failed","TEST_OPERATION_FAILED",i,t,e);return o.newDocument=e,o}if("remove"===t.op)return o.removed=e,o.newDocument=null,o;if("_get"===t.op)return t.value=e,o;if(r)throw new Zt("Operation `op` property is not one of operations defined in RFC-6902","OPERATION_OP_INVALID",i,t,e);return o}n||(e=Vt(e));var c=(t.path||"").split("/"),a=e,u=1,l=c.length,h=void 0,f=void 0,p=void 0;for(p="function"==typeof r?r:sr;;){if((f=c[u])&&-1!=f.indexOf("~")&&(f=zt(f)),s&&("__proto__"==f||"prototype"==f&&u>0&&"constructor"==c[u-1]))throw new TypeError("JSON-Patch: modifying `__proto__` or `constructor/prototype` prop is banned for security reasons, if this was on purpose, please set `banPrototypeModifications` flag false and pass it to this function. More info in fast-json-patch README");if(r&&void 0===h&&(void 0===a[f]?h=c.slice(0,u).join("/"):u==l-1&&(h=t.path),void 0!==h&&p(t,0,e,h)),u++,Array.isArray(a)){if("-"===f)f=a.length;else{if(r&&!Gt(f))throw new Zt("Expected an unsigned base-10 integer value, making the new referenced value the array element with the zero-based index","OPERATION_PATH_ILLEGAL_ARRAY_INDEX",i,t,e);Gt(f)&&(f=~~f)}if(u>=l){if(r&&"add"===t.op&&f>a.length)throw new Zt("The specified index MUST NOT be greater than the number of elements in the array","OPERATION_VALUE_OUT_OF_BOUNDS",i,t,e);if(!1===(o=er[t.op].call(t,a,f,e)).test)throw new Zt("Test operation failed","TEST_OPERATION_FAILED",i,t,e);return o}}else if(u>=l){if(!1===(o=Qt[t.op].call(t,a,f,e)).test)throw new Zt("Test operation failed","TEST_OPERATION_FAILED",i,t,e);return o}if(a=a[f],r&&u<l&&(!a||"object"!=typeof a))throw new Zt("Cannot perform operation at the desired path","OPERATION_PATH_UNRESOLVABLE",i,t,e)}}function nr(e,t,r,n,s){if(void 0===n&&(n=!0),void 0===s&&(s=!0),r&&!Array.isArray(t))throw new Zt("Patch sequence must be an array","SEQUENCE_NOT_AN_ARRAY");n||(e=Vt(e));for(var i=new Array(t.length),o=0,c=t.length;o<c;o++)i[o]=rr(e,t[o],r,!0,s,o),e=i[o].newDocument;return i.newDocument=e,i}function sr(e,t,r,n){if("object"!=typeof e||null===e||Array.isArray(e))throw new Zt("Operation is not an object","OPERATION_NOT_AN_OBJECT",t,e,r);if(!Qt[e.op])throw new Zt("Operation `op` property is not one of operations defined in RFC-6902","OPERATION_OP_INVALID",t,e,r);if("string"!=typeof e.path)throw new Zt("Operation `path` property is not a string","OPERATION_PATH_INVALID",t,e,r);if(0!==e.path.indexOf("/")&&e.path.length>0)throw new Zt('Operation `path` property must start with "/"',"OPERATION_PATH_INVALID",t,e,r);if(("move"===e.op||"copy"===e.op)&&"string"!=typeof e.from)throw new Zt("Operation `from` property is not present (applicable in `move` and `copy` operations)","OPERATION_FROM_REQUIRED",t,e,r);if(("add"===e.op||"replace"===e.op||"test"===e.op)&&void 0===e.value)throw new Zt("Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)","OPERATION_VALUE_REQUIRED",t,e,r);if(("add"===e.op||"replace"===e.op||"test"===e.op)&&Xt(e.value))throw new Zt("Operation `value` property is not present (applicable in `add`, `replace` and `test` operations)","OPERATION_VALUE_CANNOT_CONTAIN_UNDEFINED",t,e,r);if(r)if("add"==e.op){var s=e.path.split("/").length,i=n.split("/").length;if(s!==i+1&&s!==i)throw new Zt("Cannot perform an `add` operation at the desired path","OPERATION_PATH_CANNOT_ADD",t,e,r)}else if("replace"===e.op||"remove"===e.op||"_get"===e.op){if(e.path!==n)throw new Zt("Cannot perform the operation at a path that does not exist","OPERATION_PATH_UNRESOLVABLE",t,e,r)}else if("move"===e.op||"copy"===e.op){var o=ir([{op:"_get",path:e.from,value:void 0}],r);if(o&&"OPERATION_PATH_UNRESOLVABLE"===o.name)throw new Zt("Cannot perform the operation from a path that does not exist","OPERATION_FROM_UNRESOLVABLE",t,e,r)}}function ir(e,t,r){try{if(!Array.isArray(e))throw new Zt("Patch sequence must be an array","SEQUENCE_NOT_AN_ARRAY");if(t)nr(Vt(t),Vt(e),r||!0);else{r=r||sr;for(var n=0;n<e.length;n++)r(e[n],n,t,void 0)}}catch(e){if(e instanceof Zt)return e;throw e}}function or(e,t){if(e===t)return!0;if(e&&t&&"object"==typeof e&&"object"==typeof t){var r,n,s,i=Array.isArray(e),o=Array.isArray(t);if(i&&o){if((n=e.length)!=t.length)return!1;for(r=n;0!=r--;)if(!or(e[r],t[r]))return!1;return!0}if(i!=o)return!1;var c=Object.keys(e);if((n=c.length)!==Object.keys(t).length)return!1;for(r=n;0!=r--;)if(!t.hasOwnProperty(c[r]))return!1;for(r=n;0!=r--;)if(!or(e[s=c[r]],t[s]))return!1;return!0}return e!=e&&t!=t}const cr=Object.freeze(Object.defineProperty({__proto__:null,JsonPatchError:Zt,_areEquals:or,applyOperation:rr,applyPatch:nr,applyReducer:function(e,t,r){var n=rr(e,t);if(!1===n.test)throw new Zt("Test operation failed","TEST_OPERATION_FAILED",r,t,e);return n.newDocument},deepClone:Kt,getValueByPointer:tr,validate:ir,validator:sr},Symbol.toStringTag,{value:"Module"}));
/*!
 * https://github.com/Starcounter-Jack/JSON-Patch
 * (c) 2017-2021 Joachim Wester
 * MIT license
 */var ar=new WeakMap,ur=function(e){this.observers=new Map,this.obj=e},lr=function(e,t){this.callback=e,this.observer=t};function hr(e,t){void 0===t&&(t=!1);var r=ar.get(e.object);fr(r.value,e.object,e.patches,"",t),e.patches.length&&nr(r.value,e.patches);var n=e.patches;return n.length>0&&(e.patches=[],e.callback&&e.callback(n)),n}function fr(e,t,r,n,s){if(t!==e){"function"==typeof t.toJSON&&(t=t.toJSON());for(var i=Jt(t),o=Jt(e),c=!1,a=o.length-1;a>=0;a--){var u=e[h=o[a]];if(!Ut(t,h)||void 0===t[h]&&void 0!==u&&!1===Array.isArray(t))Array.isArray(e)===Array.isArray(t)?(s&&r.push({op:"test",path:n+"/"+Ht(h),value:Vt(u)}),r.push({op:"remove",path:n+"/"+Ht(h)}),c=!0):(s&&r.push({op:"test",path:n,value:e}),r.push({op:"replace",path:n,value:t}));else{var l=t[h];"object"==typeof u&&null!=u&&"object"==typeof l&&null!=l&&Array.isArray(u)===Array.isArray(l)?fr(u,l,r,n+"/"+Ht(h),s):u!==l&&(s&&r.push({op:"test",path:n+"/"+Ht(h),value:Vt(u)}),r.push({op:"replace",path:n+"/"+Ht(h),value:Vt(l)}))}}if(c||i.length!=o.length)for(a=0;a<i.length;a++){var h;Ut(e,h=i[a])||void 0===t[h]||r.push({op:"add",path:n+"/"+Ht(h),value:Vt(t[h])})}}}const pr=Object.freeze(Object.defineProperty({__proto__:null,compare:function(e,t,r){void 0===r&&(r=!1);var n=[];return fr(e,t,n,"",r),n},generate:hr,observe:function(e,t){var r,n=function(e){return ar.get(e)}(e);if(n){var s=function(e,t){return e.observers.get(t)}(n,t);r=s&&s.observer}else n=new ur(e),ar.set(e,n);if(r)return r;if(r={},n.value=Vt(e),t){r.callback=t,r.next=null;var i=function(){hr(r)},o=function(){clearTimeout(r.next),r.next=setTimeout(i)};"undefined"!=typeof window&&(window.addEventListener("mouseup",o),window.addEventListener("keyup",o),window.addEventListener("mousedown",o),window.addEventListener("keydown",o),window.addEventListener("change",o))}return r.patches=[],r.object=e,r.unobserve=function(){hr(r),clearTimeout(r.next),function(e,t){e.observers.delete(t.callback)}(n,r),"undefined"!=typeof window&&(window.removeEventListener("mouseup",o),window.removeEventListener("keyup",o),window.removeEventListener("mousedown",o),window.removeEventListener("keydown",o),window.removeEventListener("change",o))},n.observers.set(t,new lr(t,r)),r},unobserve:function(e,t){t.unobserve()}},Symbol.toStringTag,{value:"Module"}));function dr(e){return e&&e.t&&Object.prototype.hasOwnProperty.call(e,"default")?e.default:e}Object.assign({},cr,pr,{JsonPatchError:Yt,deepClone:Vt,escapePathComponent:Ht,unescapePathComponent:zt});var mr=function(e){return function(e){return!!e&&"object"==typeof e}(e)&&!function(e){var t=Object.prototype.toString.call(e);return"[object RegExp]"===t||"[object Date]"===t||function(e){return e.$$typeof===vr}(e)}(e)};var vr="function"==typeof Symbol&&Symbol.for?Symbol.for("react.element"):60103;function yr(e,t){return!1!==t.clone&&t.isMergeableObject(e)?jr((r=e,Array.isArray(r)?[]:{}),e,t):e;var r}function br(e,t,r){return e.concat(t).map((function(e){return yr(e,r)}))}function gr(e){return Object.keys(e).concat(function(e){return Object.getOwnPropertySymbols?Object.getOwnPropertySymbols(e).filter((function(t){return Object.propertyIsEnumerable.call(e,t)})):[]}(e))}function wr(e,t){try{return t in e}catch(e){return!1}}function xr(e,t,r){var n={};return r.isMergeableObject(e)&&gr(e).forEach((function(t){n[t]=yr(e[t],r)})),gr(t).forEach((function(s){(function(e,t){return wr(e,t)&&!(Object.hasOwnProperty.call(e,t)&&Object.propertyIsEnumerable.call(e,t))})(e,s)||(wr(e,s)&&r.isMergeableObject(t[s])?n[s]=function(e,t){if(!t.customMerge)return jr;var r=t.customMerge(e);return"function"==typeof r?r:jr}(s,r)(e[s],t[s],r):n[s]=yr(t[s],r))})),n}function jr(e,t,r){(r=r||{}).arrayMerge=r.arrayMerge||br,r.isMergeableObject=r.isMergeableObject||mr,r.cloneUnlessOtherwiseSpecified=yr;var n=Array.isArray(t);return n===Array.isArray(e)?n?r.arrayMerge(e,t,r):xr(e,t,r):yr(t,r)}jr.all=function(e,t){if(!Array.isArray(e))throw new Error("first argument should be an array");return e.reduce((function(e,r){return jr(e,r,t)}),{})};const Er=dr(jr),$r={add:function(e,t){return{op:"add",path:e,value:t}},replace:Sr,remove:function(e){return{op:"remove",path:e}},merge:function(e,t){return{type:"mutation",op:"merge",path:e,value:t}},mergeDeep:function(e,t){return{type:"mutation",op:"mergeDeep",path:e,value:t}},context:function(e,t){return{type:"context",path:e,value:t}},getIn:function(e,t){return t.reduce(((e,t)=>void 0!==t&&e?e[t]:e),e)},applyPatch:function(e,t,r){if(r=r||{},"merge"===(t={...t,path:t.path&&Or(t.path)}).op){const r=qr(e,t.path);Object.assign(r,t.value),nr(e,[Sr(t.path,r)])}else if("mergeDeep"===t.op){const r=qr(e,t.path),n=Er(r,t.value);e=nr(e,[Sr(t.path,n)]).newDocument}else if("add"===t.op&&""===t.path&&Rr(t.value)){const r=Object.keys(t.value).reduce(((e,r)=>(e.push({op:"add",path:`/${Or(r)}`,value:t.value[r]}),e)),[]);nr(e,r)}else if("replace"===t.op&&""===t.path){let{value:n}=t;r.allowMetaPatches&&t.meta&&Mr(t)&&(Array.isArray(t.value)||Rr(t.value))&&(n={...n,...t.meta}),e=n}else if(nr(e,[t]),r.allowMetaPatches&&t.meta&&Mr(t)&&(Array.isArray(t.value)||Rr(t.value))){const r={...qr(e,t.path),...t.meta};nr(e,[Sr(t.path,r)])}return e},parentPathMatch:function(e,t){if(!Array.isArray(t))return!1;for(let r=0,n=t.length;r<n;r+=1)if(t[r]!==e[r])return!1;return!0},flatten:Fr,fullyNormalizeArray:function(e){return Ir(Fr(kr(e)))},normalizeArray:kr,isPromise:function(e){return Rr(e)&&Dr(e.then)},forEachNew:function(e,t){try{return Ar(e,Tr,t)}catch(e){return e}},forEachNewPrimitive:function(e,t){try{return Ar(e,Pr,t)}catch(e){return e}},isJsonPatch:_r,isContextPatch:function(e){return Nr(e)&&"context"===e.type},isPatch:Nr,isMutation:Cr,isAdditiveMutation:Mr,isGenerator:function(e){return"[object GeneratorFunction]"===Object.prototype.toString.call(e)},isFunction:Dr,isObject:Rr,isError:function(e){return e instanceof Error}};function Or(e){return Array.isArray(e)?e.length<1?"":`/${e.map((e=>(e+"").replace(/~/g,"~0").replace(/\//g,"~1"))).join("/")}`:e}function Sr(e,t,r){return{op:"replace",path:e,value:t,meta:r}}function Ar(e,t,r){return Ir(Fr(e.filter(Mr).map((e=>t(e.value,r,e.path)))||[]))}function Pr(e,t,r){return r=r||[],Array.isArray(e)?e.map(((e,n)=>Pr(e,t,r.concat(n)))):Rr(e)?Object.keys(e).map((n=>Pr(e[n],t,r.concat(n)))):t(e,r[r.length-1],r)}function Tr(e,t,r){let n=[];if((r=r||[]).length>0){const s=t(e,r[r.length-1],r);s&&(n=n.concat(s))}if(Array.isArray(e)){const s=e.map(((e,n)=>Tr(e,t,r.concat(n))));s&&(n=n.concat(s))}else if(Rr(e)){const s=Object.keys(e).map((n=>Tr(e[n],t,r.concat(n))));s&&(n=n.concat(s))}return n=Fr(n),n}function kr(e){return Array.isArray(e)?e:[e]}function Fr(e){return[].concat(...e.map((e=>Array.isArray(e)?Fr(e):e)))}function Ir(e){return e.filter((e=>void 0!==e))}function Rr(e){return e&&"object"==typeof e}function Dr(e){return e&&"function"==typeof e}function _r(e){if(Nr(e)){const{op:t}=e;return"add"===t||"remove"===t||"replace"===t}return!1}function Cr(e){return _r(e)||Nr(e)&&"mutation"===e.type}function Mr(e){return Cr(e)&&("add"===e.op||"replace"===e.op||"merge"===e.op||"mergeDeep"===e.op)}function Nr(e){return e&&"object"==typeof e}function qr(e,t){try{return tr(e,t)}catch(e){return console.error(e),{}}}var Br=function(e){return e&&e.Math===Math&&e},Lr=Br("object"==typeof globalThis&&globalThis)||Br("object"==typeof window&&window)||Br("object"==typeof self&&self)||Br("object"==typeof global&&global)||Br(!1)||function(){return this}()||Function("return this")(),Ur=function(e){try{return!!e()}catch(e){return!0}},Jr=!Ur((function(){var e=function(){}.bind();return"function"!=typeof e||e.hasOwnProperty("prototype")})),Vr=Jr,Gr=Function.prototype,Hr=Gr.apply,zr=Gr.call,Xr="object"==typeof Reflect&&Reflect.apply||(Vr?zr.bind(Hr):function(){return zr.apply(Hr,arguments)}),Wr=Jr,Yr=Function.prototype,Zr=Yr.call,Kr=Wr&&Yr.bind.bind(Zr,Zr),Qr=Wr?Kr:function(e){return function(){return Zr.apply(e,arguments)}},en=Qr,tn=en({}.toString),rn=en("".slice),nn=function(e){return rn(tn(e),8,-1)},sn=nn,on=Qr,cn=function(e){if("Function"===sn(e))return on(e)},an="object"==typeof document&&document.all,un=void 0===an&&void 0!==an?function(e){return"function"==typeof e||e===an}:function(e){return"function"==typeof e},ln={},hn=!Ur((function(){return 7!==Object.defineProperty({},1,{get:function(){return 7}})[1]})),fn=Jr,pn=Function.prototype.call,dn=fn?pn.bind(pn):function(){return pn.apply(pn,arguments)},mn={},vn={}.propertyIsEnumerable,yn=Object.getOwnPropertyDescriptor,bn=yn&&!vn.call({1:2},1);mn.f=bn?function(e){var t=yn(this,e);return!!t&&t.enumerable}:vn;var gn,wn,xn=function(e,t){return{enumerable:!(1&e),configurable:!(2&e),writable:!(4&e),value:t}},jn=Ur,En=nn,$n=Object,On=Qr("".split),Sn=jn((function(){return!$n("z").propertyIsEnumerable(0)}))?function(e){return"String"===En(e)?On(e,""):$n(e)}:$n,An=function(e){return null==e},Pn=An,Tn=TypeError,kn=function(e){if(Pn(e))throw new Tn("Can't call method on "+e);return e},Fn=Sn,In=kn,Rn=function(e){return Fn(In(e))},Dn=un,_n=function(e){return"object"==typeof e?null!==e:Dn(e)},Cn={},Mn=Cn,Nn=Lr,qn=un,Bn=function(e){return qn(e)?e:void 0},Ln=function(e,t){return arguments.length<2?Bn(Mn[e])||Bn(Nn[e]):Mn[e]&&Mn[e][t]||Nn[e]&&Nn[e][t]},Un=Qr({}.isPrototypeOf),Jn=Lr.navigator,Vn=Jn&&Jn.userAgent,Gn=Lr,Hn=Vn?String(Vn):"",zn=Gn.process,Xn=Gn.Deno,Wn=zn&&zn.versions||Xn&&Xn.version,Yn=Wn&&Wn.v8;Yn&&(wn=(gn=Yn.split("."))[0]>0&&gn[0]<4?1:+(gn[0]+gn[1])),!wn&&Hn&&(!(gn=Hn.match(/Edge\/(\d+)/))||gn[1]>=74)&&(gn=Hn.match(/Chrome\/(\d+)/))&&(wn=+gn[1]);var Zn=wn,Kn=Ur,Qn=Lr.String,es=!!Object.getOwnPropertySymbols&&!Kn((function(){var e=Symbol("symbol detection");return!Qn(e)||!(Object(e)instanceof Symbol)||!Symbol.sham&&Zn&&Zn<41})),ts=es&&!Symbol.sham&&"symbol"==typeof Symbol.iterator,rs=Ln,ns=un,ss=Un,is=Object,os=ts?function(e){return"symbol"==typeof e}:function(e){var t=rs("Symbol");return ns(t)&&ss(t.prototype,is(e))},cs=String,as=function(e){try{return cs(e)}catch(e){return"Object"}},us=un,ls=as,hs=TypeError,fs=function(e){if(us(e))return e;throw new hs(ls(e)+" is not a function")},ps=fs,ds=An,ms=function(e,t){var r=e[t];return ds(r)?void 0:ps(r)},vs=dn,ys=un,bs=_n,gs=TypeError,ws={exports:{}},xs=Lr,js=Object.defineProperty,Es=Lr,$s=function(e,t){try{js(xs,e,{value:t,configurable:!0,writable:!0})}catch(r){xs[e]=t}return t},Os=ws.exports=Es["o"]||$s("__core-js_shared__",{});(Os.versions||(Os.versions=[])).push({version:"3.38.1",mode:"pure",copyright:"© 2014-2024 Denis Pushkarev (zloirock.ru)",license:"https://github.com/zloirock/core-js/blob/v3.38.1/LICENSE",source:"https://github.com/zloirock/core-js"});var Ss=ws.exports,As=Ss,Ps=function(e,t){return As[e]||(As[e]=t||{})},Ts=kn,ks=Object,Fs=function(e){return ks(Ts(e))},Is=Fs,Rs=Qr({}.hasOwnProperty),Ds=Object.hasOwn||function(e,t){return Rs(Is(e),t)},_s=Qr,Cs=0,Ms=Math.random(),Ns=_s(1..toString),qs=function(e){return"Symbol("+(void 0===e?"":e)+")_"+Ns(++Cs+Ms,36)},Bs=Ps,Ls=Ds,Us=qs,Js=es,Vs=ts,Gs=Lr.Symbol,Hs=Bs("wks"),zs=Vs?Gs.for||Gs:Gs&&Gs.withoutSetter||Us,Xs=function(e){return Ls(Hs,e)||(Hs[e]=Js&&Ls(Gs,e)?Gs[e]:zs("Symbol."+e)),Hs[e]},Ws=dn,Ys=_n,Zs=os,Ks=ms,Qs=function(e,t){var r,n;if("string"===t&&ys(r=e.toString)&&!bs(n=vs(r,e)))return n;if(ys(r=e.valueOf)&&!bs(n=vs(r,e)))return n;if("string"!==t&&ys(r=e.toString)&&!bs(n=vs(r,e)))return n;throw new gs("Can't convert object to primitive value")},ei=TypeError,ti=Xs("toPrimitive"),ri=function(e,t){if(!Ys(e)||Zs(e))return e;var r,n=Ks(e,ti);if(n){if(void 0===t&&(t="default"),r=Ws(n,e,t),!Ys(r)||Zs(r))return r;throw new ei("Can't convert object to primitive value")}return void 0===t&&(t="number"),Qs(e,t)},ni=os,openapi_parser_si=function(e){var t=ri(e,"string");return ni(t)?t:t+""},ii=_n,oi=Lr.document,ci=ii(oi)&&ii(oi.createElement),ai=function(e){return ci?oi.createElement(e):{}},ui=ai,li=!hn&&!Ur((function(){return 7!==Object.defineProperty(ui("div"),"a",{get:function(){return 7}}).a})),hi=hn,fi=dn,pi=mn,di=xn,mi=Rn,vi=openapi_parser_si,yi=Ds,bi=li,gi=Object.getOwnPropertyDescriptor;ln.f=hi?gi:function(e,t){if(e=mi(e),t=vi(t),bi)try{return gi(e,t)}catch(e){}if(yi(e,t))return di(!fi(pi.f,e,t),e[t])};var wi=Ur,xi=un,ji=/#|\.prototype\./,Ei=function(e,t){var r=Oi[$i(e)];return r===Ai||r!==Si&&(xi(t)?wi(t):!!t)},$i=Ei.normalize=function(e){return String(e).replace(ji,".").toLowerCase()},Oi=Ei.data={},Si=Ei.NATIVE="N",Ai=Ei.POLYFILL="P",Pi=Ei,Ti=fs,ki=Jr,Fi=cn(cn.bind),Ii=function(e,t){return Ti(e),void 0===t?e:ki?Fi(e,t):function(){return e.apply(t,arguments)}},Ri={},Di=hn&&Ur((function(){return 42!==Object.defineProperty((function(){}),"prototype",{value:42,writable:!1}).prototype})),_i=_n,Ci=String,Mi=TypeError,Ni=function(e){if(_i(e))return e;throw new Mi(Ci(e)+" is not an object")},qi=hn,Bi=li,Li=Di,Ui=Ni,Ji=openapi_parser_si,Vi=TypeError,Gi=Object.defineProperty,Hi=Object.getOwnPropertyDescriptor;Ri.f=qi?Li?function(e,t,r){if(Ui(e),t=Ji(t),Ui(r),"function"==typeof e&&"prototype"===t&&"value"in r&&"writable"in r&&!r.writable){var n=Hi(e,t);n&&n.writable&&(e[t]=r.value,r={configurable:"configurable"in r?r.configurable:n.configurable,enumerable:"enumerable"in r?r.enumerable:n.enumerable,writable:!1})}return Gi(e,t,r)}:Gi:function(e,t,r){if(Ui(e),t=Ji(t),Ui(r),Bi)try{return Gi(e,t,r)}catch(e){}if("get"in r||"set"in r)throw new Vi("Accessors not supported");return"value"in r&&(e[t]=r.value),e};var zi=Ri,Xi=xn,Wi=hn?function(e,t,r){return zi.f(e,t,Xi(1,r))}:function(e,t,r){return e[t]=r,e},Yi=Lr,Zi=Xr,Ki=cn,Qi=un,eo=ln.f,to=Pi,ro=Cn,no=Ii,so=Wi,io=Ds,oo=function(e){var t=function(r,n,s){if(this instanceof t){switch(arguments.length){case 0:return new e;case 1:return new e(r);case 2:return new e(r,n)}return new e(r,n,s)}return Zi(e,this,arguments)};return t.prototype=e.prototype,t},co=function(e,t){var r,n,s,i,o,c,a,u,l,h=e.target,f=e.global,p=e.stat,d=e.proto,m=f?Yi:p?Yi[h]:Yi[h]&&Yi[h].prototype,v=f?ro:ro[h]||so(ro,h,{})[h],y=v.prototype;for(i in t)n=!(r=to(f?i:h+(p?".":"#")+i,e.forced))&&m&&io(m,i),c=v[i],n&&(a=e.dontCallGetSet?(l=eo(m,i))&&l.value:m[i]),o=n&&a?a:t[i],(r||d||typeof c!=typeof o)&&(u=e.bind&&n?no(o,Yi):e.wrap&&n?oo(o):d&&Qi(o)?Ki(o):o,(e.sham||o&&o.sham||c&&c.sham)&&so(u,"sham",!0),so(v,i,u),d&&(io(ro,s=h+"Prototype")||so(ro,s,{}),so(ro[s],i,o),e.real&&y&&(r||!y[i])&&so(y,i,o)))},ao=qs,uo=Ps("keys"),lo=function(e){return uo[e]||(uo[e]=ao(e))},ho=!Ur((function(){function e(){}return e.prototype.constructor=null,Object.getPrototypeOf(new e)!==e.prototype})),fo=Ds,po=un,mo=Fs,vo=ho,yo=lo("IE_PROTO"),bo=Object,go=bo.prototype,wo=vo?bo.getPrototypeOf:function(e){var t=mo(e);if(fo(t,yo))return t[yo];var r=t.constructor;return po(r)&&t instanceof r?r.prototype:t instanceof bo?go:null},xo=Qr,jo=fs,Eo=_n,$o=function(e){return Eo(e)||null===e},Oo=String,So=TypeError,Ao=function(e,t,r){try{return xo(jo(Object.getOwnPropertyDescriptor(e,t)[r]))}catch(e){}},Po=_n,To=kn,ko=function(e){if($o(e))return e;throw new So("Can't set "+Oo(e)+" as a prototype")},Fo=Object.setPrototypeOf||("__proto__"in{}?function(){var e,t=!1,r={};try{(e=Ao(Object.prototype,"__proto__","set"))(r,[]),t=r instanceof Array}catch(e){}return function(r,n){return To(r),ko(n),Po(r)?(t?e(r,n):r.__proto__=n,r):r}}():void 0),Io={},Ro=Math.ceil,Do=Math.floor,_o=Math.trunc||function(e){var t=+e;return(t>0?Do:Ro)(t)},Co=function(e){var t=+e;return t!=t||0===t?0:_o(t)},Mo=Co,No=Math.max,qo=Math.min,Bo=Co,Lo=Math.min,Uo=function(e){var t=Bo(e);return t>0?Lo(t,9007199254740991):0},Jo=function(e){return Uo(e.length)},Vo=Rn,Go=function(e,t){var r=Mo(e);return r<0?No(r+t,0):qo(r,t)},Ho=Jo,zo=function(e){return function(t,r,n){var s=Vo(t),i=Ho(s);if(0===i)return!e&&-1;var o,c=Go(n,i);if(e&&r!=r){for(;i>c;)if((o=s[c++])!=o)return!0}else for(;i>c;c++)if((e||c in s)&&s[c]===r)return e||c||0;return!e&&-1}},Xo={includes:zo(!0),indexOf:zo(!1)},Wo={},Yo=Ds,Zo=Rn,Ko=Xo.indexOf,Qo=Wo,ec=Qr([].push),tc=function(e,t){var r,n=Zo(e),s=0,i=[];for(r in n)!Yo(Qo,r)&&Yo(n,r)&&ec(i,r);for(;t.length>s;)Yo(n,r=t[s++])&&(~Ko(i,r)||ec(i,r));return i},rc=["constructor","hasOwnProperty","isPrototypeOf","propertyIsEnumerable","toLocaleString","toString","valueOf"],nc=tc,sc=rc.concat("length","prototype");Io.f=Object.getOwnPropertyNames||function(e){return nc(e,sc)};var ic={};ic.f=Object.getOwnPropertySymbols;var oc=Ln,cc=Io,ac=ic,uc=Ni,lc=Qr([].concat),hc=oc("Reflect","ownKeys")||function(e){var t=cc.f(uc(e)),r=ac.f;return r?lc(t,r(e)):t},fc=Ds,pc=hc,dc=ln,mc=Ri,vc=function(e,t,r){for(var n=pc(t),s=mc.f,i=dc.f,o=0;o<n.length;o++){var c=n[o];fc(e,c)||r&&fc(r,c)||s(e,c,i(t,c))}},yc={},bc=tc,gc=rc,wc=Object.keys||function(e){return bc(e,gc)},xc=hn,jc=Di,Ec=Ri,$c=Ni,Oc=Rn,Sc=wc;yc.f=xc&&!jc?Object.defineProperties:function(e,t){$c(e);for(var r,n=Oc(t),s=Sc(t),i=s.length,o=0;i>o;)Ec.f(e,r=s[o++],n[r]);return e};var Ac,Pc=Ln("document","documentElement"),Tc=Ni,kc=yc,Fc=rc,Ic=Wo,Rc=Pc,Dc=ai,_c=lo("IE_PROTO"),Cc=function(){},Mc=function(e){return"<script>"+e+"<\/script>"},Nc=function(e){e.write(Mc("")),e.close();var t=e.parentWindow.Object;return e=null,t},qc=function(){try{Ac=new ActiveXObject("htmlfile")}catch(e){}var e,t;qc="undefined"!=typeof document?document.domain&&Ac?Nc(Ac):((t=Dc("iframe")).style.display="none",Rc.appendChild(t),t.src=String("javascript:"),(e=t.contentWindow.document).open(),e.write(Mc("document.F=Object")),e.close(),e.F):Nc(Ac);for(var r=Fc.length;r--;)delete qc.prototype[Fc[r]];return qc()};Ic[_c]=!0;var Bc=Object.create||function(e,t){var r;return null!==e?(Cc.prototype=Tc(e),r=new Cc,Cc.prototype=null,r[_c]=e):r=qc(),void 0===t?r:kc.f(r,t)},Lc=_n,Uc=Wi,Jc=function(e,t){Lc(t)&&"cause"in t&&Uc(e,"cause",t.cause)},Vc=Error,Gc=Qr("".replace),Hc=String(new Vc("zxcasd").stack),zc=/\n\s*at [^:]*:[^\n]*/,Xc=zc.test(Hc),Wc=xn,Yc=!Ur((function(){var e=new Error("a");return!("stack"in e)||(Object.defineProperty(e,"stack",Wc(1,7)),7!==e.stack)})),Zc=Wi,Kc=function(e,t){if(Xc&&"string"==typeof e&&!Vc.prepareStackTrace)for(;t--;)e=Gc(e,zc,"");return e},Qc=Yc,ea=Error.captureStackTrace,ta=function(e,t,r,n){Qc&&(ea?ea(e,t):Zc(e,"stack",Kc(r,n)))},ra={},na=ra,sa=Xs("iterator"),ia=Array.prototype,oa={};oa[Xs("toStringTag")]="z";var ca="[object z]"===String(oa),aa=ca,ua=un,la=nn,ha=Xs("toStringTag"),fa=Object,pa="Arguments"===la(function(){return arguments}()),da=aa?la:function(e){var t,r,n;return void 0===e?"Undefined":null===e?"Null":"string"==typeof(r=function(e,t){try{return e[t]}catch(e){}}(t=fa(e),ha))?r:pa?la(t):"Object"===(n=la(t))&&ua(t.callee)?"Arguments":n},ma=da,va=ms,ya=An,ba=ra,ga=Xs("iterator"),wa=function(e){if(!ya(e))return va(e,ga)||va(e,"@@iterator")||ba[ma(e)]},xa=dn,ja=fs,Ea=Ni,$a=as,Oa=wa,Sa=TypeError,Aa=dn,Pa=Ni,Ta=ms,ka=Ii,Fa=dn,Ia=Ni,Ra=as,Da=function(e){return void 0!==e&&(na.Array===e||ia[sa]===e)},_a=Jo,Ca=Un,Ma=function(e,t){var r=arguments.length<2?Oa(e):t;if(ja(r))return Ea(xa(r,e));throw new Sa($a(e)+" is not iterable")},Na=wa,qa=function(e,t,r){var n,s;Pa(e);try{if(!(n=Ta(e,"return"))){if("throw"===t)throw r;return r}n=Aa(n,e)}catch(e){s=!0,n=e}if("throw"===t)throw r;if(s)throw n;return Pa(n),r},Ba=TypeError,La=function(e,t){this.stopped=e,this.result=t},Ua=La.prototype,Ja=da,Va=String,Ga=function(e){if("Symbol"===Ja(e))throw new TypeError("Cannot convert a Symbol value to a string");return Va(e)},Ha=Ga,za=function(e,t){return void 0===e?arguments.length<2?"":t:Ha(e)},Xa=co,Wa=Un,Ya=wo,Za=Fo,Ka=vc,Qa=Bc,eu=Wi,tu=xn,ru=Jc,nu=ta,su=function(e,t,r){var n,s,i,o,c,a,u,l=r&&r.that,h=!(!r||!r.AS_ENTRIES),f=!(!r||!r.IS_RECORD),p=!(!r||!r.IS_ITERATOR),d=!(!r||!r.INTERRUPTED),m=ka(t,l),v=function(e){return n&&qa(n,"normal",e),new La(!0,e)},y=function(e){return h?(Ia(e),d?m(e[0],e[1],v):m(e[0],e[1])):d?m(e,v):m(e)};if(f)n=e.iterator;else if(p)n=e;else{if(!(s=Na(e)))throw new Ba(Ra(e)+" is not iterable");if(Da(s)){for(i=0,o=_a(e);o>i;i++)if((c=y(e[i]))&&Ca(Ua,c))return c;return new La(!1)}n=Ma(e,s)}for(a=f?e.next:n.next;!(u=Fa(a,n)).done;){try{c=y(u.value)}catch(e){qa(n,"throw",e)}if("object"==typeof c&&c&&Ca(Ua,c))return c}return new La(!1)},iu=za,ou=Xs("toStringTag"),cu=Error,au=[].push,uu=function(e,t){var r,n=Wa(lu,this);Za?r=Za(new cu,n?Ya(this):lu):(r=n?this:Qa(lu),eu(r,ou,"Error")),void 0!==t&&eu(r,"message",iu(t)),nu(r,uu,r.stack,1),arguments.length>2&&ru(r,arguments[2]);var s=[];return su(e,au,{that:s}),eu(r,"errors",s),r};Za?Za(uu,cu):Ka(uu,cu,{name:!0});var lu=uu.prototype=Qa(cu.prototype,{constructor:tu(1,uu),message:tu(1,""),name:tu(1,"AggregateError")});Xa({global:!0,constructor:!0,arity:2},{AggregateError:uu});var hu=Ri.f,fu=un,pu=_n,du=Fo,mu=Ln,vu=Wi,yu=Un,bu=Fo,gu=vc,wu=function(e,t,r){r in e||hu(e,r,{configurable:!0,get:function(){return t[r]},set:function(e){t[r]=e}})},xu=function(e,t,r){var n,s;return du&&fu(n=t.constructor)&&n!==r&&pu(s=n.prototype)&&s!==r.prototype&&du(e,s),e},ju=za,Eu=Jc,$u=ta,Ou=hn,Su=function(e,t,r,n){var s="stackTraceLimit",i=n?2:1,o=e.split("."),c=o[o.length-1],a=mu.apply(null,o);if(a){var u=a.prototype;if(!r)return a;var l=mu("Error"),h=t((function(e,t){var r=ju(n?t:e,void 0),s=n?new a(e):new a;return void 0!==r&&vu(s,"message",r),$u(s,h,s.stack,2),this&&yu(u,this)&&xu(s,this,h),arguments.length>i&&Eu(s,arguments[i]),s}));return h.prototype=u,"Error"!==c?bu?bu(h,l):gu(h,l,{name:!0}):Ou&&s in a&&(wu(h,a,s),wu(h,a,"prepareStackTrace")),gu(h,a),h}},Au=co,Pu=Xr,Tu=Su,ku=Lr.WebAssembly,Fu=7!==new Error("e",{cause:7}).cause,Iu=function(e,t){var r={};r[e]=Tu(e,t,Fu),Au({global:!0,constructor:!0,arity:1,forced:Fu},r)},Ru=function(e,t){if(ku&&ku[e]){var r={};r[e]=Tu("WebAssembly."+e,t,Fu),Au({target:"WebAssembly",stat:!0,constructor:!0,arity:1,forced:Fu},r)}};Iu("Error",(function(e){return function(t){return Pu(e,this,arguments)}})),Iu("EvalError",(function(e){return function(t){return Pu(e,this,arguments)}})),Iu("RangeError",(function(e){return function(t){return Pu(e,this,arguments)}})),Iu("ReferenceError",(function(e){return function(t){return Pu(e,this,arguments)}})),Iu("SyntaxError",(function(e){return function(t){return Pu(e,this,arguments)}})),Iu("TypeError",(function(e){return function(t){return Pu(e,this,arguments)}})),Iu("URIError",(function(e){return function(t){return Pu(e,this,arguments)}})),Ru("CompileError",(function(e){return function(t){return Pu(e,this,arguments)}})),Ru("LinkError",(function(e){return function(t){return Pu(e,this,arguments)}})),Ru("RuntimeError",(function(e){return function(t){return Pu(e,this,arguments)}}));var Du=co,_u=Xr,Cu=Ur,Mu=Su,Nu=Ln("AggregateError"),qu=!Cu((function(){return 1!==Nu([1]).errors[0]}))&&Cu((function(){return 7!==Nu([1],"AggregateError",{cause:7}).cause}));Du({global:!0,constructor:!0,arity:2,forced:qu},{AggregateError:Mu("AggregateError",(function(e){return function(t,r){return _u(e,this,arguments)}}),qu,!0)});var Bu,Lu,Uu,Ju=un,Vu=Lr.WeakMap,Gu=Ju(Vu)&&/native code/.test(String(Vu)),Hu=Lr,zu=_n,Xu=Wi,Wu=Ds,Yu=Ss,Zu=lo,Ku=Wo,Qu=Hu.TypeError,el=Hu.WeakMap;if(Gu||Yu.state){var tl=Yu.state||(Yu.state=new el);tl.get=tl.get,tl.has=tl.has,tl.set=tl.set,Bu=function(e,t){if(tl.has(e))throw new Qu("Object already initialized");return t.facade=e,tl.set(e,t),t},Lu=function(e){return tl.get(e)||{}},Uu=function(e){return tl.has(e)}}else{var rl=Zu("state");Ku[rl]=!0,Bu=function(e,t){if(Wu(e,rl))throw new Qu("Object already initialized");return t.facade=e,Xu(e,rl,t),t},Lu=function(e){return Wu(e,rl)?e[rl]:{}},Uu=function(e){return Wu(e,rl)}}var nl,sl,il,ol={set:Bu,get:Lu,has:Uu,enforce:function(e){return Uu(e)?Lu(e):Bu(e,{})},getterFor:function(e){return function(t){var r;if(!zu(t)||(r=Lu(t)).type!==e)throw new Qu("Incompatible receiver, "+e+" required");return r}}},cl=hn,al=Ds,ul=Function.prototype,ll=cl&&Object.getOwnPropertyDescriptor,hl=al(ul,"name"),fl={EXISTS:hl,PROPER:hl&&"something"===function(){}.name,CONFIGURABLE:hl&&(!cl||cl&&ll(ul,"name").configurable)},pl=Wi,dl=function(e,t,r,n){return n&&n.enumerable?e[t]=r:pl(e,t,r),e},ml=Ur,vl=un,yl=_n,bl=Bc,gl=wo,wl=dl,xl=Xs("iterator"),jl=!1;[].keys&&("next"in(il=[].keys())?(sl=gl(gl(il)))!==Object.prototype&&(nl=sl):jl=!0);var El=!yl(nl)||ml((function(){var e={};return nl[xl].call(e)!==e}));vl((nl=El?{}:bl(nl))[xl])||wl(nl,xl,(function(){return this}));var $l={IteratorPrototype:nl,BUGGY_SAFARI_ITERATORS:jl},Ol=da,Sl=ca?{}.toString:function(){return"[object "+Ol(this)+"]"},Al=ca,Pl=Ri.f,Tl=Wi,kl=Ds,Fl=Sl,Il=Xs("toStringTag"),Rl=function(e,t,r,n){var s=r?e:e&&e.prototype;s&&(kl(s,Il)||Pl(s,Il,{configurable:!0,value:t}),n&&!Al&&Tl(s,"toString",Fl))},Dl=$l.IteratorPrototype,_l=Bc,Cl=xn,Ml=Rl,Nl=ra,ql=function(){return this},Bl=co,Ll=dn,Ul=fl,Jl=function(e,t,r,n){var s=t+" Iterator";return e.prototype=_l(Dl,{next:Cl(+!n,r)}),Ml(e,s,!1,!0),Nl[s]=ql,e},Vl=wo,Gl=Rl,Hl=dl,zl=ra,Xl=$l,Wl=Ul.PROPER,Yl=Xl.BUGGY_SAFARI_ITERATORS,Zl=Xs("iterator"),Kl=function(){return this},Ql=function(e,t,r,n,s,i,o){Jl(r,t,n);var c,a,u,l=function(e){if(e===s&&m)return m;if(!Yl&&e&&e in p)return p[e];switch(e){case"keys":case"values":case"entries":return function(){return new r(this,e)}}return function(){return new r(this)}},h=t+" Iterator",f=!1,p=e.prototype,d=p[Zl]||p["@@iterator"]||s&&p[s],m=!Yl&&d||l(s),v="Array"===t&&p.entries||d;if(v&&(c=Vl(v.call(new e)))!==Object.prototype&&c.next&&(Gl(c,h,!0,!0),zl[h]=Kl),Wl&&"values"===s&&d&&"values"!==d.name&&(f=!0,m=function(){return Ll(d,this)}),s)if(a={values:l("values"),keys:i?m:l("keys"),entries:l("entries")},o)for(u in a)(Yl||f||!(u in p))&&Hl(p,u,a[u]);else Bl({target:t,proto:!0,forced:Yl||f},a);return o&&p[Zl]!==m&&Hl(p,Zl,m,{name:s}),zl[t]=m,a},eh=function(e,t){return{value:e,done:t}},th=Rn,rh=ra,nh=ol;Ri.f;var sh=Ql,ih=eh,oh=nh.set,ch=nh.getterFor("Array Iterator");sh(Array,"Array",(function(e,t){oh(this,{type:"Array Iterator",target:th(e),index:0,kind:t})}),(function(){var e=ch(this),t=e.target,r=e.index++;if(!t||r>=t.length)return e.target=null,ih(void 0,!0);switch(e.kind){case"keys":return ih(r,!1);case"values":return ih(t[r],!1)}return ih([r,t[r]],!1)}),"values"),rh.Arguments=rh.Array;var ah=Qr,uh=Co,lh=Ga,hh=kn,fh=ah("".charAt),ph=ah("".charCodeAt),dh=ah("".slice),mh=function(e){return function(t,r){var n,s,i=lh(hh(t)),o=uh(r),c=i.length;return o<0||o>=c?e?"":void 0:(n=ph(i,o))<55296||n>56319||o+1===c||(s=ph(i,o+1))<56320||s>57343?e?fh(i,o):n:e?dh(i,o,o+2):s-56320+(n-55296<<10)+65536}},vh={codeAt:mh(!1),charAt:mh(!0)}.charAt,yh=Ga,bh=ol,gh=Ql,wh=eh,xh=bh.set,jh=bh.getterFor("String Iterator");gh(String,"String",(function(e){xh(this,{type:"String Iterator",string:yh(e),index:0})}),(function(){var e,t=jh(this),r=t.string,n=t.index;return n>=r.length?wh(void 0,!0):(e=vh(r,n),t.index+=e.length,wh(e,!1))}));var Eh=Cn.AggregateError,$h={CSSRuleList:0,CSSStyleDeclaration:0,CSSValueList:0,ClientRectList:0,DOMRectList:0,DOMStringList:0,DOMTokenList:1,DataTransferItemList:0,FileList:0,HTMLAllCollection:0,HTMLCollection:0,HTMLFormElement:0,HTMLSelectElement:0,MediaList:0,MimeTypeArray:0,NamedNodeMap:0,NodeList:1,PaintRequestList:0,Plugin:0,PluginArray:0,SVGLengthList:0,SVGNumberList:0,SVGPathSegList:0,SVGPointList:0,SVGStringList:0,SVGTransformList:0,SourceBufferList:0,StyleSheetList:0,TextTrackCueList:0,TextTrackList:0,TouchList:0},Oh=Lr,Sh=Rl,Ah=ra;for(var Ph in $h)Sh(Oh[Ph],Ph),Ah[Ph]=Ah.Array;const Th=dr(Eh);class kh extends Th{constructor(e,t,r){if(super(e,t,r),this.name=this.constructor.name,"string"==typeof t&&(this.message=t),"function"==typeof Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=new Error(t).stack,null!=r&&"object"==typeof r&&Object.hasOwn(r,"cause")&&!("cause"in this)){const{cause:e}=r;this.cause=e,e instanceof Error&&"stack"in e&&(this.stack=`${this.stack}\nCAUSE: ${e.stack}`)}}}class Fh extends Error{static[Symbol.hasInstance](e){return super[Symbol.hasInstance](e)||Function.prototype[Symbol.hasInstance].call(kh,e)}constructor(e,t){if(super(e,t),this.name=this.constructor.name,"string"==typeof e&&(this.message=e),"function"==typeof Error.captureStackTrace?Error.captureStackTrace(this,this.constructor):this.stack=new Error(e).stack,null!=t&&"object"==typeof t&&Object.hasOwn(t,"cause")&&!("cause"in this)){const{cause:e}=t;this.cause=e,e instanceof Error&&"stack"in e&&(this.stack=`${this.stack}\nCAUSE: ${e.stack}`)}}}class Ih extends Fh{constructor(e,t){if(super(e,t),null!=t&&"object"==typeof t){const{cause:e,...r}=t;Object.assign(this,r)}}}class Rh extends Fh{}class Dh extends Rh{}var _h=function(){return!1},Ch=function(){return!0};function Mh(e){return null!=e&&"object"==typeof e&&!0===e["@@functional/placeholder"]}function Nh(e){return function t(r){return 0===arguments.length||Mh(r)?t:e.apply(this,arguments)}}function qh(e){return function t(r,n){switch(arguments.length){case 0:return t;case 1:return Mh(r)?t:Nh((function(t){return e(r,t)}));default:return Mh(r)&&Mh(n)?t:Mh(r)?Nh((function(t){return e(t,n)})):Mh(n)?Nh((function(t){return e(r,t)})):e(r,n)}}}function Bh(e,t){switch(e){case 0:return function(){return t.apply(this,arguments)};case 1:return function(e){return t.apply(this,arguments)};case 2:return function(e,r){return t.apply(this,arguments)};case 3:return function(e,r,n){return t.apply(this,arguments)};case 4:return function(e,r,n,s){return t.apply(this,arguments)};case 5:return function(e,r,n,s,i){return t.apply(this,arguments)};case 6:return function(e,r,n,s,i,o){return t.apply(this,arguments)};case 7:return function(e,r,n,s,i,o,c){return t.apply(this,arguments)};case 8:return function(e,r,n,s,i,o,c,a){return t.apply(this,arguments)};case 9:return function(e,r,n,s,i,o,c,a,u){return t.apply(this,arguments)};case 10:return function(e,r,n,s,i,o,c,a,u,l){return t.apply(this,arguments)};default:throw new Error("First argument to _arity must be a non-negative integer no greater than ten")}}function Lh(e,t,r){return function(){for(var n=[],s=0,i=e,o=0,c=!1;o<t.length||s<arguments.length;){var a;o<t.length&&(!Mh(t[o])||s>=arguments.length)?a=t[o]:(a=arguments[s],s+=1),n[o]=a,Mh(a)?c=!0:i-=1,o+=1}return!c&&i<=0?r.apply(this,n):Bh(Math.max(0,i),Lh(e,n,r))}}var Uh=qh((function(e,t){return 1===e?Nh(t):Bh(e,Lh(e,[],t))}));function Jh(e){return function t(r,n,s){switch(arguments.length){case 0:return t;case 1:return Mh(r)?t:qh((function(t,n){return e(r,t,n)}));case 2:return Mh(r)&&Mh(n)?t:Mh(r)?qh((function(t,r){return e(t,n,r)})):Mh(n)?qh((function(t,n){return e(r,t,n)})):Nh((function(t){return e(r,n,t)}));default:return Mh(r)&&Mh(n)&&Mh(s)?t:Mh(r)&&Mh(n)?qh((function(t,r){return e(t,r,s)})):Mh(r)&&Mh(s)?qh((function(t,r){return e(t,n,r)})):Mh(n)&&Mh(s)?qh((function(t,n){return e(r,t,n)})):Mh(r)?Nh((function(t){return e(t,n,s)})):Mh(n)?Nh((function(t){return e(r,t,s)})):Mh(s)?Nh((function(t){return e(r,n,t)})):e(r,n,s)}}}const Vh=Array.isArray||function(e){return null!=e&&e.length>=0&&"[object Array]"===Object.prototype.toString.call(e)};function Gh(e){return null!=e&&"function"==typeof e["@@transducer/step"]}function Hh(e,t,r){return function(){if(0===arguments.length)return r();var n=arguments[arguments.length-1];if(!Vh(n)){for(var s=0;s<e.length;){if("function"==typeof n[e[s]])return n[e[s]].apply(n,Array.prototype.slice.call(arguments,0,-1));s+=1}if(Gh(n)){var i=t.apply(null,Array.prototype.slice.call(arguments,0,-1));return i(n)}}return r.apply(this,arguments)}}function zh(e){return e&&e["@@transducer/reduced"]?e:{"@@transducer/value":e,"@@transducer/reduced":!0}}const Xh=function(){return this.xf["@@transducer/init"]()},Wh=function(e){return this.xf["@@transducer/result"](e)};var Yh=function(){function e(e,t){this.xf=t,this.f=e,this.all=!0}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=function(e){return this.all&&(e=this.xf["@@transducer/step"](e,!0)),this.xf["@@transducer/result"](e)},e.prototype["@@transducer/step"]=function(e,t){return this.f(t)||(this.all=!1,e=zh(this.xf["@@transducer/step"](e,!1))),e},e}();function Zh(e){return function(t){return new Yh(e,t)}}var Kh=qh(Hh(["all"],Zh,(function(e,t){for(var r=0;r<t.length;){if(!e(t[r]))return!1;r+=1}return!0})));function Qh(e){for(var t,r=[];!(t=e.next()).done;)r.push(t.value);return r}function ef(e,t,r){for(var n=0,s=r.length;n<s;){if(e(t,r[n]))return!0;n+=1}return!1}function tf(e,t){return Object.prototype.hasOwnProperty.call(t,e)}const rf="function"==typeof Object.is?Object.is:function(e,t){return e===t?0!==e||1/e==1/t:e!=e&&t!=t};var nf=Object.prototype.toString,sf=function(){return"[object Arguments]"===nf.call(arguments)?function(e){return"[object Arguments]"===nf.call(e)}:function(e){return tf("callee",e)}}(),of=!{toString:null}.propertyIsEnumerable("toString"),cf=["constructor","valueOf","isPrototypeOf","toString","propertyIsEnumerable","hasOwnProperty","toLocaleString"],af=function(){return arguments.propertyIsEnumerable("length")}(),uf=function(e,t){for(var r=0;r<e.length;){if(e[r]===t)return!0;r+=1}return!1},lf="function"!=typeof Object.keys||af?Nh((function(e){if(Object(e)!==e)return[];var t,r,n=[],s=af&&sf(e);for(t in e)!tf(t,e)||s&&"length"===t||(n[n.length]=t);if(of)for(r=cf.length-1;r>=0;)tf(t=cf[r],e)&&!uf(n,t)&&(n[n.length]=t),r-=1;return n})):Nh((function(e){return Object(e)!==e?[]:Object.keys(e)})),hf=Nh((function(e){return null===e?"Null":void 0===e?"Undefined":Object.prototype.toString.call(e).slice(8,-1)}));function ff(e,t,r,n){var s=Qh(e);function i(e,t){return pf(e,t,r.slice(),n.slice())}return!ef((function(e,t){return!ef(i,t,e)}),Qh(t),s)}function pf(e,t,r,n){if(rf(e,t))return!0;var s=hf(e);if(s!==hf(t))return!1;if("function"==typeof e["fantasy-land/equals"]||"function"==typeof t["fantasy-land/equals"])return"function"==typeof e["fantasy-land/equals"]&&e["fantasy-land/equals"](t)&&"function"==typeof t["fantasy-land/equals"]&&t["fantasy-land/equals"](e);if("function"==typeof e.equals||"function"==typeof t.equals)return"function"==typeof e.equals&&e.equals(t)&&"function"==typeof t.equals&&t.equals(e);switch(s){case"Arguments":case"Array":case"Object":if("function"==typeof e.constructor&&"Promise"===function(e){var t=String(e).match(/^function (\w*)/);return null==t?"":t[1]}(e.constructor))return e===t;break;case"Boolean":case"Number":case"String":if(typeof e!=typeof t||!rf(e.valueOf(),t.valueOf()))return!1;break;case"Date":if(!rf(e.valueOf(),t.valueOf()))return!1;break;case"Error":return e.name===t.name&&e.message===t.message;case"RegExp":if(e.source!==t.source||e.global!==t.global||e.ignoreCase!==t.ignoreCase||e.multiline!==t.multiline||e.sticky!==t.sticky||e.unicode!==t.unicode)return!1}for(var i=r.length-1;i>=0;){if(r[i]===e)return n[i]===t;i-=1}switch(s){case"Map":return e.size===t.size&&ff(e.entries(),t.entries(),r.concat([e]),n.concat([t]));case"Set":return e.size===t.size&&ff(e.values(),t.values(),r.concat([e]),n.concat([t]));case"Arguments":case"Array":case"Object":case"Boolean":case"Number":case"String":case"Date":case"Error":case"RegExp":case"Int8Array":case"Uint8Array":case"Uint8ClampedArray":case"Int16Array":case"Uint16Array":case"Int32Array":case"Uint32Array":case"Float32Array":case"Float64Array":case"ArrayBuffer":break;default:return!1}var o=lf(e);if(o.length!==lf(t).length)return!1;var c=r.concat([e]),a=n.concat([t]);for(i=o.length-1;i>=0;){var u=o[i];if(!tf(u,t)||!pf(t[u],e[u],c,a))return!1;i-=1}return!0}var df=qh((function(e,t){return pf(e,t,[],[])}));function mf(e,t){return function(e,t,r){var n,s;if("function"==typeof e.indexOf)switch(typeof t){case"number":if(0===t){for(n=1/t;r<e.length;){if(0===(s=e[r])&&1/s===n)return r;r+=1}return-1}if(t!=t){for(;r<e.length;){if("number"==typeof(s=e[r])&&s!=s)return r;r+=1}return-1}return e.indexOf(t,r);case"string":case"boolean":case"function":case"undefined":return e.indexOf(t,r);case"object":if(null===t)return e.indexOf(t,r)}for(;r<e.length;){if(df(e[r],t))return r;r+=1}return-1}(t,e,0)>=0}function vf(e,t){for(var r=0,n=t.length,s=Array(n);r<n;)s[r]=e(t[r]),r+=1;return s}function yf(e){return'"'+e.replace(/\\/g,"\\\\").replace(/[\b]/g,"\\b").replace(/\f/g,"\\f").replace(/\n/g,"\\n").replace(/\r/g,"\\r").replace(/\t/g,"\\t").replace(/\v/g,"\\v").replace(/\0/g,"\\0").replace(/"/g,'\\"')+'"'}var bf=function(e){return(e<10?"0":"")+e},gf="function"==typeof Date.prototype.toISOString?function(e){return e.toISOString()}:function(e){return e.getUTCFullYear()+"-"+bf(e.getUTCMonth()+1)+"-"+bf(e.getUTCDate())+"T"+bf(e.getUTCHours())+":"+bf(e.getUTCMinutes())+":"+bf(e.getUTCSeconds())+"."+(e.getUTCMilliseconds()/1e3).toFixed(3).slice(2,5)+"Z"};function wf(e){return function(){return!e.apply(this,arguments)}}function xf(e,t,r){for(var n=0,s=r.length;n<s;)t=e(t,r[n]),n+=1;return t}function jf(e){return"[object Object]"===Object.prototype.toString.call(e)}var Ef=function(){function e(e,t){this.xf=t,this.f=e}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=Wh,e.prototype["@@transducer/step"]=function(e,t){return this.f(t)?this.xf["@@transducer/step"](e,t):e},e}();function $f(e){return function(t){return new Ef(e,t)}}var Of=qh(Hh(["fantasy-land/filter","filter"],$f,(function(e,t){return jf(t)?xf((function(r,n){return e(t[n])&&(r[n]=t[n]),r}),{},lf(t)):function(e,t){for(var r=0,n=t.length,s=[];r<n;)e(t[r])&&(s[s.length]=t[r]),r+=1;return s}(e,t)}))),Sf=qh((function(e,t){return Of(wf(e),t)}));function Af(e,t){var r=function(r){var n=t.concat([e]);return mf(r,n)?"<Circular>":Af(r,n)},n=function(e,t){return vf((function(t){return yf(t)+": "+r(e[t])}),t.slice().sort())};switch(Object.prototype.toString.call(e)){case"[object Arguments]":return"(function() { return arguments; }("+vf(r,e).join(", ")+"))";case"[object Array]":return"["+vf(r,e).concat(n(e,Sf((function(e){return/^\d+$/.test(e)}),lf(e)))).join(", ")+"]";case"[object Boolean]":return"object"==typeof e?"new Boolean("+r(e.valueOf())+")":e.toString();case"[object Date]":return"new Date("+(isNaN(e.valueOf())?r(NaN):yf(gf(e)))+")";case"[object Map]":return"new Map("+r(Array.from(e))+")";case"[object Null]":return"null";case"[object Number]":return"object"==typeof e?"new Number("+r(e.valueOf())+")":1/e==-1/0?"-0":e.toString(10);case"[object Set]":return"new Set("+r(Array.from(e).sort())+")";case"[object String]":return"object"==typeof e?"new String("+r(e.valueOf())+")":yf(e);case"[object Undefined]":return"undefined";default:if("function"==typeof e.toString){var s=e.toString();if("[object Object]"!==s)return s}return"{"+n(e,lf(e)).join(", ")+"}"}}var Pf=Nh((function(e){return Af(e,[])})),Tf=qh((function(e,t){if(e===t)return t;function r(e,t){if(e>t!=t>e)return t>e?t:e}var n=r(e,t);if(void 0!==n)return n;var s=r(typeof e,typeof t);if(void 0!==s)return s===typeof e?e:t;var i=Pf(e),o=r(i,Pf(t));return void 0!==o&&o===i?e:t})),kf=function(){function e(e,t){this.xf=t,this.f=e}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=Wh,e.prototype["@@transducer/step"]=function(e,t){return this.xf["@@transducer/step"](e,this.f(t))},e}(),Ff=qh(Hh(["fantasy-land/map","map"],(function(e){return function(t){return new kf(e,t)}}),(function(e,t){switch(Object.prototype.toString.call(t)){case"[object Function]":return Uh(t.length,(function(){return e.call(this,t.apply(this,arguments))}));case"[object Object]":return xf((function(r,n){return r[n]=e(t[n]),r}),{},lf(t));default:return vf(e,t)}})));const If=Number.isInteger||function(e){return e<<0===e};function Rf(e){return"[object String]"===Object.prototype.toString.call(e)}function Df(e,t){var r=e<0?t.length+e:e;return Rf(t)?t.charAt(r):t[r]}var _f=qh((function(e,t){if(null!=t)return If(e)?Df(e,t):t[e]})),Cf=qh((function(e,t){return Ff(_f(e),t)})),Mf=Nh((function(e){return!!Vh(e)||!!e&&("object"==typeof e&&(!Rf(e)&&(0===e.length||e.length>0&&(e.hasOwnProperty(0)&&e.hasOwnProperty(e.length-1)))))})),Nf="undefined"!=typeof Symbol?Symbol.iterator:"@@iterator";function qf(e,t,r){return function(n,s,i){if(Mf(i))return e(n,s,i);if(null==i)return s;if("function"==typeof i["fantasy-land/reduce"])return t(n,s,i,"fantasy-land/reduce");if(null!=i[Nf])return r(n,s,i[Nf]());if("function"==typeof i.next)return r(n,s,i);if("function"==typeof i.reduce)return t(n,s,i,"reduce");throw new TypeError("reduce: list must be array or iterable")}}function Bf(e,t,r){for(var n=0,s=r.length;n<s;){if((t=e["@@transducer/step"](t,r[n]))&&t["@@transducer/reduced"]){t=t["@@transducer/value"];break}n+=1}return e["@@transducer/result"](t)}var Lf=qh((function(e,t){return Bh(e.length,(function(){return e.apply(t,arguments)}))}));function Uf(e,t,r){for(var n=r.next();!n.done;){if((t=e["@@transducer/step"](t,n.value))&&t["@@transducer/reduced"]){t=t["@@transducer/value"];break}n=r.next()}return e["@@transducer/result"](t)}function Jf(e,t,r,n){return e["@@transducer/result"](r[n](Lf(e["@@transducer/step"],e),t))}var Vf=qf(Bf,Jf,Uf),Gf=function(){function e(e){this.f=e}return e.prototype["@@transducer/init"]=function(){throw new Error("init not implemented on XWrap")},e.prototype["@@transducer/result"]=function(e){return e},e.prototype["@@transducer/step"]=function(e,t){return this.f(e,t)},e}();function Hf(e){return new Gf(e)}var zf=Jh((function(e,t,r){return Vf("function"==typeof e?Hf(e):e,t,r)})),Xf=Nh((function(e){return Uh(zf(Tf,0,Cf("length",e)),(function(){for(var t=0,r=e.length;t<r;){if(!e[t].apply(this,arguments))return!1;t+=1}return!0}))})),Wf=Nh((function(e){return function(){return e}})),Yf=qh((function(e,t){return e&&t})),Zf=Nh((function(e){return Uh(zf(Tf,0,Cf("length",e)),(function(){for(var t=0,r=e.length;t<r;){if(e[t].apply(this,arguments))return!0;t+=1}return!1}))}));function Kf(e,t,r){for(var n=r.next();!n.done;)t=e(t,n.value),n=r.next();return t}function Qf(e,t,r,n){return r[n](e,t)}var ep=qf(xf,Qf,Kf),tp=qh((function(e,t){return"function"==typeof t["fantasy-land/ap"]?t["fantasy-land/ap"](e):"function"==typeof e.ap?e.ap(t):"function"==typeof e?function(r){return e(r)(t(r))}:ep((function(e,r){return function(e,t){var r;t=t||[];var n=(e=e||[]).length,s=t.length,i=[];for(r=0;r<n;)i[i.length]=e[r],r+=1;for(r=0;r<s;)i[i.length]=t[r],r+=1;return i}(e,Ff(r,t))}),[],e)})),rp=qh((function(e,t){return e.apply(this,t)})),np=Nh((function(e){return Uh(e.length,e)}));var sp=Nh((function(e){return null==e})),ip=Jh((function e(t,r,n){if(0===t.length)return r;var s=t[0];if(t.length>1){var i=!sp(n)&&tf(s,n)&&"object"==typeof n[s]?n[s]:If(t[1])?[]:{};r=e(Array.prototype.slice.call(t,1),r,i)}return function(e,t,r){if(If(e)&&Vh(r)){var n=[].concat(r);return n[e]=t,n}var s={};for(var i in r)s[i]=r[i];return s[e]=t,s}(s,r,n)}));function op(e){var t=Object.prototype.toString.call(e);return"[object Function]"===t||"[object AsyncFunction]"===t||"[object GeneratorFunction]"===t||"[object AsyncGeneratorFunction]"===t}var cp=qh((function(e,t){var r=Uh(e,t);return Uh(e,(function(){return xf(tp,Ff(r,arguments[0]),Array.prototype.slice.call(arguments,1))}))})),ap=Nh((function(e){return cp(e.length,e)})),up=qh((function(e,t){return op(e)?function(){return e.apply(this,arguments)&&t.apply(this,arguments)}:ap(Yf)(e,t)}));function lp(e){return new RegExp(e.source,e.flags?e.flags:(e.global?"g":"")+(e.ignoreCase?"i":"")+(e.multiline?"m":"")+(e.sticky?"y":"")+(e.unicode?"u":"")+(e.dotAll?"s":""))}function hp(e,t,r){if(r||(r=new fp),function(e){var t=typeof e;return null==e||"object"!=t&&"function"!=t}(e))return e;var n=function(t){var n=r.get(e);if(n)return n;for(var s in r.set(e,t),e)Object.prototype.hasOwnProperty.call(e,s)&&(t[s]=e[s]);return t};switch(hf(e)){case"Object":return n(Object.create(Object.getPrototypeOf(e)));case"Array":return n(Array(e.length));case"Date":return new Date(e.valueOf());case"RegExp":return lp(e);case"Int8Array":case"Uint8Array":case"Uint8ClampedArray":case"Int16Array":case"Uint16Array":case"Int32Array":case"Uint32Array":case"Float32Array":case"Float64Array":case"BigInt64Array":case"BigUint64Array":return e.slice();default:return e}}var fp=function(){function e(){this.map={},this.length=0}return e.prototype.set=function(e,t){var r=this.hash(e),n=this.map[r];n||(this.map[r]=n=[]),n.push([e,t]),this.length+=1},e.prototype.hash=function(e){var t=[];for(var r in e)t.push(Object.prototype.toString.call(e[r]));return t.join()},e.prototype.get=function(e){if(this.length<=180)for(var t in this.map)for(var r=this.map[t],n=0;n<r.length;n+=1){if((i=r[n])[0]===e)return i[1]}else{var s=this.hash(e);if(r=this.map[s])for(n=0;n<r.length;n+=1){var i;if((i=r[n])[0]===e)return i[1]}}},e}(),pp=Nh((function(e){return function(t,r){return e(t,r)?-1:e(r,t)?1:0}})),dp=ap(Nh((function(e){return!e})));function mp(e,t){return function(){return t.call(this,e.apply(this,arguments))}}function vp(e,t){return function(){var r=arguments.length;if(0===r)return t();var n=arguments[r-1];return Vh(n)||"function"!=typeof n[e]?t.apply(this,arguments):n[e].apply(n,Array.prototype.slice.call(arguments,0,r-1))}}var yp=Jh(vp("slice",(function(e,t,r){return Array.prototype.slice.call(r,e,t)}))),bp=Nh(vp("tail",yp(1,1/0)));function gp(){if(0===arguments.length)throw new Error("pipe requires at least one argument");return Bh(arguments[0].length,zf(mp,arguments[0],bp(arguments)))}var wp=Nh((function(e){return Df(0,e)}));function xp(e){return e}var jp=Nh(xp),Ep=qh((function(e,t){return Uh(zf(Tf,0,Cf("length",t)),(function(){var r=arguments,n=this;return e.apply(n,vf((function(e){return e.apply(n,r)}),t))}))})),$p=function(){function e(e,t,r,n){this.valueFn=e,this.valueAcc=t,this.keyFn=r,this.xf=n,this.inputs={}}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=function(e){var t;for(t in this.inputs)if(tf(t,this.inputs)&&(e=this.xf["@@transducer/step"](e,this.inputs[t]))["@@transducer/reduced"]){e=e["@@transducer/value"];break}return this.inputs=null,this.xf["@@transducer/result"](e)},e.prototype["@@transducer/step"]=function(e,t){var r=this.keyFn(t);return this.inputs[r]=this.inputs[r]||[r,hp(this.valueAcc)],this.inputs[r][1]=this.valueFn(this.inputs[r][1],t),e},e}();function Op(e,t,r){return function(n){return new $p(e,t,r,n)}}var Sp=Lh(4,[],Hh([],Op,(function(e,t,r,n){var s=Hf((function(n,s){var i=r(s),o=e(tf(i,n)?n[i]:hp(t),s);return o&&o["@@transducer/reduced"]?zh(n):(n[i]=o,n)}));return Vf(s,{},n)}))),Ap=qh((function(e,t){return null==t||t!=t?e:t})),Pp=function(){function e(){this._nativeSet="function"==typeof Set?new Set:null,this._items={}}return e.prototype.add=function(e){return!Tp(e,!0,this)},e.prototype.has=function(e){return Tp(e,!1,this)},e}();function Tp(e,t,r){var n,s=typeof e;switch(s){case"string":case"number":return 0===e&&1/e==-1/0?!!r._items["-0"]||(t&&(r._items["-0"]=!0),!1):null!==r._nativeSet?t?(n=r._nativeSet.size,r._nativeSet.add(e),r._nativeSet.size===n):r._nativeSet.has(e):s in r._items?e in r._items[s]||(t&&(r._items[s][e]=!0),!1):(t&&(r._items[s]={},r._items[s][e]=!0),!1);case"boolean":if(s in r._items){var i=e?1:0;return!!r._items[s][i]||(t&&(r._items[s][i]=!0),!1)}return t&&(r._items[s]=e?[!1,!0]:[!0,!1]),!1;case"function":return null!==r._nativeSet?t?(n=r._nativeSet.size,r._nativeSet.add(e),r._nativeSet.size===n):r._nativeSet.has(e):s in r._items?!!mf(e,r._items[s])||(t&&r._items[s].push(e),!1):(t&&(r._items[s]=[e]),!1);case"undefined":return!!r._items[s]||(t&&(r._items[s]=!0),!1);case"object":if(null===e)return!!r._items.null||(t&&(r._items.null=!0),!1);default:return(s=Object.prototype.toString.call(e))in r._items?!!mf(e,r._items[s])||(t&&r._items[s].push(e),!1):(t&&(r._items[s]=[e]),!1)}}var kp=qh((function(e,t){for(var r=[],n=0,s=e.length,i=t.length,o=new Pp,c=0;c<i;c+=1)o.add(t[c]);for(;n<s;)o.add(e[n])&&(r[r.length]=e[n]),n+=1;return r})),Fp=function(){function e(e,t){this.xf=t,this.n=e,this.i=0}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=Wh,e.prototype["@@transducer/step"]=function(e,t){this.i+=1;var r=0===this.n?e:this.xf["@@transducer/step"](e,t);return this.n>=0&&this.i>=this.n?zh(r):r},e}();function Ip(e){return function(t){return new Fp(e,t)}}var Rp=qh(Hh(["take"],Ip,(function(e,t){return yp(0,e<0?1/0:e,t)})));function Dp(e,t){for(var r=t.length-1;r>=0&&e(t[r]);)r-=1;return yp(0,r+1,t)}var _p=function(){function e(e,t){this.f=e,this.retained=[],this.xf=t}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=function(e){return this.retained=null,this.xf["@@transducer/result"](e)},e.prototype["@@transducer/step"]=function(e,t){return this.f(t)?this.retain(e,t):this.flush(e,t)},e.prototype.flush=function(e,t){return e=Vf(this.xf,e,this.retained),this.retained=[],this.xf["@@transducer/step"](e,t)},e.prototype.retain=function(e,t){return this.retained.push(t),e},e}();function Cp(e){return function(t){return new _p(e,t)}}var Mp=qh(Hh([],Cp,Dp)),Np=Nh((function(e){return Df(-1,e)})),qp=function(){function e(e,t){this.xf=t,this.f=e}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=Wh,e.prototype["@@transducer/step"]=function(e,t){if(this.f){if(this.f(t))return e;this.f=null}return this.xf["@@transducer/step"](e,t)},e}();function Bp(e){return function(t){return new qp(e,t)}}var Lp=qh(Hh(["dropWhile"],Bp,(function(e,t){for(var r=0,n=t.length;r<n&&e(t[r]);)r+=1;return yp(r,1/0,t)}))),Up=qh((function(e,t){return e||t})),Jp=qh((function(e,t){return op(e)?function(){return e.apply(this,arguments)||t.apply(this,arguments)}:ap(Up)(e,t)}));var Vp=Nh((function(e){return null!=e&&"function"==typeof e["fantasy-land/empty"]?e["fantasy-land/empty"]():null!=e&&null!=e.constructor&&"function"==typeof e.constructor["fantasy-land/empty"]?e.constructor["fantasy-land/empty"]():null!=e&&"function"==typeof e.empty?e.empty():null!=e&&null!=e.constructor&&"function"==typeof e.constructor.empty?e.constructor.empty():Vh(e)?[]:Rf(e)?"":jf(e)?{}:sf(e)?function(){return arguments}():function(e){var t=Object.prototype.toString.call(e);return"[object Uint8ClampedArray]"===t||"[object Int8Array]"===t||"[object Uint8Array]"===t||"[object Int16Array]"===t||"[object Uint16Array]"===t||"[object Int32Array]"===t||"[object Uint32Array]"===t||"[object Float32Array]"===t||"[object Float64Array]"===t||"[object BigInt64Array]"===t||"[object BigUint64Array]"===t}(e)?e.constructor.from(""):void 0})),Gp=Nh((function(e){return Uh(e.length,(function(t,r){var n=Array.prototype.slice.call(arguments,0);return n[0]=r,n[1]=t,e.apply(this,n)}))})),Hp=qh(vp("groupBy",Sp((function(e,t){return e.push(t),e}),[]))),zp=qh((function(e,t){if(0===e.length||sp(t))return!1;for(var r=t,n=0;n<e.length;){if(sp(r)||!tf(e[n],r))return!1;r=r[e[n]],n+=1}return!0})),Xp=qh((function(e,t){return zp([e],t)})),Wp=function(e,t){switch(arguments.length){case 0:return Wp;case 1:return function t(r){return 0===arguments.length?t:rf(e,r)};default:return rf(e,t)}},Yp=Jh((function(e,t,r){return Uh(Math.max(e.length,t.length,r.length),(function(){return e.apply(this,arguments)?t.apply(this,arguments):r.apply(this,arguments)}))})),Zp=qh(mf),Kp=yp(0,-1),Qp=qh((function(e,t){return Uh(e+1,(function(){var r=arguments[e];if(null!=r&&op(r[t]))return r[t].apply(r,Array.prototype.slice.call(arguments,0,e));throw new TypeError(Pf(r)+' does not have a method named "'+t+'"')}))})),ed=Nh((function(e){return null!=e&&df(e,Vp(e))})),td=Nh((function(e){return!ed(e)})),rd=Qp(1,"join");function nd(e){return"[object Number]"===Object.prototype.toString.call(e)}var sd=qh((function(e,t){return function(r){return function(n){return Ff((function(e){return t(e,n)}),r(e(n)))}}}));function id(e,t){for(var r=t,n=0;n<e.length;n+=1){if(null==r)return;var s=e[n];r=If(s)?Df(s,r):r[s]}return r}var od=qh((function(e,t){return xf((function(r,n){return r[n]=e(t[n],n,t),r}),{},lf(t))})),cd=Jh((function(e,t,r){var n,s={};for(n in r=r||{},t=t||{})tf(n,t)&&(s[n]=tf(n,r)?e(n,t[n],r[n]):t[n]);for(n in r)tf(n,r)&&!tf(n,s)&&(s[n]=r[n]);return s})),ad=Jh((function e(t,r,n){return cd((function(r,n,s){return jf(n)&&jf(s)?e(t,n,s):t(r,n,s)}),r,n)})),ud=qh((function(e,t){return ad((function(e,t,r){return r}),e,t)})),ld=qh((function(e,t){return Kh(wf(e),t)})),hd=function(e){return{value:e,map:function(t){return hd(t(e))}}},fd=Jh((function(e,t,r){return e((function(e){return hd(t(e))}))(r).value})),pd=qh(id),dd=Jh((function(e,t,r){return Ap(e,id(t,r))})),md=Jh((function(e,t,r){return e(id(t,r))})),vd=qh((function(e,t){for(var r={},n=0;n<e.length;)e[n]in t&&(r[e[n]]=t[e[n]]),n+=1;return r})),yd=Jh((function(e,t,r){return df(e,_f(t,r))})),bd=Jh((function(e,t,r){return Ap(e,_f(t,r))})),gd=Jh((function(e,t,r){return e(_f(t,r))})),wd=qh((function(e,t){if(!nd(e)||!nd(t))throw new TypeError("Both arguments to range must be numbers");for(var r=Array(e<t?t-e:0),n=e<0?t+Math.abs(e):t-e,s=0;s<n;)r[s]=s+e,s+=1;return r})),xd=Nh(zh),jd=Jh((function(e,t,r){return r.replace(e,t)})),Ed=qh((function(e,t){return Array.prototype.slice.call(t,0).sort(e)})),$d=Qp(1,"split"),Od=qh((function(e,t){return df(Rp(e.length,t),e)}));var Sd=qh((function(e,t){if(r=e,"[object RegExp]"!==Object.prototype.toString.call(r))throw new TypeError("‘test’ requires a value of type RegExp as its first argument; received "+Pf(e));var r;return lp(e).test(t)})),Ad=function(){function e(e,t){this.xf=t,this.pred=e,this.items=[]}return e.prototype["@@transducer/init"]=Xh,e.prototype["@@transducer/result"]=Wh,e.prototype["@@transducer/step"]=function(e,t){return ef(this.pred,t,this.items)?e:(this.items.push(t),this.xf["@@transducer/step"](e,t))},e}();function Pd(e){return function(t){return new Ad(e,t)}}var Td=qh(Hh([],Pd,(function(e,t){for(var r,n=0,s=t.length,i=[];n<s;)ef(e,r=t[n],i)||(i[i.length]=r),n+=1;return i}))),kd=Jh((function(e,t,r){return e(r)?t(r):r})),Fd=Wf(void 0),Id=df(Fd()),Rd=dp(Id),Dd=df(null),_d=dp(Dd),Cd=dp(sp),Md=Uh(1,gp(hf,Wp("GeneratorFunction"))),Nd=Uh(1,gp(hf,Wp("AsyncFunction"))),qd=Zf([gp(hf,Wp("Function")),Md,Nd]),Bd=Uh(1,qd(Array.isArray)?Array.isArray:gp(hf,Wp("Array"))),Ld=up(Bd,ed),Ud=up(Bd,td),Jd=Uh(1,gp(hf,Wp("String"))),Vd=df("");function Gd(e){return Gd="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(e){return typeof e}:function(e){return e&&"function"==typeof Symbol&&e.constructor===Symbol&&e!==Symbol.prototype?"symbol":typeof e},Gd(e)}var Hd=function(e){return"object"===Gd(e)},zd=dp(Uh(1,up(_d,Jp(Hd,qd)))),Xd=Xf([Jd,zd,td]),Wd=dp(qd),Yd=Uh(1,up(_d,Hd)),Zd=gp(hf,Wp("Object")),Kd=gp(Pf,df(Pf(Object))),Qd=md(up(qd,Kd),["constructor"]),em=Uh(1,(function(e){if(!Yd(e)||!Zd(e))return!1;var t=Object.getPrototypeOf(e);return!!Dd(t)||Qd(t)})),tm=up(Uh(1,gp(hf,Wp("Number"))),isFinite),rm=Uh(1,tm),nm=up(qd(Number.isFinite)?Uh(1,Lf(Number.isFinite,Number)):rm,Ep(df,[Math.floor,jp])),sm=Uh(1,nm),im=qd(Number.isInteger)?Uh(1,Lf(Number.isInteger,Number)):sm,om=Uh(1,gp(hf,Wp("RegExp")));function cm(e){return function(e){if(Array.isArray(e))return am(e)}(e)||function(e){if("undefined"!=typeof Symbol&&null!=e[Symbol.iterator]||null!=e["@@iterator"])return Array.from(e)}(e)||function(e,t){if(e){if("string"==typeof e)return am(e,t);var r={}.toString.call(e).slice(8,-1);return"Object"===r&&e.constructor&&(r=e.constructor.name),"Map"===r||"Set"===r?Array.from(e):"Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r)?am(e,t):void 0}}(e)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function am(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=Array(t);r<t;r++)n[r]=e[r];return n}var um,lm,hm=gp(Ed(pp((function(e,t){return e.length>t.length}))),wp,_f("length")),fm=np((function(e,t,r){var n=r.apply(void 0,cm(e));return Cd(n)?xd(n):t})),pm=Yp(Ud,(function(e){var t=hm(e);return Uh(t,(function(){for(var t=arguments.length,r=new Array(t),n=0;n<t;n++)r[n]=arguments[n];return zf(fm(r),void 0,e)}))}),Fd),dm=Gp(Zp),mm=Uh(3,(function(e,t,r){var n=pd(e,r),s=pd(Kp(e),r);if(!Wd(n)&&!Ld(e)){var i=Lf(n,s);return rp(i,t)}})),vm=kd(Jd,jd(/[.*+?^${}()|[\]\\-]/g,"\\$&")),ym=function(e,t){if("string"!=typeof e&&!(e instanceof String))throw TypeError("`".concat(t,"` must be a string"))},bm=Uh(3,(function(e,t,r){!function(e,t,r){if(null==r||null==e||null==t)throw TypeError("Input values must not be `null` or `undefined`")}(e,t,r),ym(r,"str"),ym(t,"replaceValue"),function(e){if(!("string"==typeof e||e instanceof String||e instanceof RegExp))throw TypeError("`searchValue` must be a string or an regexp")}(e);var n=new RegExp(om(e)?e:vm(e),"g");return jd(n,t,r)})),gm=Qp(2,"replaceAll"),wm=qd(String.prototype.replaceAll)?gm:bm,xm=np((function(e,t){return gp($d(""),Mp(dm(e)),rd(""))(t)})),jm=np((function(e,t){return gp($d(""),Lp(dm(e)),rd(""))(t)})),Em={exports:{}},$m=Em.exports={};function Om(){throw new Error("setTimeout has not been defined")}function Sm(){throw new Error("clearTimeout has not been defined")}function Am(e){if(um===setTimeout)return setTimeout(e,0);if((um===Om||!um)&&setTimeout)return um=setTimeout,setTimeout(e,0);try{return um(e,0)}catch(t){try{return um.call(null,e,0)}catch(t){return um.call(this,e,0)}}}!function(){try{um="function"==typeof setTimeout?setTimeout:Om}catch(e){um=Om}try{lm="function"==typeof clearTimeout?clearTimeout:Sm}catch(e){lm=Sm}}();var Pm,Tm=[],km=!1,Fm=-1;function Im(){km&&Pm&&(km=!1,Pm.length?Tm=Pm.concat(Tm):Fm=-1,Tm.length&&Rm())}function Rm(){if(!km){var e=Am(Im);km=!0;for(var t=Tm.length;t;){for(Pm=Tm,Tm=[];++Fm<t;)Pm&&Pm[Fm].run();Fm=-1,t=Tm.length}Pm=null,km=!1,function(e){if(lm===clearTimeout)return clearTimeout(e);if((lm===Sm||!lm)&&clearTimeout)return lm=clearTimeout,clearTimeout(e);try{lm(e)}catch(t){try{return lm.call(null,e)}catch(t){return lm.call(this,e)}}}(e)}}function Dm(e,t){this.fun=e,this.array=t}function _m(){}$m.nextTick=function(e){var t=new Array(arguments.length-1);if(arguments.length>1)for(var r=1;r<arguments.length;r++)t[r-1]=arguments[r];Tm.push(new Dm(e,t)),1!==Tm.length||km||Am(Rm)},Dm.prototype.run=function(){this.fun.apply(null,this.array)},$m.title="browser",$m.browser=!0,$m.env={},$m.argv=[],$m.version="",$m.versions={},$m.on=_m,$m.addListener=_m,$m.once=_m,$m.off=_m,$m.removeListener=_m,$m.removeAllListeners=_m,$m.emit=_m,$m.prependListener=_m,$m.prependOnceListener=_m,$m.listeners=function(e){return[]},$m.binding=function(e){throw new Error("process.binding is not supported")},$m.cwd=function(){return"/"},$m.chdir=function(e){throw new Error("process.chdir is not supported")},$m.umask=function(){return 0};const Cm=dr(Em.exports),Mm=()=>md(Sd(/^win/),["platform"],Cm),Nm=e=>{try{const t=new URL(e);return xm(":",t.protocol)}catch{return}},qm=gp(Nm,Rd),Bm=e=>{const t=e.lastIndexOf(".");return t>=0?e.substring(t).toLowerCase():""},Lm=e=>{if(Cm.browser)return!1;const t=Nm(e);return Id(t)||"file"===t||/^[a-zA-Z]$/.test(t)},Um=e=>{const t=Nm(e);return"http"===t||"https"===t},Jm=(e,t)=>{const r=[/%23/g,"#",/%24/g,"$",/%26/g,"&",/%2C/g,",",/%40/g,"@"],n=bd(!1,"keepFileProtocol",t),s=bd(Mm,"isWindows",t);let i=decodeURI(e);for(let e=0;e<r.length;e+=2)i=i.replace(r[e],r[e+1]);let o="file://"===i.substring(0,7).toLowerCase();return o&&(i="/"===i[7]?i.substring(8):i.substring(7),s()&&"/"===i[1]&&(i=`${i[0]}:${i.substring(1)}`),n?i=`file:///${i}`:(o=!1,i=s()?i:`/${i}`)),s()&&!o&&(i=wm("/","\\",i),":\\"===i.substring(1,3)&&(i=i[0].toUpperCase()+i.substring(1))),i},Vm=e=>{const t=[/\?/g,"%3F",/#/g,"%23"];let r=e;Mm()&&(r=r.replace(/\\/g,"/")),r=encodeURI(r);for(let e=0;e<t.length;e+=2)r=r.replace(t[e],t[e+1]);return r},Gm=e=>{const t=e.indexOf("#");return-1!==t?e.substring(t):"#"},Hm=e=>{const t=e.indexOf("#");let r=e;return t>=0&&(r=e.substring(0,t)),r},zm=()=>{if(Cm.browser)return Hm(globalThis.location.href);const e=Cm.cwd(),t=Np(e);return["/","\\"].includes(t)?e:e+(Mm()?"\\":"/")},Xm=(e,t)=>{const r=new URL(t,new URL(e,"resolve://"));if("resolve:"===r.protocol){const{pathname:e,search:t,hash:n}=r;return e+t+n}return r.toString()},Wm=e=>{if(Lm(e))return Vm(Jm(e));try{return new URL(e).toString()}catch{return encodeURI(decodeURI(e)).replace(/%5B/g,"[").replace(/%5D/g,"]")}},Ym=e=>Lm(e)?Jm(e):decodeURI(e),Zm=Object.freeze(Object.defineProperty({__proto__:null,cwd:zm,fromFileSystemPath:Vm,getExtension:Bm,getHash:Gm,getProtocol:Nm,hasProtocol:qm,isFileSystemPath:Lm,isHttpUrl:Um,isURI:e=>{try{return new URL(e)&&!0}catch{return!1}},resolve:Xm,sanitize:Wm,stripHash:Hm,toFileSystemPath:Jm,unsanitize:Ym},Symbol.toStringTag,{value:"Module"}));let Km=class{uri;mediaType;data;parseResult;constructor({uri:e,mediaType:t="text/plain",data:r,parseResult:n}){this.uri=e,this.mediaType=t,this.data=r,this.parseResult=n}get extension(){return Jd(this.uri)?Bm(this.uri):""}toString(){if("string"==typeof this.data)return this.data;if(this.data instanceof ArrayBuffer||["ArrayBuffer"].includes(hf(this.data))||ArrayBuffer.isView(this.data)){return new TextDecoder("utf-8").decode(this.data)}return String(this.data)}};class Qm{rootRef;refs;circular;constructor({refs:e=[],circular:t=!1}={}){this.refs=[],this.circular=t,e.forEach(this.add.bind(this))}get size(){return this.refs.length}add(e){return this.has(e)||(this.refs.push(e),this.rootRef=void 0===this.rootRef?e:this.rootRef,e.refSet=this),this}merge(e){for(const t of e.values())this.add(t);return this}has(e){const t=Jd(e)?e:e.uri;return Rd(this.find((e=>e.uri===t)))}find(e){return this.refs.find(e)}*values(){yield*this.refs}clean(){this.refs.forEach((e=>{e.refSet=void 0})),this.rootRef=void 0,this.refs.length=0}}const ev={parse:{mediaType:"text/plain",parsers:[],parserOpts:{}},resolve:{baseURI:"",resolvers:[],resolverOpts:{},strategies:[],strategyOpts:{},internal:!0,external:!0,maxDepth:1/0},dereference:{strategies:[],strategyOpts:{},refSet:null,maxDepth:1/0,circular:"ignore",circularReplacer:jp,immutable:!0},bundle:{strategies:[],refSet:null,maxDepth:1/0}},tv=sd(pd(["resolve","baseURI"]),ip(["resolve","baseURI"])),rv=e=>Vd(e)?zm():e,nv=(e,t)=>{const r=ud(e,t);return fd(tv,rv,r)};class sv extends Fh{plugin;constructor(e,t){super(e,{cause:t.cause}),this.plugin=t.plugin}}const iv=async(e,t,r)=>{const n=await Promise.all(r.map(mm([e],t)));return r.filter(((e,t)=>n[t]))},ov=async(e,t,r)=>{let n;for(const s of r)try{const r=await s[e].call(s,...t);return{plugin:s,result:r}}catch(e){n=new sv("Error while running plugin",{cause:e,plugin:s})}return Promise.reject(n)};class cv extends Fh{}class av extends Fh{}class uv extends av{}class lv extends uv{}const hv=async(e,t)=>{const r=new Km({uri:Wm(Hm(e)),mediaType:t.parse.mediaType}),n=await(async(e,t)=>{const r=t.resolve.resolvers.map((e=>{const r=Object.create(e);return Object.assign(r,t.resolve.resolverOpts)})),n=await iv("canRead",[e,t],r);if(ed(n))throw new lv(e.uri);try{const{result:t}=await ov("read",[e],n);return t}catch(t){throw new av(`Error while reading file "${e.uri}"`,{cause:t})}})(r,t);return(async(e,t)=>{const r=t.parse.parsers.map((e=>{const r=Object.create(e);return Object.assign(r,t.parse.parserOpts)})),n=await iv("canParse",[e,t],r);if(ed(n))throw new lv(e.uri);try{const{plugin:r,result:s}=await ov("parse",[e,t],n);return!r.allowEmpty&&s.isEmpty?Promise.reject(new cv(`Error while parsing file "${e.uri}". File is empty.`)):s}catch(t){throw new cv(`Error while parsing file "${e.uri}"`,{cause:t})}})(new Km({...r,data:n}),t)};var fv=function(e){return null===e},pv="object"==typeof global&&global&&global.Object===Object&&global,dv=pv,mv="object"==typeof self&&self&&self.Object===Object&&self,vv=dv||mv||Function("return this")(),yv=vv.Symbol,bv=yv,gv=Object.prototype,wv=gv.hasOwnProperty,xv=gv.toString,jv=bv?bv.toStringTag:void 0;var Ev=function(e){var t=wv.call(e,jv),r=e[jv];try{e[jv]=void 0;var n=!0}catch(e){}var s=xv.call(e);return n&&(t?e[jv]=r:delete e[jv]),s},$v=Object.prototype.toString;var Ov=Ev,Sv=function(e){return $v.call(e)},Av=yv?yv.toStringTag:void 0;var Pv=function(e){return null==e?void 0===e?"[object Undefined]":"[object Null]":Av&&Av in Object(e)?Ov(e):Sv(e)},Tv=Array.isArray;var kv=function(e){return null!=e&&"object"==typeof e},Fv=Pv,Iv=Tv,Rv=kv;var Dv=function(e){return"string"==typeof e||!Iv(e)&&Rv(e)&&"[object String]"==Fv(e)},_v=Pv,Cv=kv;var Mv=function(e){return"number"==typeof e||Cv(e)&&"[object Number]"==_v(e)},Nv=Pv,qv=kv;var Bv=function(e){return!0===e||!1===e||qv(e)&&"[object Boolean]"==Nv(e)};var Lv=function(e){var t=typeof e;return null!=e&&("object"==t||"function"==t)};var Uv=class{constructor(e){this.namespace=e||new this.Namespace}serialise(e){if(!(e instanceof this.namespace.elements.Element))throw new TypeError(`Given element \`${e}\` is not an Element instance`);const t={element:e.element};e._meta&&e._meta.length>0&&(t.meta=this.serialiseObject(e.meta)),e._attributes&&e._attributes.length>0&&(t.attributes=this.serialiseObject(e.attributes));const r=this.serialiseContent(e.content);return void 0!==r&&(t.content=r),t}deserialise(e){if(!e.element)throw new Error("Given value is not an object containing an element name");const t=new(this.namespace.getElementClass(e.element));t.element!==e.element&&(t.element=e.element),e.meta&&this.deserialiseObject(e.meta,t.meta),e.attributes&&this.deserialiseObject(e.attributes,t.attributes);const r=this.deserialiseContent(e.content);return void 0===r&&null!==t.content||(t.content=r),t}serialiseContent(e){if(e instanceof this.namespace.elements.Element)return this.serialise(e);if(e instanceof this.namespace.KeyValuePair){const t={key:this.serialise(e.key)};return e.value&&(t.value=this.serialise(e.value)),t}if(e&&e.map){if(0===e.length)return;return e.map(this.serialise,this)}return e}deserialiseContent(e){if(e){if(e.element)return this.deserialise(e);if(e.key){const t=new this.namespace.KeyValuePair(this.deserialise(e.key));return e.value&&(t.value=this.deserialise(e.value)),t}if(e.map)return e.map(this.deserialise,this)}return e}serialiseObject(e){const t={};if(e.forEach(((e,r)=>{e&&(t[r.toValue()]=this.serialise(e))})),0!==Object.keys(t).length)return t}deserialiseObject(e,t){Object.keys(e).forEach((r=>{t.set(r,this.deserialise(e[r]))}))}};var Jv=function(){this.u=[],this.size=0};var Vv=function(e,t){return e===t||e!=e&&t!=t},Gv=Vv;var Hv=function(e,t){for(var r=e.length;r--;)if(Gv(e[r][0],t))return r;return-1},zv=Hv,Xv=Array.prototype.splice;var Wv=function(e){var t=this.u,r=zv(t,e);return!(r<0)&&(r==t.length-1?t.pop():Xv.call(t,r,1),--this.size,!0)},Yv=Hv;var Zv=function(e){var t=this.u,r=Yv(t,e);return r<0?void 0:t[r][1]},Kv=Hv;var Qv=Hv;var ey=function(e,t){var r=this.u,n=Qv(r,e);return n<0?(++this.size,r.push([e,t])):r[n][1]=t,this},ty=Jv,ry=Wv,ny=Zv,sy=function(e){return Kv(this.u,e)>-1},iy=ey;function oy(e){var t=-1,r=null==e?0:e.length;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}oy.prototype.clear=ty,oy.prototype.delete=ry,oy.prototype.get=ny,oy.prototype.has=sy,oy.prototype.set=iy;var cy=oy,ay=cy;var uy=function(){this.u=new ay,this.size=0};var ly=function(e){var t=this.u,r=t.delete(e);return this.size=t.size,r};var hy=function(e){return this.u.get(e)};var fy=function(e){return this.u.has(e)},py=Pv,dy=Lv;var my=function(e){if(!dy(e))return!1;var t=py(e);return"[object Function]"==t||"[object GeneratorFunction]"==t||"[object AsyncFunction]"==t||"[object Proxy]"==t},vy=vv["o"],yy=function(){var e=/[^.]+$/.exec(vy&&vy.keys&&vy.keys.IE_PROTO||"");return e?"Symbol(src)_1."+e:""}();var by=function(e){return!!yy&&yy in e},gy=Function.prototype.toString;var wy=function(e){if(null!=e){try{return gy.call(e)}catch(e){}try{return e+""}catch(e){}}return""},xy=my,jy=by,Ey=Lv,$y=wy,Oy=/^\[object .+?Constructor\]$/,Sy=Function.prototype,Ay=Object.prototype,Py=Sy.toString,Ty=Ay.hasOwnProperty,ky=RegExp("^"+Py.call(Ty).replace(/[\\^$.*+?()[\]{}|]/g,"\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g,"$1.*?")+"$");var Fy=function(e){return!(!Ey(e)||jy(e))&&(xy(e)?ky:Oy).test($y(e))},Iy=function(e,t){return null==e?void 0:e[t]};var Ry=function(e,t){var r=Iy(e,t);return Fy(r)?r:void 0},Dy=Ry(vv,"Map"),_y=Ry(Object,"create"),Cy=_y;var My=function(){this.u=Cy?Cy(null):{},this.size=0};var Ny=function(e){var t=this.has(e)&&delete this.u[e];return this.size-=t?1:0,t},qy=_y,By=Object.prototype.hasOwnProperty;var Ly=function(e){var t=this.u;if(qy){var r=t[e];return"__lodash_hash_undefined__"===r?void 0:r}return By.call(t,e)?t[e]:void 0},Uy=_y,Jy=Object.prototype.hasOwnProperty;var Vy=function(e){var t=this.u;return Uy?void 0!==t[e]:Jy.call(t,e)},Gy=_y;var Hy=function(e,t){var r=this.u;return this.size+=this.has(e)?0:1,r[e]=Gy&&void 0===t?"__lodash_hash_undefined__":t,this},zy=My,Xy=Ny,Wy=Ly,Yy=Vy,Zy=Hy;function Ky(e){var t=-1,r=null==e?0:e.length;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}Ky.prototype.clear=zy,Ky.prototype.delete=Xy,Ky.prototype.get=Wy,Ky.prototype.has=Yy,Ky.prototype.set=Zy;var Qy=Ky,eb=cy,tb=Dy;var rb=function(e){var t=typeof e;return"string"==t||"number"==t||"symbol"==t||"boolean"==t?"__proto__"!==e:null===e},nb=rb;var sb=function(e,t){var r=e.u;return nb(t)?r["string"==typeof t?"string":"hash"]:r.map},ib=sb;var ob=sb;var cb=sb;var ab=sb;var ub=function(e,t){var r=ab(this,e),n=r.size;return r.set(e,t),this.size+=r.size==n?0:1,this},lb=function(){this.size=0,this.u={hash:new Qy,map:new(tb||eb),string:new Qy}},hb=function(e){var t=ib(this,e).delete(e);return this.size-=t?1:0,t},fb=function(e){return ob(this,e).get(e)},pb=function(e){return cb(this,e).has(e)},db=ub;function mb(e){var t=-1,r=null==e?0:e.length;for(this.clear();++t<r;){var n=e[t];this.set(n[0],n[1])}}mb.prototype.clear=lb,mb.prototype.delete=hb,mb.prototype.get=fb,mb.prototype.has=pb,mb.prototype.set=db;var vb=mb,yb=cy,bb=Dy,gb=vb;var wb=function(e,t){var r=this.u;if(r instanceof yb){var n=r.u;if(!bb||n.length<199)return n.push([e,t]),this.size=++r.size,this;r=this.u=new gb(n)}return r.set(e,t),this.size=r.size,this},xb=cy,jb=uy,Eb=ly,$b=hy,Ob=fy,Sb=wb;function Ab(e){var t=this.u=new xb(e);this.size=t.size}Ab.prototype.clear=jb,Ab.prototype.delete=Eb,Ab.prototype.get=$b,Ab.prototype.has=Ob,Ab.prototype.set=Sb;var Pb=Ab;var Tb=vb,kb=function(e){return this.u.set(e,"__lodash_hash_undefined__"),this},Fb=function(e){return this.u.has(e)};function Ib(e){var t=-1,r=null==e?0:e.length;for(this.u=new Tb;++t<r;)this.add(e[t])}Ib.prototype.add=Ib.prototype.push=kb,Ib.prototype.has=Fb;var Rb=function(e,t){for(var r=-1,n=null==e?0:e.length;++r<n;)if(t(e[r],r,e))return!0;return!1};var Db=Ib,_b=Rb,Cb=function(e,t){return e.has(t)};var Mb=function(e,t,r,n,s,i){var o=1&r,c=e.length,a=t.length;if(c!=a&&!(o&&a>c))return!1;var u=i.get(e),l=i.get(t);if(u&&l)return u==t&&l==e;var h=-1,f=!0,p=2&r?new Db:void 0;for(i.set(e,t),i.set(t,e);++h<c;){var d=e[h],m=t[h];if(n)var v=o?n(m,d,h,t,e,i):n(d,m,h,e,t,i);if(void 0!==v){if(v)continue;f=!1;break}if(p){if(!_b(t,(function(e,t){if(!Cb(p,t)&&(d===e||s(d,e,r,n,i)))return p.push(t)}))){f=!1;break}}else if(d!==m&&!s(d,m,r,n,i)){f=!1;break}}return i.delete(e),i.delete(t),f};var Nb=function(e){var t=-1,r=Array(e.size);return e.forEach((function(e,n){r[++t]=[n,e]})),r};var qb=function(e){var t=-1,r=Array(e.size);return e.forEach((function(e){r[++t]=e})),r},Bb=vv.Uint8Array,Lb=Vv,Ub=Mb,Jb=Nb,Vb=qb,Gb=yv?yv.prototype:void 0,Hb=Gb?Gb.valueOf:void 0;var zb=function(e,t,r,n,s,i,o){switch(r){case"[object DataView]":if(e.byteLength!=t.byteLength||e.byteOffset!=t.byteOffset)return!1;e=e.buffer,t=t.buffer;case"[object ArrayBuffer]":return!(e.byteLength!=t.byteLength||!i(new Bb(e),new Bb(t)));case"[object Boolean]":case"[object Date]":case"[object Number]":return Lb(+e,+t);case"[object Error]":return e.name==t.name&&e.message==t.message;case"[object RegExp]":case"[object String]":return e==t+"";case"[object Map]":var c=Jb;case"[object Set]":var a=1&n;if(c||(c=Vb),e.size!=t.size&&!a)return!1;var u=o.get(e);if(u)return u==t;n|=2,o.set(e,t);var l=Ub(c(e),c(t),n,s,i,o);return o.delete(e),l;case"[object Symbol]":if(Hb)return Hb.call(e)==Hb.call(t)}return!1};var Xb=function(e,t){for(var r=-1,n=t.length,s=e.length;++r<n;)e[s+r]=t[r];return e},Wb=Xb,Yb=Tv;var Zb=function(e,t,r){var n=t(e);return Yb(e)?n:Wb(n,r(e))};var Kb=function(e,t){for(var r=-1,n=null==e?0:e.length,s=0,i=[];++r<n;){var o=e[r];t(o,r,e)&&(i[s++]=o)}return i};var Qb=Kb,eg=function(){return[]},tg=Object.prototype.propertyIsEnumerable,rg=Object.getOwnPropertySymbols,ng=rg?function(e){return null==e?[]:(e=Object(e),Qb(rg(e),(function(t){return tg.call(e,t)})))}:eg;var sg=function(e,t){for(var r=-1,n=Array(e);++r<e;)n[r]=t(r);return n},ig=Pv,og=kv;var cg=function(e){return og(e)&&"[object Arguments]"==ig(e)},ag=kv,ug=Object.prototype,lg=ug.hasOwnProperty,hg=ug.propertyIsEnumerable,fg=cg(function(){return arguments}())?cg:function(e){return ag(e)&&lg.call(e,"callee")&&!hg.call(e,"callee")},pg={exports:{}};var dg=function(){return!1};!function(e,t){var r=vv,n=dg,s=t&&!t.nodeType&&t,i=s&&e&&!e.nodeType&&e,o=i&&i.exports===s?r.Buffer:void 0,c=(o?o.isBuffer:void 0)||n;e.exports=c}(pg,pg.exports);var mg=pg.exports,vg=/^(?:0|[1-9]\d*)$/;var yg=function(e,t){var r=typeof e;return!!(t=null==t?9007199254740991:t)&&("number"==r||"symbol"!=r&&vg.test(e))&&e>-1&&e%1==0&&e<t};var bg=function(e){return"number"==typeof e&&e>-1&&e%1==0&&e<=9007199254740991},gg=Pv,wg=bg,xg=kv,jg={};jg["[object Float32Array]"]=jg["[object Float64Array]"]=jg["[object Int8Array]"]=jg["[object Int16Array]"]=jg["[object Int32Array]"]=jg["[object Uint8Array]"]=jg["[object Uint8ClampedArray]"]=jg["[object Uint16Array]"]=jg["[object Uint32Array]"]=!0,jg["[object Arguments]"]=jg["[object Array]"]=jg["[object ArrayBuffer]"]=jg["[object Boolean]"]=jg["[object DataView]"]=jg["[object Date]"]=jg["[object Error]"]=jg["[object Function]"]=jg["[object Map]"]=jg["[object Number]"]=jg["[object Object]"]=jg["[object RegExp]"]=jg["[object Set]"]=jg["[object String]"]=jg["[object WeakMap]"]=!1;var Eg=function(e){return xg(e)&&wg(e.length)&&!!jg[gg(e)]};var $g=function(e){return function(t){return e(t)}},Og={exports:{}};!function(e,t){var r=pv,n=t&&!t.nodeType&&t,s=n&&e&&!e.nodeType&&e,i=s&&s.exports===n&&r.process,o=function(){try{var e=s&&s.require&&s.require("util").types;return e||i&&i.binding&&i.binding("util")}catch(e){}}();e.exports=o}(Og,Og.exports);var Sg=Og.exports,Ag=Eg,Pg=$g,Tg=Sg&&Sg.isTypedArray,kg=Tg?Pg(Tg):Ag,Fg=sg,Ig=fg,Rg=Tv,Dg=mg,_g=yg,Cg=kg,Mg=Object.prototype.hasOwnProperty;var Ng=function(e,t){var r=Rg(e),n=!r&&Ig(e),s=!r&&!n&&Dg(e),i=!r&&!n&&!s&&Cg(e),o=r||n||s||i,c=o?Fg(e.length,String):[],a=c.length;for(var u in e)!t&&!Mg.call(e,u)||o&&("length"==u||s&&("offset"==u||"parent"==u)||i&&("buffer"==u||"byteLength"==u||"byteOffset"==u)||_g(u,a))||c.push(u);return c},qg=Object.prototype;var Bg=function(e){var t=e&&e.constructor;return e===("function"==typeof t&&t.prototype||qg)};var Lg=function(e,t){return function(r){return e(t(r))}}(Object.keys,Object),Ug=Bg,Jg=Lg,Vg=Object.prototype.hasOwnProperty;var Gg=my,Hg=bg;var zg=Ng,Xg=function(e){if(!Ug(e))return Jg(e);var t=[];for(var r in Object(e))Vg.call(e,r)&&"constructor"!=r&&t.push(r);return t},Wg=function(e){return null!=e&&Hg(e.length)&&!Gg(e)};var Yg=Zb,Zg=ng,Kg=function(e){return Wg(e)?zg(e):Xg(e)};var Qg=function(e){return Yg(e,Kg,Zg)},ew=Object.prototype.hasOwnProperty;var tw=function(e,t,r,n,s,i){var o=1&r,c=Qg(e),a=c.length;if(a!=Qg(t).length&&!o)return!1;for(var u=a;u--;){var l=c[u];if(!(o?l in t:ew.call(t,l)))return!1}var h=i.get(e),f=i.get(t);if(h&&f)return h==t&&f==e;var p=!0;i.set(e,t),i.set(t,e);for(var d=o;++u<a;){var m=e[l=c[u]],v=t[l];if(n)var y=o?n(v,m,l,t,e,i):n(m,v,l,e,t,i);if(!(void 0===y?m===v||s(m,v,r,n,i):y)){p=!1;break}d||(d="constructor"==l)}if(p&&!d){var b=e.constructor,g=t.constructor;b==g||!("constructor"in e)||!("constructor"in t)||"function"==typeof b&&b instanceof b&&"function"==typeof g&&g instanceof g||(p=!1)}return i.delete(e),i.delete(t),p},rw=Ry(vv,"DataView"),nw=Dy,sw=Ry(vv,"Promise"),iw=Ry(vv,"Set"),ow=Ry(vv,"WeakMap"),cw=Pv,aw=wy,uw=aw(rw),lw=aw(nw),hw=aw(sw),fw=aw(iw),pw=aw(ow),dw=cw;(rw&&"[object DataView]"!=dw(new rw(new ArrayBuffer(1)))||nw&&"[object Map]"!=dw(new nw)||sw&&"[object Promise]"!=dw(sw.resolve())||iw&&"[object Set]"!=dw(new iw)||ow&&"[object WeakMap]"!=dw(new ow))&&(dw=function(e){var t=cw(e),r="[object Object]"==t?e.constructor:void 0,n=r?aw(r):"";if(n)switch(n){case uw:return"[object DataView]";case lw:return"[object Map]";case hw:return"[object Promise]";case fw:return"[object Set]";case pw:return"[object WeakMap]"}return t});var mw=Pb,vw=Mb,yw=zb,bw=tw,gw=dw,ww=Tv,xw=mg,jw=kg,Ew="[object Object]",$w=Object.prototype.hasOwnProperty;var Ow=function(e,t,r,n,s,i){var o=ww(e),c=ww(t),a=o?"[object Array]":gw(e),u=c?"[object Array]":gw(t),l=(a="[object Arguments]"==a?Ew:a)==Ew,h=(u="[object Arguments]"==u?Ew:u)==Ew,f=a==u;if(f&&xw(e)){if(!xw(t))return!1;o=!0,l=!1}if(f&&!l)return i||(i=new mw),o||jw(e)?vw(e,t,r,n,s,i):yw(e,t,a,r,n,s,i);if(!(1&r)){var p=l&&$w.call(e,"__wrapped__"),d=h&&$w.call(t,"__wrapped__");if(p||d){var m=p?e.value():e,v=d?t.value():t;return i||(i=new mw),s(m,v,r,n,i)}}return!!f&&(i||(i=new mw),bw(e,t,r,n,s,i))},Sw=kv;var Aw=function e(t,r,n,s,i){return t===r||(null==t||null==r||!Sw(t)&&!Sw(r)?t!=t&&r!=r:Ow(t,r,n,s,e,i))},Pw=Aw;var Tw=function(e,t){return Pw(e,t)};var kw=class e{constructor(e,t){this.key=e,this.value=t}clone(){const t=new e;return this.key&&(t.key=this.key.clone()),this.value&&(t.value=this.value.clone()),t}};var Fw=function(e){if("function"!=typeof e)throw new TypeError("Expected a function");return function(){var t=arguments;switch(t.length){case 0:return!e.call(this);case 1:return!e.call(this,t[0]);case 2:return!e.call(this,t[0],t[1]);case 3:return!e.call(this,t[0],t[1],t[2])}return!e.apply(this,t)}};const Iw=Fw;function Rw(e){return"string"==typeof e?t=>t.element===e:e.constructor&&e.extend?t=>t instanceof e:e}let Dw=class e{constructor(e){this.elements=e||[]}toValue(){return this.elements.map((e=>e.toValue()))}map(e,t){return this.elements.map(e,t)}flatMap(e,t){return this.map(e,t).reduce(((e,t)=>e.concat(t)),[])}compactMap(e,t){const r=[];return this.forEach((n=>{const s=e.bind(t)(n);s&&r.push(s)})),r}filter(t,r){return t=Rw(t),new e(this.elements.filter(t,r))}reject(t,r){return t=Rw(t),new e(this.elements.filter(Iw(t),r))}find(e,t){return e=Rw(e),this.elements.find(e,t)}forEach(e,t){this.elements.forEach(e,t)}reduce(e,t){return this.elements.reduce(e,t)}includes(e){return this.elements.some((t=>t.equals(e)))}shift(){return this.elements.shift()}unshift(e){this.elements.unshift(this.refract(e))}push(e){return this.elements.push(this.refract(e)),this}add(e){this.push(e)}get(e){return this.elements[e]}getValue(e){const t=this.elements[e];if(t)return t.toValue()}get length(){return this.elements.length}get isEmpty(){return 0===this.elements.length}get first(){return this.elements[0]}};"undefined"!=typeof Symbol&&(Dw.prototype[Symbol.iterator]=function(){return this.elements[Symbol.iterator]()});var _w=Dw;const Cw=Tw,Mw=kw,Nw=_w;var qw=class e{constructor(e,t,r){t&&(this.meta=t),r&&(this.attributes=r),this.content=e}freeze(){Object.isFrozen(this)||(this._meta&&(this.meta.parent=this,this.meta.freeze()),this._attributes&&(this.attributes.parent=this,this.attributes.freeze()),this.children.forEach((e=>{e.parent=this,e.freeze()}),this),this.content&&Array.isArray(this.content)&&Object.freeze(this.content),Object.freeze(this))}primitive(){}clone(){const e=new this.constructor;return e.element=this.element,this.meta.length&&(e._meta=this.meta.clone()),this.attributes.length&&(e._attributes=this.attributes.clone()),this.content?this.content.clone?e.content=this.content.clone():Array.isArray(this.content)?e.content=this.content.map((e=>e.clone())):e.content=this.content:e.content=this.content,e}toValue(){return this.content instanceof e?this.content.toValue():this.content instanceof Mw?{key:this.content.key.toValue(),value:this.content.value?this.content.value.toValue():void 0}:this.content&&this.content.map?this.content.map((e=>e.toValue()),this):this.content}toRef(e){if(""===this.id.toValue())throw Error("Cannot create reference to an element that does not contain an ID");const t=new this.RefElement(this.id.toValue());return e&&(t.path=e),t}findRecursive(...e){if(arguments.length>1&&!this.isFrozen)throw new Error("Cannot find recursive with multiple element names without first freezing the element. Call `element.freeze()`");const t=e.pop();let r=new Nw;const n=(e,t)=>(e.push(t),e),s=(e,r)=>{r.element===t&&e.push(r);const i=r.findRecursive(t);return i&&i.reduce(n,e),r.content instanceof Mw&&(r.content.key&&s(e,r.content.key),r.content.value&&s(e,r.content.value)),e};return this.content&&(this.content.element&&s(r,this.content),Array.isArray(this.content)&&this.content.reduce(s,r)),e.isEmpty||(r=r.filter((t=>{let r=t.parents.map((e=>e.element));for(const t in e){const n=e[t],s=r.indexOf(n);if(-1===s)return!1;r=r.splice(0,s)}return!0}))),r}set(e){return this.content=e,this}equals(e){return Cw(this.toValue(),e)}getMetaProperty(e,t){if(!this.meta.hasKey(e)){if(this.isFrozen){const e=this.refract(t);return e.freeze(),e}this.meta.set(e,t)}return this.meta.get(e)}setMetaProperty(e,t){this.meta.set(e,t)}get element(){return this._storedElement||"element"}set element(e){this._storedElement=e}get content(){return this._content}set content(t){if(t instanceof e)this._content=t;else if(t instanceof Nw)this.content=t.elements;else if("string"==typeof t||"number"==typeof t||"boolean"==typeof t||"null"===t||null==t)this._content=t;else if(t instanceof Mw)this._content=t;else if(Array.isArray(t))this._content=t.map(this.refract);else{if("object"!=typeof t)throw new Error("Cannot set content to given value");this._content=Object.keys(t).map((e=>new this.MemberElement(e,t[e])))}}get meta(){if(!this._meta){if(this.isFrozen){const e=new this.ObjectElement;return e.freeze(),e}this._meta=new this.ObjectElement}return this._meta}set meta(e){e instanceof this.ObjectElement?this._meta=e:this.meta.set(e||{})}get attributes(){if(!this._attributes){if(this.isFrozen){const e=new this.ObjectElement;return e.freeze(),e}this._attributes=new this.ObjectElement}return this._attributes}set attributes(e){e instanceof this.ObjectElement?this._attributes=e:this.attributes.set(e||{})}get id(){return this.getMetaProperty("id","")}set id(e){this.setMetaProperty("id",e)}get classes(){return this.getMetaProperty("classes",[])}set classes(e){this.setMetaProperty("classes",e)}get title(){return this.getMetaProperty("title","")}set title(e){this.setMetaProperty("title",e)}get description(){return this.getMetaProperty("description","")}set description(e){this.setMetaProperty("description",e)}get links(){return this.getMetaProperty("links",[])}set links(e){this.setMetaProperty("links",e)}get isFrozen(){return Object.isFrozen(this)}get parents(){let{parent:e}=this;const t=new Nw;for(;e;)t.push(e),e=e.parent;return t}get children(){if(Array.isArray(this.content))return new Nw(this.content);if(this.content instanceof Mw){const e=new Nw([this.content.key]);return this.content.value&&e.push(this.content.value),e}return this.content instanceof e?new Nw([this.content]):new Nw}get recursiveChildren(){const e=new Nw;return this.children.forEach((t=>{e.push(t),t.recursiveChildren.forEach((t=>{e.push(t)}))})),e}};const Bw=qw;var Lw=class extends Bw{constructor(e,t,r){super(e||null,t,r),this.element="null"}primitive(){return"null"}set(){return new Error("Cannot set the value of null")}};const Uw=qw;const Jw=qw;const Vw=qw;const Gw=Fw,Hw=qw,zw=_w;let Xw=class extends Hw{constructor(e,t,r){super(e||[],t,r),this.element="array"}primitive(){return"array"}get(e){return this.content[e]}getValue(e){const t=this.get(e);if(t)return t.toValue()}getIndex(e){return this.content[e]}set(e,t){return this.content[e]=this.refract(t),this}remove(e){const t=this.content.splice(e,1);return t.length?t[0]:null}map(e,t){return this.content.map(e,t)}flatMap(e,t){return this.map(e,t).reduce(((e,t)=>e.concat(t)),[])}compactMap(e,t){const r=[];return this.forEach((n=>{const s=e.bind(t)(n);s&&r.push(s)})),r}filter(e,t){return new zw(this.content.filter(e,t))}reject(e,t){return this.filter(Gw(e),t)}reduce(e,t){let r,n;void 0!==t?(r=0,n=this.refract(t)):(r=1,n="object"===this.primitive()?this.first.value:this.first);for(let t=r;t<this.length;t+=1){const r=this.content[t];n="object"===this.primitive()?this.refract(e(n,r.value,r.key,r,this)):this.refract(e(n,r,t,this))}return n}forEach(e,t){this.content.forEach(((r,n)=>{e.bind(t)(r,this.refract(n))}))}shift(){return this.content.shift()}unshift(e){this.content.unshift(this.refract(e))}push(e){return this.content.push(this.refract(e)),this}add(e){this.push(e)}findElements(e,t){const r=t||{},n=!!r.recursive,s=void 0===r.results?[]:r.results;return this.forEach(((t,r,i)=>{n&&void 0!==t.findElements&&t.findElements(e,{results:s,recursive:n}),e(t,r,i)&&s.push(t)})),s}find(e){return new zw(this.findElements(e,{recursive:!0}))}findByElement(e){return this.find((t=>t.element===e))}findByClass(e){return this.find((t=>t.classes.includes(e)))}getById(e){return this.find((t=>t.id.toValue()===e)).first}includes(e){return this.content.some((t=>t.equals(e)))}contains(e){return this.includes(e)}empty(){return new this.constructor([])}"fantasy-land/empty"(){return this.empty()}concat(e){return new this.constructor(this.content.concat(e.content))}"fantasy-land/concat"(e){return this.concat(e)}"fantasy-land/map"(e){return new this.constructor(this.map(e))}"fantasy-land/chain"(e){return this.map((t=>e(t)),this).reduce(((e,t)=>e.concat(t)),this.empty())}"fantasy-land/filter"(e){return new this.constructor(this.content.filter(e))}"fantasy-land/reduce"(e,t){return this.content.reduce(e,t)}get length(){return this.content.length}get isEmpty(){return 0===this.content.length}get first(){return this.getIndex(0)}get second(){return this.getIndex(1)}get last(){return this.getIndex(this.length-1)}};Xw.empty=function(){return new this},Xw["fantasy-land/empty"]=Xw.empty,"undefined"!=typeof Symbol&&(Xw.prototype[Symbol.iterator]=function(){return this.content[Symbol.iterator]()});var Ww=Xw;const Yw=kw,Zw=qw;var Kw=class extends Zw{constructor(e,t,r,n){super(new Yw,r,n),this.element="member",this.key=e,this.value=t}get key(){return this.content.key}set key(e){this.content.key=this.refract(e)}get value(){return this.content.value}set value(e){this.content.value=this.refract(e)}};const Qw=Fw,ex=_w;var tx=class e extends ex{map(e,t){return this.elements.map((r=>e.bind(t)(r.value,r.key,r)))}filter(t,r){return new e(this.elements.filter((e=>t.bind(r)(e.value,e.key,e))))}reject(e,t){return this.filter(Qw(e.bind(t)))}forEach(e,t){return this.elements.forEach(((r,n)=>{e.bind(t)(r.value,r.key,r,n)}))}keys(){return this.map(((e,t)=>t.toValue()))}values(){return this.map((e=>e.toValue()))}};const rx=Fw,nx=Lv,sx=Ww,ix=Kw,ox=tx;var cx=class extends sx{constructor(e,t,r){super(e||[],t,r),this.element="object"}primitive(){return"object"}toValue(){return this.content.reduce(((e,t)=>(e[t.key.toValue()]=t.value?t.value.toValue():void 0,e)),{})}get(e){const t=this.getMember(e);if(t)return t.value}getMember(e){if(void 0!==e)return this.content.find((t=>t.key.toValue()===e))}remove(e){let t=null;return this.content=this.content.filter((r=>r.key.toValue()!==e||(t=r,!1))),t}getKey(e){const t=this.getMember(e);if(t)return t.key}set(e,t){if(nx(e))return Object.keys(e).forEach((t=>{this.set(t,e[t])})),this;const r=e,n=this.getMember(r);return n?n.value=t:this.content.push(new ix(r,t)),this}keys(){return this.content.map((e=>e.key.toValue()))}values(){return this.content.map((e=>e.value.toValue()))}hasKey(e){return this.content.some((t=>t.key.equals(e)))}items(){return this.content.map((e=>[e.key.toValue(),e.value.toValue()]))}map(e,t){return this.content.map((r=>e.bind(t)(r.value,r.key,r)))}compactMap(e,t){const r=[];return this.forEach(((n,s,i)=>{const o=e.bind(t)(n,s,i);o&&r.push(o)})),r}filter(e,t){return new ox(this.content).filter(e,t)}reject(e,t){return this.filter(rx(e),t)}forEach(e,t){return this.content.forEach((r=>e.bind(t)(r.value,r.key,r)))}};const ax=qw;const ux=qw;const lx=qw,hx=Lw,fx=class extends Uw{constructor(e,t,r){super(e,t,r),this.element="string"}primitive(){return"string"}get length(){return this.content.length}},px=class extends Jw{constructor(e,t,r){super(e,t,r),this.element="number"}primitive(){return"number"}},dx=class extends Vw{constructor(e,t,r){super(e,t,r),this.element="boolean"}primitive(){return"boolean"}},mx=Ww,vx=Kw,yx=cx,bx=class extends ax{constructor(e,t,r){super(e||[],t,r),this.element="link"}get relation(){return this.attributes.get("relation")}set relation(e){this.attributes.set("relation",e)}get href(){return this.attributes.get("href")}set href(e){this.attributes.set("href",e)}},gx=class extends ux{constructor(e,t,r){super(e||[],t,r),this.element="ref",this.path||(this.path="element")}get path(){return this.attributes.get("path")}set path(e){this.attributes.set("path",e)}},wx=_w,xx=tx,jx=kw;function Ex(e){if(e instanceof lx)return e;if("string"==typeof e)return new fx(e);if("number"==typeof e)return new px(e);if("boolean"==typeof e)return new dx(e);if(null===e)return new hx;if(Array.isArray(e))return new mx(e.map(Ex));if("object"==typeof e){return new yx(e)}return e}lx.prototype.ObjectElement=yx,lx.prototype.RefElement=gx,lx.prototype.MemberElement=vx,lx.prototype.refract=Ex,wx.prototype.refract=Ex;var $x={Element:lx,NullElement:hx,StringElement:fx,NumberElement:px,BooleanElement:dx,ArrayElement:mx,MemberElement:vx,ObjectElement:yx,LinkElement:bx,RefElement:gx,refract:Ex,ArraySlice:wx,ObjectSlice:xx,KeyValuePair:jx};const Ox=fv,Sx=Dv,Ax=Mv,Px=Bv,Tx=Lv,kx=Uv,Fx=$x;let Ix=class{constructor(e){this.elementMap={},this.elementDetection=[],this.Element=Fx.Element,this.KeyValuePair=Fx.KeyValuePair,e&&e.noDefault||this.useDefault(),this._attributeElementKeys=[],this._attributeElementArrayKeys=[]}use(e){return e.namespace&&e.namespace({base:this}),e.load&&e.load({base:this}),this}useDefault(){return this.register("null",Fx.NullElement).register("string",Fx.StringElement).register("number",Fx.NumberElement).register("boolean",Fx.BooleanElement).register("array",Fx.ArrayElement).register("object",Fx.ObjectElement).register("member",Fx.MemberElement).register("ref",Fx.RefElement).register("link",Fx.LinkElement),this.detect(Ox,Fx.NullElement,!1).detect(Sx,Fx.StringElement,!1).detect(Ax,Fx.NumberElement,!1).detect(Px,Fx.BooleanElement,!1).detect(Array.isArray,Fx.ArrayElement,!1).detect(Tx,Fx.ObjectElement,!1),this}register(e,t){return this._elements=void 0,this.elementMap[e]=t,this}unregister(e){return this._elements=void 0,delete this.elementMap[e],this}detect(e,t,r){return void 0===r||r?this.elementDetection.unshift([e,t]):this.elementDetection.push([e,t]),this}toElement(e){if(e instanceof this.Element)return e;let t;for(let r=0;r<this.elementDetection.length;r+=1){const n=this.elementDetection[r][0],s=this.elementDetection[r][1];if(n(e)){t=new s(e);break}}return t}getElementClass(e){const t=this.elementMap[e];return void 0===t?this.Element:t}fromRefract(e){return this.serialiser.deserialise(e)}toRefract(e){return this.serialiser.serialise(e)}get elements(){return void 0===this._elements&&(this._elements={Element:this.Element},Object.keys(this.elementMap).forEach((e=>{const t=e[0].toUpperCase()+e.substr(1);this._elements[t]=this.elementMap[e]}))),this._elements}get serialiser(){return new kx(this)}};kx.prototype.Namespace=Ix;var Rx=Ix,Dx=kw,_x=$x.ArraySlice,Cx=$x.ObjectSlice,Mx=$x.Element,Nx=$x.StringElement,qx=$x.NumberElement,Bx=$x.BooleanElement,Lx=$x.NullElement,Ux=$x.ArrayElement,Jx=$x.ObjectElement,Vx=$x.MemberElement,Gx=$x.RefElement,Hx=$x.LinkElement,zx=$x.refract;class Xx extends Nx{constructor(e,t,r){super(e,t,r),this.element="annotation"}get code(){return this.attributes.get("code")}set code(e){this.attributes.set("code",e)}}class Wx extends Nx{constructor(e,t,r){super(e,t,r),this.element="comment"}}class Yx extends Ux{constructor(e,t,r){super(e,t,r),this.element="parseResult"}get api(){return this.children.filter((e=>e.classes.contains("api"))).first}get results(){return this.children.filter((e=>e.classes.contains("result")))}get result(){return this.results.first}get annotations(){return this.children.filter((e=>"annotation"===e.element))}get warnings(){return this.children.filter((e=>"annotation"===e.element&&e.classes.contains("warning")))}get errors(){return this.children.filter((e=>"annotation"===e.element&&e.classes.contains("error")))}get isEmpty(){return this.children.reject((e=>"annotation"===e.element)).isEmpty}replaceResult(e){const{result:t}=this;if(Id(t))return!1;const r=this.content.findIndex((e=>e===t));return-1!==r&&(this.content[r]=e,!0)}}class Zx extends Ux{constructor(e,t,r){super(e,t,r),this.element="sourceMap"}get positionStart(){return this.children.filter((e=>e.classes.contains("position"))).get(0)}get positionEnd(){return this.children.filter((e=>e.classes.contains("position"))).get(1)}set position(e){if(void 0===e)return;const t=new Ux([e.start.row,e.start.column,e.start.char]),r=new Ux([e.end.row,e.end.column,e.end.char]);t.classes.push("position"),r.classes.push("position"),this.push(t).push(r)}}const Kx=(e,t)=>"object"==typeof t&&null!==t&&e in t&&"function"==typeof t[e],Qx=e=>"object"==typeof e&&null!=e&&"_storedElement"in e&&"string"==typeof e._storedElement&&"_content"in e,ej=(e,t)=>"object"==typeof t&&null!==t&&"primitive"in t&&("function"==typeof t.primitive&&t.primitive()===e),tj=(e,t)=>"object"==typeof t&&null!==t&&"classes"in t&&(Array.isArray(t.classes)||t.classes instanceof Ux)&&t.classes.includes(e),rj=(e,t)=>"object"==typeof t&&null!==t&&"element"in t&&t.element===e,nj=e=>e({hasMethod:Kx,hasBasicElementProps:Qx,primitiveEq:ej,isElementType:rj,hasClass:tj}),sj=nj((({hasBasicElementProps:e,primitiveEq:t})=>r=>r instanceof Mx||e(r)&&t(void 0,r))),ij=nj((({hasBasicElementProps:e,primitiveEq:t})=>r=>r instanceof Nx||e(r)&&t("string",r))),oj=nj((({hasBasicElementProps:e,primitiveEq:t})=>r=>r instanceof qx||e(r)&&t("number",r))),cj=nj((({hasBasicElementProps:e,primitiveEq:t})=>r=>r instanceof Lx||e(r)&&t("null",r))),aj=nj((({hasBasicElementProps:e,primitiveEq:t})=>r=>r instanceof Bx||e(r)&&t("boolean",r))),uj=nj((({hasBasicElementProps:e,primitiveEq:t,hasMethod:r})=>n=>n instanceof Jx||e(n)&&t("object",n)&&r("keys",n)&&r("values",n)&&r("items",n))),lj=nj((({hasBasicElementProps:e,primitiveEq:t,hasMethod:r})=>n=>n instanceof Ux&&!(n instanceof Jx)||e(n)&&t("array",n)&&r("push",n)&&r("unshift",n)&&r("map",n)&&r("reduce",n))),hj=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof Vx||e(n)&&t("member",n)&&r(void 0,n))),fj=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof Hx||e(n)&&t("link",n)&&r(void 0,n))),pj=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof Gx||e(n)&&t("ref",n)&&r(void 0,n))),dj=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof Xx||e(n)&&t("annotation",n)&&r("array",n))),mj=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof Wx||e(n)&&t("comment",n)&&r("string",n))),vj=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof Yx||e(n)&&t("parseResult",n)&&r("array",n))),yj=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof Zx||e(n)&&t("sourceMap",n)&&r("array",n))),bj=e=>rj("object",e)||rj("array",e)||rj("boolean",e)||rj("number",e)||rj("string",e)||rj("null",e)||rj("member",e),gj=e=>yj(e.meta.get("sourceMap")),wj=(e,t)=>0===e.length||Kh(dm(t.classes.toValue()),e),xj=Object.freeze(Object.defineProperty({__proto__:null,hasElementSourceMap:gj,includesClasses:wj,includesSymbols:(e,t)=>{if(0===e.length)return!0;const r=t.attributes.get("symbols");return!!lj(r)&&Kh(dm(r.toValue()),e)},isAnnotationElement:dj,isArrayElement:lj,isBooleanElement:aj,isCommentElement:mj,isElement:sj,isLinkElement:fj,isMemberElement:hj,isNullElement:cj,isNumberElement:oj,isObjectElement:uj,isParseResultElement:vj,isPrimitiveElement:bj,isRefElement:pj,isSourceMapElement:yj,isStringElement:ij},Symbol.toStringTag,{value:"Module"}));class jj extends Rx{constructor(){super(),this.register("annotation",Xx),this.register("comment",Wx),this.register("parseResult",Yx),this.register("sourceMap",Zx)}}const Ej=new jj,$j=e=>{const t=new jj;return em(e)&&t.use(e),t},Oj=()=>({predicates:{...xj},namespace:Ej}),Sj=(e,t,r)=>{const n=e[t];if(null!=n){if(!r&&"function"==typeof n)return n;const e=r?n.leave:n.enter;if("function"==typeof e)return e}else{const n=r?e.leave:e.enter;if(null!=n){if("function"==typeof n)return n;const e=n[t];if("function"==typeof e)return e}}return null},Aj={},Pj=e=>null==e?void 0:e.type,Tj=e=>"string"==typeof Pj(e),kj=e=>Object.create(Object.getPrototypeOf(e),Object.getOwnPropertyDescriptors(e)),Fj=(e,{visitFnGetter:t=Sj,nodeTypeGetter:r=Pj,breakSymbol:n=Aj,deleteNodeSymbol:s=null,skipVisitingNodeSymbol:i=!1,exposeEdits:o=!1}={})=>{const c=Symbol("skip"),a=new Array(e.length).fill(c);return{enter(u,l,h,f,p,d){let m=u,v=!1;const y={...d,replaceWith(e,t){d.replaceWith(e,t),m=e}};for(let u=0;u<e.length;u+=1)if(a[u]===c){const c=t(e[u],r(m),!1);if("function"==typeof c){const t=c.call(e[u],m,l,h,f,p,y);if("function"==typeof(null==t?void 0:t.then))throw new Ih("Async visitor not supported in sync mode",{visitor:e[u],visitFn:c});if(t===i)a[u]=m;else if(t===n)a[u]=n;else{if(t===s)return t;if(void 0!==t){if(!o)return t;m=t,v=!0}}}}return v?m:void 0},leave(s,o,u,l,h,f){let p=s;const d={...f,replaceWith(e,t){f.replaceWith(e,t),p=e}};for(let s=0;s<e.length;s+=1)if(a[s]===c){const c=t(e[s],r(p),!0);if("function"==typeof c){const t=c.call(e[s],p,o,u,l,h,d);if("function"==typeof(null==t?void 0:t.then))throw new Ih("Async visitor not supported in sync mode",{visitor:e[s],visitFn:c});if(t===n)a[s]=n;else if(void 0!==t&&t!==i)return t}}else a[s]===p&&(a[s]=c)}}};Fj[Symbol.for("nodejs.util.promisify.custom")]=(e,{visitFnGetter:t=Sj,nodeTypeGetter:r=Pj,breakSymbol:n=Aj,deleteNodeSymbol:s=null,skipVisitingNodeSymbol:i=!1,exposeEdits:o=!1}={})=>{const c=Symbol("skip"),a=new Array(e.length).fill(c);return{async enter(u,l,h,f,p,d){let m=u,v=!1;const y={...d,replaceWith(e,t){d.replaceWith(e,t),m=e}};for(let u=0;u<e.length;u+=1)if(a[u]===c){const c=t(e[u],r(m),!1);if("function"==typeof c){const t=await c.call(e[u],m,l,h,f,p,y);if(t===i)a[u]=m;else if(t===n)a[u]=n;else{if(t===s)return t;if(void 0!==t){if(!o)return t;m=t,v=!0}}}}return v?m:void 0},async leave(s,o,u,l,h,f){let p=s;const d={...f,replaceWith(e,t){f.replaceWith(e,t),p=e}};for(let s=0;s<e.length;s+=1)if(a[s]===c){const c=t(e[s],r(p),!0);if("function"==typeof c){const t=await c.call(e[s],p,o,u,l,h,d);if(t===n)a[s]=n;else if(void 0!==t&&t!==i)return t}}else a[s]===p&&(a[s]=c)}}};const Ij=(e,t,{keyMap:r=null,state:n={},breakSymbol:s=Aj,deleteNodeSymbol:i=null,skipVisitingNodeSymbol:o=!1,visitFnGetter:c=Sj,nodeTypeGetter:a=Pj,nodePredicate:u=Tj,nodeCloneFn:l=kj,detectCycles:h=!0}={})=>{const f=r||{};let p,d,m=Array.isArray(e),v=[e],y=-1,b=[],g=e;const w=[],x=[];do{y+=1;const e=y===v.length;let r;const $=e&&0!==b.length;if(e){if(r=0===x.length?void 0:w.pop(),g=d,d=x.pop(),$)if(m){g=g.slice();let e=0;for(const[t,r]of b){const n=t-e;r===i?(g.splice(n,1),e+=1):g[n]=r}}else{g=l(g);for(const[e,t]of b)g[e]=t}y=p.index,v=p.keys,b=p.edits,m=p.inArray,p=p.prev}else if(d!==i&&void 0!==d){if(r=m?y:v[y],g=d[r],g===i||void 0===g)continue;w.push(r)}let O;if(!Array.isArray(g)){var j;if(!u(g))throw new Ih(`Invalid AST Node:  ${String(g)}`,{node:g});if(h&&x.includes(g)){w.pop();continue}const i=c(t,a(g),e);if(i){for(const[e,r]of Object.entries(n))t[e]=r;const s={replaceWith(t,n){"function"==typeof n?n(t,g,r,d,w,x):d&&(d[r]=t),e||(g=t)}};O=i.call(t,g,r,d,w,x,s)}if("function"==typeof(null===(j=O)||void 0===j?void 0:j.then))throw new Ih("Async visitor not supported in sync mode",{visitor:t,visitFn:i});if(O===s)break;if(O===o){if(!e){w.pop();continue}}else if(void 0!==O&&(b.push([r,O]),!e)){if(!u(O)){w.pop();continue}g=O}}var E;if(void 0===O&&$&&b.push([r,g]),!e)p={inArray:m,index:y,keys:v,edits:b,prev:p},m=Array.isArray(g),v=m?g:null!==(E=f[a(g)])&&void 0!==E?E:[],y=-1,b=[],d!==i&&void 0!==d&&x.push(d),d=g}while(void 0!==p);return 0!==b.length?b[b.length-1][1]:e};Ij[Symbol.for("nodejs.util.promisify.custom")]=async(e,t,{keyMap:r=null,state:n={},breakSymbol:s=Aj,deleteNodeSymbol:i=null,skipVisitingNodeSymbol:o=!1,visitFnGetter:c=Sj,nodeTypeGetter:a=Pj,nodePredicate:u=Tj,nodeCloneFn:l=kj,detectCycles:h=!0}={})=>{const f=r||{};let p,d,m=Array.isArray(e),v=[e],y=-1,b=[],g=e;const w=[],x=[];do{y+=1;const e=y===v.length;let r;const E=e&&0!==b.length;if(e){if(r=0===x.length?void 0:w.pop(),g=d,d=x.pop(),E)if(m){g=g.slice();let e=0;for(const[t,r]of b){const n=t-e;r===i?(g.splice(n,1),e+=1):g[n]=r}}else{g=l(g);for(const[e,t]of b)g[e]=t}y=p.index,v=p.keys,b=p.edits,m=p.inArray,p=p.prev}else if(d!==i&&void 0!==d){if(r=m?y:v[y],g=d[r],g===i||void 0===g)continue;w.push(r)}let $;if(!Array.isArray(g)){if(!u(g))throw new Ih(`Invalid AST Node: ${String(g)}`,{node:g});if(h&&x.includes(g)){w.pop();continue}const i=c(t,a(g),e);if(i){for(const[e,r]of Object.entries(n))t[e]=r;const s={replaceWith(t,n){"function"==typeof n?n(t,g,r,d,w,x):d&&(d[r]=t),e||(g=t)}};$=await i.call(t,g,r,d,w,x,s)}if($===s)break;if($===o){if(!e){w.pop();continue}}else if(void 0!==$&&(b.push([r,$]),!e)){if(!u($)){w.pop();continue}g=$}}var j;if(void 0===$&&E&&b.push([r,g]),!e)p={inArray:m,index:y,keys:v,edits:b,prev:p},m=Array.isArray(g),v=m?g:null!==(j=f[a(g)])&&void 0!==j?j:[],y=-1,b=[],d!==i&&void 0!==d&&x.push(d),d=g}while(void 0!==p);return 0!==b.length?b[b.length-1][1]:e};class Rj extends Ih{value;constructor(e,t){super(e,t),void 0!==t&&(this.value=t.value)}}class Dj extends Rj{}class _j extends Rj{}const Cj=(e,t={})=>{const{visited:r=new WeakMap}=t,n={...t,visited:r};if(r.has(e))return r.get(e);if(e instanceof Dx){const{key:t,value:s}=e,i=sj(t)?Cj(t,n):t,o=sj(s)?Cj(s,n):s,c=new Dx(i,o);return r.set(e,c),c}if(e instanceof Cx){const t=e=>Cj(e,n),s=[...e].map(t),i=new Cx(s);return r.set(e,i),i}if(e instanceof _x){const t=e=>Cj(e,n),s=[...e].map(t),i=new _x(s);return r.set(e,i),i}if(sj(e)){const t=qj(e);if(r.set(e,t),e.content)if(sj(e.content))t.content=Cj(e.content,n);else if(e.content instanceof Dx)t.content=Cj(e.content,n);else if(Array.isArray(e.content)){const r=e=>Cj(e,n);t.content=e.content.map(r)}else t.content=e.content;else t.content=e.content;return t}throw new Dj("Value provided to cloneDeep function couldn't be cloned",{value:e})};Cj.safe=e=>{try{return Cj(e)}catch{return e}};const Mj=e=>{const{key:t,value:r}=e;return new Dx(t,r)},Nj=e=>{const t=new e.constructor;if(t.element=e.element,e.meta.length>0&&(t._meta=Cj(e.meta)),e.attributes.length>0&&(t._attributes=Cj(e.attributes)),sj(e.content)){const r=e.content;t.content=Nj(r)}else Array.isArray(e.content)?t.content=[...e.content]:e.content instanceof Dx?t.content=Mj(e.content):t.content=e.content;return t},qj=e=>{if(e instanceof Dx)return Mj(e);if(e instanceof Cx)return(e=>{const t=[...e];return new Cx(t)})(e);if(e instanceof _x)return(e=>{const t=[...e];return new _x(t)})(e);if(sj(e))return Nj(e);throw new _j("Value provided to cloneShallow function couldn't be cloned",{value:e})};qj.safe=e=>{try{return qj(e)}catch{return e}};const Bj=e=>uj(e)?"ObjectElement":lj(e)?"ArrayElement":hj(e)?"MemberElement":ij(e)?"StringElement":aj(e)?"BooleanElement":oj(e)?"NumberElement":cj(e)?"NullElement":fj(e)?"LinkElement":pj(e)?"RefElement":void 0,Lj=e=>sj(e)?qj(e):kj(e),Uj=gp(Bj,Jd),Jj={ObjectElement:["content"],ArrayElement:["content"],MemberElement:["key","value"],StringElement:[],BooleanElement:[],NumberElement:[],NullElement:[],RefElement:[],LinkElement:[],Annotation:[],Comment:[],ParseResultElement:["content"],SourceMap:["content"]};class Vj{result;predicate;returnOnTrue;returnOnFalse;constructor({predicate:e=_h,returnOnTrue:t,returnOnFalse:r}={}){this.result=[],this.predicate=e,this.returnOnTrue=t,this.returnOnFalse=r}enter(e){return this.predicate(e)?(this.result.push(e),this.returnOnTrue):this.returnOnFalse}}const Gj=(e,t,{keyMap:r=Jj,...n}={})=>Ij(e,t,{keyMap:r,nodeTypeGetter:Bj,nodePredicate:Uj,nodeCloneFn:Lj,...n});Gj[Symbol.for("nodejs.util.promisify.custom")]=async(e,t,{keyMap:r=Jj,...n}={})=>Ij[Symbol.for("nodejs.util.promisify.custom")](e,t,{keyMap:r,nodeTypeGetter:Bj,nodePredicate:Uj,nodeCloneFn:Lj,...n});const Hj={toolboxCreator:Oj,visitorOptions:{nodeTypeGetter:Bj,exposeEdits:!0}},zj=(e,t,r={})=>{if(0===t.length)return e;const n=ud(Hj,r),{toolboxCreator:s,visitorOptions:i}=n,o=s(),c=t.map((e=>e(o))),a=Fj(c.map(bd({},"visitor")),{...i});c.forEach(mm(["pre"],[]));const u=Gj(e,a,i);return c.forEach(mm(["post"],[])),u};zj[Symbol.for("nodejs.util.promisify.custom")]=async(e,t,r={})=>{if(0===t.length)return e;const n=ud(Hj,r),{toolboxCreator:s,visitorOptions:i}=n,o=s(),c=t.map((e=>e(o))),a=Fj[Symbol.for("nodejs.util.promisify.custom")],u=Gj[Symbol.for("nodejs.util.promisify.custom")],l=a(c.map(bd({},"visitor")),{...i});await Promise.allSettled(c.map(mm(["pre"],[])));const h=await u(e,l,i);return await Promise.allSettled(c.map(mm(["post"],[]))),h};var Xj={exports:{}};!function(e){var t=(()=>{var e=Object.defineProperty,t=Object.getOwnPropertyDescriptor,r=Object.getOwnPropertyNames,n=Object.getOwnPropertySymbols,s=Object.prototype.hasOwnProperty,i=Object.prototype.propertyIsEnumerable,o=(t,r,n)=>r in t?e(t,r,{enumerable:!0,configurable:!0,writable:!0,value:n}):t[r]=n,c=(e,t)=>{for(var r in t||(t={}))s.call(t,r)&&o(e,r,t[r]);if(n)for(var r of n(t))i.call(t,r)&&o(e,r,t[r]);return e},a=(e,t,r)=>(o(e,"symbol"!=typeof t?t+"":t,r),r),u={};((t,r)=>{for(var n in r)e(t,n,{get:r[n],enumerable:!0})})(u,{DEFAULT_OPTIONS:()=>h,DEFAULT_UUID_LENGTH:()=>l,default:()=>p});var l=6,h={dictionary:"alphanum",shuffle:!0,debug:!1,length:l,counter:0},f=class{constructor(e={}){a(this,"counter"),a(this,"debug"),a(this,"dict"),a(this,"version"),a(this,"dictIndex",0),a(this,"dictRange",[]),a(this,"lowerBound",0),a(this,"upperBound",0),a(this,"dictLength",0),a(this,"uuidLength"),a(this,"_digit_first_ascii",48),a(this,"_digit_last_ascii",58),a(this,"_alpha_lower_first_ascii",97),a(this,"_alpha_lower_last_ascii",123),a(this,"_hex_last_ascii",103),a(this,"_alpha_upper_first_ascii",65),a(this,"_alpha_upper_last_ascii",91),a(this,"_number_dict_ranges",{digits:[this._digit_first_ascii,this._digit_last_ascii]}),a(this,"_alpha_dict_ranges",{lowerCase:[this._alpha_lower_first_ascii,this._alpha_lower_last_ascii],upperCase:[this._alpha_upper_first_ascii,this._alpha_upper_last_ascii]}),a(this,"_alpha_lower_dict_ranges",{lowerCase:[this._alpha_lower_first_ascii,this._alpha_lower_last_ascii]}),a(this,"_alpha_upper_dict_ranges",{upperCase:[this._alpha_upper_first_ascii,this._alpha_upper_last_ascii]}),a(this,"_alphanum_dict_ranges",{digits:[this._digit_first_ascii,this._digit_last_ascii],lowerCase:[this._alpha_lower_first_ascii,this._alpha_lower_last_ascii],upperCase:[this._alpha_upper_first_ascii,this._alpha_upper_last_ascii]}),a(this,"_alphanum_lower_dict_ranges",{digits:[this._digit_first_ascii,this._digit_last_ascii],lowerCase:[this._alpha_lower_first_ascii,this._alpha_lower_last_ascii]}),a(this,"_alphanum_upper_dict_ranges",{digits:[this._digit_first_ascii,this._digit_last_ascii],upperCase:[this._alpha_upper_first_ascii,this._alpha_upper_last_ascii]}),a(this,"_hex_dict_ranges",{decDigits:[this._digit_first_ascii,this._digit_last_ascii],alphaDigits:[this._alpha_lower_first_ascii,this._hex_last_ascii]}),a(this,"_dict_ranges",{_number_dict_ranges:this._number_dict_ranges,_alpha_dict_ranges:this._alpha_dict_ranges,_alpha_lower_dict_ranges:this._alpha_lower_dict_ranges,_alpha_upper_dict_ranges:this._alpha_upper_dict_ranges,_alphanum_dict_ranges:this._alphanum_dict_ranges,_alphanum_lower_dict_ranges:this._alphanum_lower_dict_ranges,_alphanum_upper_dict_ranges:this._alphanum_upper_dict_ranges,_hex_dict_ranges:this._hex_dict_ranges}),a(this,"log",((...e)=>{const t=[...e];if(t[0]=`[short-unique-id] ${e[0]}`,!0===this.debug&&"undefined"!=typeof console&&null!==console)return console.log(...t)})),a(this,"_normalizeDictionary",((e,t)=>{let r;if(e&&Array.isArray(e)&&e.length>1)r=e;else{let t;r=[],this.dictIndex=t=0;const n=`_${e}_dict_ranges`,s=this._dict_ranges[n];Object.keys(s).forEach((e=>{const n=e;for(this.dictRange=s[n],this.lowerBound=this.dictRange[0],this.upperBound=this.dictRange[1],this.dictIndex=t=this.lowerBound;this.lowerBound<=this.upperBound?t<this.upperBound:t>this.upperBound;this.dictIndex=this.lowerBound<=this.upperBound?t+=1:t-=1)r.push(String.fromCharCode(this.dictIndex))}))}if(t){const e=.5;r=r.sort((()=>Math.random()-e))}return r})),a(this,"setDictionary",((e,t)=>{this.dict=this._normalizeDictionary(e,t),this.dictLength=this.dict.length,this.setCounter(0)})),a(this,"seq",(()=>this.sequentialUUID())),a(this,"sequentialUUID",(()=>{let e,t,r="";e=this.counter;do{t=e%this.dictLength,e=Math.trunc(e/this.dictLength),r+=this.dict[t]}while(0!==e);return this.counter+=1,r})),a(this,"rnd",((e=this.uuidLength||l)=>this.randomUUID(e))),a(this,"randomUUID",((e=this.uuidLength||l)=>{let t,r,n;if(null==e||e<1)throw new Error("Invalid UUID Length Provided");for(t="",n=0;n<e;n+=1)r=parseInt((Math.random()*this.dictLength).toFixed(0),10)%this.dictLength,t+=this.dict[r];return t})),a(this,"fmt",((e,t)=>this.formattedUUID(e,t))),a(this,"formattedUUID",((e,t)=>{const r={$r:this.randomUUID,$s:this.sequentialUUID,$t:this.stamp};return e.replace(/\$[rs]\d{0,}|\$t0|\$t[1-9]\d{1,}/g,(e=>{const n=e.slice(0,2),s=parseInt(e.slice(2),10);return"$s"===n?r[n]().padStart(s,"0"):"$t"===n&&t?r[n](s,t):r[n](s)}))})),a(this,"availableUUIDs",((e=this.uuidLength)=>parseFloat(Math.pow([...new Set(this.dict)].length,e).toFixed(0)))),a(this,"approxMaxBeforeCollision",((e=this.availableUUIDs(this.uuidLength))=>parseFloat(Math.sqrt(Math.PI/2*e).toFixed(20)))),a(this,"collisionProbability",((e=this.availableUUIDs(this.uuidLength),t=this.uuidLength)=>parseFloat((this.approxMaxBeforeCollision(e)/this.availableUUIDs(t)).toFixed(20)))),a(this,"uniqueness",((e=this.availableUUIDs(this.uuidLength))=>{const t=parseFloat((1-this.approxMaxBeforeCollision(e)/e).toFixed(20));return t>1?1:t<0?0:t})),a(this,"getVersion",(()=>this.version)),a(this,"stamp",((e,t)=>{const r=Math.floor(+(t||new Date)/1e3).toString(16);if("number"==typeof e&&0===e)return r;if("number"!=typeof e||e<10)throw new Error(["Param finalLength must be a number greater than or equal to 10,","or 0 if you want the raw hexadecimal timestamp"].join("\n"));const n=e-9,s=Math.round(Math.random()*(n>15?15:n)),i=this.randomUUID(n);return`${i.substring(0,s)}${r}${i.substring(s)}${s.toString(16)}`})),a(this,"parseStamp",((e,t)=>{if(t&&!/t0|t[1-9]\d{1,}/.test(t))throw new Error("Cannot extract date from a formated UUID with no timestamp in the format");const r=t?t.replace(/\$[rs]\d{0,}|\$t0|\$t[1-9]\d{1,}/g,(e=>{const t={$r:e=>[...Array(e)].map((()=>"r")).join(""),$s:e=>[...Array(e)].map((()=>"s")).join(""),$t:e=>[...Array(e)].map((()=>"t")).join("")},r=e.slice(0,2),n=parseInt(e.slice(2),10);return t[r](n)})).replace(/^(.*?)(t{8,})(.*)$/g,((t,r,n)=>e.substring(r.length,r.length+n.length))):e;if(8===r.length)return new Date(1e3*parseInt(r,16));if(r.length<10)throw new Error("Stamp length invalid");const n=parseInt(r.substring(r.length-1),16);return new Date(1e3*parseInt(r.substring(n,n+8),16))})),a(this,"setCounter",(e=>{this.counter=e})),a(this,"validate",((e,t)=>{const r=t?this._normalizeDictionary(t):this.dict;return e.split("").every((e=>r.includes(e)))}));const t=c(c({},h),e);this.counter=0,this.debug=!1,this.dict=[],this.version="5.2.0";const{dictionary:r,shuffle:n,length:s,counter:i}=t;return this.uuidLength=s,this.setDictionary(r,n),this.setCounter(i),this.debug=t.debug,this.log(this.dict),this.log(`Generator instantiated with Dictionary Size ${this.dictLength} and counter set to ${this.counter}`),this.log=this.log.bind(this),this.setDictionary=this.setDictionary.bind(this),this.setCounter=this.setCounter.bind(this),this.seq=this.seq.bind(this),this.sequentialUUID=this.sequentialUUID.bind(this),this.rnd=this.rnd.bind(this),this.randomUUID=this.randomUUID.bind(this),this.fmt=this.fmt.bind(this),this.formattedUUID=this.formattedUUID.bind(this),this.availableUUIDs=this.availableUUIDs.bind(this),this.approxMaxBeforeCollision=this.approxMaxBeforeCollision.bind(this),this.collisionProbability=this.collisionProbability.bind(this),this.uniqueness=this.uniqueness.bind(this),this.getVersion=this.getVersion.bind(this),this.stamp=this.stamp.bind(this),this.parseStamp=this.parseStamp.bind(this),this}};a(f,"default",f);var p=f;return(n=>((n,i,o,c)=>{if(i&&"object"==typeof i||"function"==typeof i)for(let a of r(i))s.call(n,a)||a===o||e(n,a,{get:()=>i[a],enumerable:!(c=t(i,a))||c.enumerable});return n})(e({},"__esModule",{value:!0}),n))(u)})();e.exports=t.default,"undefined"!=typeof window&&(t=t.default)}(Xj);const Wj=dr(Xj.exports);class Yj extends Ih{value;constructor(e,t){super(e,t),void 0!==t&&(this.value=t.value)}}class Zj{uuid;identityMap;constructor({length:e=6}={}){this.uuid=new Wj({length:e}),this.identityMap=new WeakMap}identify(e){if(!sj(e))throw new Yj("Cannot not identify the element. `element` is neither structurally compatible nor a subclass of an Element class.",{value:e});if(e.meta.hasKey("id")&&ij(e.meta.get("id"))&&!e.meta.get("id").equals(""))return e.id;if(this.identityMap.has(e))return this.identityMap.get(e);const t=new Nx(this.generateId());return this.identityMap.set(e,t),t}forget(e){return!!this.identityMap.has(e)&&(this.identityMap.delete(e),!0)}generateId(){return this.uuid.randomUUID()}}new Zj;class Kj extends Array{unknownMediaType="application/octet-stream";filterByFormat(){throw new Dh("filterByFormat method in MediaTypes class is not yet implemented.")}findBy(){throw new Dh("findBy method in MediaTypes class is not yet implemented.")}latest(){throw new Dh("latest method in MediaTypes class is not yet implemented.")}}const Qj=e=>(t,r={})=>((e,{Type:t,plugins:r=[]})=>{const n=new t(e);return sj(e)&&(e.meta.length>0&&(n.meta=Cj(e.meta)),e.attributes.length>0&&(n.attributes=Cj(e.attributes))),zj(n,r,{toolboxCreator:Oj,visitorOptions:{nodeTypeGetter:Bj}})})(t,{...r,Type:e});Jx.refract=Qj(Jx),Ux.refract=Qj(Ux),Nx.refract=Qj(Nx),Bx.refract=Qj(Bx),Lx.refract=Qj(Lx),qx.refract=Qj(qx),Hx.refract=Qj(Hx),Gx.refract=Qj(Gx),Xx.refract=Qj(Xx),Wx.refract=Qj(Wx),Yx.refract=Qj(Yx),Zx.refract=Qj(Zx);const eE=(e,t)=>{const r=new Vj({predicate:e,returnOnTrue:Aj});return Gj(t,r),dd(void 0,[0],r.result)},tE=e=>"string"==typeof(null==e?void 0:e.type)?e.type:Bj(e),rE={EphemeralObject:["content"],EphemeralArray:["content"],...Jj},nE=(e,t,{keyMap:r=rE,...n}={})=>Gj(e,t,{keyMap:r,nodeTypeGetter:tE,nodePredicate:Ch,detectCycles:!1,deleteNodeSymbol:Symbol.for("delete-node"),skipVisitingNodeSymbol:Symbol.for("skip-visiting-node"),...n});nE[Symbol.for("nodejs.util.promisify.custom")]=async(e,{keyMap:t=rE,...r}={})=>Gj[Symbol.for("nodejs.util.promisify.custom")](e,visitor,{keyMap:t,nodeTypeGetter:tE,nodePredicate:Ch,detectCycles:!1,deleteNodeSymbol:Symbol.for("delete-node"),skipVisitingNodeSymbol:Symbol.for("skip-visiting-node"),...r});class sE{type="EphemeralArray";content=[];reference=void 0;constructor(e){this.content=e,this.reference=[]}toReference(){return this.reference}toArray(){return this.reference.push(...this.content),this.reference}}class iE{type="EphemeralObject";content=[];reference=void 0;constructor(e){this.content=e,this.reference={}}toReference(){return this.reference}toObject(){return Object.assign(this.reference,Object.fromEntries(this.content))}}const oE=e=>sj(e)?ij(e)||oj(e)||aj(e)||cj(e)?e.toValue():nE(e,new class{ObjectElement={enter:e=>{if(this.references.has(e))return this.references.get(e).toReference();const t=new iE(e.content);return this.references.set(e,t),t}};EphemeralObject={leave:e=>e.toObject()};MemberElement={enter:e=>[e.key,e.value]};ArrayElement={enter:e=>{if(this.references.has(e))return this.references.get(e).toReference();const t=new sE(e.content);return this.references.set(e,t),t}};EphemeralArray={leave:e=>e.toArray()};references=new WeakMap;BooleanElement(e){return e.toValue()}NumberElement(e){return e.toValue()}StringElement(e){return e.toValue()}NullElement(){return null}RefElement(e,...t){var r;const n=t[3];return"EphemeralObject"===(null===(r=n[n.length-1])||void 0===r?void 0:r.type)?Symbol.for("delete-node"):String(e.toValue())}LinkElement(e){return ij(e.href)?e.href.toValue():""}}):e,cE=(e,t=new WeakMap)=>(hj(e)?(t.set(e.key,e),cE(e.key,t),t.set(e.value,e),cE(e.value,t)):e.children.forEach((r=>{t.set(r,e),cE(r,t)})),t);class aE{element;edges;constructor({element:e}){this.element=e}transclude(e,t){var r;if(e===this.element)return t;if(e===t)return this.element;this.edges=null!==(r=this.edges)&&void 0!==r?r:cE(this.element);const n=this.edges.get(e);return Id(n)?void 0:(uj(n)?((e,t,r)=>{const n=r.get(e);uj(n)&&(n.content=n.map(((s,i,o)=>o===e?(r.delete(e),r.set(t,n),t):o)))})(e,t,this.edges):lj(n)?((e,t,r)=>{const n=r.get(e);lj(n)&&(n.content=n.map((s=>s===e?(r.delete(e),r.set(t,n),t):s)))})(e,t,this.edges):hj(n)&&((e,t,r)=>{const n=r.get(e);hj(n)&&(n.key===e&&(n.key=t,r.delete(e),r.set(t,n)),n.value===e&&(n.value=t,r.delete(e),r.set(t,n)))})(e,t,this.edges),this.element)}}const uE=(e,t)=>{const r=Ap(e,t);return od((e=>{if(em(e)&&Xp("$ref",e)&&gd(Jd,"$ref",e)){const t=pd(["$ref"],e),n=jm("#/",t);return pd(n.split("/"),r)}return em(e)?uE(e,r):e}),e)},lE=(e,t=Ej)=>{if(Jd(e))try{return t.fromRefract(JSON.parse(e))}catch{}return em(e)&&Xp("element",e)?t.fromRefract(e):t.toElement(e)},hE=e=>{const t=e.meta.length>0?Cj(e.meta):void 0,r=e.attributes.length>0?Cj(e.attributes):void 0;return new e.constructor(void 0,t,r)},fE=(e,t)=>t.clone&&t.isMergeableElement(e)?dE(hE(e),e,t):e,pE={clone:!0,isMergeableElement:e=>uj(e)||lj(e),arrayElementMerge:(e,t,r)=>e.concat(t)["fantasy-land/map"]((e=>fE(e,r))),objectElementMerge:(e,t,r)=>{const n=uj(e)?hE(e):hE(t);return uj(e)&&e.forEach(((e,t,s)=>{const i=qj(s);i.value=fE(e,r),n.content.push(i)})),t.forEach(((t,s,i)=>{const o=oE(s);let c;if(uj(e)&&e.hasKey(o)&&r.isMergeableElement(t)){const n=e.get(o);c=qj(i),c.value=((e,t)=>{if("function"!=typeof t.customMerge)return dE;const r=t.customMerge(e,t);return"function"==typeof r?r:dE})(s,r)(n,t)}else c=qj(i),c.value=fE(t,r);n.remove(o),n.content.push(c)})),n},customMerge:void 0,customMetaMerge:void 0,customAttributesMerge:void 0};function dE(e,t,r){var n,s,i;const o={...pE,...r};o.isMergeableElement=null!==(n=o.isMergeableElement)&&void 0!==n?n:pE.isMergeableElement,o.arrayElementMerge=null!==(s=o.arrayElementMerge)&&void 0!==s?s:pE.arrayElementMerge,o.objectElementMerge=null!==(i=o.objectElementMerge)&&void 0!==i?i:pE.objectElementMerge;const c=lj(t);if(!(c===lj(e)))return fE(t,o);const a=c&&"function"==typeof o.arrayElementMerge?o.arrayElementMerge(e,t,o):o.objectElementMerge(e,t,o);return a.meta=(e=>"function"!=typeof e.customMetaMerge?e=>Cj(e):e.customMetaMerge)(o)(e.meta,t.meta),a.attributes=(e=>"function"!=typeof e.customAttributesMerge?e=>Cj(e):e.customAttributesMerge)(o)(e.attributes,t.attributes),a}dE.all=(e,t)=>{if(!Array.isArray(e))throw new TypeError("First argument of deepmerge should be an array.");return 0===e.length?new Jx:e.reduce(((e,r)=>dE(e,r,t)),hE(e[0]))};class mE extends Fh{}class vE extends mE{}let yE=class{name;allowEmpty;sourceMap;fileExtensions;mediaTypes;constructor({name:e,allowEmpty:t=!0,sourceMap:r=!1,fileExtensions:n=[],mediaTypes:s=[]}){this.name=e,this.allowEmpty=t,this.sourceMap=r,this.fileExtensions=n,this.mediaTypes=s}};class bE extends Array{includesCycle(e){return this.filter((t=>t.has(e))).length>1}includes(e,t){return e instanceof Set?super.includes(e,t):this.some((t=>t.has(e)))}findItem(e){for(const t of this)for(const r of t)if(sj(r)&&e(r))return r}}let gE=class{uri;depth;value;refSet;errors;constructor({uri:e,depth:t=0,refSet:r,value:n}){this.uri=e,this.value=n,this.depth=t,this.refSet=r,this.errors=[]}};class wE extends Fh{}class xE extends wE{}class jE extends Fh{}class EE extends jE{}class $E extends wE{constructor(e){super(`Invalid JSON Schema $anchor "${e}".`)}}class OE extends mE{}class SE extends av{}class AE extends cv{}const PE=async(e,t={})=>(async(e,t)=>{let r=e,n=!1;if(!vj(e)){const t=qj(e);t.classes.push("result"),r=new Yx([t]),n=!0}const s=new Km({uri:t.resolve.baseURI,parseResult:r,mediaType:t.parse.mediaType}),i=await iv("canDereference",[s,t],t.dereference.strategies);if(ed(i))throw new vE(s.uri);try{const{result:e}=await ov("dereference",[s,t],i);return n?e.get(0):e}catch(e){throw new mE(`Error while dereferencing file "${s.uri}"`,{cause:e})}})(e,nv(ev,t));function TE(e,t){(null==t||t>e.length)&&(t=e.length);for(var r=0,n=new Array(t);r<t;r++)n[r]=e[r];return n}function kE(e,t){if(!(e instanceof t))throw new TypeError("Cannot call a class as a function")}function FE(e,t,r){return t&&function(e,t){for(var r=0;r<t.length;r++){var n=t[r];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(e,n.key,n)}}(e.prototype,t),e}function IE(e,t){return null!=t&&"undefined"!=typeof Symbol&&t[Symbol.hasInstance]?!!t[Symbol.hasInstance](e):e instanceof t}function RE(e,t){return function(e){if(Array.isArray(e))return e}(e)||function(e,t){var r=null==e?null:"undefined"!=typeof Symbol&&e[Symbol.iterator]||e["@@iterator"];if(null!=r){var n,s,i=[],o=!0,c=!1;try{for(r=r.call(e);!(o=(n=r.next()).done)&&(i.push(n.value),!t||i.length!==t);o=!0);}catch(e){c=!0,s=e}finally{try{o||null==r.return||r.return()}finally{if(c)throw s}}return i}}(e,t)||function(e,t){if(!e)return;if("string"==typeof e)return TE(e,t);var r=Object.prototype.toString.call(e).slice(8,-1);"Object"===r&&e.constructor&&(r=e.constructor.name);if("Map"===r||"Set"===r)return Array.from(r);if("Arguments"===r||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(r))return TE(e,t)}(e,t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function DE(e){return e&&"undefined"!=typeof Symbol&&e.constructor===Symbol?"symbol":typeof e}var _E=function(e){throw TypeError(e)},CE=function(e,t,r){return t.has(e)||_E("Cannot "+r)},ME=function(e,t,r){return CE(e,t,"read from private field"),t.get(e)},NE=function(e,t,r){return t.has(e)?_E("Cannot add the same private member more than once"):IE(t,WeakSet)?t.add(e):t.set(e,r)},qE=function(e,t,r,n){return CE(e,t,"write to private field"),t.set(e,r),r},BE=function(e){return Object.prototype.toString.call(e)},LE=function(e){return ArrayBuffer.isView(e)&&!IE(e,DataView)},UE=Array.isArray,JE=Object.getOwnPropertyDescriptor,VE=Object.prototype.propertyIsEnumerable,GE=Object.getOwnPropertySymbols,HE=Object.prototype.hasOwnProperty;function zE(e){for(var t=Object.keys(e),r=GE(e),n=0;n<r.length;n++)VE.call(e,r[n])&&t.push(r[n]);return t}function XE(e,t){var r;return!(null===(r=JE(e,t))||void 0===r?void 0:r.writable)}function WE(e,t){if("object"===(void 0===e?"undefined":DE(e))&&null!==e){var r;if(UE(e))r=[];else if("[object Date]"===BE(e))r=new Date(e.getTime?e.getTime():e);else if(function(e){return"[object RegExp]"===BE(e)}(e))r=new RegExp(e);else if(function(e){return"[object Error]"===BE(e)}(e))r={message:e.message};else if(function(e){return"[object Boolean]"===BE(e)}(e)||function(e){return"[object Number]"===BE(e)}(e)||function(e){return"[object String]"===BE(e)}(e))r=Object(e);else{if(LE(e))return e.slice();r=Object.create(Object.getPrototypeOf(e))}var n=t.includeSymbols?zE:Object.keys,s=!0,i=!1,o=void 0;try{for(var c,a=n(e)[Symbol.iterator]();!(s=(c=a.next()).done);s=!0){var u=c.value;r[u]=e[u]}}catch(e){i=!0,o=e}finally{try{s||null==a.return||a.return()}finally{if(i)throw o}}return r}return e}var YE,ZE,KE={includeSymbols:!1,immutable:!1};function QE(e,t){var r=arguments.length>2&&void 0!==arguments[2]?arguments[2]:KE,n=[],s=[],i=!0,o=r.includeSymbols?zE:Object.keys,c=!!r.immutable;return function e(a){var u=c?WE(a,r):a,l={},h=!0,f={node:u,node_:a,path:[].concat(n),parent:s[s.length-1],parents:s,key:n[n.length-1],isRoot:0===n.length,level:n.length,circular:void 0,isLeaf:!1,notLeaf:!0,notRoot:!0,isFirst:!1,isLast:!1,update:function(e){var t=arguments.length>1&&void 0!==arguments[1]&&arguments[1];f.isRoot||(f.parent.node[f.key]=e),f.node=e,t&&(h=!1)},delete:function(e){delete f.parent.node[f.key],e&&(h=!1)},remove:function(e){UE(f.parent.node)?f.parent.node.splice(f.key,1):delete f.parent.node[f.key],e&&(h=!1)},keys:null,before:function(e){l.before=e},after:function(e){l.after=e},pre:function(e){l.pre=e},post:function(e){l.post=e},stop:function(){i=!1},block:function(){h=!1}};if(!i)return f;function p(){if("object"===DE(f.node)&&null!==f.node){f.keys&&f.node_===f.node||(f.keys=o(f.node)),f.isLeaf=0===f.keys.length;for(var e=0;e<s.length;e++)if(s[e].node_===a){f.circular=s[e];break}}else f.isLeaf=!0,f.keys=null;f.notLeaf=!f.isLeaf,f.notRoot=!f.isRoot}p();var d=t.call(f,f.node);if(void 0!==d&&f.update&&f.update(d),l.before&&l.before.call(f,f.node),!h)return f;if("object"===DE(f.node)&&null!==f.node&&!f.circular){var m;s.push(f),p();var v=!0,y=!1,b=void 0;try{for(var g,w=Object.entries(null!==(m=f.keys)&&void 0!==m?m:[])[Symbol.iterator]();!(v=(g=w.next()).done);v=!0){var x,j=RE(g.value,2),E=j[0],$=j[1];n.push($),l.pre&&l.pre.call(f,f.node[$],$);var O=e(f.node[$]);c&&HE.call(f.node,$)&&!XE(f.node,$)&&(f.node[$]=O.node),O.isLast=!!(null===(x=f.keys)||void 0===x?void 0:x.length)&&+E==f.keys.length-1,O.isFirst=0==+E,l.post&&l.post.call(f,O),n.pop()}}catch(e){y=!0,b=e}finally{try{v||null==w.return||w.return()}finally{if(y)throw b}}s.pop()}return l.after&&l.after.call(f,f.node),f}(e).node}var e$=function(){function e(t){var r=arguments.length>1&&void 0!==arguments[1]?arguments[1]:KE;kE(this,e),NE(this,YE),NE(this,ZE),qE(this,YE,t),qE(this,ZE,r)}return FE(e,[{key:"get",value:function(e){for(var t=ME(this,YE),r=0;t&&r<e.length;r++){var n=e[r];if(!HE.call(t,n)||!ME(this,ZE).includeSymbols&&"symbol"===(void 0===n?"undefined":DE(n)))return;t=t[n]}return t}},{key:"has",value:function(e){for(var t=ME(this,YE),r=0;t&&r<e.length;r++){var n=e[r];if(!HE.call(t,n)||!ME(this,ZE).includeSymbols&&"symbol"===(void 0===n?"undefined":DE(n)))return!1;t=t[n]}return!0}},{key:"set",value:function(e,t){var r=ME(this,YE),n=0;for(n=0;n<e.length-1;n++){var s=e[n];HE.call(r,s)||(r[s]={}),r=r[s]}return r[e[n]]=t,t}},{key:"map",value:function(e){return QE(ME(this,YE),e,{immutable:!0,includeSymbols:!!ME(this,ZE).includeSymbols})}},{key:"forEach",value:function(e){return qE(this,YE,QE(ME(this,YE),e,ME(this,ZE))),ME(this,YE)}},{key:"reduce",value:function(e,t){var r=1===arguments.length,n=r?ME(this,YE):t;return this.forEach((function(t){this.isRoot&&r||(n=e.call(this,n,t))})),n}},{key:"paths",value:function(){var e=[];return this.forEach((function(){e.push(this.path)})),e}},{key:"nodes",value:function(){var e=[];return this.forEach((function(){e.push(this.node)})),e}},{key:"clone",value:function(){var e=[],t=[],r=ME(this,ZE);return LE(ME(this,YE))?ME(this,YE).slice():function n(s){for(var i=0;i<e.length;i++)if(e[i]===s)return t[i];if("object"===(void 0===s?"undefined":DE(s))&&null!==s){var o=WE(s,r);e.push(s),t.push(o);var c=r.includeSymbols?zE:Object.keys,a=!0,u=!1,l=void 0;try{for(var h,f=c(s)[Symbol.iterator]();!(a=(h=f.next()).done);a=!0){var p=h.value;o[p]=n(s[p])}}catch(e){u=!0,l=e}finally{try{a||null==f.return||f.return()}finally{if(u)throw l}}return e.pop(),t.pop(),o}return s}(ME(this,YE))}}]),e}();YE=new WeakMap,ZE=new WeakMap;var t$=function(e,t){return new e$(e,t)};t$.get=function(e,t,r){return new e$(e,r).get(t)},t$.set=function(e,t,r,n){return new e$(e,n).set(t,r)},t$.has=function(e,t,r){return new e$(e,r).has(t)},t$.map=function(e,t,r){return new e$(e,r).map(t)},t$.forEach=function(e,t,r){return new e$(e,r).forEach(t)},t$.reduce=function(e,t,r,n){return new e$(e,n).reduce(t,r)},t$.paths=function(e,t){return new e$(e,t).paths()},t$.nodes=function(e,t){return new e$(e,t).nodes()},t$.clone=function(e,t){return new e$(e,t).clone()};var r$=t$;const n$=["properties"],s$=["properties"],i$=["definitions","parameters","responses","securityDefinitions","components/schemas","components/responses","components/parameters","components/securitySchemes"],o$=["schema/example","items/example"];function c$(e){const t=e[e.length-1],r=e[e.length-2],n=e.join("/");return n$.indexOf(t)>-1&&-1===s$.indexOf(r)||i$.indexOf(n)>-1||o$.some((e=>n.indexOf(e)>-1))}function a$(e,t){const[r,n]=e.split("#"),s=null!=t?t:"",i=null!=r?r:"";let o;if(Um(s))o=Xm(s,i);else{const e=Xm("https://swagger.io",s),t=Xm(e,i).replace("https://swagger.io","");o=i.startsWith("/")?t:t.substring(1)}return n?`${o}#${n}`:o}const u$=/^([a-z]+:\/\/|\/\/)/i;class l$ extends Ih{}const h$={},f$=new WeakMap,p$=[e=>"paths"===e[0]&&"responses"===e[3]&&"examples"===e[5],e=>"paths"===e[0]&&"responses"===e[3]&&"content"===e[5]&&"example"===e[7],e=>"paths"===e[0]&&"responses"===e[3]&&"content"===e[5]&&"examples"===e[7]&&"value"===e[9],e=>"paths"===e[0]&&"requestBody"===e[3]&&"content"===e[4]&&"example"===e[6],e=>"paths"===e[0]&&"requestBody"===e[3]&&"content"===e[4]&&"examples"===e[6]&&"value"===e[8],e=>"paths"===e[0]&&"parameters"===e[2]&&"example"===e[4],e=>"paths"===e[0]&&"parameters"===e[3]&&"example"===e[5],e=>"paths"===e[0]&&"parameters"===e[2]&&"examples"===e[4]&&"value"===e[6],e=>"paths"===e[0]&&"parameters"===e[3]&&"examples"===e[5]&&"value"===e[7],e=>"paths"===e[0]&&"parameters"===e[2]&&"content"===e[4]&&"example"===e[6],e=>"paths"===e[0]&&"parameters"===e[2]&&"content"===e[4]&&"examples"===e[6]&&"value"===e[8],e=>"paths"===e[0]&&"parameters"===e[3]&&"content"===e[4]&&"example"===e[7],e=>"paths"===e[0]&&"parameters"===e[3]&&"content"===e[5]&&"examples"===e[7]&&"value"===e[9]],d$={key:"$ref",plugin:(e,t,r,n)=>{const s=n.getInstance(),i=r.slice(0,-1);if(c$(i)||(e=>p$.some((t=>t(e))))(i))return;const{baseDoc:o}=n.getContext(r);if("string"!=typeof e)return new l$("$ref: must be a string (JSON-Ref)",{$ref:e,baseDoc:o,fullPath:r});const c=b$(e),a=c[0],u=c[1]||"";let l,h,f;try{l=o||a?v$(a,o):null}catch(t){return y$(t,{pointer:u,$ref:e,basePath:l,fullPath:r})}if(function(e,t,r,n){let s=f$.get(n);s||(s={},f$.set(n,s));const i=function(e){if(0===e.length)return"";return`/${e.map($$).join("/")}`}(r),o=`${t||"<specmap-base>"}#${e}`,c=i.replace(/allOf\/\d+\/?/g,""),a=n.contextTree.get([]).baseDoc;if(t===a&&O$(c,e))return!0;let u="";const l=r.some((e=>(u=`${u}/${$$(e)}`,s[u]&&s[u].some((e=>O$(e,o)||O$(o,e))))));if(l)return!0;return void(s[c]=(s[c]||[]).concat(o))}(u,l,i,n)&&!s.useCircularStructures){const t=a$(e,l);return e===t?null:$r.replace(r,t)}if(null==l?(f=j$(u),h=n.get(f),void 0===h&&(h=new l$(`Could not resolve reference: ${e}`,{pointer:u,$ref:e,baseDoc:o,fullPath:r}))):(h=g$(l,u),h=null!=h.l?h.l:h.catch((t=>{throw y$(t,{pointer:u,$ref:e,baseDoc:o,fullPath:r})}))),h instanceof Error)return[$r.remove(r),h];const p=a$(e,l),d=$r.replace(i,h,{$$ref:p});if(l&&l!==o)return[d,$r.context(i,{baseDoc:l})];try{if(!function(e,t){const r=[e];return t.path.reduce(((e,t)=>(r.push(e[t]),e[t])),e),n(t.value);function n(e){return $r.isObject(e)&&(r.indexOf(e)>=0||Object.keys(e).some((t=>n(e[t]))))}}(n.state,d)||s.useCircularStructures)return d}catch(e){return null}}},m$=Object.assign(d$,{docCache:h$,absoluteify:v$,clearCache:function(e){void 0!==e?delete h$[e]:Object.keys(h$).forEach((e=>{delete h$[e]}))},JSONRefError:l$,wrapError:y$,getDoc:w$,split:b$,extractFromDoc:g$,fetchJSON:function(e){return fetch(e,{headers:{Accept:"application/json, application/yaml"},loadSpec:!0}).then((e=>e.text())).then((e=>It.load(e)))},extract:x$,jsonPointerToArray:j$,unescapeJsonPointerToken:E$});function v$(e,t){if(!u$.test(e)){if(!t)throw new l$(`Tried to resolve a relative URL, without having a basePath. path: '${e}' basePath: '${t}'`);return Xm(t,e)}return e}function y$(e,t){let r;return r=e&&e.response&&e.response.body?`${e.response.body.code} ${e.response.body.message}`:e.message,new l$(`Could not resolve reference: ${r}`,{...t,cause:e})}function b$(e){return(e+"").split("#")}function g$(e,t){const r=h$[e];if(r&&!$r.isPromise(r))try{const e=x$(t,r);return Object.assign(Promise.resolve(e),{l:e})}catch(e){return Promise.reject(e)}return w$(e).then((e=>x$(t,e)))}function w$(e){const t=h$[e];return t?$r.isPromise(t)?t:Promise.resolve(t):(h$[e]=m$.fetchJSON(e).then((t=>(h$[e]=t,t))),h$[e])}function x$(e,t){const r=j$(e);if(r.length<1)return t;const n=$r.getIn(t,r);if(void 0===n)throw new l$(`Could not resolve pointer: ${e} does not exist in document`,{pointer:e});return n}function j$(e){if("string"!=typeof e)throw new TypeError("Expected a string, got a "+typeof e);return"/"===e[0]&&(e=e.substr(1)),""===e?[]:e.split("/").map(E$)}function E$(e){if("string"!=typeof e)return e;return new URLSearchParams(`=${e.replace(/~1/g,"/").replace(/~0/g,"~")}`).get("")}function $$(e){return new URLSearchParams([["",e.replace(/~/g,"~0").replace(/\//g,"~1")]]).toString().slice(1)}function O$(e,t){if(!(r=t)||"/"===r||"#"===r)return!0;var r;const n=e.charAt(t.length),s=t.slice(-1);return 0===e.indexOf(t)&&(!n||"/"===n||"#"===n)&&"#"!==s}const S$={key:"allOf",plugin:(e,t,r,n,s)=>{if(s.meta&&s.meta.$$ref)return;const i=r.slice(0,-1);if(c$(i))return;if(!Array.isArray(e)){const e=new TypeError("allOf must be an array");return e.fullPath=r,e}let o=!1,c=s.value;if(i.forEach((e=>{c&&(c=c[e])})),c={...c},0===Object.keys(c).length)return;delete c.allOf;const a=[];return a.push(n.replace(i,{})),e.forEach(((e,t)=>{if(!n.isObject(e)){if(o)return null;o=!0;const e=new TypeError("Elements in allOf must be objects");return e.fullPath=r,a.push(e)}a.push(n.mergeDeep(i,e));const s=function(e,t,{specmap:r,getBaseUrlForNodePath:n=(e=>r.getContext([...t,...e]).baseDoc),targetKeys:s=["$ref","$$ref"]}={}){const i=[];return r$(e).forEach((function(){if(s.includes(this.key)&&"string"==typeof this.node){const e=this.path,s=t.concat(this.path),o=a$(this.node,n(e));i.push(r.replace(s,o))}})),i}(e,r.slice(0,-1),{getBaseUrlForNodePath:e=>n.getContext([...r,t,...e]).baseDoc,specmap:n});a.push(...s)})),c.example&&a.push(n.remove([].concat(i,"example"))),a.push(n.mergeDeep(i,c)),c.$$ref||a.push(n.remove([].concat(i,"$$ref"))),a}},A$={key:"parameters",plugin:(e,t,r,n)=>{if(Array.isArray(e)&&e.length){const t=Object.assign([],e),s=r.slice(0,-1),i={...$r.getIn(n.spec,s)};for(let s=0;s<e.length;s+=1){const o=e[s];try{t[s].default=n.parameterMacro(i,o)}catch(e){const t=new Error(e);return t.fullPath=r,t}}return $r.replace(r,t)}return $r.replace(r,e)}},P$={key:"properties",plugin:(e,t,r,n)=>{const s={...e};for(const t in e)try{s[t].default=n.modelPropertyMacro(s[t])}catch(e){const t=new Error(e);return t.fullPath=r,t}return $r.replace(r,s)}};class T${constructor(e){this.root=k$(e||{})}set(e,t){const r=this.getParent(e,!0);if(!r)return void F$(this.root,t,null);const n=e[e.length-1],{children:s}=r;s[n]?F$(s[n],t,r):s[n]=k$(t,r)}get(e){if((e=e||[]).length<1)return this.root.value;let t,r,n=this.root;for(let s=0;s<e.length&&(r=e[s],t=n.children,t[r]);s+=1)n=t[r];return n&&n.protoValue}getParent(e,t){return!e||e.length<1?null:e.length<2?this.root:e.slice(0,-1).reduce(((e,r)=>{if(!e)return e;const{children:n}=e;return!n[r]&&t&&(n[r]=k$(null,e)),n[r]}),this.root)}}function k$(e,t){return F$({children:{}},e,t)}function F$(e,t,r){return e.value=t||{},e.protoValue=r?{...r.protoValue,...e.value}:e.value,Object.keys(e.children).forEach((t=>{const r=e.children[t];e.children[t]=F$(r,r.value,e)})),e}const I$=()=>{};class R${static getPluginName(e){return e.pluginName}static getPatchesOfType(e,t){return e.filter(t)}constructor(e){Object.assign(this,{spec:"",debugLevel:"info",plugins:[],pluginHistory:{},errors:[],mutations:[],promisedPatches:[],state:{},patches:[],context:{},contextTree:new T$,showDebug:!1,allPatches:[],pluginProp:"specMap",libMethods:Object.assign(Object.create(this),$r,{getInstance:()=>this}),allowMetaPatches:!1},e),this.get=this._get.bind(this),this.getContext=this._getContext.bind(this),this.hasRun=this._hasRun.bind(this),this.wrappedPlugins=this.plugins.map(this.wrapPlugin.bind(this)).filter($r.isFunction),this.patches.push($r.add([],this.spec)),this.patches.push($r.context([],this.context)),this.updatePatches(this.patches)}debug(e,...t){this.debugLevel===e&&console.log(...t)}verbose(e,...t){"verbose"===this.debugLevel&&console.log(`[${e}]   `,...t)}wrapPlugin(e,t){const{pathDiscriminator:r}=this;let n,s=null;return e[this.pluginProp]?(s=e,n=e[this.pluginProp]):$r.isFunction(e)?n=e:$r.isObject(e)&&(n=function(e){const t=(e,t)=>!Array.isArray(e)||e.every(((e,r)=>e===t[r]));return function*(n,s){const i={};for(const[e,t]of n.filter($r.isAdditiveMutation).entries()){if(!(e<3e3))return;yield*o(t.value,t.path,t)}function*o(n,c,a){if($r.isObject(n)){const u=c.length-1,l=c[u],h=c.indexOf("properties"),f="properties"===l&&u===h,p=s.allowMetaPatches&&i[n.$$ref];for(const u of Object.keys(n)){const l=n[u],h=c.concat(u),d=$r.isObject(l),m=n.$$ref;if(p||d&&(s.allowMetaPatches&&m&&(i[m]=!0),yield*o(l,h,a)),!f&&u===e.key){const n=t(r,c);r&&!n||(yield e.plugin(l,u,h,s,a))}}}else e.key===c[c.length-1]&&(yield e.plugin(n,e.key,c,s))}}}(e)),Object.assign(n.bind(s),{pluginName:e.name||t,isGenerator:$r.isGenerator(n)})}nextPlugin(){return this.wrappedPlugins.find((e=>this.getMutationsForPlugin(e).length>0))}nextPromisedPatch(){if(this.promisedPatches.length>0)return Promise.race(this.promisedPatches.map((e=>e.value)))}getPluginHistory(e){const t=this.constructor.getPluginName(e);return this.pluginHistory[t]||[]}getPluginRunCount(e){return this.getPluginHistory(e).length}getPluginHistoryTip(e){const t=this.getPluginHistory(e);return t&&t[t.length-1]||{}}getPluginMutationIndex(e){const t=this.getPluginHistoryTip(e).mutationIndex;return"number"!=typeof t?-1:t}updatePluginHistory(e,t){const r=this.constructor.getPluginName(e);this.pluginHistory[r]=this.pluginHistory[r]||[],this.pluginHistory[r].push(t)}updatePatches(e){$r.normalizeArray(e).forEach((e=>{if(e instanceof Error)this.errors.push(e);else try{if(!$r.isObject(e))return void this.debug("updatePatches","Got a non-object patch",e);if(this.showDebug&&this.allPatches.push(e),$r.isPromise(e.value))return this.promisedPatches.push(e),void this.promisedPatchThen(e);if($r.isContextPatch(e))return void this.setContext(e.path,e.value);$r.isMutation(e)&&this.updateMutations(e)}catch(e){console.error(e),this.errors.push(e)}}))}updateMutations(e){"object"==typeof e.value&&!Array.isArray(e.value)&&this.allowMetaPatches&&(e.value={...e.value});const t=$r.applyPatch(this.state,e,{allowMetaPatches:this.allowMetaPatches});t&&(this.mutations.push(e),this.state=t)}removePromisedPatch(e){const t=this.promisedPatches.indexOf(e);t<0?this.debug("Tried to remove a promisedPatch that isn't there!"):this.promisedPatches.splice(t,1)}promisedPatchThen(e){return e.value=e.value.then((t=>{const r={...e,value:t};this.removePromisedPatch(e),this.updatePatches(r)})).catch((t=>{this.removePromisedPatch(e),this.updatePatches(t)})),e.value}getMutations(e,t){return e=e||0,"number"!=typeof t&&(t=this.mutations.length),this.mutations.slice(e,t)}getCurrentMutations(){return this.getMutationsForPlugin(this.getCurrentPlugin())}getMutationsForPlugin(e){const t=this.getPluginMutationIndex(e);return this.getMutations(t+1)}getCurrentPlugin(){return this.currentPlugin}getLib(){return this.libMethods}_get(e){return $r.getIn(this.state,e)}_getContext(e){return this.contextTree.get(e)}setContext(e,t){return this.contextTree.set(e,t)}_hasRun(e){return this.getPluginRunCount(this.getCurrentPlugin())>(e||0)}dispatch(){const e=this,t=this.nextPlugin();if(!t){const e=this.nextPromisedPatch();if(e)return e.then((()=>this.dispatch())).catch((()=>this.dispatch()));const t={spec:this.state,errors:this.errors};return this.showDebug&&(t.patches=this.allPatches),Promise.resolve(t)}if(e.pluginCount=e.pluginCount||new WeakMap,e.pluginCount.set(t,(e.pluginCount.get(t)||0)+1),e.pluginCount[t]>100)return Promise.resolve({spec:e.state,errors:e.errors.concat(new Error("We've reached a hard limit of 100 plugin runs"))});if(t!==this.currentPlugin&&this.promisedPatches.length){const e=this.promisedPatches.map((e=>e.value));return Promise.all(e.map((e=>e.then(I$,I$)))).then((()=>this.dispatch()))}return function(){e.currentPlugin=t;const n=e.getCurrentMutations(),s=e.mutations.length-1;try{if(t.isGenerator)for(const s of t(n,e.getLib()))r(s);else{r(t(n,e.getLib()))}}catch(e){console.error(e),r([Object.assign(Object.create(e),{plugin:t})])}finally{e.updatePluginHistory(t,{mutationIndex:s})}return e.dispatch()}();function r(r){r&&(r=$r.fullyNormalizeArray(r),e.updatePatches(r,t))}}}const D$={refs:m$,allOf:S$,parameters:A$,properties:P$};async function _$(e){const{spec:t,mode:r,allowMetaPatches:n=!0,pathDiscriminator:s,modelPropertyMacro:i,parameterMacro:o,requestInterceptor:c,responseInterceptor:a,skipNormalization:u=!1,useCircularStructures:l,strategies:h}=e,f=Mt(e),p=Nt(e),d=h.find((e=>e.match(t)));return async function(e){f&&(D$.refs.docCache[f]=e);D$.refs.fetchJSON=Ct(p,{requestInterceptor:c,responseInterceptor:a});const t=[D$.refs];"function"==typeof o&&t.push(D$.parameters);"function"==typeof i&&t.push(D$.properties);"strict"!==r&&t.push(D$.allOf);const h=await(m={spec:e,context:{baseDoc:f},plugins:t,allowMetaPatches:n,pathDiscriminator:s,parameterMacro:o,modelPropertyMacro:i,useCircularStructures:l},new R$(m).dispatch());var m;u||(h.spec=d.normalize(h.spec));return h}(t)}const C$=e=>e.replace(/\W/gi,"_");function M$(e,t,r="",{v2OperationIdCompatibilityMode:n}={}){if(!e||"object"!=typeof e)return null;return(e.operationId||"").replace(/\s/g,"").length?C$(e.operationId):function(e,t,{v2OperationIdCompatibilityMode:r}={}){if(r){let r=`${t.toLowerCase()}_${e}`.replace(/[\s!@#$%^&*()_+=[{\]};:<>|./?,\\'""-]/g,"_");return r=r||`${e.substring(1)}_${t}`,r.replace(/((_){2,})/g,"_").replace(/^(_)*/g,"").replace(/([_])*$/g,"")}return`${t.toLowerCase()}${C$(e)}`}(t,r,{v2OperationIdCompatibilityMode:n})}function N$(e){const{spec:t}=e,{paths:r}=t,n={};if(!r||t.$$normalized)return e;for(const e in r){const s=r[e];if(null==s||!["object","function"].includes(typeof s))continue;const i=s.parameters;for(const r in s){const o=s[r];if(null==o||!["object","function"].includes(typeof o))continue;const c=M$(o,e,r);if(c){n[c]?n[c].push(o):n[c]=[o];const e=n[c];if(e.length>1)e.forEach(((e,t)=>{e.h=e.h||e.operationId,e.operationId=`${c}${t+1}`}));else if(void 0!==o.operationId){const t=e[0];t.h=t.h||o.operationId,t.operationId=c}}if("parameters"!==r){const e=[],r={};for(const n in t)"produces"!==n&&"consumes"!==n&&"security"!==n||(r[n]=t[n],e.push(r));if(i&&(r.parameters=i,e.push(r)),e.length)for(const t of e)for(const e in t)if(o[e]){if("parameters"===e)for(const r of t[e]){o[e].some((e=>e.name&&e.name===r.name||e.$ref&&e.$ref===r.$ref||e.$$ref&&e.$$ref===r.$$ref||e===r))||o[e].push(r)}}else o[e]=t[e]}}}return t.$$normalized=!0,e}const q$={name:"generic",match:()=>!0,normalize(e){const{spec:t}=N$({spec:e});return t},resolve:async e=>_$(e)};const B$=e=>{try{const{swagger:t}=e;return"2.0"===t}catch{return!1}},L$=e=>{try{const{openapi:t}=e;return"string"==typeof t&&/^3\.0\.([0123])(?:-rc[012])?$/.test(t)}catch{return!1}},U$=e=>{try{const{openapi:t}=e;return"string"==typeof t&&/^3\.1\.(?:[1-9]\d*|0)$/.test(t)}catch{return!1}},J$=e=>L$(e)||U$(e),V$={name:"openapi-2",match:e=>B$(e),normalize(e){const{spec:t}=N$({spec:e});return t},resolve:async e=>async function(e){return _$(e)}(e)};const G$={name:"openapi-3-0",match:e=>L$(e),normalize(e){const{spec:t}=N$({spec:e});return t},resolve:async e=>async function(e){return _$(e)}(e)},H$=e=>async t=>(async e=>{const{spec:t,requestInterceptor:r,responseInterceptor:n}=e,s=Mt(e),i=Nt(e),o=t||await Ct(i,{requestInterceptor:r,responseInterceptor:n})(s),c={...e,spec:o};return e.strategies.find((e=>e.match(o))).resolve(c)})({...e,...t}),z$=H$({strategies:[G$,V$,q$]});class X$ extends Ih{}class W$ extends X${pointer;constructor(e,t){super(e,t),void 0!==t&&(this.pointer=t.pointer)}}class Y$ extends X${tokens;constructor(e,t){super(e,t),void 0!==t&&(this.tokens=[...t.tokens])}}class Z$ extends X${pointer;tokens;failedToken;failedTokenPosition;element;constructor(e,t){super(e,t),void 0!==t&&(this.pointer=t.pointer,Array.isArray(t.tokens)&&(this.tokens=[...t.tokens]),this.failedToken=t.failedToken,this.failedTokenPosition=t.failedTokenPosition,this.element=t.element)}}const K$=gp(jd(/~/g,"~0"),jd(/\//g,"~1"),encodeURIComponent),Q$=gp(jd(/~1/g,"/"),jd(/~0/g,"~"),(e=>{try{return decodeURIComponent(e)}catch{return e}})),eO=e=>{const t=(e=>{const t=e.indexOf("#");return-1!==t?e.substring(t):"#"})(e);return jm("#",t)},tO=e=>{try{return 0===e.length?"":`/${e.map(K$).join("/")}`}catch(t){throw new Y$("JSON Pointer compilation of tokens encountered an error.",{tokens:e,cause:t})}},rO=(e,t)=>{let r;try{r=(e=>{if(Vd(e))return[];if(!Od("/",e))throw new W$(`Invalid JSON Pointer "${e}". JSON Pointers must begin with "/"`,{pointer:e});try{const t=gp($d("/"),Ff(Q$))(e);return bp(t)}catch(t){throw new W$(`JSON Pointer parsing of "${e}" encountered an error.`,{pointer:e,cause:t})}})(e)}catch(r){throw new Z$(`JSON Pointer evaluation failed while parsing the pointer "${e}".`,{pointer:e,element:Cj(t),cause:r})}return r.reduce(((t,n,s)=>{if(uj(t)){if(!t.hasKey(n))throw new Z$(`JSON Pointer evaluation failed while evaluating token "${n}" against an ObjectElement`,{pointer:e,tokens:r,failedToken:n,failedTokenPosition:s,element:Cj(t)});return t.get(n)}if(lj(t)){if(!(n in t.content)||!im(Number(n)))throw new Z$(`JSON Pointer evaluation failed while evaluating token "${n}" against an ArrayElement`,{pointer:e,tokens:r,failedToken:n,failedTokenPosition:s,element:Cj(t)});return t.get(Number(n))}throw new Z$(`JSON Pointer evaluation failed while evaluating token "${n}" against an unexpected Element`,{pointer:e,tokens:r,failedToken:n,failedTokenPosition:s,element:Cj(t)})}),t)};class nO extends Kj{filterByFormat(e="generic"){const t="generic"===e?"openapi;version":e;return this.filter((e=>e.includes(t)))}findBy(e="3.1.0",t="generic"){const r="generic"===t?`vnd.oai.openapi;version=${e}`:`vnd.oai.openapi+${t};version=${e}`;return this.find((e=>e.includes(r)))||this.unknownMediaType}latest(e="generic"){return Np(this.filterByFormat(e))}}const sO=new nO("application/vnd.oai.openapi;version=3.1.0","application/vnd.oai.openapi+json;version=3.1.0","application/vnd.oai.openapi+yaml;version=3.1.0");let iO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="callback"}},oO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="components"}get schemas(){return this.get("schemas")}set schemas(e){this.set("schemas",e)}get responses(){return this.get("responses")}set responses(e){this.set("responses",e)}get parameters(){return this.get("parameters")}set parameters(e){this.set("parameters",e)}get examples(){return this.get("examples")}set examples(e){this.set("examples",e)}get requestBodies(){return this.get("requestBodies")}set requestBodies(e){this.set("requestBodies",e)}get headers(){return this.get("headers")}set headers(e){this.set("headers",e)}get securitySchemes(){return this.get("securitySchemes")}set securitySchemes(e){this.set("securitySchemes",e)}get links(){return this.get("links")}set links(e){this.set("links",e)}get callbacks(){return this.get("callbacks")}set callbacks(e){this.set("callbacks",e)}},cO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="contact"}get name(){return this.get("name")}set name(e){this.set("name",e)}get url(){return this.get("url")}set url(e){this.set("url",e)}get email(){return this.get("email")}set email(e){this.set("email",e)}},aO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="discriminator"}get propertyName(){return this.get("propertyName")}set propertyName(e){this.set("propertyName",e)}get mapping(){return this.get("mapping")}set mapping(e){this.set("mapping",e)}},uO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="encoding"}get contentType(){return this.get("contentType")}set contentType(e){this.set("contentType",e)}get headers(){return this.get("headers")}set headers(e){this.set("headers",e)}get style(){return this.get("style")}set style(e){this.set("style",e)}get explode(){return this.get("explode")}set explode(e){this.set("explode",e)}get allowedReserved(){return this.get("allowedReserved")}set allowedReserved(e){this.set("allowedReserved",e)}},lO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="example"}get summary(){return this.get("summary")}set summary(e){this.set("summary",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get value(){return this.get("value")}set value(e){this.set("value",e)}get externalValue(){return this.get("externalValue")}set externalValue(e){this.set("externalValue",e)}},hO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="externalDocumentation"}get description(){return this.get("description")}set description(e){this.set("description",e)}get url(){return this.get("url")}set url(e){this.set("url",e)}},fO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="header"}get required(){return this.hasKey("required")?this.get("required"):new Bx(!1)}set required(e){this.set("required",e)}get deprecated(){return this.hasKey("deprecated")?this.get("deprecated"):new Bx(!1)}set deprecated(e){this.set("deprecated",e)}get allowEmptyValue(){return this.get("allowEmptyValue")}set allowEmptyValue(e){this.set("allowEmptyValue",e)}get style(){return this.get("style")}set style(e){this.set("style",e)}get explode(){return this.get("explode")}set explode(e){this.set("explode",e)}get allowReserved(){return this.get("allowReserved")}set allowReserved(e){this.set("allowReserved",e)}get schema(){return this.get("schema")}set schema(e){this.set("schema",e)}get example(){return this.get("example")}set example(e){this.set("example",e)}get examples(){return this.get("examples")}set examples(e){this.set("examples",e)}get contentProp(){return this.get("content")}set contentProp(e){this.set("content",e)}};Object.defineProperty(fO.prototype,"description",{get(){return this.get("description")},set(e){this.set("description",e)},enumerable:!0});let pO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="info",this.classes.push("info")}get title(){return this.get("title")}set title(e){this.set("title",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get termsOfService(){return this.get("termsOfService")}set termsOfService(e){this.set("termsOfService",e)}get contact(){return this.get("contact")}set contact(e){this.set("contact",e)}get license(){return this.get("license")}set license(e){this.set("license",e)}get version(){return this.get("version")}set version(e){this.set("version",e)}},dO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="license"}get name(){return this.get("name")}set name(e){this.set("name",e)}get url(){return this.get("url")}set url(e){this.set("url",e)}},mO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="link"}get operationRef(){return this.get("operationRef")}set operationRef(e){this.set("operationRef",e)}get operationId(){return this.get("operationId")}set operationId(e){this.set("operationId",e)}get operation(){var e,t;return ij(this.operationRef)?null===(e=this.operationRef)||void 0===e?void 0:e.meta.get("operation"):ij(this.operationId)?null===(t=this.operationId)||void 0===t?void 0:t.meta.get("operation"):void 0}set operation(e){this.set("operation",e)}get parameters(){return this.get("parameters")}set parameters(e){this.set("parameters",e)}get requestBody(){return this.get("requestBody")}set requestBody(e){this.set("requestBody",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get server(){return this.get("server")}set server(e){this.set("server",e)}},vO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="mediaType"}get schema(){return this.get("schema")}set schema(e){this.set("schema",e)}get example(){return this.get("example")}set example(e){this.set("example",e)}get examples(){return this.get("examples")}set examples(e){this.set("examples",e)}get encoding(){return this.get("encoding")}set encoding(e){this.set("encoding",e)}},yO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="oAuthFlow"}get authorizationUrl(){return this.get("authorizationUrl")}set authorizationUrl(e){this.set("authorizationUrl",e)}get tokenUrl(){return this.get("tokenUrl")}set tokenUrl(e){this.set("tokenUrl",e)}get refreshUrl(){return this.get("refreshUrl")}set refreshUrl(e){this.set("refreshUrl",e)}get scopes(){return this.get("scopes")}set scopes(e){this.set("scopes",e)}},bO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="oAuthFlows"}get implicit(){return this.get("implicit")}set implicit(e){this.set("implicit",e)}get password(){return this.get("password")}set password(e){this.set("password",e)}get clientCredentials(){return this.get("clientCredentials")}set clientCredentials(e){this.set("clientCredentials",e)}get authorizationCode(){return this.get("authorizationCode")}set authorizationCode(e){this.set("authorizationCode",e)}},gO=class extends Nx{constructor(e,t,r){super(e,t,r),this.element="openapi",this.classes.push("spec-version"),this.classes.push("version")}};class wO extends Jx{constructor(e,t,r){super(e,t,r),this.element="openApi3_0",this.classes.push("api")}get openapi(){return this.get("openapi")}set openapi(e){this.set("openapi",e)}get info(){return this.get("info")}set info(e){this.set("info",e)}get servers(){return this.get("servers")}set servers(e){this.set("servers",e)}get paths(){return this.get("paths")}set paths(e){this.set("paths",e)}get components(){return this.get("components")}set components(e){this.set("components",e)}get security(){return this.get("security")}set security(e){this.set("security",e)}get tags(){return this.get("tags")}set tags(e){this.set("tags",e)}get externalDocs(){return this.get("externalDocs")}set externalDocs(e){this.set("externalDocs",e)}}let xO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="operation"}get tags(){return this.get("tags")}set tags(e){this.set("tags",e)}get summary(){return this.get("summary")}set summary(e){this.set("summary",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}set externalDocs(e){this.set("externalDocs",e)}get externalDocs(){return this.get("externalDocs")}get operationId(){return this.get("operationId")}set operationId(e){this.set("operationId",e)}get parameters(){return this.get("parameters")}set parameters(e){this.set("parameters",e)}get requestBody(){return this.get("requestBody")}set requestBody(e){this.set("requestBody",e)}get responses(){return this.get("responses")}set responses(e){this.set("responses",e)}get callbacks(){return this.get("callbacks")}set callbacks(e){this.set("callbacks",e)}get deprecated(){return this.hasKey("deprecated")?this.get("deprecated"):new Bx(!1)}set deprecated(e){this.set("deprecated",e)}get security(){return this.get("security")}set security(e){this.set("security",e)}get servers(){return this.get("severs")}set servers(e){this.set("servers",e)}},jO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="parameter"}get name(){return this.get("name")}set name(e){this.set("name",e)}get in(){return this.get("in")}set in(e){this.set("in",e)}get required(){return this.hasKey("required")?this.get("required"):new Bx(!1)}set required(e){this.set("required",e)}get deprecated(){return this.hasKey("deprecated")?this.get("deprecated"):new Bx(!1)}set deprecated(e){this.set("deprecated",e)}get allowEmptyValue(){return this.get("allowEmptyValue")}set allowEmptyValue(e){this.set("allowEmptyValue",e)}get style(){return this.get("style")}set style(e){this.set("style",e)}get explode(){return this.get("explode")}set explode(e){this.set("explode",e)}get allowReserved(){return this.get("allowReserved")}set allowReserved(e){this.set("allowReserved",e)}get schema(){return this.get("schema")}set schema(e){this.set("schema",e)}get example(){return this.get("example")}set example(e){this.set("example",e)}get examples(){return this.get("examples")}set examples(e){this.set("examples",e)}get contentProp(){return this.get("content")}set contentProp(e){this.set("content",e)}};Object.defineProperty(jO.prototype,"description",{get(){return this.get("description")},set(e){this.set("description",e)},enumerable:!0});let EO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="pathItem"}get $ref(){return this.get("$ref")}set $ref(e){this.set("$ref",e)}get summary(){return this.get("summary")}set summary(e){this.set("summary",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get GET(){return this.get("get")}set GET(e){this.set("GET",e)}get PUT(){return this.get("put")}set PUT(e){this.set("PUT",e)}get POST(){return this.get("post")}set POST(e){this.set("POST",e)}get DELETE(){return this.get("delete")}set DELETE(e){this.set("DELETE",e)}get OPTIONS(){return this.get("options")}set OPTIONS(e){this.set("OPTIONS",e)}get HEAD(){return this.get("head")}set HEAD(e){this.set("HEAD",e)}get PATCH(){return this.get("patch")}set PATCH(e){this.set("PATCH",e)}get TRACE(){return this.get("trace")}set TRACE(e){this.set("TRACE",e)}get servers(){return this.get("servers")}set servers(e){this.set("servers",e)}get parameters(){return this.get("parameters")}set parameters(e){this.set("parameters",e)}},$O=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="paths"}},OO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="reference",this.classes.push("openapi-reference")}get $ref(){return this.get("$ref")}set $ref(e){this.set("$ref",e)}},SO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="requestBody"}get description(){return this.get("description")}set description(e){this.set("description",e)}get contentProp(){return this.get("content")}set contentProp(e){this.set("content",e)}get required(){return this.hasKey("required")?this.get("required"):new Bx(!1)}set required(e){this.set("required",e)}},AO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="response"}get description(){return this.get("description")}set description(e){this.set("description",e)}get headers(){return this.get("headers")}set headers(e){this.set("headers",e)}get contentProp(){return this.get("content")}set contentProp(e){this.set("content",e)}get links(){return this.get("links")}set links(e){this.set("links",e)}},PO=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="responses"}get default(){return this.get("default")}set default(e){this.set("default",e)}};class TO extends Jx{constructor(e,t,r){super(e,t,r),this.element="JSONSchemaDraft4"}get idProp(){return this.get("id")}set idProp(e){this.set("id",e)}get $schema(){return this.get("$schema")}set $schema(e){this.set("$schema",e)}get multipleOf(){return this.get("multipleOf")}set multipleOf(e){this.set("multipleOf",e)}get maximum(){return this.get("maximum")}set maximum(e){this.set("maximum",e)}get exclusiveMaximum(){return this.get("exclusiveMaximum")}set exclusiveMaximum(e){this.set("exclusiveMaximum",e)}get minimum(){return this.get("minimum")}set minimum(e){this.set("minimum",e)}get exclusiveMinimum(){return this.get("exclusiveMinimum")}set exclusiveMinimum(e){this.set("exclusiveMinimum",e)}get maxLength(){return this.get("maxLength")}set maxLength(e){this.set("maxLength",e)}get minLength(){return this.get("minLength")}set minLength(e){this.set("minLength",e)}get pattern(){return this.get("pattern")}set pattern(e){this.set("pattern",e)}get additionalItems(){return this.get("additionalItems")}set additionalItems(e){this.set("additionalItems",e)}get items(){return this.get("items")}set items(e){this.set("items",e)}get maxItems(){return this.get("maxItems")}set maxItems(e){this.set("maxItems",e)}get minItems(){return this.get("minItems")}set minItems(e){this.set("minItems",e)}get uniqueItems(){return this.get("uniqueItems")}set uniqueItems(e){this.set("uniqueItems",e)}get maxProperties(){return this.get("maxProperties")}set maxProperties(e){this.set("maxProperties",e)}get minProperties(){return this.get("minProperties")}set minProperties(e){this.set("minProperties",e)}get required(){return this.get("required")}set required(e){this.set("required",e)}get properties(){return this.get("properties")}set properties(e){this.set("properties",e)}get additionalProperties(){return this.get("additionalProperties")}set additionalProperties(e){this.set("additionalProperties",e)}get patternProperties(){return this.get("patternProperties")}set patternProperties(e){this.set("patternProperties",e)}get dependencies(){return this.get("dependencies")}set dependencies(e){this.set("dependencies",e)}get enum(){return this.get("enum")}set enum(e){this.set("enum",e)}get type(){return this.get("type")}set type(e){this.set("type",e)}get allOf(){return this.get("allOf")}set allOf(e){this.set("allOf",e)}get anyOf(){return this.get("anyOf")}set anyOf(e){this.set("anyOf",e)}get oneOf(){return this.get("oneOf")}set oneOf(e){this.set("oneOf",e)}get not(){return this.get("not")}set not(e){this.set("not",e)}get definitions(){return this.get("definitions")}set definitions(e){this.set("definitions",e)}get title(){return this.get("title")}set title(e){this.set("title",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get default(){return this.get("default")}set default(e){this.set("default",e)}get format(){return this.get("format")}set format(e){this.set("format",e)}get base(){return this.get("base")}set base(e){this.set("base",e)}get links(){return this.get("links")}set links(e){this.set("links",e)}get media(){return this.get("media")}set media(e){this.set("media",e)}get readOnly(){return this.get("readOnly")}set readOnly(e){this.set("readOnly",e)}}class kO extends Jx{constructor(e,t,r){super(e,t,r),this.element="JSONReference",this.classes.push("json-reference")}get $ref(){return this.get("$ref")}set $ref(e){this.set("$ref",e)}}class FO extends Jx{constructor(e,t,r){super(e,t,r),this.element="media"}get binaryEncoding(){return this.get("binaryEncoding")}set binaryEncoding(e){this.set("binaryEncoding",e)}get type(){return this.get("type")}set type(e){this.set("type",e)}}class IO extends Jx{constructor(e,t,r){super(e,t,r),this.element="linkDescription"}get href(){return this.get("href")}set href(e){this.set("href",e)}get rel(){return this.get("rel")}set rel(e){this.set("rel",e)}get title(){return this.get("title")}set title(e){this.set("title",e)}get targetSchema(){return this.get("targetSchema")}set targetSchema(e){this.set("targetSchema",e)}get mediaType(){return this.get("mediaType")}set mediaType(e){this.set("mediaType",e)}get method(){return this.get("method")}set method(e){this.set("method",e)}get encType(){return this.get("encType")}set encType(e){this.set("encType",e)}get schema(){return this.get("schema")}set schema(e){this.set("schema",e)}}const RO={namespace:e=>{const{base:t}=e;return t.register("jSONSchemaDraft4",TO),t.register("jSONReference",kO),t.register("media",FO),t.register("linkDescription",IO),t}},DO=e=>{if(sj(e))return`${e.element.charAt(0).toUpperCase()+e.element.slice(1)}Element`},_O={JSONSchemaDraft4Element:["content"],JSONReferenceElement:["content"],MediaElement:["content"],LinkDescriptionElement:["content"],...Jj};let CO=class{element;constructor(e){Object.assign(this,e)}copyMetaAndAttributes(e,t){(e.meta.length>0||t.meta.length>0)&&(t.meta=dE(t.meta,e.meta),gj(e)&&t.meta.set("sourceMap",e.meta.get("sourceMap"))),(e.attributes.length>0||e.meta.length>0)&&(t.attributes=dE(t.attributes,e.attributes))}},MO=class extends CO{enter(e){return this.element=Cj(e),Aj}};const NO=(e,t,r=[])=>{const n=Object.getOwnPropertyDescriptors(t);for(let e of r)delete n[e];Object.defineProperties(e,n)},qO=(e,t=[e])=>{const r=Object.getPrototypeOf(e);return null===r?t:qO(r,[...t,r])},BO=(e,t,r=[])=>{var n;const s=null!==(n=((...e)=>{if(0===e.length)return;let t;const r=e.map((e=>qO(e)));for(;r.every((e=>e.length>0));){const e=r.map((e=>e.pop())),n=e[0];if(!e.every((e=>e===n)))break;t=n}return t})(...e))&&void 0!==n?n:Object.prototype,i=Object.create(s),o=qO(s);for(let t of e){let e=qO(t);for(let t=e.length-1;t>=0;t--){let n=e[t];-1===o.indexOf(n)&&(NO(i,n,["constructor",...r]),o.push(n))}}return i.constructor=t,i},LO=e=>e.filter(((t,r)=>e.indexOf(t)==r)),UO=new WeakMap,JO=e=>UO.get(e),VO=(e,t)=>{var r,n;const s=LO([...Object.getOwnPropertyNames(e),...Object.getOwnPropertyNames(t)]),i={};for(let o of s)i[o]=LO([...null!==(r=null==e?void 0:e[o])&&void 0!==r?r:[],...null!==(n=null==t?void 0:t[o])&&void 0!==n?n:[]]);return i},GO=(e,t)=>{var r,n,s,i;return{property:VO(null!==(r=null==e?void 0:e.property)&&void 0!==r?r:{},null!==(n=null==t?void 0:t.property)&&void 0!==n?n:{}),method:VO(null!==(s=null==e?void 0:e.method)&&void 0!==s?s:{},null!==(i=null==t?void 0:t.method)&&void 0!==i?i:{})}},HO=new Map,zO=(...e)=>{const t=((...e)=>{var t;const r=new Set,n=new Set([...e]);for(;n.size>0;)for(let e of n){const s=[...qO(e.prototype).map((e=>e.constructor)),...null!==(t=JO(e))&&void 0!==t?t:[]].filter((e=>!r.has(e)));for(let e of s)n.add(e);r.add(e),n.delete(e)}return[...r]})(...e).map((e=>HO.get(e))).filter((e=>!!e));return 0==t.length?{}:1==t.length?t[0]:t.reduce(((e,t)=>((e,t)=>{var r,n,s,i,o,c;return{class:LO([...null!==(r=null==e?void 0:e.class)&&void 0!==r?r:[],...null!==(n=null==t?void 0:t.class)&&void 0!==n?n:[]]),static:GO(null!==(s=null==e?void 0:e.static)&&void 0!==s?s:{},null!==(i=null==t?void 0:t.static)&&void 0!==i?i:{}),instance:GO(null!==(o=null==e?void 0:e.instance)&&void 0!==o?o:{},null!==(c=null==t?void 0:t.instance)&&void 0!==c?c:{})}})(e,t)))};function XO(...e){var t,r,n;const s=e.map((e=>e.prototype));function i(...t){for(const r of e)NO(this,new r(...t))}i.prototype=BO(s,i),Object.setPrototypeOf(i,BO(e,null,["prototype"]));let o=i;{const s=zO(...e);for(let e of null!==(t=null==s?void 0:s.class)&&void 0!==t?t:[]){const t=e(o);t&&(o=t)}WO(null!==(r=null==s?void 0:s.static)&&void 0!==r?r:{},o),WO(null!==(n=null==s?void 0:s.instance)&&void 0!==n?n:{},o.prototype)}var c,a;return c=o,a=e,UO.set(c,a),o}const WO=(e,t)=>{const r=e.property,n=e.method;if(r)for(let e in r)for(let n of r[e])n(t,e);if(n)for(let e in n)for(let r of n[e])r(t,e,Object.getOwnPropertyDescriptor(t,e))};let YO=class extends CO{specObj;passingOptionsNames=["specObj"];constructor({specObj:e,...t}){super({...t}),this.specObj=e}retrievePassingOptions(){return vd(this.passingOptionsNames,this)}retrieveFixedFields(e){const t=pd(["visitors",...e,"fixedFields"],this.specObj);return"object"==typeof t&&null!==t?Object.keys(t):[]}retrieveVisitor(e){return md(qd,["visitors",...e],this.specObj)?pd(["visitors",...e],this.specObj):pd(["visitors",...e,"$visitor"],this.specObj)}retrieveVisitorInstance(e,t={}){const r=this.retrievePassingOptions();return new(this.retrieveVisitor(e))({...r,...t})}toRefractedElement(e,t,r={}){const n=this.retrieveVisitorInstance(e,r);return n instanceof MO&&(null==n?void 0:n.constructor)===MO?Cj(t):(Gj(t,n,r),n.element)}},ZO=class extends YO{specPath;ignoredFields;constructor({specPath:e,ignoredFields:t,...r}){super({...r}),this.specPath=e,this.ignoredFields=t||[]}ObjectElement(e){const t=this.specPath(e),r=this.retrieveFixedFields(t);return e.forEach(((e,n,s)=>{if(ij(n)&&r.includes(oE(n))&&!this.ignoredFields.includes(oE(n))){const r=this.toRefractedElement([...t,"fixedFields",oE(n)],e),i=new Vx(Cj(n),r);this.copyMetaAndAttributes(s,i),i.classes.push("fixed-field"),this.element.content.push(i)}else this.ignoredFields.includes(oE(n))||this.element.content.push(Cj(s))})),this.copyMetaAndAttributes(e,this.element),Aj}};class KO extends(XO(ZO,MO)){constructor(e){super(e),this.element=new TO,this.specPath=Wf(["document","objects","JSONSchema"])}}let QO=class{parent;constructor({parent:e}){this.parent=e}};const eS=e=>uj(e)&&e.hasKey("$ref");let tS=class extends(XO(YO,QO,MO)){ObjectElement(e){const t=eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"];return this.element=this.toRefractedElement(t,e),Aj}ArrayElement(e){return this.element=new Ux,this.element.classes.push("json-schema-items"),e.forEach((e=>{const t=eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"],r=this.toRefractedElement(t,e);this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}};let rS=class extends YO{specPath;ignoredFields;fieldPatternPredicate=_h;constructor({specPath:e,ignoredFields:t,fieldPatternPredicate:r,...n}){super({...n}),this.specPath=e,this.ignoredFields=t||[],"function"==typeof r&&(this.fieldPatternPredicate=r)}ObjectElement(e){return e.forEach(((e,t,r)=>{if(!this.ignoredFields.includes(oE(t))&&this.fieldPatternPredicate(oE(t))){const n=this.specPath(e),s=this.toRefractedElement(n,e),i=new Vx(Cj(t),s);this.copyMetaAndAttributes(r,i),i.classes.push("patterned-field"),this.element.content.push(i)}else this.ignoredFields.includes(oE(t))||this.element.content.push(Cj(r))})),this.copyMetaAndAttributes(e,this.element),Aj}},nS=class extends rS{constructor(e){super(e),this.fieldPatternPredicate=Xd}},sS=class extends(XO(nS,QO,MO)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-properties"),this.specPath=e=>eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"]}},iS=class extends(XO(nS,QO,MO)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-patternProperties"),this.specPath=e=>eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"]}};class oS extends(XO(nS,QO,MO)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-dependencies"),this.specPath=e=>eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"]}}let cS=class extends(XO(YO,QO,MO)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-allOf")}ArrayElement(e){return e.forEach((e=>{const t=eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"],r=this.toRefractedElement(t,e);this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}},aS=class extends(XO(YO,QO,MO)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-anyOf")}ArrayElement(e){return e.forEach((e=>{const t=eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"],r=this.toRefractedElement(t,e);this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}},uS=class extends(XO(YO,QO,MO)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-oneOf")}ArrayElement(e){return e.forEach((e=>{const t=eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"],r=this.toRefractedElement(t,e);this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}};class lS extends(XO(nS,QO,MO)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-definitions"),this.specPath=e=>eS(e)?["document","objects","JSONReference"]:["document","objects","JSONSchema"]}}let hS=class extends(XO(YO,QO,MO)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-links")}ArrayElement(e){return e.forEach((e=>{const t=this.toRefractedElement(["document","objects","LinkDescription"],e);this.element.push(t)})),this.copyMetaAndAttributes(e,this.element),Aj}};class fS extends(XO(ZO,MO)){constructor(e){super(e),this.element=new kO,this.specPath=Wf(["document","objects","JSONReference"])}ObjectElement(e){const t=ZO.prototype.ObjectElement.call(this,e);return ij(this.element.$ref)&&this.element.classes.push("reference-element"),t}}let pS=class extends YO{alternator;constructor({alternator:e,...t}){super({...t}),this.alternator=e}enter(e){const t=this.alternator.map((({predicate:e,specPath:t})=>Yp(e,Wf(t),Fd))),r=pm(t)(e);return this.element=this.toRefractedElement(r,e),Aj}},dS=class extends pS{constructor(e){super(e),this.alternator=[{predicate:eS,specPath:["document","objects","JSONReference"]},{predicate:Ch,specPath:["document","objects","JSONSchema"]}]}};class mS extends(XO(ZO,MO)){constructor(e){super(e),this.element=new FO,this.specPath=Wf(["document","objects","Media"])}}class vS extends(XO(ZO,MO)){constructor(e){super(e),this.element=new IO,this.specPath=Wf(["document","objects","LinkDescription"])}}const yS={visitors:{value:MO,JSONSchemaOrJSONReferenceVisitor:dS,document:{objects:{JSONSchema:{$visitor:KO,fixedFields:{id:{$ref:"#/visitors/value"},$schema:{$ref:"#/visitors/value"},multipleOf:{$ref:"#/visitors/value"},maximum:{$ref:"#/visitors/value"},exclusiveMaximum:{$ref:"#/visitors/value"},minimum:{$ref:"#/visitors/value"},exclusiveMinimum:{$ref:"#/visitors/value"},maxLength:{$ref:"#/visitors/value"},minLength:{$ref:"#/visitors/value"},pattern:{$ref:"#/visitors/value"},additionalItems:dS,items:tS,maxItems:{$ref:"#/visitors/value"},minItems:{$ref:"#/visitors/value"},uniqueItems:{$ref:"#/visitors/value"},maxProperties:{$ref:"#/visitors/value"},minProperties:{$ref:"#/visitors/value"},required:class extends MO{ArrayElement(e){const t=this.enter(e);return this.element.classes.push("json-schema-required"),t}},properties:sS,additionalProperties:dS,patternProperties:iS,dependencies:oS,enum:class extends MO{ArrayElement(e){const t=this.enter(e);return this.element.classes.push("json-schema-enum"),t}},type:class extends MO{StringElement(e){const t=this.enter(e);return this.element.classes.push("json-schema-type"),t}ArrayElement(e){const t=this.enter(e);return this.element.classes.push("json-schema-type"),t}},allOf:cS,anyOf:aS,oneOf:uS,not:dS,definitions:lS,title:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},default:{$ref:"#/visitors/value"},format:{$ref:"#/visitors/value"},base:{$ref:"#/visitors/value"},links:hS,media:{$ref:"#/visitors/document/objects/Media"},readOnly:{$ref:"#/visitors/value"}}},JSONReference:{$visitor:fS,fixedFields:{$ref:class extends MO{StringElement(e){const t=this.enter(e);return this.element.classes.push("reference-value"),t}}}},Media:{$visitor:mS,fixedFields:{binaryEncoding:{$ref:"#/visitors/value"},type:{$ref:"#/visitors/value"}}},LinkDescription:{$visitor:vS,fixedFields:{href:{$ref:"#/visitors/value"},rel:{$ref:"#/visitors/value"},title:{$ref:"#/visitors/value"},targetSchema:dS,mediaType:{$ref:"#/visitors/value"},method:{$ref:"#/visitors/value"},encType:{$ref:"#/visitors/value"},schema:dS}}}}}},bS=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof TO||e(n)&&t("JSONSchemaDraft4",n)&&r("object",n))),gS=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof kO||e(n)&&t("JSONReference",n)&&r("object",n))),wS=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof FO||e(n)&&t("media",n)&&r("object",n))),xS=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof IO||e(n)&&t("linkDescription",n)&&r("object",n))),jS=Object.freeze(Object.defineProperty({__proto__:null,isJSONReferenceElement:gS,isJSONSchemaElement:bS,isLinkDescriptionElement:xS,isMediaElement:wS},Symbol.toStringTag,{value:"Module"})),ES=()=>{const e=$j(RO);return{predicates:{...jS,isStringElement:ij},namespace:e}},$S=e=>(t,r={})=>((e,{specPath:t=["visitors","document","objects","JSONSchema","$visitor"],plugins:r=[],specificationObj:n=yS}={})=>{const s=zx(e),i=uE(n),o=new(pd(t,i))({specObj:i});return Gj(s,o),zj(o.element,r,{toolboxCreator:ES,visitorOptions:{keyMap:_O,nodeTypeGetter:DO}})})(t,{specPath:e,...r});TO.refract=$S(["visitors","document","objects","JSONSchema","$visitor"]),kO.refract=$S(["visitors","document","objects","JSONReference","$visitor"]),FO.refract=$S(["visitors","document","objects","Media","$visitor"]),IO.refract=$S(["visitors","document","objects","LinkDescription","$visitor"]);let OS=class extends TO{constructor(e,t,r){super(e,t,r),this.element="schema",this.classes.push("json-schema-draft-4")}get idProp(){throw new Rh("idProp getter in Schema class is not not supported.")}set idProp(e){throw new Rh("idProp setter in Schema class is not not supported.")}get $schema(){throw new Rh("$schema getter in Schema class is not not supported.")}set $schema(e){throw new Rh("$schema setter in Schema class is not not supported.")}get additionalItems(){return this.get("additionalItems")}set additionalItems(e){this.set("additionalItems",e)}get items(){return this.get("items")}set items(e){this.set("items",e)}get additionalProperties(){return this.get("additionalProperties")}set additionalProperties(e){this.set("additionalProperties",e)}get patternProperties(){throw new Rh("patternProperties getter in Schema class is not not supported.")}set patternProperties(e){throw new Rh("patternProperties setter in Schema class is not not supported.")}get dependencies(){throw new Rh("dependencies getter in Schema class is not not supported.")}set dependencies(e){throw new Rh("dependencies setter in Schema class is not not supported.")}get type(){return this.get("type")}set type(e){this.set("type",e)}get not(){return this.get("not")}set not(e){this.set("not",e)}get definitions(){throw new Rh("definitions getter in Schema class is not not supported.")}set definitions(e){throw new Rh("definitions setter in Schema class is not not supported.")}get base(){throw new Rh("base getter in Schema class is not not supported.")}set base(e){throw new Rh("base setter in Schema class is not not supported.")}get links(){throw new Rh("links getter in Schema class is not not supported.")}set links(e){throw new Rh("links setter in Schema class is not not supported.")}get media(){throw new Rh("media getter in Schema class is not not supported.")}set media(e){throw new Rh("media setter in Schema class is not not supported.")}get nullable(){return this.get("nullable")}set nullable(e){this.set("nullable",e)}get discriminator(){return this.get("discriminator")}set discriminator(e){this.set("discriminator",e)}get writeOnly(){return this.get("writeOnly")}set writeOnly(e){this.set("writeOnly",e)}get xml(){return this.get("xml")}set xml(e){this.set("xml",e)}get externalDocs(){return this.get("externalDocs")}set externalDocs(e){this.set("externalDocs",e)}get example(){return this.get("example")}set example(e){this.set("example",e)}get deprecated(){return this.get("deprecated")}set deprecated(e){this.set("deprecated",e)}},SS=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="securityRequirement"}},AS=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="securityScheme"}get type(){return this.get("type")}set type(e){this.set("type",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get name(){return this.get("name")}set name(e){this.set("name",e)}get in(){return this.get("in")}set in(e){this.set("in",e)}get scheme(){return this.get("scheme")}set scheme(e){this.set("scheme",e)}get bearerFormat(){return this.get("bearerFormat")}set bearerFormat(e){this.set("bearerFormat",e)}get flows(){return this.get("flows")}set flows(e){this.set("flows",e)}get openIdConnectUrl(){return this.get("openIdConnectUrl")}set openIdConnectUrl(e){this.set("openIdConnectUrl",e)}},PS=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="server"}get url(){return this.get("url")}set url(e){this.set("url",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get variables(){return this.get("variables")}set variables(e){this.set("variables",e)}},TS=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="serverVariable"}get enum(){return this.get("enum")}set enum(e){this.set("enum",e)}get default(){return this.get("default")}set default(e){this.set("default",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}},kS=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="tag"}get name(){return this.get("name")}set name(e){this.set("name",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get externalDocs(){return this.get("externalDocs")}set externalDocs(e){this.set("externalDocs",e)}},FS=class extends Jx{constructor(e,t,r){super(e,t,r),this.element="xml"}get name(){return this.get("name")}set name(e){this.set("name",e)}get namespace(){return this.get("namespace")}set namespace(e){this.set("namespace",e)}get prefix(){return this.get("prefix")}set prefix(e){this.set("prefix",e)}get attribute(){return this.get("attribute")}set attribute(e){this.set("attribute",e)}get wrapped(){return this.get("wrapped")}set wrapped(e){this.set("wrapped",e)}};const IS={namespace:e=>{const{base:t}=e;return t.register("callback",iO),t.register("components",oO),t.register("contact",cO),t.register("discriminator",aO),t.register("encoding",uO),t.register("example",lO),t.register("externalDocumentation",hO),t.register("header",fO),t.register("info",pO),t.register("license",dO),t.register("link",mO),t.register("mediaType",vO),t.register("oAuthFlow",yO),t.register("oAuthFlows",bO),t.register("openapi",gO),t.register("openApi3_0",wO),t.register("operation",xO),t.register("parameter",jO),t.register("pathItem",EO),t.register("paths",$O),t.register("reference",OO),t.register("requestBody",SO),t.register("response",AO),t.register("responses",PO),t.register("schema",OS),t.register("securityRequirement",SS),t.register("securityScheme",AS),t.register("server",PS),t.register("serverVariable",TS),t.register("tag",kS),t.register("xml",FS),t}};class RS extends Ux{static primaryClass="servers";constructor(e,t,r){super(e,t,r),this.classes.push(RS.primaryClass)}}class DS extends Ux{static primaryClass="security";constructor(e,t,r){super(e,t,r),this.classes.push(DS.primaryClass)}}class _S extends Ux{static primaryClass="tags";constructor(e,t,r){super(e,t,r),this.classes.push(_S.primaryClass)}}class CS extends Jx{static primaryClass="server-variables";constructor(e,t,r){super(e,t,r),this.classes.push(CS.primaryClass)}}class MS extends Jx{static primaryClass="components-schemas";constructor(e,t,r){super(e,t,r),this.classes.push(MS.primaryClass)}}class NS extends Jx{static primaryClass="components-responses";constructor(e,t,r){super(e,t,r),this.classes.push(NS.primaryClass)}}class qS extends Jx{static primaryClass="components-parameters";constructor(e,t,r){super(e,t,r),this.classes.push(qS.primaryClass),this.classes.push("parameters")}}class BS extends Jx{static primaryClass="components-examples";constructor(e,t,r){super(e,t,r),this.classes.push(BS.primaryClass),this.classes.push("examples")}}class LS extends Jx{static primaryClass="components-request-bodies";constructor(e,t,r){super(e,t,r),this.classes.push(LS.primaryClass)}}class US extends Jx{static primaryClass="components-headers";constructor(e,t,r){super(e,t,r),this.classes.push(US.primaryClass)}}class JS extends Jx{static primaryClass="components-security-schemes";constructor(e,t,r){super(e,t,r),this.classes.push(JS.primaryClass)}}class VS extends Jx{static primaryClass="components-links";constructor(e,t,r){super(e,t,r),this.classes.push(VS.primaryClass)}}class GS extends Jx{static primaryClass="components-callbacks";constructor(e,t,r){super(e,t,r),this.classes.push(GS.primaryClass)}}class HS extends Ux{static primaryClass="path-item-servers";constructor(e,t,r){super(e,t,r),this.classes.push(HS.primaryClass),this.classes.push("servers")}}class zS extends Ux{static primaryClass="path-item-parameters";constructor(e,t,r){super(e,t,r),this.classes.push(zS.primaryClass),this.classes.push("parameters")}}class XS extends Ux{static primaryClass="operation-parameters";constructor(e,t,r){super(e,t,r),this.classes.push(XS.primaryClass),this.classes.push("parameters")}}class WS extends Jx{static primaryClass="parameter-examples";constructor(e,t,r){super(e,t,r),this.classes.push(WS.primaryClass),this.classes.push("examples")}}class YS extends Jx{static primaryClass="parameter-content";constructor(e,t,r){super(e,t,r),this.classes.push(YS.primaryClass),this.classes.push("content")}}class ZS extends Ux{static primaryClass="operation-tags";constructor(e,t,r){super(e,t,r),this.classes.push(ZS.primaryClass)}}class KS extends Jx{static primaryClass="operation-callbacks";constructor(e,t,r){super(e,t,r),this.classes.push(KS.primaryClass)}}class QS extends Ux{static primaryClass="operation-security";constructor(e,t,r){super(e,t,r),this.classes.push(QS.primaryClass),this.classes.push("security")}}class eA extends Ux{static primaryClass="operation-servers";constructor(e,t,r){super(e,t,r),this.classes.push(eA.primaryClass),this.classes.push("servers")}}class tA extends Jx{static primaryClass="request-body-content";constructor(e,t,r){super(e,t,r),this.classes.push(tA.primaryClass),this.classes.push("content")}}class rA extends Jx{static primaryClass="media-type-examples";constructor(e,t,r){super(e,t,r),this.classes.push(rA.primaryClass),this.classes.push("examples")}}class nA extends Jx{static primaryClass="media-type-encoding";constructor(e,t,r){super(e,t,r),this.classes.push(nA.primaryClass)}}class sA extends Jx{static primaryClass="encoding-headers";constructor(e,t,r){super(e,t,r),this.classes.push(sA.primaryClass)}}class iA extends Jx{static primaryClass="response-headers";constructor(e,t,r){super(e,t,r),this.classes.push(iA.primaryClass)}}class oA extends Jx{static primaryClass="response-content";constructor(e,t,r){super(e,t,r),this.classes.push(oA.primaryClass),this.classes.push("content")}}class cA extends Jx{static primaryClass="response-links";constructor(e,t,r){super(e,t,r),this.classes.push(cA.primaryClass)}}class aA extends Jx{static primaryClass="discriminator-mapping";constructor(e,t,r){super(e,t,r),this.classes.push(aA.primaryClass)}}class uA extends Jx{static primaryClass="oauth-flow-scopes";constructor(e,t,r){super(e,t,r),this.classes.push(uA.primaryClass)}}class lA extends Jx{static primaryClass="link-parameters";constructor(e,t,r){super(e,t,r),this.classes.push(lA.primaryClass)}}class hA extends Jx{static primaryClass="header-examples";constructor(e,t,r){super(e,t,r),this.classes.push(hA.primaryClass),this.classes.push("examples")}}class fA extends Jx{static primaryClass="header-content";constructor(e,t,r){super(e,t,r),this.classes.push(fA.primaryClass),this.classes.push("content")}}const pA=e=>{if(sj(e))return`${e.element.charAt(0).toUpperCase()+e.element.slice(1)}Element`},dA={CallbackElement:["content"],ComponentsElement:["content"],ContactElement:["content"],DiscriminatorElement:["content"],Encoding:["content"],Example:["content"],ExternalDocumentationElement:["content"],HeaderElement:["content"],InfoElement:["content"],LicenseElement:["content"],MediaTypeElement:["content"],OAuthFlowElement:["content"],OAuthFlowsElement:["content"],OpenApi3_0Element:["content"],OperationElement:["content"],ParameterElement:["content"],PathItemElement:["content"],PathsElement:["content"],ReferenceElement:["content"],RequestBodyElement:["content"],ResponseElement:["content"],ResponsesElement:["content"],SchemaElement:["content"],SecurityRequirementElement:["content"],SecuritySchemeElement:["content"],ServerElement:["content"],ServerVariableElement:["content"],TagElement:["content"],...Jj};class mA{element;constructor(e={}){Object.assign(this,e)}copyMetaAndAttributes(e,t){(e.meta.length>0||t.meta.length>0)&&(t.meta=dE(t.meta,e.meta),gj(e)&&t.meta.set("sourceMap",e.meta.get("sourceMap"))),(e.attributes.length>0||e.meta.length>0)&&(t.attributes=dE(t.attributes,e.attributes))}}class vA extends mA{enter(e){return this.element=Cj(e),Aj}}class yA extends mA{specObj;passingOptionsNames=["specObj","openApiGenericElement","openApiSemanticElement"];openApiGenericElement;openApiSemanticElement;constructor({specObj:e,passingOptionsNames:t,openApiGenericElement:r,openApiSemanticElement:n,...s}){super({...s}),this.specObj=e,this.openApiGenericElement=r,this.openApiSemanticElement=n,Array.isArray(t)&&(this.passingOptionsNames=t)}retrievePassingOptions(){return vd(this.passingOptionsNames,this)}retrieveFixedFields(e){const t=pd(["visitors",...e,"fixedFields"],this.specObj);return"object"==typeof t&&null!==t?Object.keys(t):[]}retrieveVisitor(e){return md(qd,["visitors",...e],this.specObj)?pd(["visitors",...e],this.specObj):pd(["visitors",...e,"$visitor"],this.specObj)}retrieveVisitorInstance(e,t={}){const r=this.retrievePassingOptions();return new(this.retrieveVisitor(e))({...r,...t})}toRefractedElement(e,t,r={}){const n=this.retrieveVisitorInstance(e,r);return n instanceof vA&&(null==n?void 0:n.constructor)===vA?Cj(t):(Gj(t,n,r),n.element)}}const bA=e=>uj(e)&&e.hasKey("$ref"),gA=uj,wA=uj,xA=e=>ij(e.key)&&Od("x-",oE(e.key));class jA extends yA{specPath;ignoredFields;canSupportSpecificationExtensions=!0;specificationExtensionPredicate=xA;constructor({specPath:e,ignoredFields:t,canSupportSpecificationExtensions:r,specificationExtensionPredicate:n,...s}){super({...s}),this.specPath=e,this.ignoredFields=t||[],"boolean"==typeof r&&(this.canSupportSpecificationExtensions=r),"function"==typeof n&&(this.specificationExtensionPredicate=n)}ObjectElement(e){const t=this.specPath(e),r=this.retrieveFixedFields(t);return e.forEach(((e,n,s)=>{if(ij(n)&&r.includes(oE(n))&&!this.ignoredFields.includes(oE(n))){const r=this.toRefractedElement([...t,"fixedFields",oE(n)],e),i=new Vx(Cj(n),r);this.copyMetaAndAttributes(s,i),i.classes.push("fixed-field"),this.element.content.push(i)}else if(this.canSupportSpecificationExtensions&&this.specificationExtensionPredicate(s)){const e=this.toRefractedElement(["document","extension"],s);this.element.content.push(e)}else this.ignoredFields.includes(oE(n))||this.element.content.push(Cj(s))})),this.copyMetaAndAttributes(e,this.element),Aj}}class EA extends(XO(jA,vA)){constructor(e){super(e),this.element=new wO,this.specPath=Wf(["document","objects","OpenApi"]),this.canSupportSpecificationExtensions=!0}ObjectElement(e){return jA.prototype.ObjectElement.call(this,e)}}class $A extends(XO(yA,vA)){StringElement(e){const t=new gO(oE(e));return this.copyMetaAndAttributes(e,t),this.element=t,Aj}}let OA=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new pO,this.specPath=Wf(["document","objects","Info"]),this.canSupportSpecificationExtensions=!0}};let SA=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new cO,this.specPath=Wf(["document","objects","Contact"]),this.canSupportSpecificationExtensions=!0}},AA=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new dO,this.specPath=Wf(["document","objects","License"]),this.canSupportSpecificationExtensions=!0}},PA=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new mO,this.specPath=Wf(["document","objects","Link"]),this.canSupportSpecificationExtensions=!0}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return(ij(this.element.operationId)||ij(this.element.operationRef))&&this.element.classes.push("reference-element"),t}};class TA extends yA{specPath;ignoredFields;fieldPatternPredicate=_h;canSupportSpecificationExtensions=!1;specificationExtensionPredicate=xA;constructor({specPath:e,ignoredFields:t,fieldPatternPredicate:r,canSupportSpecificationExtensions:n,specificationExtensionPredicate:s,...i}){super({...i}),this.specPath=e,this.ignoredFields=t||[],"function"==typeof r&&(this.fieldPatternPredicate=r),"boolean"==typeof n&&(this.canSupportSpecificationExtensions=n),"function"==typeof s&&(this.specificationExtensionPredicate=s)}ObjectElement(e){return e.forEach(((e,t,r)=>{if(this.canSupportSpecificationExtensions&&this.specificationExtensionPredicate(r)){const e=this.toRefractedElement(["document","extension"],r);this.element.content.push(e)}else if(!this.ignoredFields.includes(oE(t))&&this.fieldPatternPredicate(oE(t))){const n=this.specPath(e),s=this.toRefractedElement(n,e),i=new Vx(Cj(t),s);this.copyMetaAndAttributes(r,i),i.classes.push("patterned-field"),this.element.content.push(i)}else this.ignoredFields.includes(oE(t))||this.element.content.push(Cj(r))})),this.copyMetaAndAttributes(e,this.element),Aj}}class kA extends TA{constructor(e){super(e),this.fieldPatternPredicate=Xd}}let FA=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new lA,this.specPath=Wf(["value"])}},IA=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new PS,this.specPath=Wf(["document","objects","Server"]),this.canSupportSpecificationExtensions=!0}};let RA=class extends(XO(yA,vA)){constructor(e){super(e),this.element=new RS}ArrayElement(e){return e.forEach((e=>{const t=gA(e)?["document","objects","Server"]:["value"],r=this.toRefractedElement(t,e);this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}},DA=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new TS,this.specPath=Wf(["document","objects","ServerVariable"]),this.canSupportSpecificationExtensions=!0}};class _A extends(XO(kA,vA)){constructor(e){super(e),this.element=new CS,this.specPath=Wf(["document","objects","ServerVariable"])}}let CA=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new vO,this.specPath=Wf(["document","objects","MediaType"]),this.canSupportSpecificationExtensions=!0}};class MA extends yA{alternator;constructor({alternator:e,...t}){super({...t}),this.alternator=e||[]}enter(e){const t=this.alternator.map((({predicate:e,specPath:t})=>Yp(e,Wf(t),Fd))),r=pm(t)(e);return this.element=this.toRefractedElement(r,e),Aj}}const NA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof iO||e(n)&&t("callback",n)&&r("object",n))),qA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof oO||e(n)&&t("components",n)&&r("object",n))),BA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof cO||e(n)&&t("contact",n)&&r("object",n))),LA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof lO||e(n)&&t("example",n)&&r("object",n))),UA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof hO||e(n)&&t("externalDocumentation",n)&&r("object",n))),JA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof fO||e(n)&&t("header",n)&&r("object",n))),VA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof pO||e(n)&&t("info",n)&&r("object",n))),GA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof dO||e(n)&&t("license",n)&&r("object",n))),HA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof mO||e(n)&&t("link",n)&&r("object",n))),zA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof gO||e(n)&&t("openapi",n)&&r("string",n))),XA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r,hasClass:n})=>s=>s instanceof wO||e(s)&&t("openApi3_0",s)&&r("object",s)&&n("api",s))),WA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof xO||e(n)&&t("operation",n)&&r("object",n))),YA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof jO||e(n)&&t("parameter",n)&&r("object",n))),ZA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof EO||e(n)&&t("pathItem",n)&&r("object",n))),KA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof $O||e(n)&&t("paths",n)&&r("object",n))),QA=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof OO||e(n)&&t("reference",n)&&r("object",n))),eP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof SO||e(n)&&t("requestBody",n)&&r("object",n))),tP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof AO||e(n)&&t("response",n)&&r("object",n))),rP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof PO||e(n)&&t("responses",n)&&r("object",n))),nP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof OS||e(n)&&t("schema",n)&&r("object",n))),sP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof SS||e(n)&&t("securityRequirement",n)&&r("object",n))),iP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof AS||e(n)&&t("securityScheme",n)&&r("object",n))),oP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof PS||e(n)&&t("server",n)&&r("object",n))),cP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof TS||e(n)&&t("serverVariable",n)&&r("object",n))),aP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof vO||e(n)&&t("mediaType",n)&&r("object",n))),uP=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r,hasClass:n})=>s=>s instanceof RS||e(s)&&t("array",s)&&r("array",s)&&n("servers",s))),lP=Object.freeze(Object.defineProperty({__proto__:null,isBooleanJsonSchemaElement:e=>aj(e)&&e.classes.includes("boolean-json-schema"),isCallbackElement:NA,isComponentsElement:qA,isContactElement:BA,isExampleElement:LA,isExternalDocumentationElement:UA,isHeaderElement:JA,isInfoElement:VA,isLicenseElement:GA,isLinkElement:HA,isMediaTypeElement:aP,isOpenApi3_0Element:XA,isOpenapiElement:zA,isOperationElement:WA,isParameterElement:YA,isPathItemElement:ZA,isPathsElement:KA,isReferenceElement:QA,isRequestBodyElement:eP,isResponseElement:tP,isResponsesElement:rP,isSchemaElement:nP,isSecurityRequirementElement:sP,isSecuritySchemeElement:iP,isServerElement:oP,isServerVariableElement:cP,isServersElement:uP},Symbol.toStringTag,{value:"Module"}));let hP=class extends(XO(MA,vA)){constructor(e){super(e),this.alternator=[{predicate:bA,specPath:["document","objects","Reference"]},{predicate:Ch,specPath:["document","objects","Schema"]}]}ObjectElement(e){const t=MA.prototype.enter.call(this,e);return QA(this.element)&&this.element.setMetaProperty("referenced-element","schema"),t}},fP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("examples"),this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Example"],this.canSupportSpecificationExtensions=!0}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","example")})),t}},pP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new nA,this.specPath=Wf(["document","objects","Encoding"])}},dP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new SS,this.specPath=Wf(["value"])}},mP=class extends(XO(yA,vA)){constructor(e){super(e),this.element=new DS}ArrayElement(e){return e.forEach((e=>{if(uj(e)){const t=this.toRefractedElement(["document","objects","SecurityRequirement"],e);this.element.push(t)}else this.element.push(Cj(e))})),this.copyMetaAndAttributes(e,this.element),Aj}},vP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new oO,this.specPath=Wf(["document","objects","Components"]),this.canSupportSpecificationExtensions=!0}},yP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new kS,this.specPath=Wf(["document","objects","Tag"]),this.canSupportSpecificationExtensions=!0}},bP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new OO,this.specPath=Wf(["document","objects","Reference"]),this.canSupportSpecificationExtensions=!1}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return ij(this.element.$ref)&&this.element.classes.push("reference-element"),t}},gP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new jO,this.specPath=Wf(["document","objects","Parameter"]),this.canSupportSpecificationExtensions=!0}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return uj(this.element.contentProp)&&this.element.contentProp.filter(aP).forEach(((e,t)=>{e.setMetaProperty("media-type",oE(t))})),t}},wP=class extends(XO(MA,vA)){constructor(e){super(e),this.alternator=[{predicate:bA,specPath:["document","objects","Reference"]},{predicate:Ch,specPath:["document","objects","Schema"]}]}ObjectElement(e){const t=MA.prototype.enter.call(this,e);return QA(this.element)&&this.element.setMetaProperty("referenced-element","schema"),t}},xP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new fO,this.specPath=Wf(["document","objects","Header"]),this.canSupportSpecificationExtensions=!0}},jP=class extends(XO(MA,vA)){constructor(e){super(e),this.alternator=[{predicate:bA,specPath:["document","objects","Reference"]},{predicate:Ch,specPath:["document","objects","Schema"]}]}ObjectElement(e){const t=MA.prototype.enter.call(this,e);return QA(this.element)&&this.element.setMetaProperty("referenced-element","schema"),t}},EP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("content"),this.specPath=Wf(["document","objects","MediaType"])}},$P=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new OS,this.specPath=Wf(["document","objects","Schema"]),this.canSupportSpecificationExtensions=!0}};const{allOf:OP}=yS.visitors.document.objects.JSONSchema.fixedFields;const{anyOf:SP}=yS.visitors.document.objects.JSONSchema.fixedFields;const{oneOf:AP}=yS.visitors.document.objects.JSONSchema.fixedFields;const{items:PP}=yS.visitors.document.objects.JSONSchema.fixedFields;const{properties:TP}=yS.visitors.document.objects.JSONSchema.fixedFields;const{type:kP}=yS.visitors.document.objects.JSONSchema.fixedFields;const{JSONSchemaOrJSONReferenceVisitor:FP}=yS.visitors;class IP extends FP{ObjectElement(e){const t=FP.prototype.enter.call(this,e);return QA(this.element)&&this.element.setMetaProperty("referenced-element","schema"),t}}let RP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new aO,this.specPath=Wf(["document","objects","Discriminator"]),this.canSupportSpecificationExtensions=!1}};class DP extends(XO(kA,vA)){constructor(e){super(e),this.element=new aA,this.specPath=Wf(["value"])}}let _P=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new FS,this.specPath=Wf(["document","objects","XML"]),this.canSupportSpecificationExtensions=!0}},CP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new MS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Schema"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","schema")})),t}},MP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new NS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Response"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","response")})),this.element.filter(tP).forEach(((e,t)=>{e.setMetaProperty("http-status-code",oE(t))})),t}},NP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new qS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Parameter"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","parameter")})),t}},qP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new BS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Example"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","example")})),t}};class BP extends(XO(kA,vA)){constructor(e){super(e),this.element=new LS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","RequestBody"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","requestBody")})),t}}let LP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new US,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Header"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","header")})),this.element.filter(JA).forEach(((e,t)=>{e.setMetaProperty("header-name",oE(t))})),t}};class UP extends(XO(kA,vA)){constructor(e){super(e),this.element=new JS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","SecurityScheme"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","securityScheme")})),t}}let JP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new VS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Link"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","link")})),t}},VP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new GS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Callback"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","callback")})),t}},GP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new lO,this.specPath=Wf(["document","objects","Example"]),this.canSupportSpecificationExtensions=!0}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return ij(this.element.externalValue)&&this.element.classes.push("reference-element"),t}};let HP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new hO,this.specPath=Wf(["document","objects","ExternalDocumentation"]),this.canSupportSpecificationExtensions=!0}},zP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new uO,this.specPath=Wf(["document","objects","Encoding"]),this.canSupportSpecificationExtensions=!0}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return uj(this.element.headers)&&this.element.headers.filter(JA).forEach(((e,t)=>{e.setMetaProperty("header-name",oE(t))})),t}},XP=class extends(XO(kA,vA)){constructor(e){super(e),this.element=new sA,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Header"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","header")})),this.element.forEach(((e,t)=>{if(!JA(e))return;const r=oE(t);e.setMetaProperty("headerName",r)})),t}},WP=class extends(XO(TA,vA)){constructor(e){super(e),this.element=new $O,this.specPath=Wf(["document","objects","PathItem"]),this.canSupportSpecificationExtensions=!0,this.fieldPatternPredicate=Ch}ObjectElement(e){const t=TA.prototype.ObjectElement.call(this,e);return this.element.filter(ZA).forEach(((e,t)=>{t.classes.push("openapi-path-template"),t.classes.push("path-template"),e.setMetaProperty("path",Cj(t))})),t}},YP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new SO,this.specPath=Wf(["document","objects","RequestBody"])}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return uj(this.element.contentProp)&&this.element.contentProp.filter(aP).forEach(((e,t)=>{e.setMetaProperty("media-type",oE(t))})),t}},ZP=class extends(XO(TA,vA)){constructor(e){super(e),this.element=new iO,this.specPath=Wf(["document","objects","PathItem"]),this.canSupportSpecificationExtensions=!0,this.fieldPatternPredicate=e=>/{(?<expression>[^}]{1,2083})}/.test(String(e))}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(ZA).forEach(((e,t)=>{e.setMetaProperty("runtime-expression",oE(t))})),t}},KP=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new AO,this.specPath=Wf(["document","objects","Response"])}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return uj(this.element.contentProp)&&this.element.contentProp.filter(aP).forEach(((e,t)=>{e.setMetaProperty("media-type",oE(t))})),uj(this.element.headers)&&this.element.headers.filter(JA).forEach(((e,t)=>{e.setMetaProperty("header-name",oE(t))})),t}};class QP extends(XO(kA,vA)){constructor(e){super(e),this.element=new iA,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Header"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","header")})),this.element.forEach(((e,t)=>{if(!JA(e))return;const r=oE(t);e.setMetaProperty("header-name",r)})),t}}class eT extends(XO(kA,vA)){constructor(e){super(e),this.element=new cA,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Link"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","link")})),t}}class tT extends(XO(jA,TA)){specPathFixedFields;specPathPatternedFields;constructor({specPathFixedFields:e,specPathPatternedFields:t,...r}){super({...r}),this.specPathFixedFields=e,this.specPathPatternedFields=t}ObjectElement(e){const{specPath:t,ignoredFields:r}=this;try{this.specPath=this.specPathFixedFields;const t=this.retrieveFixedFields(this.specPath(e));this.ignoredFields=[...r,...kp(e.keys(),t)],jA.prototype.ObjectElement.call(this,e),this.specPath=this.specPathPatternedFields,this.ignoredFields=t,TA.prototype.ObjectElement.call(this,e)}catch(e){throw this.specPath=t,e}return Aj}}let rT=class extends(XO(tT,vA)){constructor(e){super(e),this.element=new PO,this.specPathFixedFields=Wf(["document","objects","Responses"]),this.canSupportSpecificationExtensions=!0,this.specPathPatternedFields=e=>bA(e)?["document","objects","Reference"]:["document","objects","Response"],this.fieldPatternPredicate=e=>new RegExp(`^(1XX|2XX|3XX|4XX|5XX|${wd(100,600).join("|")})$`).test(String(e))}ObjectElement(e){const t=tT.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","response")})),this.element.filter(tP).forEach(((e,t)=>{const r=Cj(t);this.fieldPatternPredicate(oE(r))&&e.setMetaProperty("http-status-code",r)})),t}};class nT extends(XO(MA,vA)){constructor(e){super(e),this.alternator=[{predicate:bA,specPath:["document","objects","Reference"]},{predicate:Ch,specPath:["document","objects","Response"]}]}ObjectElement(e){const t=MA.prototype.enter.call(this,e);return QA(this.element)?this.element.setMetaProperty("referenced-element","response"):tP(this.element)&&this.element.setMetaProperty("http-status-code","default"),t}}let sT=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new xO,this.specPath=Wf(["document","objects","Operation"])}},iT=class extends(XO(yA,vA)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("parameters")}ArrayElement(e){return e.forEach((e=>{const t=bA(e)?["document","objects","Reference"]:["document","objects","Parameter"],r=this.toRefractedElement(t,e);QA(r)&&r.setMetaProperty("referenced-element","parameter"),this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}};class oT extends(XO(kA,vA)){specPath;constructor(e){super(e),this.element=new KS,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","Callback"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","callback")})),t}}class cT extends(XO(yA,vA)){constructor(e){super(e),this.element=new QS}ArrayElement(e){return e.forEach((e=>{const t=uj(e)?["document","objects","SecurityRequirement"]:["value"],r=this.toRefractedElement(t,e);this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}}let aT=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new EO,this.specPath=Wf(["document","objects","PathItem"])}ObjectElement(e){const t=jA.prototype.ObjectElement.call(this,e);return this.element.filter(WA).forEach(((e,t)=>{const r=Cj(t);r.content=oE(r).toUpperCase(),e.setMetaProperty("http-method",r)})),ij(this.element.$ref)&&this.element.classes.push("reference-element"),t}};let uT=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new AS,this.specPath=Wf(["document","objects","SecurityScheme"]),this.canSupportSpecificationExtensions=!0}},lT=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new bO,this.specPath=Wf(["document","objects","OAuthFlows"]),this.canSupportSpecificationExtensions=!0}},hT=class extends(XO(jA,vA)){constructor(e){super(e),this.element=new yO,this.specPath=Wf(["document","objects","OAuthFlow"]),this.canSupportSpecificationExtensions=!0}};class fT extends(XO(kA,vA)){constructor(e){super(e),this.element=new uA,this.specPath=Wf(["value"])}}class pT extends(XO(yA,vA)){constructor(e){super(e),this.element=new _S}ArrayElement(e){return e.forEach((e=>{const t=wA(e)?["document","objects","Tag"]:["value"],r=this.toRefractedElement(t,e);this.element.push(r)})),this.copyMetaAndAttributes(e,this.element),Aj}}const{fixedFields:dT}=yS.visitors.document.objects.JSONSchema,mT={visitors:{value:vA,document:{objects:{OpenApi:{$visitor:EA,fixedFields:{openapi:$A,info:{$ref:"#/visitors/document/objects/Info"},servers:RA,paths:{$ref:"#/visitors/document/objects/Paths"},components:{$ref:"#/visitors/document/objects/Components"},security:mP,tags:pT,externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"}}},Info:{$visitor:OA,fixedFields:{title:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},termsOfService:{$ref:"#/visitors/value"},contact:{$ref:"#/visitors/document/objects/Contact"},license:{$ref:"#/visitors/document/objects/License"},version:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("api-version"),this.element.classes.push("version"),t}}}},Contact:{$visitor:SA,fixedFields:{name:{$ref:"#/visitors/value"},url:{$ref:"#/visitors/value"},email:{$ref:"#/visitors/value"}}},License:{$visitor:AA,fixedFields:{name:{$ref:"#/visitors/value"},url:{$ref:"#/visitors/value"}}},Server:{$visitor:IA,fixedFields:{url:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("server-url"),t}},description:{$ref:"#/visitors/value"},variables:_A}},ServerVariable:{$visitor:DA,fixedFields:{enum:{$ref:"#/visitors/value"},default:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"}}},Components:{$visitor:vP,fixedFields:{schemas:CP,responses:MP,parameters:NP,examples:qP,requestBodies:BP,headers:LP,securitySchemes:UP,links:JP,callbacks:VP}},Paths:{$visitor:WP},PathItem:{$visitor:aT,fixedFields:{$ref:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("reference-value"),t}},summary:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},get:{$ref:"#/visitors/document/objects/Operation"},put:{$ref:"#/visitors/document/objects/Operation"},post:{$ref:"#/visitors/document/objects/Operation"},delete:{$ref:"#/visitors/document/objects/Operation"},options:{$ref:"#/visitors/document/objects/Operation"},head:{$ref:"#/visitors/document/objects/Operation"},patch:{$ref:"#/visitors/document/objects/Operation"},trace:{$ref:"#/visitors/document/objects/Operation"},servers:class extends RA{constructor(e){super(e),this.element=new HS}},parameters:class extends iT{constructor(e){super(e),this.element=new zS}}}},Operation:{$visitor:sT,fixedFields:{tags:class extends vA{constructor(e){super(e),this.element=new ZS}ArrayElement(e){return this.element=this.element.concat(Cj(e)),Aj}},summary:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"},operationId:{$ref:"#/visitors/value"},parameters:class extends iT{constructor(e){super(e),this.element=new XS}},requestBody:class extends MA{constructor(e){super(e),this.alternator=[{predicate:bA,specPath:["document","objects","Reference"]},{predicate:Ch,specPath:["document","objects","RequestBody"]}]}ObjectElement(e){const t=MA.prototype.enter.call(this,e);return QA(this.element)&&this.element.setMetaProperty("referenced-element","requestBody"),t}},responses:{$ref:"#/visitors/document/objects/Responses"},callbacks:oT,deprecated:{$ref:"#/visitors/value"},security:cT,servers:class extends RA{constructor(e){super(e),this.element=new eA}}}},ExternalDocumentation:{$visitor:HP,fixedFields:{description:{$ref:"#/visitors/value"},url:{$ref:"#/visitors/value"}}},Parameter:{$visitor:gP,fixedFields:{name:{$ref:"#/visitors/value"},in:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},required:{$ref:"#/visitors/value"},deprecated:{$ref:"#/visitors/value"},allowEmptyValue:{$ref:"#/visitors/value"},style:{$ref:"#/visitors/value"},explode:{$ref:"#/visitors/value"},allowReserved:{$ref:"#/visitors/value"},schema:wP,example:{$ref:"#/visitors/value"},examples:class extends fP{constructor(e){super(e),this.element=new WS}},content:class extends EP{constructor(e){super(e),this.element=new YS}}}},RequestBody:{$visitor:YP,fixedFields:{description:{$ref:"#/visitors/value"},content:class extends EP{constructor(e){super(e),this.element=new tA}},required:{$ref:"#/visitors/value"}}},MediaType:{$visitor:CA,fixedFields:{schema:hP,example:{$ref:"#/visitors/value"},examples:class extends fP{constructor(e){super(e),this.element=new rA}},encoding:pP}},Encoding:{$visitor:zP,fixedFields:{contentType:{$ref:"#/visitors/value"},headers:XP,style:{$ref:"#/visitors/value"},explode:{$ref:"#/visitors/value"},allowReserved:{$ref:"#/visitors/value"}}},Responses:{$visitor:rT,fixedFields:{default:nT}},Response:{$visitor:KP,fixedFields:{description:{$ref:"#/visitors/value"},headers:QP,content:class extends EP{constructor(e){super(e),this.element=new oA}},links:eT}},Callback:{$visitor:ZP},Example:{$visitor:GP,fixedFields:{summary:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},value:{$ref:"#/visitors/value"},externalValue:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("reference-value"),t}}}},Link:{$visitor:PA,fixedFields:{operationRef:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("reference-value"),t}},operationId:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("reference-value"),t}},parameters:FA,requestBody:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},server:{$ref:"#/visitors/document/objects/Server"}}},Header:{$visitor:xP,fixedFields:{description:{$ref:"#/visitors/value"},required:{$ref:"#/visitors/value"},deprecated:{$ref:"#/visitors/value"},allowEmptyValue:{$ref:"#/visitors/value"},style:{$ref:"#/visitors/value"},explode:{$ref:"#/visitors/value"},allowReserved:{$ref:"#/visitors/value"},schema:jP,example:{$ref:"#/visitors/value"},examples:class extends fP{constructor(e){super(e),this.element=new hA}},content:class extends EP{constructor(e){super(e),this.element=new fA}}}},Tag:{$visitor:yP,fixedFields:{name:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"}}},Reference:{$visitor:bP,fixedFields:{$ref:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("reference-value"),t}}}},JSONSchema:{$ref:"#/visitors/document/objects/Schema"},JSONReference:{$ref:"#/visitors/document/objects/Reference"},Schema:{$visitor:$P,fixedFields:{title:dT.title,multipleOf:dT.multipleOf,maximum:dT.maximum,exclusiveMaximum:dT.exclusiveMaximum,minimum:dT.minimum,exclusiveMinimum:dT.exclusiveMinimum,maxLength:dT.maxLength,minLength:dT.minLength,pattern:dT.pattern,maxItems:dT.maxItems,minItems:dT.minItems,uniqueItems:dT.uniqueItems,maxProperties:dT.maxProperties,minProperties:dT.minProperties,required:dT.required,enum:dT.enum,type:class extends kP{ArrayElement(e){return this.enter(e)}},allOf:class extends OP{ArrayElement(e){const t=OP.prototype.ArrayElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","schema")})),t}},anyOf:class extends SP{ArrayElement(e){const t=SP.prototype.ArrayElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","schema")})),t}},oneOf:class extends AP{ArrayElement(e){const t=AP.prototype.ArrayElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","schema")})),t}},not:IP,items:class extends PP{ObjectElement(e){const t=PP.prototype.ObjectElement.call(this,e);return QA(this.element)&&this.element.setMetaProperty("referenced-element","schema"),t}ArrayElement(e){return this.enter(e)}},properties:class extends TP{ObjectElement(e){const t=TP.prototype.ObjectElement.call(this,e);return this.element.filter(QA).forEach((e=>{e.setMetaProperty("referenced-element","schema")})),t}},additionalProperties:IP,description:dT.description,format:dT.format,default:dT.default,nullable:{$ref:"#/visitors/value"},discriminator:{$ref:"#/visitors/document/objects/Discriminator"},writeOnly:{$ref:"#/visitors/value"},xml:{$ref:"#/visitors/document/objects/XML"},externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"},example:{$ref:"#/visitors/value"},deprecated:{$ref:"#/visitors/value"}}},Discriminator:{$visitor:RP,fixedFields:{propertyName:{$ref:"#/visitors/value"},mapping:DP}},XML:{$visitor:_P,fixedFields:{name:{$ref:"#/visitors/value"},namespace:{$ref:"#/visitors/value"},prefix:{$ref:"#/visitors/value"},attribute:{$ref:"#/visitors/value"},wrapped:{$ref:"#/visitors/value"}}},SecurityScheme:{$visitor:uT,fixedFields:{type:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},name:{$ref:"#/visitors/value"},in:{$ref:"#/visitors/value"},scheme:{$ref:"#/visitors/value"},bearerFormat:{$ref:"#/visitors/value"},flows:{$ref:"#/visitors/document/objects/OAuthFlows"},openIdConnectUrl:{$ref:"#/visitors/value"}}},OAuthFlows:{$visitor:lT,fixedFields:{implicit:{$ref:"#/visitors/document/objects/OAuthFlow"},password:{$ref:"#/visitors/document/objects/OAuthFlow"},clientCredentials:{$ref:"#/visitors/document/objects/OAuthFlow"},authorizationCode:{$ref:"#/visitors/document/objects/OAuthFlow"}}},OAuthFlow:{$visitor:hT,fixedFields:{authorizationUrl:{$ref:"#/visitors/value"},tokenUrl:{$ref:"#/visitors/value"},refreshUrl:{$ref:"#/visitors/value"},scopes:fT}},SecurityRequirement:{$visitor:dP}},extension:{$visitor:class extends yA{MemberElement(e){return this.element=Cj(e),this.element.classes.push("specification-extension"),Aj}}}}}},vT=()=>{const e=$j(IS);return{predicates:{...lP,isElement:sj,isStringElement:ij,isArrayElement:lj,isObjectElement:uj,isMemberElement:hj,includesClasses:wj,hasElementSourceMap:gj},namespace:e}},yT=e=>(t,r={})=>((e,{specPath:t=["visitors","document","objects","OpenApi","$visitor"],plugins:r=[]}={})=>{const n=zx(e),s=uE(mT),i=new(pd(t,s))({specObj:s});return Gj(n,i),zj(i.element,r,{toolboxCreator:vT,visitorOptions:{keyMap:dA,nodeTypeGetter:pA}})})(t,{specPath:e,...r});iO.refract=yT(["visitors","document","objects","Callback","$visitor"]),oO.refract=yT(["visitors","document","objects","Components","$visitor"]),cO.refract=yT(["visitors","document","objects","Contact","$visitor"]),lO.refract=yT(["visitors","document","objects","Example","$visitor"]),aO.refract=yT(["visitors","document","objects","Discriminator","$visitor"]),uO.refract=yT(["visitors","document","objects","Encoding","$visitor"]),hO.refract=yT(["visitors","document","objects","ExternalDocumentation","$visitor"]),fO.refract=yT(["visitors","document","objects","Header","$visitor"]),pO.refract=yT(["visitors","document","objects","Info","$visitor"]),dO.refract=yT(["visitors","document","objects","License","$visitor"]),mO.refract=yT(["visitors","document","objects","Link","$visitor"]),vO.refract=yT(["visitors","document","objects","MediaType","$visitor"]),yO.refract=yT(["visitors","document","objects","OAuthFlow","$visitor"]),bO.refract=yT(["visitors","document","objects","OAuthFlows","$visitor"]),gO.refract=yT(["visitors","document","objects","OpenApi","fixedFields","openapi"]),wO.refract=yT(["visitors","document","objects","OpenApi","$visitor"]),xO.refract=yT(["visitors","document","objects","Operation","$visitor"]),jO.refract=yT(["visitors","document","objects","Parameter","$visitor"]),EO.refract=yT(["visitors","document","objects","PathItem","$visitor"]),$O.refract=yT(["visitors","document","objects","Paths","$visitor"]),OO.refract=yT(["visitors","document","objects","Reference","$visitor"]),SO.refract=yT(["visitors","document","objects","RequestBody","$visitor"]),AO.refract=yT(["visitors","document","objects","Response","$visitor"]),PO.refract=yT(["visitors","document","objects","Responses","$visitor"]),OS.refract=yT(["visitors","document","objects","Schema","$visitor"]),SS.refract=yT(["visitors","document","objects","SecurityRequirement","$visitor"]),AS.refract=yT(["visitors","document","objects","SecurityScheme","$visitor"]),PS.refract=yT(["visitors","document","objects","Server","$visitor"]),TS.refract=yT(["visitors","document","objects","ServerVariable","$visitor"]),kS.refract=yT(["visitors","document","objects","Tag","$visitor"]),FS.refract=yT(["visitors","document","objects","XML","$visitor"]);class bT extends iO{}class gT extends oO{get pathItems(){return this.get("pathItems")}set pathItems(e){this.set("pathItems",e)}}class wT extends cO{}class xT extends aO{}class jT extends uO{}class ET extends lO{}class $T extends hO{}class OT extends fO{get schema(){return this.get("schema")}set schema(e){this.set("schema",e)}}class ST extends pO{get license(){return this.get("license")}set license(e){this.set("license",e)}get summary(){return this.get("summary")}set summary(e){this.set("summary",e)}}class AT extends Nx{static default=new AT("https://spec.openapis.org/oas/3.1/dialect/base");constructor(e,t,r){super(e,t,r),this.element="jsonSchemaDialect"}}class PT extends dO{get identifier(){return this.get("identifier")}set identifier(e){this.set("identifier",e)}}class TT extends mO{}class kT extends vO{get schema(){return this.get("schema")}set schema(e){this.set("schema",e)}}class FT extends yO{}class IT extends bO{}class RT extends gO{}class DT extends Jx{constructor(e,t,r){super(e,t,r),this.element="openApi3_1",this.classes.push("api")}get openapi(){return this.get("openapi")}set openapi(e){this.set("openapi",e)}get info(){return this.get("info")}set info(e){this.set("info",e)}get jsonSchemaDialect(){return this.get("jsonSchemaDialect")}set jsonSchemaDialect(e){this.set("jsonSchemaDialect",e)}get servers(){return this.get("servers")}set servers(e){this.set("servers",e)}get paths(){return this.get("paths")}set paths(e){this.set("paths",e)}get components(){return this.get("components")}set components(e){this.set("components",e)}get security(){return this.get("security")}set security(e){this.set("security",e)}get tags(){return this.get("tags")}set tags(e){this.set("tags",e)}get externalDocs(){return this.get("externalDocs")}set externalDocs(e){this.set("externalDocs",e)}get webhooks(){return this.get("webhooks")}set webhooks(e){this.set("webhooks",e)}}class _T extends xO{get requestBody(){return this.get("requestBody")}set requestBody(e){this.set("requestBody",e)}}class CT extends jO{get schema(){return this.get("schema")}set schema(e){this.set("schema",e)}}class MT extends EO{get GET(){return this.get("get")}set GET(e){this.set("GET",e)}get PUT(){return this.get("put")}set PUT(e){this.set("PUT",e)}get POST(){return this.get("post")}set POST(e){this.set("POST",e)}get DELETE(){return this.get("delete")}set DELETE(e){this.set("DELETE",e)}get OPTIONS(){return this.get("options")}set OPTIONS(e){this.set("OPTIONS",e)}get HEAD(){return this.get("head")}set HEAD(e){this.set("HEAD",e)}get PATCH(){return this.get("patch")}set PATCH(e){this.set("PATCH",e)}get TRACE(){return this.get("trace")}set TRACE(e){this.set("TRACE",e)}}class NT extends $O{}class qT extends OO{}Object.defineProperty(qT.prototype,"description",{get(){return this.get("description")},set(e){this.set("description",e)},enumerable:!0}),Object.defineProperty(qT.prototype,"summary",{get(){return this.get("summary")},set(e){this.set("summary",e)},enumerable:!0});class BT extends SO{}let LT=class extends AO{};class UT extends PO{}class JT extends Jx{constructor(e,t,r){super(e,t,r),this.element="schema"}get $schema(){return this.get("$schema")}set $schema(e){this.set("$schema",e)}get $vocabulary(){return this.get("$vocabulary")}set $vocabulary(e){this.set("$vocabulary",e)}get $id(){return this.get("$id")}set $id(e){this.set("$id",e)}get $anchor(){return this.get("$anchor")}set $anchor(e){this.set("$anchor",e)}get $dynamicAnchor(){return this.get("$dynamicAnchor")}set $dynamicAnchor(e){this.set("$dynamicAnchor",e)}get $dynamicRef(){return this.get("$dynamicRef")}set $dynamicRef(e){this.set("$dynamicRef",e)}get $ref(){return this.get("$ref")}set $ref(e){this.set("$ref",e)}get $defs(){return this.get("$defs")}set $defs(e){this.set("$defs",e)}get $comment(){return this.get("$comment")}set $comment(e){this.set("$comment",e)}get allOf(){return this.get("allOf")}set allOf(e){this.set("allOf",e)}get anyOf(){return this.get("anyOf")}set anyOf(e){this.set("anyOf",e)}get oneOf(){return this.get("oneOf")}set oneOf(e){this.set("oneOf",e)}get not(){return this.get("not")}set not(e){this.set("not",e)}get if(){return this.get("if")}set if(e){this.set("if",e)}get then(){return this.get("then")}set then(e){this.set("then",e)}get else(){return this.get("else")}set else(e){this.set("else",e)}get dependentSchemas(){return this.get("dependentSchemas")}set dependentSchemas(e){this.set("dependentSchemas",e)}get prefixItems(){return this.get("prefixItems")}set prefixItems(e){this.set("prefixItems",e)}get items(){return this.get("items")}set items(e){this.set("items",e)}get containsProp(){return this.get("contains")}set containsProp(e){this.set("contains",e)}get properties(){return this.get("properties")}set properties(e){this.set("properties",e)}get patternProperties(){return this.get("patternProperties")}set patternProperties(e){this.set("patternProperties",e)}get additionalProperties(){return this.get("additionalProperties")}set additionalProperties(e){this.set("additionalProperties",e)}get propertyNames(){return this.get("propertyNames")}set propertyNames(e){this.set("propertyNames",e)}get unevaluatedItems(){return this.get("unevaluatedItems")}set unevaluatedItems(e){this.set("unevaluatedItems",e)}get unevaluatedProperties(){return this.get("unevaluatedProperties")}set unevaluatedProperties(e){this.set("unevaluatedProperties",e)}get type(){return this.get("type")}set type(e){this.set("type",e)}get enum(){return this.get("enum")}set enum(e){this.set("enum",e)}get const(){return this.get("const")}set const(e){this.set("const",e)}get multipleOf(){return this.get("multipleOf")}set multipleOf(e){this.set("multipleOf",e)}get maximum(){return this.get("maximum")}set maximum(e){this.set("maximum",e)}get exclusiveMaximum(){return this.get("exclusiveMaximum")}set exclusiveMaximum(e){this.set("exclusiveMaximum",e)}get minimum(){return this.get("minimum")}set minimum(e){this.set("minimum",e)}get exclusiveMinimum(){return this.get("exclusiveMinimum")}set exclusiveMinimum(e){this.set("exclusiveMinimum",e)}get maxLength(){return this.get("maxLength")}set maxLength(e){this.set("maxLength",e)}get minLength(){return this.get("minLength")}set minLength(e){this.set("minLength",e)}get pattern(){return this.get("pattern")}set pattern(e){this.set("pattern",e)}get maxItems(){return this.get("maxItems")}set maxItems(e){this.set("maxItems",e)}get minItems(){return this.get("minItems")}set minItems(e){this.set("minItems",e)}get uniqueItems(){return this.get("uniqueItems")}set uniqueItems(e){this.set("uniqueItems",e)}get maxContains(){return this.get("maxContains")}set maxContains(e){this.set("maxContains",e)}get minContains(){return this.get("minContains")}set minContains(e){this.set("minContains",e)}get maxProperties(){return this.get("maxProperties")}set maxProperties(e){this.set("maxProperties",e)}get minProperties(){return this.get("minProperties")}set minProperties(e){this.set("minProperties",e)}get required(){return this.get("required")}set required(e){this.set("required",e)}get dependentRequired(){return this.get("dependentRequired")}set dependentRequired(e){this.set("dependentRequired",e)}get title(){return this.get("title")}set title(e){this.set("title",e)}get description(){return this.get("description")}set description(e){this.set("description",e)}get default(){return this.get("default")}set default(e){this.set("default",e)}get deprecated(){return this.get("deprecated")}set deprecated(e){this.set("deprecated",e)}get readOnly(){return this.get("readOnly")}set readOnly(e){this.set("readOnly",e)}get writeOnly(){return this.get("writeOnly")}set writeOnly(e){this.set("writeOnly",e)}get examples(){return this.get("examples")}set examples(e){this.set("examples",e)}get format(){return this.get("format")}set format(e){this.set("format",e)}get contentEncoding(){return this.get("contentEncoding")}set contentEncoding(e){this.set("contentEncoding",e)}get contentMediaType(){return this.get("contentMediaType")}set contentMediaType(e){this.set("contentMediaType",e)}get contentSchema(){return this.get("contentSchema")}set contentSchema(e){this.set("contentSchema",e)}get discriminator(){return this.get("discriminator")}set discriminator(e){this.set("discriminator",e)}get xml(){return this.get("xml")}set xml(e){this.set("xml",e)}get externalDocs(){return this.get("externalDocs")}set externalDocs(e){this.set("externalDocs",e)}get example(){return this.get("example")}set example(e){this.set("example",e)}}class VT extends SS{}class GT extends AS{}class HT extends PS{}class zT extends TS{}class XT extends kS{}class WT extends FS{}const YT={namespace:e=>{const{base:t}=e;return t.register("callback",bT),t.register("components",gT),t.register("contact",wT),t.register("discriminator",xT),t.register("encoding",jT),t.register("example",ET),t.register("externalDocumentation",$T),t.register("header",OT),t.register("info",ST),t.register("jsonSchemaDialect",AT),t.register("license",PT),t.register("link",TT),t.register("mediaType",kT),t.register("oAuthFlow",FT),t.register("oAuthFlows",IT),t.register("openapi",RT),t.register("openApi3_1",DT),t.register("operation",_T),t.register("parameter",CT),t.register("pathItem",MT),t.register("paths",NT),t.register("reference",qT),t.register("requestBody",BT),t.register("response",LT),t.register("responses",UT),t.register("schema",JT),t.register("securityRequirement",VT),t.register("securityScheme",GT),t.register("server",HT),t.register("serverVariable",zT),t.register("tag",XT),t.register("xml",WT),t}};class ZT extends Jx{static primaryClass="components-path-items";constructor(e,t,r){super(e,t,r),this.classes.push(ZT.primaryClass)}}class KT extends Jx{static primaryClass="webhooks";constructor(e,t,r){super(e,t,r),this.classes.push(KT.primaryClass)}}const QT=e=>{if(sj(e))return`${e.element.charAt(0).toUpperCase()+e.element.slice(1)}Element`},ek={CallbackElement:["content"],ComponentsElement:["content"],ContactElement:["content"],DiscriminatorElement:["content"],Encoding:["content"],Example:["content"],ExternalDocumentationElement:["content"],HeaderElement:["content"],InfoElement:["content"],LicenseElement:["content"],MediaTypeElement:["content"],OAuthFlowElement:["content"],OAuthFlowsElement:["content"],OpenApi3_1Element:["content"],OperationElement:["content"],ParameterElement:["content"],PathItemElement:["content"],PathsElement:["content"],ReferenceElement:["content"],RequestBodyElement:["content"],ResponseElement:["content"],ResponsesElement:["content"],SchemaElement:["content"],SecurityRequirementElement:["content"],SecuritySchemeElement:["content"],ServerElement:["content"],ServerVariableElement:["content"],TagElement:["content"],...Jj};class tk{internalStore;constructor(e,t,r){this.storageElement=e,this.storageField=t,this.storageSubField=r}get store(){if(!this.internalStore){let e=this.storageElement.get(this.storageField);uj(e)||(e=new Jx,this.storageElement.set(this.storageField,e));let t=e.get(this.storageSubField);lj(t)||(t=new Ux,e.set(this.storageSubField,t)),this.internalStore=t}return this.internalStore}append(e){this.includes(e)||this.store.push(e)}includes(e){return this.store.includes(e)}}const rk=({storageField:e="x-normalized"}={})=>t=>{const{predicates:r,ancestorLineageToJSONPointer:n}=t,s=(e,t)=>!!r.isParameterElement(e)&&(!!r.isParameterElement(t)&&(!!r.isStringElement(e.name)&&(!!r.isStringElement(e.in)&&(!!r.isStringElement(t.name)&&(!!r.isStringElement(t.in)&&(oE(e.name)===oE(t.name)&&oE(e.in)===oE(t.in))))))),i=[];let o;return{visitor:{OpenApi3_1Element:{enter(t){o=new tk(t,e,"parameters")},leave(){o=void 0}},PathItemElement:{enter(e,t,n,s,o){if(o.some(r.isComponentsElement))return;const{parameters:c}=e;r.isArrayElement(c)?i.push([...c.content]):i.push([])},leave(){i.pop()}},OperationElement:{leave(e,t,r,c,a){const u=Np(i);if(!Array.isArray(u)||0===u.length)return;const l=n([...a,r,e]);if(o.includes(l))return;const h=dd([],["parameters","content"],e),f=Td(s,[...h,...u]);e.parameters=new XS(f),o.append(l)}}}}},nk=({storageField:e="x-normalized"}={})=>t=>{const{predicates:r,ancestorLineageToJSONPointer:n}=t;let s,i;return{visitor:{OpenApi3_1Element:{enter(t){i=new tk(t,e,"security-requirements"),r.isArrayElement(t.security)&&(s=t.security)},leave(){i=void 0,s=void 0}},OperationElement:{leave(e,t,o,c,a){if(a.some(r.isComponentsElement))return;const u=n([...a,o,e]);if(i.includes(u))return;var l;void 0===e.security&&void 0!==s&&(e.security=new QS(null===(l=s)||void 0===l?void 0:l.content),i.append(u))}}}}},sk=e=>e.replace(/\s/g,""),ik=e=>e.replace(/\W/gi,"_"),ok=(e,t,r)=>{const n=sk(e);return n.length>0?ik(n):((e,t)=>`${ik(sk(t.toLowerCase()))}${ik(sk(e))}`)(t,r)},ck=({storageField:e="x-normalized",operationIdNormalizer:t=ok}={})=>r=>{const{predicates:n,ancestorLineageToJSONPointer:s,namespace:i}=r,o=[],c=[],a=[];let u;return{visitor:{OpenApi3_1Element:{enter(t){u=new tk(t,e,"operation-ids")},leave(){const e=Hp((e=>oE(e.operationId)),c);Object.entries(e).forEach((([e,t])=>{Array.isArray(t)&&(t.length<=1||t.forEach(((t,r)=>{const n=`${e}${r+1}`;t.operationId=new i.elements.String(n)})))})),a.forEach((e=>{if(void 0===e.operationId)return;const t=String(oE(e.operationId)),r=c.find((e=>oE(e.meta.get("originalOperationId"))===t));void 0!==r&&(e.operationId=Cj.safe(r.operationId),e.meta.set("originalOperationId",t),e.set("__originalOperationId",t))})),c.length=0,a.length=0,u=void 0}},PathItemElement:{enter(e){const t=Ap("path",oE(e.meta.get("path")));o.push(t)},leave(){o.pop()}},OperationElement:{enter(e,r,n,a,l){if(void 0===e.operationId)return;const h=s([...l,n,e]);if(u.includes(h))return;const f=String(oE(e.operationId)),p=Np(o),d=Ap("method",oE(e.meta.get("http-method"))),m=t(f,p,d);f!==m&&(e.operationId=new i.elements.String(m),e.set("__originalOperationId",f),e.meta.set("originalOperationId",f),c.push(e),u.append(h))}},LinkElement:{leave(e){n.isLinkElement(e)&&void 0!==e.operationId&&a.push(e)}}}}},ak=({storageField:e="x-normalized"}={})=>t=>{const{predicates:r,ancestorLineageToJSONPointer:n}=t;let s;return{visitor:{OpenApi3_1Element:{enter(t){s=new tk(t,e,"parameter-examples")},leave(){s=void 0}},ParameterElement:{leave(e,t,i,o,c){var a,u;if(c.some(r.isComponentsElement))return;if(void 0===e.schema||!r.isSchemaElement(e.schema))return;if(void 0===(null===(a=e.schema)||void 0===a?void 0:a.example)&&void 0===(null===(u=e.schema)||void 0===u?void 0:u.examples))return;const l=n([...c,i,e]);if(!s.includes(l)){if(void 0!==e.examples&&r.isObjectElement(e.examples)){const t=e.examples.map((e=>Cj.safe(e.value)));return void 0!==e.schema.examples&&(e.schema.set("examples",t),s.append(l)),void(void 0!==e.schema.example&&(e.schema.set("example",t[0]),s.append(l)))}void 0!==e.example&&(void 0!==e.schema.examples&&(e.schema.set("examples",[Cj(e.example)]),s.append(l)),void 0!==e.schema.example&&(e.schema.set("example",Cj(e.example)),s.append(l)))}}}}}},uk=({storageField:e="x-normalized"}={})=>t=>{const{predicates:r,ancestorLineageToJSONPointer:n}=t;let s;return{visitor:{OpenApi3_1Element:{enter(t){s=new tk(t,e,"header-examples")},leave(){s=void 0}},HeaderElement:{leave(e,t,i,o,c){var a,u;if(c.some(r.isComponentsElement))return;if(void 0===e.schema||!r.isSchemaElement(e.schema))return;if(void 0===(null===(a=e.schema)||void 0===a?void 0:a.example)&&void 0===(null===(u=e.schema)||void 0===u?void 0:u.examples))return;const l=n([...c,i,e]);if(!s.includes(l)){if(void 0!==e.examples&&r.isObjectElement(e.examples)){const t=e.examples.map((e=>Cj.safe(e.value)));return void 0!==e.schema.examples&&(e.schema.set("examples",t),s.append(l)),void(void 0!==e.schema.example&&(e.schema.set("example",t[0]),s.append(l)))}void 0!==e.example&&(void 0!==e.schema.examples&&(e.schema.set("examples",[Cj(e.example)]),s.append(l)),void 0!==e.schema.example&&(e.schema.set("example",Cj(e.example)),s.append(l)))}}}}}},lk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof bT||e(n)&&t("callback",n)&&r("object",n))),hk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof gT||e(n)&&t("components",n)&&r("object",n))),fk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof wT||e(n)&&t("contact",n)&&r("object",n))),pk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof ET||e(n)&&t("example",n)&&r("object",n))),dk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof $T||e(n)&&t("externalDocumentation",n)&&r("object",n))),mk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof OT||e(n)&&t("header",n)&&r("object",n))),vk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof ST||e(n)&&t("info",n)&&r("object",n))),yk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof AT||e(n)&&t("jsonSchemaDialect",n)&&r("string",n))),bk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof PT||e(n)&&t("license",n)&&r("object",n))),gk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof TT||e(n)&&t("link",n)&&r("object",n))),wk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof RT||e(n)&&t("openapi",n)&&r("string",n))),xk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r,hasClass:n})=>s=>s instanceof DT||e(s)&&t("openApi3_1",s)&&r("object",s)&&n("api",s))),jk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof _T||e(n)&&t("operation",n)&&r("object",n))),Ek=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof CT||e(n)&&t("parameter",n)&&r("object",n))),$k=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof MT||e(n)&&t("pathItem",n)&&r("object",n))),Ok=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof NT||e(n)&&t("paths",n)&&r("object",n))),Sk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof qT||e(n)&&t("reference",n)&&r("object",n))),Ak=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof BT||e(n)&&t("requestBody",n)&&r("object",n))),Pk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof LT||e(n)&&t("response",n)&&r("object",n))),Tk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof UT||e(n)&&t("responses",n)&&r("object",n))),kk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof JT||e(n)&&t("schema",n)&&r("object",n))),Fk=e=>aj(e)&&e.classes.includes("boolean-json-schema"),Ik=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof VT||e(n)&&t("securityRequirement",n)&&r("object",n))),Rk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof GT||e(n)&&t("securityScheme",n)&&r("object",n))),Dk=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof HT||e(n)&&t("server",n)&&r("object",n))),_k=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof zT||e(n)&&t("serverVariable",n)&&r("object",n))),Ck=nj((({hasBasicElementProps:e,isElementType:t,primitiveEq:r})=>n=>n instanceof kT||e(n)&&t("mediaType",n)&&r("object",n))),Mk=Object.freeze(Object.defineProperty({__proto__:null,isBooleanJsonSchemaElement:Fk,isCallbackElement:lk,isComponentsElement:hk,isContactElement:fk,isExampleElement:pk,isExternalDocumentationElement:dk,isHeaderElement:mk,isInfoElement:vk,isJsonSchemaDialectElement:yk,isLicenseElement:bk,isLinkElement:gk,isMediaTypeElement:Ck,isOpenApi3_1Element:xk,isOpenapiElement:wk,isOperationElement:jk,isParameterElement:Ek,isPathItemElement:$k,isPathItemElementExternal:e=>{if(!$k(e))return!1;if(!ij(e.$ref))return!1;const t=oE(e.$ref);return"string"==typeof t&&t.length>0&&!t.startsWith("#")},isPathsElement:Ok,isReferenceElement:Sk,isReferenceElementExternal:e=>{if(!Sk(e))return!1;if(!ij(e.$ref))return!1;const t=oE(e.$ref);return"string"==typeof t&&t.length>0&&!t.startsWith("#")},isRequestBodyElement:Ak,isResponseElement:Pk,isResponsesElement:Tk,isSchemaElement:kk,isSecurityRequirementElement:Ik,isSecuritySchemeElement:Rk,isServerElement:Dk,isServerVariableElement:_k},Symbol.toStringTag,{value:"Module"})),Nk=e=>{const t=e.reduce(((t,r,n)=>{if(hj(r)){const e=String(oE(r.key));t.push(e)}else if(lj(e[n-2])){const s=String(e[n-2].content.indexOf(r));t.push(s)}return t}),[]);return tO(t)},qk=()=>{const e=$j(YT);return{predicates:{...Mk,isElement:sj,isStringElement:ij,isArrayElement:lj,isObjectElement:uj,isMemberElement:hj,isServersElement:uP,includesClasses:wj,hasElementSourceMap:gj},ancestorLineageToJSONPointer:Nk,namespace:e}};class Bk extends(XO(jA,vA)){constructor(e){super(e),this.element=new DT,this.specPath=Wf(["document","objects","OpenApi"]),this.canSupportSpecificationExtensions=!0,this.openApiSemanticElement=this.element}ObjectElement(e){return this.openApiGenericElement=e,jA.prototype.ObjectElement.call(this,e)}}const{visitors:{document:{objects:{Info:{$visitor:Lk}}}}}=mT;const{visitors:{document:{objects:{Contact:{$visitor:Uk}}}}}=mT;const{visitors:{document:{objects:{License:{$visitor:Jk}}}}}=mT;const{visitors:{document:{objects:{Link:{$visitor:Vk}}}}}=mT;class Gk extends(XO(yA,vA)){StringElement(e){const t=new AT(oE(e));return this.copyMetaAndAttributes(e,t),this.element=t,Aj}}const{visitors:{document:{objects:{Server:{$visitor:Hk}}}}}=mT;const{visitors:{document:{objects:{ServerVariable:{$visitor:zk}}}}}=mT;const{visitors:{document:{objects:{MediaType:{$visitor:Xk}}}}}=mT;const{visitors:{document:{objects:{SecurityRequirement:{$visitor:Wk}}}}}=mT;const{visitors:{document:{objects:{Components:{$visitor:Yk}}}}}=mT;const{visitors:{document:{objects:{Tag:{$visitor:Zk}}}}}=mT;const{visitors:{document:{objects:{Reference:{$visitor:Kk}}}}}=mT;const{visitors:{document:{objects:{Parameter:{$visitor:Qk}}}}}=mT;const{visitors:{document:{objects:{Header:{$visitor:eF}}}}}=mT;class tF{parent;constructor({parent:e}){this.parent=e}}class rF extends(XO(jA,tF,vA)){constructor(e){super(e),this.element=new JT,this.specPath=Wf(["document","objects","Schema"]),this.canSupportSpecificationExtensions=!0,this.jsonSchemaDefaultDialect=AT.default,this.passingOptionsNames.push("parent")}ObjectElement(e){this.handle$schema(e),this.handle$id(e),this.parent=this.element;const t=jA.prototype.ObjectElement.call(this,e);return ij(this.element.$ref)&&(this.element.classes.push("reference-element"),this.element.setMetaProperty("referenced-element","schema")),t}BooleanElement(e){const t=super.enter(e);return this.element.classes.push("boolean-json-schema"),t}getJsonSchemaDialect(){let e;return e=void 0!==this.openApiSemanticElement&&yk(this.openApiSemanticElement.jsonSchemaDialect)?oE(this.openApiSemanticElement.jsonSchemaDialect):void 0!==this.openApiGenericElement&&ij(this.openApiGenericElement.get("jsonSchemaDialect"))?oE(this.openApiGenericElement.get("jsonSchemaDialect")):oE(this.jsonSchemaDefaultDialect),e}handle$schema(e){if(Id(this.parent)&&!ij(e.get("$schema")))this.element.setMetaProperty("inherited$schema",this.getJsonSchemaDialect());else if(kk(this.parent)&&!ij(e.get("$schema"))){const e=Ap(oE(this.parent.meta.get("inherited$schema")),oE(this.parent.$schema));this.element.setMetaProperty("inherited$schema",e)}}handle$id(e){const t=void 0!==this.parent?Cj(this.parent.getMetaProperty("inherited$id",[])):new Ux,r=oE(e.get("$id"));Xd(r)&&t.push(r),this.element.setMetaProperty("inherited$id",t)}}class nF extends(XO(kA,tF,vA)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-$defs"),this.specPath=Wf(["document","objects","Schema"]),this.passingOptionsNames.push("parent")}}let sF=class extends(XO(yA,tF,vA)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-allOf"),this.passingOptionsNames.push("parent")}ArrayElement(e){return e.forEach((e=>{if(uj(e)){const t=this.toRefractedElement(["document","objects","Schema"],e);this.element.push(t)}else{const t=Cj(e);this.element.push(t)}})),this.copyMetaAndAttributes(e,this.element),Aj}};class iF extends(XO(yA,tF,vA)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-anyOf"),this.passingOptionsNames.push("parent")}ArrayElement(e){return e.forEach((e=>{if(uj(e)){const t=this.toRefractedElement(["document","objects","Schema"],e);this.element.push(t)}else{const t=Cj(e);this.element.push(t)}})),this.copyMetaAndAttributes(e,this.element),Aj}}class oF extends(XO(yA,tF,vA)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-oneOf"),this.passingOptionsNames.push("parent")}ArrayElement(e){return e.forEach((e=>{if(uj(e)){const t=this.toRefractedElement(["document","objects","Schema"],e);this.element.push(t)}else{const t=Cj(e);this.element.push(t)}})),this.copyMetaAndAttributes(e,this.element),Aj}}class cF extends(XO(kA,tF,vA)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-dependentSchemas"),this.specPath=Wf(["document","objects","Schema"]),this.passingOptionsNames.push("parent")}}class aF extends(XO(yA,tF,vA)){constructor(e){super(e),this.element=new Ux,this.element.classes.push("json-schema-prefixItems"),this.passingOptionsNames.push("parent")}ArrayElement(e){return e.forEach((e=>{if(uj(e)){const t=this.toRefractedElement(["document","objects","Schema"],e);this.element.push(t)}else{const t=Cj(e);this.element.push(t)}})),this.copyMetaAndAttributes(e,this.element),Aj}}class uF extends(XO(kA,tF,vA)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-properties"),this.specPath=Wf(["document","objects","Schema"]),this.passingOptionsNames.push("parent")}}class lF extends(XO(kA,tF,vA)){constructor(e){super(e),this.element=new Jx,this.element.classes.push("json-schema-patternProperties"),this.specPath=Wf(["document","objects","Schema"]),this.passingOptionsNames.push("parent")}}const{visitors:{document:{objects:{Discriminator:{$visitor:hF}}}}}=mT;const{visitors:{document:{objects:{XML:{$visitor:fF}}}}}=mT;class pF extends(XO(kA,vA)){constructor(e){super(e),this.element=new MS,this.specPath=Wf(["document","objects","Schema"])}}class dF extends(XO(kA,vA)){constructor(e){super(e),this.element=new ZT,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","PathItem"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(Sk).forEach((e=>{e.setMetaProperty("referenced-element","pathItem")})),t}}const{visitors:{document:{objects:{Example:{$visitor:mF}}}}}=mT;const{visitors:{document:{objects:{ExternalDocumentation:{$visitor:vF}}}}}=mT;const{visitors:{document:{objects:{Encoding:{$visitor:yF}}}}}=mT;const{visitors:{document:{objects:{Paths:{$visitor:bF}}}}}=mT;const{visitors:{document:{objects:{RequestBody:{$visitor:gF}}}}}=mT;const{visitors:{document:{objects:{Callback:{$visitor:wF}}}}}=mT;const{visitors:{document:{objects:{Response:{$visitor:xF}}}}}=mT;const{visitors:{document:{objects:{Responses:{$visitor:jF}}}}}=mT;const{visitors:{document:{objects:{Operation:{$visitor:EF}}}}}=mT;const{visitors:{document:{objects:{PathItem:{$visitor:$F}}}}}=mT;const{visitors:{document:{objects:{SecurityScheme:{$visitor:OF}}}}}=mT;const{visitors:{document:{objects:{OAuthFlows:{$visitor:SF}}}}}=mT;const{visitors:{document:{objects:{OAuthFlow:{$visitor:AF}}}}}=mT;class PF extends(XO(kA,vA)){constructor(e){super(e),this.element=new KT,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","PathItem"]}ObjectElement(e){const t=kA.prototype.ObjectElement.call(this,e);return this.element.filter(Sk).forEach((e=>{e.setMetaProperty("referenced-element","pathItem")})),this.element.filter($k).forEach(((e,t)=>{e.setMetaProperty("webhook-name",oE(t))})),t}}const TF={visitors:{value:mT.visitors.value,document:{objects:{OpenApi:{$visitor:Bk,fixedFields:{openapi:mT.visitors.document.objects.OpenApi.fixedFields.openapi,info:{$ref:"#/visitors/document/objects/Info"},jsonSchemaDialect:Gk,servers:mT.visitors.document.objects.OpenApi.fixedFields.servers,paths:{$ref:"#/visitors/document/objects/Paths"},webhooks:PF,components:{$ref:"#/visitors/document/objects/Components"},security:mT.visitors.document.objects.OpenApi.fixedFields.security,tags:mT.visitors.document.objects.OpenApi.fixedFields.tags,externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"}}},Info:{$visitor:class extends Lk{constructor(e){super(e),this.element=new ST}},fixedFields:{title:mT.visitors.document.objects.Info.fixedFields.title,description:mT.visitors.document.objects.Info.fixedFields.description,summary:{$ref:"#/visitors/value"},termsOfService:mT.visitors.document.objects.Info.fixedFields.termsOfService,contact:{$ref:"#/visitors/document/objects/Contact"},license:{$ref:"#/visitors/document/objects/License"},version:mT.visitors.document.objects.Info.fixedFields.version}},Contact:{$visitor:class extends Uk{constructor(e){super(e),this.element=new wT}},fixedFields:{name:mT.visitors.document.objects.Contact.fixedFields.name,url:mT.visitors.document.objects.Contact.fixedFields.url,email:mT.visitors.document.objects.Contact.fixedFields.email}},License:{$visitor:class extends Jk{constructor(e){super(e),this.element=new PT}},fixedFields:{name:mT.visitors.document.objects.License.fixedFields.name,identifier:{$ref:"#/visitors/value"},url:mT.visitors.document.objects.License.fixedFields.url}},Server:{$visitor:class extends Hk{constructor(e){super(e),this.element=new HT}},fixedFields:{url:mT.visitors.document.objects.Server.fixedFields.url,description:mT.visitors.document.objects.Server.fixedFields.description,variables:mT.visitors.document.objects.Server.fixedFields.variables}},ServerVariable:{$visitor:class extends zk{constructor(e){super(e),this.element=new zT}},fixedFields:{enum:mT.visitors.document.objects.ServerVariable.fixedFields.enum,default:mT.visitors.document.objects.ServerVariable.fixedFields.default,description:mT.visitors.document.objects.ServerVariable.fixedFields.description}},Components:{$visitor:class extends Yk{constructor(e){super(e),this.element=new gT}},fixedFields:{schemas:pF,responses:mT.visitors.document.objects.Components.fixedFields.responses,parameters:mT.visitors.document.objects.Components.fixedFields.parameters,examples:mT.visitors.document.objects.Components.fixedFields.examples,requestBodies:mT.visitors.document.objects.Components.fixedFields.requestBodies,headers:mT.visitors.document.objects.Components.fixedFields.headers,securitySchemes:mT.visitors.document.objects.Components.fixedFields.securitySchemes,links:mT.visitors.document.objects.Components.fixedFields.links,callbacks:mT.visitors.document.objects.Components.fixedFields.callbacks,pathItems:dF}},Paths:{$visitor:class extends bF{constructor(e){super(e),this.element=new NT}}},PathItem:{$visitor:class extends $F{constructor(e){super(e),this.element=new MT}},fixedFields:{$ref:mT.visitors.document.objects.PathItem.fixedFields.$ref,summary:mT.visitors.document.objects.PathItem.fixedFields.summary,description:mT.visitors.document.objects.PathItem.fixedFields.description,get:{$ref:"#/visitors/document/objects/Operation"},put:{$ref:"#/visitors/document/objects/Operation"},post:{$ref:"#/visitors/document/objects/Operation"},delete:{$ref:"#/visitors/document/objects/Operation"},options:{$ref:"#/visitors/document/objects/Operation"},head:{$ref:"#/visitors/document/objects/Operation"},patch:{$ref:"#/visitors/document/objects/Operation"},trace:{$ref:"#/visitors/document/objects/Operation"},servers:mT.visitors.document.objects.PathItem.fixedFields.servers,parameters:mT.visitors.document.objects.PathItem.fixedFields.parameters}},Operation:{$visitor:class extends EF{constructor(e){super(e),this.element=new _T}},fixedFields:{tags:mT.visitors.document.objects.Operation.fixedFields.tags,summary:mT.visitors.document.objects.Operation.fixedFields.summary,description:mT.visitors.document.objects.Operation.fixedFields.description,externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"},operationId:mT.visitors.document.objects.Operation.fixedFields.operationId,parameters:mT.visitors.document.objects.Operation.fixedFields.parameters,requestBody:mT.visitors.document.objects.Operation.fixedFields.requestBody,responses:{$ref:"#/visitors/document/objects/Responses"},callbacks:mT.visitors.document.objects.Operation.fixedFields.callbacks,deprecated:mT.visitors.document.objects.Operation.fixedFields.deprecated,security:mT.visitors.document.objects.Operation.fixedFields.security,servers:mT.visitors.document.objects.Operation.fixedFields.servers}},ExternalDocumentation:{$visitor:class extends vF{constructor(e){super(e),this.element=new $T}},fixedFields:{description:mT.visitors.document.objects.ExternalDocumentation.fixedFields.description,url:mT.visitors.document.objects.ExternalDocumentation.fixedFields.url}},Parameter:{$visitor:class extends Qk{constructor(e){super(e),this.element=new CT}},fixedFields:{name:mT.visitors.document.objects.Parameter.fixedFields.name,in:mT.visitors.document.objects.Parameter.fixedFields.in,description:mT.visitors.document.objects.Parameter.fixedFields.description,required:mT.visitors.document.objects.Parameter.fixedFields.required,deprecated:mT.visitors.document.objects.Parameter.fixedFields.deprecated,allowEmptyValue:mT.visitors.document.objects.Parameter.fixedFields.allowEmptyValue,style:mT.visitors.document.objects.Parameter.fixedFields.style,explode:mT.visitors.document.objects.Parameter.fixedFields.explode,allowReserved:mT.visitors.document.objects.Parameter.fixedFields.allowReserved,schema:{$ref:"#/visitors/document/objects/Schema"},example:mT.visitors.document.objects.Parameter.fixedFields.example,examples:mT.visitors.document.objects.Parameter.fixedFields.examples,content:mT.visitors.document.objects.Parameter.fixedFields.content}},RequestBody:{$visitor:class extends gF{constructor(e){super(e),this.element=new BT}},fixedFields:{description:mT.visitors.document.objects.RequestBody.fixedFields.description,content:mT.visitors.document.objects.RequestBody.fixedFields.content,required:mT.visitors.document.objects.RequestBody.fixedFields.required}},MediaType:{$visitor:class extends Xk{constructor(e){super(e),this.element=new kT}},fixedFields:{schema:{$ref:"#/visitors/document/objects/Schema"},example:mT.visitors.document.objects.MediaType.fixedFields.example,examples:mT.visitors.document.objects.MediaType.fixedFields.examples,encoding:mT.visitors.document.objects.MediaType.fixedFields.encoding}},Encoding:{$visitor:class extends yF{constructor(e){super(e),this.element=new jT}},fixedFields:{contentType:mT.visitors.document.objects.Encoding.fixedFields.contentType,headers:mT.visitors.document.objects.Encoding.fixedFields.headers,style:mT.visitors.document.objects.Encoding.fixedFields.style,explode:mT.visitors.document.objects.Encoding.fixedFields.explode,allowReserved:mT.visitors.document.objects.Encoding.fixedFields.allowReserved}},Responses:{$visitor:class extends jF{constructor(e){super(e),this.element=new UT}},fixedFields:{default:mT.visitors.document.objects.Responses.fixedFields.default}},Response:{$visitor:class extends xF{constructor(e){super(e),this.element=new LT}},fixedFields:{description:mT.visitors.document.objects.Response.fixedFields.description,headers:mT.visitors.document.objects.Response.fixedFields.headers,content:mT.visitors.document.objects.Response.fixedFields.content,links:mT.visitors.document.objects.Response.fixedFields.links}},Callback:{$visitor:class extends wF{constructor(e){super(e),this.element=new bT,this.specPath=e=>bA(e)?["document","objects","Reference"]:["document","objects","PathItem"]}ObjectElement(e){const t=wF.prototype.ObjectElement.call(this,e);return this.element.filter(Sk).forEach((e=>{e.setMetaProperty("referenced-element","pathItem")})),t}}},Example:{$visitor:class extends mF{constructor(e){super(e),this.element=new ET}},fixedFields:{summary:mT.visitors.document.objects.Example.fixedFields.summary,description:mT.visitors.document.objects.Example.fixedFields.description,value:mT.visitors.document.objects.Example.fixedFields.value,externalValue:mT.visitors.document.objects.Example.fixedFields.externalValue}},Link:{$visitor:class extends Vk{constructor(e){super(e),this.element=new TT}},fixedFields:{operationRef:mT.visitors.document.objects.Link.fixedFields.operationRef,operationId:mT.visitors.document.objects.Link.fixedFields.operationId,parameters:mT.visitors.document.objects.Link.fixedFields.parameters,requestBody:mT.visitors.document.objects.Link.fixedFields.requestBody,description:mT.visitors.document.objects.Link.fixedFields.description,server:{$ref:"#/visitors/document/objects/Server"}}},Header:{$visitor:class extends eF{constructor(e){super(e),this.element=new OT}},fixedFields:{description:mT.visitors.document.objects.Header.fixedFields.description,required:mT.visitors.document.objects.Header.fixedFields.required,deprecated:mT.visitors.document.objects.Header.fixedFields.deprecated,allowEmptyValue:mT.visitors.document.objects.Header.fixedFields.allowEmptyValue,style:mT.visitors.document.objects.Header.fixedFields.style,explode:mT.visitors.document.objects.Header.fixedFields.explode,allowReserved:mT.visitors.document.objects.Header.fixedFields.allowReserved,schema:{$ref:"#/visitors/document/objects/Schema"},example:mT.visitors.document.objects.Header.fixedFields.example,examples:mT.visitors.document.objects.Header.fixedFields.examples,content:mT.visitors.document.objects.Header.fixedFields.content}},Tag:{$visitor:class extends Zk{constructor(e){super(e),this.element=new XT}},fixedFields:{name:mT.visitors.document.objects.Tag.fixedFields.name,description:mT.visitors.document.objects.Tag.fixedFields.description,externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"}}},Reference:{$visitor:class extends Kk{constructor(e){super(e),this.element=new qT}},fixedFields:{$ref:mT.visitors.document.objects.Reference.fixedFields.$ref,summary:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"}}},Schema:{$visitor:rF,fixedFields:{$schema:{$ref:"#/visitors/value"},$vocabulary:class extends vA{ObjectElement(e){const t=super.enter(e);return this.element.classes.push("json-schema-$vocabulary"),t}},$id:{$ref:"#/visitors/value"},$anchor:{$ref:"#/visitors/value"},$dynamicAnchor:{$ref:"#/visitors/value"},$dynamicRef:{$ref:"#/visitors/value"},$ref:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("reference-value"),t}},$defs:nF,$comment:{$ref:"#/visitors/value"},allOf:sF,anyOf:iF,oneOf:oF,not:{$ref:"#/visitors/document/objects/Schema"},if:{$ref:"#/visitors/document/objects/Schema"},then:{$ref:"#/visitors/document/objects/Schema"},else:{$ref:"#/visitors/document/objects/Schema"},dependentSchemas:cF,prefixItems:aF,items:{$ref:"#/visitors/document/objects/Schema"},contains:{$ref:"#/visitors/document/objects/Schema"},properties:uF,patternProperties:lF,additionalProperties:{$ref:"#/visitors/document/objects/Schema"},propertyNames:{$ref:"#/visitors/document/objects/Schema"},unevaluatedItems:{$ref:"#/visitors/document/objects/Schema"},unevaluatedProperties:{$ref:"#/visitors/document/objects/Schema"},type:class extends vA{StringElement(e){const t=super.enter(e);return this.element.classes.push("json-schema-type"),t}ArrayElement(e){const t=super.enter(e);return this.element.classes.push("json-schema-type"),t}},enum:class extends vA{ArrayElement(e){const t=super.enter(e);return this.element.classes.push("json-schema-enum"),t}},const:{$ref:"#/visitors/value"},multipleOf:{$ref:"#/visitors/value"},maximum:{$ref:"#/visitors/value"},exclusiveMaximum:{$ref:"#/visitors/value"},minimum:{$ref:"#/visitors/value"},exclusiveMinimum:{$ref:"#/visitors/value"},maxLength:{$ref:"#/visitors/value"},minLength:{$ref:"#/visitors/value"},pattern:{$ref:"#/visitors/value"},maxItems:{$ref:"#/visitors/value"},minItems:{$ref:"#/visitors/value"},uniqueItems:{$ref:"#/visitors/value"},maxContains:{$ref:"#/visitors/value"},minContains:{$ref:"#/visitors/value"},maxProperties:{$ref:"#/visitors/value"},minProperties:{$ref:"#/visitors/value"},required:{$ref:"#/visitors/value"},dependentRequired:class extends vA{ObjectElement(e){const t=super.enter(e);return this.element.classes.push("json-schema-dependentRequired"),t}},title:{$ref:"#/visitors/value"},description:{$ref:"#/visitors/value"},default:{$ref:"#/visitors/value"},deprecated:{$ref:"#/visitors/value"},readOnly:{$ref:"#/visitors/value"},writeOnly:{$ref:"#/visitors/value"},examples:class extends vA{ArrayElement(e){const t=super.enter(e);return this.element.classes.push("json-schema-examples"),t}},format:{$ref:"#/visitors/value"},contentEncoding:{$ref:"#/visitors/value"},contentMediaType:{$ref:"#/visitors/value"},contentSchema:{$ref:"#/visitors/document/objects/Schema"},discriminator:{$ref:"#/visitors/document/objects/Discriminator"},xml:{$ref:"#/visitors/document/objects/XML"},externalDocs:{$ref:"#/visitors/document/objects/ExternalDocumentation"},example:{$ref:"#/visitors/value"}}},Discriminator:{$visitor:class extends hF{constructor(e){super(e),this.element=new xT,this.canSupportSpecificationExtensions=!0}},fixedFields:{propertyName:mT.visitors.document.objects.Discriminator.fixedFields.propertyName,mapping:mT.visitors.document.objects.Discriminator.fixedFields.mapping}},XML:{$visitor:class extends fF{constructor(e){super(e),this.element=new WT}},fixedFields:{name:mT.visitors.document.objects.XML.fixedFields.name,namespace:mT.visitors.document.objects.XML.fixedFields.namespace,prefix:mT.visitors.document.objects.XML.fixedFields.prefix,attribute:mT.visitors.document.objects.XML.fixedFields.attribute,wrapped:mT.visitors.document.objects.XML.fixedFields.wrapped}},SecurityScheme:{$visitor:class extends OF{constructor(e){super(e),this.element=new GT}},fixedFields:{type:mT.visitors.document.objects.SecurityScheme.fixedFields.type,description:mT.visitors.document.objects.SecurityScheme.fixedFields.description,name:mT.visitors.document.objects.SecurityScheme.fixedFields.name,in:mT.visitors.document.objects.SecurityScheme.fixedFields.in,scheme:mT.visitors.document.objects.SecurityScheme.fixedFields.scheme,bearerFormat:mT.visitors.document.objects.SecurityScheme.fixedFields.bearerFormat,flows:{$ref:"#/visitors/document/objects/OAuthFlows"},openIdConnectUrl:mT.visitors.document.objects.SecurityScheme.fixedFields.openIdConnectUrl}},OAuthFlows:{$visitor:class extends SF{constructor(e){super(e),this.element=new IT}},fixedFields:{implicit:{$ref:"#/visitors/document/objects/OAuthFlow"},password:{$ref:"#/visitors/document/objects/OAuthFlow"},clientCredentials:{$ref:"#/visitors/document/objects/OAuthFlow"},authorizationCode:{$ref:"#/visitors/document/objects/OAuthFlow"}}},OAuthFlow:{$visitor:class extends AF{constructor(e){super(e),this.element=new FT}},fixedFields:{authorizationUrl:mT.visitors.document.objects.OAuthFlow.fixedFields.authorizationUrl,tokenUrl:mT.visitors.document.objects.OAuthFlow.fixedFields.tokenUrl,refreshUrl:mT.visitors.document.objects.OAuthFlow.fixedFields.refreshUrl,scopes:mT.visitors.document.objects.OAuthFlow.fixedFields.scopes}},SecurityRequirement:{$visitor:class extends Wk{constructor(e){super(e),this.element=new VT}}}},extension:{$visitor:mT.visitors.document.extension.$visitor}}}},kF=e=>(t,r={})=>((e,{specPath:t=["visitors","document","objects","OpenApi","$visitor"],plugins:r=[]}={})=>{const n=zx(e),s=uE(TF),i=new(pd(t,s))({specObj:s});return Gj(n,i),zj(i.element,r,{toolboxCreator:qk,visitorOptions:{keyMap:ek,nodeTypeGetter:QT}})})(t,{specPath:e,...r});bT.refract=kF(["visitors","document","objects","Callback","$visitor"]),gT.refract=kF(["visitors","document","objects","Components","$visitor"]),wT.refract=kF(["visitors","document","objects","Contact","$visitor"]),ET.refract=kF(["visitors","document","objects","Example","$visitor"]),xT.refract=kF(["visitors","document","objects","Discriminator","$visitor"]),jT.refract=kF(["visitors","document","objects","Encoding","$visitor"]),$T.refract=kF(["visitors","document","objects","ExternalDocumentation","$visitor"]),OT.refract=kF(["visitors","document","objects","Header","$visitor"]),ST.refract=kF(["visitors","document","objects","Info","$visitor"]),AT.refract=kF(["visitors","document","objects","OpenApi","fixedFields","jsonSchemaDialect"]),PT.refract=kF(["visitors","document","objects","License","$visitor"]),TT.refract=kF(["visitors","document","objects","Link","$visitor"]),kT.refract=kF(["visitors","document","objects","MediaType","$visitor"]),FT.refract=kF(["visitors","document","objects","OAuthFlow","$visitor"]),IT.refract=kF(["visitors","document","objects","OAuthFlows","$visitor"]),RT.refract=kF(["visitors","document","objects","OpenApi","fixedFields","openapi"]),DT.refract=kF(["visitors","document","objects","OpenApi","$visitor"]),_T.refract=kF(["visitors","document","objects","Operation","$visitor"]),CT.refract=kF(["visitors","document","objects","Parameter","$visitor"]),MT.refract=kF(["visitors","document","objects","PathItem","$visitor"]),NT.refract=kF(["visitors","document","objects","Paths","$visitor"]),qT.refract=kF(["visitors","document","objects","Reference","$visitor"]),BT.refract=kF(["visitors","document","objects","RequestBody","$visitor"]),LT.refract=kF(["visitors","document","objects","Response","$visitor"]),UT.refract=kF(["visitors","document","objects","Responses","$visitor"]),JT.refract=kF(["visitors","document","objects","Schema","$visitor"]),VT.refract=kF(["visitors","document","objects","SecurityRequirement","$visitor"]),GT.refract=kF(["visitors","document","objects","SecurityScheme","$visitor"]),HT.refract=kF(["visitors","document","objects","Server","$visitor"]),zT.refract=kF(["visitors","document","objects","ServerVariable","$visitor"]),XT.refract=kF(["visitors","document","objects","Tag","$visitor"]),WT.refract=kF(["visitors","document","objects","XML","$visitor"]);class FF extends yE{constructor(e){super({...null!=e?e:{},name:"binary"})}canParse(e){return 0===this.fileExtensions.length||this.fileExtensions.includes(e.extension)}parse(e){try{const t=unescape(encodeURIComponent(e.toString())),r=btoa(t),n=new Yx;if(0!==r.length){const e=new Nx(r);e.classes.push("result"),n.push(e)}return n}catch(t){throw new AE(`Error parsing "${e.uri}"`,{cause:t})}}}class IF extends class{name;constructor({name:e}){this.name=e}}{constructor(e){super({...null!=e?e:{},name:"openapi-3-1"})}canResolve(e,t){const r=t.dereference.strategies.find((e=>"openapi-3-1"===e.name));return void 0!==r&&r.canDereference(e,t)}async resolve(e,t){const r=t.dereference.strategies.find((e=>"openapi-3-1"===e.name));if(void 0===r)throw new vE('"openapi-3-1" dereference strategy is not available.');const n=new Qm,s=nv(t,{resolve:{internal:!1},dereference:{refSet:n}});return await r.dereference(e,s),n}}const{AbortController:RF,AbortSignal:DF}=globalThis;void 0===globalThis.AbortController&&(globalThis.AbortController=RF),void 0===globalThis.AbortSignal&&(globalThis.AbortSignal=DF);class _F extends class extends class{name;constructor({name:e}){this.name=e}}{timeout;redirects;withCredentials;constructor(e){const{name:t="http-resolver",timeout:r=5e3,redirects:n=5,withCredentials:s=!1}=null!=e?e:{};super({name:t}),this.timeout=r,this.redirects=n,this.withCredentials=s}canRead(e){return Um(e.uri)}}{swaggerHTTPClient=_t;swaggerHTTPClientConfig;constructor({swaggerHTTPClient:e=_t,swaggerHTTPClientConfig:t={},...r}={}){super({...r,name:"http-swagger-client"}),this.swaggerHTTPClient=e,this.swaggerHTTPClientConfig=t}getHttpClient(){return this.swaggerHTTPClient}async read(e){const t=this.getHttpClient(),r=new AbortController,{signal:n}=r,s=setTimeout((()=>{r.abort()}),this.timeout),i=this.getHttpClient().withCredentials||this.withCredentials?"include":"same-origin",o=0===this.redirects?"error":"follow",c=this.redirects>0?this.redirects:void 0;try{return(await t({url:e.uri,signal:n,userFetch:async(e,t)=>{let r=await fetch(e,t);try{r.headers.delete("Content-Type")}catch{r=new Response(r.body,{...r,headers:new Headers(r.headers)}),r.headers.delete("Content-Type")}return r},credentials:i,redirect:o,follow:c,...this.swaggerHTTPClientConfig})).text.arrayBuffer()}catch(t){throw new uv(`Error downloading "${e.uri}"`,{cause:t})}finally{clearTimeout(s)}}}class CF extends yE{constructor(e={}){super({name:"json-swagger-client",mediaTypes:["application/json"],...e})}async canParse(e){const t=0===this.fileExtensions.length||this.fileExtensions.includes(e.extension),r=this.mediaTypes.includes(e.mediaType);if(!t)return!1;if(r)return!0;if(!r)try{return JSON.parse(e.toString()),!0}catch(e){return!1}return!1}async parse(e){if(this.sourceMap)throw new AE("json-swagger-client parser plugin doesn't support sourceMaps option");const t=new Yx,r=e.toString();if(this.allowEmpty&&""===r.trim())return t;try{const e=lE(JSON.parse(r));return e.classes.push("result"),t.push(e),t}catch(t){throw new AE(`Error parsing "${e.uri}"`,{cause:t})}}}class MF extends yE{constructor(e={}){super({name:"yaml-1-2-swagger-client",mediaTypes:["text/yaml","application/yaml"],...e})}async canParse(e){const t=0===this.fileExtensions.length||this.fileExtensions.includes(e.extension),r=this.mediaTypes.includes(e.mediaType);if(!t)return!1;if(r)return!0;if(!r)try{return It.load(e.toString(),{schema:xt}),!0}catch(e){return!1}return!1}async parse(e){if(this.sourceMap)throw new AE("yaml-1-2-swagger-client parser plugin doesn't support sourceMaps option");const t=new Yx,r=e.toString();try{const e=It.load(r,{schema:xt});if(this.allowEmpty&&void 0===e)return t;const n=lE(e);return n.classes.push("result"),t.push(n),t}catch(t){throw new AE(`Error parsing "${e.uri}"`,{cause:t})}}}class NF extends yE{detectionRegExp=/"openapi"\s*:\s*"(?<version_json>3\.1\.(?:[1-9]\d*|0))"/;constructor(e={}){super({name:"openapi-json-3-1-swagger-client",mediaTypes:new nO(...sO.filterByFormat("generic"),...sO.filterByFormat("json")),...e})}async canParse(e){const t=0===this.fileExtensions.length||this.fileExtensions.includes(e.extension),r=this.mediaTypes.includes(e.mediaType);if(!t)return!1;if(r)return!0;if(!r)try{const t=e.toString();return JSON.parse(t),this.detectionRegExp.test(t)}catch(e){return!1}return!1}async parse(e){if(this.sourceMap)throw new AE("openapi-json-3-1-swagger-client parser plugin doesn't support sourceMaps option");const t=new Yx,r=e.toString();if(this.allowEmpty&&""===r.trim())return t;try{const e=JSON.parse(r),n=DT.refract(e,this.refractorOpts);return n.classes.push("result"),t.push(n),t}catch(t){throw new AE(`Error parsing "${e.uri}"`,{cause:t})}}}class qF extends yE{detectionRegExp=/(?<YAML>^(["']?)openapi\2\s*:\s*(["']?)(?<version_yaml>3\.1\.(?:[1-9]\d*|0))\3(?:\s+|$))|(?<JSON>"openapi"\s*:\s*"(?<version_json>3\.1\.(?:[1-9]\d*|0))")/m;constructor(e={}){super({name:"openapi-yaml-3-1-swagger-client",mediaTypes:new nO(...sO.filterByFormat("generic"),...sO.filterByFormat("yaml")),...e})}async canParse(e){const t=0===this.fileExtensions.length||this.fileExtensions.includes(e.extension),r=this.mediaTypes.includes(e.mediaType);if(!t)return!1;if(r)return!0;if(!r)try{const t=e.toString();return It.load(t),this.detectionRegExp.test(t)}catch(e){return!1}return!1}async parse(e){if(this.sourceMap)throw new AE("openapi-yaml-3-1-swagger-client parser plugin doesn't support sourceMaps option");const t=new Yx,r=e.toString();try{const e=It.load(r,{schema:xt});if(this.allowEmpty&&void 0===e)return t;const n=DT.refract(e,this.refractorOpts);return n.classes.push("result"),t.push(n),t}catch(t){throw new AE(`Error parsing "${e.uri}"`,{cause:t})}}}const BF=e=>/^[A-Za-z_][A-Za-z_0-9.-]*$/.test(e),LF=e=>{const t=Gm(e);return jm("#",t)},UF=(e,t)=>{const r=(e=>{if(!BF(e))throw new $E(e);return e})(e),n=eE((e=>kk(e)&&oE(e.$anchor)===r),t);if(Id(n))throw new xE(`Evaluation failed on token: "${r}"`);return n},JF=(e,t)=>{if(void 0===t.$ref)return;const r=Gm(oE(t.$ref)),n=oE(t.meta.get("inherited$id"));return`${zf(((e,t)=>Xm(e,Wm(Hm(t)))),e,[...n,oE(t.$ref)])}${"#"===r?"":r}`},VF=e=>{if(VF.cache.has(e))return VF.cache.get(e);const t=JT.refract(e);return VF.cache.set(e,t),t};VF.cache=new WeakMap;const GF=e=>bj(e)?VF(e):e,HF=(e,t)=>{const{cache:r}=HF,n=Hm(e),s=e=>kk(e)&&void 0!==e.$id;if(!r.has(t)){const e=((e,t)=>{const r=new Vj({predicate:e});return Gj(t,r),new _x(r.result)})(s,t);r.set(t,Array.from(e))}const i=r.get(t).find((e=>{const t=((e,t)=>{if(void 0===t.$id)return;const r=oE(t.meta.get("inherited$id"));return zf(((e,t)=>Xm(e,Wm(Hm(t)))),e,[...r,oE(t.$id)])})(n,e);return t===n}));if(Id(i))throw new EE(`Evaluation failed on URI: "${e}"`);let o,c;return BF(LF(e))?(o=UF,c=LF(e)):(o=rO,c=eO(e)),o(c,i)};HF.cache=new WeakMap;const zF=Gj[Symbol.for("nodejs.util.promisify.custom")],XF=new Zj,WF=(e,t,r,n)=>{hj(n)?n.value=e:Array.isArray(n)&&(n[r]=e)};class YF{indirections;namespace;reference;options;ancestors;refractCache;constructor({reference:e,namespace:t,options:r,indirections:n=[],ancestors:s=new bE,refractCache:i=new Map}){this.indirections=n,this.namespace=t,this.reference=e,this.options=r,this.ancestors=new bE(...s),this.refractCache=i}toBaseURI(e){return Xm(this.reference.uri,Wm(Hm(e)))}async toReference(e){if(this.reference.depth>=this.options.resolve.maxDepth)throw new SE(`Maximum resolution depth of ${this.options.resolve.maxDepth} has been exceeded by file "${this.reference.uri}"`);const t=this.toBaseURI(e),{refSet:r}=this.reference;if(r.has(t))return r.find(yd(t,"uri"));const n=await hv(Ym(t),{...this.options,parse:{...this.options.parse,mediaType:"text/plain"}}),s=new gE({uri:t,value:Cj(n),depth:this.reference.depth+1});if(r.add(s),this.options.dereference.immutable){const e=new gE({uri:`immutable://${t}`,value:n,depth:this.reference.depth+1});r.add(e)}return s}toAncestorLineage(e){const t=new Set(e.filter(sj));return[new bE(...this.ancestors,t),t]}async ReferenceElement(e,t,r,n,s,i){if(this.indirections.includes(e))return!1;const[o,c]=this.toAncestorLineage([...s,r]),a=this.toBaseURI(oE(e.$ref)),u=Hm(this.reference.uri)===a,l=!u;if(!this.options.resolve.internal&&u)return!1;if(!this.options.resolve.external&&l)return!1;const h=await this.toReference(oE(e.$ref)),f=Xm(a,oE(e.$ref));this.indirections.push(e);const p=eO(f);let d=rO(p,h.value.result);if(d.id=XF.identify(d),bj(d)){const t=oE(e.meta.get("referenced-element")),r=`${t}-${oE(XF.identify(d))}`;if(this.refractCache.has(r))d=this.refractCache.get(r);else if(bA(d))d=qT.refract(d),d.setMetaProperty("referenced-element",t),this.refractCache.set(r,d);else{d=this.namespace.getElementClass(t).refract(d),this.refractCache.set(r,d)}}if(e===d)throw new Fh("Recursive Reference Object detected");if(this.indirections.length>this.options.dereference.maxDepth)throw new OE(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);if(o.includes(d)){if(h.refSet.circular=!0,"error"===this.options.dereference.circular)throw new Fh("Circular reference detected");if("replace"===this.options.dereference.circular){var m,v;const t=new Gx(d.id,{type:"reference",uri:h.uri,$ref:oE(e.$ref)}),n=(null!==(m=null===(v=this.options.dereference.strategyOpts["openapi-3-1"])||void 0===v?void 0:v.circularReplacer)&&void 0!==m?m:this.options.dereference.circularReplacer)(t);return i.replaceWith(n,WF),!r&&n}}const y=Hm(h.refSet.rootRef.uri)!==h.uri,b=["error","replace"].includes(this.options.dereference.circular);if((l||y||Sk(d)||b)&&!o.includesCycle(d)){c.add(e);const t=new YF({reference:h,namespace:this.namespace,indirections:[...this.indirections],options:this.options,refractCache:this.refractCache,ancestors:o});d=await zF(d,t,{keyMap:ek,nodeTypeGetter:QT}),c.delete(e)}this.indirections.pop();const g=qj(d);return g.setMetaProperty("id",XF.generateId()),g.setMetaProperty("ref-fields",{$ref:oE(e.$ref),description:oE(e.description),summary:oE(e.summary)}),g.setMetaProperty("ref-origin",h.uri),g.setMetaProperty("ref-referencing-element-id",Cj(XF.identify(e))),uj(d)&&uj(g)&&(e.hasKey("description")&&"description"in d&&(g.remove("description"),g.set("description",e.get("description"))),e.hasKey("summary")&&"summary"in d&&(g.remove("summary"),g.set("summary",e.get("summary")))),i.replaceWith(g,WF),!r&&g}async PathItemElement(e,t,r,n,s,i){if(!ij(e.$ref))return;if(this.indirections.includes(e))return!1;const[o,c]=this.toAncestorLineage([...s,r]),a=this.toBaseURI(oE(e.$ref)),u=Hm(this.reference.uri)===a,l=!u;if(!this.options.resolve.internal&&u)return;if(!this.options.resolve.external&&l)return;const h=await this.toReference(oE(e.$ref)),f=Xm(a,oE(e.$ref));this.indirections.push(e);const p=eO(f);let d=rO(p,h.value.result);if(d.id=XF.identify(d),bj(d)){const e=`path-item-${oE(XF.identify(d))}`;this.refractCache.has(e)?d=this.refractCache.get(e):(d=MT.refract(d),this.refractCache.set(e,d))}if(e===d)throw new Fh("Recursive Path Item Object reference detected");if(this.indirections.length>this.options.dereference.maxDepth)throw new OE(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);if(o.includes(d)){if(h.refSet.circular=!0,"error"===this.options.dereference.circular)throw new Fh("Circular reference detected");if("replace"===this.options.dereference.circular){var m,v;const t=new Gx(d.id,{type:"path-item",uri:h.uri,$ref:oE(e.$ref)}),n=(null!==(m=null===(v=this.options.dereference.strategyOpts["openapi-3-1"])||void 0===v?void 0:v.circularReplacer)&&void 0!==m?m:this.options.dereference.circularReplacer)(t);return i.replaceWith(n,WF),!r&&n}}const y=Hm(h.refSet.rootRef.uri)!==h.uri,b=["error","replace"].includes(this.options.dereference.circular);if((l||y||$k(d)&&ij(d.$ref)||b)&&!o.includesCycle(d)){c.add(e);const t=new YF({reference:h,namespace:this.namespace,indirections:[...this.indirections],options:this.options,refractCache:this.refractCache,ancestors:o});d=await zF(d,t,{keyMap:ek,nodeTypeGetter:QT}),c.delete(e)}if(this.indirections.pop(),$k(d)){const t=new MT([...d.content],Cj(d.meta),Cj(d.attributes));t.setMetaProperty("id",XF.generateId()),e.forEach(((e,r,n)=>{t.remove(oE(r)),t.content.push(n)})),t.remove("$ref"),t.setMetaProperty("ref-fields",{$ref:oE(e.$ref)}),t.setMetaProperty("ref-origin",h.uri),t.setMetaProperty("ref-referencing-element-id",Cj(XF.identify(e))),d=t}return i.replaceWith(d,WF),r?void 0:d}async LinkElement(e,t,r,n,s,i){if(!ij(e.operationRef)&&!ij(e.operationId))return;if(ij(e.operationRef)&&ij(e.operationId))throw new Fh("LinkElement operationRef and operationId fields are mutually exclusive.");let o;if(ij(e.operationRef)){var c;const t=eO(oE(e.operationRef)),n=this.toBaseURI(oE(e.operationRef)),s=Hm(this.reference.uri)===n,a=!s;if(!this.options.resolve.internal&&s)return;if(!this.options.resolve.external&&a)return;const u=await this.toReference(oE(e.operationRef));if(o=rO(t,u.value.result),bj(o)){const e=`operation-${oE(XF.identify(o))}`;this.refractCache.has(e)?o=this.refractCache.get(e):(o=_T.refract(o),this.refractCache.set(e,o))}o=qj(o),o.setMetaProperty("ref-origin",u.uri);const l=qj(e);return null===(c=l.operationRef)||void 0===c||c.meta.set("operation",o),i.replaceWith(l,WF),r?void 0:l}if(ij(e.operationId)){var a;const t=oE(e.operationId),n=await this.toReference(Ym(this.reference.uri));if(o=eE((e=>jk(e)&&sj(e.operationId)&&e.operationId.equals(t)),n.value.result),Id(o))throw new Fh(`OperationElement(operationId=${t}) not found.`);const s=qj(e);return null===(a=s.operationId)||void 0===a||a.meta.set("operation",o),i.replaceWith(s,WF),r?void 0:s}}async ExampleElement(e,t,r,n,s,i){if(!ij(e.externalValue))return;if(e.hasKey("value")&&ij(e.externalValue))throw new Fh("ExampleElement value and externalValue fields are mutually exclusive.");const o=this.toBaseURI(oE(e.externalValue)),c=Hm(this.reference.uri)===o,a=!c;if(!this.options.resolve.internal&&c)return;if(!this.options.resolve.external&&a)return;const u=await this.toReference(oE(e.externalValue)),l=qj(u.value.result);l.setMetaProperty("ref-origin",u.uri);const h=qj(e);return h.value=l,i.replaceWith(h,WF),r?void 0:h}async SchemaElement(e,t,r,n,s,i){if(!ij(e.$ref))return;if(this.indirections.includes(e))return!1;const[o,c]=this.toAncestorLineage([...s,r]);let a=await this.toReference(Ym(this.reference.uri)),{uri:u}=a;const l=JF(u,e),h=Hm(l),f=new Km({uri:h}),p=ld((e=>e.canRead(f)),this.options.resolve.resolvers),d=!p;let m,v=Hm(this.reference.uri)===l,y=!v;this.indirections.push(e);try{if(p||d){u=this.toBaseURI(l);const e=l,t=GF(a.value.result);if(m=HF(e,t),m=GF(m),m.id=XF.identify(m),!this.options.resolve.internal&&v)return;if(!this.options.resolve.external&&y)return}else{if(u=this.toBaseURI(l),v=Hm(this.reference.uri)===u,y=!v,!this.options.resolve.internal&&v)return;if(!this.options.resolve.external&&y)return;a=await this.toReference(Ym(l));const e=eO(l),t=GF(a.value.result);m=rO(e,t),m=GF(m),m.id=XF.identify(m)}}catch(e){if(!(d&&e instanceof EE))throw e;if(BF(LF(l))){if(v=Hm(this.reference.uri)===u,y=!v,!this.options.resolve.internal&&v)return;if(!this.options.resolve.external&&y)return;a=await this.toReference(Ym(l));const e=LF(l),t=GF(a.value.result);m=UF(e,t),m=GF(m),m.id=XF.identify(m)}else{if(u=this.toBaseURI(l),v=Hm(this.reference.uri)===u,y=!v,!this.options.resolve.internal&&v)return;if(!this.options.resolve.external&&y)return;a=await this.toReference(Ym(l));const e=eO(l),t=GF(a.value.result);m=rO(e,t),m=GF(m),m.id=XF.identify(m)}}if(e===m)throw new Fh("Recursive Schema Object reference detected");if(this.indirections.length>this.options.dereference.maxDepth)throw new OE(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);if(o.includes(m)){if(a.refSet.circular=!0,"error"===this.options.dereference.circular)throw new Fh("Circular reference detected");if("replace"===this.options.dereference.circular){var b,g;const t=new Gx(m.id,{type:"json-schema",uri:a.uri,$ref:oE(e.$ref)}),n=(null!==(b=null===(g=this.options.dereference.strategyOpts["openapi-3-1"])||void 0===g?void 0:g.circularReplacer)&&void 0!==b?b:this.options.dereference.circularReplacer)(t);return i.replaceWith(n,WF),!r&&n}}const w=Hm(a.refSet.rootRef.uri)!==a.uri,x=["error","replace"].includes(this.options.dereference.circular);if((y||w||kk(m)&&ij(m.$ref)||x)&&!o.includesCycle(m)){c.add(e);const t=new YF({reference:a,namespace:this.namespace,indirections:[...this.indirections],options:this.options,refractCache:this.refractCache,ancestors:o});m=await zF(m,t,{keyMap:ek,nodeTypeGetter:QT}),c.delete(e)}if(this.indirections.pop(),Fk(m)){const t=Cj(m);return t.setMetaProperty("id",XF.generateId()),t.setMetaProperty("ref-fields",{$ref:oE(e.$ref)}),t.setMetaProperty("ref-origin",a.uri),t.setMetaProperty("ref-referencing-element-id",Cj(XF.identify(e))),i.replaceWith(t,WF),!r&&t}if(kk(m)){const t=new JT([...m.content],Cj(m.meta),Cj(m.attributes));t.setMetaProperty("id",XF.generateId()),e.forEach(((e,r,n)=>{t.remove(oE(r)),t.content.push(n)})),t.remove("$ref"),t.setMetaProperty("ref-fields",{$ref:oE(e.$ref)}),t.setMetaProperty("ref-origin",a.uri),t.setMetaProperty("ref-referencing-element-id",Cj(XF.identify(e))),m=t}return i.replaceWith(m,WF),r?void 0:m}}const ZF=Gj[Symbol.for("nodejs.util.promisify.custom")];const KF=e=>{const t=(e=>e.slice(2))(e);return t.reduce(((e,r,n)=>{if(hj(r)){const t=String(oE(r.key));e.push(t)}else if(lj(t[n-2])){const s=t[n-2].content.indexOf(r);e.push(s)}return e}),[])};class QF{modelPropertyMacro;options;SchemaElement={leave:(e,t,r,n,s)=>{void 0!==e.properties&&uj(e.properties)&&e.properties.forEach((t=>{if(uj(t))try{const e=this.modelPropertyMacro(oE(t));t.set("default",e)}catch(t){var n,i;const o=new Error(t,{cause:t});o.fullPath=[...KF([...s,r,e]),"properties"],null===(n=this.options.dereference.dereferenceOpts)||void 0===n||null===(n=n.errors)||void 0===n||null===(i=n.push)||void 0===i||i.call(n,o)}}))}};constructor({modelPropertyMacro:e,options:t}){this.modelPropertyMacro=e,this.options=t}}class eI{options;SchemaElement={leave(e,t,r,n,s){if(void 0===e.allOf)return;if(!lj(e.allOf)){var i,o;const t=new TypeError("allOf must be an array");return t.fullPath=[...KF([...s,r,e]),"allOf"],void(null===(i=this.options.dereference.dereferenceOpts)||void 0===i||null===(i=i.errors)||void 0===i||null===(o=i.push)||void 0===o||o.call(i,t))}if(e.allOf.isEmpty)return void e.remove("allOf");if(!e.allOf.content.every(kk)){var c,a;const t=new TypeError("Elements in allOf must be objects");return t.fullPath=[...KF([...s,r,e]),"allOf"],void(null===(c=this.options.dereference.dereferenceOpts)||void 0===c||null===(c=c.errors)||void 0===c||null===(a=c.push)||void 0===a||a.call(c,t))}for(;e.hasKey("allOf");){const{allOf:t}=e;e.remove("allOf");const r=dE.all([...t.content,e]);if(e.hasKey("$$ref")||r.remove("$$ref"),e.hasKey("example")){const t=r.getMember("example");t&&(t.value=e.get("example"))}if(e.hasKey("examples")){const t=r.getMember("examples");t&&(t.value=e.get("examples"))}e.content=r.content}}};constructor({options:e}){this.options=e}}class tI{parameterMacro;options;#e;OperationElement={enter:e=>{this.#e=e},leave:()=>{this.#e=void 0}};ParameterElement={leave:(e,t,r,n,s)=>{const i=this.#e?oE(this.#e):null,o=oE(e);try{const t=this.parameterMacro(i,o);e.set("default",t)}catch(e){var c,a;const t=new Error(e,{cause:e});t.fullPath=KF([...s,r]),null===(c=this.options.dereference.dereferenceOpts)||void 0===c||null===(c=c.errors)||void 0===c||null===(a=c.push)||void 0===a||a.call(c,t)}}};constructor({parameterMacro:e,options:t}){this.parameterMacro=e,this.options=t}}const rI=e=>{if(null==e.cause)return e;let{cause:t}=e;for(;null!=t.cause;)t=t.cause;return t};class nI extends Ih{}const{wrapError:sI}=m$,iI=Gj[Symbol.for("nodejs.util.promisify.custom")],oI=new Zj,cI=(e,t,r,n)=>{hj(n)?n.value=e:Array.isArray(n)&&(n[r]=e)};class aI extends YF{useCircularStructures;allowMetaPatches;basePath;constructor({allowMetaPatches:e=!0,useCircularStructures:t=!1,basePath:r=null,...n}){super(n),this.allowMetaPatches=e,this.useCircularStructures=t,this.basePath=r}async ReferenceElement(e,t,r,n,s,i){try{if(this.indirections.includes(e))return!1;const[t,n]=this.toAncestorLineage([...s,r]),u=this.toBaseURI(oE(e.$ref)),l=Hm(this.reference.uri)===u,h=!l;if(!this.options.resolve.internal&&l)return!1;if(!this.options.resolve.external&&h)return!1;const f=await this.toReference(oE(e.$ref)),p=Xm(u,oE(e.$ref));this.indirections.push(e);const d=eO(p);let m=rO(d,f.value.result);if(m.id=oI.identify(m),bj(m)){const t=oE(e.meta.get("referenced-element")),r=`${t}-${oE(oI.identify(m))}`;if(this.refractCache.has(r))m=this.refractCache.get(r);else if(bA(m))m=qT.refract(m),m.setMetaProperty("referenced-element",t),this.refractCache.set(r,m);else{m=this.namespace.getElementClass(t).refract(m),this.refractCache.set(r,m)}}if(e===m)throw new Fh("Recursive Reference Object detected");if(this.indirections.length>this.options.dereference.maxDepth)throw new OE(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);if(t.includes(m)){if(f.refSet.circular=!0,"error"===this.options.dereference.circular)throw new Fh("Circular reference detected");if("replace"===this.options.dereference.circular){var o,c;const t=new Gx(m.id,{type:"reference",uri:f.uri,$ref:oE(e.$ref),baseURI:p,referencingElement:e}),n=(null!==(o=null===(c=this.options.dereference.strategyOpts["openapi-3-1"])||void 0===c?void 0:c.circularReplacer)&&void 0!==o?o:this.options.dereference.circularReplacer)(t);return i.replaceWith(t,cI),!r&&n}}const v=Hm(f.refSet.rootRef.uri)!==f.uri,y=["error","replace"].includes(this.options.dereference.circular);if((h||v||Sk(m)||y)&&!t.includesCycle(m)){var a;n.add(e);const i=new aI({reference:f,namespace:this.namespace,indirections:[...this.indirections],options:this.options,refractCache:this.refractCache,ancestors:t,allowMetaPatches:this.allowMetaPatches,useCircularStructures:this.useCircularStructures,basePath:null!==(a=this.basePath)&&void 0!==a?a:[...KF([...s,r,e]),"$ref"]});m=await iI(m,i,{keyMap:ek,nodeTypeGetter:QT}),n.delete(e)}this.indirections.pop();const b=qj(m);if(b.setMetaProperty("ref-fields",{$ref:oE(e.$ref),description:oE(e.description),summary:oE(e.summary)}),b.setMetaProperty("ref-origin",f.uri),b.setMetaProperty("ref-referencing-element-id",Cj(oI.identify(e))),uj(m)&&(e.hasKey("description")&&"description"in m&&(b.remove("description"),b.set("description",e.get("description"))),e.hasKey("summary")&&"summary"in m&&(b.remove("summary"),b.set("summary",e.get("summary")))),this.allowMetaPatches&&uj(b)&&!b.hasKey("$$ref")){const e=Xm(u,p);b.set("$$ref",e)}return i.replaceWith(b,cI),!r&&b}catch(t){var u,l,h;const n=rI(t),i=sI(n,{baseDoc:this.reference.uri,$ref:oE(e.$ref),pointer:eO(oE(e.$ref)),fullPath:null!==(u=this.basePath)&&void 0!==u?u:[...KF([...s,r,e]),"$ref"]});return void(null===(l=this.options.dereference.dereferenceOpts)||void 0===l||null===(l=l.errors)||void 0===l||null===(h=l.push)||void 0===h||h.call(l,i))}}async PathItemElement(e,t,r,n,s,i){try{if(!ij(e.$ref))return;if(this.indirections.includes(e))return!1;if(wj(["cycle"],e.$ref))return!1;const[t,n]=this.toAncestorLineage([...s,r]),u=this.toBaseURI(oE(e.$ref)),l=Hm(this.reference.uri)===u,h=!l;if(!this.options.resolve.internal&&l)return;if(!this.options.resolve.external&&h)return;const f=await this.toReference(oE(e.$ref)),p=Xm(u,oE(e.$ref));this.indirections.push(e);const d=eO(p);let m=rO(d,f.value.result);if(m.id=oI.identify(m),bj(m)){const e=`path-item-${oE(oI.identify(m))}`;this.refractCache.has(e)?m=this.refractCache.get(e):(m=MT.refract(m),this.refractCache.set(e,m))}if(e===m)throw new Fh("Recursive Path Item Object reference detected");if(this.indirections.length>this.options.dereference.maxDepth)throw new OE(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);if(t.includes(m)){if(f.refSet.circular=!0,"error"===this.options.dereference.circular)throw new Fh("Circular reference detected");if("replace"===this.options.dereference.circular){var o,c;const t=new Gx(m.id,{type:"path-item",uri:f.uri,$ref:oE(e.$ref),baseURI:p,referencingElement:e}),n=(null!==(o=null===(c=this.options.dereference.strategyOpts["openapi-3-1"])||void 0===c?void 0:c.circularReplacer)&&void 0!==o?o:this.options.dereference.circularReplacer)(t);return i.replaceWith(t,cI),!r&&n}}const v=Hm(f.refSet.rootRef.uri)!==f.uri,y=["error","replace"].includes(this.options.dereference.circular);if((h||v||$k(m)&&ij(m.$ref)||y)&&!t.includesCycle(m)){var a;n.add(e);const i=new aI({reference:f,namespace:this.namespace,indirections:[...this.indirections],options:this.options,ancestors:t,allowMetaPatches:this.allowMetaPatches,useCircularStructures:this.useCircularStructures,basePath:null!==(a=this.basePath)&&void 0!==a?a:[...KF([...s,r,e]),"$ref"]});m=await iI(m,i,{keyMap:ek,nodeTypeGetter:QT}),n.delete(e)}if(this.indirections.pop(),$k(m)){const t=new MT([...m.content],Cj(m.meta),Cj(m.attributes));if(e.forEach(((e,r,n)=>{t.remove(oE(r)),t.content.push(n)})),t.remove("$ref"),t.setMetaProperty("ref-fields",{$ref:oE(e.$ref)}),t.setMetaProperty("ref-origin",f.uri),t.setMetaProperty("ref-referencing-element-id",Cj(oI.identify(e))),this.allowMetaPatches&&void 0===t.get("$$ref")){const e=Xm(u,p);t.set("$$ref",e)}m=t}return i.replaceWith(m,cI),r?void 0:m}catch(t){var u,l,h;const n=rI(t),i=sI(n,{baseDoc:this.reference.uri,$ref:oE(e.$ref),pointer:eO(oE(e.$ref)),fullPath:null!==(u=this.basePath)&&void 0!==u?u:[...KF([...s,r,e]),"$ref"]});return void(null===(l=this.options.dereference.dereferenceOpts)||void 0===l||null===(l=l.errors)||void 0===l||null===(h=l.push)||void 0===h||h.call(l,i))}}async SchemaElement(e,t,r,n,s,i){try{if(!ij(e.$ref))return;if(this.indirections.includes(e))return!1;const[t,n]=this.toAncestorLineage([...s,r]);let u=await this.toReference(Ym(this.reference.uri)),{uri:l}=u;const h=JF(l,e),f=Hm(h),p=new Km({uri:f}),d=!this.options.resolve.resolvers.some((e=>e.canRead(p))),m=!d;let v,y=Hm(this.reference.uri)===h,b=!y;this.indirections.push(e);try{if(d||m){l=this.toBaseURI(h);const e=h,t=GF(u.value.result);if(v=HF(e,t),v=GF(v),v.id=oI.identify(v),!this.options.resolve.internal&&y)return;if(!this.options.resolve.external&&b)return}else{if(l=this.toBaseURI(h),y=Hm(this.reference.uri)===l,b=!y,!this.options.resolve.internal&&y)return;if(!this.options.resolve.external&&b)return;u=await this.toReference(Ym(h));const e=eO(h),t=GF(u.value.result);v=rO(e,t),v=GF(v),v.id=oI.identify(v)}}catch(e){if(!(m&&e instanceof EE))throw e;if(BF(LF(h))){if(y=Hm(this.reference.uri)===l,b=!y,!this.options.resolve.internal&&y)return;if(!this.options.resolve.external&&b)return;u=await this.toReference(Ym(h));const e=LF(h),t=GF(u.value.result);v=UF(e,t),v=GF(v),v.id=oI.identify(v)}else{if(l=this.toBaseURI(oE(h)),y=Hm(this.reference.uri)===l,b=!y,!this.options.resolve.internal&&y)return;if(!this.options.resolve.external&&b)return;u=await this.toReference(Ym(h));const e=eO(h),t=GF(u.value.result);v=rO(e,t),v=GF(v),v.id=oI.identify(v)}}if(e===v)throw new Fh("Recursive Schema Object reference detected");if(this.indirections.length>this.options.dereference.maxDepth)throw new OE(`Maximum dereference depth of "${this.options.dereference.maxDepth}" has been exceeded in file "${this.reference.uri}"`);if(t.includes(v)){if(u.refSet.circular=!0,"error"===this.options.dereference.circular)throw new Fh("Circular reference detected");if("replace"===this.options.dereference.circular){var o,c;const t=new Gx(v.id,{type:"json-schema",uri:u.uri,$ref:oE(e.$ref),baseURI:Xm(l,h),referencingElement:e}),n=(null!==(o=null===(c=this.options.dereference.strategyOpts["openapi-3-1"])||void 0===c?void 0:c.circularReplacer)&&void 0!==o?o:this.options.dereference.circularReplacer)(t);return i.replaceWith(n,cI),!r&&n}}const g=Hm(u.refSet.rootRef.uri)!==u.uri,w=["error","replace"].includes(this.options.dereference.circular);if((b||g||kk(v)&&ij(v.$ref)||w)&&!t.includesCycle(v)){var a;n.add(e);const i=new aI({reference:u,namespace:this.namespace,indirections:[...this.indirections],options:this.options,useCircularStructures:this.useCircularStructures,allowMetaPatches:this.allowMetaPatches,ancestors:t,basePath:null!==(a=this.basePath)&&void 0!==a?a:[...KF([...s,r,e]),"$ref"]});v=await iI(v,i,{keyMap:ek,nodeTypeGetter:QT}),n.delete(e)}if(this.indirections.pop(),Fk(v)){const t=Cj(v);return t.setMetaProperty("ref-fields",{$ref:oE(e.$ref)}),t.setMetaProperty("ref-origin",u.uri),t.setMetaProperty("ref-referencing-element-id",Cj(oI.identify(e))),i.replaceWith(t,cI),!r&&t}if(kk(v)){const t=new JT([...v.content],Cj(v.meta),Cj(v.attributes));if(e.forEach(((e,r,n)=>{t.remove(oE(r)),t.content.push(n)})),t.remove("$ref"),t.setMetaProperty("ref-fields",{$ref:oE(e.$ref)}),t.setMetaProperty("ref-origin",u.uri),t.setMetaProperty("ref-referencing-element-id",Cj(oI.identify(e))),this.allowMetaPatches&&void 0===t.get("$$ref")){const e=Xm(l,h);t.set("$$ref",e)}v=t}return i.replaceWith(v,cI),r?void 0:v}catch(t){var u,l,h;const n=rI(t),i=new nI(`Could not resolve reference: ${n.message}`,{baseDoc:this.reference.uri,$ref:oE(e.$ref),fullPath:null!==(u=this.basePath)&&void 0!==u?u:[...KF([...s,r,e]),"$ref"],cause:n});return void(null===(l=this.options.dereference.dereferenceOpts)||void 0===l||null===(l=l.errors)||void 0===l||null===(h=l.push)||void 0===h||h.call(l,i))}}async LinkElement(){}async ExampleElement(e,t,r,n,s,i){try{return await super.ExampleElement(e,t,r,n,s,i)}catch(t){var o,c,a;const n=rI(t),i=sI(n,{baseDoc:this.reference.uri,externalValue:oE(e.externalValue),fullPath:null!==(o=this.basePath)&&void 0!==o?o:[...KF([...s,r,e]),"externalValue"]});return void(null===(c=this.options.dereference.dereferenceOpts)||void 0===c||null===(c=c.errors)||void 0===c||null===(a=c.push)||void 0===a||a.call(c,i))}}}const uI=Fj[Symbol.for("nodejs.util.promisify.custom")];class lI{constructor({parameterMacro:e,modelPropertyMacro:t,mode:r,options:n,...s}){const i=[];i.push(new aI({...s,options:n})),"function"==typeof t&&i.push(new QF({modelPropertyMacro:t,options:n})),"strict"!==r&&i.push(new eI({options:n})),"function"==typeof e&&i.push(new tI({parameterMacro:e,options:n}));const o=uI(i,{nodeTypeGetter:QT});Object.assign(this,o)}}const hI=Gj[Symbol.for("nodejs.util.promisify.custom")];class fI extends class extends class{name;constructor({name:e}){this.name=e}}{constructor(e){super({...null!=e?e:{},name:"openapi-3-1"})}canDereference(e){var t;return"text/plain"!==e.mediaType?sO.includes(e.mediaType):xk(null===(t=e.parseResult)||void 0===t?void 0:t.result)}async dereference(e,t){var r;const n=$j(YT),s=null!==(r=t.dereference.refSet)&&void 0!==r?r:new Qm,i=new Qm;let o,c=s;s.has(e.uri)?o=s.find(yd(e.uri,"uri")):(o=new gE({uri:e.uri,value:e.parseResult}),s.add(o)),t.dereference.immutable&&(s.refs.map((e=>new gE({...e,value:Cj(e.value)}))).forEach((e=>i.add(e))),o=i.find((t=>t.uri===e.uri)),c=i);const a=new YF({reference:o,namespace:n,options:t}),u=await ZF(c.rootRef.value,a,{keyMap:ek,nodeTypeGetter:QT});return t.dereference.immutable&&i.refs.filter((e=>e.uri.startsWith("immutable://"))).map((e=>new gE({...e,uri:e.uri.replace(/^immutable:\/\//,"")}))).forEach((e=>s.add(e))),null===t.dereference.refSet&&s.clean(),i.clean(),u}}{allowMetaPatches;parameterMacro;modelPropertyMacro;mode;ancestors;constructor({allowMetaPatches:e=!1,parameterMacro:t=null,modelPropertyMacro:r=null,mode:n="non-strict",ancestors:s=[],...i}={}){super({...i}),this.name="openapi-3-1-swagger-client",this.allowMetaPatches=e,this.parameterMacro=t,this.modelPropertyMacro=r,this.mode=n,this.ancestors=[...s]}async dereference(e,t){var r;const n=$j(YT),s=null!==(r=t.dereference.refSet)&&void 0!==r?r:new Qm,i=new Qm;let o,c=s;s.has(e.uri)?o=s.find((t=>t.uri===e.uri)):(o=new gE({uri:e.uri,value:e.parseResult}),s.add(o)),t.dereference.immutable&&(s.refs.map((e=>new gE({...e,value:Cj(e.value)}))).forEach((e=>i.add(e))),o=i.find((t=>t.uri===e.uri)),c=i);const a=new lI({reference:o,namespace:n,options:t,allowMetaPatches:this.allowMetaPatches,ancestors:this.ancestors,modelPropertyMacro:this.modelPropertyMacro,mode:this.mode,parameterMacro:this.parameterMacro}),u=await hI(c.rootRef.value,a,{keyMap:ek,nodeTypeGetter:QT});return t.dereference.immutable&&i.refs.filter((e=>e.uri.startsWith("immutable://"))).map((e=>new gE({...e,uri:e.uri.replace(/^immutable:\/\//,"")}))).forEach((e=>s.add(e))),null===t.dereference.refSet&&s.clean(),i.clean(),u}}const pI=e=>{const t=oE(e.meta.get("baseURI")),r=e.meta.get("referencingElement");return new Jx({$ref:t},Cj(r.meta),Cj(r.attributes))},dI=async e=>{const{spec:t,timeout:r,redirects:n,requestInterceptor:s,responseInterceptor:i,pathDiscriminator:o=[],allowMetaPatches:c=!1,useCircularStructures:a=!1,skipNormalization:u=!1,parameterMacro:l=null,modelPropertyMacro:h=null,mode:f="non-strict",strategies:p}=e;try{const{cache:d}=dI,m=p.find((e=>e.match(t))),v=Um(zm())?zm():"https://swagger.io",y=Mt(e),b=Xm(v,y);let g;d.has(t)?g=d.get(t):(g=DT.refract(t),g.classes.push("result"),d.set(t,g));const w=new Yx([g]),x=tO(o),j=""===x?"":`#${x}`,E=rO(x,g),$=new gE({uri:b,value:w}),O=new Qm({refs:[$]});""!==x&&(O.rootRef=void 0);const S=[new Set([E])],A=[],P=((e,t,r)=>new aE({element:r}).transclude(e,t))(E,await PE(E,{resolve:{baseURI:`${b}${j}`,resolvers:[new _F({timeout:r||1e4,redirects:n||10})],resolverOpts:{swaggerHTTPClientConfig:{requestInterceptor:s,responseInterceptor:i}},strategies:[new IF]},parse:{mediaType:sO.latest(),parsers:[new NF({allowEmpty:!1,sourceMap:!1}),new qF({allowEmpty:!1,sourceMap:!1}),new CF({allowEmpty:!1,sourceMap:!1}),new MF({allowEmpty:!1,sourceMap:!1}),new FF({allowEmpty:!1,sourceMap:!1})]},dereference:{maxDepth:100,strategies:[new fI({allowMetaPatches:c,useCircularStructures:a,parameterMacro:l,modelPropertyMacro:h,mode:f,ancestors:S})],refSet:O,dereferenceOpts:{errors:A},immutable:!1,circular:a?"ignore":"replace",circularReplacer:a?ev.dereference.circularReplacer:pI}}),g),T=u?P:m.normalize(P);return{spec:oE(T),errors:A}}catch(e){if(e instanceof W$||e instanceof Z$)return{spec:null,errors:[]};throw e}};dI.cache=new WeakMap;const mI=e=>{if(!uj(e))return e;const t=[ck({operationIdNormalizer:(e,t,r)=>M$({operationId:e},t,r,{v2OperationIdCompatibilityMode:!1})}),rk(),nk(),ak(),uk()];return zj(e,t,{toolboxCreator:qk,visitorOptions:{keyMap:ek,nodeTypeGetter:QT}})},vI={name:"openapi-3-1-apidom",match:e=>U$(e),normalize(e){if(!sj(e)&&em(e)&&!e.$$normalized){const r=(t=mI,e=>{const r=DT.refract(e);r.classes.push("result");const n=t(r),s=oE(n);return dI.cache.set(s,n),oE(n)})(e);return r.$$normalized=!0,r}var t;return sj(e)?mI(e):e},resolve:async e=>dI(e)};function yI(e,t,r){if(!e||"object"!=typeof e||!e.paths||"object"!=typeof e.paths)return null;const{paths:n}=e;for(const s in n)for(const i in n[s]){if("PARAMETERS"===i.toUpperCase())continue;const o=n[s][i];if(!o||"object"!=typeof o)continue;const c={spec:e,pathName:s,method:i.toUpperCase(),operation:o},a=t(c);if(r&&a)return c}}function bI(e,t){return`${t.toLowerCase()}-${e}`}function gI(e,t){return e&&e.paths?function(e,t){return yI(e,t,!0)||null}(e,(({pathName:e,method:r,operation:n})=>{if(!n||"object"!=typeof n)return!1;const s=n.operationId;return[M$(n,e,r),bI(e,r),s].some((e=>e&&e===t))})):null}const{isHttpUrl:wI}=Zm,xI=()=>null,jI={mapTagOperations:function({spec:e,cb:t=xI,defaultTag:r="default",v2OperationIdCompatibilityMode:n}){const s={},i={};return yI(e,(({pathName:o,method:c,operation:a})=>{var u;(a.tags?(u=a.tags,Array.isArray(u)?u:[u]):[r]).forEach((r=>{if("string"!=typeof r)return;i[r]=i[r]||{};const u=i[r],l=M$(a,o,c,{v2OperationIdCompatibilityMode:n}),h=t({spec:e,pathName:o,method:c,operation:a,operationId:l});if(s[l])s[l]+=1,u[`${l}${s[l]}`]=h;else if(void 0!==u[l]){const e=s[l]||1;s[l]=e+1,u[`${l}${s[l]}`]=h;const t=u[l];delete u[l],u[`${l}${e}`]=t}else u[l]=h}))})),i},makeExecute:function(e={}){return({pathName:t,method:r,operationId:n})=>(s,i={})=>{const{requestInterceptor:o,responseInterceptor:c,userFetch:a}=e;return e.execute({spec:e.spec,requestInterceptor:o,responseInterceptor:c,userFetch:a,pathName:t,method:r,parameters:s,operationId:n,...i})}}};var EI={
/*!
 * cookie
 * Copyright(c) 2012-2014 Roman Shtylman
 * Copyright(c) 2015 Douglas Christopher Wilson
 * MIT Licensed
 */
parse:function(e,t){if("string"!=typeof e)throw new TypeError("argument str must be a string");var r={},n=(t||{}).decode||SI,s=0;for(;s<e.length;){var i=e.indexOf("=",s);if(-1===i)break;var o=e.indexOf(";",s);if(-1===o)o=e.length;else if(o<i){s=e.lastIndexOf(";",i-1)+1;continue}var c=e.slice(s,i).trim();if(void 0===r[c]){var a=e.slice(i+1,o).trim();34===a.charCodeAt(0)&&(a=a.slice(1,-1)),r[c]=PI(a,n)}s=o+1}return r},serialize:function(e,t,r){var n=r||{},s=n.encode||AI;if("function"!=typeof s)throw new TypeError("option encode is invalid");if(!OI.test(e))throw new TypeError("argument name is invalid");var i=s(t);if(i&&!OI.test(i))throw new TypeError("argument val is invalid");var o=e+"="+i;if(null!=n.maxAge){var c=n.maxAge-0;if(isNaN(c)||!isFinite(c))throw new TypeError("option maxAge is invalid");o+="; Max-Age="+Math.floor(c)}if(n.domain){if(!OI.test(n.domain))throw new TypeError("option domain is invalid");o+="; Domain="+n.domain}if(n.path){if(!OI.test(n.path))throw new TypeError("option path is invalid");o+="; Path="+n.path}if(n.expires){var a=n.expires;if(!function(e){return"[object Date]"===$I.call(e)||e instanceof Date}(a)||isNaN(a.valueOf()))throw new TypeError("option expires is invalid");o+="; Expires="+a.toUTCString()}n.httpOnly&&(o+="; HttpOnly");n.secure&&(o+="; Secure");n.partitioned&&(o+="; Partitioned");if(n.priority){switch("string"==typeof n.priority?n.priority.toLowerCase():n.priority){case"low":o+="; Priority=Low";break;case"medium":o+="; Priority=Medium";break;case"high":o+="; Priority=High";break;default:throw new TypeError("option priority is invalid")}}if(n.sameSite){switch("string"==typeof n.sameSite?n.sameSite.toLowerCase():n.sameSite){case!0:o+="; SameSite=Strict";break;case"lax":o+="; SameSite=Lax";break;case"strict":o+="; SameSite=Strict";break;case"none":o+="; SameSite=None";break;default:throw new TypeError("option sameSite is invalid")}}return o}},$I=Object.prototype.toString,OI=/^[\u0009\u0020-\u007e\u0080-\u00ff]+$/;function SI(e){return-1!==e.indexOf("%")?decodeURIComponent(e):e}function AI(e){return encodeURIComponent(e)}function PI(e,t){try{return t(e)}catch(t){return e}}const TI=function(){const e=II,t=FI,r=this,n="parser.js: Parser(): ";r.ast=void 0,r.stats=void 0,r.trace=void 0,r.callbacks=[];let s,i,o,c,a,u,l,h=0,f=0,p=0,d=0,m=0,v=new function(){this.state=e.ACTIVE,this.phraseLength=0,this.refresh=()=>{this.state=e.ACTIVE,this.phraseLength=0}};r.parse=(y,b,w,x)=>{const j=`${n}parse(): `;h=0,f=0,p=0,d=0,m=0,s=void 0,i=void 0,o=void 0,c=void 0,v.refresh(),a=void 0,u=void 0,l=void 0,c=t.stringToChars(w),s=y.rules,i=y.udts;const E=b.toLowerCase();let $;for(const e in s)if(s.hasOwnProperty(e)&&E===s[e].lower){$=s[e].index;break}if(void 0===$)throw new Error(`${j}start rule name '${startRule}' not recognized`);(()=>{const e=`${n}initializeCallbacks(): `;let t,o;for(a=[],u=[],t=0;t<s.length;t+=1)a[t]=void 0;for(t=0;t<i.length;t+=1)u[t]=void 0;const c=[];for(t=0;t<s.length;t+=1)c.push(s[t].lower);for(t=0;t<i.length;t+=1)c.push(i[t].lower);for(const n in r.callbacks)if(r.callbacks.hasOwnProperty(n)){if(t=c.indexOf(n.toLowerCase()),t<0)throw new Error(`${e}syntax callback '${n}' not a rule or udt name`);if(o=r.callbacks[n]?r.callbacks[n]:void 0,"function"!=typeof o&&void 0!==o)throw new Error(`${e}syntax callback[${n}] must be function reference or falsy)`);t<s.length?a[t]=o:u[t-s.length]=o}})(),r.trace&&r.trace.init(s,i,c),r.stats&&r.stats.init(s,i),r.ast&&r.ast.init(s,i,c),l=x,o=[{type:e.RNM,index:$}],g(0,0),o=void 0;let O=!1;switch(v.state){case e.ACTIVE:throw new Error(`${j}final state should never be 'ACTIVE'`);case e.NOMATCH:O=!1;break;case e.EMPTY:case e.MATCH:O=v.phraseLength===c.length;break;default:throw new Error("unrecognized state")}return{success:O,state:v.state,stateName:e.idName(v.state),length:c.length,matched:v.phraseLength,maxMatched:m,maxTreeDepth:p,nodeHits:d}};const y=(t,r,s,i)=>{if(r.phraseLength>s){let e=`${n}opRNM(${t.name}): callback function error: `;throw e+=`sysData.phraseLength: ${r.phraseLength}`,e+=` must be <= remaining chars: ${s}`,new Error(e)}switch(r.state){case e.ACTIVE:if(!i)throw new Error(`${n}opRNM(${t.name}): callback function return error. ACTIVE state not allowed.`);break;case e.EMPTY:r.phraseLength=0;break;case e.MATCH:0===r.phraseLength&&(r.state=e.EMPTY);break;case e.NOMATCH:r.phraseLength=0;break;default:throw new Error(`${n}opRNM(${t.name}): callback function return error. Unrecognized return state: ${r.state}`)}},b=(t,a)=>{let f,p,d;const m=o[t],y=i[m.index];v.UdtIndex=y.index,h||(d=r.ast&&r.ast.udtDefined(m.index),d&&(p=s.length+m.index,f=r.ast.getLength(),r.ast.down(p,y.name)));const b=c.length-a;u[m.index](v,c,a,l),((t,r,s)=>{if(r.phraseLength>s){let e=`${n}opUDT(${t.name}): callback function error: `;throw e+=`sysData.phraseLength: ${r.phraseLength}`,e+=` must be <= remaining chars: ${s}`,new Error(e)}switch(r.state){case e.ACTIVE:throw new Error(`${n}opUDT(${t.name}) ACTIVE state return not allowed.`);case e.EMPTY:if(!t.empty)throw new Error(`${n}opUDT(${t.name}) may not return EMPTY.`);r.phraseLength=0;break;case e.MATCH:if(0===r.phraseLength){if(!t.empty)throw new Error(`${n}opUDT(${t.name}) may not return EMPTY.`);r.state=e.EMPTY}break;case e.NOMATCH:r.phraseLength=0;break;default:throw new Error(`${n}opUDT(${t.name}): callback function return error. Unrecognized return state: ${r.state}`)}})(y,v,b),h||d&&(v.state===e.NOMATCH?r.ast.setLength(f):r.ast.up(p,y.name,a,v.phraseLength))},g=(t,i)=>{const u=`${n}opExecute(): `,w=o[t];switch(d+=1,f>p&&(p=f),f+=1,v.refresh(),r.trace&&r.trace.down(w,i),w.type){case e.ALT:((t,r)=>{const n=o[t];for(let t=0;t<n.children.length&&(g(n.children[t],r),v.state===e.NOMATCH);t+=1);})(t,i);break;case e.CAT:((t,n)=>{let s,i,c,a;const u=o[t];r.ast&&(i=r.ast.getLength()),s=!0,c=n,a=0;for(let t=0;t<u.children.length;t+=1){if(g(u.children[t],c),v.state===e.NOMATCH){s=!1;break}c+=v.phraseLength,a+=v.phraseLength}s?(v.state=0===a?e.EMPTY:e.MATCH,v.phraseLength=a):(v.state=e.NOMATCH,v.phraseLength=0,r.ast&&r.ast.setLength(i))})(t,i);break;case e.REP:((t,n)=>{let s,i,a,u;const l=o[t];if(0===l.max)return v.state=e.EMPTY,void(v.phraseLength=0);for(i=n,a=0,u=0,r.ast&&(s=r.ast.getLength());!(i>=c.length)&&(g(t+1,i),v.state!==e.NOMATCH)&&v.state!==e.EMPTY&&(u+=1,a+=v.phraseLength,i+=v.phraseLength,u!==l.max););v.state===e.EMPTY||u>=l.min?(v.state=0===a?e.EMPTY:e.MATCH,v.phraseLength=a):(v.state=e.NOMATCH,v.phraseLength=0,r.ast&&r.ast.setLength(s))})(t,i);break;case e.RNM:((t,n)=>{let i,u,f;const p=o[t],d=s[p.index],m=a[d.index];if(h||(u=r.ast&&r.ast.ruleDefined(p.index),u&&(i=r.ast.getLength(),r.ast.down(p.index,s[p.index].name))),m){const t=c.length-n;m(v,c,n,l),y(d,v,t,!0),v.state===e.ACTIVE&&(f=o,o=d.opcodes,g(0,n),o=f,m(v,c,n,l),y(d,v,t,!1))}else f=o,o=d.opcodes,g(0,n),o=f;h||u&&(v.state===e.NOMATCH?r.ast.setLength(i):r.ast.up(p.index,d.name,n,v.phraseLength))})(t,i);break;case e.TRG:((t,r)=>{const n=o[t];v.state=e.NOMATCH,r<c.length&&n.min<=c[r]&&c[r]<=n.max&&(v.state=e.MATCH,v.phraseLength=1)})(t,i);break;case e.TBS:((t,r)=>{const n=o[t],s=n.string.length;if(v.state=e.NOMATCH,r+s<=c.length){for(let e=0;e<s;e+=1)if(c[r+e]!==n.string[e])return;v.state=e.MATCH,v.phraseLength=s}})(t,i);break;case e.TLS:((t,r)=>{let n;const s=o[t];v.state=e.NOMATCH;const i=s.string.length;if(0!==i){if(r+i<=c.length){for(let e=0;e<i;e+=1)if(n=c[r+e],n>=65&&n<=90&&(n+=32),n!==s.string[e])return;v.state=e.MATCH,v.phraseLength=i}}else v.state=e.EMPTY})(t,i);break;case e.UDT:b(t,i);break;case e.AND:((t,r)=>{switch(h+=1,g(t+1,r),h-=1,v.phraseLength=0,v.state){case e.EMPTY:case e.MATCH:v.state=e.EMPTY;break;case e.NOMATCH:v.state=e.NOMATCH;break;default:throw new Error(`opAND: invalid state ${v.state}`)}})(t,i);break;case e.NOT:((t,r)=>{switch(h+=1,g(t+1,r),h-=1,v.phraseLength=0,v.state){case e.EMPTY:case e.MATCH:v.state=e.NOMATCH;break;case e.NOMATCH:v.state=e.EMPTY;break;default:throw new Error(`opNOT: invalid state ${v.state}`)}})(t,i);break;default:throw new Error(`${u}unrecognized operator`)}h||i+v.phraseLength>m&&(m=i+v.phraseLength),r.stats&&r.stats.collect(w,v),r.trace&&r.trace.up(w,v.state,i,v.phraseLength),f-=1}},kI=function(){const e=II,t=FI,r=this;let n,s,i,o=0;const c=[],a=[],u=[];function l(e){let t="";for(;e-- >0;)t+=" ";return t}r.callbacks=[],r.init=(e,t,l)=>{let h;a.length=0,u.length=0,o=0,n=e,s=t,i=l;const f=[];for(h=0;h<n.length;h+=1)f.push(n[h].lower);for(h=0;h<s.length;h+=1)f.push(s[h].lower);for(o=n.length+s.length,h=0;h<o;h+=1)c[h]=void 0;for(const e in r.callbacks)if(r.callbacks.hasOwnProperty(e)){const t=e.toLowerCase();if(h=f.indexOf(t),h<0)throw new Error(`parser.js: Ast()): init: node '${e}' not a rule or udt name`);c[h]=r.callbacks[e]}},r.ruleDefined=e=>!!c[e],r.udtDefined=e=>!!c[n.length+e],r.down=(t,r)=>{const n=u.length;return a.push(n),u.push({name:r,thisIndex:n,thatIndex:void 0,state:e.SEM_PRE,callbackIndex:t,phraseIndex:void 0,phraseLength:void 0,stack:a.length}),n},r.up=(t,r,n,s)=>{const i=u.length,o=a.pop();return u.push({name:r,thisIndex:i,thatIndex:o,state:e.SEM_POST,callbackIndex:t,phraseIndex:n,phraseLength:s,stack:a.length}),u[o].thatIndex=i,u[o].phraseIndex=n,u[o].phraseLength=s,i},r.translate=t=>{let r,n;for(let s=0;s<u.length;s+=1)n=u[s],r=c[n.callbackIndex],r&&(n.state===e.SEM_PRE?r(e.SEM_PRE,i,n.phraseIndex,n.phraseLength,t):r&&r(e.SEM_POST,i,n.phraseIndex,n.phraseLength,t))},r.setLength=e=>{u.length=e,a.length=e>0?u[e-1].stack:0},r.getLength=()=>u.length,r.toXml=()=>{let r="",n=0;return r+='<?xml version="1.0" encoding="utf-8"?>\n',r+=`<root nodes="${u.length/2}" characters="${i.length}">\n`,r+="\x3c!-- input string --\x3e\n",r+=l(n+2),r+=t.charsToString(i),r+="\n",u.forEach((s=>{s.state===e.SEM_PRE?(n+=1,r+=l(n),r+=`<node name="${s.name}" index="${s.phraseIndex}" length="${s.phraseLength}">\n`,r+=l(n+2),r+=t.charsToString(i,s.phraseIndex,s.phraseLength),r+="\n"):(r+=l(n),r+=`</node>\x3c!-- name="${s.name}" --\x3e\n`,n-=1)})),r+="</root>\n",r}},FI={stringToChars:e=>[...e].map((e=>e.codePointAt(0))),charsToString:(e,t,r)=>{let n=e;for(;!(void 0===t||t<0);){if(void 0===r){n=e.slice(t);break}if(r<=0)return"";n=e.slice(t,t+r);break}return String.fromCodePoint(...n)}},II={ALT:1,CAT:2,REP:3,RNM:4,TRG:5,TBS:6,TLS:7,UDT:11,AND:12,NOT:13,ACTIVE:100,MATCH:101,EMPTY:102,NOMATCH:103,SEM_PRE:200,SEM_POST:201,SEM_OK:300,idName:e=>{switch(e){case II.ALT:return"ALT";case II.CAT:return"CAT";case II.REP:return"REP";case II.RNM:return"RNM";case II.TRG:return"TRG";case II.TBS:return"TBS";case II.TLS:return"TLS";case II.UDT:return"UDT";case II.AND:return"AND";case II.NOT:return"NOT";case II.ACTIVE:return"ACTIVE";case II.EMPTY:return"EMPTY";case II.MATCH:return"MATCH";case II.NOMATCH:return"NOMATCH";case II.SEM_PRE:return"SEM_PRE";case II.SEM_POST:return"SEM_POST";case II.SEM_OK:return"SEM_OK";default:return"UNRECOGNIZED STATE"}}},RI=(e,t,r,n,s)=>{if(e===II.SEM_PRE){if(!1===Array.isArray(s))throw new Error("parser's user data must be an array");s.push(["server-url-template",FI.charsToString(t,r,n)])}return II.SEM_OK},DI=(e,t,r,n,s)=>{if(e===II.SEM_PRE){if(!1===Array.isArray(s))throw new Error("parser's user data must be an array");s.push(["server-variable",FI.charsToString(t,r,n)])}return II.SEM_OK},_I=(e,t,r,n,s)=>{if(e===II.SEM_PRE){if(!1===Array.isArray(s))throw new Error("parser's user data must be an array");s.push(["server-variable-name",FI.charsToString(t,r,n)])}return II.SEM_OK},CI=(e,t,r,n,s)=>{if(e===II.SEM_PRE){if(!1===Array.isArray(s))throw new Error("parser's user data must be an array");s.push(["literals",FI.charsToString(t,r,n)])}return II.SEM_OK},MI=new function(){this.grammarObject="grammarObject",this.rules=[],this.rules[0]={name:"server-url-template",lower:"server-url-template",index:0,isBkr:!1},this.rules[1]={name:"server-variable",lower:"server-variable",index:1,isBkr:!1},this.rules[2]={name:"server-variable-name",lower:"server-variable-name",index:2,isBkr:!1},this.rules[3]={name:"literals",lower:"literals",index:3,isBkr:!1},this.rules[4]={name:"ALPHA",lower:"alpha",index:4,isBkr:!1},this.rules[5]={name:"DIGIT",lower:"digit",index:5,isBkr:!1},this.rules[6]={name:"HEXDIG",lower:"hexdig",index:6,isBkr:!1},this.rules[7]={name:"pct-encoded",lower:"pct-encoded",index:7,isBkr:!1},this.rules[8]={name:"unreserved",lower:"unreserved",index:8,isBkr:!1},this.rules[9]={name:"sub-delims",lower:"sub-delims",index:9,isBkr:!1},this.rules[10]={name:"ucschar",lower:"ucschar",index:10,isBkr:!1},this.rules[11]={name:"iprivate",lower:"iprivate",index:11,isBkr:!1},this.udts=[],this.rules[0].opcodes=[],this.rules[0].opcodes[0]={type:3,min:1,max:1/0},this.rules[0].opcodes[1]={type:1,children:[2,3]},this.rules[0].opcodes[2]={type:4,index:3},this.rules[0].opcodes[3]={type:4,index:1},this.rules[1].opcodes=[],this.rules[1].opcodes[0]={type:2,children:[1,2,3]},this.rules[1].opcodes[1]={type:7,string:[123]},this.rules[1].opcodes[2]={type:4,index:2},this.rules[1].opcodes[3]={type:7,string:[125]},this.rules[2].opcodes=[],this.rules[2].opcodes[0]={type:3,min:1,max:1/0},this.rules[2].opcodes[1]={type:1,children:[2,3,4,5,6]},this.rules[2].opcodes[2]={type:4,index:8},this.rules[2].opcodes[3]={type:4,index:7},this.rules[2].opcodes[4]={type:4,index:9},this.rules[2].opcodes[5]={type:7,string:[58]},this.rules[2].opcodes[6]={type:7,string:[64]},this.rules[3].opcodes=[],this.rules[3].opcodes[0]={type:3,min:1,max:1/0},this.rules[3].opcodes[1]={type:1,children:[2,3,4,5,6,7,8,9,10,11,12,13,14]},this.rules[3].opcodes[2]={type:6,string:[33]},this.rules[3].opcodes[3]={type:5,min:35,max:36},this.rules[3].opcodes[4]={type:6,string:[38]},this.rules[3].opcodes[5]={type:5,min:40,max:59},this.rules[3].opcodes[6]={type:6,string:[61]},this.rules[3].opcodes[7]={type:5,min:63,max:91},this.rules[3].opcodes[8]={type:6,string:[93]},this.rules[3].opcodes[9]={type:6,string:[95]},this.rules[3].opcodes[10]={type:5,min:97,max:122},this.rules[3].opcodes[11]={type:6,string:[126]},this.rules[3].opcodes[12]={type:4,index:10},this.rules[3].opcodes[13]={type:4,index:11},this.rules[3].opcodes[14]={type:4,index:7},this.rules[4].opcodes=[],this.rules[4].opcodes[0]={type:1,children:[1,2]},this.rules[4].opcodes[1]={type:5,min:65,max:90},this.rules[4].opcodes[2]={type:5,min:97,max:122},this.rules[5].opcodes=[],this.rules[5].opcodes[0]={type:5,min:48,max:57},this.rules[6].opcodes=[],this.rules[6].opcodes[0]={type:1,children:[1,2,3,4,5,6,7]},this.rules[6].opcodes[1]={type:4,index:5},this.rules[6].opcodes[2]={type:7,string:[97]},this.rules[6].opcodes[3]={type:7,string:[98]},this.rules[6].opcodes[4]={type:7,string:[99]},this.rules[6].opcodes[5]={type:7,string:[100]},this.rules[6].opcodes[6]={type:7,string:[101]},this.rules[6].opcodes[7]={type:7,string:[102]},this.rules[7].opcodes=[],this.rules[7].opcodes[0]={type:2,children:[1,2,3]},this.rules[7].opcodes[1]={type:7,string:[37]},this.rules[7].opcodes[2]={type:4,index:6},this.rules[7].opcodes[3]={type:4,index:6},this.rules[8].opcodes=[],this.rules[8].opcodes[0]={type:1,children:[1,2,3,4,5,6]},this.rules[8].opcodes[1]={type:4,index:4},this.rules[8].opcodes[2]={type:4,index:5},this.rules[8].opcodes[3]={type:7,string:[45]},this.rules[8].opcodes[4]={type:7,string:[46]},this.rules[8].opcodes[5]={type:7,string:[95]},this.rules[8].opcodes[6]={type:7,string:[126]},this.rules[9].opcodes=[],this.rules[9].opcodes[0]={type:1,children:[1,2,3,4,5,6,7,8,9,10,11]},this.rules[9].opcodes[1]={type:7,string:[33]},this.rules[9].opcodes[2]={type:7,string:[36]},this.rules[9].opcodes[3]={type:7,string:[38]},this.rules[9].opcodes[4]={type:7,string:[39]},this.rules[9].opcodes[5]={type:7,string:[40]},this.rules[9].opcodes[6]={type:7,string:[41]},this.rules[9].opcodes[7]={type:7,string:[42]},this.rules[9].opcodes[8]={type:7,string:[43]},this.rules[9].opcodes[9]={type:7,string:[44]},this.rules[9].opcodes[10]={type:7,string:[59]},this.rules[9].opcodes[11]={type:7,string:[61]},this.rules[10].opcodes=[],this.rules[10].opcodes[0]={type:1,children:[1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17]},this.rules[10].opcodes[1]={type:5,min:160,max:55295},this.rules[10].opcodes[2]={type:5,min:63744,max:64975},this.rules[10].opcodes[3]={type:5,min:65008,max:65519},this.rules[10].opcodes[4]={type:5,min:65536,max:131069},this.rules[10].opcodes[5]={type:5,min:131072,max:196605},this.rules[10].opcodes[6]={type:5,min:196608,max:262141},this.rules[10].opcodes[7]={type:5,min:262144,max:327677},this.rules[10].opcodes[8]={type:5,min:327680,max:393213},this.rules[10].opcodes[9]={type:5,min:393216,max:458749},this.rules[10].opcodes[10]={type:5,min:458752,max:524285},this.rules[10].opcodes[11]={type:5,min:524288,max:589821},this.rules[10].opcodes[12]={type:5,min:589824,max:655357},this.rules[10].opcodes[13]={type:5,min:655360,max:720893},this.rules[10].opcodes[14]={type:5,min:720896,max:786429},this.rules[10].opcodes[15]={type:5,min:786432,max:851965},this.rules[10].opcodes[16]={type:5,min:851968,max:917501},this.rules[10].opcodes[17]={type:5,min:921600,max:983037},this.rules[11].opcodes=[],this.rules[11].opcodes[0]={type:1,children:[1,2,3]},this.rules[11].opcodes[1]={type:5,min:57344,max:63743},this.rules[11].opcodes[2]={type:5,min:983040,max:1048573},this.rules[11].opcodes[3]={type:5,min:1048576,max:1114109},this.toString=function(){let e="";return e+="; OpenAPI Server URL templating ABNF syntax\n",e+="server-url-template    = 1*( literals / server-variable )\n",e+='server-variable        = "{" server-variable-name "}"\n',e+='server-variable-name   = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" )\n',e+="literals               = 1*( %x21 / %x23-24 / %x26 / %x28-3B / %x3D / %x3F-5B\n",e+="                       / %x5D / %x5F / %x61-7A / %x7E / ucschar / iprivate\n",e+="                       / pct-encoded)\n",e+="                           ; any Unicode character except: CTL, SP,\n",e+='                           ;  DQUOTE, "\'", "%" (aside from pct-encoded),\n',e+='                           ;  "<", ">", "\\", "^", "`", "{", "|", "}"\n',e+="\n",e+="; Characters definitions (from RFC 6570)\n",e+="ALPHA          =  %x41-5A / %x61-7A   ; A-Z / a-z\n",e+="DIGIT          =  %x30-39             ; 0-9\n",e+='HEXDIG         =  DIGIT / "A" / "B" / "C" / "D" / "E" / "F"\n',e+="                 ; case-insensitive\n",e+="\n",e+='pct-encoded    =  "%" HEXDIG HEXDIG\n',e+='unreserved     =  ALPHA / DIGIT / "-" / "." / "_" / "~"\n',e+='sub-delims     =  "!" / "$" / "&" / "\'" / "(" / ")"\n',e+='               /  "*" / "+" / "," / ";" / "="\n',e+="\n",e+="ucschar        =  %xA0-D7FF / %xF900-FDCF / %xFDF0-FFEF\n",e+="               /  %x10000-1FFFD / %x20000-2FFFD / %x30000-3FFFD\n",e+="               /  %x40000-4FFFD / %x50000-5FFFD / %x60000-6FFFD\n",e+="               /  %x70000-7FFFD / %x80000-8FFFD / %x90000-9FFFD\n",e+="               /  %xA0000-AFFFD / %xB0000-BFFFD / %xC0000-CFFFD\n",e+="               /  %xD0000-DFFFD / %xE1000-EFFFD\n",e+="\n",e+="iprivate       =  %xE000-F8FF / %xF0000-FFFFD / %x100000-10FFFD\n",'; OpenAPI Server URL templating ABNF syntax\nserver-url-template    = 1*( literals / server-variable )\nserver-variable        = "{" server-variable-name "}"\nserver-variable-name   = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" )\nliterals               = 1*( %x21 / %x23-24 / %x26 / %x28-3B / %x3D / %x3F-5B\n                       / %x5D / %x5F / %x61-7A / %x7E / ucschar / iprivate\n                       / pct-encoded)\n                           ; any Unicode character except: CTL, SP,\n                           ;  DQUOTE, "\'", "%" (aside from pct-encoded),\n                           ;  "<", ">", "\\", "^", "`", "{", "|", "}"\n\n; Characters definitions (from RFC 6570)\nALPHA          =  %x41-5A / %x61-7A   ; A-Z / a-z\nDIGIT          =  %x30-39             ; 0-9\nHEXDIG         =  DIGIT / "A" / "B" / "C" / "D" / "E" / "F"\n                 ; case-insensitive\n\npct-encoded    =  "%" HEXDIG HEXDIG\nunreserved     =  ALPHA / DIGIT / "-" / "." / "_" / "~"\nsub-delims     =  "!" / "$" / "&" / "\'" / "(" / ")"\n               /  "*" / "+" / "," / ";" / "="\n\nucschar        =  %xA0-D7FF / %xF900-FDCF / %xFDF0-FFEF\n               /  %x10000-1FFFD / %x20000-2FFFD / %x30000-3FFFD\n               /  %x40000-4FFFD / %x50000-5FFFD / %x60000-6FFFD\n               /  %x70000-7FFFD / %x80000-8FFFD / %x90000-9FFFD\n               /  %xA0000-AFFFD / %xB0000-BFFFD / %xC0000-CFFFD\n               /  %xD0000-DFFFD / %xE1000-EFFFD\n\niprivate       =  %xE000-F8FF / %xF0000-FFFFD / %x100000-10FFFD\n'}},NI=e=>{const t=new TI;t.ast=new kI,t.ast.callbacks["server-url-template"]=RI,t.ast.callbacks["server-variable"]=DI,t.ast.callbacks["server-variable-name"]=_I,t.ast.callbacks.literals=CI;return{result:t.parse(MI,"server-url-template",e),ast:t.ast}},qI=e=>(e=>{try{return"string"==typeof e&&decodeURIComponent(e)!==e}catch{return!1}})(e)?e:encodeURIComponent(e).replace(/%5B/g,"[").replace(/%5D/g,"]"),BI=["literals","server-variable-name"];const LI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["slash",FI.charsToString(t,r,n)]),II.SEM_OK),UI=(e,t,r,n,s)=>{if(e===II.SEM_PRE){if(!1===Array.isArray(s))throw new Error("parser's user data must be an array");s.push(["path-template",FI.charsToString(t,r,n)])}return II.SEM_OK},JI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["path",FI.charsToString(t,r,n)]),II.SEM_OK),VI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["path-literal",FI.charsToString(t,r,n)]),II.SEM_OK),GI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["query",FI.charsToString(t,r,n)]),II.SEM_OK),HI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["query-marker",FI.charsToString(t,r,n)]),II.SEM_OK),zI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["fragment",FI.charsToString(t,r,n)]),II.SEM_OK),XI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["fragment-marker",FI.charsToString(t,r,n)]),II.SEM_OK),WI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["template-expression",FI.charsToString(t,r,n)]),II.SEM_OK),YI=(e,t,r,n,s)=>(e===II.SEM_PRE&&s.push(["template-expression-param-name",FI.charsToString(t,r,n)]),II.SEM_OK),ZI=new function(){this.grammarObject="grammarObject",this.rules=[],this.rules[0]={name:"path-template",lower:"path-template",index:0,isBkr:!1},this.rules[1]={name:"path",lower:"path",index:1,isBkr:!1},this.rules[2]={name:"path-segment",lower:"path-segment",index:2,isBkr:!1},this.rules[3]={name:"query",lower:"query",index:3,isBkr:!1},this.rules[4]={name:"query-literal",lower:"query-literal",index:4,isBkr:!1},this.rules[5]={name:"query-marker",lower:"query-marker",index:5,isBkr:!1},this.rules[6]={name:"fragment",lower:"fragment",index:6,isBkr:!1},this.rules[7]={name:"fragment-literal",lower:"fragment-literal",index:7,isBkr:!1},this.rules[8]={name:"fragment-marker",lower:"fragment-marker",index:8,isBkr:!1},this.rules[9]={name:"slash",lower:"slash",index:9,isBkr:!1},this.rules[10]={name:"path-literal",lower:"path-literal",index:10,isBkr:!1},this.rules[11]={name:"template-expression",lower:"template-expression",index:11,isBkr:!1},this.rules[12]={name:"template-expression-param-name",lower:"template-expression-param-name",index:12,isBkr:!1},this.rules[13]={name:"unreserved",lower:"unreserved",index:13,isBkr:!1},this.rules[14]={name:"pct-encoded",lower:"pct-encoded",index:14,isBkr:!1},this.rules[15]={name:"sub-delims",lower:"sub-delims",index:15,isBkr:!1},this.rules[16]={name:"ALPHA",lower:"alpha",index:16,isBkr:!1},this.rules[17]={name:"DIGIT",lower:"digit",index:17,isBkr:!1},this.rules[18]={name:"HEXDIG",lower:"hexdig",index:18,isBkr:!1},this.udts=[],this.rules[0].opcodes=[],this.rules[0].opcodes[0]={type:2,children:[1,2,6]},this.rules[0].opcodes[1]={type:4,index:1},this.rules[0].opcodes[2]={type:3,min:0,max:1},this.rules[0].opcodes[3]={type:2,children:[4,5]},this.rules[0].opcodes[4]={type:4,index:5},this.rules[0].opcodes[5]={type:4,index:3},this.rules[0].opcodes[6]={type:3,min:0,max:1},this.rules[0].opcodes[7]={type:2,children:[8,9]},this.rules[0].opcodes[8]={type:4,index:8},this.rules[0].opcodes[9]={type:4,index:6},this.rules[1].opcodes=[],this.rules[1].opcodes[0]={type:2,children:[1,2,6]},this.rules[1].opcodes[1]={type:4,index:9},this.rules[1].opcodes[2]={type:3,min:0,max:1/0},this.rules[1].opcodes[3]={type:2,children:[4,5]},this.rules[1].opcodes[4]={type:4,index:2},this.rules[1].opcodes[5]={type:4,index:9},this.rules[1].opcodes[6]={type:3,min:0,max:1},this.rules[1].opcodes[7]={type:4,index:2},this.rules[2].opcodes=[],this.rules[2].opcodes[0]={type:3,min:1,max:1/0},this.rules[2].opcodes[1]={type:1,children:[2,3]},this.rules[2].opcodes[2]={type:4,index:10},this.rules[2].opcodes[3]={type:4,index:11},this.rules[3].opcodes=[],this.rules[3].opcodes[0]={type:3,min:0,max:1/0},this.rules[3].opcodes[1]={type:4,index:4},this.rules[4].opcodes=[],this.rules[4].opcodes[0]={type:3,min:1,max:1/0},this.rules[4].opcodes[1]={type:1,children:[2,3,4,5,6,7,8,9,10]},this.rules[4].opcodes[2]={type:4,index:13},this.rules[4].opcodes[3]={type:4,index:14},this.rules[4].opcodes[4]={type:4,index:15},this.rules[4].opcodes[5]={type:7,string:[58]},this.rules[4].opcodes[6]={type:7,string:[64]},this.rules[4].opcodes[7]={type:7,string:[47]},this.rules[4].opcodes[8]={type:7,string:[63]},this.rules[4].opcodes[9]={type:7,string:[38]},this.rules[4].opcodes[10]={type:7,string:[61]},this.rules[5].opcodes=[],this.rules[5].opcodes[0]={type:7,string:[63]},this.rules[6].opcodes=[],this.rules[6].opcodes[0]={type:3,min:0,max:1/0},this.rules[6].opcodes[1]={type:4,index:7},this.rules[7].opcodes=[],this.rules[7].opcodes[0]={type:3,min:1,max:1/0},this.rules[7].opcodes[1]={type:1,children:[2,3,4,5,6,7,8]},this.rules[7].opcodes[2]={type:4,index:13},this.rules[7].opcodes[3]={type:4,index:14},this.rules[7].opcodes[4]={type:4,index:15},this.rules[7].opcodes[5]={type:7,string:[58]},this.rules[7].opcodes[6]={type:7,string:[64]},this.rules[7].opcodes[7]={type:7,string:[47]},this.rules[7].opcodes[8]={type:7,string:[63]},this.rules[8].opcodes=[],this.rules[8].opcodes[0]={type:7,string:[35]},this.rules[9].opcodes=[],this.rules[9].opcodes[0]={type:7,string:[47]},this.rules[10].opcodes=[],this.rules[10].opcodes[0]={type:3,min:1,max:1/0},this.rules[10].opcodes[1]={type:1,children:[2,3,4,5,6]},this.rules[10].opcodes[2]={type:4,index:13},this.rules[10].opcodes[3]={type:4,index:14},this.rules[10].opcodes[4]={type:4,index:15},this.rules[10].opcodes[5]={type:7,string:[58]},this.rules[10].opcodes[6]={type:7,string:[64]},this.rules[11].opcodes=[],this.rules[11].opcodes[0]={type:2,children:[1,2,3]},this.rules[11].opcodes[1]={type:7,string:[123]},this.rules[11].opcodes[2]={type:4,index:12},this.rules[11].opcodes[3]={type:7,string:[125]},this.rules[12].opcodes=[],this.rules[12].opcodes[0]={type:3,min:1,max:1/0},this.rules[12].opcodes[1]={type:1,children:[2,3,4,5,6]},this.rules[12].opcodes[2]={type:4,index:13},this.rules[12].opcodes[3]={type:4,index:14},this.rules[12].opcodes[4]={type:4,index:15},this.rules[12].opcodes[5]={type:7,string:[58]},this.rules[12].opcodes[6]={type:7,string:[64]},this.rules[13].opcodes=[],this.rules[13].opcodes[0]={type:1,children:[1,2,3,4,5,6]},this.rules[13].opcodes[1]={type:4,index:16},this.rules[13].opcodes[2]={type:4,index:17},this.rules[13].opcodes[3]={type:7,string:[45]},this.rules[13].opcodes[4]={type:7,string:[46]},this.rules[13].opcodes[5]={type:7,string:[95]},this.rules[13].opcodes[6]={type:7,string:[126]},this.rules[14].opcodes=[],this.rules[14].opcodes[0]={type:2,children:[1,2,3]},this.rules[14].opcodes[1]={type:7,string:[37]},this.rules[14].opcodes[2]={type:4,index:18},this.rules[14].opcodes[3]={type:4,index:18},this.rules[15].opcodes=[],this.rules[15].opcodes[0]={type:1,children:[1,2,3,4,5,6,7,8,9,10,11]},this.rules[15].opcodes[1]={type:7,string:[33]},this.rules[15].opcodes[2]={type:7,string:[36]},this.rules[15].opcodes[3]={type:7,string:[38]},this.rules[15].opcodes[4]={type:7,string:[39]},this.rules[15].opcodes[5]={type:7,string:[40]},this.rules[15].opcodes[6]={type:7,string:[41]},this.rules[15].opcodes[7]={type:7,string:[42]},this.rules[15].opcodes[8]={type:7,string:[43]},this.rules[15].opcodes[9]={type:7,string:[44]},this.rules[15].opcodes[10]={type:7,string:[59]},this.rules[15].opcodes[11]={type:7,string:[61]},this.rules[16].opcodes=[],this.rules[16].opcodes[0]={type:1,children:[1,2]},this.rules[16].opcodes[1]={type:5,min:65,max:90},this.rules[16].opcodes[2]={type:5,min:97,max:122},this.rules[17].opcodes=[],this.rules[17].opcodes[0]={type:5,min:48,max:57},this.rules[18].opcodes=[],this.rules[18].opcodes[0]={type:1,children:[1,2,3,4,5,6,7]},this.rules[18].opcodes[1]={type:4,index:17},this.rules[18].opcodes[2]={type:7,string:[97]},this.rules[18].opcodes[3]={type:7,string:[98]},this.rules[18].opcodes[4]={type:7,string:[99]},this.rules[18].opcodes[5]={type:7,string:[100]},this.rules[18].opcodes[6]={type:7,string:[101]},this.rules[18].opcodes[7]={type:7,string:[102]},this.toString=function(){let e="";return e+="; OpenAPI Path Templating ABNF syntax\n",e+="path-template                  = path [ query-marker query ] [ fragment-marker fragment ]\n",e+="path                           = slash *( path-segment slash ) [ path-segment ]\n",e+="path-segment                   = 1*( path-literal / template-expression )\n",e+="query                          = *( query-literal )\n",e+='query-literal                  = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" / "/" / "?" / "&" / "=" )\n',e+='query-marker                   = "?"\n',e+="fragment                       = *( fragment-literal )\n",e+='fragment-literal               = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" / "/" / "?" )\n',e+='fragment-marker                = "#"\n',e+='slash                          = "/"\n',e+='path-literal                   = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" )\n',e+='template-expression            = "{" template-expression-param-name "}"\n',e+='template-expression-param-name = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" )\n',e+="\n",e+="; Characters definitions (from RFC 3986)\n",e+='unreserved          = ALPHA / DIGIT / "-" / "." / "_" / "~"\n',e+='pct-encoded         = "%" HEXDIG HEXDIG\n',e+='sub-delims          = "!" / "$" / "&" / "\'" / "(" / ")"\n',e+='                    / "*" / "+" / "," / ";" / "="\n',e+="ALPHA               = %x41-5A / %x61-7A   ; A-Z / a-z\n",e+="DIGIT               = %x30-39            ; 0-9\n",e+='HEXDIG              = DIGIT / "A" / "B" / "C" / "D" / "E" / "F"\n','; OpenAPI Path Templating ABNF syntax\npath-template                  = path [ query-marker query ] [ fragment-marker fragment ]\npath                           = slash *( path-segment slash ) [ path-segment ]\npath-segment                   = 1*( path-literal / template-expression )\nquery                          = *( query-literal )\nquery-literal                  = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" / "/" / "?" / "&" / "=" )\nquery-marker                   = "?"\nfragment                       = *( fragment-literal )\nfragment-literal               = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" / "/" / "?" )\nfragment-marker                = "#"\nslash                          = "/"\npath-literal                   = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" )\ntemplate-expression            = "{" template-expression-param-name "}"\ntemplate-expression-param-name = 1*( unreserved / pct-encoded / sub-delims / ":" / "@" )\n\n; Characters definitions (from RFC 3986)\nunreserved          = ALPHA / DIGIT / "-" / "." / "_" / "~"\npct-encoded         = "%" HEXDIG HEXDIG\nsub-delims          = "!" / "$" / "&" / "\'" / "(" / ")"\n                    / "*" / "+" / "," / ";" / "="\nALPHA               = %x41-5A / %x61-7A   ; A-Z / a-z\nDIGIT               = %x30-39            ; 0-9\nHEXDIG              = DIGIT / "A" / "B" / "C" / "D" / "E" / "F"\n'}},KI=e=>{const t=new TI;t.ast=new kI,t.ast.callbacks["path-template"]=UI,t.ast.callbacks.path=JI,t.ast.callbacks.query=GI,t.ast.callbacks["query-marker"]=HI,t.ast.callbacks.fragment=zI,t.ast.callbacks["fragment-marker"]=XI,t.ast.callbacks.slash=LI,t.ast.callbacks["path-literal"]=VI,t.ast.callbacks["template-expression"]=WI,t.ast.callbacks["template-expression-param-name"]=YI;return{result:t.parse(ZI,"path-template",e),ast:t.ast}},QI=e=>(e=>{try{return"string"==typeof e&&decodeURIComponent(e)!==e}catch{return!1}})(e)?e:encodeURIComponent(e).replace(/%5B/g,"[").replace(/%5D/g,"]"),eR=["slash","path-literal","query-marker","query-literal","template-expression-param-name"],tR=(e,t,r={})=>{const n={...{encoder:QI},...r},s=KI(e);if(!s.result.success)return e;const i=[];s.ast.translate(i);const o=i.filter((([e])=>eR.includes(e))).map((([e,r])=>"template-expression-param-name"===e?Object.hasOwn(t,r)?n.encoder(t[r],r):`{${r}}`:r));return o.join("")},rR={body:function({req:e,value:t}){void 0!==t&&(e.body=t)},header:function({req:e,parameter:t,value:r}){e.headers=e.headers||{},void 0!==r&&(e.headers[t.name]=r)},query:function({req:e,value:t,parameter:r}){e.query=e.query||{},!1===t&&"boolean"===r.type&&(t="false");0===t&&["number","integer"].indexOf(r.type)>-1&&(t="0");if(t)e.query[r.name]={collectionFormat:r.collectionFormat,value:t};else if(r.allowEmptyValue&&void 0!==t){const t=r.name;e.query[t]=e.query[t]||{},e.query[t].allowEmptyValue=!0}},path:function({req:e,value:t,parameter:r,baseURL:n}){if(void 0!==t){const s=e.url.replace(n,""),i=tR(s,{[r.name]:t});e.url=n+i}},formData:function({req:e,value:t,parameter:r}){!1===t&&"boolean"===r.type&&(t="false");0===t&&["number","integer"].indexOf(r.type)>-1&&(t="0");if(t)e.form=e.form||{},e.form[r.name]={collectionFormat:r.collectionFormat,value:t};else if(r.allowEmptyValue&&void 0!==t){e.form=e.form||{};const t=r.name;e.form[t]=e.form[t]||{},e.form[t].allowEmptyValue=!0}}};function nR(e,t){return t.includes("application/json")?"string"==typeof e?e:(Array.isArray(e)&&(e=e.map((e=>{try{return JSON.parse(e)}catch(t){return e}}))),JSON.stringify(e)):String(e)}const sR=["accept","authorization","content-type"];const iR=Object.freeze(Object.defineProperty({__proto__:null,cookie:function({req:e,parameter:t,value:r}){e.headers=e.headers||{};const n=typeof r;if(void 0!==r&&t.content){const n=Object.keys(t.content)[0];e.headers.Cookie=`${t.name}=${nR(r,n)}`}else if(void 0!==r&&(!Array.isArray(r)||0!==r.length)){const s="object"===n&&!Array.isArray(r)&&t.explode?"":`${t.name}=`;e.headers.Cookie=s+openapi_parser_f({key:t.name,value:r,escape:!1,style:t.style||"form",explode:void 0!==t.explode&&t.explode})}},header:function({req:e,parameter:t,value:r}){if(e.headers=e.headers||{},!(sR.indexOf(t.name.toLowerCase())>-1))if(void 0!==r&&t.content){const n=Object.keys(t.content)[0];e.headers[t.name]=nR(r,n)}else void 0===r||Array.isArray(r)&&0===r.length||(e.headers[t.name]=openapi_parser_f({key:t.name,value:r,style:t.style||"simple",explode:void 0!==t.explode&&t.explode,escape:!1}))},path:function({req:e,value:t,parameter:r,baseURL:n}){const{name:s,style:i,explode:o,content:c}=r;if(void 0===t)return;const a=e.url.replace(n,"");let u;if(c){const e=Object.keys(c)[0];u=tR(a,{[s]:t},{encoder:t=>openapi_parser_h(nR(t,e))})}else u=tR(a,{[s]:t},{encoder:e=>openapi_parser_f({key:r.name,value:e,style:i||"simple",explode:o||!1,escape:"reserved"})});e.url=n+u},query:function({req:e,value:t,parameter:r}){if(e.query=e.query||{},void 0!==t&&r.content){const n=nR(t,Object.keys(r.content)[0]);if(n)e.query[r.name]=n;else if(r.allowEmptyValue){const t=r.name;e.query[t]=e.query[t]||{},e.query[t].allowEmptyValue=!0}}else if(!1===t&&(t="false"),0===t&&(t="0"),t){const{style:n,explode:s,allowReserved:i}=r;e.query[r.name]={value:t,serializationOption:{style:n,explode:s,allowReserved:i}}}else if(r.allowEmptyValue&&void 0!==t){const t=r.name;e.query[t]=e.query[t]||{},e.query[t].allowEmptyValue=!0}}},Symbol.toStringTag,{value:"Module"})),oR="undefined"!=typeof globalThis?globalThis:"undefined"!=typeof self?self:window,{btoa:cR}=oR;function aR(e,t){const{operation:r,requestBody:n,securities:s,spec:i,attachContentTypeForEmptyPayload:o}=e;let{requestContentType:c}=e;t=function({request:e,securities:t={},operation:r={},spec:n}){var s;const i={...e},{authorized:o={}}=t,c=r.security||n.security||[],a=o&&!!Object.keys(o).length,u=(null==n||null===(s=n.components)||void 0===s?void 0:s.securitySchemes)||{};if(i.headers=i.headers||{},i.query=i.query||{},!Object.keys(t).length||!a||!c||Array.isArray(r.security)&&!r.security.length)return e;return c.forEach((e=>{Object.keys(e).forEach((e=>{const t=o[e],r=u[e];if(!t)return;const n=t.value||t,{type:s}=r;if(t)if("apiKey"===s)"query"===r.in&&(i.query[r.name]=n),"header"===r.in&&(i.headers[r.name]=n),"cookie"===r.in&&(i.cookies[r.name]=n);else if("http"===s){if(/^basic$/i.test(r.scheme)){const e=n.username||"",t=n.password||"",r=cR(`${e}:${t}`);i.headers.Authorization=`Basic ${r}`}/^bearer$/i.test(r.scheme)&&(i.headers.Authorization=`Bearer ${n}`)}else if("oauth2"===s||"openIdConnect"===s){const e=t.token||{},n=e[r["x-tokenName"]||"access_token"];let s=e.token_type;s&&"bearer"!==s.toLowerCase()||(s="Bearer"),i.headers.Authorization=`${s} ${n}`}}))})),i}({request:t,securities:s,operation:r,spec:i});const a=r.requestBody||{},u=Object.keys(a.content||{}),l=c&&u.indexOf(c)>-1;if(n||o){if(c&&l)t.headers["Content-Type"]=c;else if(!c){const e=u[0];e&&(t.headers["Content-Type"]=e,c=e)}}else c&&l&&(t.headers["Content-Type"]=c);if(!e.responseContentType&&r.responses){const e=Object.entries(r.responses).filter((([e,t])=>{const r=parseInt(e,10);return r>=200&&r<300&&em(t.content)})).reduce(((e,[,t])=>e.concat(Object.keys(t.content))),[]);e.length>0&&(t.headers.accept=e.join(", "))}if(n)if(c){if(u.indexOf(c)>-1)if("application/x-www-form-urlencoded"===c||"multipart/form-data"===c)if("object"==typeof n){var h,f;const e=null!==(h=null===(f=a.content[c])||void 0===f?void 0:f.encoding)&&void 0!==h?h:{};t.form={},Object.keys(n).forEach((r=>{let s;try{s=JSON.parse(n[r])}catch{s=n[r]}t.form[r]={value:s,encoding:e[r]||{}}}))}else if("string"==typeof n){var p,d;const e=null!==(p=null===(d=a.content[c])||void 0===d?void 0:d.encoding)&&void 0!==p?p:{};try{t.form={};const r=JSON.parse(n);Object.entries(r).forEach((([r,n])=>{t.form[r]={value:n,encoding:e[r]||{}}}))}catch{t.form=n}}else t.form=n;else t.body=n}else t.body=n;return t}function uR(e,t){const{spec:r,operation:n,securities:s,requestContentType:i,responseContentType:o,attachContentTypeForEmptyPayload:c}=e;if(t=function({request:e,securities:t={},operation:r={},spec:n}){const s={...e},{authorized:i={},specSecurity:o=[]}=t,c=r.security||o,a=i&&!!Object.keys(i).length,u=n.securityDefinitions;if(s.headers=s.headers||{},s.query=s.query||{},!Object.keys(t).length||!a||!c||Array.isArray(r.security)&&!r.security.length)return e;return c.forEach((e=>{Object.keys(e).forEach((e=>{const t=i[e];if(!t)return;const{token:r}=t,n=t.value||t,o=u[e],{type:c}=o,a=o["x-tokenName"]||"access_token",l=r&&r[a];let h=r&&r.token_type;if(t)if("apiKey"===c){const e="query"===o.in?"query":"headers";s[e]=s[e]||{},s[e][o.name]=n}else if("basic"===c)if(n.header)s.headers.authorization=n.header;else{const e=n.username||"",t=n.password||"";n.base64=cR(`${e}:${t}`),s.headers.authorization=`Basic ${n.base64}`}else"oauth2"===c&&l&&(h=h&&"bearer"!==h.toLowerCase()?h:"Bearer",s.headers.authorization=`${h} ${l}`)}))})),s}({request:t,securities:s,operation:n,spec:r}),t.body||t.form||c)i?t.headers["Content-Type"]=i:Array.isArray(n.consumes)?[t.headers["Content-Type"]]=n.consumes:Array.isArray(r.consumes)?[t.headers["Content-Type"]]=r.consumes:n.parameters&&n.parameters.filter((e=>"file"===e.type)).length?t.headers["Content-Type"]="multipart/form-data":n.parameters&&n.parameters.filter((e=>"formData"===e.in)).length&&(t.headers["Content-Type"]="application/x-www-form-urlencoded");else if(i){const e=n.parameters&&n.parameters.filter((e=>"body"===e.in)).length>0,r=n.parameters&&n.parameters.filter((e=>"formData"===e.in)).length>0;(e||r)&&(t.headers["Content-Type"]=i)}return!o&&Array.isArray(n.produces)&&n.produces.length>0&&(t.headers.accept=n.produces.join(", ")),t}const lR=e=>Array.isArray(e)?e:[],hR=e=>{try{return new URL(e)}catch{const t=new URL(e,"https://swagger.io"),r=String(e).startsWith("/")?t.pathname:t.pathname.substring(1);return{hash:t.hash,host:"",hostname:"",href:"",origin:"",password:"",pathname:r,port:"",protocol:"",search:t.search,searchParams:t.searchParams}}};class fR extends Ih{}const pR={buildRequest:dR};function dR(e){const{spec:t,operationId:r,responseContentType:n,scheme:s,requestInterceptor:i,responseInterceptor:o,contextUrl:c,userFetch:a,server:u,serverVariables:l,http:h,signal:f,serverVariableEncoder:p}=e;let{parameters:d,parameterBuilders:m}=e;const v=J$(t);m||(m=v?iR:rR);let y={url:"",credentials:h&&h.withCredentials?"include":"same-origin",headers:{},cookies:{}};f&&(y.signal=f),i&&(y.requestInterceptor=i),o&&(y.responseInterceptor=o),a&&(y.userFetch=a);const b=gI(t,r);if(!b)throw new fR(`Operation ${r} not found`);const{operation:w={},method:x,pathName:j}=b,E=vR({spec:t,scheme:s,contextUrl:c,server:u,serverVariables:l,pathName:j,method:x,serverVariableEncoder:p});if(y.url+=E,!r)return delete y.cookies,y;y.url+=j,y.method=`${x}`.toUpperCase(),d=d||{};const $=t.paths[j]||{};n&&(y.headers.accept=n);const O=(e=>{const t={};e.forEach((e=>{t[e.in]||(t[e.in]={}),t[e.in][e.name]=e}));const r=[];return Object.keys(t).forEach((e=>{Object.keys(t[e]).forEach((n=>{r.push(t[e][n])}))})),r})([].concat(lR(w.parameters)).concat(lR($.parameters)));O.forEach((e=>{const r=m[e.in];let n;if("body"===e.in&&e.schema&&e.schema.properties&&(n=d),n=e&&e.name&&d[e.name],void 0===n?n=e&&e.name&&d[`${e.in}.${e.name}`]:((e,t)=>t.filter((t=>t.name===e)))(e.name,O).length>1&&console.warn(`Parameter '${e.name}' is ambiguous because the defined spec has more than one parameter with the name: '${e.name}' and the passed-in parameter values did not define an 'in' value.`),null!==n){if(void 0!==e.default&&void 0===n&&(n=e.default),void 0===n&&e.required&&!e.allowEmptyValue)throw new Error(`Required parameter ${e.name} is not provided`);if(v&&e.schema&&"object"===e.schema.type&&"string"==typeof n)try{n=JSON.parse(n)}catch(e){throw new Error("Could not parse object parameter value string as JSON")}r&&r({req:y,parameter:e,value:n,operation:w,spec:t,baseURL:E})}}));const S={...e,operation:w};if(y=v?aR(S,y):uR(S,y),y.cookies&&Object.keys(y.cookies).length){const e=Object.keys(y.cookies).reduce(((e,t)=>{const r=y.cookies[t];return e+(e?"&":"")+EI.serialize(t,r)}),"");y.headers.Cookie=e}return y.cookies&&delete y.cookies,openapi_parser_g(y)}const mR=e=>e?e.replace(/\W/g,""):null;function vR(t){return J$(t.spec)?function({spec:t,pathName:r,method:n,server:s,contextUrl:i,serverVariables:o={},serverVariableEncoder:c}){var a,u;let l,h=[],f="";const p=null==t||null===(a=t.paths)||void 0===a||null===(a=a[r])||void 0===a||null===(a=a[(n||"").toLowerCase()])||void 0===a?void 0:a.servers,d=null==t||null===(u=t.paths)||void 0===u||null===(u=u[r])||void 0===u?void 0:u.servers,m=null==t?void 0:t.servers;h=yR(p)?p:yR(d)?d:yR(m)?m:[openapi_parser_e],s&&(l=h.find((e=>e.url===s)),l&&(f=s));f||([l]=h,f=l.url);if(((e,{strict:t=!1}={})=>{try{const r=NI(e);if(!r.result.success)return!1;const n=[];r.ast.translate(n);const s=n.some((([e])=>"server-variable"===e));if(!t&&!s)try{return new URL(e,"https://vladimirgorej.com"),!0}catch{return!1}return!t||s}catch{return!1}})(f,{strict:!0})){const e=Object.entries({...l.variables}).reduce(((e,[t,r])=>(e[t]=r.default,e)),{});f=((e,t,r={})=>{const n={encoder:qI,...r},s=NI(e);if(!s.result.success)return e;const i=[];s.ast.translate(i);const o=i.filter((([e])=>BI.includes(e))).map((([e,r])=>"server-variable-name"===e?Object.hasOwn(t,r)?n.encoder(t[r],r):`{${r}}`:r));return o.join("")})(f,{...e,...o},{encoder:"function"==typeof c?c:jp})}return function(e="",t=""){const r=hR(e&&t?Xm(t,e):e),n=hR(t),s=mR(r.protocol)||mR(n.protocol),i=r.host||n.host,o=r.pathname;let c;c=s&&i?`${s}://${i+o}`:o;return"/"===c[c.length-1]?c.slice(0,-1):c}(f,i)}(t):function({spec:e,scheme:t,contextUrl:r=""}){const n=hR(r),s=Array.isArray(e.schemes)?e.schemes[0]:null,i=t||s||mR(n.protocol)||"http",o=e.host||n.host||"",c=e.basePath||"";let a;a=i&&o?`${i}://${o+c}`:c;return"/"===a[a.length-1]?a.slice(0,-1):a}(t)}const yR=e=>Array.isArray(e)&&e.length>0;function bR(e,t={}){if("string"==typeof e?t.url=e:t=e,!(this instanceof bR))return new bR(t);Object.assign(this,t);const r=this.resolve().then((()=>(this.disableInterfaces||Object.assign(this,bR.makeApisTagOperation(this)),this)));return r.client=this,r}bR.http=_t,bR.makeHttp=function(e,t,r){return r=r||(e=>e),t=t||(e=>e),n=>("string"==typeof n&&(n={url:n}),n=openapi_parser_g(n),n=t(n),r(e(n)))}.bind(null,bR.http),bR.resolveStrategies={"openapi-3-1-apidom":vI,"openapi-3-0":G$,"openapi-2-0":V$,generic:q$},bR.resolve=H$({strategies:[bR.resolveStrategies["openapi-3-1-apidom"],bR.resolveStrategies["openapi-3-0"],bR.resolveStrategies["openapi-2-0"],bR.resolveStrategies.generic]}),bR.resolveSubtree=(e=>async(t,r,n={})=>(async(e,t,r={})=>{const{returnEntireTree:n,baseDoc:s,requestInterceptor:i,responseInterceptor:o,parameterMacro:c,modelPropertyMacro:a,useCircularStructures:u,strategies:l}=r,h={spec:e,pathDiscriminator:t,baseDoc:s,requestInterceptor:i,responseInterceptor:o,parameterMacro:c,modelPropertyMacro:a,useCircularStructures:u,strategies:l},f=l.find((t=>t.match(e))).normalize(e),p=await z$({spec:f,...h,allowMetaPatches:!0,skipNormalization:!U$(e)});return!n&&Array.isArray(t)&&t.length&&(p.spec=t.reduce(((e,t)=>null==e?void 0:e[t]),p.spec)||null),p})(t,r,{...e,...n}))({strategies:[bR.resolveStrategies["openapi-3-1-apidom"],bR.resolveStrategies["openapi-3-0"],bR.resolveStrategies["openapi-2-0"],bR.resolveStrategies.generic]}),bR.execute=function({http:e,fetch:t,spec:r,operationId:n,pathName:s,method:i,parameters:o,securities:c,...a}){const u=e||t||_t;s&&i&&!n&&(n=bI(s,i));const l=pR.buildRequest({spec:r,operationId:n,parameters:o,securities:c,http:u,...a});return l.body&&(em(l.body)||Array.isArray(l.body))&&(l.body=JSON.stringify(l.body)),u(l)},bR.serializeRes=Dt,bR.serializeHeaders=Rt,bR.clearCache=function(){D$.refs.clearCache()},bR.makeApisTagOperation=function(e={}){const t=jI.makeExecute(e);return{apis:jI.mapTagOperations({v2OperationIdCompatibilityMode:e.v2OperationIdCompatibilityMode,spec:e.spec,cb:t})}},bR.buildRequest=dR,bR.helpers={opId:M$},bR.getBaseUrl=vR,bR.apidom={resolve:{resolvers:{HTTPResolverSwaggerClient:_F}},parse:{parsers:{JsonParser:CF,YamlParser:MF,OpenApiJson3_1Parser:NF,OpenApiYaml3_1Parser:qF}},dereference:{strategies:{OpenApi3_1SwaggerClientDereferenceStrategy:fI}}},bR.prototype={http:_t,execute(e){return this.applyDefaults(),bR.execute({spec:this.spec,http:this.http,securities:{authorized:this.authorizations},contextUrl:"string"==typeof this.url?this.url:void 0,requestInterceptor:this.requestInterceptor||null,responseInterceptor:this.responseInterceptor||null,...e})},resolve(e={}){return bR.resolve({spec:this.spec,url:this.url,http:this.http||this.fetch,allowMetaPatches:this.allowMetaPatches,useCircularStructures:this.useCircularStructures,requestInterceptor:this.requestInterceptor||null,responseInterceptor:this.responseInterceptor||null,skipNormalization:this.skipNormalization||!1,...e}).then((e=>(this.originalSpec=this.spec,this.spec=e.spec,this.errors=e.errors,this)))}},bR.prototype.applyDefaults=function(){const{spec:t}=this,r=this.url;if(B$(t)&&wI(r)){const e=new URL(r);t.host||(t.host=e.host),t.schemes||(t.schemes=[e.protocol.replace(":","")]),t.basePath||(t.basePath="/")}else if(J$(t)){const r=Array.isArray(t.servers)&&0===t.servers.length;t.servers&&!r||(t.servers=[openapi_parser_e])}};function gR(e){const t=(e=e.replace("[]","Array")).split("/");return t[0]=t[0].replace(/[^A-Za-z0-9_\-\.]+|\s+/gm,"_"),t.join("/")}const wR={parameterTypeProperties:["format","minimum","maximum","exclusiveMinimum","exclusiveMaximum","minLength","maxLength","multipleOf","minItems","maxItems","uniqueItems","minProperties","maxProperties","additionalProperties","pattern","enum","default"],arrayProperties:["items","minItems","maxItems","uniqueItems"],httpMethods:["get","post","put","delete","patch","head","options","trace"],uniqueOnly:function(e,t,r){return r.indexOf(e)===t},createHash:function(e){let t,r=0;if(0===e.length)return r;for(let n=0;n<e.length;n++)t=e.charCodeAt(n),r=(r<<5)-r+t,r|=0;return r},sanitise:gR,sanitiseAll:function(e){return gR(e.split("/").join("_"))},camelize:function(e){return e.toLowerCase().replace(/[-_ \/\.](.)/g,((e,t)=>t.toUpperCase()))},clone:function(e){return JSON.parse(JSON.stringify(e))},circularClone:function e(t,r=null){if(r||(r=new WeakMap),Object(t)!==t||t instanceof Function)return t;if(r.has(t))return r.get(t);let n;try{n=new t.constructor}catch(e){n=Object.create(Object.getPrototypeOf(t))}return r.set(t,n),Object.assign(n,...Object.keys(t).map((n=>({[n]:e(t[n],r)}))))}};function xR(){return{depth:0,seen:new WeakMap,top:!0,combine:!1,allowRefSiblings:!1}}const jR={getDefaultState:xR,walkSchema:function e(t,r,n,s){if(void 0===n.depth&&(n=xR()),null==t)return t;if(n.combine&&(t.allOf&&Array.isArray(t.allOf)&&1===t.allOf.length&&delete(t={...t.allOf[0],...t})?.allOf,t?.anyOf&&Array.isArray(t.anyOf)&&1===t.anyOf.length&&delete(t={...t.anyOf[0],...t})?.anyOf,t?.oneOf&&Array.isArray(t.oneOf)&&1===t.oneOf.length&&delete(t={...t.oneOf[0],...t})?.oneOf),s(t,r,n),n.seen.has(t))return t;if("object"==typeof t&&null!==t&&n.seen.set(t,!0),n.top=!1,n.depth++,void 0!==t?.items&&(n.property="items",e(t.items,t,n,s)),t?.additionalItems&&"object"==typeof t.additionalItems&&(n.property="additionalItems",e(t.additionalItems,t,n,s)),t?.additionalProperties&&"object"==typeof t.additionalProperties&&(n.property="additionalProperties",e(t.additionalProperties,t,n,s)),t?.properties)for(const r in t.properties){const i=t.properties[r];n.property=`properties/${r}`,e(i,t,n,s)}if(t?.patternProperties)for(const r in t.patternProperties){const i=t.patternProperties[r];n.property=`patternProperties/${r}`,e(i,t,n,s)}if(t?.allOf)for(const r in t.allOf){const i=t.allOf[r];n.property=`allOf/${r}`,e(i,t,n,s)}if(t?.anyOf)for(const r in t.anyOf){const i=t.anyOf[r];n.property=`anyOf/${r}`,e(i,t,n,s)}if(t?.oneOf)for(const r in t.oneOf){const i=t.oneOf[r];n.property=`oneOf/${r}`,e(i,t,n,s)}return t?.not&&(n.property="not",e(t.not,t,n,s)),n.depth--,t}};function ER(e,t,r){if(t||(t={depth:0}),t.depth||(t={path:"#",depth:0,pkey:"",parent:{},payload:{},seen:new WeakMap,identity:!1,identityDetection:!1,...t}),"object"!=typeof e)return;const n=t.path;for(const s in e){if(t.key=s,t.path=`${t.path}/${encodeURIComponent(s)}`,t.identityPath=t.seen.get(e[s]),t.identity=void 0!==t.identityPath,e.hasOwnProperty(s)&&r(e,s,t),"object"==typeof e[s]&&!t.identity){t.identityDetection&&!Array.isArray(e[s])&&null!==e[s]&&t.seen.set(e[s],t.path);const n={};n.parent=e,n.path=t.path,n.depth=t.depth?t.depth+1:1,n.pkey=s,n.payload=t.payload,n.seen=t.seen,n.identity=!1,n.identityDetection=t.identityDetection,ER(e[s],n,r)}t.path=n}}let $R;function OR(e,t){for(const r in e)r.startsWith("x-")&&!r.startsWith("x-s2o")&&(t[r]=e[r])}function SR(e,t){jR.walkSchema(e,{},{},((e,r)=>{!function(e){if(e["x-required"]&&Array.isArray(e["x-required"])&&(e.required||(e.required=[]),e.required=e.required.concat(e["x-required"]),delete e["x-required"]),e["x-anyOf"]&&(e.anyOf=e["x-anyOf"],delete e["x-anyOf"]),e["x-oneOf"]&&(e.oneOf=e["x-oneOf"],delete e["x-oneOf"]),e["x-not"]&&(e.not=e["x-not"],delete e["x-not"]),"boolean"==typeof e["x-nullable"]&&(e.nullable=e["x-nullable"],delete e["x-nullable"]),"object"==typeof e["x-discriminator"]&&"string"==typeof e["x-discriminator"].propertyName){e.discriminator=e["x-discriminator"],delete e["x-discriminator"];for(const t in e.discriminator.mapping){const r=e.discriminator.mapping[t];r.startsWith("#/definitions/")&&(e.discriminator.mapping[t]=r.replace("#/definitions/","#/components/schemas/"))}}}(e),function(e,t,r){if(e.nullable&&r.patches++,e.discriminator&&"string"==typeof e.discriminator&&(e.discriminator={propertyName:e.discriminator}),e.items&&Array.isArray(e.items)&&(0===e.items.length?e.items={}:1===e.items.length?e.items=e.items[0]:e.items={anyOf:e.items}),e.type&&Array.isArray(e.type)){if(r.patches++,r.warnings.push("(Patchable) schema type must not be an array"),0===e.type.length)delete e.type;else{e.oneOf||(e.oneOf=[]);for(const t of e.type){const r={};if("null"===t)e.nullable=!0;else{r.type=t;for(const t of wR.arrayProperties)void 0!==e.prop&&(r[t]=e[t],delete e[t])}r.type&&e.oneOf.push(r)}delete e.type,0===e.oneOf.length?delete e.oneOf:e.oneOf.length<2&&(e.type=e.oneOf[0].type,Object.keys(e.oneOf[0]).length>1&&(r.patches++,r.warnings.push("Lost properties from oneOf")),delete e.oneOf)}e.type&&Array.isArray(e.type)&&1===e.type.length&&(e.type=e.type[0])}e.type&&"null"===e.type&&(delete e.type,e.nullable=!0),"array"!==e.type||e.items||(e.items={}),"file"===e.type&&(e.type="string",e.format="binary"),"boolean"==typeof e.required&&(e.required&&e.name&&(void 0===t.required&&(t.required=[]),Array.isArray(t.required)&&t.required.push(e.name)),delete e.required),e.xml&&"string"==typeof e.xml.namespace&&(e.xml.namespace||delete e.xml.namespace),e.allowEmptyValue&&(delete e.allowEmptyValue,r.patches++,r.warnings.push("(Patchable): deleted schema.allowEmptyValue"))}(e,r,t)}))}function AR(e){for(const t in e)for(const r in e[t]){const n=wR.sanitise(r);r!==n&&(e[t][n]=e[t][r],delete e[t][r])}}function PR(e,t){if("basic"===e.type&&(e.type="http",e.scheme="basic"),"oauth2"===e.type){const r={};let n=e.flow;"application"===e.flow&&(n="clientCredentials"),"accessCode"===e.flow&&(n="authorizationCode"),"string"==typeof e.authorizationUrl&&(r.authorizationUrl=e.authorizationUrl.split("?")[0].trim()||"/"),"string"==typeof e.tokenUrl&&(r.tokenUrl=e.tokenUrl.split("?")[0].trim()||"/"),r.scopes=e.scopes||{},e.flows={},e.flows[n]=r,delete e.flow,delete e.authorizationUrl,delete e.tokenUrl,delete e.scopes,e.name&&(delete e.name,t.patches++,t.warnings.push("(Patchable) oauth2 securitySchemes should not have name property"))}}function TR(e){return e&&!e["x-s2o-delete"]}function kR(e,t){if(e.type&&!e.schema&&(e.schema={}),e.type&&(e.schema.type=e.type),e.items&&"array"!==e.items.type){if(e.items.collectionFormat!==e.collectionFormat)return t.errCount++,void t.errors.push({message:"Nested collectionFormats are not supported",pointer:"/.../responses/header"});delete e.items.collectionFormat}"array"===e.type?("ssv"===e.collectionFormat?(t.patches++,t.warnings.push("collectionFormat:ssv is no longer supported for headers")):"pipes"===e.collectionFormat?(t.patches++,t.warnings.push("collectionFormat:pipes is no longer supported for headers")):"multi"===e.collectionFormat?e.explode=!0:"tsv"===e.collectionFormat?(e["x-collectionFormat"]="tsv",t.patches++,t.warnings.push("collectionFormat:tsv is no longer supported")):e.style="simple",delete e.collectionFormat):e.collectionFormat&&(delete e.collectionFormat,t.patches++,t.warnings.push("(Patchable) collectionFormat is only applicable to header.type array")),delete e.type;for(const t of wR.parameterTypeProperties)void 0!==e[t]&&(e.schema[t]=e[t],delete e[t]);for(const t of wR.arrayProperties)void 0!==e[t]&&(e.schema[t]=e[t],delete e[t])}function FR(e,t,r,n,s,i,o){const c={};let a,u=!0;t&&t.consumes&&"string"==typeof t.consumes&&(t.consumes=[t.consumes],o.patches++,o.warnings.push("(Patchable) operation.consumes must be an array")),Array.isArray(i.consumes)||delete i.consumes;const l=((t?t.consumes:null)||i.consumes||[]).filter(wR.uniqueOnly);if(e&&(e.name||e.in)){"boolean"==typeof e["x-deprecated"]&&(e.deprecated=e["x-deprecated"],delete e["x-deprecated"]),void 0!==e["x-example"]&&(e.example=e["x-example"],delete e["x-example"]),"body"===e.in||e.type||(e.type="string",o.patches++,o.warnings.push("(Patchable) parameter.type is mandatory for non-body parameters")),"file"===e.type&&(e["x-s2o-originalType"]=e.type,a=e.type),null===e.description&&delete e.description;let t=e.collectionFormat;if("array"!==e.type||t||(t="csv"),t&&("array"!==e.type&&(delete e.collectionFormat,o.patches++,o.warnings.push("(Patchable) collectionFormat is only applicable to param.type array")),"csv"!==t||"query"!==e.in&&"cookie"!==e.in||(e.style="form",e.explode=!1),"csv"!==t||"path"!==e.in&&"header"!==e.in||(e.style="simple"),"ssv"===t&&("query"===e.in?e.style="spaceDelimited":o.warnings.push(`${e.name} collectionFormat:ssv is no longer supported except for in:query parameters`)),"pipes"===t&&("query"===e.in?e.style="pipeDelimited":o.warnings.push(`${e.name} collectionFormat:pipes is no longer supported except for in:query parameters`)),"multi"===t&&(e.explode=!0),"tsv"===t&&(o.warnings.push("collectionFormat:tsv is no longer supported"),e["x-collectionFormat"]="tsv"),delete e.collectionFormat),e.type&&"body"!==e.type&&"formData"!==e.in)if(e.items&&e.schema)o.warnings.push(`${e.name} parameter has array,items and schema`);else{e.schema&&o.patches++,e.schema&&"object"==typeof e.schema||(e.schema={}),e.schema.type=e.type,e.items&&(e.schema.items=e.items,delete e.items,ER(e.schema.items,null,((r,n)=>{"collectionFormat"===n&&"string"==typeof r[n]&&(t&&r[n]!==t&&o.warnings.push(`${e.name} Nested collectionFormats are not supported`),delete r[n])})));for(const t of wR.parameterTypeProperties)void 0!==e[t]&&(e.schema[t]=e[t]),delete e[t]}e.schema&&SR(e.schema,o),e["x-ms-skip-url-encoding"]&&"query"===e.in&&(e.allowReserved=!0,delete e["x-ms-skip-url-encoding"])}if(e&&"formData"===e.in){u=!1,c.content={};let t="application/x-www-form-urlencoded";if(l.length&&l.indexOf("multipart/form-data")>=0&&(t="multipart/form-data"),c.content[t]={},e.schema)c.content[t].schema=e.schema;else{c.content[t].schema={},c.content[t].schema.type="object",c.content[t].schema.properties={},c.content[t].schema.properties[e.name]={};const r=c.content[t].schema,n=c.content[t].schema.properties[e.name];e.description&&(n.description=e.description),e.example&&(n.example=e.example),e.type&&(n.type=e.type);for(const t of wR.parameterTypeProperties)void 0!==e[t]&&(n[t]=e[t]);!0===e.required&&(r.required||(r.required=[]),r.required.push(e.name),c.required=!0),void 0!==e.default&&(n.default=e.default),n.properties&&(n.properties=e.properties),e.allOf&&(n.allOf=e.allOf),"array"===e.type&&e.items&&(n.items=e.items,n.items.collectionFormat&&delete n.items.collectionFormat),"file"!==a&&"file"!==e["x-s2o-originalType"]||(n.type="string",n.format="binary"),OR(e,n)}}else e&&"file"===e.type&&(e.required&&(c.required=e.required),c.content={},c.content["application/octet-stream"]={},c.content["application/octet-stream"].schema={},c.content["application/octet-stream"].schema.type="string",c.content["application/octet-stream"].schema.format="binary",OR(e,c));if(e&&"body"===e.in){c.content={},e.name&&(c["x-s2o-name"]=(t&&t.operationId?wR.sanitiseAll(t.operationId):"")+wR.camelize(`_${e.name}`)),e.description&&(c.description=e.description),e.required&&(c.required=e.required),l.length||l.push("application/json");for(const t of l)c.content[t]={},c.content[t].schema=wR.clone(e.schema||{}),SR(c.content[t].schema,o);OR(e,c)}if(Object.keys(c).length>0&&(e["x-s2o-delete"]=!0,t))if(t.requestBody&&u){t.requestBody["x-s2o-overloaded"]=!0;const e=t.operationId||s;o.warnings.push(`Operation ${e} has multiple requestBodies`)}else t.requestBody||(t=function(e,t){const r={};for(const n of Object.keys(e))r[n]=e[n],"parameters"===n&&(r.requestBody={},t.rbname&&(r[t.rbname]=""));return r.requestBody={},r}(t,o),r[n]=t),t.requestBody.content&&t.requestBody.content["multipart/form-data"]&&t.requestBody.content["multipart/form-data"].schema&&t.requestBody.content["multipart/form-data"].schema.properties&&c.content["multipart/form-data"]&&c.content["multipart/form-data"].schema&&c.content["multipart/form-data"].schema.properties?(t.requestBody.content["multipart/form-data"].schema.properties=Object.assign(t.requestBody.content["multipart/form-data"].schema.properties,c.content["multipart/form-data"].schema.properties),t.requestBody.content["multipart/form-data"].schema.required=(t.requestBody.content["multipart/form-data"].schema.required||[]).concat(c.content["multipart/form-data"].schema.required||[]),t.requestBody.content["multipart/form-data"].schema.required.length||delete t.requestBody.content["multipart/form-data"].schema.required):t.requestBody.content&&t.requestBody.content["application/x-www-form-urlencoded"]&&t.requestBody.content["application/x-www-form-urlencoded"].schema&&t.requestBody.content["application/x-www-form-urlencoded"].schema.properties&&c.content["application/x-www-form-urlencoded"]&&c.content["application/x-www-form-urlencoded"].schema&&c.content["application/x-www-form-urlencoded"].schema.properties?(t.requestBody.content["application/x-www-form-urlencoded"].schema.properties=Object.assign(t.requestBody.content["application/x-www-form-urlencoded"].schema.properties,c.content["application/x-www-form-urlencoded"].schema.properties),t.requestBody.content["application/x-www-form-urlencoded"].schema.required=(t.requestBody.content["application/x-www-form-urlencoded"].schema.required||[]).concat(c.content["application/x-www-form-urlencoded"].schema.required||[]),t.requestBody.content["application/x-www-form-urlencoded"].schema.required.length||delete t.requestBody.content["application/x-www-form-urlencoded"].schema.required):(t.requestBody=Object.assign(t.requestBody,c),t.requestBody["x-s2o-name"]||t.operationId&&(t.requestBody["x-s2o-name"]=wR.sanitiseAll(t.operationId)));if(e&&!e["x-s2o-delete"]){delete e.type;for(const t of wR.parameterTypeProperties)delete e[t];"path"!==e.in||void 0!==e.required&&!0===e.required||(e.required=!0,o.patches++,o.warnings.push(`(Patchable) path parameters must be required:true [${e.name} in ${s}]`))}return t}function IR(e,t,r,n){if(!e)return!1;if(e.description||"object"!=typeof e||Array.isArray(e)||(n.patches++,n.warnings.push("(Patchable) response.description is mandatory")),void 0!==e.schema){SR(e.schema,n),t&&t.produces&&"string"==typeof t.produces&&(t.produces=[t.produces],n.patches++,n.warnings.push("(Patchable) operation.produces must be an array")),r.produces&&!Array.isArray(r.produces)&&delete r.produces;const s=((t?t.produces:null)||r.produces||[]).filter(wR.uniqueOnly);s.length||s.push("*/*"),e.content={};for(const t of s){if(e.content[t]={},e.content[t].schema=wR.clone(e.schema),e.examples&&e.examples[t]){const r={};r.value=e.examples[t],e.content[t].examples={},e.content[t].examples.response=r,delete e.examples[t]}"file"===e.content[t].schema.type&&(e.content[t].schema={type:"string",format:"binary"})}delete e.schema}for(const t in e.examples)e.content||(e.content={}),e.content[t]||(e.content[t]={}),e.content[t].examples={},e.content[t].examples.response={},e.content[t].examples.response.value=e.examples[t];if(delete e.examples,e.headers)for(const t in e.headers)"status code"===t.toLowerCase()?(delete e.headers[t],n.patches++,n.warnings.push('(Patchable) "Status Code" is not a valid header')):kR(e.headers[t],n)}function RR(e,t,r,n,s){for(const i in e){const o=e[i];o&&o["x-trace"]&&"object"==typeof o["x-trace"]&&(o.trace=o["x-trace"],delete o["x-trace"]),o&&o["x-summary"]&&"string"==typeof o["x-summary"]&&(o.summary=o["x-summary"],delete o["x-summary"]),o&&o["x-description"]&&"string"==typeof o["x-description"]&&(o.description=o["x-description"],delete o["x-description"]),o&&o["x-servers"]&&Array.isArray(o["x-servers"])&&(o.servers=o["x-servers"],delete o["x-servers"]);for(const e in o)if(wR.httpMethods.indexOf(e)>=0||"x-amazon-apigateway-any-method"===e){let c=o[e];if(c&&c.parameters&&Array.isArray(c.parameters)){if(o.parameters)for(const t of o.parameters){c.parameters.find((e=>e.name===t.name&&e.in===t.in))||"formData"!==t.in&&"body"!==t.in&&"file"!==t.type||(c=FR(t,c,o,e,i,s,r))}for(const t of c.parameters)c=FR(t,c,o,e,`${e}: ${i}`,s,r);c.parameters&&(c.parameters=c.parameters.filter(TR))}if(c&&c.security&&AR(c.security),"object"==typeof c){if(!c.responses){const e={description:"Default response"};c.responses={default:e}}for(const e in c.responses){IR(c.responses[e],c,s,r)}}if(c&&c["x-servers"]&&Array.isArray(c["x-servers"]))c.servers=c["x-servers"],delete c["x-servers"];else if(c&&c.schemes&&c.schemes.length)for(const e of c.schemes)if((!s.schemes||s.schemes.indexOf(e)<0)&&(c.servers||(c.servers=[]),Array.isArray(s.servers)))for(const e of s.servers){const t=wR.clone(e);c.servers.push(t)}if(c){if(delete c.consumes,delete c.produces,delete c.schemes,c["x-ms-examples"]){for(const e in c["x-ms-examples"]){const t=c["x-ms-examples"][e],r=wR.sanitiseAll(e);if(t.parameters)for(const r in t.parameters){const n=t.parameters[r];for(const t of(c.parameters||[]).concat(o.parameters||[]))t.name!==r||t.example||(t.examples||(t.examples={}),t.examples[e]={value:n})}if(t.responses)for(const n in t.responses){if(t.responses[n].headers)for(const e in t.responses[n].headers){const r=t.responses[n].headers[e];for(const t in c.responses[n].headers)if(t===e){c.responses[n].headers[t].example=r}}if(t.responses[n].body&&(s.components.examples[r]={value:wR.clone(t.responses[n].body)},c.responses[n]&&c.responses[n].content))for(const t in c.responses[n].content){const s=c.responses[n].content[t];s.examples||(s.examples={}),s.examples[e]={$ref:`#/components/examples/${r}`}}}}delete c["x-ms-examples"]}if(c.parameters&&0===c.parameters.length&&delete c.parameters,c.requestBody){const r=c.operationId?wR.sanitiseAll(c.operationId):wR.camelize(wR.sanitiseAll(e+i)),s=wR.sanitise(c.requestBody["x-s2o-name"]||r||"");delete c.requestBody["x-s2o-name"];const o=JSON.stringify(c.requestBody),a=wR.createHash(o);if(!n[a]){const e={};e.name=s,e.body=c.requestBody,e.refs=[],n[a]=e}const u=`#/${t}/${encodeURIComponent(i)}/${e}/requestBody`;n[a].refs.push(u)}}}if(o&&o.parameters){for(const e in o.parameters){FR(o.parameters[e],null,o,null,i,s,r)}Array.isArray(o.parameters)&&(o.parameters=o.parameters.filter(TR))}}}function DR(e){return e&&e.url&&"string"==typeof e.url?(e.url=e.url.split("{{").join("{"),e.url=e.url.split("}}").join("}"),e.url.replace(/\{(.+?)\}/g,((t,r)=>{e.variables||(e.variables={}),e.variables[r]={default:"unknown"}})),e):e}function _R(e,t){void 0!==e.info&&null!==e.info||(e.info={version:"",title:""},t.patches++,t.warnings.push("(Patchable) info object is mandatory")),("object"!=typeof e.info||Array.isArray(e.info))&&(t.errCount++,t.errors.push({message:"info must be an object",pointer:"/info"})),e.info&&(void 0===e.info.title&&(t.patches++,e.info.title="",t.warnings.push({message:"(Patchable) info.title cannot be null",pointer:"/info/title",patchable:!0})),void 0===e.info.version?(t.patches++,e.info.version="",t.warnings.push("(Patchable) info.version cannot be null")):"string"!=typeof e.info.version&&(t.patches++,e.info.version=e.info.version.toString(),t.warnings.push("(Patchable) info.version must be a string")))}function CR(e,t){e.paths||(t.patches++,e.paths={},t.warnings.push("(Patchable) paths object is mandatory"))}function MR(e={}){const t={original:e,openapi:{},patches:0,warnings:[],errCount:0,errors:[]};if(e.openapi&&"string"==typeof e.openapi&&e.openapi.startsWith("3."))return t.openapi=wR.circularClone(e),_R(t.openapi,t),CR(t.openapi,t),t;if("2.0"!==e.swagger)return t.errCount++,t.errors.push({message:`Unsupported swagger/OpenAPI version: ${e.openapi?e.openapi:e.swagger}`,pointer:"/swagger"}),t;if(t.openapi=wR.circularClone(e),t.openapi.openapi="3.0.0",delete t.openapi.swagger,ER(t.openapi,{},((e,t,r)=>{null===e[t]&&!t.startsWith("x-")&&"default"!==t&&r.path.indexOf("/example")<0&&delete e[t]})),e.host)(e.schemes||[]).forEach((r=>{const n={},s=(e.basePath||"").replace(/\/$/,"");n.url=`${r?`${r}:`:""}//${e.host}${s}`,DR(n),t.openapi.servers||(t.openapi.servers=[]),t.openapi.servers.push(n)}));else if(e.basePath){const r={};r.url=e.basePath,DR(r),t.openapi.servers||(t.openapi.servers=[]),t.openapi.servers.push(r)}if(delete t.openapi.host,delete t.openapi.basePath,e["x-ms-parameterized-host"]){const r=e["x-ms-parameterized-host"],n={};n.url=r.hostTemplate+(e.basePath?e.basePath:""),n.variables={};const s=n.url.match(/\{\w+\}/g);for(const e in r.parameters){const t=r.parameters[e];e.startsWith("x-")||(delete t.required,delete t.type,delete t.in,void 0===t.default&&(t.enum?t.default=t.enum[0]:t.default="none"),t.name||(t.name=s[e].replace("{","").replace("}","")),n.variables[t.name]=t,delete t.name)}t.openapi.servers||(t.openapi.servers=[]),!1===r.useSchemePrefix?t.openapi.servers.push(n):e.schemes.forEach((e=>{t.openapi.servers.push({...n,url:`${e}://${n.url}`})})),delete t.openapi["x-ms-parameterized-host"]}return _R(t.openapi,t),CR(t.openapi,t),"string"==typeof t.openapi.consumes&&(t.openapi.consumes=[t.openapi.consumes]),"string"==typeof t.openapi.produces&&(t.openapi.produces=[t.openapi.produces]),t.openapi.components={},t.openapi["x-callbacks"]&&(t.openapi.components.callbacks=t.openapi["x-callbacks"],delete t.openapi["x-callbacks"]),t.openapi.components.examples={},t.openapi.components.headers={},t.openapi["x-links"]&&(t.openapi.components.links=t.openapi["x-links"],delete t.openapi["x-links"]),t.openapi.components.parameters=t.openapi.parameters||{},t.openapi.components.responses=t.openapi.responses||{},t.openapi.components.requestBodies={},t.openapi.components.securitySchemes=t.openapi.securityDefinitions||{},t.openapi.components.schemas=t.openapi.definitions||{},delete t.openapi.definitions,delete t.openapi.responses,delete t.openapi.parameters,delete t.openapi.securityDefinitions,function(e){const t=e.openapi,r={};$R={schemas:{}},t.security&&AR(t.security);for(const r in t.components.securitySchemes){const n=wR.sanitise(r);if(r!==n){if(t.components.securitySchemes[n])return e.errCount++,e.errors.push({message:`Duplicate sanitised securityScheme name ${n}`,pointer:`/components/securitySchemes/${n}`}),e;t.components.securitySchemes[n]=t.components.securitySchemes[r],delete t.components.securitySchemes[r]}PR(t.components.securitySchemes[n],e)}for(const r in t.components.schemas){const n=wR.sanitiseAll(r);let s=0;if(r!==n){for(;t.components.schemas[n+s];)s=s?++s:2;t.components.schemas[n+s]=t.components.schemas[r],delete t.components.schemas[r]}$R.schemas[r]=n+s,SR(t.components.schemas[`${n}${s}`],e)}for(const r in t.components.parameters){const n=wR.sanitise(r);if(r!==n){if(t.components.parameters[n])return e.errCount++,e.errors.push({message:`Duplicate sanitised parameter name ${n}`,pointer:`/components/parameters/${n}`}),e;t.components.parameters[n]=t.components.parameters[r],delete t.components.parameters[r]}FR(t.components.parameters[n],null,null,null,n,t,e)}for(const r in t.components.responses){const n=wR.sanitise(r);if(r!==n){if(t.components.responses[n])return e.errCount++,e.errors.push({message:`Duplicate sanitised response name ${n}`,pointer:`/components/responses/${n}`}),e;t.components.responses[n]=t.components.responses[r],delete t.components.responses[r]}const s=t.components.responses[n];if(IR(s,null,t,e),s.headers)for(const t in s.headers)"status code"===t.toLowerCase()?(delete s.headers[t],e.patches++,e.warnings.push('(Patchable) "Status Code" is not a valid header')):kR(s.headers[t],e)}for(const e in t.components.requestBodies){const n=t.components.requestBodies[e],s=JSON.stringify(n),i=wR.createHash(s),o={};o.name=e,o.body=n,o.refs=[],r[i]=o}RR(t.paths,"paths",e,r,t),t["x-ms-paths"]&&RR(t["x-ms-paths"],"x-ms-paths",e,r,t);for(const e in t.components.parameters)t.components.parameters[e]["x-s2o-delete"]&&delete t.components.parameters[e];return delete t.consumes,delete t.produces,delete t.schemes,t.components.requestBodies={},t.components.responses&&0===Object.keys(t.components.responses).length&&delete t.components.responses,t.components.parameters&&0===Object.keys(t.components.parameters).length&&delete t.components.parameters,t.components.examples&&0===Object.keys(t.components.examples).length&&delete t.components.examples,t.components.requestBodies&&0===Object.keys(t.components.requestBodies).length&&delete t.components.requestBodies,t.components.securitySchemes&&0===Object.keys(t.components.securitySchemes).length&&delete t.components.securitySchemes,t.components.headers&&0===Object.keys(t.components.headers).length&&delete t.components.headers,t.components.schemas&&0===Object.keys(t.components.schemas).length&&delete t.components.schemas,t.components&&0===Object.keys(t.components).length&&delete t.components,e}(t)}function NR(e){return e.ok&&e.text&&e.parseError&&"YAMLException"===e.parseError.name&&(!e.headers["content-type"]||e.headers["content-type"].match("text/plain"))&&(e.body=e.text),e}const qR={convertObj:MR,resolve:function(e){return new Promise((async t=>{try{const r=await bR.resolve(e,NR);if(r.errors&&r.errors.length>0)t(r);else{r.spec.openapi&&(r.resolvedSpec=r.spec,t(r));const e=MR(r.spec);e.errors&&e.errors.length>0&&(Array.isArray(r.errors)?r.errors.concat(r.errors):r.errors=e.errors),e.warnings&&e.warnings.length>0&&(r.warnings=e.warnings),r.resolvedSpec=r.spec,r.spec=e.openapi,t(r)}}catch(e){t(e)}}))}};

;// ./src/utils/spec-parser.js
/* eslint-disable no-use-before-define */



async function ProcessSpec(specUrl, generateMissingTags = false, sortTags = false, sortSchemas = false, sortEndpointsBy = '', attrApiKey = '', attrApiKeyLocation = '', attrApiKeyValue = '', serverUrl = '', matchPaths = '', matchType = '', removeEndpointsWithBadgeLabelAs = '') {
  var _jsonParsedSpec$info, _jsonParsedSpec$compo;
  let jsonParsedSpec;
  try {
    var _specMeta$resolvedSpe, _specMeta$resolvedSpe2;
    this.requestUpdate(); // important to show the initial loader
    let specMeta;
    if (typeof specUrl === 'string') {
      specMeta = await qR.resolve({
        url: specUrl,
        allowMetaPatches: false
      }); // Swagger(specUrl);
    } else {
      specMeta = await qR.resolve({
        spec: specUrl,
        allowMetaPatches: false
      }); // Swagger({ spec: specUrl });
    }
    await sleep(0); // important to show the initial loader (allows for rendering updates)

    // If JSON Schema Viewer
    if ((_specMeta$resolvedSpe = specMeta.resolvedSpec) !== null && _specMeta$resolvedSpe !== void 0 && _specMeta$resolvedSpe.jsonSchemaViewer && (_specMeta$resolvedSpe2 = specMeta.resolvedSpec) !== null && _specMeta$resolvedSpe2 !== void 0 && _specMeta$resolvedSpe2.schemaAndExamples) {
      this.dispatchEvent(new CustomEvent('before-render', {
        detail: {
          spec: specMeta.resolvedSpec
        }
      }));
      const schemaAndExamples = Object.entries(specMeta.resolvedSpec.schemaAndExamples).map(v => ({
        show: true,
        expanded: true,
        selectedExample: null,
        name: v[0],
        elementId: v[0].replace(invalidCharsRegEx, '-'),
        ...v[1]
      }));
      const parsedSpec = {
        specLoadError: false,
        isSpecLoading: false,
        info: specMeta.resolvedSpec.info,
        schemaAndExamples
      };
      return parsedSpec;
    }

    // If RapiDoc or RapiDocMini
    if (specMeta.spec && (specMeta.spec.components || specMeta.spec.info || specMeta.spec.servers || specMeta.spec.tags || specMeta.spec.paths)) {
      jsonParsedSpec = filterPaths(specMeta.spec, matchPaths, matchType, removeEndpointsWithBadgeLabelAs);
      this.dispatchEvent(new CustomEvent('before-render', {
        detail: {
          spec: jsonParsedSpec
        }
      }));
    } else {
      var _specMeta$response, _specMeta$response2, _specMeta$response3, _specMeta$response4;
      console.info('RapiDoc: %c There was an issue while parsing the spec %o ', 'color:orangered', specMeta); // eslint-disable-line no-console
      return {
        specLoadError: true,
        isSpecLoading: false,
        info: {
          title: 'Error loading the spec',
          description: (_specMeta$response = specMeta.response) !== null && _specMeta$response !== void 0 && _specMeta$response.url ? `${(_specMeta$response2 = specMeta.response) === null || _specMeta$response2 === void 0 ? void 0 : _specMeta$response2.url} ┃ ${(_specMeta$response3 = specMeta.response) === null || _specMeta$response3 === void 0 ? void 0 : _specMeta$response3.status}  ${(_specMeta$response4 = specMeta.response) === null || _specMeta$response4 === void 0 ? void 0 : _specMeta$response4.statusText}` : 'Unable to load the Spec',
          version: ' '
        },
        tags: []
      };
    }
  } catch (err) {
    console.info('RapiDoc: %c There was an issue while parsing the spec %o ', 'color:orangered', err); // eslint-disable-line no-console
  }

  // const pathGroups = groupByPaths(jsonParsedSpec);

  // Tags with Paths and WebHooks
  const tags = groupByTags(jsonParsedSpec, sortEndpointsBy, generateMissingTags, sortTags);

  // Components
  const components = getComponents(jsonParsedSpec, sortSchemas);

  // Info Description Headers
  const infoDescriptionHeaders = (_jsonParsedSpec$info = jsonParsedSpec.info) !== null && _jsonParsedSpec$info !== void 0 && _jsonParsedSpec$info.description ? getHeadersFromMarkdown(jsonParsedSpec.info.description) : [];

  // Security Scheme
  const securitySchemes = [];
  if ((_jsonParsedSpec$compo = jsonParsedSpec.components) !== null && _jsonParsedSpec$compo !== void 0 && _jsonParsedSpec$compo.securitySchemes) {
    const securitySchemeSet = new Set();
    Object.entries(jsonParsedSpec.components.securitySchemes).forEach(kv => {
      if (!securitySchemeSet.has(kv[0])) {
        securitySchemeSet.add(kv[0]);
        const securityObj = {
          securitySchemeId: kv[0],
          ...kv[1]
        };
        securityObj.value = '';
        securityObj.finalKeyValue = '';
        if (kv[1].type === 'apiKey' || kv[1].type === 'http') {
          securityObj.in = kv[1].in || 'header';
          securityObj.name = kv[1].name || 'Authorization';
          securityObj.user = '';
          securityObj.password = '';
        } else if (kv[1].type === 'oauth2') {
          securityObj.in = 'header';
          securityObj.name = 'Authorization';
          securityObj.clientId = '';
          securityObj.clientSecret = '';
        }
        securitySchemes.push(securityObj);
      }
    });
  }
  if (attrApiKey && attrApiKeyLocation && attrApiKeyValue) {
    securitySchemes.push({
      securitySchemeId: rapidocApiKey,
      description: 'api-key provided in rapidoc element attributes',
      type: 'apiKey',
      oAuthFlow: '',
      name: attrApiKey,
      in: attrApiKeyLocation,
      value: attrApiKeyValue,
      finalKeyValue: attrApiKeyValue
    });
  }

  // Updated Security Type Display Text based on Type
  securitySchemes.forEach(v => {
    if (v.type === 'http') {
      v.typeDisplay = v.scheme === 'basic' ? 'HTTP Basic' : 'HTTP Bearer';
    } else if (v.type === 'apiKey') {
      v.typeDisplay = `API Key (${v.name})`;
    } else if (v.type === 'oauth2') {
      v.typeDisplay = `OAuth (${v.securitySchemeId})`;
    } else {
      v.typeDisplay = v.type || 'None';
    }
  });

  // Servers
  let servers = [];
  if (jsonParsedSpec.servers && Array.isArray(jsonParsedSpec.servers) && jsonParsedSpec.servers.length > 0) {
    jsonParsedSpec.servers.forEach(v => {
      let computedUrl = v.url.trim();
      if (!(computedUrl.startsWith('http') || computedUrl.startsWith('//') || computedUrl.startsWith('{'))) {
        if (window.location.origin.startsWith('http')) {
          v.url = window.location.origin + v.url;
          computedUrl = v.url;
        }
      }
      // Apply server-variables to generate final computed-url
      if (v.variables) {
        Object.entries(v.variables).forEach(kv => {
          const regex = new RegExp(`{${kv[0]}}`, 'g');
          computedUrl = computedUrl.replace(regex, kv[1].default || '');
          kv[1].value = kv[1].default || '';
        });
      }
      v.computedUrl = computedUrl;
    });
    if (serverUrl) {
      jsonParsedSpec.servers.push({
        url: serverUrl,
        computedUrl: serverUrl
      });
    }
  } else if (serverUrl) {
    jsonParsedSpec.servers = [{
      url: serverUrl,
      computedUrl: serverUrl
    }];
  } else if (window.location.origin.startsWith('http')) {
    jsonParsedSpec.servers = [{
      url: window.location.origin,
      computedUrl: window.location.origin
    }];
  } else {
    jsonParsedSpec.servers = [{
      url: 'http://localhost',
      computedUrl: 'http://localhost'
    }];
  }
  servers = jsonParsedSpec.servers; // eslint-disable-line prefer-destructuring
  const parsedSpec = {
    specLoadError: false,
    isSpecLoading: false,
    info: jsonParsedSpec.info,
    infoDescriptionHeaders,
    tags,
    components,
    externalDocs: jsonParsedSpec.externalDocs,
    securitySchemes,
    servers
  };
  return parsedSpec;
}
function filterPaths(openApiObject, matchPaths = '', matchType = '', removeEndpointsWithBadgeLabelAs = '') {
  const filteredPaths = {};

  // Convert the removePathsWithBadgeLabeledAs to an array if provided
  const labelsToRemove = removeEndpointsWithBadgeLabelAs.split(',').map(label => label.trim().toLowerCase()).filter(Boolean);

  // Helper function to check if a path should be included based on matchPaths
  function pathMatches(pathsKey, httpMethod) {
    if (!matchPaths) {
      return true; // If no matchPaths provided, include everything
    }
    const fullPath = `${httpMethod} ${pathsKey}`.toLowerCase(); // Construct "method path" string
    if (matchType === 'regex') {
      const regex = new RegExp(matchPaths, 'i');
      return regex.test(matchPaths.toLowerCase());
    }
    return fullPath.includes(matchPaths.toLowerCase());
  }

  // Helper function to check if the badges contain any label that needs to be removed
  function containsLabelToRemove(badges) {
    return badges.some(badge => labelsToRemove.includes(badge === null || badge === void 0 ? void 0 : badge.label.toLowerCase()));
  }

  // Loop through the paths in the openApiObject
  Object.entries(openApiObject.paths).forEach(([pathsKey, methods]) => {
    const filteredMethods = {};
    Object.entries(methods).forEach(([httpMethod, methodDetails]) => {
      const badges = methodDetails['x-badges'];

      // Filter by matchPaths
      if (pathMatches(pathsKey, httpMethod)) {
        if (badges && Array.isArray(badges)) {
          // Filter out based on removePathsWithBadgeLabeledAs
          if (!containsLabelToRemove(badges)) {
            filteredMethods[httpMethod] = methodDetails;
          }
        } else {
          // No badges present, include the method
          filteredMethods[httpMethod] = methodDetails;
        }
      }
    });
    if (Object.keys(filteredMethods).length > 0) {
      filteredPaths[pathsKey] = filteredMethods;
    }
  });
  openApiObject.paths = filteredPaths;
  return openApiObject;
}
function getHeadersFromMarkdown(markdownContent) {
  const tokens = marked.lexer(markdownContent);
  const headers = tokens.filter(v => v.type === 'heading' && v.depth <= 2);
  return headers || [];
}
function getComponents(openApiSpec, sortSchemas = false) {
  if (!openApiSpec.components) {
    return [];
  }
  const components = [];
  for (const component in openApiSpec.components) {
    const subComponents = [];
    for (const sComponent in openApiSpec.components[component]) {
      const scmp = {
        show: true,
        id: `${component.toLowerCase()}-${sComponent.toLowerCase()}`.replace(invalidCharsRegEx, '-'),
        name: sComponent,
        component: openApiSpec.components[component][sComponent]
      };
      subComponents.push(scmp);
    }
    let cmpDescription = component;
    let cmpName = component;
    switch (component) {
      case 'schemas':
        if (sortSchemas) {
          subComponents.sort((c1, c2) => c1.name.localeCompare(c2.name));
        }
        cmpName = 'Schemas';
        cmpDescription = 'Schemas allows the definition of input and output data types. These types can be objects, but also primitives and arrays.';
        break;
      case 'responses':
        cmpName = 'Responses';
        cmpDescription = 'Describes responses from an API Operation, including design-time, static links to operations based on the response.';
        break;
      case 'parameters':
        cmpName = 'Parameters';
        cmpDescription = 'Describes operation parameters. A unique parameter is defined by a combination of a name and location.';
        break;
      case 'examples':
        cmpName = 'Examples';
        cmpDescription = 'List of Examples for operations, can be requests, responses and objects examples.';
        break;
      case 'requestBodies':
        cmpName = 'Request Bodies';
        cmpDescription = 'Describes common request bodies that are used across the API operations.';
        break;
      case 'headers':
        cmpName = 'Headers';
        cmpDescription = 'Headers follows the structure of the Parameters but they are explicitly in "header"';
        break;
      case 'securitySchemes':
        cmpName = 'Security Schemes';
        // eslint-disable-next-line max-len
        cmpDescription = 'Defines a security scheme that can be used by the operations. Supported schemes are HTTP authentication, an API key (either as a header, a cookie parameter or as a query parameter), OAuth2\'s common flows(implicit, password, client credentials and authorization code) as defined in RFC6749, and OpenID Connect Discovery.';
        break;
      case 'links':
        cmpName = 'Links';
        cmpDescription = 'Links represent a possible design-time link for a response. The presence of a link does not guarantee the caller\'s ability to successfully invoke it, rather it provides a known relationship and traversal mechanism between responses and other operations.';
        break;
      case 'callbacks':
        cmpName = 'Callbacks';
        // eslint-disable-next-line max-len
        cmpDescription = 'A map of possible out-of band callbacks related to the parent operation. Each value in the map is a Path Item Object that describes a set of requests that may be initiated by the API provider and the expected responses. The key value used to identify the path item object is an expression, evaluated at runtime, that identifies a URL to use for the callback operation.';
        break;
      default:
        cmpName = component;
        cmpDescription = component;
        break;
    }
    const cmp = {
      show: true,
      name: cmpName,
      description: cmpDescription,
      subComponents
    };
    components.push(cmp);
  }
  return components || [];
}
function groupByTags(openApiSpec, sortEndpointsBy, generateMissingTags = false, sortTags = false) {
  const supportedMethods = ['get', 'put', 'post', 'delete', 'patch', 'head', 'options']; // this is also used for ordering endpoints by methods
  const tags = openApiSpec.tags && Array.isArray(openApiSpec.tags) && openApiSpec.tags.length > 0 ? openApiSpec.tags.map(v => ({
    show: true,
    elementId: `tag--${v.name.replace(invalidCharsRegEx, '-')}`,
    name: v.name,
    displayName: v['x-displayName'] || v.name,
    description: v.description || '',
    headers: v.description ? getHeadersFromMarkdown(v.description) : [],
    paths: [],
    expanded: v['x-tag-expanded'] !== false
  })) : [];
  const pathsAndWebhooks = openApiSpec.paths || {};
  if (openApiSpec.webhooks) {
    for (const [key, value] of Object.entries(openApiSpec.webhooks)) {
      value._type = 'webhook'; // eslint-disable-line no-underscore-dangle
      pathsAndWebhooks[key] = value;
    }
  }
  // For each path find the tag and push it into the corresponding tag
  for (const pathOrHookName in pathsAndWebhooks) {
    const commonParams = pathsAndWebhooks[pathOrHookName].parameters;
    const commonPathProp = {
      servers: pathsAndWebhooks[pathOrHookName].servers || [],
      parameters: pathsAndWebhooks[pathOrHookName].parameters || []
    };
    const isWebhook = pathsAndWebhooks[pathOrHookName]._type === 'webhook'; // eslint-disable-line no-underscore-dangle
    supportedMethods.forEach(methodName => {
      if (pathsAndWebhooks[pathOrHookName][methodName]) {
        const pathOrHookObj = openApiSpec.paths[pathOrHookName][methodName];
        // If path.methods are tagged, else generate it from path
        const pathTags = pathOrHookObj.tags || [];
        if (pathTags.length === 0) {
          if (generateMissingTags) {
            const pathOrHookNameKey = pathOrHookName.replace(/^\/+|\/+$/g, '');
            const firstWordEndIndex = pathOrHookNameKey.indexOf('/');
            if (firstWordEndIndex === -1) {
              pathTags.push(pathOrHookNameKey);
            } else {
              // firstWordEndIndex -= 1;
              pathTags.push(pathOrHookNameKey.substring(0, firstWordEndIndex));
            }
          } else {
            pathTags.push('General ⦂');
          }
        }
        pathTags.forEach(tag => {
          let tagObj;
          let specTagsItem;
          if (openApiSpec.tags) {
            specTagsItem = openApiSpec.tags.find(v => v.name.toLowerCase() === tag.toLowerCase());
          }
          tagObj = tags.find(v => v.name === tag);
          if (!tagObj) {
            var _specTagsItem, _specTagsItem2;
            tagObj = {
              show: true,
              elementId: `tag--${tag.replace(invalidCharsRegEx, '-')}`,
              name: tag,
              description: ((_specTagsItem = specTagsItem) === null || _specTagsItem === void 0 ? void 0 : _specTagsItem.description) || '',
              headers: (_specTagsItem2 = specTagsItem) !== null && _specTagsItem2 !== void 0 && _specTagsItem2.description ? getHeadersFromMarkdown(specTagsItem.description) : [],
              paths: [],
              expanded: specTagsItem ? specTagsItem['x-tag-expanded'] !== false : true
            };
            tags.push(tagObj);
          }

          // Generate a short summary which is broken
          let shortSummary = (pathOrHookObj.summary || pathOrHookObj.description || `${methodName.toUpperCase()} ${pathOrHookName}`).trim();
          if (shortSummary.length > 100) {
            [shortSummary] = shortSummary.split(/[.|!|?]\s|[\r?\n]/); // take the first line (period or carriage return)
          }
          // Merge Common Parameters with This methods parameters
          let finalParameters = [];
          if (commonParams) {
            if (pathOrHookObj.parameters) {
              finalParameters = commonParams.filter(commonParam => {
                if (!pathOrHookObj.parameters.some(param => commonParam.name === param.name && commonParam.in === param.in)) {
                  return commonParam;
                }
              }).concat(pathOrHookObj.parameters);
            } else {
              finalParameters = commonParams.slice(0);
            }
          } else {
            finalParameters = pathOrHookObj.parameters ? pathOrHookObj.parameters.slice(0) : [];
          }

          // Filter callbacks to contain only objects.
          if (pathOrHookObj.callbacks) {
            for (const [callbackName, callbackConfig] of Object.entries(pathOrHookObj.callbacks)) {
              const filteredCallbacks = Object.entries(callbackConfig).filter(entry => typeof entry[1] === 'object') || [];
              pathOrHookObj.callbacks[callbackName] = Object.fromEntries(filteredCallbacks);
            }
          }

          // Update Responses
          tagObj.paths.push({
            show: true,
            expanded: false,
            isWebhook,
            expandedAtLeastOnce: false,
            summary: pathOrHookObj.summary || '',
            description: pathOrHookObj.description || '',
            externalDocs: pathOrHookObj.externalDocs,
            shortSummary,
            method: methodName,
            path: pathOrHookName,
            operationId: pathOrHookObj.operationId,
            elementId: `${methodName}-${pathOrHookName.replace(invalidCharsRegEx, '-')}`,
            servers: pathOrHookObj.servers ? commonPathProp.servers.concat(pathOrHookObj.servers) : commonPathProp.servers,
            parameters: finalParameters,
            requestBody: pathOrHookObj.requestBody,
            responses: pathOrHookObj.responses,
            callbacks: pathOrHookObj.callbacks,
            deprecated: pathOrHookObj.deprecated,
            security: pathOrHookObj.security,
            // commonSummary: commonPathProp.summary,
            // commonDescription: commonPathProp.description,
            xBadges: pathOrHookObj['x-badges'] || undefined,
            xCodeSamples: pathOrHookObj['x-codeSamples'] || pathOrHookObj['x-code-samples'] || ''
          });
        }); // End of tag path create
      }
    }); // End of Methods
  }
  const tagsWithSortedPaths = tags.filter(tag => tag.paths && tag.paths.length > 0);
  tagsWithSortedPaths.forEach(tag => {
    if (sortEndpointsBy === 'method') {
      tag.paths.sort((a, b) => supportedMethods.indexOf(a.method).toString().localeCompare(supportedMethods.indexOf(b.method)));
    } else if (sortEndpointsBy === 'summary') {
      tag.paths.sort((a, b) => a.shortSummary.localeCompare(b.shortSummary));
    } else if (sortEndpointsBy === 'path') {
      tag.paths.sort((a, b) => a.path.localeCompare(b.path));
    } else if (sortEndpointsBy === 'none') {
      // don't sort if sortEndpointsBy is 'none'
    }
    tag.firstPathId = tag.paths[0].elementId;
  });
  return sortTags ? tagsWithSortedPaths.sort((a, b) => a.name.localeCompare(b.name)) : tagsWithSortedPaths;
}
;// ./node_modules/lit-html/directive.js
/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const directive_t={ATTRIBUTE:1,CHILD:2,PROPERTY:3,BOOLEAN_ATTRIBUTE:4,EVENT:5,ELEMENT:6},directive_e=t=>(...e)=>({_$litDirective$:t,values:e});class directive_i{constructor(t){}get _$AU(){return this._$AM._$AU}_$AT(t,e,i){this.t=t,this._$AM=e,this.i=i}_$AS(t,e){return this.update(t,e)}update(t,e){return this.render(...e)}}
//# sourceMappingURL=directive.js.map

;// ./node_modules/lit-html/directives/unsafe-html.js

/**
 * @license
 * Copyright 2017 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */class unsafe_html_le extends directive_i{constructor(i){if(super(i),this.it=D,i.type!==directive_t.CHILD)throw Error(this.constructor.directiveName+"() can only be used in child bindings")}render(t){if(t===D||null==t)return this._t=void 0,this.it=t;if(t===R)return t;if("string"!=typeof t)throw Error(this.constructor.directiveName+"() called with a non-string value");if(t===this.it)return this._t;this.it=t;const i=[t];return i.raw=i,this._t={_$litType$:this.constructor.resultType,strings:i,values:[]}}}unsafe_html_le.directiveName="unsafeHTML",unsafe_html_le.resultType=1;const unsafe_html_ae=directive_e(unsafe_html_le);
//# sourceMappingURL=unsafe-html.js.map

;// ./node_modules/lit/directives/unsafe-html.js

//# sourceMappingURL=unsafe-html.js.map

;// ./src/templates/security-scheme-template.js
/* provided dependency */ var Buffer = __webpack_require__(287)["hp"];
/* eslint-disable arrow-body-style */

 // eslint-disable-line import/extensions

const codeVerifier = '731DB1C3F7EA533B85E29492D26AA-1234567890-1234567890';
const codeChallenge = '4FatVDBJKPAo4JgLLaaQFMUcQPn5CrPRvLlaob9PTYc'; // Base64 encoded SHA-256

const localStorageKey = 'rapidoc';
function applyApiKey(securitySchemeId, username = '', password = '', providedApikeyVal = '') {
  var _this$resolvedSpec$se, _securityObj$scheme;
  const securityObj = (_this$resolvedSpec$se = this.resolvedSpec.securitySchemes) === null || _this$resolvedSpec$se === void 0 ? void 0 : _this$resolvedSpec$se.find(v => v.securitySchemeId === securitySchemeId);
  if (!securityObj) {
    return false;
  }
  let finalApiKeyValue = '';
  if (((_securityObj$scheme = securityObj.scheme) === null || _securityObj$scheme === void 0 ? void 0 : _securityObj$scheme.toLowerCase()) === 'basic') {
    if (username) {
      finalApiKeyValue = `Basic ${Buffer.from(`${username}:${password}`, 'utf8').toString('base64')}`;
    }
  } else if (providedApikeyVal) {
    var _securityObj$scheme2;
    securityObj.value = providedApikeyVal;
    finalApiKeyValue = `${((_securityObj$scheme2 = securityObj.scheme) === null || _securityObj$scheme2 === void 0 ? void 0 : _securityObj$scheme2.toLowerCase()) === 'bearer' ? 'Bearer ' : ''}${providedApikeyVal}`;
  }
  if (finalApiKeyValue) {
    securityObj.finalKeyValue = finalApiKeyValue;
    this.requestUpdate();
    return true;
  }
  return false;
}
function onClearAllApiKeys() {
  var _this$resolvedSpec$se2;
  (_this$resolvedSpec$se2 = this.resolvedSpec.securitySchemes) === null || _this$resolvedSpec$se2 === void 0 || _this$resolvedSpec$se2.forEach(v => {
    v.user = '';
    v.password = '';
    v.value = '';
    v.finalKeyValue = '';
  });
  this.requestUpdate();
}
function getPersistedApiKeys() {
  return JSON.parse(localStorage.getItem(localStorageKey)) || {};
}
function setPersistedApiKeys(obj) {
  localStorage.setItem(localStorageKey, JSON.stringify(obj));
}
function recoverPersistedApiKeys() {
  const rapidocLs = getPersistedApiKeys.call(this);
  Object.values(rapidocLs).forEach(p => {
    applyApiKey.call(this, p.securitySchemeId, p.username, p.password, p.value);
  });
}
function onApiKeyChange(securitySchemeId) {
  let apiKeyValue = '';
  const securityObj = this.resolvedSpec.securitySchemes.find(v => v.securitySchemeId === securitySchemeId);
  if (securityObj) {
    const trEl = this.shadowRoot.getElementById(`security-scheme-${securitySchemeId}`);
    if (trEl) {
      if (securityObj.type && securityObj.scheme && securityObj.type === 'http' && securityObj.scheme.toLowerCase() === 'basic') {
        const userVal = trEl.querySelector('.api-key-user').value.trim();
        const passwordVal = trEl.querySelector('.api-key-password').value.trim();
        applyApiKey.call(this, securitySchemeId, userVal, passwordVal);
      } else {
        apiKeyValue = trEl.querySelector('.api-key-input').value.trim();
        applyApiKey.call(this, securitySchemeId, '', '', apiKeyValue);
      }
      if (this.persistAuth === 'true') {
        const rapidocLs = getPersistedApiKeys.call(this);
        rapidocLs[securitySchemeId] = securityObj;
        setPersistedApiKeys.call(this, rapidocLs);
      }
    }
  }
}

// Updates the OAuth Access Token (API key), so it reflects in UI and gets used in TRY calls
function updateOAuthKey(securitySchemeId, accessToken, tokenType = 'Bearer') {
  const securityObj = this.resolvedSpec.securitySchemes.find(v => v.securitySchemeId === securitySchemeId);
  securityObj.finalKeyValue = `${tokenType.toLowerCase() === 'bearer' ? 'Bearer' : tokenType.toLowerCase() === 'mac' ? 'MAC' : tokenType} ${accessToken}`;
  this.requestUpdate();
}

/* eslint-disable no-console */
// Gets Access-Token in exchange of Authorization Code
async function fetchAccessToken(tokenUrl, clientId, clientSecret, redirectUrl, grantType, authCode, securitySchemeId, authFlowDivEl, sendClientSecretIn = 'header', scopes = null, username = null, password = null) {
  const respDisplayEl = authFlowDivEl ? authFlowDivEl.querySelector('.oauth-resp-display') : undefined;
  const urlFormParams = new URLSearchParams();
  const headers = new Headers();
  urlFormParams.append('grant_type', grantType);
  if (grantType === 'authorization_code') {
    urlFormParams.append('client_id', clientId);
    urlFormParams.append('client_secret', clientSecret);
  }
  if (grantType !== 'client_credentials' && grantType !== 'password') {
    urlFormParams.append('redirect_uri', redirectUrl);
  }
  if (authCode) {
    urlFormParams.append('code', authCode);
    urlFormParams.append('code_verifier', codeVerifier); // for PKCE
  }
  if (sendClientSecretIn === 'header') {
    headers.set('Authorization', `Basic ${Buffer.from(`${clientId}:${clientSecret}`, 'utf8').toString('base64')}`);
  } else if (grantType !== 'authorization_code') {
    urlFormParams.append('client_id', clientId);
    urlFormParams.append('client_secret', clientSecret);
  }
  if (grantType === 'password') {
    urlFormParams.append('username', username);
    urlFormParams.append('password', password);
  }
  if (scopes) {
    urlFormParams.append('scope', scopes);
  }
  try {
    const resp = await fetch(tokenUrl, {
      method: 'POST',
      headers,
      body: urlFormParams
    });
    const tokenResp = await resp.json();
    if (resp.ok) {
      if (tokenResp.token_type && tokenResp.access_token) {
        updateOAuthKey.call(this, securitySchemeId, tokenResp.access_token, tokenResp.token_type);
        if (respDisplayEl) {
          respDisplayEl.innerHTML = '<span style="color:var(--green)">Access Token Received</span>';
        }
        return true;
      }
    } else {
      if (respDisplayEl) {
        respDisplayEl.innerHTML = `<span style="color:var(--red)">${tokenResp.error_description || tokenResp.error_description || 'Unable to get access token'}</span>`;
      }
      return false;
    }
  } catch {
    if (respDisplayEl) {
      respDisplayEl.innerHTML = '<span style="color:var(--red)">Failed to get access token</span>';
    }
    return false;
  }
}

// Gets invoked when it receives the Authorization Code from the other window via message-event
async function onWindowMessageEvent(msgEvent, winObj, tokenUrl, clientId, clientSecret, redirectUrl, grantType, sendClientSecretIn, securitySchemeId, authFlowDivEl) {
  sessionStorage.removeItem('winMessageEventActive');
  winObj.close();
  if (msgEvent.data.fake) {
    return;
  }
  if (!msgEvent.data) {
    console.warn('RapiDoc: Received no data with authorization message');
  }
  if (msgEvent.data.error) {
    console.warn('RapiDoc: Error while receiving data');
  }
  if (msgEvent.data) {
    if (msgEvent.data.responseType === 'code') {
      // Authorization Code flow
      fetchAccessToken.call(this, tokenUrl, clientId, clientSecret, redirectUrl, grantType, msgEvent.data.code, securitySchemeId, authFlowDivEl, sendClientSecretIn);
    } else if (msgEvent.data.responseType === 'token') {
      // Implicit flow
      updateOAuthKey.call(this, securitySchemeId, msgEvent.data.access_token, msgEvent.data.token_type);
    }
  }
}

// code_challenge generator for PKCE flow
// TODO: Implement dynamic generation of code-challenge based on code-verifier
/*
async function generateCodeChallenge() {
  const encoder = new TextEncoder();
  const data = encoder.encode(codeVerifier);
  const sha256Hash = await window.crypto.subtle.digest('SHA-256', data); // returns Unit8Array
  // const utf8Decoder = new TextDecoder();
  // const b64EncodedSha256 = btoa(utf8Decoder.decode(sha256Hash));
  const b64EncodedSha256 = base64encode(sha256Hash);
  return b64EncodedSha256;
}
*/

async function onInvokeOAuthFlow(securitySchemeId, flowType, authUrl, tokenUrl, e) {
  const authFlowDivEl = e.target.closest('.oauth-flow');
  const clientId = authFlowDivEl.querySelector('.oauth-client-id') ? authFlowDivEl.querySelector('.oauth-client-id').value.trim() : '';
  const clientSecret = authFlowDivEl.querySelector('.oauth-client-secret') ? authFlowDivEl.querySelector('.oauth-client-secret').value.trim() : '';
  const username = authFlowDivEl.querySelector('.api-key-user') ? authFlowDivEl.querySelector('.api-key-user').value.trim() : '';
  const password = authFlowDivEl.querySelector('.api-key-password') ? authFlowDivEl.querySelector('.api-key-password').value.trim() : '';
  const sendClientSecretIn = authFlowDivEl.querySelector('.oauth-send-client-secret-in') ? authFlowDivEl.querySelector('.oauth-send-client-secret-in').value.trim() : 'header';
  const checkedScopeEls = [...authFlowDivEl.querySelectorAll('.scope-checkbox:checked')];
  const pkceCheckboxEl = authFlowDivEl.querySelector(`#${securitySchemeId}-pkce`);
  const state = `${Math.random().toString(36).slice(2, 9)}random${Math.random().toString(36).slice(2, 9)}`;
  const nonce = `${Math.random().toString(36).slice(2, 9)}random${Math.random().toString(36).slice(2, 9)}`;
  // const codeChallenge = await generateCodeChallenge(codeVerifier);
  const redirectUrlObj = new URL(`${window.location.origin}${window.location.pathname.substring(0, window.location.pathname.lastIndexOf('/'))}/${this.oauthReceiver}`);
  let grantType = '';
  let responseType = '';
  let newWindow;

  // clear previous error messages
  const errEls = [...authFlowDivEl.parentNode.querySelectorAll('.oauth-resp-display')];
  errEls.forEach(v => {
    v.innerHTML = '';
  });
  if (flowType === 'authorizationCode' || flowType === 'implicit') {
    const authUrlObj = new URL(authUrl);
    if (flowType === 'authorizationCode') {
      grantType = 'authorization_code';
      responseType = 'code';
    } else if (flowType === 'implicit') {
      responseType = 'token';
    }
    const authCodeParams = new URLSearchParams(authUrlObj.search);
    const selectedScopes = checkedScopeEls.map(v => v.value).join(' ');
    if (selectedScopes) {
      authCodeParams.set('scope', selectedScopes);
    }
    authCodeParams.set('client_id', clientId);
    authCodeParams.set('redirect_uri', redirectUrlObj.toString());
    authCodeParams.set('response_type', responseType);
    authCodeParams.set('state', state);
    authCodeParams.set('nonce', nonce);
    if (pkceCheckboxEl && pkceCheckboxEl.checked) {
      authCodeParams.set('code_challenge', codeChallenge);
      authCodeParams.set('code_challenge_method', 'S256');
    }
    authCodeParams.set('show_dialog', true);
    authUrlObj.search = authCodeParams.toString();
    // If any older message-event-listener is active then fire a fake message to remove it (these are single time listeners)
    if (sessionStorage.getItem('winMessageEventActive') === 'true') {
      window.postMessage({
        fake: true
      }, this);
    }
    setTimeout(() => {
      newWindow = window.open(authUrlObj.toString());
      if (!newWindow) {
        console.error(`RapiDoc: Unable to open ${authUrlObj.toString()} in a new window`);
      } else {
        sessionStorage.setItem('winMessageEventActive', 'true');
        window.addEventListener('message', msgEvent => onWindowMessageEvent.call(this, msgEvent, newWindow, tokenUrl, clientId, clientSecret, redirectUrlObj.toString(), grantType, sendClientSecretIn, securitySchemeId, authFlowDivEl), {
          once: true
        });
      }
    }, 10);
  } else if (flowType === 'clientCredentials') {
    grantType = 'client_credentials';
    const selectedScopes = checkedScopeEls.map(v => v.value).join(' ');
    fetchAccessToken.call(this, tokenUrl, clientId, clientSecret, redirectUrlObj.toString(), grantType, '', securitySchemeId, authFlowDivEl, sendClientSecretIn, selectedScopes);
  } else if (flowType === 'password') {
    grantType = 'password';
    const selectedScopes = checkedScopeEls.map(v => v.value).join(' ');
    fetchAccessToken.call(this, tokenUrl, clientId, clientSecret, redirectUrlObj.toString(), grantType, '', securitySchemeId, authFlowDivEl, sendClientSecretIn, selectedScopes, username, password);
  }
}
/* eslint-enable no-console */

/* eslint-disable indent */

function oAuthFlowTemplate(flowName, clientId, clientSecret, securitySchemeId, authFlow, defaultScopes = [], receiveTokenIn = 'header', receiveTokenInOptions = undefined) {
  var _this$selectedServer;
  let {
    authorizationUrl,
    tokenUrl,
    refreshUrl
  } = authFlow;
  const pkceOnly = authFlow['x-pkce-only'] || false;
  const isUrlAbsolute = url => url.indexOf('://') > 0 || url.indexOf('//') === 0;
  // Calculcate base URL
  const url = new URL((_this$selectedServer = this.selectedServer) === null || _this$selectedServer === void 0 ? void 0 : _this$selectedServer.computedUrl);
  const baseUrl = url.origin;
  if (refreshUrl && !isUrlAbsolute(refreshUrl)) {
    refreshUrl = `${baseUrl}/${refreshUrl.replace(/^\//, '')}`;
  }
  if (tokenUrl && !isUrlAbsolute(tokenUrl)) {
    tokenUrl = `${baseUrl}/${tokenUrl.replace(/^\//, '')}`;
  }
  if (authorizationUrl && !isUrlAbsolute(authorizationUrl)) {
    authorizationUrl = `${baseUrl}/${authorizationUrl.replace(/^\//, '')}`;
  }
  let flowNameDisplay;
  if (flowName === 'authorizationCode') {
    flowNameDisplay = 'Authorization Code Flow';
  } else if (flowName === 'clientCredentials') {
    flowNameDisplay = 'Client Credentials Flow';
  } else if (flowName === 'implicit') {
    flowNameDisplay = 'Implicit Flow';
  } else if (flowName === 'password') {
    flowNameDisplay = 'Password Flow';
  } else {
    flowNameDisplay = flowName;
  }
  return ke`
    <div class="oauth-flow ${flowName}" style="padding: 12px 0; margin-bottom:12px;">
      <div class="tiny-title upper" style="margin-bottom:8px;">${flowNameDisplay}</div>
      ${authorizationUrl ? ke`<div style="margin-bottom:5px"><span style="width:75px; display: inline-block;">Auth URL</span> <span class="mono-font"> ${authorizationUrl} </span></div>` : ''}
      ${tokenUrl ? ke`<div style="margin-bottom:5px"><span style="width:75px; display: inline-block;">Token URL</span> <span class="mono-font">${tokenUrl}</span></div>` : ''}
      ${refreshUrl ? ke`<div style="margin-bottom:5px"><span style="width:75px; display: inline-block;">Refresh URL</span> <span class="mono-font">${refreshUrl}</span></div>` : ''}
      ${flowName === 'authorizationCode' || flowName === 'clientCredentials' || flowName === 'implicit' || flowName === 'password' ? ke`
          ${authFlow.scopes ? ke`
              <span> Scopes </span>
              <div class= "oauth-scopes" part="section-auth-scopes" style = "width:100%; display:flex; flex-direction:column; flex-wrap:wrap; margin:0 0 10px 24px">
                ${Object.entries(authFlow.scopes).map((scopeAndDescr, index) => ke`
                  <div class="m-checkbox" style="display:inline-flex; align-items:center">
                    <input type="checkbox" part="checkbox checkbox-auth-scope" class="scope-checkbox" id="${securitySchemeId}${flowName}${index}" ?checked="${defaultScopes.includes(scopeAndDescr[0])}" value="${scopeAndDescr[0]}">
                    <label for="${securitySchemeId}${flowName}${index}" style="margin-left:5px; cursor:pointer">
                      <span class="mono-font">${scopeAndDescr[0]}</span>
                        ${scopeAndDescr[0] !== scopeAndDescr[1] ? ` - ${scopeAndDescr[1] || ''}` : ''}
                    </label>
                  </div>
                `)}
              </div>
            ` : ''}
          ${flowName === 'password' ? ke`
              <div style="margin:5px 0">
                <input type="text" value = "" placeholder="username" spellcheck="false" class="oauth2 ${flowName} ${securitySchemeId} api-key-user" part="textbox textbox-username" id="input-${securitySchemeId}-${flowName}-api-key-user">
                <input type="password" value = "" placeholder="password" spellcheck="false" class="oauth2 ${flowName} ${securitySchemeId} api-key-password" style = "margin:0 5px;" part="textbox textbox-password" id="input-${securitySchemeId}-${flowName}-api-key-password">
              </div>` : ''}
          <div>
            ${flowName === 'authorizationCode' ? ke`
                <div style="margin: 16px 0 4px">
                  <input type="checkbox" part="checkbox checkbox-auth-scope" id="${securitySchemeId}-pkce" checked ?disabled=${pkceOnly}>
                  <label for="${securitySchemeId}-pkce" style="margin:0 16px 0 4px; line-height:24px; cursor:pointer">
                   Send Proof Key for Code Exchange (PKCE)
                  </label>
                </div>
              ` : ''}
            <input type="text" part="textbox textbox-auth-client-id" value = "${clientId || ''}" placeholder="client-id" spellcheck="false" class="oauth2 ${flowName} ${securitySchemeId} oauth-client-id">
            ${flowName === 'authorizationCode' || flowName === 'clientCredentials' || flowName === 'password' ? ke`
                <input
                  id="${securitySchemeId}-${flowName}-oauth-client-secret"
                  type="password" part="textbox textbox-auth-client-secret"
                  value = "${clientSecret || ''}" placeholder="client-secret" spellcheck="false"
                  class="oauth2 ${flowName} ${securitySchemeId}
                  oauth-client-secret"
                  style = "margin:0 5px;${pkceOnly ? 'display:none;' : ''}"
                >
                <select style="margin-right:5px;${pkceOnly ? 'display:none;' : ''}" class="${flowName} ${securitySchemeId} oauth-send-client-secret-in">
                   ${!receiveTokenInOptions || receiveTokenInOptions.includes('header') ? ke`<option value = 'header' .selected = ${receiveTokenIn === 'header'} > Authorization Header </option>` : ''}
                   ${!receiveTokenInOptions || receiveTokenInOptions.includes('request-body') ? ke` <option value = 'request-body' .selected = ${receiveTokenIn === 'request-body'}> Request Body </option>` : ''}
                </select>` : ''}
            ${flowName === 'authorizationCode' || flowName === 'clientCredentials' || flowName === 'implicit' || flowName === 'password' ? ke`
                <button class="m-btn thin-border" part="btn btn-outline"
                  @click="${e => {
    onInvokeOAuthFlow.call(this, securitySchemeId, flowName, authorizationUrl, tokenUrl, e);
  }}"
                > GET TOKEN </button>` : ''}
          </div>
          <div class="oauth-resp-display red-text small-font-size"></div>
          ` : ''}
    </div>
  `;
}
function removeApiKey(securitySchemeId) {
  var _this$resolvedSpec$se3;
  const securityObj = (_this$resolvedSpec$se3 = this.resolvedSpec.securitySchemes) === null || _this$resolvedSpec$se3 === void 0 ? void 0 : _this$resolvedSpec$se3.find(v => v.securitySchemeId === securitySchemeId);
  securityObj.user = '';
  securityObj.password = '';
  securityObj.value = '';
  securityObj.finalKeyValue = '';
  if (this.persistAuth === 'true') {
    const rapidocLs = getPersistedApiKeys.call(this);
    delete rapidocLs[securityObj.securitySchemeId];
    setPersistedApiKeys.call(this, rapidocLs);
  }
  this.requestUpdate();
}
function securitySchemeTemplate() {
  var _this$resolvedSpec$se4;
  if (!this.resolvedSpec) {
    return '';
  }
  const providedApiKeys = (_this$resolvedSpec$se4 = this.resolvedSpec.securitySchemes) === null || _this$resolvedSpec$se4 === void 0 ? void 0 : _this$resolvedSpec$se4.filter(v => v.finalKeyValue);
  if (!providedApiKeys) {
    return;
  }
  return ke`
  <section id='auth' part="section-auth" style="text-align:left; direction:ltr; margin-top:24px; margin-bottom:24px;" class = 'observe-me ${'read focused'.includes(this.renderStyle) ? 'section-gap--read-mode' : 'section-gap '}'>
    <div class='sub-title regular-font'> AUTHENTICATION </div>

    <div class="small-font-size" style="display:flex; align-items: center; min-height:30px">
      ${providedApiKeys.length > 0 ? ke`
          <div class="blue-text"> ${providedApiKeys.length} API key applied </div>
          <div style="flex:1"></div>
          <button class="m-btn thin-border" part="btn btn-outline" @click=${() => {
    onClearAllApiKeys.call(this);
  }}>CLEAR ALL API KEYS</button>` : ke`<div class="red-text">No API key applied</div>`}
    </div>
    ${this.resolvedSpec.securitySchemes && this.resolvedSpec.securitySchemes.length > 0 ? ke`
        <table role="presentation" id="auth-table" class='m-table padded-12' style="width:100%;">
          ${this.resolvedSpec.securitySchemes.filter(v => v.type).map(v => {
    var _v$scheme, _v$scheme2;
    return ke`
            <tr id="security-scheme-${v.securitySchemeId}" class="${v.type.toLowerCase()}">
              <td style="max-width:500px; overflow-wrap: break-word;">
                <div style="line-height:28px; margin-bottom:5px;">
                  <span style="font-weight:bold; font-size:var(--font-size-regular)">${v.typeDisplay}</span>
                  ${v.finalKeyValue ? ke`
                      <span class='blue-text'>  ${v.finalKeyValue ? 'Key Applied' : ''} </span>
                      <button class="m-btn thin-border small" part="btn btn-outline" @click=${() => {
      removeApiKey.call(this, v.securitySchemeId);
    }}>REMOVE</button>
                      ` : ''}
                </div>
                ${v.description ? ke`
                    <div class="m-markdown">
                      ${unsafe_html_ae(marked(v.description || ''))}
                    </div>` : ''}

                ${v.type.toLowerCase() === 'apikey' || v.type.toLowerCase() === 'http' && ((_v$scheme = v.scheme) === null || _v$scheme === void 0 ? void 0 : _v$scheme.toLowerCase()) === 'bearer' ? ke`
                    <div style="margin-bottom:5px">
                      ${v.type.toLowerCase() === 'apikey' ? ke`Send <code>${v.name}</code> in <code>${v.in}</code>` : ke`Send <code>Authorization</code> in <code>header</code> containing the word <code>Bearer</code> followed by a space and a Token String.`}
                    </div>
                    <div style="max-height:28px;">
                      ${v.in !== 'cookie' ? ke`
                          <input type = "text" value = "${v.value}" class="${v.type} ${v.securitySchemeId} api-key-input" placeholder = "api-token" spellcheck = "false" id = "${v.type}-${v.securitySchemeId}-api-key-input">
                          <button class="m-btn thin-border" style = "margin-left:5px;"
                            part = "btn btn-outline"
                            @click="${e => {
      onApiKeyChange.call(this, v.securitySchemeId, e);
    }}">
                            ${v.finalKeyValue ? 'UPDATE' : 'SET'}
                          </button>` : ke`<span class="gray-text" style="font-size::var(--font-size-small)"> cookies cannot be set from here</span>`}
                    </div>` : ''}
                ${v.type.toLowerCase() === 'http' && ((_v$scheme2 = v.scheme) === null || _v$scheme2 === void 0 ? void 0 : _v$scheme2.toLowerCase()) === 'basic' ? ke`
                    <div style="margin-bottom:5px">
                      Send <code>Authorization</code> in <code>header</code> containing the word <code>Basic</code> followed by a space and a base64 encoded string of <code>username:password</code>.
                    </div>
                    <div>
                      <input type="text" value = "${v.user}" placeholder="username" spellcheck="false" class="${v.type} ${v.securitySchemeId} api-key-user" style="width:100px" id = "input-${v.type}-${v.securitySchemeId}-api-key-user">
                      <input type="password" value = "${v.password}" placeholder="password" spellcheck="false" class="${v.type} ${v.securitySchemeId} api-key-password" style = "width:100px; margin:0 5px;" id = "input-${v.type}-${v.securitySchemeId}-api-key-password">
                      <button class="m-btn thin-border"
                        @click="${e => {
      onApiKeyChange.call(this, v.securitySchemeId, e);
    }}"
                        part = "btn btn-outline"
                      >
                        ${v.finalKeyValue ? 'UPDATE' : 'SET'}
                      </button>
                    </div>` : ''}
              </td>
            </tr>
            ${v.type.toLowerCase() === 'oauth2' ? ke`
                <tr>
                  <td style="border:none; padding-left:48px">
                    ${Object.keys(v.flows).map(f => oAuthFlowTemplate.call(this, f, v.flows[f]['x-client-id'] || v['x-client-id'] || '', v.flows[f]['x-client-secret'] || v['x-client-secret'] || '', v.securitySchemeId, v.flows[f], v.flows[f]['x-default-scopes'] || v['x-default-scopes'], v.flows[f]['x-receive-token-in'] || v['x-receive-token-in'], v.flows[f]['x-receive-token-in-options'] || v['x-receive-token-in-options']))}
                  </td>
                </tr>
                ` : ''}
          `;
  })}
        </table>` : ''}
    <slot name="auth"></slot>
  </section>
`;
}
function pathSecurityTemplate(pathSecurity) {
  if (this.resolvedSpec.securitySchemes && pathSecurity) {
    const orSecurityKeys1 = [];
    if (Array.isArray(pathSecurity)) {
      if (pathSecurity.length === 0) {
        return '';
      }
    } else {
      return '';
    }
    pathSecurity.forEach(pSecurity => {
      const andSecurityKeys1 = [];
      const andKeyTypes = [];
      if (Object.keys(pSecurity).length === 0) {
        orSecurityKeys1.push({
          securityTypes: 'None',
          securityDefs: []
        });
      } else {
        Object.keys(pSecurity).forEach(pathSecurityKey => {
          let pathScopes = '';
          const s = this.resolvedSpec.securitySchemes.find(ss => ss.securitySchemeId === pathSecurityKey);
          if (pSecurity[pathSecurityKey] && Array.isArray(pSecurity[pathSecurityKey])) {
            pathScopes = pSecurity[pathSecurityKey].join(', ');
          }
          if (s) {
            andKeyTypes.push(s.typeDisplay);
            andSecurityKeys1.push({
              ...s,
              ...{
                scopes: pathScopes
              }
            });
          }
        });
        orSecurityKeys1.push({
          securityTypes: andKeyTypes.length > 1 ? `${andKeyTypes[0]} + ${andKeyTypes.length - 1} more` : andKeyTypes[0],
          securityDefs: andSecurityKeys1
        });
      }
    });
    return ke`<div style="position:absolute; top:3px; right:2px; font-size:var(--font-size-small); line-height: 1.5;">
      <div style="position:relative; display:flex; min-width:350px; max-width:700px; justify-content: flex-end;">
        <svg width="24" height="24" viewBox="0 0 24 24" stroke-width="1.5" fill="none" style="stroke:var(--fg3)"> <rect x="5" y="11" width="14" height="10" rx="2" /> <circle cx="12" cy="16" r="1" /> <path d="M8 11v-4a4 4 0 0 1 8 0v4" /></svg>
          ${orSecurityKeys1.map((orSecurityItem1, i) => ke`
          ${orSecurityItem1.securityTypes ? ke`
              ${i !== 0 ? ke`<div style="padding:3px 4px;"> OR </div>` : ''}
              <div class="tooltip">
                <div style = "padding:2px 4px; white-space:nowrap; text-overflow:ellipsis;max-width:150px; overflow:hidden;">
                  ${this.updateRoute === 'true' && this.allowAuthentication === 'true' ? ke`<a part="anchor anchor-operation-security" href="#auth"> ${orSecurityItem1.securityTypes} </a>` : ke`${orSecurityItem1.securityTypes}`}
                </div>
                <div class="tooltip-text" style="position:absolute; color: var(--fg); top:26px; right:0; border:1px solid var(--border-color);padding:2px 4px; display:block;">
                  ${orSecurityItem1.securityDefs.length > 1 ? ke`<div>Requires <b>all</b> of the following </div>` : ''}
                  <div style="padding-left: 8px">
                    ${orSecurityItem1.securityDefs.map((andSecurityItem, j) => {
      const scopeHtml = ke`${andSecurityItem.scopes !== '' ? ke`
                          <div>
                            <b>Required scopes:</b>
                            <br/>
                            <div style="margin-left:8px">
                              ${andSecurityItem.scopes.split(',').map((scope, cnt) => ke`${cnt === 0 ? '' : '┃'}<span>${scope}</span>`)}
                            </div>
                          </div>` : ''}`;
      return ke`
                      ${andSecurityItem.type === 'oauth2' ? ke`
                          <div>
                            ${orSecurityItem1.securityDefs.length > 1 ? ke`<b>${j + 1}.</b> &nbsp;` : 'Needs'}
                            OAuth Token <span style="font-family:var(--font-mono); color:var(--primary-color);">${andSecurityItem.securitySchemeId}</span> in <b>Authorization header</b>
                            ${scopeHtml}
                          </div>` : andSecurityItem.type === 'http' ? ke`
                            <div>
                              ${orSecurityItem1.securityDefs.length > 1 ? ke`<b>${j + 1}.</b> &nbsp;` : ke`Requires`}
                              ${andSecurityItem.scheme === 'basic' ? 'Base 64 encoded username:password' : 'Bearer Token'} in <b>Authorization header</b>
                              ${scopeHtml}
                            </div>` : ke`
                            <div>
                              ${orSecurityItem1.securityDefs.length > 1 ? ke`<b>${j + 1}.</b> &nbsp;` : ke`Requires`}
                              Token in <b>${andSecurityItem.name} ${andSecurityItem.in}</b>
                              ${scopeHtml}
                            </div>`}`;
    })}
                  </div>
                </div>
              </div>
            ` : ''}
        `)}
      </div>
      </div>
    `;
  }
  return '';
}

/* eslint-enable indent */
;// ./src/templates/code-samples-template.js

 // eslint-disable-line import/extensions



/* eslint-disable indent */
function codeSamplesTemplate(xCodeSamples) {
  return ke`
  <section class="table-title" style="margin-top:24px;">CODE SAMPLES</div>
  <div part="tab-panel" class="tab-panel col"
    @click="${e => {
    if (!e.target.classList.contains('tab-btn')) {
      return;
    }
    const clickedTab = e.target.dataset.tab;
    const tabButtons = [...e.currentTarget.querySelectorAll('.tab-btn')];
    const tabContents = [...e.currentTarget.querySelectorAll('.tab-content')];
    tabButtons.forEach(tabBtnEl => tabBtnEl.classList[tabBtnEl.dataset.tab === clickedTab ? 'add' : 'remove']('active'));
    tabContents.forEach(tabBodyEl => {
      tabBodyEl.style.display = tabBodyEl.dataset.tab === clickedTab ? 'block' : 'none';
    });
  }}">
    <div part="tab-btn-row" class="tab-buttons row" style="width:100; overflow">
      ${xCodeSamples.map((v, i) => ke`<button part="tab-btn" class="tab-btn ${i === 0 ? 'active' : ''}" data-tab = '${v.lang}${i}'> ${v.label || v.lang} </button>`)}
    </div>
    ${xCodeSamples.map((v, i) => {
    var _v$lang, _v$lang2, _v$lang3;
    return ke`
      <div class="tab-content m-markdown" style= "display:${i === 0 ? 'block' : 'none'}" data-tab = '${v.lang}${i}'>
        <button class="toolbar-btn" style = "position:absolute; top:12px; right:8px" @click='${e => {
      copyToClipboard(v.source, e);
    }}'> Copy </button>
        <pre><code class="language">${(prism_default()).languages[(_v$lang = v.lang) === null || _v$lang === void 0 ? void 0 : _v$lang.toLowerCase()] ? unsafe_html_ae(prism_default().highlight(v.source, (prism_default()).languages[(_v$lang2 = v.lang) === null || _v$lang2 === void 0 ? void 0 : _v$lang2.toLowerCase()], (_v$lang3 = v.lang) === null || _v$lang3 === void 0 ? void 0 : _v$lang3.toLowerCase())) : v.source}</code></pre>
      </div>`;
  })}
  </div>  
  </section>`;
}
/* eslint-enable indent */
;// ./src/templates/callback-template.js


/* eslint-disable indent */
function callbackTemplate(callbacks) {
  return ke`
    <div class="req-res-title" style="margin-top:12px">CALLBACKS</div>
    ${Object.entries(callbacks).map(kv => ke`
      <div class="tiny-title" style="padding: 12px; border:1px solid var(--light-border-color)"> 
        ${kv[0]}
        ${Object.entries(kv[1]).map(pathObj => ke`
          <div class="mono-font small-font-size" style="display:flex; margin-left:16px;">
            <div style="width:100%"> 
              ${Object.entries(pathObj[1]).map(method => {
    var _method$, _method$2, _method$3;
    return ke`
                <div>
                  <div style="margin-top:12px;">
                    <div class="method method-fg ${method[0]}" style="width:70px; border:none; margin:0; padding:0; line-height:20px; vertical-align: baseline;text-align:left"> 
                      <span style="font-size:20px;"> &#x2944; </span> 
                      ${method[0]} 
                    </div>
                    <span style="line-height:20px; vertical-align: baseline;">${pathObj[0]} </span>
                  </div>  
                  <div class='expanded-req-resp-container'>
                    <api-request
                      class = "${this.renderStyle}-mode callback"  
                      style = "width:100%;"
                      callback = "true"
                      method = "${method[0] || ''}", 
                      path = "${pathObj[0] || ''}" 
                      .parameters = "${((_method$ = method[1]) === null || _method$ === void 0 ? void 0 : _method$.parameters) || ''}" 
                      .request_body = "${((_method$2 = method[1]) === null || _method$2 === void 0 ? void 0 : _method$2.requestBody) || ''}"
                      fill-request-fields-with-example = "${this.fillRequestFieldsWithExample}"
                      allow-try = "false"
                      render-style="${this.renderStyle}" 
                      schema-style = "${this.schemaStyle}"
                      active-schema-tab = "${this.defaultSchemaTab}"
                      schema-expand-level = "${this.schemaExpandLevel}"
                      schema-description-expanded = "${this.schemaDescriptionExpanded}"
                      allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
                      schema-hide-read-only = "false"
                      schema-hide-write-only = "${this.schemaHideWriteOnly === 'never' ? 'false' : 'true'}"
                      fetch-credentials = "${this.fetchCredentials}"
                      exportparts = "wrap-request-btn:wrap-request-btn, btn:btn, btn-fill:btn-fill, btn-outline:btn-outline, btn-try:btn-try, btn-clear:btn-clear, btn-clear-resp:btn-clear-resp,
                        tab-panel:tab-panel, tab-btn:tab-btn, tab-btn-row:tab-btn-row, tab-coontent:tab-content, 
                        file-input:file-input, textbox:textbox, textbox-param:textbox-param, textarea:textarea, textarea-param:textarea-param, 
                        anchor:anchor, anchor-param-example:anchor-param-example, schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
                      > </api-request>

                    <api-response
                      style = "width:100%;"
                      class = "${this.renderStyle}-mode"
                      callback = "true"
                      .responses="${(_method$3 = method[1]) === null || _method$3 === void 0 ? void 0 : _method$3.responses}"
                      render-style="${this.renderStyle}"
                      schema-style="${this.schemaStyle}"
                      active-schema-tab = "${this.defaultSchemaTab}"
                      schema-expand-level = "${this.schemaExpandLevel}"
                      schema-description-expanded = "${this.schemaDescriptionExpanded}"
                      allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
                      schema-hide-read-only = "${this.schemaHideReadOnly === 'never' ? 'false' : 'true'}"
                      schema-hide-write-only = "false"
                      exportparts = "btn:btn, btn-response-status:btn-response-status, btn-selected-response-status:btn-selected-response-status, btn-fill:btn-fill, btn-copy:btn-copy,
                        tab-panel:tab-panel, tab-btn:tab-btn, tab-btn-row:tab-btn-row, tab-coontent:tab-content, 
                        schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
                    > </api-response>
                  </div>
                </div>  
              `;
  })}
            </div>  
          </div>  
        `)}
      </div>  
    `)}
  `;
}
/* eslint-enable indent */
;// ./node_modules/lit-html/directives/guard.js

/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */
const guard_Vt={},guard_It=directive_e(class extends directive_i{constructor(){super(...arguments),this.ot=guard_Vt}render(r,t){return t()}update(r,[t,s]){if(Array.isArray(t)){if(Array.isArray(this.ot)&&this.ot.length===t.length&&t.every(((r,t)=>r===this.ot[t])))return R}else if(this.ot===t)return R;return this.ot=Array.isArray(t)?Array.from(t):t,this.render(t,s)}});
//# sourceMappingURL=guard.js.map

;// ./node_modules/lit/directives/guard.js

//# sourceMappingURL=guard.js.map

;// ./node_modules/lit-html/directive-helpers.js

/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const{I:directive_helpers_et}=si,directive_helpers_st=o=>null===o||"object"!=typeof o&&"function"!=typeof o,directive_helpers_no={HTML:1,SVG:2,MATHML:3},directive_helpers_nt=(o,t)=>void 0===t?void 0!==o?._$litType$:o?._$litType$===t,directive_helpers_ot=o=>null!=o?._$litType$?.h,directive_helpers_eo=o=>void 0!==o?._$litDirective$,directive_helpers_lo=o=>o?._$litDirective$,directive_helpers_rt=o=>void 0===o.strings,directive_helpers_lt=()=>document.createComment(""),directive_helpers_at=(o,t,i)=>{const n=o._$AA.parentNode,e=void 0===t?o._$AB:t._$AA;if(void 0===i){const t=n.insertBefore(directive_helpers_lt(),e),l=n.insertBefore(directive_helpers_lt(),e);i=new directive_helpers_et(t,l,o,o.options)}else{const t=i._$AB.nextSibling,l=i._$AM,c=l!==o;if(c){let t;i._$AQ?.(o),i._$AM=o,void 0!==i._$AP&&(t=o._$AU)!==l._$AU&&i._$AP(t)}if(t!==e||c){let o=i._$AA;for(;o!==t;){const t=o.nextSibling;n.insertBefore(o,e),o=t}}}return i},directive_helpers_ct=(o,t,i=o)=>(o._$AI(t,i),o),directive_helpers_ht={},directive_helpers_dt=(o,t=directive_helpers_ht)=>o._$AH=t,directive_helpers_ut=o=>o._$AH,directive_helpers_pt=o=>{o._$AP?.(!1,!0);let t=o._$AA;const i=o._$AB.nextSibling;for(;t!==i;){const o=t.nextSibling;t.remove(),t=o}},directive_helpers_ft=o=>{o._$AR()};
//# sourceMappingURL=directive-helpers.js.map

;// ./node_modules/lit-html/directives/live.js

/**
 * @license
 * Copyright 2020 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const live_Ft=directive_e(class extends directive_i{constructor(r){if(super(r),r.type!==directive_t.PROPERTY&&r.type!==directive_t.ATTRIBUTE&&r.type!==directive_t.BOOLEAN_ATTRIBUTE)throw Error("The `live` directive is not allowed on child or event bindings");if(!directive_helpers_rt(r))throw Error("`live` bindings can only contain a single expression")}render(r){return r}update(r,[e]){if(e===R||e===D)return e;const i=r.element,n=r.name;if(r.type===directive_t.PROPERTY){if(e===i[n])return R}else if(r.type===directive_t.BOOLEAN_ATTRIBUTE){if(!!e===i.hasAttribute(n))return R}else if(r.type===directive_t.ATTRIBUTE&&i.getAttribute(n)===e+"")return R;return directive_helpers_dt(r),e}});
//# sourceMappingURL=live.js.map

;// ./node_modules/lit/directives/live.js

//# sourceMappingURL=live.js.map

;// ./node_modules/lit-html/directives/if-defined.js

/**
 * @license
 * Copyright 2018 Google LLC
 * SPDX-License-Identifier: BSD-3-Clause
 */const if_defined_to=t=>t??D;
//# sourceMappingURL=if-defined.js.map

;// ./node_modules/lit/directives/if-defined.js

//# sourceMappingURL=if-defined.js.map

// EXTERNAL MODULE: ./node_modules/xml-but-prettier/dist/index.js
var dist = __webpack_require__(657);
var dist_default = /*#__PURE__*/__webpack_require__.n(dist);
;// ./src/styles/border-styles.js

/* harmony default export */ const border_styles = (i`
.border-top {
  border-top:1px solid var(--border-color);
}
.border{
  border:1px solid var(--border-color);
  border-radius: var(--border-radius);
}
.light-border{
  border:1px solid var(--light-border-color);
  border-radius: var(--border-radius);
}
.pad-8-16{
  padding: 8px 16px;
}
.pad-top-8 {
  padding-top: 8px;
}
.mar-top-8 {
  margin-top: 8px;
}
`);
// EXTERNAL MODULE: ./node_modules/randexp/lib/randexp.js
var randexp = __webpack_require__(859);
var randexp_default = /*#__PURE__*/__webpack_require__.n(randexp);
;// ./src/utils/schema-utils.js


// Make RandExp determinist
(randexp_default()).prototype.randInt = from => from;

// Takes a value as input and provides a printable string to replresent null values, spaces, blankstring etc
function getPrintableVal(val) {
  if (val === undefined) {
    return '';
  }
  if (val === null) {
    return 'null';
  }
  if (val === '') {
    return '∅';
  }
  if (typeof val === 'boolean' || typeof val === 'number') {
    return `${val}`;
  }
  if (Array.isArray(val)) {
    return val.map(v => v === null ? 'null' : v === '' ? '∅' : v.toString().replace(/^ +| +$/g, m => '●'.repeat(m.length)) || '').join(', ');
  }
  if (typeof val === 'object') {
    const keys = Object.keys(val);
    return `{ ${keys[0]}:${val[keys[0]]}${keys.length > 1 ? ',' : ''} ... }`;
  }
  return val.toString().replace(/^ +| +$/g, m => '●'.repeat(m.length)) || '';
}

/* Generates an schema object containing type and constraint info */
function getTypeInfo(schema) {
  if (!schema) {
    return;
  }
  let dataType = '';
  let constrain = '';
  // let examples;

  if (schema.$ref) {
    const n = schema.$ref.lastIndexOf('/');
    const schemaNode = schema.$ref.substring(n + 1);
    dataType = `{recursive: ${schemaNode}} `;
  } else if (schema.type) {
    dataType = Array.isArray(schema.type) ? schema.type.join(schema.length === 2 ? ' or ' : '┃') : schema.type;
    if (schema.format || schema.enum || schema.const) {
      dataType = dataType.replace('string', schema.enum ? 'enum' : schema.const ? 'const' : schema.format);
    }
    if (schema.nullable) {
      dataType += '┃null';
    }
  } else if (schema.const) {
    dataType = 'const';
  } else if (Object.keys(schema).length === 0) {
    dataType = 'any';
  } else {
    dataType = '{missing-type-info}';
  }
  const info = {
    type: dataType,
    format: schema.format || '',
    pattern: schema.pattern && !schema.enum ? schema.pattern : '',
    readOrWriteOnly: schema.readOnly ? '🆁' : schema.writeOnly ? '🆆' : '',
    deprecated: schema.deprecated ? '❌' : '',
    examples: schema.examples || schema.example,
    default: getPrintableVal(schema.default),
    description: schema.description || '',
    constrain: '',
    allowedValues: '',
    arrayType: '',
    html: ''
  };
  if (info.type === '{recursive}') {
    info.description = schema.$ref.substring(schema.$ref.lastIndexOf('/') + 1);
  } else if (info.type === '{missing-type-info}' || info.type === 'any') {
    info.description = info.description || '';
  }
  // Set Allowed Values
  info.allowedValues = schema.const ? schema.const : Array.isArray(schema.enum) ? schema.enum.map(v => getPrintableVal(v)).join('┃') : '';
  if (dataType === 'array' && schema.items) {
    var _schema$items, _schema$items2;
    const arrayItemType = (_schema$items = schema.items) === null || _schema$items === void 0 ? void 0 : _schema$items.type;
    const arrayItemDefault = getPrintableVal(schema.items.default);
    info.arrayType = `${schema.type} of ${Array.isArray(arrayItemType) ? arrayItemType.join('') : arrayItemType}`;
    info.default = arrayItemDefault;
    info.allowedValues = schema.items.const ? schema.const : Array.isArray((_schema$items2 = schema.items) === null || _schema$items2 === void 0 ? void 0 : _schema$items2.enum) ? schema.items.enum.map(v => getPrintableVal(v)).join('┃') : '';
  }
  if (dataType.match(/integer|number/g)) {
    if (schema.minimum !== undefined || schema.exclusiveMinimum !== undefined) {
      constrain += schema.minimum !== undefined ? `Min ${schema.minimum}` : `More than ${schema.exclusiveMinimum}`;
    }
    if (schema.maximum !== undefined || schema.exclusiveMaximum !== undefined) {
      constrain += schema.maximum !== undefined ? `${constrain ? '┃' : ''}Max ${schema.maximum}` : `${constrain ? '┃' : ''}Less than ${schema.exclusiveMaximum}`;
    }
    if (schema.multipleOf !== undefined) {
      constrain += `${constrain ? '┃' : ''} multiple of ${schema.multipleOf}`;
    }
  }
  if (dataType.match(/string/g)) {
    if (schema.minLength !== undefined && schema.maxLength !== undefined) {
      constrain += `${constrain ? '┃' : ''}${schema.minLength} to ${schema.maxLength} chars`;
    } else if (schema.minLength !== undefined) {
      constrain += `${constrain ? '┃' : ''}Min ${schema.minLength} chars`;
    } else if (schema.maxLength !== undefined) {
      constrain += `Max ${constrain ? '┃' : ''}${schema.maxLength} chars`;
    }
  }
  info.constrain = constrain;
  info.html = `${info.type}~|~${info.readOrWriteOnly}~|~${info.constrain}~|~${info.default}~|~${info.allowedValues}~|~${info.pattern}~|~${info.description}~|~${schema.title || ''}~|~${info.deprecated ? 'deprecated' : ''}`;
  return info;
}

/**
 *
 * @param {*} ex  if the value
 *  - Is an Object with 'value' property  like
 *      { 'value': 'example_val1', 'description': 'some description' }
 *    Returns >>>
 *      {
 *        'Example': { 'value' : 'example_val1', 'description': 'some description' },
 *      }
 *  - Is an object where each key represents a valid example object (i,e has a value property)
 *      {
 *        'example1': { 'value' : 'example_val1', 'description': 'some description' },
 *        'example2': { 'value' : 'example_val2', 'description': 'some other description' },
 *        'invalid':  { 'description': 'invalid example object without any value property' }
 *      }
 *    Returns >>>
 *      {
 *        'example1': { 'value' : 'example_val1', 'description': 'some description' },
 *        'example2': { 'value' : 'example_val2', 'description': 'some other description' }
 *      }
 *      if none of the keys represents an object with 'value' property then return undefined
 *  - Is an array of premitive values
 *      ['example_val1', 'example_val2']
 *    Returns >>>
 *      {
 *         'Example1': {value:'value1'}
 *         'Example2': {value:'value2'}
 *      }
 *  - Is a premitive value
 *      'example_val1'
 *    Returns >>>
 *      {
 *        'Example': { 'value': 'example_val1' }
 *      }
 *  - Is undefined
 *    returns undefined
 * @returns
 */

function standardizeExample(ex) {
  if (typeof ex === 'object' && !Array.isArray(ex)) {
    if (ex.value !== undefined) {
      // Case 1: Single object with 'value' property
      return {
        Example: {
          ...ex
        }
      };
    }
    // Case 2: Object where each key is an object with a 'value' property
    const filteredEntries = Object.entries(ex).filter(([_, obj]) => obj.value !== undefined); // eslint-disable-line
    // If no valid entries found, return JSON.stringify of the input
    if (filteredEntries.length === 0) {
      return undefined;
    }
    return Object.fromEntries(filteredEntries);
  }
  if (Array.isArray(ex)) {
    // Case 3: Array of primitive values
    return ex.reduce((acc, value, index) => {
      acc[`Example${index + 1}`] = {
        value
      };
      return acc;
    }, {});
  }
  // Case 4: Single primitive value
  return ex ? {
    Example: {
      value: ex
    }
  } : undefined;
}

/**
 *  Normalize example object in the following format (List of object which is used to render example links and fill the input boxes)
 *  [{
 *     exampleVal  : 'value to be rendered on the input control (text-box)',
 *     exampleList : [
 *       value         : '',
 *       printableValue: '',
 *       summary       : '',
 *       description   : ''
 *     ]
 *  }]
 * */
function normalizeExamples(examples, dataType = 'string') {
  if (!examples) {
    return {
      exampleVal: '',
      exampleList: []
    };
  }
  if (examples.constructor === Object) {
    const exampleList = Object.values(examples).filter(v => v['x-example-show-value'] !== false).map(v => ({
      value: typeof v.value === 'boolean' || typeof v.value === 'number' ? `${v.value}` : v.value || '',
      printableValue: getPrintableVal(v.value),
      summary: v.summary || '',
      description: v.description || ''
    }));
    const exampleVal = exampleList.length > 0 ? exampleList[0].value : '';
    return {
      exampleVal,
      exampleList
    };
  }

  // This is non-standard way to provide example but will support for now
  if (!Array.isArray(examples)) {
    examples = examples ? [examples] : [];
  }
  if (examples.length === 0) {
    return {
      exampleVal: '',
      exampleList: []
    };
  }
  if (dataType === 'array') {
    const [exampleVal] = examples;
    const exampleList = examples.map(v => ({
      value: v,
      printableValue: getPrintableVal(v)
    }));
    return {
      exampleVal,
      exampleList
    };
  }
  const exampleVal = examples[0].toString();
  const exampleList = examples.map(v => ({
    value: v.toString(),
    printableValue: getPrintableVal(v)
  }));
  return {
    exampleVal,
    exampleList
  };
}
function anyExampleWithSummaryOrDescription(examples) {
  return examples.some(x => {
    var _x$summary, _x$description;
    return ((_x$summary = x.summary) === null || _x$summary === void 0 ? void 0 : _x$summary.length) > 0 || ((_x$description = x.description) === null || _x$description === void 0 ? void 0 : _x$description.length) > 0;
  });
}
function getSampleValueByType(schemaObj) {
  const example = schemaObj.examples ? schemaObj.examples[0] : schemaObj.example === null ? null : schemaObj.example || undefined;
  if (example === '') {
    return '';
  }
  if (example === null) {
    return null;
  }
  if (example === 0) {
    return 0;
  }
  if (example === false) {
    return false;
  }
  if (example instanceof Date) {
    switch (schemaObj.format.toLowerCase()) {
      case 'date':
        return example.toISOString().split('T')[0];
      case 'time':
        return example.toISOString().split('T')[1];
      default:
        return example.toISOString();
    }
  }
  if (example) {
    return example;
  }
  if (Object.keys(schemaObj).length === 0) {
    return null;
  }
  if (schemaObj.$ref) {
    // Indicates a Circular ref
    return {};
  }
  if (schemaObj.const === false || schemaObj.const === 0 || schemaObj.const === null || schemaObj.const === '') {
    return schemaObj.const;
  }
  if (schemaObj.const) {
    return schemaObj.const;
  }
  if (schemaObj.default) {
    return schemaObj.default;
  }
  const typeValue = Array.isArray(schemaObj.type) ? schemaObj.type[0] : schemaObj.type;
  if (!typeValue) {
    return null;
  }
  if (typeValue.match(/^integer|^number/g)) {
    const multipleOf = Number.isNaN(Number(schemaObj.multipleOf)) ? undefined : Number(schemaObj.multipleOf);
    const maximum = Number.isNaN(Number(schemaObj.maximum)) ? undefined : Number(schemaObj.maximum);
    const minimumPossibleVal = Number.isNaN(Number(schemaObj.minimum)) ? Number.isNaN(Number(schemaObj.exclusiveMinimum)) ? maximum || 0 : Number(schemaObj.exclusiveMinimum) + (typeValue.startsWith('integer') ? 1 : 0.001) : Number(schemaObj.minimum);
    const finalVal = multipleOf ? multipleOf >= minimumPossibleVal ? multipleOf : minimumPossibleVal % multipleOf === 0 ? minimumPossibleVal : Math.ceil(minimumPossibleVal / multipleOf) * multipleOf : minimumPossibleVal;
    return finalVal;
  }
  if (typeValue.match(/^boolean/g)) {
    return false;
  }
  if (typeValue.match(/^null/g)) {
    return null;
  }
  if (typeValue.match(/^string/g)) {
    if (schemaObj.enum) {
      return schemaObj.enum[0];
    }
    if (schemaObj.const) {
      return schemaObj.const;
    }
    if (schemaObj.pattern) {
      try {
        return new (randexp_default())(schemaObj.pattern).gen();
      } catch {
        return schemaObj.pattern;
      }
    }
    if (schemaObj.format) {
      const u = `${Date.now().toString(16)}${Math.random().toString(16)}0`.repeat(16);
      switch (schemaObj.format.toLowerCase()) {
        case 'url':
        case 'uri':
          return 'http://example.com';
        case 'date':
          return new Date(0).toISOString().split('T')[0];
        case 'time':
          return new Date(0).toISOString().split('T')[1];
        case 'date-time':
          return new Date(0).toISOString();
        case 'duration':
          return 'P3Y6M4DT12H30M5S';
        // P=Period 3-Years 6-Months 4-Days 12-Hours 30-Minutes 5-Seconds
        case 'email':
        case 'idn-email':
          return 'user@example.com';
        case 'hostname':
        case 'idn-hostname':
          return 'www.example.com';
        case 'ipv4':
          return '198.51.100.42';
        case 'ipv6':
          return '2001:0db8:5b96:0000:0000:426f:8e17:642a';
        case 'uuid':
          return [u.substring(0, 8), u.substring(8, 12), `4000-8${u.substring(13, 16)}`, u.substring(16, 28)].join('-');
        case 'byte':
          return 'ZXhhbXBsZQ==';
        // 'example' base64 encoded. See https://spec.openapis.org/oas/v3.0.0#data-types
        default:
          return '';
      }
    } else {
      const minLength = Number.isNaN(schemaObj.minLength) ? undefined : Number(schemaObj.minLength);
      const maxLength = Number.isNaN(schemaObj.maxLength) ? undefined : Number(schemaObj.maxLength);
      const finalLength = minLength || (maxLength > 6 ? 6 : maxLength || undefined);
      return finalLength ? 'A'.repeat(finalLength) : 'string';
    }
  }
  // If type cannot be determined
  return null;
}

/*
json2xml- TestCase
  {
    'prop1' : 'one',
    'prop2' : 'two',
    'prop3' : [ 'a', 'b', 'c' ],
    'prop4' : {
      'ob1' : 'val-1',
      'ob2' : 'val-2'
    }
  }
  <root>
    <prop1>simple</prop1>
    <prop2>
      <0>a</0>
      <1>b</1>
      <2>c</2>
    </prop2>
    <prop3>
      <ob1>val-1</ob1>
      <ob2>val-2</ob2>
    </prop3>
  </root>
*/
function json2xml(obj, level = 1) {
  const indent = '  '.repeat(level);
  let xmlText = '';
  if (level === 1 && typeof obj !== 'object') {
    return `\n${indent}${obj.toString()}`;
  }
  for (const prop in obj) {
    const tagNameOrProp = obj[prop]['::XML_TAG'] || prop;
    let tagName = '';
    if (Array.isArray(obj[prop])) {
      tagName = tagNameOrProp[0]['::XML_TAG'] || `${prop}`;
    } else {
      tagName = tagNameOrProp;
    }
    if (prop.startsWith('::')) {
      continue;
    }
    if (Array.isArray(obj[prop])) {
      xmlText = `${xmlText}\n${indent}<${tagName}>${json2xml(obj[prop], level + 1)}\n${indent}</${tagName}>`;
    } else if (typeof obj[prop] === 'object') {
      xmlText = `${xmlText}\n${indent}<${tagName}>${json2xml(obj[prop], level + 1)}\n${indent}</${tagName}>`;
    } else {
      xmlText = `${xmlText}\n${indent}<${tagName}>${obj[prop].toString()}</${tagName}>`;
    }
  }
  return xmlText;
}
function addSchemaInfoToExample(schema, obj) {
  var _schema$xml, _schema$xml3;
  if (typeof obj !== 'object' || obj === null) {
    return;
  }
  if (schema.title) {
    obj['::TITLE'] = schema.title;
  }
  if (schema.description) {
    obj['::DESCRIPTION'] = schema.description;
  }
  if ((_schema$xml = schema.xml) !== null && _schema$xml !== void 0 && _schema$xml.name) {
    var _schema$xml2;
    obj['::XML_TAG'] = (_schema$xml2 = schema.xml) === null || _schema$xml2 === void 0 ? void 0 : _schema$xml2.name;
  }
  if ((_schema$xml3 = schema.xml) !== null && _schema$xml3 !== void 0 && _schema$xml3.wrapped) {
    var _schema$xml4;
    obj['::XML_WRAP'] = (_schema$xml4 = schema.xml) === null || _schema$xml4 === void 0 ? void 0 : _schema$xml4.wrapped.toString();
  }
}
function removeTitlesAndDescriptions(obj) {
  if (typeof obj !== 'object' || obj === null) {
    return;
  }
  delete obj['::TITLE'];
  delete obj['::DESCRIPTION'];
  delete obj['::XML_TAG'];
  delete obj['::XML_WRAP'];
  for (const k in obj) {
    removeTitlesAndDescriptions(obj[k]);
  }
}
function addPropertyExampleToObjectExamples(example, obj, propertyKey) {
  for (const key in obj) {
    obj[key][propertyKey] = example;
  }
}
function mergePropertyExamples(obj, propertyName, propExamples) {
  // Create an example for each variant of the propertyExample, merging them with the current (parent) example
  let i = 0;
  const maxCombinations = 10;
  const mergedObj = {};
  for (const exampleKey in obj) {
    for (const propExampleKey in propExamples) {
      mergedObj[`example-${i}`] = {
        ...obj[exampleKey]
      };
      mergedObj[`example-${i}`][propertyName] = propExamples[propExampleKey];
      i++;
      if (i >= maxCombinations) {
        break;
      }
    }
    if (i >= maxCombinations) {
      break;
    }
  }
  return mergedObj;
}

/* For changing JSON-Schema to a Sample Object, as per the schema (to generate examples based on schema) */
function schemaToSampleObj(schema, config = {}) {
  let obj = {};
  if (!schema) {
    return;
  }
  if (schema.allOf) {
    var _schema$allOf$, _schema$allOf$2;
    const objWithAllProps = {};
    if (schema.allOf.length === 1 && !((_schema$allOf$ = schema.allOf[0]) !== null && _schema$allOf$ !== void 0 && _schema$allOf$.properties) && !((_schema$allOf$2 = schema.allOf[0]) !== null && _schema$allOf$2 !== void 0 && _schema$allOf$2.items)) {
      // If allOf has single item and the type is not an object or array, then its a primitive
      if (schema.allOf[0].$ref) {
        return '{  }';
      }
      if (schema.allOf[0].readOnly && config.includeReadOnly) {
        const tempSchema = schema.allOf[0];
        return getSampleValueByType(tempSchema);
      }
      return;
    }
    schema.allOf.forEach(v => {
      if (v.type === 'object' || v.properties || v.allOf || v.anyOf || v.oneOf) {
        const partialObj = schemaToSampleObj(v, config);
        Object.assign(objWithAllProps, partialObj);
      } else if (v.type === 'array' || v.items) {
        const partialObj = [schemaToSampleObj(v, config)];
        Object.assign(objWithAllProps, partialObj);
      } else if (v.type) {
        const prop = `prop${Object.keys(objWithAllProps).length}`;
        objWithAllProps[prop] = getSampleValueByType(v);
      } else {
        return '';
      }
    });
    obj = objWithAllProps;
  } else if (schema.oneOf) {
    // 1. First create example with scheme.properties
    const objWithSchemaProps = {};
    if (schema.properties) {
      for (const propertyName in schema.properties) {
        var _schema$properties$pr;
        if (schema.properties[propertyName].properties || (_schema$properties$pr = schema.properties[propertyName].properties) !== null && _schema$properties$pr !== void 0 && _schema$properties$pr.items) {
          objWithSchemaProps[propertyName] = schemaToSampleObj(schema.properties[propertyName], config);
        } else {
          objWithSchemaProps[propertyName] = getSampleValueByType(schema.properties[propertyName]);
        }
      }
    }
    if (schema.oneOf.length > 0) {
      /*
      oneOf:
        - type: object
          properties:
            option1_PropA:
              type: string
            option1_PropB:
              type: string
        - type: object
          properties:
            option2_PropX:
              type: string
      properties:
        prop1:
          type: string
        prop2:
          type: string
          minLength: 10
       The aboove Schem should generate the following 2 examples
       Example-1
      {
        prop1: 'string',
        prop2: 'AAAAAAAAAA',       <-- min-length 10
        option1_PropA: 'string',
        option1_PropB: 'string'
      }
       Example-2
      {
        prop1: 'string',
        prop2: 'AAAAAAAAAA',       <-- min-length 10
        option2_PropX: 'string'
      }
      */
      let i = 0;
      // Merge all examples of each oneOf-schema
      for (const key in schema.oneOf) {
        const oneOfSamples = schemaToSampleObj(schema.oneOf[key], config);
        for (const sampleKey in oneOfSamples) {
          // 2. In the final example include a one-of item along with properties
          let finalExample;
          if (Object.keys(objWithSchemaProps).length > 0) {
            if (oneOfSamples[sampleKey] === null || typeof oneOfSamples[sampleKey] !== 'object') {
              // This doesn't really make sense since every oneOf schema _should_ be an object if there are common properties, so we'll skip this
              continue;
            } else {
              finalExample = Object.assign(oneOfSamples[sampleKey], objWithSchemaProps);
            }
          } else {
            finalExample = oneOfSamples[sampleKey];
          }
          obj[`example-${i}`] = finalExample;
          addSchemaInfoToExample(schema.oneOf[key], obj[`example-${i}`]);
          i++;
        }
      }
    }
  } else if (schema.anyOf) {
    // First generate values for regular properties
    let commonObj;
    if (schema.type === 'object' || schema.properties) {
      commonObj = {
        'example-0': {}
      };
      for (const propertyName in schema.properties) {
        if (schema.example) {
          commonObj = schema;
          break;
        }
        if (schema.properties[propertyName].deprecated && !config.includeDeprecated) {
          continue;
        }
        if (schema.properties[propertyName].readOnly && !config.includeReadOnly) {
          continue;
        }
        if (schema.properties[propertyName].writeOnly && !config.includeWriteOnly) {
          continue;
        }
        commonObj = mergePropertyExamples(commonObj, propertyName, schemaToSampleObj(schema.properties[propertyName], config));
      }
    }

    // Combine every variant of the regular properties with every variant of the anyOf samples
    let i = 0;
    for (const key in schema.anyOf) {
      const anyOfSamples = schemaToSampleObj(schema.anyOf[key], config);
      for (const sampleKey in anyOfSamples) {
        if (typeof commonObj !== 'undefined') {
          for (const commonKey in commonObj) {
            obj[`example-${i}`] = {
              ...commonObj[commonKey],
              ...anyOfSamples[sampleKey]
            };
          }
        } else {
          obj[`example-${i}`] = anyOfSamples[sampleKey];
        }
        addSchemaInfoToExample(schema.anyOf[key], obj[`example-${i}`]);
        i++;
      }
    }
  } else if (schema.type === 'object' || schema.properties) {
    obj['example-0'] = {};
    addSchemaInfoToExample(schema, obj['example-0']);
    if (schema.example) {
      obj['example-0'] = schema.example;
    } else {
      for (const propertyName in schema.properties) {
        var _schema$properties$pr2, _schema$properties$pr3, _schema$properties$pr4, _schema$properties$pr5, _schema$properties$pr6;
        if ((_schema$properties$pr2 = schema.properties[propertyName]) !== null && _schema$properties$pr2 !== void 0 && _schema$properties$pr2.deprecated && !config.includeDeprecated) {
          continue;
        }
        if ((_schema$properties$pr3 = schema.properties[propertyName]) !== null && _schema$properties$pr3 !== void 0 && _schema$properties$pr3.readOnly && !config.includeReadOnly) {
          continue;
        }
        if ((_schema$properties$pr4 = schema.properties[propertyName]) !== null && _schema$properties$pr4 !== void 0 && _schema$properties$pr4.writeOnly && !config.includeWriteOnly) {
          continue;
        }
        if (((_schema$properties$pr5 = schema.properties[propertyName]) === null || _schema$properties$pr5 === void 0 ? void 0 : _schema$properties$pr5.type) === 'array' || (_schema$properties$pr6 = schema.properties[propertyName]) !== null && _schema$properties$pr6 !== void 0 && _schema$properties$pr6.items) {
          var _schema$properties$pr7;
          if (schema.properties[propertyName].example) {
            addPropertyExampleToObjectExamples(schema.properties[propertyName].example, obj, propertyName);
          } else if ((_schema$properties$pr7 = schema.properties[propertyName]) !== null && _schema$properties$pr7 !== void 0 && (_schema$properties$pr7 = _schema$properties$pr7.items) !== null && _schema$properties$pr7 !== void 0 && _schema$properties$pr7.example) {
            // schemas and properties support single example but not multiple examples.
            addPropertyExampleToObjectExamples([schema.properties[propertyName].items.example], obj, propertyName);
          } else {
            const itemSamples = schemaToSampleObj(schema.properties[propertyName].items, config);
            if (config.useXmlTagForProp) {
              var _schema$properties$pr8, _schema$properties$pr9;
              const xmlTagName = ((_schema$properties$pr8 = schema.properties[propertyName].xml) === null || _schema$properties$pr8 === void 0 ? void 0 : _schema$properties$pr8.name) || propertyName;
              if ((_schema$properties$pr9 = schema.properties[propertyName].xml) !== null && _schema$properties$pr9 !== void 0 && _schema$properties$pr9.wrapped) {
                const wrappedItemSample = JSON.parse(`{ "${xmlTagName}" : { "${xmlTagName}" : ${JSON.stringify(itemSamples['example-0'])} } }`);
                obj = mergePropertyExamples(obj, xmlTagName, wrappedItemSample);
              } else {
                obj = mergePropertyExamples(obj, xmlTagName, itemSamples);
              }
            } else {
              const arraySamples = [];
              for (const key in itemSamples) {
                arraySamples[key] = [itemSamples[key]];
              }
              obj = mergePropertyExamples(obj, propertyName, arraySamples);
            }
          }
          continue;
        }
        obj = mergePropertyExamples(obj, propertyName, schemaToSampleObj(schema.properties[propertyName], config));
      }
      if (typeof schema.additionalProperties === 'object') {
        const propertyName = schema.additionalProperties['x-additionalPropertiesName'] || 'property';
        obj = mergePropertyExamples(obj, `${propertyName}1`, schemaToSampleObj(schema.additionalProperties, config));
        obj = mergePropertyExamples(obj, `${propertyName}2`, schemaToSampleObj(schema.additionalProperties, config));
      }
    }
  } else if (schema.type === 'array' || schema.items) {
    if (schema.items || schema.example) {
      var _schema$items3;
      if (schema.example) {
        obj['example-0'] = schema.example;
      } else if ((_schema$items3 = schema.items) !== null && _schema$items3 !== void 0 && _schema$items3.example) {
        // schemas and properties support single example but not multiple examples.
        obj['example-0'] = [schema.items.example];
      } else {
        const samples = schemaToSampleObj(schema.items, config);
        let i = 0;
        for (const key in samples) {
          obj[`example-${i}`] = [samples[key]];
          addSchemaInfoToExample(schema.items, obj[`example-${i}`]);
          i++;
        }
      }
    } else {
      obj['example-0'] = [];
    }
  } else {
    return {
      'example-0': getSampleValueByType(schema)
    };
  }
  return obj;
}
function generateMarkdownForArrayAndObjectDescription(schema, level = 0) {
  var _schema$items4;
  let markdown = (schema.description || schema.title) && (schema.minItems || schema.maxItems) ? '<span class="descr-expand-toggle">➔</span>' : '';
  if (schema.title) {
    if (schema.description) {
      markdown = `${markdown} <b>${schema.title}:</b> ${schema.description}<br/>`;
    } else {
      markdown = `${markdown} ${schema.title}<br/>`;
    }
  } else if (schema.description) {
    markdown = `${markdown} ${schema.description}<br/>`;
  }
  if (schema.minItems) {
    markdown = `${markdown} <b>Min Items:</b> ${schema.minItems}`;
  }
  if (schema.maxItems) {
    markdown = `${markdown} <b>Max Items:</b> ${schema.maxItems}`;
  }
  if (level > 0 && (_schema$items4 = schema.items) !== null && _schema$items4 !== void 0 && _schema$items4.description) {
    let itemsMarkdown = '';
    if (schema.items.minProperties) {
      itemsMarkdown = `<b>Min Properties:</b> ${schema.items.minProperties}`;
    }
    if (schema.items.maxProperties) {
      itemsMarkdown = `${itemsMarkdown} <b>Max Properties:</b> ${schema.items.maxProperties}`;
    }
    markdown = `${markdown} ⮕ ${itemsMarkdown} [ ${schema.items.description} ] `;
  }
  return markdown;
}
/**
 * For changing OpenAPI-Schema to an Object Notation,
 * This Object would further be an input to UI Components to generate an Object-Tree
 * @param {object} schema - Schema object from OpenAPI spec
 * @param {object} obj - recursivly pass this object to generate object notation
 * @param {number} level - recursion level
 * @param {string} suffix - used for suffixing property names to avoid duplicate props during object composion
 */
function schemaInObjectNotation(schema, obj, level = 0, suffix = '') {
  if (!schema) {
    return;
  }
  if (schema.allOf) {
    const objWithAllProps = {};
    if (schema.allOf.length === 1 && !schema.allOf[0].properties && !schema.allOf[0].items) {
      // If allOf has single item and the type is not an object or array, then its a primitive
      const tempSchema = schema.allOf[0];
      return `${getTypeInfo(tempSchema).html}`;
    }
    // If allOf is an array of multiple elements, then all the keys makes a single object
    schema.allOf.map((v, i) => {
      if (v.type === 'object' || v.properties || v.allOf || v.anyOf || v.oneOf) {
        const propSuffix = (v.anyOf || v.oneOf) && i > 0 ? i : '';
        const partialObj = schemaInObjectNotation(v, {}, level + 1, propSuffix);
        Object.assign(objWithAllProps, partialObj);
      } else if (v.type === 'array' || v.items) {
        const partialObj = schemaInObjectNotation(v, {}, level + 1);
        Object.assign(objWithAllProps, partialObj);
      } else if (v.type) {
        const prop = `prop${Object.keys(objWithAllProps).length}`;
        const typeObj = getTypeInfo(v);
        objWithAllProps[prop] = `${typeObj.html}`;
      } else {
        return '';
      }
    });
    obj = objWithAllProps;
  } else if (schema.anyOf || schema.oneOf) {
    obj['::description'] = schema.description || '';
    // 1. First iterate the regular properties
    if (schema.type === 'object' || schema.properties) {
      obj['::description'] = schema.description || '';
      obj['::type'] = 'object';
      // obj['::deprecated'] = schema.deprecated || false;
      for (const key in schema.properties) {
        if (schema.required && schema.required.includes(key)) {
          obj[`${key}*`] = schemaInObjectNotation(schema.properties[key], {}, level + 1);
        } else {
          obj[key] = schemaInObjectNotation(schema.properties[key], {}, level + 1);
        }
      }
    }
    // 2. Then show allof/anyof objects
    const objWithAnyOfProps = {};
    const xxxOf = schema.anyOf ? 'anyOf' : 'oneOf';
    schema[xxxOf].forEach((v, index) => {
      if (v.type === 'object' || v.properties || v.allOf || v.anyOf || v.oneOf) {
        const partialObj = schemaInObjectNotation(v, {});
        objWithAnyOfProps[`::OPTION~${index + 1}${v.title ? `~${v.title}` : ''}`] = partialObj;
        objWithAnyOfProps[`::OPTION~${index + 1}${v.title ? `~${v.title}` : ''}`]['::readwrite'] = ''; // xxx-options cannot be read or write only
        objWithAnyOfProps['::type'] = 'xxx-of-option';
      } else if (v.type === 'array' || v.items) {
        // This else-if block never seems to get executed
        const partialObj = schemaInObjectNotation(v, {});
        objWithAnyOfProps[`::OPTION~${index + 1}${v.title ? `~${v.title}` : ''}`] = partialObj;
        objWithAnyOfProps[`::OPTION~${index + 1}${v.title ? `~${v.title}` : ''}`]['::readwrite'] = ''; // xxx-options cannot be read or write only
        objWithAnyOfProps['::type'] = 'xxx-of-array';
      } else {
        const prop = `::OPTION~${index + 1}${v.title ? `~${v.title}` : ''}`;
        objWithAnyOfProps[prop] = `${getTypeInfo(v).html}`;
        objWithAnyOfProps['::type'] = 'xxx-of-option';
      }
    });
    obj[schema.anyOf ? `::ANY~OF ${suffix}` : `::ONE~OF ${suffix}`] = objWithAnyOfProps;
    // obj['::type'] = 'object';
    obj['::type'] = 'object';
  } else if (Array.isArray(schema.type)) {
    // When a property has multiple types, then check further if any of the types are array or object, if yes then modify the schema using one-of
    // Clone the schema - as it will be modified to replace multi-data-types with one-of;
    const subSchema = JSON.parse(JSON.stringify(schema));
    const primitiveType = [];
    const complexTypes = [];
    subSchema.type.forEach(v => {
      var _subSchema$items, _subSchema$items2;
      if (v.match(/integer|number|string|null|boolean/g)) {
        primitiveType.push(v);
      } else if (v === 'array' && typeof ((_subSchema$items = subSchema.items) === null || _subSchema$items === void 0 ? void 0 : _subSchema$items.type) === 'string' && (_subSchema$items2 = subSchema.items) !== null && _subSchema$items2 !== void 0 && _subSchema$items2.type.match(/integer|number|string|null|boolean/g)) {
        // Array with primitive types should also be treated as primitive type
        if (subSchema.items.type === 'string' && subSchema.items.format) {
          primitiveType.push(`[${subSchema.items.format}]`);
        } else {
          primitiveType.push(`[${subSchema.items.type}]`);
        }
      } else {
        complexTypes.push(v);
      }
    });
    let multiPrimitiveTypes;
    if (primitiveType.length > 0) {
      subSchema.type = primitiveType.join(primitiveType.length === 2 ? ' or ' : '┃');
      multiPrimitiveTypes = getTypeInfo(subSchema);
      if (complexTypes.length === 0) {
        var _multiPrimitiveTypes;
        return `${((_multiPrimitiveTypes = multiPrimitiveTypes) === null || _multiPrimitiveTypes === void 0 ? void 0 : _multiPrimitiveTypes.html) || ''}`;
      }
    }
    if (complexTypes.length > 0) {
      var _multiPrimitiveTypes2;
      obj['::type'] = 'object';
      const multiTypeOptions = {
        '::type': 'xxx-of-option'
      };

      // Generate ONE-OF options for complexTypes
      complexTypes.forEach((v, i) => {
        if (v === 'null') {
          multiTypeOptions[`::OPTION~${i + 1}`] = 'NULL~|~~|~~|~~|~~|~~|~~|~~|~';
        } else if ('integer, number, string, boolean,'.includes(`${v},`)) {
          subSchema.type = Array.isArray(v) ? v.join('┃') : v;
          const primitiveTypeInfo = getTypeInfo(subSchema);
          multiTypeOptions[`::OPTION~${i + 1}`] = primitiveTypeInfo.html;
        } else if (v === 'object') {
          // If object type iterate all the properties and create an object-type-option
          const objTypeOption = {
            '::title': schema.title || '',
            '::description': schema.description || '',
            '::type': 'object',
            '::deprecated': schema.deprecated || false
          };
          for (const key in schema.properties) {
            if (schema.required && schema.required.includes(key)) {
              objTypeOption[`${key}*`] = schemaInObjectNotation(schema.properties[key], {}, level + 1);
            } else {
              objTypeOption[key] = schemaInObjectNotation(schema.properties[key], {}, level + 1);
            }
          }
          multiTypeOptions[`::OPTION~${i + 1}`] = objTypeOption;
        } else if (v === 'array') {
          multiTypeOptions[`::OPTION~${i + 1}`] = {
            '::title': schema.title || '',
            '::description': schema.description || '',
            '::type': 'array',
            '::props': schemaInObjectNotation(schema.items, {}, level + 1)
          };
        }
      });
      multiTypeOptions[`::OPTION~${complexTypes.length + 1}`] = ((_multiPrimitiveTypes2 = multiPrimitiveTypes) === null || _multiPrimitiveTypes2 === void 0 ? void 0 : _multiPrimitiveTypes2.html) || '';
      obj['::ONE~OF'] = multiTypeOptions;
    }
  } else if (schema.type === 'object' || schema.properties) {
    // If Object
    obj['::title'] = schema.title || '';
    obj['::description'] = generateMarkdownForArrayAndObjectDescription(schema, level);
    obj['::type'] = 'object';
    if (Array.isArray(schema.type) && schema.type.includes('null') || schema.nullable) {
      obj['::dataTypeLabel'] = 'object or null';
      obj['::nullable'] = true;
    }
    obj['::deprecated'] = schema.deprecated || false;
    obj['::readwrite'] = schema.readOnly ? 'readonly' : schema.writeOnly ? 'writeonly' : '';
    for (const key in schema.properties) {
      if (schema.required && schema.required.includes(key)) {
        obj[`${key}*`] = schemaInObjectNotation(schema.properties[key], {}, level + 1);
      } else {
        obj[key] = schemaInObjectNotation(schema.properties[key], {}, level + 1);
      }
    }
    for (const key in schema.patternProperties) {
      obj[`[pattern: ${key}]`] = schemaInObjectNotation(schema.patternProperties[key], obj, level + 1);
    }
    if (schema.additionalProperties) {
      obj['[any-key]'] = schemaInObjectNotation(schema.additionalProperties, {});
    }
  } else if (schema.type === 'array' || schema.items) {
    var _schema$items5;
    // If Array
    obj['::title'] = schema.title || '';
    obj['::description'] = generateMarkdownForArrayAndObjectDescription(schema, level);
    obj['::type'] = 'array';
    if (Array.isArray(schema.type) && schema.type.includes('null') || schema.nullable) {
      obj['::dataTypeLabel'] = 'array or null';
      obj['::nullable'] = true;
    }
    obj['::deprecated'] = schema.deprecated || false;
    obj['::readwrite'] = schema.readOnly ? 'readonly' : schema.writeOnly ? 'writeonly' : '';
    if ((_schema$items5 = schema.items) !== null && _schema$items5 !== void 0 && _schema$items5.items) {
      obj['::array-type'] = schema.items.items.type;
    }
    obj['::props'] = schemaInObjectNotation(schema.items, {}, level + 1);
  } else {
    const typeObj = getTypeInfo(schema);
    if (typeObj !== null && typeObj !== void 0 && typeObj.html) {
      return `${typeObj.html}`;
    }
    return '';
  }
  return obj;
}

/* Create Example object */
function generateExample(schema, mimeType, examples = {}, example = {}, includeReadOnly = true, includeWriteOnly = true, outputType = 'json', includeGeneratedExample = false) {
  const finalExamples = [];
  // First check if examples is provided
  if (examples) {
    for (const eg in examples) {
      let egContent = '';
      let egFormat = 'json';
      if (mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('json')) {
        if (outputType === 'text') {
          egContent = typeof examples[eg].value === 'string' ? examples[eg].value : JSON.stringify(examples[eg].value, undefined, 2);
          egFormat = 'text';
        } else {
          egContent = examples[eg].value;
          if (typeof examples[eg].value === 'string') {
            try {
              // const fixedJsonString = examples[eg].value.replace((/([\w]+)(:)/g), '"$1"$2').replace((/'/g), '"');
              const fixedJsonString = examples[eg].value;
              egContent = JSON.parse(fixedJsonString);
              egFormat = 'json';
            } catch {
              egFormat = 'text';
              egContent = examples[eg].value;
            }
          }
        }
      } else {
        egContent = examples[eg].value;
        egFormat = 'text';
      }
      finalExamples.push({
        exampleId: eg,
        exampleSummary: examples[eg].summary || eg,
        exampleDescription: examples[eg].description || '',
        exampleType: mimeType,
        exampleValue: egContent,
        exampleFormat: egFormat
      });
    }
  } else if (example) {
    let egContent = '';
    let egFormat = 'json';
    if (mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('json')) {
      if (outputType === 'text') {
        egContent = typeof example === 'string' ? example : JSON.stringify(example, undefined, 2);
        egFormat = 'text';
      } else if (typeof example === 'object') {
        egContent = example;
        egFormat = 'json';
      } else if (typeof example === 'string') {
        try {
          egContent = JSON.parse(example);
          egFormat = 'json';
        } catch {
          egFormat = 'text';
          egContent = example;
        }
      }
    } else {
      egContent = example;
      egFormat = 'text';
    }
    finalExamples.push({
      exampleId: 'Example',
      exampleSummary: '',
      exampleDescription: '',
      exampleType: mimeType,
      exampleValue: egContent,
      exampleFormat: egFormat
    });
  }
  // If schema-level examples are not provided or includeGeneratedExample === true then generate one based on the schema field types
  if (finalExamples.length === 0 || includeGeneratedExample === true) {
    if (schema) {
      if (schema.example) {
        // Note: Deprecated: The 'example' property has been deprecated in 3.1.0 in favor of the JSON Schema 'examples' keyword
        finalExamples.push({
          exampleId: 'Example',
          exampleSummary: '',
          exampleDescription: '',
          exampleType: mimeType,
          exampleValue: schema.example,
          exampleFormat: mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('json') && typeof schema.example === 'object' ? 'json' : 'text'
        });
      } else if (mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('json') || mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('text') || mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('*/*') || mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('xml')) {
        let xmlRootStart = '';
        let xmlRootEnd = '';
        let exampleFormat = '';
        let exampleValue = '';
        if (mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('xml')) {
          var _schema$xml5, _schema$xml6;
          xmlRootStart = (_schema$xml5 = schema.xml) !== null && _schema$xml5 !== void 0 && _schema$xml5.name ? `<${schema.xml.name} ${schema.xml.namespace ? `xmlns="${schema.xml.namespace}"` : ''}>` : '<root>';
          xmlRootEnd = (_schema$xml6 = schema.xml) !== null && _schema$xml6 !== void 0 && _schema$xml6.name ? `</${schema.xml.name}>` : '</root>';
          exampleFormat = 'text';
        } else {
          exampleFormat = outputType;
        }
        const samples = schemaToSampleObj(schema, {
          includeReadOnly,
          includeWriteOnly,
          deprecated: true,
          useXmlTagForProp: mimeType === null || mimeType === void 0 ? void 0 : mimeType.toLowerCase().includes('xml')
        });
        let i = 0;
        for (const samplesKey in samples) {
          if (!samples[samplesKey]) {
            continue;
          }
          const summary = samples[samplesKey]['::TITLE'] || `Example ${++i}`;
          const description = samples[samplesKey]['::DESCRIPTION'] || '';
          if (mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('xml')) {
            exampleValue = `<?xml version="1.0" encoding="UTF-8"?>\n${xmlRootStart}${json2xml(samples[samplesKey], 1)}\n${xmlRootEnd}`;
          } else {
            removeTitlesAndDescriptions(samples[samplesKey]);
            exampleValue = outputType === 'text' ? JSON.stringify(samples[samplesKey], null, 2) : samples[samplesKey];
          }
          finalExamples.push({
            exampleId: samplesKey,
            exampleSummary: summary,
            exampleDescription: description,
            exampleType: mimeType,
            exampleFormat,
            exampleValue
          });
        }
      } else if (mimeType !== null && mimeType !== void 0 && mimeType.toLowerCase().includes('jose')) {
        finalExamples.push({
          exampleId: 'Example',
          exampleSummary: 'Base64 Encoded',
          exampleDescription: '',
          exampleType: mimeType,
          exampleValue: schema.pattern || 'bXJpbg==',
          exampleFormat: 'text'
        });
      } else {
        finalExamples.push({
          exampleId: 'Example',
          exampleSummary: '',
          exampleDescription: '',
          exampleType: mimeType,
          exampleValue: '',
          exampleFormat: 'text'
        });
      }
    } else {
      // No Example or Schema provided (should never reach here)
      finalExamples.push({
        exampleId: 'Example',
        exampleSummary: '',
        exampleDescription: '',
        exampleType: mimeType,
        exampleValue: '',
        exampleFormat: 'text'
      });
    }
  }
  return finalExamples;
}
function getSerializeStyleForContentType(contentType) {
  if (contentType === 'application/json') {
    return 'json';
  }
  if (contentType === 'application/xml') {
    return 'xml';
  }
  return null;
}
function getSchemaFromParam(param) {
  if (param.schema) {
    return [param.schema, null, null];
  }
  if (param.content) {
    // we gonna use the first content-encoding
    for (const contentType of Object.keys(param.content)) {
      if (param.content[contentType].schema) {
        return [param.content[contentType].schema, getSerializeStyleForContentType(contentType), param.content[contentType]];
      }
    }
  }
  return [null, null, null];
}
;// ./src/components/json-tree.js






class JsonTree extends lit_element_h {
  static get properties() {
    return {
      data: {
        type: Object
      },
      renderStyle: {
        type: String,
        attribute: 'render-style'
      }
    };
  }
  static get styles() {
    return [font_styles, border_styles, input_styles, i`
      :host{
        display:flex;
      }
      :where(button, input[type="checkbox"], [tabindex="0"]):focus-visible { box-shadow: var(--focus-shadow); }
      :where(input[type="text"], input[type="password"], select, textarea):focus-visible { border-color: var(--primary-color); }
      .json-tree {
        position: relative;
        font-family: var(--font-mono);
        font-size: var(--font-size-small);
        display:inline-block;
        overflow:hidden;
        word-break: break-all;
        flex:1;
        line-height: calc(var(--font-size-small) + 6px);
        min-height: 40px;
        direction: ltr; 
        text-align: left;
      }

      .open-bracket {
        display:inline-block;
        padding: 0 20px 0 0;
        cursor:pointer;
        border: 1px solid transparent;
        border-radius:3px;
      }
      .close-bracket {
        border: 1px solid transparent;
        border-radius:3px;
        display:inline-block;
      }
      .open-bracket:hover {
        color:var(--primary-color);
        background-color:var(--hover-color);
        border: 1px solid var(--border-color);
      }
      .open-bracket.expanded:hover ~ .inside-bracket {
        border-left: 1px solid var(--fg3);
      }
      .open-bracket.expanded:hover ~ .close-bracket {
        color:var(--primary-color);
      }
      .inside-bracket {
        padding-left:12px;
        overflow: hidden;
        border-left:1px dotted var(--border-color);
      }
      .open-bracket.collapsed + .inside-bracket,
      .open-bracket.collapsed + .inside-bracket + .close-bracket {
        display:none;
      }

      .string{color:var(--green);}
      .number{color:var(--blue);}
      .null{color:var(--red);}
      .boolean{color:var(--purple);}
      .object{color:var(--fg)}
      .toolbar {
        position: absolute;
        top:5px;
        right:6px;
        display:flex;
        padding:2px;
        align-items: center;
      }`, custom_styles];
  }

  /* eslint-disable indent */
  render() {
    return ke`
      <div class = "json-tree"  @click='${e => {
      if (e.target.classList.contains('btn-copy')) {
        copyToClipboard(JSON.stringify(this.data, null, 2), e);
      } else {
        this.toggleExpand(e);
      }
    }}'>
        <div class='toolbar'> 
          <button class="toolbar-btn btn-copy" part="btn btn-fill btn-copy"> Copy </button>
        </div>
          ${this.generateTree(this.data, true)}
      </div>  
    `;
  }
  generateTree(data, isLast = false) {
    if (data === null) {
      return ke`<span class="null">null</span>${isLast ? '' : ','}`;
    }
    if (typeof data === 'object' && data instanceof Date === false) {
      const detailType = Array.isArray(data) ? 'array' : 'pure_object';
      if (Object.keys(data).length === 0) {
        return ke`${Array.isArray(data) ? '[ ],' : '{ },'}`;
      }
      return ke`
      <div class="open-bracket expanded ${detailType === 'array' ? 'array' : 'object'}" > ${detailType === 'array' ? '[' : '{'}</div>
      <div class="inside-bracket">
        ${Object.keys(data).map((key, i, a) => ke`
          <div class="item"> 
            ${detailType === 'pure_object' ? ke`"${key}":` : ''}
            ${this.generateTree(data[key], i === a.length - 1)}
          </div>`)}
      </div>
      <div class="close-bracket">${detailType === 'array' ? ']' : '}'}${isLast ? '' : ','}</div>
      `;
    }
    return typeof data === 'string' || data instanceof Date ? ke`<span class="${typeof data}">"${data}"</span>${isLast ? '' : ','}` : ke`<span class="${typeof data}">${data}</span>${isLast ? '' : ','}`;
  }
  /* eslint-enable indent */

  toggleExpand(e) {
    const openBracketEl = e.target;
    if (e.target.classList.contains('open-bracket')) {
      if (openBracketEl.classList.contains('expanded')) {
        openBracketEl.classList.replace('expanded', 'collapsed');
        e.target.innerHTML = e.target.classList.contains('array') ? '[...]' : '{...}';
      } else {
        openBracketEl.classList.replace('collapsed', 'expanded');
        e.target.innerHTML = e.target.classList.contains('array') ? '[' : '{';
      }
    }
  }
}
// Register the element with the browser
customElements.define('json-tree', JsonTree);
;// ./src/styles/schema-styles.js

/* harmony default export */ const schema_styles = (i`

*, *:before, *:after { box-sizing: border-box; }
:host {
  container-type: inline-size;
}

.tr {
  display: flex;
  flex: none;
  width: 100%;
  box-sizing: content-box;
  border-bottom: 1px dotted transparent;
  transition: max-height 0.3s ease-out;
}
.td {
  display: block;
  flex: 0 0 auto;
}
.key {
  font-family: var(--font-mono);
  white-space: normal;
  word-break: break-all;
}

.collapsed-all-descr .key {
  overflow:hidden;
}
.expanded-all-descr .key-descr .descr-expand-toggle {
  display:none;
}

.key-descr .descr-expand-toggle {
  display:inline-block;
  user-select:none;
  color: var(--fg);
  cursor: pointer;
  transform: rotate(45deg);
  transition: transform .2s ease;
}

.expanded-descr .key-descr .descr-expand-toggle {
  transform: rotate(270deg)
}

.key-descr .descr-expand-toggle:hover {
  color: var(--primary-color);
}

.expanded-descr .more-content { display:none; }

.key-descr {
  font-family:var(--font-regular);
  color:var(--light-fg);
  flex-shrink: 1;
  text-overflow: ellipsis;
  overflow: hidden;
  display: none;
}
.expanded-descr .key-descr{
  max-height:auto;
  overflow:hidden;
  display: none;
}

.xxx-of-key {
  font-size: calc(var(--font-size-small) - 2px); 
  font-weight:bold; 
  background-color:var(--primary-color); 
  color:var(--primary-color-invert); 
  border-radius:2px;
  line-height:calc(var(--font-size-small) + 6px);
  padding:0px 5px; 
  margin-bottom:1px; 
  display:inline-block;
}

.xxx-of-descr {
  font-family: var(--font-regular);
  color: var(--primary-color);
  font-size: calc(var(--font-size-small) - 1px);
  margin-left: 2px;
}

.stri, .string, .uri, .url, .byte, .bina, .date, .pass, .ipv4, .ipv4, .uuid, .emai, .host { color:var(--green); }
.inte, .numb, .number, .int6, .int3, .floa, .doub, .deci .blue { color:var(--blue); }
.null { color:var(--red); }
.bool, .boolean { color:var(--orange) }
.enum { color:var(--purple) }
.cons { color:var(--purple) }
.recu { color:var(--brown) }
.toolbar {
  display:flex;
  width:100%;
  padding: 2px 0;
  color:var(--primary-color);
}
.toolbar-item {
  cursor:pointer;
  padding:5px 0;
  margin:0 2px;
}
.schema-root-type {
  cursor:auto;
  color:var(--fg2);
  font-weight: bold;
  text-transform: uppercase;
}
.toolbar-item:first-of-type { margin:0 2px 0 0;}

@container (min-width: 500px) {
  .key-descr {
    display: block;
  }
  .expanded-descr .key-descr {
    display: block;
  }
}
`);
;// ./src/components/schema-tree.js

 // eslint-disable-line import/extensions





class SchemaTree extends lit_element_h {
  static get properties() {
    return {
      data: {
        type: Object
      },
      schemaExpandLevel: {
        type: Number,
        attribute: 'schema-expand-level'
      },
      schemaDescriptionExpanded: {
        type: String,
        attribute: 'schema-description-expanded'
      },
      allowSchemaDescriptionExpandToggle: {
        type: String,
        attribute: 'allow-schema-description-expand-toggle'
      },
      schemaHideReadOnly: {
        type: String,
        attribute: 'schema-hide-read-only'
      },
      schemaHideWriteOnly: {
        type: String,
        attribute: 'schema-hide-write-only'
      }
    };
  }
  connectedCallback() {
    super.connectedCallback();
    if (!this.schemaExpandLevel || this.schemaExpandLevel < 1) {
      this.schemaExpandLevel = 99999;
    }
    if (!this.schemaDescriptionExpanded || !'true false'.includes(this.schemaDescriptionExpanded)) {
      this.schemaDescriptionExpanded = 'false';
    }
    if (!this.schemaHideReadOnly || !'true false'.includes(this.schemaHideReadOnly)) {
      this.schemaHideReadOnly = 'true';
    }
    if (!this.schemaHideWriteOnly || !'true false'.includes(this.schemaHideWriteOnly)) {
      this.schemaHideWriteOnly = 'true';
    }
  }
  static get styles() {
    return [font_styles, schema_styles, border_styles, i`
      .tree {
        font-size:var(--font-size-small);
        text-align: left;
        direction: ltr;
        line-height:calc(var(--font-size-small) + 6px);
      }
      .tree .tr:hover{
        background-color:var(--hover-color);
      }
      .collapsed-all-descr .tr:not(.expanded-descr) {
        overflow: hidden;
        max-height:calc(var(--font-size-small) + 8px);
      }
      .tree .key {
        max-width: 300px;
      }
      .tr.expanded:hover > .td.key > .open-bracket {
        color: var(--primary-color);
      }
      .tr.expanded:hover + .inside-bracket {
        border-left: 1px solid var(--fg3);
      }
      .tr.expanded:hover + .inside-bracket + .close-bracket {
        color: var(--primary-color);
      }
      .inside-bracket.xxx-of-option {
        border-left: 1px solid transparent;
      }
      .open-bracket{
        display:inline-block;
        padding: 0 20px 0 0;
        cursor:pointer;
        border: 1px solid transparent;
        border-radius:3px;
      }
      .open-bracket:hover {
        color:var(--primary-color);
        background-color:var(--hover-color);
        border: 1px solid var(--border-color);
      }
      .close-bracket{
        display:inline-block;
        font-family: var(--font-mono);
      }
      .tr.collapsed + .inside-bracket,
      .tr.collapsed + .inside-bracket + .close-bracket{
        overflow: hidden;
        display:none;
      }
      .inside-bracket.object,
      .inside-bracket.array {
        border-left: 1px dotted var(--border-color);
      }`, custom_styles];
  }

  /* eslint-disable indent */
  render() {
    var _this$data, _this$data2, _this$data3;
    return ke`
      <div class="tree ${this.schemaDescriptionExpanded === 'true' ? 'expanded-all-descr' : 'collapsed-all-descr'}" @click="${e => this.handleAllEvents(e)}">
        <div class="toolbar">
          <div class="toolbar-item schema-root-type ${((_this$data = this.data) === null || _this$data === void 0 ? void 0 : _this$data['::type']) || ''} "> ${((_this$data2 = this.data) === null || _this$data2 === void 0 ? void 0 : _this$data2['::type']) || ''} </div>
          ${this.allowSchemaDescriptionExpandToggle === 'true' ? ke`
              <div style="flex:1"></div>
              <div part="schema-toolbar-item schema-multiline-toggle" class='toolbar-item schema-multiline-toggle'> 
                ${this.schemaDescriptionExpanded === 'true' ? 'Single line description' : 'Multiline description'}
              </div>` : ''}
        </div>
        <span part="schema-description" class='m-markdown'> ${unsafe_html_ae(marked(((_this$data3 = this.data) === null || _this$data3 === void 0 ? void 0 : _this$data3['::description']) || ''))}</span>
        ${this.data ? ke`
            ${this.generateTree(this.data['::type'] === 'array' ? this.data['::props'] : this.data, this.data['::type'], this.data['::array-type'] || '')}` : ke`<span class='mono-font' style='color:var(--red)'> Schema not found </span>`}
      </div>  
    `;
  }
  generateTree(data, dataType = 'object', arrayType = '', key = '', description = '', schemaLevel = 0, indentLevel = 0, readOrWrite = '', isDeprecated = false) {
    var _data$Type;
    if (this.schemaHideReadOnly === 'true') {
      if (dataType === 'array') {
        if (readOrWrite === 'readonly') {
          return;
        }
      }
      if ((data === null || data === void 0 ? void 0 : data['::readwrite']) === 'readonly') {
        return;
      }
    }
    if (this.schemaHideWriteOnly === 'true') {
      if (dataType === 'array') {
        if (readOrWrite === 'writeonly') {
          return;
        }
      }
      if ((data === null || data === void 0 ? void 0 : data['::readwrite']) === 'writeonly') {
        return;
      }
    }
    if (!data) {
      return ke`<div class="null" style="display:inline;">
        <span class="key-label xxx-of-key"> ${key.replace('::OPTION~', '')}</span>
        ${dataType === 'array' ? ke`<span class='mono-font'> [ ] </span>` : dataType === 'object' ? ke`<span class='mono-font'> { } </span>` : ke`<span class='mono-font'> schema undefined </span>`}
      </div>`;
    }
    if (Object.keys(data).length === 0) {
      return ke`<span class="key object">${key}:{ }</span>`;
    }
    let keyLabel = '';
    let keyDescr = '';
    if (key.startsWith('::ONE~OF') || key.startsWith('::ANY~OF')) {
      keyLabel = key.replace('::', '').replace('~', ' ');
    } else if (key.startsWith('::OPTION')) {
      const parts = key.split('~');
      [, keyLabel, keyDescr] = parts;
    } else {
      keyLabel = key;
    }
    const leftPadding = 12;
    const minFieldColWidth = 400 - indentLevel * leftPadding;
    let openBracket = '';
    let closeBracket = '';
    const newSchemaLevel = (_data$Type = data['::type']) !== null && _data$Type !== void 0 && _data$Type.startsWith('xxx-of') ? schemaLevel : schemaLevel + 1;
    // const newIndentLevel = dataType === 'xxx-of-option' || data['::type'] === 'xxx-of-option' ? indentLevel : (indentLevel + 1);
    const newIndentLevel = dataType === 'xxx-of-option' || data['::type'] === 'xxx-of-option' || key.startsWith('::OPTION') ? indentLevel : indentLevel + 1;
    if (data['::type'] === 'object') {
      if (dataType === 'array') {
        if (schemaLevel < this.schemaExpandLevel) {
          openBracket = ke`<span class="open-bracket array-of-object" >[{</span>`;
        } else {
          openBracket = ke`<span class="open-bracket array-of-object">[{...}]</span>`;
        }
        closeBracket = '}]';
      } else {
        if (schemaLevel < this.schemaExpandLevel) {
          openBracket = ke`<span class="open-bracket object">${data['::nullable'] ? 'null┃' : ''}{</span>`;
        } else {
          openBracket = ke`<span class="open-bracket object">${data['::nullable'] ? 'null┃' : ''}{...}</span>`;
        }
        closeBracket = '}';
      }
    } else if (data['::type'] === 'array') {
      if (dataType === 'array') {
        const arrType = arrayType !== 'object' ? arrayType : '';
        if (schemaLevel < this.schemaExpandLevel) {
          openBracket = ke`<span class="open-bracket array-of-array" data-array-type="${arrType}">[[ ${arrType} </span>`;
        } else {
          openBracket = ke`<span class="open-bracket array-of-array"  data-array-type="${arrType}">[[...]]</span>`;
        }
        closeBracket = ']]';
      } else {
        if (schemaLevel < this.schemaExpandLevel) {
          openBracket = ke`<span class="open-bracket array">[</span>`;
        } else {
          openBracket = ke`<span class="open-bracket array">[...]</span>`;
        }
        closeBracket = ']';
      }
    }
    if (typeof data === 'object') {
      var _data$Type2;
      return ke`
        <div class="tr ${schemaLevel < this.schemaExpandLevel || (_data$Type2 = data['::type']) !== null && _data$Type2 !== void 0 && _data$Type2.startsWith('xxx-of') ? 'expanded' : 'collapsed'} ${data['::type'] || 'no-type-info'}${data['::nullable'] ? ' nullable' : ''}" title="${isDeprecated || data['::deprecated'] ? 'Deprecated' : ''}">
          <div class="td key ${isDeprecated || data['::deprecated'] ? 'deprecated' : ''}" style='min-width:${minFieldColWidth}px'>
            ${data['::type'] === 'xxx-of-option' || data['::type'] === 'xxx-of-array' || key.startsWith('::OPTION') ? ke`<span class='key-label xxx-of-key'> ${keyLabel}</span><span class="xxx-of-descr">${keyDescr}</span>` : keyLabel === '::props' || keyLabel === '::ARRAY~OF' ? '' : schemaLevel > 0 ? ke`<span class="key-label" title="${readOrWrite === 'readonly' ? 'Read-Only' : readOrWrite === 'writeonly' ? 'Write-Only' : ''}">
                      ${isDeprecated || data['::deprecated'] ? ke`<svg viewBox="0 0 10 10" width="10" height="10" style="stroke:var(--red); margin-right:-6px"><path d="M2 2L8 8M2 8L8 2"/></svg>` : ''}
                      ${keyLabel.replace(/\*$/, '')}${keyLabel.endsWith('*') ? ke`<span style="color:var(--red)">*</span>` : ''}${readOrWrite === 'readonly' ? ke` 🆁` : readOrWrite === 'writeonly' ? ke` 🆆` : readOrWrite}:
                    </span>` : ''}
            ${openBracket}
          </div>
          <div class='td key-descr m-markdown-small'>${unsafe_html_ae(marked(description || ''))}</div>
        </div>
        <div class='inside-bracket ${data['::type'] || 'no-type-info'}' style='padding-left:${data['::type'] === 'xxx-of-option' || data['::type'] === 'xxx-of-array' ? 0 : leftPadding}px;'>
          ${Array.isArray(data) && data[0] ? ke`${this.generateTree(data[0], 'xxx-of-option', '', '::ARRAY~OF', '', newSchemaLevel, newIndentLevel, data[0]['::readwrite'], isDeprecated || data[0]['::deprecated'])}` : ke`
              ${Object.keys(data).map(dataKey => {
        var _data$dataKey;
        return ke`
                ${['::title', '::description', '::type', '::props', '::deprecated', '::array-type', '::readwrite', '::dataTypeLabel', '::nullable'].includes(dataKey) ? data[dataKey]['::type'] === 'array' || data[dataKey]['::type'] === 'object' ? ke`${this.generateTree(data[dataKey]['::type'] === 'array' ? data[dataKey]['::props'] : data[dataKey], data[dataKey]['::type'], data[dataKey]['::array-type'] || '', dataKey, data[dataKey]['::description'], newSchemaLevel, newIndentLevel, data[dataKey]['::readwrite'] ? data[dataKey]['::readwrite'] : '', isDeprecated || data[dataKey]['::deprecated'])}` : '' : ke`${this.generateTree(data[dataKey]['::type'] === 'array' ? data[dataKey]['::props'] : data[dataKey], data[dataKey]['::type'], data[dataKey]['::array-type'] || '', dataKey, ((_data$dataKey = data[dataKey]) === null || _data$dataKey === void 0 ? void 0 : _data$dataKey['::description']) || '', newSchemaLevel, newIndentLevel, data[dataKey]['::readwrite'] ? data[dataKey]['::readwrite'] : '', isDeprecated || data[dataKey]['::deprecated'])}`}
              `;
      })}
            `}
        </div>
        ${data['::type'] && data['::type'].includes('xxx-of') ? '' : ke`<div class='close-bracket'> ${closeBracket} </div>`}
      `;
    }

    // For Primitive types and array of Primitives
    // eslint-disable-next-line no-unused-vars
    const [type, primitiveReadOrWrite, constraint, defaultValue, allowedValues, pattern, schemaDescription, schemaTitle, deprecated] = data.split('~|~');
    if (primitiveReadOrWrite === '🆁' && this.schemaHideReadOnly === 'true') {
      return;
    }
    if (primitiveReadOrWrite === '🆆' && this.schemaHideWriteOnly === 'true') {
      return;
    }
    const dataTypeCss = type.replace(/┃.*/g, '').replace(/[^a-zA-Z0-9+]/g, '').substring(0, 4).toLowerCase();
    const descrExpander = `${constraint || defaultValue || allowedValues || pattern ? `<span class="descr-expand-toggle ${this.schemaDescriptionExpanded === 'true' ? 'expanded-descr' : ''}">➔</span>` : ''}`;
    let finalReadWriteText = '';
    let finalReadWriteTip = '';
    if (dataType === 'array') {
      if (readOrWrite === 'readonly') {
        finalReadWriteText = '🆁';
        finalReadWriteTip = 'Read-Only';
      } else if (readOrWrite === 'writeonly') {
        finalReadWriteText = '🆆';
        finalReadWriteTip = 'Write-Only';
      }
    } else if (primitiveReadOrWrite === '🆁') {
      finalReadWriteText = '🆁';
      finalReadWriteTip = 'Read-Only';
    } else if (primitiveReadOrWrite === '🆆') {
      finalReadWriteText = '🆆';
      finalReadWriteTip = 'Write-Only';
    }
    return ke`
      <div class = "tr primitive" title="${deprecated ? 'Deprecated' : ''}">
        <div class="td key ${isDeprecated || deprecated}" style='min-width:${minFieldColWidth}px'>
          ${isDeprecated || deprecated ? ke`<svg viewBox="0 0 10 10" width="10" height="10" style="stroke:var(--red); margin-right:-6px"><path d="M2 2L8 8M2 8L8 2"/></svg>` : ''}
          ${keyLabel.endsWith('*') ? ke`<span class="key-label">${keyLabel.substring(0, keyLabel.length - 1)}</span><span style='color:var(--red);'>*</span>:` : key.startsWith('::OPTION') ? ke`<span class='key-label xxx-of-key'>${keyLabel}</span><span class="xxx-of-descr">${keyDescr}</span>` : ke`<span class="key-label">${keyLabel}:</span>`}
          <span class="${dataTypeCss}" title="${finalReadWriteTip}"> 
            ${dataType === 'array' ? `[${type}]` : `${type}`}
            ${finalReadWriteText}
          </span>
        </div>
        <div class='td key-descr'>
          ${description || schemaTitle || schemaDescription ? ke`${ke`<span class="m-markdown-small">
                ${unsafe_html_ae(marked(dataType === 'array' ? `${descrExpander} ${description}` : schemaTitle ? `${descrExpander} <b>${schemaTitle}:</b> ${schemaDescription}` : `${descrExpander} ${schemaDescription}`))}
              </span>`}` : ''}  
          ${constraint ? ke`<div style='display:inline-block; line-break:anywhere; margin-right:8px'><span class='bold-text'>Constraints: </span>${constraint}</div>` : ''}
          ${defaultValue ? ke`<div style='display:inline-block; line-break:anywhere; margin-right:8px'><span class='bold-text'>Default: </span>${defaultValue}</div>` : ''}
          ${allowedValues ? ke`<div style='display:inline-block; line-break:anywhere; margin-right:8px'><span class='bold-text'>${type === 'const' ? 'Value' : 'Allowed'}: </span>${allowedValues}</div>` : ''}
          ${pattern ? ke`<div style='display:inline-block; line-break: anywhere; margin-right:8px'><span class='bold-text'>Pattern: </span>${pattern}</div>` : ''}
        </div>
      </div>
    `;
  }
  /* eslint-enable indent */

  handleAllEvents(e) {
    if (e.target.classList.contains('open-bracket')) {
      this.toggleObjectExpand(e);
    } else if (e.target.classList.contains('schema-multiline-toggle')) {
      this.schemaDescriptionExpanded = this.schemaDescriptionExpanded === 'true' ? 'false' : 'true';
    } else if (e.target.classList.contains('descr-expand-toggle')) {
      const trEl = e.target.closest('.tr');
      if (trEl) {
        trEl.classList.toggle('expanded-descr');
        trEl.style.maxHeight = trEl.scrollHeight;
      }
    }
  }
  toggleObjectExpand(e) {
    const rowEl = e.target.closest('.tr');
    const nullable = rowEl.classList.contains('nullable');
    if (rowEl.classList.contains('expanded')) {
      rowEl.classList.replace('expanded', 'collapsed');
      e.target.innerHTML = e.target.classList.contains('array-of-object') ? '[{...}]' : e.target.classList.contains('array-of-array') ? '[[...]]' : e.target.classList.contains('array') ? '[...]' : `${nullable ? 'null┃' : ''}{...}`;
    } else {
      rowEl.classList.replace('collapsed', 'expanded');
      e.target.innerHTML = e.target.classList.contains('array-of-object') ? '[{' : e.target.classList.contains('array-of-array') ? `[[ ${e.target.dataset.arrayType}` : e.target.classList.contains('object') ? `${nullable ? 'null┃' : ''}{` : '[';
    }
  }
}
customElements.define('schema-tree', SchemaTree);
;// ./src/components/tag-input.js

class TagInput extends lit_element_h {
  /* eslint-disable indent */
  render() {
    let tagItemTmpl = '';
    if (Array.isArray(this.value)) {
      tagItemTmpl = ke`${this.value.filter(v => typeof v === 'string' && v.trim() !== '').map(v => ke`<span class='tag'>${v}</span>`)}`;
    }
    return ke`
      <div class='tags'>
        ${tagItemTmpl}
        <input type="text" class='editor' @paste="${e => this.afterPaste(e)}" @keydown="${this.afterKeyDown}" @blur="${this.onBlur}" placeholder="${this.placeholder || ''}">
      </div>
    `;
  }
  /* eslint-enable indent */

  static get properties() {
    return {
      placeholder: {
        type: String
      },
      value: {
        type: Array,
        attribute: 'value'
      }
    };
  }
  attributeChangedCallback(name, oldVal, newVal) {
    if (name === 'value') {
      if (newVal && oldVal !== newVal) {
        this.value = newVal.split(',').filter(v => v.trim() !== '');
      }
    }
    super.attributeChangedCallback(name, oldVal, newVal);
  }
  afterPaste(e) {
    const clipboardData = e.clipboardData || window.clipboardData;
    const pastedData = clipboardData.getData('Text');
    const pastedArray = pastedData ? pastedData.split(',').filter(v => v.trim() !== '') : '';
    if (pastedArray) {
      if (Array.isArray(this.value)) {
        this.value = [...this.value, ...pastedArray];
      } else {
        this.value = pastedArray;
      }
    }
    e.preventDefault();
  }
  afterKeyDown(e) {
    if (e.keyCode === 13) {
      e.stopPropagation();
      e.preventDefault();
      if (e.target.value) {
        if (Array.isArray(this.value)) {
          this.value = [...this.value, e.target.value];
        } else {
          this.value = [e.target.value];
        }
        e.target.value = '';
      }
    } else if (e.keyCode === 8) {
      if (e.target.value.length === 0) {
        if (Array.isArray(this.value) && this.value.length > 0) {
          this.value.splice(-1);
          this.value = [...this.value];
        }
      }
    }
  }
  onBlur(e) {
    if (e.target.value) {
      if (Array.isArray(this.value)) {
        this.value = [...this.value, e.target.value];
      } else {
        this.value = [e.target.value];
      }
      e.target.value = '';
    }
  }
  static get styles() {
    return [i`
      .tags {
        display:flex;
        flex-wrap: wrap;
        outline: none;
        padding:0;
        border-radius:var(--border-radius);
        border:1px solid var(--border-color);
        cursor:text;
        overflow:hidden;
        background:var(--input-bg);
      }
      .tag, .editor {
        padding:3px;
        margin:2px;
      }
      .tag{
        border:1px solid var(--border-color);
        background-color:var(--bg3);
        color:var(--fg3);
        border-radius:var(--border-radius);
        word-break: break-all;
        font-size: var(--font-size-small);
      }
      .tag:hover ~ #cursor {
        display: block;
      }
      .editor {
        flex:1;
        border:1px solid transparent;
        color:var(--fg);
        min-width:60px;
        outline: none;
        line-height: inherit;
        font-family:inherit;
        background:transparent;
        font-size: calc(var(--font-size-small) + 1px);
      }
      .editor:focus-visible {
        outline: 1px solid;
      }
      .editor::placeholder {
        color: var(--placeholder-color);
        opacity:1;
      }
    `];
  }
}
// Register the element with the browser
customElements.define('tag-input', TagInput);
;// ./src/components/api-request.js

 // eslint-disable-line import/extensions
 // eslint-disable-line import/extensions
 // eslint-disable-line import/extensions
 // eslint-disable-line import/extensions
















class ApiRequest extends lit_element_h {
  constructor() {
    super();
    this.responseMessage = '';
    this.responseStatus = 'success';
    this.responseHeaders = '';
    this.responseText = '';
    this.responseUrl = '';
    this.curlSyntax = '';
    this.activeResponseTab = 'response'; // allowed values: response, headers, curl
    this.selectedRequestBodyType = '';
    this.selectedRequestBodyExample = '';
    this.activeParameterSchemaTabs = {};
  }
  static get properties() {
    return {
      serverUrl: {
        type: String,
        attribute: 'server-url'
      },
      servers: {
        type: Array
      },
      method: {
        type: String
      },
      path: {
        type: String
      },
      security: {
        type: Array
      },
      parameters: {
        type: Array
      },
      request_body: {
        type: Object
      },
      api_keys: {
        type: Array
      },
      parser: {
        type: Object
      },
      accept: {
        type: String
      },
      callback: {
        type: String
      },
      webhook: {
        type: String
      },
      responseMessage: {
        type: String,
        attribute: false
      },
      responseText: {
        type: String,
        attribute: false
      },
      responseHeaders: {
        type: String,
        attribute: false
      },
      responseStatus: {
        type: String,
        attribute: false
      },
      responseUrl: {
        type: String,
        attribute: false
      },
      curlSyntax: {
        type: String,
        attribute: false
      },
      fillRequestFieldsWithExample: {
        type: String,
        attribute: 'fill-request-fields-with-example'
      },
      allowTry: {
        type: String,
        attribute: 'allow-try'
      },
      showCurlBeforeTry: {
        type: String,
        attribute: 'show-curl-before-try'
      },
      renderStyle: {
        type: String,
        attribute: 'render-style'
      },
      schemaStyle: {
        type: String,
        attribute: 'schema-style'
      },
      activeSchemaTab: {
        type: String,
        attribute: 'active-schema-tab'
      },
      activeParameterSchemaTabs: {
        type: Object,
        converter: {
          fromAttribute: attr => JSON.parse(attr),
          toAttribute: prop => JSON.stringify(prop)
        },
        attribute: 'active-parameter-schema-tabs'
      },
      schemaExpandLevel: {
        type: Number,
        attribute: 'schema-expand-level'
      },
      schemaDescriptionExpanded: {
        type: String,
        attribute: 'schema-description-expanded'
      },
      allowSchemaDescriptionExpandToggle: {
        type: String,
        attribute: 'allow-schema-description-expand-toggle'
      },
      schemaHideReadOnly: {
        type: String,
        attribute: 'schema-hide-read-only'
      },
      schemaHideWriteOnly: {
        type: String,
        attribute: 'schema-hide-write-only'
      },
      fetchCredentials: {
        type: String,
        attribute: 'fetch-credentials'
      },
      // properties for internal tracking
      activeResponseTab: {
        type: String
      },
      // internal tracking of response-tab not exposed as a attribute
      selectedRequestBodyType: {
        type: String,
        attribute: 'selected-request-body-type'
      },
      // internal tracking of selected request-body type
      selectedRequestBodyExample: {
        type: String,
        attribute: 'selected-request-body-example'
      } // internal tracking of selected request-body example
    };
  }
  static get styles() {
    return [table_styles, input_styles, font_styles, flex_styles, border_styles, tab_styles, prism_styles, i`
        :host {
          container-type: inline-size;
        }
        *, *:before, *:after { box-sizing: border-box; }
        :where(button, input[type="checkbox"], [tabindex="0"]):focus-visible { box-shadow: var(--focus-shadow); }
        :where(input[type="text"], input[type="password"], select, textarea):focus-visible { border-color: var(--primary-color); }
        tag-input:focus-within { outline: 1px solid;}
        .read-mode {
          margin-top: 24px;
        }
        .param-name,
        .param-type {
          margin: 1px 0;
          text-align: right;
          line-height: var(--font-size-small);
        }
        .param-name {
          color: var(--fg); 
          font-family: var(--font-mono);
        }
        .param-name.deprecated { 
          color: var(--red);
        }
        .param-type{
          color: var(--light-fg); 
          font-family: var(--font-regular);
        }
        .param-constraint{
          min-width:100px;
        }
        .param-constraint:empty{
          display:none;
        }
        .top-gap{margin-top:24px;}

        .textarea {
          min-height:220px; 
          padding:5px;
          resize:vertical;
          direction: ltr;
        }
        .example:first-child {
          margin-top: -9px;
        }

        .response-message{
          font-weight:bold;
          text-overflow: ellipsis;
        }
        .response-message.error {
          color:var(--red);
        }
        .response-message.success {
          color:var(--blue);
        }

        .file-input-container {
          align-items:flex-end;
        }
        .file-input-container .input-set:first-child .file-input-remove-btn{
          visibility:hidden;
        }

        .file-input-remove-btn{
          font-size:16px;
          color:var(--red);
          outline: none;
          border: none;
          background:none;
          cursor:pointer;
        }

        .v-tab-btn {
          font-size: var(--smal-font-size);
          height:24px; 
          border:none; 
          background:none; 
          opacity: 0.3;
          cursor: pointer;
          padding: 4px 8px;
        }
        .v-tab-btn.active {
          font-weight: bold;
          background: var(--bg);
          opacity: 1;
        }

        @container (min-width: 768px) {
          .textarea {
            padding:8px;
          }
        }

        @container (max-width: 470px) {
          .hide-in-small-screen {
            display:none;
          }
        }
      `, custom_styles];
  }

  /* eslint-disable indent */
  render() {
    return ke`
    <div class="col regular-font request-panel ${'read focused'.includes(this.renderStyle) || this.callback === 'true' ? 'read-mode' : 'view-mode'}">
      <div class=" ${this.callback === 'true' ? 'tiny-title' : 'req-res-title'} "> 
        ${this.callback === 'true' ? 'CALLBACK REQUEST' : 'REQUEST'}
      </div>
      <div>
        ${guard_It([this.method, this.path, this.allowTry, this.parameters, this.activeParameterSchemaTabs], () => this.inputParametersTemplate('path'))}
        ${guard_It([this.method, this.path, this.allowTry, this.parameters, this.activeParameterSchemaTabs], () => this.inputParametersTemplate('query'))}
        ${this.requestBodyTemplate()}
        ${guard_It([this.method, this.path, this.allowTry, this.parameters, this.activeParameterSchemaTabs], () => this.inputParametersTemplate('header'))}
        ${guard_It([this.method, this.path, this.allowTry, this.parameters, this.activeParameterSchemaTabs], () => this.inputParametersTemplate('cookie'))}
        ${this.allowTry === 'false' ? '' : ke`${this.apiCallTemplate()}`}
      </div>  
    </div>
    `;
  }
  async updated() {
    if (this.showCurlBeforeTry === 'true') {
      this.applyCURLSyntax(this.shadowRoot);
    }

    // In focused mode after rendering the request component, update the text-areas(which contains examples) using
    // the original values from hidden textareas
    // This is done coz, user may update the dom by editing the textarea's and once the DOM is updated externally change detection wont happen, therefore update the values manually

    // if (this.renderStyle === 'focused') {
    //   if (changedProperties.size === 1 && changedProperties.has('activeSchemaTab')) {
    //     // dont update example as only tabs is switched
    //   } else {
    //     this.requestUpdate();
    //   }
    // }

    if (this.webhook === 'true') {
      this.allowTry = 'false';
    }
  }
  async saveExampleState() {
    if (this.renderStyle === 'focused') {
      const reqBodyTextAreaEls = [...this.shadowRoot.querySelectorAll('textarea.request-body-param-user-input')];
      reqBodyTextAreaEls.forEach(el => {
        el.dataset.user_example = el.value;
      });
      const exampleTextAreaEls = [...this.shadowRoot.querySelectorAll('textarea[data-ptype="form-data"]')];
      exampleTextAreaEls.forEach(el => {
        el.dataset.user_example = el.value;
      });
      this.requestUpdate();
    }
  }
  async updateExamplesFromDataAttr() {
    // In focused mode after rendering the request component, update the text-areas(which contains examples) using
    // the original values from hidden textareas
    // This is done coz, user may update the dom by editing the textarea's and once the DOM is updated externally change detection wont happen, therefore update the values manually
    if (this.renderStyle === 'focused') {
      const reqBodyTextAreaEls = [...this.shadowRoot.querySelectorAll('textarea.request-body-param-user-input')];
      reqBodyTextAreaEls.forEach(el => {
        el.value = el.dataset.user_example || el.dataset.example;
      });
      const exampleTextAreaEls = [...this.shadowRoot.querySelectorAll('textarea[data-ptype="form-data"]')];
      exampleTextAreaEls.forEach(el => {
        el.value = el.dataset.user_example || el.dataset.example;
      });
      this.requestUpdate();
    }
  }
  renderExample(example, paramType, paramName) {
    var _example$value, _example$value2;
    return ke`
      ${paramType === 'array' ? '[' : ''}
      <a
        part="anchor anchor-param-example"
        style="display:inline-block; min-width:24px; text-align:center"
        class="${this.allowTry === 'true' ? '' : 'inactive-link'}"
        data-example-type="${paramType === 'array' ? paramType : 'string'}"
        data-example="${example.value && Array.isArray(example.value) ? (_example$value = example.value) === null || _example$value === void 0 ? void 0 : _example$value.join('~|~') : (typeof example.value === 'object' ? JSON.stringify(example.value, null, 2) : example.value) || ''}"
        title="${example.value && Array.isArray(example.value) ? (_example$value2 = example.value) === null || _example$value2 === void 0 ? void 0 : _example$value2.join('~|~') : (typeof example.value === 'object' ? JSON.stringify(example.value, null, 2) : example.value) || ''}"
        @click="${e => {
      const inputEl = e.target.closest('table').querySelector(`[data-pname="${paramName}"]`);
      if (inputEl) {
        inputEl.value = e.target.dataset.exampleType === 'array' ? e.target.dataset.example.split('~|~') : e.target.dataset.example;
      }
    }}"
      > ${example.printableValue || example.value} </a>
      ${paramType === 'array' ? '] ' : ''}
    `;
  }
  renderShortFormatExamples(examples, paramType, paramName) {
    return ke`${examples.map((x, i) => ke`
      ${i === 0 ? '' : '┃'}
      ${this.renderExample(x, paramType, paramName)}`)}`;
  }
  renderLongFormatExamples(exampleList, paramType, paramName) {
    return ke` <ul style="list-style-type: disclosure-closed;">
      ${exampleList.map(v => {
      var _v$summary, _v$description;
      return ke`
          <li>
            ${this.renderExample(v, paramType, paramName)}
            ${((_v$summary = v.summary) === null || _v$summary === void 0 ? void 0 : _v$summary.length) > 0 ? ke`<span>&lpar;${v.summary}&rpar;</span>` : ''}
            ${((_v$description = v.description) === null || _v$description === void 0 ? void 0 : _v$description.length) > 0 ? ke`<p>${unsafe_html_ae(marked(v.description))}</p>` : ''}
          </li>
        `;
    })}
    </ul>`;
  }
  exampleListTemplate(paramName, paramType, exampleList = []) {
    return ke` ${exampleList.length > 0 ? ke`<span style="font-weight:bold">Examples: </span>
          ${anyExampleWithSummaryOrDescription(exampleList) ? this.renderLongFormatExamples(exampleList, paramType, paramName) : this.renderShortFormatExamples(exampleList, paramType, paramName)}` : ''}`;
  }
  inputParametersTemplate(paramType) {
    const filteredParams = this.parameters ? this.parameters.filter(param => param.in === paramType) : [];
    if (filteredParams.length === 0) {
      return '';
    }
    let title = '';
    if (paramType === 'path') {
      title = 'PATH PARAMETERS';
    } else if (paramType === 'query') {
      title = 'QUERY-STRING PARAMETERS';
    } else if (paramType === 'header') {
      title = 'REQUEST HEADERS';
    } else if (paramType === 'cookie') {
      title = 'COOKIES';
    }
    const tableRows = [];
    for (const param of filteredParams) {
      const [declaredParamSchema, serializeStyle, mimeTypeElem] = getSchemaFromParam(param);
      if (!declaredParamSchema) {
        continue;
      }
      const paramSchema = getTypeInfo(declaredParamSchema);
      if (!paramSchema) {
        continue; // eslint-disable-line no-continue
      }
      const schemaAsObj = schemaInObjectNotation(declaredParamSchema, {});
      // let exampleVal = '';
      // let exampleList = [];
      let paramStyle = 'form';
      let paramExplode = true;
      let paramAllowReserved = false;
      if (paramType === 'query' || paramType === 'header' || paramType === 'path') {
        if (param.style && 'form spaceDelimited pipeDelimited'.includes(param.style)) {
          paramStyle = param.style;
        } else if (serializeStyle) {
          paramStyle = serializeStyle;
        }
        if (typeof param.explode === 'boolean') {
          paramExplode = param.explode;
        }
        if (typeof param.allowReserved === 'boolean') {
          paramAllowReserved = param.allowReserved;
        }
      }
      // openapi 3.1.0 spec based examples (which must be Object(string : { value:any, summary?: string, description?: string})
      const example = normalizeExamples(standardizeExample(param.examples) || standardizeExample(param.example) || standardizeExample(mimeTypeElem === null || mimeTypeElem === void 0 ? void 0 : mimeTypeElem.example) || standardizeExample(mimeTypeElem === null || mimeTypeElem === void 0 ? void 0 : mimeTypeElem.examples) || standardizeExample(paramSchema.examples) || standardizeExample(paramSchema.example), paramSchema.type);
      if (!example.exampleVal && paramSchema.type === 'object') {
        example.exampleVal = generateExample(declaredParamSchema, serializeStyle || 'json', {}, {}, this.callback === 'true' || this.webhook === 'true' ? true : false,
        // eslint-disable-line no-unneeded-ternary
        this.callback === 'true' || this.webhook === 'true' ? false : true,
        // eslint-disable-line no-unneeded-ternary
        true, 'text', false)[0].exampleValue;
      }
      const labelColWidth = 'read focused'.includes(this.renderStyle) ? '200px' : '160px';
      tableRows.push(ke`
      <tr title="${param.deprecated ? 'Deprecated' : ''}"> 
        <td rowspan="${this.allowTry === 'true' ? '1' : '2'}" style="width:${labelColWidth}; min-width:100px;">
          <div class="param-name ${param.deprecated ? 'deprecated' : ''}" >
            ${param.deprecated ? ke`<svg viewBox="0 0 10 10" width="10" height="10" style="stroke:var(--red); margin-right:-6px"><path d="M2 2L8 8M2 8L8 2"/></svg>` : ''}
            ${param.required ? ke`<span style='color:var(--red)'>*</span>` : ''}
            ${param.name}
          </div>
          <div class="param-type">
            ${paramSchema.type === 'array' ? `${paramSchema.arrayType}` : `${paramSchema.format ? paramSchema.format : paramSchema.type}`}
          </div>
        </td>  
        ${this.allowTry === 'true' ? ke`
            <td style="min-width:100px;" colspan="${paramSchema.default || paramSchema.constrain || paramSchema.allowedValues || paramSchema.pattern ? '1' : '2'}">
              ${paramSchema.type === 'array' ? ke`
                  <tag-input class="request-param" 
                    id = "tag-input-request-param-${param.name}"
                    style = "width:100%" 
                    data-ptype = "${paramType}"
                    data-pname = "${param.name}"
                    data-example = "${Array.isArray(example.exampleVal) ? example.exampleVal.join('~|~') : example.exampleVal}"
                    data-param-serialize-style = "${paramStyle}"
                    data-param-serialize-explode = "${paramExplode}"
                    data-param-allow-reserved = "${paramAllowReserved}"
                    data-x-fill-example = "${param['x-fill-example'] || 'yes'}"
                    data-array = "true"
                    placeholder = "add-multiple &#x21a9;"
                    .value="${param['x-fill-example'] === 'no' ? [] : live_Ft(this.fillRequestFieldsWithExample === 'true' ? Array.isArray(example.exampleVal) ? example.exampleVal : [example.exampleVal] : [])}"
                  >
                  </tag-input>` : paramSchema.type === 'object' ? ke`
                    <div part="tab-panel" class="tab-panel col" style="border-width:0 0 1px 0;">
                      <div part="tab-btn-row" class="tab-buttons row" @click="${e => {
        if (e.target.tagName.toLowerCase() === 'button') {
          const newState = {
            ...this.activeParameterSchemaTabs
          };
          newState[param.name] = e.target.dataset.tab;
          this.activeParameterSchemaTabs = newState;
        }
      }}">
                        <button part="tab-btn" class="tab-btn ${this.activeParameterSchemaTabs[param.name] === 'example' ? 'active' : ''}" data-tab = 'example'>EXAMPLE </button>
                        <button part="tab-btn" class="tab-btn ${this.activeParameterSchemaTabs[param.name] !== 'example' ? 'active' : ''}" data-tab = 'schema'>SCHEMA</button>
                      </div>

                    ${ke`<div part="tab-content" class="tab-content col" data-tab = 'example' style="display:${this.activeParameterSchemaTabs[param.name] === 'example' ? 'block' : 'none'}; padding-left:5px; width:100%">
                        <textarea 
                          id = "textarea-request-param-${param.name}"
                          class = "textarea request-param"
                          part = "textarea textarea-param"
                          data-ptype = "${paramType}-object"
                          data-pname = "${param.name}"
                          data-example = "${example.exampleVal}"
                          data-param-serialize-style = "${paramStyle}"
                          data-param-serialize-explode = "${paramExplode}"
                          data-param-allow-reserved = "${paramAllowReserved}"
                          data-x-fill-example = "${param['x-fill-example'] || 'yes'}"
                          spellcheck = "false"
                          .textContent="${param['x-fill-example'] === 'no' ? '' : live_Ft(this.fillRequestFieldsWithExample === 'true' ? typeof example.exampleVal === 'object' ? JSON.stringify(example.exampleVal, null, 2) : example.exampleVal : '')}"
                          style = "resize:vertical; width:100%; height: ${'read focused'.includes(this.renderStyle) ? '180px' : '120px'};"
                          @input=${e => {
        const requestPanelEl = this.getRequestPanel(e);
        this.liveCURLSyntaxUpdate(requestPanelEl);
      }}
                        ></textarea>
                      </div>`}
                    ${ke`<div part="tab-content" class="tab-content col" data-tab = 'schema' style="display:${this.activeParameterSchemaTabs[param.name] !== 'example' ? 'block' : 'none'}; padding-left:5px; width:100%;">
                        <schema-tree
                          class = 'json'
                          style = 'display: block'
                          .data = '${schemaAsObj}'
                          schema-expand-level = "${this.schemaExpandLevel}"
                          schema-description-expanded = "${this.schemaDescriptionExpanded}"
                          allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
                          schema-hide-read-only = "${this.schemaHideReadOnly.includes(this.method)}"
                          schema-hide-write-only = "${this.schemaHideWriteOnly.includes(this.method)}"
                          exportparts = "wrap-request-btn:wrap-request-btn, btn:btn, btn-fill:btn-fill, btn-outline:btn-outline, btn-try:btn-try, btn-clear:btn-clear, btn-clear-resp:btn-clear-resp,
                            file-input:file-input, textbox:textbox, textbox-param:textbox-param, textarea:textarea, textarea-param:textarea-param, 
                            anchor:anchor, anchor-param-example:anchor-param-example"
                        > </schema-tree>
                      </div>`}
                  </div>` : ke`
                    <input type="${paramSchema.format === 'password' ? 'password' : 'text'}" spellcheck="false" style="width:100%" 
                      id="input-request-param-${param.name}"
                      class="request-param"
                      part="textbox textbox-param"
                      data-ptype="${paramType}"
                      data-pname="${param.name}" 
                      data-example="${Array.isArray(example.exampleVal) ? example.exampleVal.join('~|~') : example.exampleVal}"
                      data-param-allow-reserved = "${paramAllowReserved}"
                      data-x-fill-example = "${param['x-fill-example'] || 'yes'}"
                      data-array="false"
                      .value="${param['x-fill-example'] === 'no' ? '' : live_Ft(this.fillRequestFieldsWithExample === 'true' ? example.exampleVal : '')}"
                      @input=${e => {
        const requestPanelEl = this.getRequestPanel(e);
        this.liveCURLSyntaxUpdate(requestPanelEl);
      }}
                    />`}
            </td>` : ''}
        ${paramSchema.default || paramSchema.constrain || paramSchema.allowedValues || paramSchema.pattern ? ke`
            <td colspan="${this.allowTry === 'true' ? '1' : '2'}">
              <div class="param-constraint">
                ${paramSchema.default ? ke`<span style="font-weight:bold">Default: </span>${paramSchema.default}<br/>` : ''}
                ${paramSchema.pattern ? ke`<span style="font-weight:bold">Pattern: </span>${paramSchema.pattern}<br/>` : ''}
                ${paramSchema.constrain ? ke`${paramSchema.constrain}<br/>` : ''}
                ${paramSchema.allowedValues && paramSchema.allowedValues.split('┃').map((v, i) => ke`
                  ${i > 0 ? '┃' : ke`<span style="font-weight:bold">Allowed: </span>`}
                  ${ke`
                    <a part="anchor anchor-param-constraint" class = "${this.allowTry === 'true' ? '' : 'inactive-link'}"
                      data-type="${paramSchema.type === 'array' ? paramSchema.type : 'string'}"
                      data-enum="${v.trim()}"
                      @click="${e => {
        const inputEl = e.target.closest('table').querySelector(`[data-pname="${param.name}"]`);
        if (inputEl) {
          if (e.target.dataset.type === 'array') {
            inputEl.value = [e.target.dataset.enum];
          } else {
            inputEl.value = e.target.dataset.enum;
          }
        }
      }}"
                    >${v}</a>`}`)}
              </div>
            </td>` : ke`<td></td>`}
      </tr>
      <tr>
        ${this.allowTry === 'true' ? ke`<td style="border:none"> </td>` : ''}
        <td colspan="2" style="border:none">
          <span class="m-markdown-small">${unsafe_html_ae(marked(param.description || ''))}</span>
          ${this.exampleListTemplate.call(this, param.name, paramSchema.type, example.exampleList)}
        </td>
      </tr>
    `);
    }
    return ke`
    <div class="table-title top-gap">${title}</div>
    <div style="display:block; overflow-x:auto; max-width:100%;">
      <table role="presentation" class="m-table" style="width:100%; word-break:break-word;">
        ${tableRows}
      </table>
    </div>`;
  }

  // This method is called before navigation change in focused mode
  async beforeNavigationFocusedMode() {
    // this.saveExampleState();
  }

  // This method is called after navigation change in focused mode
  async afterNavigationFocusedMode() {
    this.selectedRequestBodyType = '';
    this.selectedRequestBodyExample = '';
    this.updateExamplesFromDataAttr();
    this.clearResponseData();
  }

  // Request-Body Event Handlers
  onSelectExample(e) {
    this.selectedRequestBodyExample = e.target.value;
    const exampleDropdownEl = e.target;
    window.setTimeout(selectEl => {
      const readOnlyExampleEl = selectEl.closest('.example-panel').querySelector('.request-body-param');
      const userInputExampleTextareaEl = selectEl.closest('.example-panel').querySelector('.request-body-param-user-input');
      userInputExampleTextareaEl.value = readOnlyExampleEl.innerText;
      const requestPanelEl = this.getRequestPanel({
        target: selectEl
      });
      this.liveCURLSyntaxUpdate(requestPanelEl);
    }, 0, exampleDropdownEl);
  }
  onMimeTypeChange(e) {
    this.selectedRequestBodyType = e.target.value;
    const mimeDropdownEl = e.target;
    this.selectedRequestBodyExample = '';
    window.setTimeout(selectEl => {
      const readOnlyExampleEl = selectEl.closest('.request-body-container').querySelector('.request-body-param');
      if (readOnlyExampleEl) {
        const userInputExampleTextareaEl = selectEl.closest('.request-body-container').querySelector('.request-body-param-user-input');
        userInputExampleTextareaEl.value = readOnlyExampleEl.innerText;
      }
    }, 0, mimeDropdownEl);
  }
  requestBodyTemplate() {
    if (!this.request_body) {
      return '';
    }
    if (Object.keys(this.request_body).length === 0) {
      return '';
    }

    // Variable to store partial HTMLs
    let reqBodyTypeSelectorHtml = '';
    let reqBodyFileInputHtml = '';
    let reqBodyFormHtml = '';
    let reqBodySchemaHtml = '';
    let reqBodyExampleHtml = '';
    const requestBodyTypes = [];
    const {
      content
    } = this.request_body;
    for (const mimeType in content) {
      requestBodyTypes.push({
        mimeType,
        schema: content[mimeType].schema,
        example: content[mimeType].example,
        examples: content[mimeType].examples
      });
      if (!this.selectedRequestBodyType) {
        this.selectedRequestBodyType = mimeType;
      }
    }
    // MIME Type selector
    reqBodyTypeSelectorHtml = requestBodyTypes.length === 1 ? '' : ke`
        <select style="min-width:100px; max-width:100%;  margin-bottom:-1px;" @change = '${e => this.onMimeTypeChange(e)}'>
          ${requestBodyTypes.map(reqBody => ke`
            <option value = '${reqBody.mimeType}' ?selected = '${reqBody.mimeType === this.selectedRequestBodyType}'>
              ${reqBody.mimeType}
            </option> `)}
        </select>
      `;

    // For Loop - Main
    requestBodyTypes.forEach(reqBody => {
      let schemaAsObj;
      let reqBodyExamples = [];
      if (this.selectedRequestBodyType.includes('json') || this.selectedRequestBodyType.includes('xml') || this.selectedRequestBodyType.includes('text') || this.selectedRequestBodyType.includes('jose')) {
        // Generate Example
        if (reqBody.mimeType === this.selectedRequestBodyType) {
          reqBodyExamples = generateExample(reqBody.schema, reqBody.mimeType, standardizeExample(reqBody.examples), standardizeExample(reqBody.example), this.callback === 'true' || this.webhook === 'true' ? true : false,
          // eslint-disable-line no-unneeded-ternary
          this.callback === 'true' || this.webhook === 'true' ? false : true,
          // eslint-disable-line no-unneeded-ternary
          'text', false);
          if (!this.selectedRequestBodyExample) {
            this.selectedRequestBodyExample = reqBodyExamples.length > 0 ? reqBodyExamples[0].exampleId : '';
          }
          reqBodyExampleHtml = ke`
            ${reqBodyExampleHtml}
            <div class = 'example-panel border-top pad-top-8'>
              ${reqBodyExamples.length === 1 ? '' : ke`
                  <select style="min-width:100px; max-width:100%;  margin-bottom:-1px;" @change='${e => this.onSelectExample(e)}'>
                    ${reqBodyExamples.map(v => ke`<option value="${v.exampleId}" ?selected=${v.exampleId === this.selectedRequestBodyExample} > 
                      ${v.exampleSummary.length > 80 ? v.exampleId : v.exampleSummary ? v.exampleSummary : v.exampleId} 
                    </option>`)}
                  </select>
                `}
              ${reqBodyExamples.filter(v => v.exampleId === this.selectedRequestBodyExample).map(v => ke`
                <div class="example ${v.exampleId === this.selectedRequestBodyExample ? 'example-selected' : ''}" data-example = '${v.exampleId}'>
                  ${v.exampleSummary && v.exampleSummary.length > 80 ? ke`<div style="padding: 4px 0"> ${v.exampleSummary} </div>` : ''}
                  ${v.exampleDescription ? ke`<div class="m-markdown-small" style="padding: 4px 0"> ${unsafe_html_ae(marked(v.exampleDescription || ''))} </div>` : ''}
                  <!-- This pre(hidden) is to store the original example value, this will remain unchanged when users switches from one example to another, its is used to populate the editable textarea -->
                  <pre 
                    class = "textarea is-hidden request-body-param ${reqBody.mimeType.substring(reqBody.mimeType.indexOf('/') + 1)}" 
                    spellcheck = "false"
                    data-ptype = "${reqBody.mimeType}" 
                    style="width:100%; resize:vertical; display:none"
                  >${v.exampleFormat === 'text' ? v.exampleValue : JSON.stringify(v.exampleValue, null, 2)}</pre>

                  <!-- this textarea is for user to edit the example -->
                  <textarea 
                    class = "textarea request-body-param-user-input"
                    part = "textarea textarea-param"
                    spellcheck = "false"
                    data-ptype = "${reqBody.mimeType}" 
                    data-example = "${v.exampleFormat === 'text' ? v.exampleValue : JSON.stringify(v.exampleValue, null, 2)}"
                    data-example-format = "${v.exampleFormat}"
                    style="width:100%; resize:vertical;"
                    .textContent = "${this.fillRequestFieldsWithExample === 'true' ? v.exampleFormat === 'text' ? v.exampleValue : JSON.stringify(v.exampleValue, null, 2) : ''}"
                    @input=${e => {
            const requestPanelEl = this.getRequestPanel(e);
            this.liveCURLSyntaxUpdate(requestPanelEl);
          }}
                    @keydown=${e => {
            if ((e.keyCode === 10 || e.keyCode === 13) && e.ctrlKey) {
              return this.onTryClick(e);
            }
          }}

                  ></textarea>
                </div>  
              `)}

            </div>
          `;
        }
      } else if (this.selectedRequestBodyType.includes('form-urlencoded') || this.selectedRequestBodyType.includes('form-data')) {
        if (reqBody.mimeType === this.selectedRequestBodyType) {
          const ex = generateExample(reqBody.schema, reqBody.mimeType, reqBody.examples, reqBody.example, this.callback === 'true' || this.webhook === 'true' ? true : false,
          // eslint-disable-line no-unneeded-ternary
          this.callback === 'true' || this.webhook === 'true' ? false : true,
          // eslint-disable-line no-unneeded-ternary
          'text', false);
          if (reqBody.schema) {
            reqBodyFormHtml = this.formDataTemplate(reqBody.schema, reqBody.mimeType, ex[0] ? ex[0].exampleValue : '');
          }
        }
      } else if (/^audio\/|^image\/|^video\/|^font\/|tar$|zip$|7z$|rtf$|msword$|excel$|\/pdf$|\/octet-stream$/.test(this.selectedRequestBodyType)) {
        if (reqBody.mimeType === this.selectedRequestBodyType) {
          reqBodyFileInputHtml = ke`
            <div class = "small-font-size bold-text row">
              <input id="input-request-body-param-file" type="file" part="file-input" style="max-width:100%" class="request-body-param-file" data-ptype="${reqBody.mimeType}" spellcheck="false" />
            </div>  
          `;
        }
      }

      // Generate Schema
      if (reqBody.mimeType.includes('json') || reqBody.mimeType.includes('xml') || reqBody.mimeType.includes('text') || this.selectedRequestBodyType.includes('jose')) {
        schemaAsObj = schemaInObjectNotation(reqBody.schema, {});
        if (this.schemaStyle === 'table') {
          reqBodySchemaHtml = ke`
            ${reqBodySchemaHtml}
            <schema-table
              class = '${reqBody.mimeType.substring(reqBody.mimeType.indexOf('/') + 1)}'
              style = 'display: ${this.selectedRequestBodyType === reqBody.mimeType ? 'block' : 'none'};'
              .data = '${schemaAsObj}'
              schema-expand-level = "${this.schemaExpandLevel}"
              schema-description-expanded = "${this.schemaDescriptionExpanded}"
              allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
              schema-hide-read-only = "${this.schemaHideReadOnly}"
              schema-hide-write-only = "${this.schemaHideWriteOnly}"
              exportparts = "schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
            > </schema-table>
          `;
        } else if (this.schemaStyle === 'tree') {
          reqBodySchemaHtml = ke`
            ${reqBodySchemaHtml}
            <schema-tree
              class = "${reqBody.mimeType.substring(reqBody.mimeType.indexOf('/') + 1)}"
              style = "display: ${this.selectedRequestBodyType === reqBody.mimeType ? 'block' : 'none'};"
              .data = "${schemaAsObj}"
              schema-expand-level = "${this.schemaExpandLevel}"
              schema-description-expanded = "${this.schemaDescriptionExpanded}"
              allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
              schema-hide-read-only = "${this.schemaHideReadOnly}"
              schema-hide-write-only = "${this.schemaHideWriteOnly}"
              exportparts = "schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
            > </schema-tree>
          `;
        }
      }
    });
    return ke`
      <div class='request-body-container' data-selected-request-body-type="${this.selectedRequestBodyType}">
        <div class="table-title top-gap row">
          REQUEST BODY ${this.request_body.required ? ke`<span class="mono-font" style='color:var(--red)'>*</span>` : ''} 
          <span style = "font-weight:normal; margin-left:5px"> ${this.selectedRequestBodyType}</span>
          <span style="flex:1"></span>
          ${reqBodyTypeSelectorHtml}
        </div>
        ${this.request_body.description ? ke`<div class="m-markdown" style="margin-bottom:12px">${unsafe_html_ae(marked(this.request_body.description))}</div>` : ''}
        
        ${this.selectedRequestBodyType.includes('json') || this.selectedRequestBodyType.includes('xml') || this.selectedRequestBodyType.includes('text') || this.selectedRequestBodyType.includes('jose') ? ke`
            <div part="tab-panel" class="tab-panel col" style="border-width:0 0 1px 0;">
              <div part="tab-btn-row" class="tab-buttons row" @click="${e => {
      if (e.target.tagName.toLowerCase() === 'button') {
        this.activeSchemaTab = e.target.dataset.tab;
      }
    }}">
                <button part="tab-btn" class="tab-btn ${this.activeSchemaTab === 'example' ? 'active' : ''}" data-tab = 'example'>EXAMPLE</button>
                <button part="tab-btn" class="tab-btn ${this.activeSchemaTab !== 'example' ? 'active' : ''}" data-tab = 'schema'>SCHEMA</button>
              </div>
              ${ke`<div part="tab-content" class="tab-content col" style="display:${this.activeSchemaTab === 'example' ? 'block' : 'none'};"> ${reqBodyExampleHtml}</div>`}
              ${ke`<div part="tab-content" class="tab-content col" style="display:${this.activeSchemaTab === 'example' ? 'none' : 'block'};"> ${reqBodySchemaHtml}</div>`}
            </div>` : ke`  
            ${reqBodyFileInputHtml}
            ${reqBodyFormHtml}`}
      </div>  
    `;
  }
  formDataParamAsObjectTemplate(fieldName, fieldSchema, mimeType) {
    var _formdataPartExample$;
    // This template is used when form-data param should be send as a object (application/json, application/xml)
    const formdataPartSchema = schemaInObjectNotation(fieldSchema, {});
    const formdataPartExample = generateExample(fieldSchema, 'json', standardizeExample(fieldSchema.examples), standardizeExample(fieldSchema.example), this.callback === 'true' || this.webhook === 'true' ? true : false,
    // eslint-disable-line no-unneeded-ternary
    this.callback === 'true' || this.webhook === 'true' ? false : true,
    // eslint-disable-line no-unneeded-ternary
    'text', false);
    return ke`
      <div part="tab-panel" class="tab-panel row" style="min-height:220px; border-left: 6px solid var(--light-border-color); align-items: stretch;">
        <div style="width:24px; background-color:var(--light-border-color)">
          <div class="row" style="flex-direction:row-reverse; width:160px; height:24px; transform:rotate(270deg) translateX(-160px); transform-origin:top left; display:block;" @click="${e => {
      if (e.target.classList.contains('v-tab-btn')) {
        const {
          tab
        } = e.target.dataset;
        if (tab) {
          const tabPanelEl = e.target.closest('.tab-panel');
          const selectedTabBtnEl = tabPanelEl.querySelector(`.v-tab-btn[data-tab="${tab}"]`);
          const otherTabBtnEl = [...tabPanelEl.querySelectorAll(`.v-tab-btn:not([data-tab="${tab}"])`)];
          const selectedTabContentEl = tabPanelEl.querySelector(`.tab-content[data-tab="${tab}"]`);
          const otherTabContentEl = [...tabPanelEl.querySelectorAll(`.tab-content:not([data-tab="${tab}"])`)];
          selectedTabBtnEl.classList.add('active');
          selectedTabContentEl.style.display = 'block';
          otherTabBtnEl.forEach(el => {
            el.classList.remove('active');
          });
          otherTabContentEl.forEach(el => {
            el.style.display = 'none';
          });
        }
      }
      if (e.target.tagName.toLowerCase() === 'button') {
        this.activeSchemaTab = e.target.dataset.tab;
      }
    }}">
          <button class="v-tab-btn ${this.activeSchemaTab === 'example' ? 'active' : ''}" data-tab = 'example'>EXAMPLE</button>
          <button class="v-tab-btn ${this.activeSchemaTab !== 'example' ? 'active' : ''}" data-tab = 'schema'>SCHEMA</button>
        </div>
      </div>
      ${ke`
        <div class="tab-content col" data-tab = 'example' style="display:${this.activeSchemaTab === 'example' ? 'block' : 'none'}; padding-left:5px; width:100%"> 
          <textarea 
            class = "textarea"
            part = "textarea textarea-param"
            style = "width:100%; border:none; resize:vertical;" 
            data-array = "false" 
            data-ptype = "${mimeType.includes('form-urlencode') ? 'form-urlencode' : 'form-data'}"
            data-pname = "${fieldName}"
            data-example = "${((_formdataPartExample$ = formdataPartExample[0]) === null || _formdataPartExample$ === void 0 ? void 0 : _formdataPartExample$.exampleValue) || ''}"
            .textContent = "${this.fillRequestFieldsWithExample === 'true' ? formdataPartExample[0].exampleValue : ''}"
            spellcheck = "false"
          ></textarea>
        </div>`}
      ${ke`
        <div class="tab-content col" data-tab = 'schema' style="display:${this.activeSchemaTab !== 'example' ? 'block' : 'none'}; padding-left:5px; width:100%;"> 
          <schema-tree
            .data = "${formdataPartSchema}"
            schema-expand-level = "${this.schemaExpandLevel}"
            schema-description-expanded = "${this.schemaDescriptionExpanded}"
            allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}",
          > </schema-tree>
        </div>`}
      </div>
    `;
  }
  formDataTemplate(schema, mimeType, exampleValue = '') {
    const formDataTableRows = [];
    if (schema.properties) {
      for (const fieldName in schema.properties) {
        var _schema$required, _fieldSchema$items;
        const fieldSchema = schema.properties[fieldName];
        if (fieldSchema.readOnly) {
          continue;
        }
        const fieldExamples = fieldSchema.examples || fieldSchema.example || '';
        const fieldType = fieldSchema.type;
        const paramSchema = getTypeInfo(fieldSchema);
        const labelColWidth = 'read focused'.includes(this.renderStyle) ? '200px' : '160px';
        const example = normalizeExamples(paramSchema.examples || paramSchema.example, paramSchema.type);
        formDataTableRows.push(ke`
        <tr title="${fieldSchema.deprecated ? 'Deprecated' : ''}"> 
          <td style="width:${labelColWidth}; min-width:100px;">
            <div class="param-name ${fieldSchema.deprecated ? 'deprecated' : ''}">
              ${fieldName}${(_schema$required = schema.required) !== null && _schema$required !== void 0 && _schema$required.includes(fieldName) || fieldSchema.required ? ke`<span style='color:var(--red);'>*</span>` : ''}
            </div>
            <div class="param-type">${paramSchema.type}</div>
          </td>  
          <td 
            style="${fieldType === 'object' ? 'width:100%; padding:0;' : this.allowTry === 'true' ? '' : 'display:none;'} min-width:100px;" 
            colspan="${fieldType === 'object' ? 2 : 1}">
            ${fieldType === 'array' ? ((_fieldSchema$items = fieldSchema.items) === null || _fieldSchema$items === void 0 ? void 0 : _fieldSchema$items.format) === 'binary' ? ke`
                <div class="file-input-container col" style='align-items:flex-end;' @click="${e => this.onAddRemoveFileInput(e, fieldName, mimeType)}">
                  <div class='input-set row'>
                    <input 
                      type = "file"
                      part = "file-input"
                      style = "width:100%" 
                      data-pname = "${fieldName}" 
                      data-ptype = "${mimeType.includes('form-urlencode') ? 'form-urlencode' : 'form-data'}"
                      data-array = "false" 
                      data-file-array = "true" 
                    />
                    <button class="file-input-remove-btn"> &#x2715; </button>
                  </div>  
                  <button class="m-btn primary file-input-add-btn" part="btn btn-fill" style="margin:2px 25px 0 0; padding:2px 6px;">ADD</button>
                </div>  
                ` : ke`
                  <tag-input
                    style = "width:100%" 
                    data-ptype = "${mimeType.includes('form-urlencode') ? 'form-urlencode' : 'form-data'}"
                    data-pname = "${fieldName}"
                    data-example = "${Array.isArray(fieldExamples) ? fieldExamples.join('~|~') : fieldExamples}"
                    data-array = "true"
                    placeholder = "add-multiple &#x21a9;"
                    .value = "${Array.isArray(fieldExamples) ? Array.isArray(fieldExamples[0]) ? fieldExamples[0] : fieldExamples : []}"
                  >
                  </tag-input>
                ` : ke`
                ${fieldType === 'object' ? this.formDataParamAsObjectTemplate.call(this, fieldName, fieldSchema, mimeType) : ke`
                    ${this.allowTry === 'true' ? ke`<input
                          .value = "${this.fillRequestFieldsWithExample === 'true' ? example.exampleVal : ''}"
                          spellcheck = "false"
                          type = "${fieldSchema.format === 'binary' ? 'file' : fieldSchema.format === 'password' ? 'password' : 'text'}"
                          part = "textbox textbox-param"
                          style = "width:100%"
                          data-ptype = "${mimeType.includes('form-urlencode') ? 'form-urlencode' : 'form-data'}"
                          data-pname = "${fieldName}"
                          data-example = "${Array.isArray(fieldExamples) ? fieldExamples[0] : fieldExamples}"
                          data-array = "false"
                        />` : ''}
                    `}`}
          </td>
          ${fieldType === 'object' ? '' : ke`
              <td>
                ${paramSchema.default || paramSchema.constrain || paramSchema.allowedValues || paramSchema.pattern ? ke`
                    <div class="param-constraint">
                      ${paramSchema.default ? ke`<span style="font-weight:bold">Default: </span>${paramSchema.default}<br/>` : ''}
                      ${paramSchema.pattern ? ke`<span style="font-weight:bold">Pattern: </span>${paramSchema.pattern}<br/>` : ''}
                      ${paramSchema.constrain ? ke`${paramSchema.constrain}<br/>` : ''}
                      ${paramSchema.allowedValues && paramSchema.allowedValues.split('┃').map((v, i) => ke`
                        ${i > 0 ? '┃' : ke`<span style="font-weight:bold">Allowed: </span>`}
                        ${ke`
                          <a part="anchor anchor-param-constraint" class = "${this.allowTry === 'true' ? '' : 'inactive-link'}"
                            data-type="${paramSchema.type === 'array' ? paramSchema.type : 'string'}"
                            data-enum="${v.trim()}"
                            @click="${e => {
          const inputEl = e.target.closest('table').querySelector(`[data-pname="${fieldName}"]`);
          if (inputEl) {
            if (e.target.dataset.type === 'array') {
              inputEl.value = [e.target.dataset.enum];
            } else {
              inputEl.value = e.target.dataset.enum;
            }
          }
        }}"
                          > 
                            ${v} 
                          </a>`}`)}
                    </div>` : ''}
              </td>`}
        </tr>
        ${fieldType === 'object' ? '' : ke`
            <tr>
              <td style="border:none"> </td>
              <td colspan="2" style="border:none; margin-top:0; padding:0 5px 8px 5px;"> 
                <span class="m-markdown-small">${unsafe_html_ae(marked(fieldSchema.description || ''))}</span>
                ${this.exampleListTemplate.call(this, fieldName, paramSchema.type, example.exampleList)}
              </td>
            </tr>
          `}`);
      }
      return ke`
        <table role="presentation" style="width:100%;" class="m-table">
          ${formDataTableRows}
        </table>
      `;
    }
    return ke`
      <textarea
        class = "textarea dynamic-form-param ${mimeType}"
        part = "textarea textarea-param"
        spellcheck = "false"
        data-pname="dynamic-form" 
        data-ptype="${mimeType}"
        .textContent = "${exampleValue}"
        style="width:100%"
      ></textarea>
      ${schema.description ? ke`<span class="m-markdown-small">${unsafe_html_ae(marked(schema.description))}</span>` : ''}
    `;
  }
  curlSyntaxTemplate(display = 'flex') {
    return ke`
      <div class="col m-markdown" style="flex:1; display:${display}; position:relative; max-width: 100%;">
        <button  class="toolbar-btn" style = "position:absolute; top:12px; right:8px" @click='${e => {
      copyToClipboard(this.curlSyntax.trim().replace(/\\$/, ''), e);
    }}' part="btn btn-fill"> Copy </button>
        <pre style="white-space:pre"><code>${unsafe_html_ae(prism_default().highlight(this.curlSyntax.trim().replace(/\\$/, ''), (prism_default()).languages.shell, 'shell'))}</code></pre>
      </div>
      `;
  }
  apiResponseTabTemplate() {
    let responseFormat = '';
    let responseContent = '';
    if (!this.responseIsBlob) {
      if (this.responseHeaders.includes('application/x-ndjson')) {
        responseFormat = 'json';
        const prismLines = this.responseText.split('\n').map(q => prism_default().highlight(q, (prism_default()).languages[responseFormat], responseFormat)).join('\n');
        responseContent = ke`<code>${unsafe_html_ae(prismLines)}</code>`;
      } else if (this.responseHeaders.includes('json')) {
        responseFormat = 'json';
        responseContent = ke`<code>${unsafe_html_ae(prism_default().highlight(this.responseText, (prism_default()).languages[responseFormat], responseFormat))}</code>`;
      } else if (this.responseHeaders.includes('html') || this.responseHeaders.includes('xml')) {
        responseFormat = 'html';
        responseContent = ke`<code>${unsafe_html_ae(prism_default().highlight(this.responseText, (prism_default()).languages[responseFormat], responseFormat))}</code>`;
      } else {
        responseFormat = 'text';
        responseContent = ke`<code>${this.responseText}</code>`;
      }
    }
    return ke`
      <div class="row" style="font-size:var(--font-size-small); margin:5px 0">
        <div class="response-message ${this.responseStatus}">Response Status: ${this.responseMessage}</div>
        <div style="flex:1"></div>
        <button class="m-btn" part="btn btn-outline btn-clear-response" @click="${this.clearResponseData}">CLEAR RESPONSE</button>
      </div>
      <div part="tab-panel" class="tab-panel col" style="border-width:0 0 1px 0;">
        <div id="tab_buttons" part="tab-btn-row" class="tab-buttons row" @click="${e => {
      if (e.target.classList.contains('tab-btn') === false) {
        return;
      }
      this.activeResponseTab = e.target.dataset.tab;
    }}">
          <button part="tab-btn" class="tab-btn ${this.activeResponseTab === 'response' ? 'active' : ''}" data-tab = 'response' > RESPONSE</button>
          <button part="tab-btn" class="tab-btn ${this.activeResponseTab === 'headers' ? 'active' : ''}"  data-tab = 'headers' > RESPONSE HEADERS</button>
          ${this.showCurlBeforeTry === 'true' ? '' : ke`<button part="tab-btn" class="tab-btn ${this.activeResponseTab === 'curl' ? 'active' : ''}" data-tab = 'curl'>CURL</button>`}
        </div>
        ${this.responseIsBlob ? ke`
            <div part="tab-content" class="tab-content col" style="flex:1; display:${this.activeResponseTab === 'response' ? 'flex' : 'none'};">
              ${this.responseBlobType === 'image' ? ke`<img style="max-height:var(--resp-area-height, 400px); object-fit:contain;" class="mar-top-8" src="${if_defined_to(this.responseBlobUrl)}"></img>` : ''}  
              <button class="m-btn thin-border mar-top-8" style="width:135px" @click='${e => {
      downloadResource(this.responseBlobUrl, this.respContentDisposition, e);
    }}' part="btn btn-outline">
                DOWNLOAD
              </button>
              ${this.responseBlobType === 'view' || this.responseBlobType === 'image' ? ke`<button class="m-btn thin-border mar-top-8" style="width:135px"  @click='${e => {
      viewResource(this.responseBlobUrl, e);
    }}' part="btn btn-outline">VIEW (NEW TAB)</button>` : ''}
            </div>` : ke`
            <div part="tab-content" class="tab-content col m-markdown" style="flex:1; display:${this.activeResponseTab === 'response' ? 'flex' : 'none'};" >
              <button class="toolbar-btn" style="position:absolute; top:12px; right:8px" @click='${e => {
      copyToClipboard(this.responseText, e);
    }}' part="btn btn-fill"> Copy </button>
              <pre style="white-space:pre; min-height:50px; height:var(--resp-area-height, 400px); resize:vertical; overflow:auto">${responseContent}</pre>
            </div>`}
        <div part="tab-content" class="tab-content col m-markdown" style="flex:1; display:${this.activeResponseTab === 'headers' ? 'flex' : 'none'};" >
          <button  class="toolbar-btn" style = "position:absolute; top:12px; right:8px" @click='${e => {
      copyToClipboard(this.responseHeaders, e);
    }}' part="btn btn-fill"> Copy </button>
          <pre style="white-space:pre"><code>${unsafe_html_ae(prism_default().highlight(this.responseHeaders, (prism_default()).languages.css, 'css'))}</code></pre>
        </div>
        ${this.showCurlBeforeTry === 'true' ? '' : this.curlSyntaxTemplate(this.activeResponseTab === 'curl' ? 'flex' : 'none')}
      </div>`;
  }
  apiCallTemplate() {
    var _this$security, _this$api_keys$;
    const selectedServerHtml = ke`
      <div style="display:flex; flex-direction:column;">
        ${this.serverUrl ? ke`
            <div style="display:flex; align-items:baseline;">
              <div style="font-weight:bold; padding-right:5px;">API Server</div> 
              <span class = "gray-text"> ${this.serverUrl} </span>
            </div>
          ` : ''}
      </div>  
    `;
    return ke`
    <div style="display:flex; align-items:flex-end; margin:16px 0; font-size:var(--font-size-small);" part="wrap-request-btn">
      <div class="hide-in-small-screen" style="flex-direction:column; margin:0; width:calc(100% - 60px);">
        <div style="display:flex; flex-direction:row; align-items:center; overflow:hidden;"> 
          ${selectedServerHtml}
        </div>
        <div style="display:flex;">
          <div style="font-weight:bold; padding-right:5px;">Authentication</div>
          ${((_this$security = this.security) === null || _this$security === void 0 ? void 0 : _this$security.length) > 0 ? ke`
              ${this.api_keys.length > 0 ? ke`<div style="color:var(--blue); overflow:hidden;"> 
                    ${this.api_keys.length === 1 ? `${(_this$api_keys$ = this.api_keys[0]) === null || _this$api_keys$ === void 0 ? void 0 : _this$api_keys$.typeDisplay} in ${this.api_keys[0].in}` : `${this.api_keys.length} API keys applied`} 
                  </div>` : ke`<div class="gray-text">Required  <span style="color:var(--red)">(None Applied)</span> </div>`}` : ke`<span class="gray-text"> Not Required </span>`}
        </div>
      </div>
      ${this.parameters.length > 0 || this.request_body ? ke`
            <button class="m-btn thin-border" part="btn btn-outline btn-fill" style="margin-right:5px;" @click="${this.onFillRequestData}" title="Fills with example data (if provided)">
              FILL EXAMPLE
            </button>
            <button class="m-btn thin-border" part="btn btn-outline btn-clear" style="margin-right:5px;" @click="${this.onClearRequestData}">
              CLEAR
            </button>` : ''}
      <button class="m-btn primary thin-border" part="btn btn-try" @click="${this.onTryClick}">TRY</button>
    </div>
    <div class="row" style="font-size:var(--font-size-small); margin:5px 0">
      ${this.showCurlBeforeTry === 'true' ? this.curlSyntaxTemplate() : ''}
    </div>
    ${this.responseMessage === '' ? '' : this.apiResponseTabTemplate()}
    `;
  }
  /* eslint-enable indent */

  async onFillRequestData(e) {
    const requestPanelEl = e.target.closest('.request-panel');
    const requestPanelInputEls = [...requestPanelEl.querySelectorAll('input, tag-input, textarea:not(.is-hidden)')];
    requestPanelInputEls.forEach(el => {
      if (el.dataset.example) {
        if (el.tagName.toUpperCase() === 'TAG-INPUT') {
          el.value = el.dataset.example.split('~|~');
        } else {
          el.value = el.dataset.example;
        }
      }
    });
  }
  async onClearRequestData(e) {
    const requestPanelEl = e.target.closest('.request-panel');
    const requestPanelInputEls = [...requestPanelEl.querySelectorAll('input, tag-input, textarea:not(.is-hidden)')];
    requestPanelInputEls.forEach(el => {
      el.value = '';
    });
  }
  buildFetchURL(requestPanelEl) {
    let fetchUrl;
    const pathParamEls = [...requestPanelEl.querySelectorAll("[data-ptype='path']")];
    const queryParamEls = [...requestPanelEl.querySelectorAll("[data-ptype='query']")];
    const queryParamObjTypeEls = [...requestPanelEl.querySelectorAll("[data-ptype='query-object']")];
    fetchUrl = this.path;
    // Generate URL using Path Params
    pathParamEls.map(el => {
      fetchUrl = fetchUrl.replace(`{${el.dataset.pname}}`, encodeURIComponent(el.value));
    });

    // Query Params
    const urlQueryParamsMap = new Map();
    const queryParamsWithReservedCharsAllowed = [];
    if (queryParamEls.length > 0) {
      queryParamEls.forEach(el => {
        const queryParam = new URLSearchParams();
        if (el.dataset.paramAllowReserved === 'true') {
          queryParamsWithReservedCharsAllowed.push(el.dataset.pname);
        }
        if (el.dataset.array === 'false') {
          if (el.value !== '') {
            queryParam.append(el.dataset.pname, el.value);
          }
        } else {
          const {
            paramSerializeStyle,
            paramSerializeExplode
          } = el.dataset;
          let vals = el.value && Array.isArray(el.value) ? el.value : [];
          vals = Array.isArray(vals) ? vals.filter(v => v !== '') : [];
          if (vals.length > 0) {
            if (paramSerializeStyle === 'spaceDelimited') {
              queryParam.append(el.dataset.pname, vals.join(' ').replace(/^\s|\s$/g, ''));
            } else if (paramSerializeStyle === 'pipeDelimited') {
              queryParam.append(el.dataset.pname, vals.join('|').replace(/^\||\|$/g, ''));
            } else {
              if (paramSerializeExplode === 'true') {
                // eslint-disable-line no-lonely-if
                vals.forEach(v => {
                  queryParam.append(el.dataset.pname, v);
                });
              } else {
                queryParam.append(el.dataset.pname, vals.join(',').replace(/^,|,$/g, ''));
              }
            }
          }
        }
        if (queryParam.toString()) {
          urlQueryParamsMap.set(el.dataset.pname, queryParam);
        }
      });
    }

    // Query Params (Dynamic - create from JSON)
    if (queryParamObjTypeEls.length > 0) {
      queryParamObjTypeEls.map(el => {
        const queryParam = new URLSearchParams();
        try {
          let queryParamObj = {};
          const {
            paramSerializeStyle,
            paramSerializeExplode,
            pname
          } = el.dataset;
          queryParamObj = Object.assign(queryParamObj, JSON.parse(el.value.replace(/\s+/g, ' ')));
          if (el.dataset.paramAllowReserved === 'true') {
            queryParamsWithReservedCharsAllowed.push(el.dataset.pname);
          }
          if ('json xml'.includes(paramSerializeStyle)) {
            if (paramSerializeStyle === 'json') {
              queryParam.append(el.dataset.pname, JSON.stringify(queryParamObj));
            } else if (paramSerializeStyle === 'xml') {
              queryParam.append(el.dataset.pname, json2xml(queryParamObj));
            }
          } else {
            for (const key in queryParamObj) {
              const pKey = `${pname}[${key}]`;
              if (typeof queryParamObj[key] === 'object') {
                if (Array.isArray(queryParamObj[key])) {
                  if (paramSerializeStyle === 'spaceDelimited') {
                    queryParam.append(pKey, queryParamObj[key].join(' '));
                  } else if (paramSerializeStyle === 'pipeDelimited') {
                    queryParam.append(pKey, queryParamObj[key].join('|'));
                  } else {
                    if (paramSerializeExplode === 'true') {
                      // eslint-disable-line no-lonely-if
                      queryParamObj[key].forEach(v => {
                        queryParam.append(pKey, v);
                      });
                    } else {
                      queryParam.append(pKey, queryParamObj[key]);
                    }
                  }
                }
              } else {
                queryParam.append(pKey, queryParamObj[key]);
              }
            }
          }
        } catch {
          console.error('RapiDoc: unable to parse %s into object', el.value); // eslint-disable-line no-console
        }
        if (queryParam.toString()) {
          urlQueryParamsMap.set(el.dataset.pname, queryParam);
        }
      });
    }
    let urlQueryParamString = '';
    if (urlQueryParamsMap.size) {
      urlQueryParamsMap.forEach((val, pname) => {
        if (queryParamsWithReservedCharsAllowed.includes(pname)) {
          urlQueryParamString += `${pname}=`;
          urlQueryParamString += val.getAll(pname).join(`&${pname}=`);
          urlQueryParamString += '&';
        } else {
          urlQueryParamString += `${val.toString()}&`;
        }
      });
      urlQueryParamString = urlQueryParamString.slice(0, -1);
    }
    if (urlQueryParamString.length !== 0) {
      fetchUrl = `${fetchUrl}${fetchUrl.includes('?') ? '&' : '?'}${urlQueryParamString}`;
    }

    // Add authentication Query-Param if provided
    this.api_keys.filter(v => v.in === 'query').forEach(v => {
      fetchUrl = `${fetchUrl}${fetchUrl.includes('?') ? '&' : '?'}${v.name}=${encodeURIComponent(v.finalKeyValue)}`;
    });
    fetchUrl = `${this.serverUrl.replace(/\/$/, '')}${fetchUrl}`;
    return fetchUrl;
  }
  buildFetchHeaders(requestPanelEl) {
    var _this$closest;
    const respEl = (_this$closest = this.closest('.expanded-req-resp-container, .req-resp-container')) === null || _this$closest === void 0 ? void 0 : _this$closest.getElementsByTagName('api-response')[0];
    const headerParamEls = [...requestPanelEl.querySelectorAll("[data-ptype='header'], [data-ptype='header-object']")];
    const requestBodyContainerEl = requestPanelEl.querySelector('.request-body-container');
    const acceptHeader = respEl === null || respEl === void 0 ? void 0 : respEl.selectedMimeType;
    const reqHeaders = new Headers();
    if (acceptHeader) {
      // Uses the acceptHeader from Response panel
      reqHeaders.append('Accept', acceptHeader);
    } else if (this.accept) {
      reqHeaders.append('Accept', this.accept);
    }

    // Add Authentication Header if provided
    this.api_keys.filter(v => v.in === 'header').forEach(v => {
      reqHeaders.append(v.name, v.finalKeyValue);
    });

    // Add Header Params
    headerParamEls.map(el => {
      if (el.value) {
        if (el.dataset.ptype === 'header-object') {
          /* CONVERT
            a header value from below object style
              {
                "key1": "val1",
                "key2": {
                  "key2_1": "val2_1",
                  "key2_2": {
                    "key2_2_1": "val2_2_1"
                  }
                },
                "key3": "val3"
              };
             TO >>>
              key1=val1, key2={"key2_1":"val2_1","key2_2":{"key2_2_1":"val2_2_1"}}, key3=val3
          */
          const headerObjVal = JSON.parse(el.value.replace(/\n/g, '').trim());
          const firstLevelKeySeparator = el.dataset.paramSerializeExplode === 'true' ? '=' : ',';
          const headerStrVal = Object.keys(headerObjVal).map(key => {
            const value = headerObjVal[key];
            if (typeof value === 'object') {
              return `${key}${firstLevelKeySeparator}${JSON.stringify(value)}`;
            }
            return `${key}${firstLevelKeySeparator}${value}`;
          }).join(',');
          reqHeaders.append(el.dataset.pname, headerStrVal);
        } else {
          reqHeaders.append(el.dataset.pname, el.value);
        }
      }
    });
    if (requestBodyContainerEl) {
      const requestBodyType = requestBodyContainerEl.dataset.selectedRequestBodyType;
      // Common for all request-body
      if (!requestBodyType.includes('form-data')) {
        // For multipart/form-data dont set the content-type to allow creation of browser generated part boundaries
        reqHeaders.append('Content-Type', requestBodyType);
      }
    }
    return reqHeaders;
  }
  buildFetchBodyOptions(requestPanelEl) {
    const requestBodyContainerEl = requestPanelEl.querySelector('.request-body-container');
    const fetchOptions = {
      method: this.method.toUpperCase()
    };
    if (requestBodyContainerEl) {
      const requestBodyType = requestBodyContainerEl.dataset.selectedRequestBodyType;
      if (requestBodyType.includes('form-urlencoded')) {
        // url-encoded Form Params (dynamic) - Parse JSON and generate Params
        const formUrlDynamicTextAreaEl = requestPanelEl.querySelector("[data-ptype='dynamic-form']");
        if (formUrlDynamicTextAreaEl) {
          const val = formUrlDynamicTextAreaEl.value;
          const formUrlDynParams = new URLSearchParams();
          let proceed = true;
          let tmpObj;
          if (val) {
            try {
              tmpObj = JSON.parse(val);
            } catch (err) {
              proceed = false;
              console.warn('RapiDoc: Invalid JSON provided', err); // eslint-disable-line no-console
            }
          } else {
            proceed = false;
          }
          if (proceed) {
            for (const prop in tmpObj) {
              formUrlDynParams.append(prop, JSON.stringify(tmpObj[prop]));
            }
            fetchOptions.body = formUrlDynParams;
          }
        } else {
          // url-encoded Form Params (regular)
          const formUrlEls = [...requestPanelEl.querySelectorAll("[data-ptype='form-urlencode']")];
          const formUrlParams = new URLSearchParams();
          formUrlEls.filter(v => v.type !== 'file').forEach(el => {
            if (el.dataset.array === 'false') {
              if (el.value) {
                formUrlParams.append(el.dataset.pname, el.value);
              }
            } else {
              const vals = el.value && Array.isArray(el.value) ? el.value.join(',') : '';
              formUrlParams.append(el.dataset.pname, vals);
            }
          });
          fetchOptions.body = formUrlParams;
        }
      } else if (requestBodyType.includes('form-data')) {
        const formDataParams = new FormData();
        const formDataEls = [...requestPanelEl.querySelectorAll("[data-ptype='form-data']")];
        formDataEls.forEach(el => {
          if (el.dataset.array === 'false') {
            if (el.type === 'file' && el.files[0]) {
              formDataParams.append(el.dataset.pname, el.files[0], el.files[0].name);
            } else if (el.value) {
              formDataParams.append(el.dataset.pname, el.value);
            }
          } else if (el.value && Array.isArray(el.value)) {
            formDataParams.append(el.dataset.pname, el.value.join(','));
          }
        });
        fetchOptions.body = formDataParams;
      } else if (/^audio\/|^image\/|^video\/|^font\/|tar$|zip$|7z$|rtf$|msword$|excel$|\/pdf$|\/octet-stream$/.test(requestBodyType)) {
        const bodyParamFileEl = requestPanelEl.querySelector('.request-body-param-file');
        if (bodyParamFileEl !== null && bodyParamFileEl !== void 0 && bodyParamFileEl.files[0]) {
          fetchOptions.body = bodyParamFileEl.files[0]; // eslint-disable-line prefer-destructuring
        }
      } else if (requestBodyType.includes('json') || requestBodyType.includes('xml') || requestBodyType.includes('text')) {
        const exampleTextAreaEl = requestPanelEl.querySelector('.request-body-param-user-input');
        if (exampleTextAreaEl !== null && exampleTextAreaEl !== void 0 && exampleTextAreaEl.value) {
          fetchOptions.body = exampleTextAreaEl.value;
        }
      }
    }
    return fetchOptions;
  }
  async onTryClick(e) {
    const tryBtnEl = e.target;
    const requestPanelEl = tryBtnEl.closest('.request-panel');
    const fetchUrl = this.buildFetchURL(requestPanelEl);
    const fetchOptions = this.buildFetchBodyOptions(requestPanelEl);
    const reqHeaders = this.buildFetchHeaders(requestPanelEl);
    this.responseUrl = '';
    this.responseHeaders = [];
    this.curlSyntax = this.generateCURLSyntax(fetchUrl, reqHeaders, fetchOptions, requestPanelEl);
    this.responseStatus = 'success';
    this.responseIsBlob = false;
    this.respContentDisposition = '';
    if (this.responseBlobUrl) {
      URL.revokeObjectURL(this.responseBlobUrl);
      this.responseBlobUrl = '';
    }
    if (this.fetchCredentials) {
      fetchOptions.credentials = this.fetchCredentials;
    }
    const controller = new AbortController();
    const {
      signal
    } = controller;
    fetchOptions.headers = reqHeaders;
    const tempRequest = {
      url: fetchUrl,
      ...fetchOptions
    };
    this.dispatchEvent(new CustomEvent('before-try', {
      bubbles: true,
      composed: true,
      detail: {
        request: tempRequest,
        controller
      }
    }));
    const updatedFetchOptions = {
      method: tempRequest.method,
      headers: tempRequest.headers,
      credentials: tempRequest.credentials,
      body: tempRequest.body
    };
    const fetchRequest = new Request(tempRequest.url, updatedFetchOptions);
    let fetchResponse;
    let responseClone;
    try {
      let respBlob;
      let respJson;
      let respText;
      tryBtnEl.disabled = true;
      this.responseText = '⌛';
      this.responseMessage = '';
      this.requestUpdate();
      const startTime = performance.now();
      fetchResponse = await fetch(fetchRequest, {
        signal
      });
      const endTime = performance.now();
      // Allow to modify response
      /*
      let resolveModifiedResponse; // Create a promise that will be resolved from the event listener
      const modifiedResponsePromise = new Promise((resolve) => {
        resolveModifiedResponse = resolve;
      });
      this.dispatchEvent(new CustomEvent('fetched-try', {
        bubbles: true,
        composed: true,
        detail: {
          request: fetchRequest,
          response: fetchResponse,
          resolveModifiedResponse, // pass the resolver function
        },
      }));
      fetchResponse = await modifiedResponsePromise; // Wait for the modified response
      */
      responseClone = fetchResponse.clone(); // create a response clone to allow reading response body again (response.json, response.text etc)
      tryBtnEl.disabled = false;
      this.responseMessage = ke`${fetchResponse.statusText ? `${fetchResponse.statusText}:${fetchResponse.status}` : fetchResponse.status} <div style="color:var(--light-fg)"> Took ${Math.round(endTime - startTime)} milliseconds </div>`;
      this.responseUrl = fetchResponse.url;
      const respHeadersObj = {};
      fetchResponse.headers.forEach((hdrVal, hdr) => {
        respHeadersObj[hdr] = hdrVal;
        this.responseHeaders = `${this.responseHeaders}${hdr}: ${hdrVal}\n`;
      });
      let contentType = fetchResponse.headers.get('content-type');
      const respEmpty = (await fetchResponse.clone().text()).length === 0;
      if (respEmpty) {
        this.responseText = '';
      } else if (contentType) {
        contentType = contentType.split(';')[0].trim();
        if (contentType === 'application/x-ndjson') {
          this.responseText = await fetchResponse.text();
        } else if (contentType.includes('json')) {
          if (/charset=[^"']+/.test(contentType)) {
            const encoding = contentType.split('charset=')[1];
            const buffer = await fetchResponse.arrayBuffer();
            try {
              respText = new TextDecoder(encoding).decode(buffer);
            } catch {
              respText = new TextDecoder('utf-8').decode(buffer);
            }
            try {
              respJson = JSON.parse(respText);
              this.responseText = JSON.stringify(respJson, null, 2);
            } catch {
              this.responseText = respText;
            }
          } else {
            respJson = await fetchResponse.json();
            this.responseText = JSON.stringify(respJson, null, 2);
          }
          // eslint-disable-next-line no-useless-escape
        } else if (/^font\/|tar$|zip$|7z$|rtf$|msword$|excel$|\/pdf$|\/octet-stream$|^application\/vnd\./.test(contentType)) {
          this.responseIsBlob = true;
          this.responseBlobType = 'download';
        } else if (/^image/.test(contentType)) {
          this.responseIsBlob = true;
          this.responseBlobType = 'image';
        } else if (/^audio|^image|^video/.test(contentType)) {
          this.responseIsBlob = true;
          this.responseBlobType = 'view';
        } else {
          respText = await fetchResponse.text();
          if (contentType.includes('xml')) {
            this.responseText = dist_default()(respText, {
              textNodesOnSameLine: true,
              indentor: '  '
            });
          } else {
            this.responseText = respText;
          }
        }
        if (this.responseIsBlob) {
          const contentDisposition = fetchResponse.headers.get('content-disposition') || '';
          let filenameFromContentDeposition = 'filename';
          if (contentDisposition) {
            const filenameStarRegexMatch = contentDisposition.match(/filename\*=\s*UTF-8''([^;]+)/); // Support Headers like >>> Content-Disposition: attachment; filename*=UTF-8''example%20file.pdf
            if (filenameStarRegexMatch) {
              filenameFromContentDeposition = decodeURIComponent(filenameStarRegexMatch[1]); // the filename* format in the Content-Disposition header follows RFC 5987, which allows encoding non-ASCII characters using percent encoding. so example%20file.pdf becomes example file.pdf
            } else {
              // Fallback to the regular filename format
              const filenameMatch = contentDisposition.match(/filename="?([^"]+)"?/); // Content-Disposition: attachment; filename=example.pdf
              if (filenameMatch) {
                filenameFromContentDeposition = filenameMatch[1];
              }
            }
          }
          this.respContentDisposition = filenameFromContentDeposition;
          respBlob = await fetchResponse.blob();
          this.responseBlobUrl = URL.createObjectURL(respBlob);
        }
      } else {
        respText = await fetchResponse.text();
        this.responseText = respText;
      }
      this.dispatchEvent(new CustomEvent('after-try', {
        bubbles: true,
        composed: true,
        detail: {
          request: fetchRequest,
          response: responseClone,
          responseHeaders: respHeadersObj,
          responseBody: respJson || respText || respBlob,
          responseStatus: responseClone.ok
        }
      }));
    } catch (err) {
      tryBtnEl.disabled = false;
      if (err.name === 'AbortError') {
        this.dispatchEvent(new CustomEvent('request-aborted', {
          bubbles: true,
          composed: true,
          detail: {
            err,
            request: fetchRequest
          }
        }));
        this.responseMessage = 'Request Aborted';
        this.responseText = 'Request Aborted';
      } else {
        this.dispatchEvent(new CustomEvent('after-try', {
          bubbles: true,
          composed: true,
          detail: {
            err,
            request: fetchRequest
          }
        }));
        this.responseMessage = `${err.message} (CORS or Network Issue)`;
      }
    }
    this.requestUpdate();
  }
  liveCURLSyntaxUpdate(requestPanelEl) {
    this.applyCURLSyntax(requestPanelEl);
    this.requestUpdate();
  }
  onGenerateCURLClick(e) {
    const requestPanelEl = this.getRequestPanel(e);
    this.applyCURLSyntax(requestPanelEl);
  }
  getRequestPanel(e) {
    return e.target.closest('.request-panel');
  }
  applyCURLSyntax(requestPanelEl) {
    const fetchUrl = this.buildFetchURL(requestPanelEl);
    const fetchOptions = this.buildFetchBodyOptions(requestPanelEl);
    const fetchHeaders = this.buildFetchHeaders(requestPanelEl);
    this.curlSyntax = this.generateCURLSyntax(fetchUrl, fetchHeaders, fetchOptions, requestPanelEl);
  }
  generateCURLSyntax(fetchUrl, fetchHeaders, fetchOptions, requestPanelEl) {
    let curlUrl;
    let curl = '';
    let curlHeaders = '';
    let curlData = '';
    let curlForm = '';
    const requestBodyContainerEl = requestPanelEl.querySelector('.request-body-container');
    if (fetchUrl.startsWith('http') === false) {
      const url = new URL(fetchUrl, window.location.href);
      curlUrl = url.href;
    } else {
      curlUrl = fetchUrl;
    }
    curl = `curl -X ${this.method.toUpperCase()} "${curlUrl}" \\\n`;
    fetchHeaders.forEach((value, key) => {
      let tempHeaderArray = value.split(',');
      tempHeaderArray = tempHeaderArray.map(el => el.trim()).filter((string, index) => tempHeaderArray.indexOf(string) === index);
      fetchHeaders.set(key, tempHeaderArray.join(', '));
    });
    curlHeaders = Array.from(fetchHeaders).map(([key, value]) => ` -H '${key}: ${value}'`).join('\\\n');
    if (curlHeaders) {
      curlHeaders = `${curlHeaders} \\\n`;
    }
    if (fetchOptions.body instanceof URLSearchParams) {
      curlData = ` -d ${fetchOptions.body.toString()} \\\n`;
    } else if (fetchOptions.body instanceof File) {
      curlData = ` --data-binary @${fetchOptions.body.name} \\\n`;
    } else if (fetchOptions.body instanceof FormData) {
      curlForm = Array.from(fetchOptions.body).reduce((aggregator, [key, value]) => {
        if (value instanceof File) {
          return [...aggregator, ` -F "${key}=@${value.name}"`];
        }
        const multiple = value.match(/([^,],)/gm);
        if (multiple) {
          const multipleResults = multiple.map(one => `-F "${key}[]=${one}"`);
          return [...aggregator, ...multipleResults];
        }
        return [...aggregator, ` -F "${key}=${value}"`];
      }, []).join('\\\n');
    } else if (requestBodyContainerEl && requestBodyContainerEl.dataset.selectedRequestBodyType) {
      const requestBodyType = requestBodyContainerEl.dataset.selectedRequestBodyType;
      const exampleTextAreaEl = requestPanelEl.querySelector('.request-body-param-user-input');
      if (exampleTextAreaEl !== null && exampleTextAreaEl !== void 0 && exampleTextAreaEl.value) {
        fetchOptions.body = exampleTextAreaEl.value;
        if (requestBodyType.includes('json')) {
          try {
            curlData = ` -d '${JSON.stringify(JSON.parse(exampleTextAreaEl.value))}' \\\n`;
          } catch {
            // Ignore.
          }
        }
        if (!curlData) {
          curlData = ` -d '${exampleTextAreaEl.value.replace(/'/g, '\'"\'"\'')}' \\\n`;
        }
      }
    }
    return `${curl}${curlHeaders}${curlData}${curlForm}`;
  }
  onAddRemoveFileInput(e, pname, ptype) {
    if (e.target.tagName.toLowerCase() !== 'button') {
      return;
    }
    if (e.target.classList.contains('file-input-remove-btn')) {
      // Remove File Input Set
      const el = e.target.closest('.input-set');
      el.remove();
      return;
    }
    const el = e.target.closest('.file-input-container');

    // Add File Input Set

    // Container
    const newInputContainerEl = document.createElement('div');
    newInputContainerEl.setAttribute('class', 'input-set row');

    // File Input
    const newInputEl = document.createElement('input');
    newInputEl.type = 'file';
    newInputEl.style = 'width:200px; margin-top:2px;';
    newInputEl.setAttribute('data-pname', pname);
    newInputEl.setAttribute('data-ptype', ptype.includes('form-urlencode') ? 'form-urlencode' : 'form-data');
    newInputEl.setAttribute('data-array', 'false');
    newInputEl.setAttribute('data-file-array', 'true');

    // Remover Button
    const newRemoveBtnEl = document.createElement('button');
    newRemoveBtnEl.setAttribute('class', 'file-input-remove-btn');
    newRemoveBtnEl.innerHTML = '&#x2715;';
    newInputContainerEl.appendChild(newInputEl);
    newInputContainerEl.appendChild(newRemoveBtnEl);
    el.insertBefore(newInputContainerEl, e.target);
    // el.appendChild(newInputContainerEl);
  }
  clearResponseData() {
    this.responseUrl = '';
    this.responseHeaders = '';
    this.responseText = '';
    this.responseStatus = 'success';
    this.responseMessage = '';
    this.responseIsBlob = false;
    this.responseBlobType = '';
    this.respContentDisposition = '';
    if (this.responseBlobUrl) {
      URL.revokeObjectURL(this.responseBlobUrl);
      this.responseBlobUrl = '';
    }
  }
  disconnectedCallback() {
    this.curlSyntax = '';
    // Cleanup ObjectURL for the blob data if this component created one
    if (this.responseBlobUrl) {
      URL.revokeObjectURL(this.responseBlobUrl);
      this.responseBlobUrl = '';
    }
    super.disconnectedCallback();
  }
}

// Register the element with the browser
customElements.define('api-request', ApiRequest);
;// ./src/components/schema-table.js

 // eslint-disable-line import/extensions




class SchemaTable extends lit_element_h {
  static get properties() {
    return {
      schemaExpandLevel: {
        type: Number,
        attribute: 'schema-expand-level'
      },
      schemaDescriptionExpanded: {
        type: String,
        attribute: 'schema-description-expanded'
      },
      allowSchemaDescriptionExpandToggle: {
        type: String,
        attribute: 'allow-schema-description-expand-toggle'
      },
      schemaHideReadOnly: {
        type: String,
        attribute: 'schema-hide-read-only'
      },
      schemaHideWriteOnly: {
        type: String,
        attribute: 'schema-hide-write-only'
      },
      data: {
        type: Object
      }
    };
  }
  connectedCallback() {
    super.connectedCallback();
    if (!this.schemaExpandLevel || this.schemaExpandLevel < 1) {
      this.schemaExpandLevel = 99999;
    }
    if (!this.schemaDescriptionExpanded || !'true false'.includes(this.schemaDescriptionExpanded)) {
      this.schemaDescriptionExpanded = 'false';
    }
    if (!this.schemaHideReadOnly || !'true false'.includes(this.schemaHideReadOnly)) {
      this.schemaHideReadOnly = 'true';
    }
    if (!this.schemaHideWriteOnly || !'true false'.includes(this.schemaHideWriteOnly)) {
      this.schemaHideWriteOnly = 'true';
    }
  }
  static get styles() {
    return [font_styles, schema_styles, i`
      .table {
        font-size: var(--font-size-small);
        text-align: left;
        line-height: calc(var(--font-size-small) + 6px);
      }
      .table .tr {
        width: calc(100% - 5px);
        padding: 0 0 0 5px;
        border-bottom: 1px dotted var(--light-border-color);
      }
      .table .td {
        padding: 4px 0;
      }
      .table .key {
        width: 240px;
      }
      .key .key-label {
        font-size: var(--font-size-mono);
      }
      .key.deprecated .key-label {
        color: var(--red);
      }

      .table .key-type {
        white-space: normal;
        width: 150px;
      }
      .collapsed-all-descr .tr:not(.expanded-descr) {
        max-height: calc(var(--font-size-small) + var(--font-size-small));
      }

      .obj-toggle {
        padding: 0 2px;
        border-radius:2px;
        border: 1px solid transparent;
        display: inline-block;
        margin-left: -16px;
        color:var(--primary-color);
        cursor:pointer;
        font-size: calc(var(--font-size-small) + 4px);
        font-family: var(--font-mono);
        background-clip: border-box;
      }
      .obj-toggle:hover {
        border-color: var(--primary-color);
      }
      .tr.expanded + .object-body {
        display:block;
      }
      .tr.collapsed + .object-body {
        display:none;
      }`, custom_styles];
  }

  /* eslint-disable indent */
  render() {
    var _this$data, _this$data2, _this$data3;
    return ke`
      <div class="table ${this.schemaDescriptionExpanded === 'true' ? 'expanded-all-descr' : 'collapsed-all-descr'}" @click="${e => this.handleAllEvents(e)}">
        <div class='toolbar'>
          <div class="toolbar-item schema-root-type ${((_this$data = this.data) === null || _this$data === void 0 ? void 0 : _this$data['::type']) || ''} "> ${((_this$data2 = this.data) === null || _this$data2 === void 0 ? void 0 : _this$data2['::type']) || ''} </div>
          ${this.allowSchemaDescriptionExpandToggle === 'true' ? ke`
              <div style="flex:1"></div>
              <div part="schema-multiline-toggle" class='toolbar-item schema-multiline-toggle' > 
                ${this.schemaDescriptionExpanded === 'true' ? 'Single line description' : 'Multiline description'}
              </div>
            ` : ''}
        </div>
        <span part="schema-description" class='m-markdown'> ${unsafe_html_ae(marked(((_this$data3 = this.data) === null || _this$data3 === void 0 ? void 0 : _this$data3['::description']) || ''))} </span>
        <div style = 'border:1px solid var(--light-border-color)'>
          <div style='display:flex; background-color: var(--bg2); padding:8px 4px; border-bottom:1px solid var(--light-border-color);'>
            <div class='key' style='font-family:var(--font-regular); font-weight:bold; color:var(--fg);'> Field </div>
            <div class='key-type' style='font-family:var(--font-regular); font-weight:bold; color:var(--fg);'> Type </div>
            <div class='key-descr' style='font-family:var(--font-regular); font-weight:bold; color:var(--fg);'> Description </div>
          </div>
          ${this.data ? ke`
              ${this.generateTree(this.data['::type'] === 'array' ? this.data['::props'] : this.data, this.data['::type'], this.data['::array-type'])}` : ''}  
        </div>
      </div>  
    `;
  }
  generateTree(data, dataType = 'object', arrayType = '', key = '', description = '', schemaLevel = 0, indentLevel = 0, readOrWrite = '', isDeprecated = false) {
    var _data$Type, _keyLabel;
    if (this.schemaHideReadOnly === 'true') {
      if (dataType === 'array') {
        if (readOrWrite === 'readonly') {
          return;
        }
      }
      if (data && data['::readwrite'] === 'readonly') {
        return;
      }
    }
    if (this.schemaHideWriteOnly === 'true') {
      if (dataType === 'array') {
        if (readOrWrite === 'writeonly') {
          return;
        }
      }
      if (data && data['::readwrite'] === 'writeonly') {
        return;
      }
    }
    if (!data) {
      return ke`<div class="null" style="display:inline;">
        <span style='margin-left:${(schemaLevel + 1) * 16}px'> &nbsp; </span>
        <span class="key-label xxx-of-key"> ${key.replace('::OPTION~', '')}</span>
        ${dataType === 'array' ? ke`<span class='mono-font'> [ ] </span>` : dataType === 'object' ? ke`<span class='mono-font'> { } </span>` : ke`<span class='mono-font'> schema undefined </span>`}
      </div>`;
    }
    const newSchemaLevel = (_data$Type = data['::type']) !== null && _data$Type !== void 0 && _data$Type.startsWith('xxx-of') ? schemaLevel : schemaLevel + 1;
    const newIndentLevel = dataType === 'xxx-of-option' || data['::type'] === 'xxx-of-option' || key.startsWith('::OPTION') ? indentLevel : indentLevel + 1;
    const leftPadding = 16 * newIndentLevel; // 2 space indentation at each level
    if (Object.keys(data).length === 0) {
      return ke`<span class="td key object" style='padding-left:${leftPadding}px'>${key}</span>`;
    }
    let keyLabel = '';
    let keyDescr = '';
    let isOneOfLabel = false;
    if (key.startsWith('::ONE~OF') || key.startsWith('::ANY~OF')) {
      keyLabel = key.replace('::', '').replace('~', ' ');
      isOneOfLabel = true;
    } else if (key.startsWith('::OPTION')) {
      const parts = key.split('~');
      keyLabel = parts[1]; // eslint-disable-line prefer-destructuring
      keyDescr = parts[2]; // eslint-disable-line prefer-destructuring
    } else {
      keyLabel = key;
    }
    let detailObjType = '';
    if (data['::type'] === 'object') {
      if (dataType === 'array') {
        detailObjType = 'array of object'; // Array of Object
      } else {
        detailObjType = data['::dataTypeLabel'] || data['::type'];
      }
    } else if (data['::type'] === 'array') {
      if (dataType === 'array') {
        // detailObjType = 'array of array'; // Array of array
        detailObjType = `array of array ${arrayType !== 'object' ? `of ${arrayType}` : ''}`; // Array of array
      } else {
        detailObjType = data['::dataTypeLabel'] || data['::type'];
      }
    }
    if (typeof data === 'object') {
      return ke`
        ${newSchemaLevel >= 0 && key ? ke`
            <div class='tr ${newSchemaLevel <= this.schemaExpandLevel ? 'expanded' : 'collapsed'} ${data['::type']}' data-obj='${keyLabel}' title="${isDeprecated || data['::deprecated'] ? 'Deprecated' : ''}">
              <div class="td key ${isDeprecated || data['::deprecated'] ? 'deprecated' : ''}" style='padding-left:${leftPadding}px'>
                ${keyLabel || keyDescr ? ke`
                    <span class='obj-toggle ${newSchemaLevel < this.schemaExpandLevel ? 'expanded' : 'collapsed'}' data-obj='${keyLabel}'>
                      ${schemaLevel < this.schemaExpandLevel ? '-' : '+'}
                    </span>` : ''}
                ${data['::type'] === 'xxx-of-option' || data['::type'] === 'xxx-of-array' || key.startsWith('::OPTION') ? ke`<span class="xxx-of-key" style="margin-left:-6px">${keyLabel}</span><span class="${isOneOfLabel ? 'xxx-of-key' : 'xxx-of-descr'}">${keyDescr}</span>` : keyLabel.endsWith('*') ? ke`<span class="key-label" style="display:inline-block; margin-left:-6px;">${isDeprecated || data['::deprecated'] ? ke`<svg viewBox="0 0 10 10" width="10" height="10" style="stroke:var(--red); margin-right:-6px"><path d="M2 2L8 8M2 8L8 2"/></svg>` : ''} ${keyLabel.substring(0, keyLabel.length - 1)}</span><span style='color:var(--red);'>*</span>` : ke`<span class="key-label" style="display:inline-block; margin-left:-6px;">${isDeprecated || data['::deprecated'] ? ke`<svg viewBox="0 0 10 10" width="10" height="10" style="stroke:var(--red); margin-right:-6px"><path d="M2 2L8 8M2 8L8 2"/></svg>` : ''} ${keyLabel === '::props' ? '' : keyLabel}</span>`}
                ${data['::type'] === 'xxx-of' && dataType === 'array' ? ke`<span style="color:var(--primary-color)">ARRAY</span>` : ''} 
              </div>
              <div class='td key-type' title="${data['::readwrite'] === 'readonly' ? 'Read-Only' : data['::readwrite'] === 'writeonly' ? 'Write-Only' : ''}">
                ${(data['::type'] || '').includes('xxx-of') ? '' : detailObjType}
                ${data['::readwrite'] === 'readonly' ? ' 🆁' : data['::readwrite'] === 'writeonly' ? ' 🆆' : ''}
              </div>
              <div class='td key-descr m-markdown-small' style='line-height:1.7'>${unsafe_html_ae(marked(description || ''))}</div>
            </div>` : ke`
            ${data['::type'] === 'array' && dataType === 'array' ? ke`
                <div class='tr'> 
                  <div class='td key'></div> 
                  <div class='td key-type'>
                    ${arrayType && arrayType !== 'object' ? `${dataType} of ${arrayType}` : dataType}
                  </div> 
                  <div class='td key-descr'></div> 
                </div>` : ''}`}
        <div class='object-body'>
        ${Array.isArray(data) && data[0] ? ke`${this.generateTree(data[0], 'xxx-of-option', '', '::ARRAY~OF', '', newSchemaLevel, newIndentLevel, '')}` : ke`
            ${Object.keys(data).map(dataKey => {
        var _data$dataKey;
        return ke`
              ${['::title', '::description', '::type', '::props', '::deprecated', '::array-type', '::readwrite', '::dataTypeLabel', '::nullable'].includes(dataKey) ? data[dataKey]['::type'] === 'array' || data[dataKey]['::type'] === 'object' ? ke`${this.generateTree(data[dataKey]['::type'] === 'array' ? data[dataKey]['::props'] : data[dataKey], data[dataKey]['::type'], data[dataKey]['::array-type'] || '', dataKey, data[dataKey]['::description'], newSchemaLevel, newIndentLevel, data[dataKey]['::readwrite'] ? data[dataKey]['::readwrite'] : '', isDeprecated || data[dataKey]['::deprecated'])}` : '' : ke`${this.generateTree(data[dataKey]['::type'] === 'array' ? data[dataKey]['::props'] : data[dataKey], data[dataKey]['::type'], data[dataKey]['::array-type'] || '', dataKey, ((_data$dataKey = data[dataKey]) === null || _data$dataKey === void 0 ? void 0 : _data$dataKey['::description']) || '', newSchemaLevel, newIndentLevel, data[dataKey]['::readwrite'] ? data[dataKey]['::readwrite'] : '', isDeprecated || data[dataKey]['::deprecated'])}`}
            `;
      })}
          `}
        </div>
      `;
    }

    // For Primitive Data types
    // eslint-disable-next-line no-unused-vars
    const [type, readOrWriteOnly, constraint, defaultValue, allowedValues, pattern, schemaDescription, schemaTitle, deprecated] = data.split('~|~');
    if (readOrWriteOnly === '🆁' && this.schemaHideReadOnly === 'true') {
      return;
    }
    if (readOrWriteOnly === '🆆' && this.schemaHideWriteOnly === 'true') {
      return;
    }
    const dataTypeCss = type.replace(/┃.*/g, '').replace(/[^a-zA-Z0-9+]/g, '').substring(0, 4).toLowerCase();
    const descrExpander = `${constraint || defaultValue || allowedValues || pattern ? '<span class="descr-expand-toggle">➔</span>' : ''}`;
    let dataTypeHtml = '';
    if (dataType === 'array') {
      dataTypeHtml = ke` 
        <div class='td key-type ${dataTypeCss}' title="${readOrWrite === 'readonly' ? 'Read-Only' : readOrWriteOnly === 'writeonly' ? 'Write-Only' : ''}">
          [${type}] ${readOrWrite === 'readonly' ? '🆁' : readOrWrite === 'writeonly' ? '🆆' : ''}
        </div>`;
    } else {
      dataTypeHtml = ke` 
        <div class='td key-type ${dataTypeCss}' title="${readOrWriteOnly === '🆁' ? 'Read-Only' : readOrWriteOnly === '🆆' ? 'Write-Only' : ''}">
          ${type} ${readOrWriteOnly}
        </div>`;
    }
    return ke`
      <div class = "tr primitive" title="${isDeprecated || deprecated ? 'Deprecated' : ''}">
        <div class="td key ${isDeprecated || deprecated ? 'deprecated' : ''}" style='padding-left:${leftPadding}px'>
          ${isDeprecated || deprecated ? ke`<svg viewBox="0 0 10 10" width="10" height="10" style="stroke:var(--red); margin-right:-6px"><path d="M2 2L8 8M2 8L8 2"/></svg>` : ''}
          ${(_keyLabel = keyLabel) !== null && _keyLabel !== void 0 && _keyLabel.endsWith('*') ? ke`
              <span class="key-label">${keyLabel.substring(0, keyLabel.length - 1)}</span>
              <span style='color:var(--red);'>*</span>` : key.startsWith('::OPTION') ? ke`<span class='xxx-of-key'>${keyLabel}</span><span class="xxx-of-descr">${keyDescr}</span>` : ke`${keyLabel ? ke`<span class="key-label"> ${keyLabel}</span>` : ke`<span class="xxx-of-descr">${schemaTitle}</span>`}`}
        </div>
        ${dataTypeHtml}
        <div class='td key-descr' style='font-size: var(--font-size-small)'>
          ${ke`<span class="m-markdown-small">
            ${unsafe_html_ae(marked(dataType === 'array' ? `${descrExpander} ${description}` : schemaTitle ? `${descrExpander} <b>${schemaTitle}:</b> ${schemaDescription}` : `${descrExpander} ${schemaDescription}`))}
          </span>`}
          ${constraint ? ke`<div class='' style='display:inline-block; line-break:anywhere; margin-right:8px;'> <span class='bold-text'>Constraints: </span> ${constraint}</div>` : ''}
          ${defaultValue ? ke`<div style='display:inline-block; line-break:anywhere; margin-right:8px;'> <span class='bold-text'>Default: </span>${defaultValue}</div>` : ''}
          ${allowedValues ? ke`<div style='display:inline-block; line-break:anywhere; margin-right:8px;'> <span class='bold-text'>${type === 'const' ? 'Value' : 'Allowed'}: </span>${allowedValues}</div>` : ''}
          ${pattern ? ke`<div style='display:inline-block; line-break:anywhere; margin-right:8px;'> <span class='bold-text'>Pattern: </span>${pattern}</div>` : ''}
        </div>
      </div>
    `;
  }
  /* eslint-enable indent */

  handleAllEvents(e) {
    if (e.target.classList.contains('obj-toggle')) {
      this.toggleObjectExpand(e);
    } else if (e.target.classList.contains('schema-multiline-toggle')) {
      this.schemaDescriptionExpanded = this.schemaDescriptionExpanded === 'true' ? 'false' : 'true';
    } else if (e.target.classList.contains('descr-expand-toggle')) {
      const trEl = e.target.closest('.tr');
      if (trEl) {
        trEl.classList.toggle('expanded-descr');
        trEl.style.maxHeight = trEl.scrollHeight;
      }
    }
  }
  toggleObjectExpand(e) {
    const rowEl = e.target.closest('.tr');
    if (rowEl.classList.contains('expanded')) {
      rowEl.classList.add('collapsed');
      rowEl.classList.remove('expanded');
      e.target.innerText = '+';
    } else {
      rowEl.classList.remove('collapsed');
      rowEl.classList.add('expanded');
      e.target.innerText = '-';
    }
  }
}
customElements.define('schema-table', SchemaTable);
;// ./src/components/api-response.js

 // eslint-disable-line import/extensions












class ApiResponse extends lit_element_h {
  constructor() {
    super();
    this.selectedStatus = '';
    this.headersForEachRespStatus = {};
    this.mimeResponsesForEachStatus = {};
    this.activeSchemaTab = 'schema';
  }
  static get properties() {
    return {
      callback: {
        type: String
      },
      webhook: {
        type: String
      },
      responses: {
        type: Object
      },
      parser: {
        type: Object
      },
      schemaStyle: {
        type: String,
        attribute: 'schema-style'
      },
      renderStyle: {
        type: String,
        attribute: 'render-style'
      },
      selectedStatus: {
        type: String,
        attribute: 'selected-status'
      },
      selectedMimeType: {
        type: String,
        attribute: 'selected-mime-type'
      },
      activeSchemaTab: {
        type: String,
        attribute: 'active-schema-tab'
      },
      schemaExpandLevel: {
        type: Number,
        attribute: 'schema-expand-level'
      },
      schemaDescriptionExpanded: {
        type: String,
        attribute: 'schema-description-expanded'
      },
      allowSchemaDescriptionExpandToggle: {
        type: String,
        attribute: 'allow-schema-description-expand-toggle'
      },
      schemaHideReadOnly: {
        type: String,
        attribute: 'schema-hide-read-only'
      },
      schemaHideWriteOnly: {
        type: String,
        attribute: 'schema-hide-write-only'
      }
    };
  }
  static get styles() {
    return [font_styles, flex_styles, tab_styles, table_styles, input_styles, border_styles, i`
      :where(button, input[type="checkbox"], [tabindex="0"]):focus-visible { box-shadow: var(--focus-shadow); }
      :where(input[type="text"], input[type="password"], select, textarea):focus-visible { border-color: var(--primary-color); }
      .resp-head{
        vertical-align: middle;
        padding:16px 0 8px;
      }
      .resp-head.divider{
        border-top: 1px solid var(--border-color);
        margin-top:10px;
      }
      .resp-status{ 
        font-weight:bold;
        font-size:calc(var(--font-size-small) + 1px);
      }
      .resp-descr{
        font-size:calc(var(--font-size-small) + 1px);
        color:var(--light-fg);
        text-align:left;
      }
      .top-gap{margin-top:16px;}
      .example-panel{
        font-size:var(--font-size-small);
        margin:0;
      }
      .focused-mode,
      .read-mode {
        padding-top:24px;
        margin-top:12px;
        border-top: 1px dashed var(--border-color);
      }`, custom_styles];
  }
  render() {
    return ke`
    <div class="col regular-font response-panel ${this.renderStyle}-mode">
      <div class=" ${this.callback === 'true' ? 'tiny-title' : 'req-res-title'} "> 
        ${this.callback === 'true' ? 'CALLBACK RESPONSE' : 'RESPONSE'}
      </div>
      <div>
        ${this.responseTemplate()}
      </div>  
    </div>  
    `;
  }
  resetSelection() {
    this.selectedStatus = '';
    this.selectedMimeType = '';
  }

  /* eslint-disable indent */
  responseTemplate() {
    if (!this.responses) {
      return '';
    }
    for (const statusCode in this.responses) {
      if (!this.selectedStatus) {
        this.selectedStatus = statusCode;
      }
      const allMimeResp = {};
      for (const mimeResp in (_this$responses$statu = this.responses[statusCode]) === null || _this$responses$statu === void 0 ? void 0 : _this$responses$statu.content) {
        var _this$responses$statu, _respExamples$;
        const mimeRespObj = this.responses[statusCode].content[mimeResp];
        if (!this.selectedMimeType) {
          this.selectedMimeType = mimeResp;
        }
        // Generate Schema
        const schemaTree = schemaInObjectNotation(mimeRespObj.schema, {});
        // Generate Example
        const respExamples = generateExample(mimeRespObj.schema, mimeResp, standardizeExample(mimeRespObj.examples), standardizeExample(mimeRespObj.example), this.callback === 'true' || this.webhook === 'true' ? false : true,
        // eslint-disable-line no-unneeded-ternary
        this.callback === 'true' || this.webhook === 'true' ? true : false,
        // eslint-disable-line no-unneeded-ternary
        mimeResp.includes('json') ? 'json' : 'text');
        allMimeResp[mimeResp] = {
          description: this.responses[statusCode].description,
          examples: respExamples,
          selectedExample: ((_respExamples$ = respExamples[0]) === null || _respExamples$ === void 0 ? void 0 : _respExamples$.exampleId) || '',
          schemaTree
        };
      }
      // Headers for each response status
      const tempHeaders = [];
      for (const key in (_this$responses$statu2 = this.responses[statusCode]) === null || _this$responses$statu2 === void 0 ? void 0 : _this$responses$statu2.headers) {
        var _this$responses$statu2;
        tempHeaders.push({
          name: key,
          ...this.responses[statusCode].headers[key]
        });
      }
      this.headersForEachRespStatus[statusCode] = tempHeaders;
      this.mimeResponsesForEachStatus[statusCode] = allMimeResp;
    }
    return ke`
      ${Object.keys(this.responses).length > 1 ? ke`<div class='row' style='flex-wrap:wrap'>
          ${Object.keys(this.responses).map(respStatus => ke`
            ${respStatus === '$$ref' // Swagger-Client parser creates '$$ref' object if JSON references are used to create responses - this should be ignored
    ? '' : ke`
                <button 
                  @click="${() => {
      this.selectedStatus = respStatus;
      if (this.responses[respStatus].content && Object.keys(this.responses[respStatus].content)[0]) {
        this.selectedMimeType = Object.keys(this.responses[respStatus].content)[0]; // eslint-disable-line prefer-destructuring
      } else {
        this.selectedMimeType = undefined;
      }
    }}"
                  class='m-btn small ${this.selectedStatus === respStatus ? 'primary' : ''}'
                  part="btn ${this.selectedStatus === respStatus ? 'btn-response-status btn-selected-response-status' : ' btn-response-status'}"
                  style='margin: 8px 4px 0 0'
                > 
                  ${respStatus} 
                </button>`}`)}</div>` : ke`<span>${Object.keys(this.responses)[0]}</span>`}

      ${Object.keys(this.responses).map(status => {
      var _this$responses$statu3, _this$headersForEachR;
      return ke`
        <div style = 'display: ${status === this.selectedStatus ? 'block' : 'none'}' >
          <div class="top-gap">
            <span class="resp-descr m-markdown ">${unsafe_html_ae(marked(((_this$responses$statu3 = this.responses[status]) === null || _this$responses$statu3 === void 0 ? void 0 : _this$responses$statu3.description) || ''))}</span>
            ${this.headersForEachRespStatus[status] && ((_this$headersForEachR = this.headersForEachRespStatus[status]) === null || _this$headersForEachR === void 0 ? void 0 : _this$headersForEachR.length) > 0 ? ke`${this.responseHeaderListTemplate(this.headersForEachRespStatus[status])}` : ''}
          </div>
          ${Object.keys(this.mimeResponsesForEachStatus[status]).length === 0 ? '' : ke`  
              <div part="tab-panel" class="tab-panel col">
                <div part="tab-btn-row" class="tab-buttons row" @click="${e => {
        if (e.target.tagName.toLowerCase() === 'button') {
          this.activeSchemaTab = e.target.dataset.tab;
        }
      }}" >
                  <button part="tab-btn" class="tab-btn ${this.activeSchemaTab === 'example' ? 'active' : ''}" data-tab = 'example'>EXAMPLE </button>
                  <button part="tab-btn" class="tab-btn ${this.activeSchemaTab !== 'example' ? 'active' : ''}" data-tab = 'schema' >SCHEMA</button>
                  <div style="flex:1"></div>
                  ${Object.keys(this.mimeResponsesForEachStatus[status]).length === 1 ? ke`<span class='small-font-size gray-text' style='align-self:center; margin-top:8px;'> ${Object.keys(this.mimeResponsesForEachStatus[status])[0]} </span>` : ke`${this.mimeTypeDropdownTemplate(Object.keys(this.mimeResponsesForEachStatus[status]))}`}
                </div>
                ${this.activeSchemaTab === 'example' ? ke`<div part="tab-content" class ='tab-content col' style = 'flex:1;'>
                      ${this.mimeExampleTemplate(this.mimeResponsesForEachStatus[status][this.selectedMimeType])}
                    </div>` : ke`<div part="tab-content" class ='tab-content col' style = 'flex:1;'>
                      ${this.mimeSchemaTemplate(this.mimeResponsesForEachStatus[status][this.selectedMimeType])}
                    </div>`}
              </div>
            `}</div>`;
    })}
    `;
  }
  responseHeaderListTemplate(respHeaders) {
    return ke`
      <div style="padding:16px 0 8px 0" class="resp-headers small-font-size bold-text">RESPONSE HEADERS</div> 
      <table role="presentation" style="border-collapse: collapse; margin-bottom:16px; border:1px solid var(--border-color); border-radius: var(--border-radius)" class="small-font-size mono-font">
        ${respHeaders.map(v => {
      var _v$schema, _v$schema2;
      return ke`
          <tr>
            <td style="padding:8px; vertical-align: baseline; min-width:120px; border-top: 1px solid var(--light-border-color); text-overflow: ellipsis;">
              ${v.name || ''}
            </td> 
            <td style="padding:4px; vertical-align: baseline; padding:0 5px; border-top: 1px solid var(--light-border-color); text-overflow: ellipsis;">
              ${((_v$schema = v.schema) === null || _v$schema === void 0 ? void 0 : _v$schema.type) || ''}
            </td> 
            <td style="padding:8px; vertical-align: baseline; border-top: 1px solid var(--light-border-color);text-overflow: ellipsis;">
              <div class="m-markdown-small regular-font" >${unsafe_html_ae(marked(v.description || ''))}</div>
            </td>
            <td style="padding:8px; vertical-align: baseline; border-top: 1px solid var(--light-border-color); text-overflow: ellipsis;">
              ${((_v$schema2 = v.schema) === null || _v$schema2 === void 0 ? void 0 : _v$schema2.example) || ''}
            </td>
          </tr>
        `;
    })}
    </table>`;
  }
  mimeTypeDropdownTemplate(mimeTypes) {
    return ke`
      <select aria-label='mime types' @change="${e => {
      this.selectedMimeType = e.target.value;
    }}" style='margin-bottom: -1px; z-index:1'>
        ${mimeTypes.map(mimeType => ke`<option value='${mimeType}' ?selected = '${mimeType === this.selectedMimeType}'> ${mimeType} </option>`)}
      </select>`;
  }
  onSelectExample(e) {
    const exampleContainerEl = e.target.closest('.example-panel');
    const exampleEls = [...exampleContainerEl.querySelectorAll('.example')];
    exampleEls.forEach(v => {
      v.style.display = v.dataset.example === e.target.value ? 'block' : 'none';
    });
  }
  mimeExampleTemplate(mimeRespDetails) {
    if (!mimeRespDetails) {
      return ke`
        <pre style='color:var(--red)' class = '${this.renderStyle === 'read' ? 'read example-panel border pad-8-16' : 'example-panel border-top'}'> No example provided </pre>
      `;
    }
    return ke`
      ${mimeRespDetails.examples.length === 1 ? ke`
          ${mimeRespDetails.examples[0].exampleFormat === 'json' ? ke`
              ${mimeRespDetails.examples[0].exampleSummary && mimeRespDetails.examples[0].exampleSummary.length > 80 ? ke`<div style="padding: 4px 0"> ${mimeRespDetails.examples[0].exampleSummary} </div>` : ''}
              ${mimeRespDetails.examples[0].exampleDescription ? ke`<div class="m-markdown-small" style="padding: 4px 0"> ${unsafe_html_ae(marked(mimeRespDetails.examples[0].exampleDescription || ''))} </div>` : ''}
              <json-tree 
                render-style = '${this.renderStyle}'
                .data="${mimeRespDetails.examples[0].exampleValue}"
                class = 'example-panel ${this.renderStyle === 'read' ? 'border pad-8-16' : 'border-top pad-top-8'}'
                exportparts = "btn:btn, btn-fill:btn-fill, btn-copy:btn-copy" 
              ></json-tree>` : ke`
              ${mimeRespDetails.examples[0].exampleSummary && mimeRespDetails.examples[0].exampleSummary.length > 80 ? ke`<div style="padding: 4px 0"> ${mimeRespDetails.examples[0].exampleSummary} </div>` : ''}
              ${mimeRespDetails.examples[0].exampleDescription ? ke`<div class="m-markdown-small" style="padding: 4px 0"> ${unsafe_html_ae(marked(mimeRespDetails.examples[0].exampleDescription || ''))} </div>` : ''}
              <pre class = 'example-panel ${this.renderStyle === 'read' ? 'border pad-8-16' : 'border-top pad-top-8'}'>${mimeRespDetails.examples[0].exampleValue}</pre>
            `}` : ke`
          <span class = 'example-panel ${this.renderStyle === 'read' ? 'border pad-8-16' : 'border-top pad-top-8'}'>
            <select aria-label='response examples' style="min-width:100px; max-width:100%" @change='${e => this.onSelectExample(e)}'>
              ${mimeRespDetails.examples.map(v => ke`<option value="${v.exampleId}" ?selected=${v.exampleId === mimeRespDetails.selectedExample} > 
                ${v.exampleSummary.length > 80 ? v.exampleId : v.exampleSummary} 
              </option>`)}
            </select>
            ${mimeRespDetails.examples.map(v => ke`
              <div class="example" data-example = '${v.exampleId}' style = "display: ${v.exampleId === mimeRespDetails.selectedExample ? 'block' : 'none'}">
                ${v.exampleSummary && v.exampleSummary.length > 80 ? ke`<div style="padding: 4px 0"> ${v.exampleSummary} </div>` : ''}
                ${v.exampleDescription ? ke`<div class="m-markdown-small"  style="padding: 4px 0"> ${unsafe_html_ae(marked(v.exampleDescription || ''))} </div>` : ''}
                ${v.exampleFormat === 'json' ? ke`
                    <json-tree 
                      render-style = '${this.renderStyle}'
                      .data = '${v.exampleValue}'
                      exportparts = "btn:btn, btn-fill:btn-fill, btn-copy:btn-copy" 
                    ></json-tree>` : ke`<pre>${v.exampleValue}</pre>`}
              </div>  
            `)}
          </span>  
        `}
    `;
  }
  mimeSchemaTemplate(mimeRespDetails) {
    if (!mimeRespDetails) {
      return ke`
        <pre style='color:var(--red)' class = '${this.renderStyle === 'read' ? 'border pad-8-16' : 'border-top'}'> Schema not found</pre>
      `;
    }
    return ke`
      ${this.schemaStyle === 'table' ? ke`
          <schema-table
            .data = "${mimeRespDetails.schemaTree}"
            schema-expand-level = "${this.schemaExpandLevel}"
            schema-description-expanded = "${this.schemaDescriptionExpanded}"
            allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
            schema-hide-read-only = "${this.schemaHideReadOnly}"
            schema-hide-write-only = "${this.schemaHideWriteOnly}"
            exportparts = "schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
          > </schema-table> ` : ke`
          <schema-tree
            .data = '${mimeRespDetails.schemaTree}'
            schema-expand-level = "${this.schemaExpandLevel}"
            schema-description-expanded = "${this.schemaDescriptionExpanded}"
            allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
            schema-hide-read-only = "${this.schemaHideReadOnly}"
            schema-hide-write-only = "${this.schemaHideWriteOnly}"
            exportparts = "schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
          > </schema-tree>`}`;
  }
  /* eslint-enable indent */
}

// Register the element with the browser
customElements.define('api-response', ApiResponse);
;// ./src/templates/expanded-endpoint-template.js

 // eslint-disable-line import/extensions








/* eslint-disable indent */
function headingRenderer(tagElementId) {
  const renderer = new marked.Renderer();
  renderer.heading = (text, level, raw, slugger) => `<h${level} class="observe-me" id="${tagElementId}--${slugger.slug(raw)}">${text}</h${level}>`;
  return renderer;
}
function expandCollapseTagDescription(e) {
  const tagDescriptionEl = e.target.closest('.tag-container').querySelector('.tag-description');
  const tagIconEl = e.target.closest('.tag-container').querySelector('.tag-icon');
  if (tagDescriptionEl && tagIconEl) {
    const isExpanded = tagDescriptionEl.classList.contains('expanded');
    if (isExpanded) {
      tagDescriptionEl.style.maxHeight = 0;
      tagDescriptionEl.classList.replace('expanded', 'collapsed');
      tagIconEl.classList.replace('expanded', 'collapsed');
    } else {
      tagDescriptionEl.style.maxHeight = `${tagDescriptionEl.scrollHeight}px`;
      tagDescriptionEl.classList.replace('collapsed', 'expanded');
      tagIconEl.classList.replace('collapsed', 'expanded');
    }
  }
}
function expandedEndpointBodyTemplate(path, tagName = '', tagDescription = '') {
  var _path$xBadges, _path$externalDocs, _path$externalDocs2, _path$externalDocs3, _path$externalDocs4, _path$externalDocs5, _path$externalDocs6, _path$servers, _this$selectedServer;
  const acceptContentTypes = new Set();
  for (const respStatus in path.responses) {
    for (const acceptContentType in (_path$responses$respS = path.responses[respStatus]) === null || _path$responses$respS === void 0 ? void 0 : _path$responses$respS.content) {
      var _path$responses$respS;
      acceptContentTypes.add(acceptContentType.trim());
    }
  }
  const accept = [...acceptContentTypes].join(', ');

  // Filter API Keys that are non-empty and are applicable to the the path
  const nonEmptyApiKeys = this.resolvedSpec.securitySchemes.filter(v => {
    var _path$security;
    return v.finalKeyValue && ((_path$security = path.security) === null || _path$security === void 0 ? void 0 : _path$security.some(ps => v.securitySchemeId in ps));
  }) || [];

  // If a RapiDoc API Key is specified on the element and its value is not hyphen(-) then include it for all paths
  const rapiDocApiKey = this.resolvedSpec.securitySchemes.find(v => v.securitySchemeId === rapidocApiKey && v.value !== '-');
  if (rapiDocApiKey) {
    nonEmptyApiKeys.push(rapiDocApiKey);
  }
  const codeSampleTabPanel = path.xCodeSamples ? codeSamplesTemplate.call(this, path.xCodeSamples) : '';
  return ke`
    ${this.renderStyle === 'read' ? ke`<div class='divider' part="operation-divider"></div>` : ''}
    <div class='expanded-endpoint-body observe-me ${path.method} ${path.deprecated ? 'deprecated' : ''} ' part="section-operation ${path.elementId}" id='${path.elementId}'>
      ${this.renderStyle === 'focused' && tagName !== 'General ⦂' ? ke`
          <div class="tag-container" part="section-operation-tag"> 
            <span class="upper" style="font-weight:bold; font-size:18px;"> ${tagName} </span>
            ${tagDescription ? ke`
                <svg class="tag-icon collapsed" width="24" height="24" viewBox="0 0 24 24" stroke-width="2" fill="none" style="stroke:var(--primary-color); vertical-align:top; cursor:pointer"
                @click="${e => {
    expandCollapseTagDescription.call(this, e);
  }}"
                >
                  <path d="M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8"></path><path d="M18 4v17"></path><path d="M15 18l3 3l3 -3"></path>
                </svg>
                <div class="tag-description collapsed" style="max-height:0px; overflow:hidden; margin-top:16px; border:1px solid var(--border-color)"> 
                  <div class="m-markdown" style="padding:8px"> ${unsafe_html_ae(marked(tagDescription))}</div>  
                </div>` : ''}  
          </div>
        ` : ''}
      ${path.deprecated ? ke`<div class="bold-text red-text"> DEPRECATED </div>` : ''}
      ${ke`
        ${path.xBadges && ((_path$xBadges = path.xBadges) === null || _path$xBadges === void 0 ? void 0 : _path$xBadges.length) > 0 ? ke`
            <div style="display:flex; flex-wrap:wrap; margin-bottom: -24px; font-size: var(--font-size-small);">
              ${path.xBadges.map(v => v.color === 'none' ? '' : ke`<span style="margin:1px; margin-right:5px; padding:1px 8px; font-weight:bold; border-radius:12px;  background-color: var(--light-${v.color}, var(--input-bg)); color:var(--${v.color}); border:1px solid var(--${v.color})">${v.label}</span>`)}
            </div>
            ` : ''}
        <h2 part="section-operation-summary"> ${path.shortSummary || `${path.method.toUpperCase()} ${path.path}`}</h2>
        ${path.isWebhook ? ke`<span part="section-operation-webhook" style="color:var(--primary-color); font-weight:bold; font-size: var(--font-size-regular);"> WEBHOOK </span>` : ke`
            <div part="section-operation-webhook-method" class="mono-font regular-font-size" style="text-align:left; direction:ltr; padding: 8px 0; color:var(--fg3)"> 
              <span part="label-operation-method" class="regular-font upper method-fg bold-text ${path.method}">${path.method}</span> 
              <span part="label-operation-path">${path.path}</span>
            </div>
          `}
        <slot name="${path.elementId}"></slot>`}
      ${path.description ? ke`<div class="m-markdown"> ${unsafe_html_ae(marked(path.description))}</div>` : ''}
      ${pathSecurityTemplate.call(this, path.security)}
      ${(_path$externalDocs = path.externalDocs) !== null && _path$externalDocs !== void 0 && _path$externalDocs.url || (_path$externalDocs2 = path.externalDocs) !== null && _path$externalDocs2 !== void 0 && _path$externalDocs2.description ? ke`<div style="background-color:var(--bg3); padding:2px 8px 8px 8px; margin:8px 0; border-radius:var(--border-radius)"> 
            <div class="m-markdown"> ${unsafe_html_ae(marked(((_path$externalDocs3 = path.externalDocs) === null || _path$externalDocs3 === void 0 ? void 0 : _path$externalDocs3.description) || ''))} </div>
            ${(_path$externalDocs4 = path.externalDocs) !== null && _path$externalDocs4 !== void 0 && _path$externalDocs4.url ? ke`<a style="font-family:var(--font-mono); font-size:var(--font-size-small)" href="${(_path$externalDocs5 = path.externalDocs) === null || _path$externalDocs5 === void 0 ? void 0 : _path$externalDocs5.url}" target="_blank">
                  ${(_path$externalDocs6 = path.externalDocs) === null || _path$externalDocs6 === void 0 ? void 0 : _path$externalDocs6.url} <div style="transform: rotate(270deg) scale(1.5); display: inline-block; margin-left:5px">⇲</div>
                </a>` : ''}
          </div>` : ''}
      ${codeSampleTabPanel}
      <div class='expanded-req-resp-container'>
        <api-request
          class = "${this.renderStyle}-mode"
          style = "width:100%;"
          webhook = "${path.isWebhook}"
          method = "${path.method}"
          path = "${path.path}"
          .security = "${path.security}"
          .parameters = "${path.parameters}"
          .request_body = "${path.requestBody}"
          .api_keys = "${nonEmptyApiKeys}"
          .servers = "${path.servers}"
          server-url = "${((_path$servers = path.servers) === null || _path$servers === void 0 || (_path$servers = _path$servers[0]) === null || _path$servers === void 0 ? void 0 : _path$servers.url) || ((_this$selectedServer = this.selectedServer) === null || _this$selectedServer === void 0 ? void 0 : _this$selectedServer.computedUrl)}"
          fill-request-fields-with-example = "${this.fillRequestFieldsWithExample}"
          allow-try = "${this.allowTry}"
          show-curl-before-try = "${this.showCurlBeforeTry}"
          accept = "${accept}"
          render-style="${this.renderStyle}" 
          schema-style = "${this.schemaStyle}"
          active-schema-tab = "${this.defaultSchemaTab}"
          schema-expand-level = "${this.schemaExpandLevel}"
          schema-description-expanded = "${this.schemaDescriptionExpanded}"
          allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
          schema-hide-read-only = "${this.schemaHideReadOnly === 'never' ? 'false' : path.isWebhook ? 'false' : 'true'}"
          schema-hide-write-only = "${this.schemaHideWriteOnly === 'never' ? 'false' : path.isWebhook ? 'true' : 'false'}"
          fetch-credentials = "${this.fetchCredentials}"
          exportparts = "wrap-request-btn:wrap-request-btn, btn:btn, btn-fill:btn-fill, btn-outline:btn-outline, btn-try:btn-try, btn-clear:btn-clear, btn-clear-resp:btn-clear-resp,
            tab-panel:tab-panel, tab-btn:tab-btn, tab-btn-row:tab-btn-row, tab-coontent:tab-content, 
            file-input:file-input, textbox:textbox, textbox-param:textbox-param, textarea:textarea, textarea-param:textarea-param, 
            anchor:anchor, anchor-param-example:anchor-param-example, schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
        > </api-request>

        ${path.callbacks ? callbackTemplate.call(this, path.callbacks) : ''}

        <api-response
          class = "${this.renderStyle}-mode"
          style = "width:100%;"
          webhook = "${path.isWebhook}"
          .responses = "${path.responses}"
          render-style = "${this.renderStyle}"
          schema-style = "${this.schemaStyle}"
          active-schema-tab = "${this.defaultSchemaTab}"
          schema-expand-level = "${this.schemaExpandLevel}"
          schema-description-expanded = "${this.schemaDescriptionExpanded}"
          allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
          schema-hide-read-only = "${this.schemaHideReadOnly === 'never' ? 'false' : path.isWebhook ? 'true' : 'false'}"
          schema-hide-write-only = "${this.schemaHideWriteOnly === 'never' ? 'false' : path.isWebhook ? 'false' : 'true'}"
          selected-status = "${Object.keys(path.responses || {})[0] || ''}"
          exportparts = "btn:btn, btn-response-status:btn-response-status, btn-selected-response-status:btn-selected-response-status, btn-fill:btn-fill, btn-copy:btn-copy,
            tab-panel:tab-panel, tab-btn:tab-btn, tab-btn-row:tab-btn-row, tab-coontent:tab-content, 
            schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
        > </api-response>
      </div>
    </div>
  `;
}
function expandedEndpointTemplate() {
  if (!this.resolvedSpec) {
    return '';
  }
  return ke`
  ${this.resolvedSpec.tags.map(tag => ke`
    <section id="${tag.elementId}" part="section-tag" class="regular-font section-gap--read-mode observe-me" style="border-top:1px solid var(--primary-color);">
      <div class="title tag" part="section-tag-title label-tag-title">${tag.displayName || tag.name}</div>
      <slot name="${tag.elementId}"></slot>
      <div class="regular-font-size">
      ${unsafe_html_ae(`
          <div class="m-markdown regular-font">
          ${marked(tag.description || '', this.infoDescriptionHeadingsInNavBar === 'true' ? {
    renderer: headingRenderer(tag.elementId)
  } : undefined)}
        </div>`)}
      </div>
    </section>
    <section class="regular-font section-gap--read-mode" part="section-operations-in-tag">
      ${tag.paths.map(path => expandedEndpointBodyTemplate.call(this, path))}
    </section>
    `)}
`;
}
/* eslint-enable indent */
;// ./src/templates/components-template.js

 // eslint-disable-line import/extensions





function schemaBodyTemplate(sComponent) {
  return ke`
  <div class='divider'></div>
  <div class='expanded-endpoint-body observe-me ${sComponent.name}' id='cmp--${sComponent.id}' >
    <div style="font-weight:bold"> ${sComponent.name} <span style="color:var(--light-fg); font-size:var(--font-size-small); font-weight:400;"> Schema </span></div>
  ${this.schemaStyle === 'table' ? ke`
      <schema-table
        .data = '${schemaInObjectNotation(sComponent.component, {})}'
        schema-expand-level = "${this.schemaExpandLevel}"
        schema-description-expanded = "${this.schemaDescriptionExpanded}"
        allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
        schema-hide-read-only = "false"
        schema-hide-write-only = "${this.schemaHideWriteOnly}"
        exportparts = "schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
      > </schema-table>` : ke`
      <schema-tree
        .data = '${schemaInObjectNotation(sComponent.component, {})}'
        schema-expand-level = "${this.schemaExpandLevel}"
        schema-description-expanded = "${this.schemaDescriptionExpanded}"
        allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
        schema-hide-read-only = "false"
        schema-hide-write-only = "${this.schemaHideWriteOnly}"
        exportparts = "schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
      > </schema-tree>`}
  </div>`;
}
function componentBodyTemplate(sComponent, componentType) {
  if (sComponent.id.indexOf('schemas-') !== -1) {
    return schemaBodyTemplate.call(this, sComponent);
  }
  return ke`
  <div class='divider'></div>
  <div class='expanded-endpoint-body observe-me ${sComponent.name}' id='cmp--${sComponent.id}' >
    ${ke`
      <div style="font-weight:bold"> ${sComponent.name} <span style="color:var(--light-fg); font-size:var(--font-size-small); font-weight:400"> ${componentType} </span> </div>
      ${sComponent.component ? ke`
      <div class='mono-font regular-font-size' style='padding: 8px 0; color:var(--fg2)'> 
        <json-tree class="border tree" render-style='${this.renderStyle}' .data="${sComponent.component}"> </json-tree>
      </div>` : ''}
    `}
  </div>
  `;
}
function componentsTemplate() {
  if (!this.resolvedSpec) {
    return '';
  }
  return ke`
  ${this.resolvedSpec.components.map(component => ke`
    <div id="cmp--${component.name.toLowerCase()}" class='regular-font section-gap--read-mode observe-me' style="border-top:1px solid var(--primary-color);">
      <div class="title tag">${component.name}</div>
      <div class="regular-font-size">
        ${unsafe_html_ae(`<div class='m-markdown regular-font'>${marked(component.description ? component.description : '')}</div>`)}
      </div>
    </div>
    <div class='regular-font section-gap--read-mode'>
      ${component.subComponents.filter(c => c.expanded !== false).map(sComponent => componentBodyTemplate.call(this, sComponent, component.name))}
    </div>
    `)}
`;
}
/* eslint-enable indent */
;// ./src/templates/overview-template.js

 // eslint-disable-line import/extensions



/* eslint-disable indent */
function overview_template_headingRenderer() {
  const renderer = new marked.Renderer();
  renderer.heading = (text, level, raw, slugger) => `<h${level} class="observe-me" id="overview--${slugger.slug(raw)}">${text}</h${level}>`;
  return renderer;
}
function overviewTemplate() {
  var _this$resolvedSpec, _this$resolvedSpec$in, _this$resolvedSpec$in2, _this$specUrl;
  return ke`
    <section id="overview" part="section-overview"
      class="observe-me ${this.renderStyle === 'view' ? 'section-gap' : 'section-gap--read-mode'}">
      ${(_this$resolvedSpec = this.resolvedSpec) !== null && _this$resolvedSpec !== void 0 && _this$resolvedSpec.info ? ke`
          <div id="api-title" part="section-overview-title" style="font-size:32px">
            ${this.resolvedSpec.info.title}
            ${!this.resolvedSpec.info.version ? '' : ke`
              <span style = 'font-size:var(--font-size-small);font-weight:bold'>
                ${this.resolvedSpec.info.version}
              </span>`}
          </div>
          <div id="api-info" style="font-size:calc(var(--font-size-regular) - 1px); margin-top:8px;">
            ${(_this$resolvedSpec$in = this.resolvedSpec.info.contact) !== null && _this$resolvedSpec$in !== void 0 && _this$resolvedSpec$in.email ? ke`<span>${this.resolvedSpec.info.contact.name || 'Email'}: 
                <a href="mailto:${this.resolvedSpec.info.contact.email}" part="anchor anchor-overview">${this.resolvedSpec.info.contact.email}</a>
              </span>` : ''}
            ${(_this$resolvedSpec$in2 = this.resolvedSpec.info.contact) !== null && _this$resolvedSpec$in2 !== void 0 && _this$resolvedSpec$in2.url ? ke`<span>URL: <a href="${this.resolvedSpec.info.contact.url}" part="anchor anchor-overview">${this.resolvedSpec.info.contact.url}</a></span>` : ''}
            ${this.resolvedSpec.info.license ? ke`<span>License: 
                ${this.resolvedSpec.info.license.url ? ke`<a href="${this.resolvedSpec.info.license.url}" part="anchor anchor-overview">${this.resolvedSpec.info.license.name}</a>` : this.resolvedSpec.info.license.name} </span>` : ''}
            ${this.resolvedSpec.info.termsOfService ? ke`<span><a href="${this.resolvedSpec.info.termsOfService}" part="anchor anchor-overview">Terms of Service</a></span>` : ''}
            ${this.specUrl && this.allowSpecFileDownload === 'true' ? ke`
                <div style="display:flex; margin:12px 0; gap:8px; justify-content: start;">
                  <button class="m-btn thin-border" style="min-width:170px" part="btn btn-outline" @click='${e => {
    downloadResource(this.specUrl, 'openapi-spec', e);
  }}'>Download OpenAPI spec</button>
                  ${(_this$specUrl = this.specUrl) !== null && _this$specUrl !== void 0 && _this$specUrl.trim().toLowerCase().endsWith('json') ? ke`<button class="m-btn thin-border" style="width:200px" part="btn btn-outline" @click='${e => {
    viewResource(this.specUrl, e);
  }}'>View OpenAPI spec (New Tab)</button>` : ''}
                </div>` : ''}
          </div>
          <slot name="overview"></slot>
          <div id="api-description">
          ${this.resolvedSpec.info.description ? ke`${unsafe_html_ae(`
                <div class="m-markdown regular-font">
                ${marked(this.resolvedSpec.info.description, this.infoDescriptionHeadingsInNavBar === 'true' ? {
    renderer: overview_template_headingRenderer()
  } : undefined)}
              </div>`)}` : ''}
          </div>
        ` : ''}
    </section>
  `;
}
/* eslint-enable indent */
;// ./src/templates/server-template.js

 // eslint-disable-line import/extensions

function setApiServer(serverUrl) {
  var _this$resolvedSpec;
  const serverObj = (_this$resolvedSpec = this.resolvedSpec) === null || _this$resolvedSpec === void 0 ? void 0 : _this$resolvedSpec.servers.find(s => s.url === serverUrl);
  if (!serverObj) {
    return false;
  }
  this.selectedServer = serverObj;
  this.requestUpdate();
  this.dispatchEvent(new CustomEvent('api-server-change', {
    bubbles: true,
    composed: true,
    detail: {
      selectedServer: serverObj
    }
  }));
  return true;
}
function onApiServerVarChange(e, serverObj) {
  const inputEls = [...e.currentTarget.closest('table').querySelectorAll('input, select')];
  let tempUrl = serverObj.url;
  inputEls.forEach(v => {
    const regex = new RegExp(`{${v.dataset.var}}`, 'g');
    tempUrl = tempUrl.replace(regex, v.value);
  });
  serverObj.computedUrl = tempUrl;
  this.requestUpdate();
}

/* eslint-disable indent */
function serverVarsTemplate() {
  // const selectedServerObj = this.resolvedSpec.servers.find((v) => (v.url === this.selectedServer));
  return this.selectedServer && this.selectedServer.variables ? ke`
    <div class="table-title">SERVER VARIABLES</div>
    <table class='m-table' role='presentation'>
      ${Object.entries(this.selectedServer.variables).map(kv => ke`
        <tr>
          <td style="vertical-align: middle;" >${kv[0]}</td>
          <td>
            ${kv[1].enum ? ke`
            <select
              data-var = "${kv[0]}"
              @input = ${e => {
    onApiServerVarChange.call(this, e, this.selectedServer);
  }}
            >
            ${Object.entries(kv[1].enum).map(e => kv[1].default === e[1] ? ke`
              <option
                selected
                label = ${e[1]}
                value = ${e[1]}
              />` : ke`
              <option
                label = ${e[1]}
                value = ${e[1]}
              />`)}
            </select>` : ke`
            <input
              type = "text"
              part="textbox textbox-server-var"
              spellcheck = "false"
              data-var = "${kv[0]}"
              value = "${kv[1].default}"
              @input = ${e => {
    onApiServerVarChange.call(this, e, this.selectedServer);
  }}
            />`}
          </td>
        </tr>
        ${kv[1].description ? ke`<tr><td colspan="2" style="border:none"><span class="m-markdown-small"> ${unsafe_html_ae(marked(kv[1].description))} </span></td></tr>` : ''}
      `)}
    </table>
    ` : '';
}
function serverTemplate() {
  var _this$resolvedSpec$se, _this$resolvedSpec2, _this$selectedServer;
  if (!this.resolvedSpec || this.resolvedSpec.specLoadError) {
    return '';
  }
  return ke`
  <section id = 'servers' part="section-servers" style="text-align:left; direction:ltr; margin-top:24px; margin-bottom:24px;" class='regular-font observe-me ${'read focused'.includes(this.renderStyle) ? 'section-gap--read-mode' : 'section-gap'}'>
    <div part = "section-servers-title" class = "sub-title">API SERVER</div>
    <div class = 'mono-font' style='margin: 12px 0; font-size:calc(var(--font-size-small) + 1px);'>
      ${!this.resolvedSpec.servers || ((_this$resolvedSpec$se = this.resolvedSpec.servers) === null || _this$resolvedSpec$se === void 0 ? void 0 : _this$resolvedSpec$se.length) === 0 ? '' : ke`
          ${(_this$resolvedSpec2 = this.resolvedSpec) === null || _this$resolvedSpec2 === void 0 ? void 0 : _this$resolvedSpec2.servers.map((server, i) => ke`
            <input type = 'radio'
              name = 'api_server'
              id = 'srvr-opt-${i}'
              value = '${server.url}'
              @change = ${() => {
    setApiServer.call(this, server.url);
  }}
              .checked = '${this.selectedServer.url === server.url}'
              style = 'margin:4px 0; cursor:pointer'
            />
              <label style='cursor:pointer' for='srvr-opt-${i}'>
                ${server.url} ${server.description ? ke`- <span class='regular-font'>${server.description} </span>` : ''}
              </label>
            <br/>
          `)}
      `}
      <div class="table-title primary-text" part="label-selected-server"> SELECTED: ${((_this$selectedServer = this.selectedServer) === null || _this$selectedServer === void 0 ? void 0 : _this$selectedServer.computedUrl) || 'none'}</div>
    </div>
    <slot name="servers"></slot>
    ${serverVarsTemplate.call(this)}
  </section>`;
}
/* eslint-enable indent */
;// ./src/templates/navbar-template.js



function expandCollapseNavBarTag(navLinkEl, action = 'toggle') {
  const tagAndPathEl = navLinkEl === null || navLinkEl === void 0 ? void 0 : navLinkEl.closest('.nav-bar-tag-and-paths');
  const pathsUnderTagEl = tagAndPathEl === null || tagAndPathEl === void 0 ? void 0 : tagAndPathEl.querySelector('.nav-bar-paths-under-tag');
  if (tagAndPathEl) {
    const isExpanded = tagAndPathEl.classList.contains('expanded');
    if (isExpanded && (action === 'toggle' || action === 'collapse')) {
      pathsUnderTagEl.style.maxHeight = 0;
      tagAndPathEl.classList.replace('expanded', 'collapsed');
    } else if (!isExpanded && (action === 'toggle' || action === 'expand')) {
      tagAndPathEl.classList.replace('collapsed', 'expanded');
      pathsUnderTagEl.style.maxHeight = `${pathsUnderTagEl.scrollHeight}px`;
    }
  }
}
function expandCollapseAll(event, action = 'expand-all') {
  if (!(event.type === 'click' || event.type === 'keyup' && event.keyCode === 13)) {
    return;
  }
  const navEl = event.target.closest('.nav-scroll');
  const elList = [...navEl.querySelectorAll('.nav-bar-tag-and-paths')];
  if (action === 'expand-all') {
    elList.forEach(el => {
      const navBarPathsUnderTagEl = el.querySelector('.nav-bar-paths-under-tag');
      el.classList.replace('collapsed', 'expanded');
      navBarPathsUnderTagEl.style.maxHeight = `${navBarPathsUnderTagEl === null || navBarPathsUnderTagEl === void 0 ? void 0 : navBarPathsUnderTagEl.scrollHeight}px`;
    });
  } else {
    elList.forEach(el => {
      el.classList.replace('expanded', 'collapsed');
      el.querySelector('.nav-bar-paths-under-tag').style.maxHeight = 0;
    });
  }
}
function navBarClickAndEnterHandler(event) {
  var _navEl$dataset, _navEl$dataset2, _navEl$dataset3, _navEl$dataset4;
  if (!(event.type === 'click' || event.type === 'keyup' && event.keyCode === 13)) {
    return;
  }
  const navEl = event.target;
  event.stopPropagation();
  if (((_navEl$dataset = navEl.dataset) === null || _navEl$dataset === void 0 ? void 0 : _navEl$dataset.action) === 'navigate') {
    this.scrollToEventTarget(event, false);
  } else if (((_navEl$dataset2 = navEl.dataset) === null || _navEl$dataset2 === void 0 ? void 0 : _navEl$dataset2.action) === 'expand-all' || ((_navEl$dataset3 = navEl.dataset) === null || _navEl$dataset3 === void 0 ? void 0 : _navEl$dataset3.action) === 'collapse-all') {
    expandCollapseAll(event, navEl.dataset.action);
  } else if (((_navEl$dataset4 = navEl.dataset) === null || _navEl$dataset4 === void 0 ? void 0 : _navEl$dataset4.action) === 'expand-collapse-tag') {
    expandCollapseNavBarTag(navEl, 'toggle');
  }
}

/* eslint-disable indent */
function navbarTemplate() {
  var _this$resolvedSpec$in, _this$resolvedSpec$in2;
  if (!this.resolvedSpec || this.resolvedSpec.specLoadError) {
    return ke`
      <nav class='nav-bar' part='section-navbar'>
        <slot name='nav-logo' class='logo'></slot>
      </nav>
    `;
  }
  return ke`
  <nav class='nav-bar ${this.renderStyle}' part='section-navbar'>
    <slot name='nav-logo' class='logo'></slot>
    ${this.allowSearch === 'false' && this.allowAdvancedSearch === 'false' ? '' : ke`
        <div style='display:flex; flex-direction:row; justify-content:center; align-items:stretch; padding:8px 24px 12px 24px; ${this.allowAdvancedSearch === 'false' ? 'border-bottom: 1px solid var(--nav-hover-bg-color)' : ''}' part='section-navbar-search'>
          ${this.allowSearch === 'false' ? '' : ke`
              <div style = 'display:flex; flex:1; line-height:22px;'>
                <input id = 'nav-bar-search' 
                  part = 'textbox textbox-nav-filter'
                  style = 'width:100%; padding-right:20px; color:var(--nav-hover-text-color); border-color:var(--nav-accent-color); background-color:var(--nav-hover-bg-color)'
                  type = 'text'
                  placeholder = 'Filter' 
                  @change = '${this.onSearchChange}'
                  spellcheck = 'false'
                >
                <div style='margin: 6px 5px 0 -24px; font-size:var(--font-size-regular); cursor:pointer;'>&#x21a9;</div>
              </div>  
              ${this.searchVal ? ke`
                  <button @click = '${this.onClearSearch}' class='m-btn thin-border' style='margin-left:5px; color:var(--nav-text-color); width:75px; padding:6px 8px;' part='btn btn-outline btn-clear-filter'>
                    CLEAR
                  </button>` : ''}
            `}
          ${this.allowAdvancedSearch === 'false' || this.searchVal ? '' : ke`
              <button class='m-btn primary' part='btn btn-fill btn-search' style='margin-left:5px; padding:6px 8px; width:75px' @click='${this.onShowSearchModalClicked}'>
                SEARCH
              </button>
            `}
        </div>
      `}
    ${ke`<nav class='nav-scroll' tabindex='-1' part='section-navbar-scroll' @click='${e => navBarClickAndEnterHandler.call(this, e)}' @keyup='${e => navBarClickAndEnterHandler.call(this, e)}' >
      ${this.showInfo === 'false' || !this.resolvedSpec.info ? '' : ke`
          ${this.infoDescriptionHeadingsInNavBar === 'true' ? ke`
              ${this.resolvedSpec.infoDescriptionHeaders.length > 0 ? ke`<div class='nav-bar-info ${this.navActiveItemMarker}' id='link-overview' data-content-id='overview' data-action='navigate' tabindex='0' part='section-navbar-item section-navbar-overview'> 
                    ${((_this$resolvedSpec$in = this.resolvedSpec.info) === null || _this$resolvedSpec$in === void 0 || (_this$resolvedSpec$in = _this$resolvedSpec$in.title) === null || _this$resolvedSpec$in === void 0 ? void 0 : _this$resolvedSpec$in.trim()) || 'Overview'}
                  </div>` : ''}
              <div class='overview-headers'>
                ${this.resolvedSpec.infoDescriptionHeaders.map(header => ke`
                  <div
                    class='nav-bar-h${header.depth} ${this.navActiveItemMarker}' 
                    id='link-overview--${new marked.Slugger().slug(header.text)}'
                    data-action='navigate' 
                    data-content-id='overview--${new marked.Slugger().slug(header.text)}' 
                  >
                    ${header.text}
                  </div>`)}
              </div>
              ${this.resolvedSpec.infoDescriptionHeaders.length > 0 ? ke`<hr style='border-top: 1px solid var(--nav-hover-bg-color); border-width:1px 0 0 0; margin: 15px 0 0 0'/>` : ''}
            ` : ke`<div class='nav-bar-info ${this.navActiveItemMarker}' id='link-overview' data-action='navigate' data-content-id='overview' tabindex='0'> 
              ${((_this$resolvedSpec$in2 = this.resolvedSpec.info) === null || _this$resolvedSpec$in2 === void 0 || (_this$resolvedSpec$in2 = _this$resolvedSpec$in2.title) === null || _this$resolvedSpec$in2 === void 0 ? void 0 : _this$resolvedSpec$in2.trim()) || 'Overview'}
            </div>`}
        `}
    
      ${this.allowServerSelection === 'false' ? '' : ke`<div class='nav-bar-info ${this.navActiveItemMarker}' id='link-servers' data-action='navigate' data-content-id='servers' tabindex='0' part='section-navbar-item section-navbar-servers'> API Servers </div>`}
      ${this.allowAuthentication === 'false' || !this.resolvedSpec.securitySchemes ? '' : ke`<div class='nav-bar-info ${this.navActiveItemMarker}' id='link-auth' data-action='navigate' data-content-id='auth' tabindex='0' part='section-navbar-item section-navbar-auth'> Authentication </div>`}

      <div id='link-operations-top' class='nav-bar-section operations' data-action='navigate' data-content-id='${this.renderStyle === 'focused' ? '' : 'operations-top'}' part='section-navbar-item section-navbar-operations-top'>
        <div style='font-size:16px; display:flex; margin-left:10px;'>
          ${this.renderStyle === 'focused' ? ke`
              <div class='nav-bar-expand-all'
                data-action='expand-all'
                tabindex='0' 
                title='Expand all'
              >▸</div>
              <div class='nav-bar-collapse-all'
                data-action='collapse-all'
                tabindex='0' 
                title='Collapse all'
              >▸</div>` : ''}  
        </div>
        <div class='nav-bar-section-title'> OPERATIONS </div>
      </div>

      <!-- TAGS AND PATHS-->
      ${this.resolvedSpec.tags.filter(tag => tag.paths.filter(path => getMatchedPaths(this.searchVal, path, tag.name)).length).map(tag => {
    var _tag$paths;
    return ke`
          <div class='nav-bar-tag-and-paths ${this.renderStyle === 'read' ? 'expanded' : tag.expanded ? 'expanded' : 'collapsed'}' >
            ${tag.name === 'General ⦂' ? ke`<hr style='border:none; border-top: 1px dotted var(--nav-text-color); opacity:0.3; margin:-1px 0 0 0;'/>` : ke`
                <div 
                  class='nav-bar-tag ${this.navActiveItemMarker}'
                  part='section-navbar-item section-navbar-tag'
                  id='link-${tag.elementId}'
                  data-action='${(this.renderStyle === 'read' ? 'navigate' : this.onNavTagClick === 'show-description') ? 'navigate' : 'expand-collapse-tag'}'
                  data-content-id='${(this.renderStyle === 'read' ? `${tag.elementId}` : this.onNavTagClick === 'show-description') ? `${tag.elementId}` : ''}'
                  data-first-path-id='${tag.firstPathId}'
                  tabindex='0'
                >
                  <div style="pointer-events:none;">${tag.displayName || tag.name}</div>
                  <div class='nav-bar-tag-icon' tabindex='0' data-action='expand-collapse-tag'></div>
                </div>
              `}
            ${this.infoDescriptionHeadingsInNavBar === 'true' ? ke`
                ${this.renderStyle === 'focused' && this.onNavTagClick === 'expand-collapse' ? '' : ke`
                    <div class='tag-headers'>
                      ${tag.headers.map(header => ke`
                      <div
                        class='nav-bar-h${header.depth} ${this.navActiveItemMarker}'
                        part='section-navbar-item section-navbar-h${header.depth}'
                        id='link-${tag.elementId}--${new marked.Slugger().slug(header.text)}'
                        data-action='navigate'
                        data-content-id='${tag.elementId}--${new marked.Slugger().slug(header.text)}'
                        tabindex='0'
                      > ${header.text}</div>`)}
                    </div>`}` : ''}
            <div class='nav-bar-paths-under-tag' style='max-height:${tag.expanded || this.renderStyle === 'read' ? (((_tag$paths = tag.paths) === null || _tag$paths === void 0 ? void 0 : _tag$paths.length) || 1) * 50 : 0}px;'>
              <!-- Paths in each tag (endpoints) -->
              ${tag.paths.filter(v => {
      if (this.searchVal) {
        return getMatchedPaths(this.searchVal, v, tag.name);
      }
      return true;
    }).map(p => ke`
              <div 
                class='nav-bar-path ${this.navActiveItemMarker} ${this.usePathInNavBar === 'true' ? 'small-font' : ''}'
                part='section-navbar-item section-navbar-path'
                data-action='navigate'
                data-content-id='${p.elementId}'
                id='link-${p.elementId}'
                tabindex='0'
              >
                <span style = 'display:flex; pointer-events: none; align-items:start; ${p.deprecated ? 'filter:opacity(0.5)' : ''}'>
                  ${ke`<span class='nav-method ${this.showMethodInNavBar} ${p.method}' style='pointer-events: none;'>
                      ${this.showMethodInNavBar === 'as-colored-block' ? p.method.substring(0, 3).toUpperCase() : p.method.toUpperCase()}
                    </span>`}
                  ${p.isWebhook ? ke`<span style='font-weight:bold; pointer-events: none; margin-right:8px; font-size: calc(var(--font-size-small) - 2px)'>WEBHOOK</span>` : ''}
                  ${this.usePathInNavBar === 'true' ? ke`<span style='pointer-events: none;' class='mono-font'>${p.path}</span>` : p.summary || p.shortSummary}
                </span>
              </div>`)}
            </div>
          </div>
        `;
  })}

      <!-- COMPONENTS -->
      ${this.resolvedSpec.components && this.showComponents === 'true' && this.renderStyle === 'focused' ? ke`
          <div id='link-components' class='nav-bar-section components'>
            <div></div>
            <div class='nav-bar-section-title'>COMPONENTS</div>
          </div>
          ${this.resolvedSpec.components.map(component => component.subComponents.length ? ke`
              <div class='nav-bar-tag'
                part='section-navbar-item section-navbar-tag'
                data-action='navigate' 
                data-content-id='cmp--${component.name.toLowerCase()}' 
                id='link-cmp--${component.name.toLowerCase()}'
              >
                ${component.name}
              </div>
              ${component.subComponents.filter(p => p.expanded !== false).map(p => ke`
                <div class='nav-bar-path' data-action='navigate' data-content-id='cmp--${p.id}' id='link-cmp--${p.id}'>
                  <span style = 'pointer-events: none;'> ${p.name} </span>
                </div>`)}` : '')}` : ''}
    </nav>`}
</nav>
`;
}
/* eslint-enable indent */
;// ./src/templates/focused-endpoint-template.js

 // eslint-disable-line import/extensions









function focused_endpoint_template_headingRenderer(tagElementId) {
  const renderer = new marked.Renderer();
  renderer.heading = (text, level, raw, slugger) => `<h${level} class="observe-me" id="${tagElementId}--${slugger.slug(raw)}">${text}</h${level}>`;
  return renderer;
}
function wrapFocusedTemplate(templateToWrap) {
  return ke`
    <div class='regular-font section-gap--focused-mode' part="section-operations-in-tag">
      ${templateToWrap}
    </div>`;
}
function defaultContentTemplate() {
  var _this$resolvedSpec$ta;
  // In focused mode default content is overview or first path
  if (this.showInfo === 'true') {
    return wrapFocusedTemplate(overviewTemplate.call(this));
  }
  const selectedTagObj = this.resolvedSpec.tags[0];
  const selectedPathObj = (_this$resolvedSpec$ta = this.resolvedSpec.tags[0]) === null || _this$resolvedSpec$ta === void 0 ? void 0 : _this$resolvedSpec$ta.paths[0];
  return selectedTagObj && selectedPathObj ? wrapFocusedTemplate(expandedEndpointBodyTemplate.call(this, selectedPathObj, selectedTagObj.name)) : wrapFocusedTemplate('');
}

/* eslint-disable indent */
function focusedTagBodyTemplate(tag) {
  return ke`
    <h1 id="${tag.elementId}">${tag.displayName || tag.name}</h1>
    ${this.onNavTagClick === 'show-description' && tag.description ? ke`
        <div class="m-markdown">
          ${unsafe_html_ae(`
            <div class="m-markdown regular-font">
              ${marked(tag.description || '', this.infoDescriptionHeadingsInNavBar === 'true' ? {
    renderer: focused_endpoint_template_headingRenderer(tag.elementId)
  } : undefined)}
            </div>`)}
        </div>` : ''}
  `;
}
function focusedEndpointTemplate() {
  if (!this.focusedElementId || !this.resolvedSpec) {
    return;
  }
  const focusElId = this.focusedElementId;
  let selectedPathObj = null;
  let selectedTagObj = null;
  let focusedTemplate;
  let i = 0;
  if (focusElId.startsWith('overview') && this.showInfo === 'true') {
    focusedTemplate = overviewTemplate.call(this);
  } else if (focusElId === 'auth' && this.allowAuthentication === 'true') {
    focusedTemplate = securitySchemeTemplate.call(this);
  } else if (focusElId === 'servers' && this.allowServerSelection === 'true') {
    focusedTemplate = serverTemplate.call(this);
  } else if (focusElId === 'operations-top') {
    focusedTemplate = ke`
    <div id="operations-top" class="observe-me">
      <slot name="operations-top"></slot>
    </div>`;
  } else if (focusElId.startsWith('cmp--') && this.showComponents === 'true') {
    focusedTemplate = componentsTemplate.call(this);
  } else if (focusElId.startsWith('tag--')) {
    const idToFocus = focusElId.indexOf('--', 4) > 0 ? focusElId.substring(0, focusElId.indexOf('--', 5)) : focusElId;
    selectedTagObj = this.resolvedSpec.tags.find(v => v.elementId === idToFocus);
    if (selectedTagObj) {
      focusedTemplate = wrapFocusedTemplate.call(this, focusedTagBodyTemplate.call(this, selectedTagObj));
    } else {
      focusedTemplate = defaultContentTemplate.call(this);
    }
  } else {
    for (i = 0; i < this.resolvedSpec.tags.length; i += 1) {
      selectedTagObj = this.resolvedSpec.tags[i];
      selectedPathObj = this.resolvedSpec.tags[i].paths.find(v => `${v.elementId}` === focusElId);
      if (selectedPathObj) {
        break;
      }
    }
    if (selectedPathObj) {
      // In focused mode we must expand the nav-bar tag element if it is collapsed
      const newNavEl = this.shadowRoot.getElementById(`link-${focusElId}`);
      expandCollapseNavBarTag(newNavEl, 'expand');
      focusedTemplate = wrapFocusedTemplate.call(this, expandedEndpointBodyTemplate.call(this, selectedPathObj, selectedTagObj.name || '', selectedTagObj.description || ''));
    } else {
      // if focusedElementId is not found then show the default content (overview or first-path)
      focusedTemplate = defaultContentTemplate.call(this);
    }
  }
  return focusedTemplate;
}
/* eslint-enable indent */
;// ./src/templates/endpoint-template.js

 // eslint-disable-line import/extensions







function toggleExpand(path) {
  if (path.expanded) {
    path.expanded = false; // collapse
    if (this.updateRoute === 'true') {
      this.replaceHistoryState('');
    }
  } else {
    path.expanded = true; // Expand
    if (this.updateRoute === 'true') {
      const newHash = `${this.routePrefix || '#'}${path.elementId}`;
      if (window.location.hash !== newHash) {
        this.replaceHistoryState(path.elementId);
      }
    }
  }
  this.requestUpdate();
}
function endpoint_template_expandCollapseAll(operationsRootEl, action = 'expand-all') {
  const elList = [...operationsRootEl.querySelectorAll('.section-tag')];
  if (action === 'expand-all') {
    elList.map(el => {
      el.classList.replace('collapsed', 'expanded');
    });
  } else {
    elList.map(el => {
      el.classList.replace('expanded', 'collapsed');
    });
  }
}
function onExpandCollapseAll(e, action = 'expand-all') {
  endpoint_template_expandCollapseAll.call(this, e.target.closest('.operations-root'), action);
}

/* eslint-disable indent */
function endpointHeadTemplate(path, pathsExpanded = false) {
  return ke`
  <summary @click="${e => {
    toggleExpand.call(this, path, e);
  }}" part="section-endpoint-head-${path.expanded ? 'expanded' : 'collapsed'}" class='endpoint-head ${path.method} ${path.deprecated ? 'deprecated' : ''} ${pathsExpanded || path.expanded ? 'expanded' : 'collapsed'}'>
    <div part="section-endpoint-head-method" class="method ${path.method} ${path.deprecated ? 'deprecated' : ''}"> ${path.method} </div> 
    <div  part="section-endpoint-head-path" class="path ${path.deprecated ? 'deprecated' : ''}"> 
      ${path.path} 
      ${path.isWebhook ? ke`<span style="font-family: var(--font-regular); font-size: var(--); font-size: var(--font-size-small); color:var(--primary-color); margin-left: 16px"> Webhook</span>` : ''}
    </div>
    ${path.deprecated ? ke`
        <span style="font-size:var(--font-size-small); text-transform:uppercase; font-weight:bold; color:var(--red); margin:2px 0 0 5px;"> 
          deprecated 
        </span>` : ''}
    ${this.showSummaryWhenCollapsed ? ke`
        <div class="only-large-screen" style="min-width:60px; flex:1"></div>
        <div part="section-endpoint-head-description" class="descr">${path.summary || path.shortSummary} </div>` : ''}
  </summary>
  `;
}
function endpointBodyTemplate(path) {
  var _path$xBadges, _path$externalDocs, _path$externalDocs2, _path$externalDocs3, _path$externalDocs4, _path$externalDocs5, _path$externalDocs6, _this$selectedServer;
  const acceptContentTypes = new Set();
  for (const respStatus in path.responses) {
    for (const acceptContentType in (_path$responses$respS = path.responses[respStatus]) === null || _path$responses$respS === void 0 ? void 0 : _path$responses$respS.content) {
      var _path$responses$respS;
      acceptContentTypes.add(acceptContentType.trim());
    }
  }
  const accept = [...acceptContentTypes].join(', ');
  // Filter API Keys that are non-empty and are applicable to the the path
  const nonEmptyApiKeys = this.resolvedSpec.securitySchemes.filter(v => {
    var _path$security;
    return v.finalKeyValue && ((_path$security = path.security) === null || _path$security === void 0 ? void 0 : _path$security.some(ps => v.securitySchemeId in ps));
  }) || [];

  // If a RapiDoc API Key is specified on the element and its value is not hyphen(-) then include it for all paths
  const rapiDocApiKey = this.resolvedSpec.securitySchemes.find(v => v.securitySchemeId === rapidocApiKey && v.value !== '-');
  if (rapiDocApiKey) {
    nonEmptyApiKeys.push(rapiDocApiKey);
  }
  const codeSampleTabPanel = path.xCodeSamples ? codeSamplesTemplate(path.xCodeSamples) : '';
  return ke`
  <div part="section-endpoint-body-${path.expanded ? 'expanded' : 'collapsed'}" class='endpoint-body ${path.method} ${path.deprecated ? 'deprecated' : ''}'>
    <div class="summary">
      ${path.summary ? ke`<div class="title" part="section-endpoint-body-title">${path.summary}</div>` : path.shortSummary !== path.description ? ke`<div class="title" part="section-endpoint-body-title">${path.shortSummary}</div>` : ''}
      ${path.xBadges && ((_path$xBadges = path.xBadges) === null || _path$xBadges === void 0 ? void 0 : _path$xBadges.length) > 0 ? ke`
          <div style="display:flex; flex-wrap:wrap;font-size: var(--font-size-small);">
            ${path.xBadges.map(v => v.color === 'none' ? '' : ke`<span part="endpoint-badge" style="margin:1px; margin-right:5px; padding:1px 8px; font-weight:bold; border-radius:12px;  background-color: var(--light-${v.color}, var(--input-bg)); color:var(--${v.color}); border:1px solid var(--${v.color})">${v.label}</span>`)}
          </div>
          ` : ''}

      ${path.description ? ke`<div part="section-endpoint-body-description" class="m-markdown"> ${unsafe_html_ae(marked(path.description))}</div>` : ''}
      ${(_path$externalDocs = path.externalDocs) !== null && _path$externalDocs !== void 0 && _path$externalDocs.url || (_path$externalDocs2 = path.externalDocs) !== null && _path$externalDocs2 !== void 0 && _path$externalDocs2.description ? ke`<div style="background-color:var(--bg3); padding:2px 8px 8px 8px; margin:8px 0; border-radius:var(--border-radius)"> 
            <div class="m-markdown"> ${unsafe_html_ae(marked(((_path$externalDocs3 = path.externalDocs) === null || _path$externalDocs3 === void 0 ? void 0 : _path$externalDocs3.description) || ''))} </div>
            ${(_path$externalDocs4 = path.externalDocs) !== null && _path$externalDocs4 !== void 0 && _path$externalDocs4.url ? ke`<a style="font-family:var(--font-mono); font-size:var(--font-size-small)" href="${(_path$externalDocs5 = path.externalDocs) === null || _path$externalDocs5 === void 0 ? void 0 : _path$externalDocs5.url}" target="_blank"> 
                  ${(_path$externalDocs6 = path.externalDocs) === null || _path$externalDocs6 === void 0 ? void 0 : _path$externalDocs6.url} <div style="transform: rotate(270deg) scale(1.5); display: inline-block; margin-left:5px">⇲</div>
                </a>` : ''}
          </div>` : ''}
      <slot name="${path.elementId}"></slot>
      ${pathSecurityTemplate.call(this, path.security)}
      ${codeSampleTabPanel}
    </div>  
    <div class='req-resp-container'> 
      <div style="display:flex; flex-direction:column" class="view-mode-request ${this.layout}-layout">
        <api-request
          class = "${this.renderStyle}-mode ${this.layout}-layout"
          style = "width:100%;"
          webhook = "${path.isWebhook}"
          method = "${path.method}"
          path = "${path.path}"
          .security = "${path.security}"
          .parameters = "${path.parameters}"
          .request_body = "${path.requestBody}"
          .api_keys = "${nonEmptyApiKeys}"
          .servers = "${path.servers}" 
          server-url = "${path.servers && path.servers.length > 0 ? path.servers[0].url : (_this$selectedServer = this.selectedServer) === null || _this$selectedServer === void 0 ? void 0 : _this$selectedServer.computedUrl}" 
          active-schema-tab = "${this.defaultSchemaTab}"
          fill-request-fields-with-example = "${this.fillRequestFieldsWithExample}"
          allow-try = "${this.allowTry}"
          show-curl-before-try = "${this.showCurlBeforeTry}"
          accept = "${accept}"
          render-style="${this.renderStyle}" 
          schema-style = "${this.schemaStyle}" 
          schema-expand-level = "${this.schemaExpandLevel}"
          schema-description-expanded = "${this.schemaDescriptionExpanded}"
          allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
          schema-hide-read-only = "${this.schemaHideReadOnly === 'never' ? 'false' : path.isWebhook ? 'false' : 'true'}"
          schema-hide-write-only = "${this.schemaHideWriteOnly === 'never' ? 'false' : path.isWebhook ? 'true' : 'false'}"
          fetch-credentials = "${this.fetchCredentials}"
          exportparts = "wrap-request-btn:wrap-request-btn, btn:btn, btn-fill:btn-fill, btn-outline:btn-outline, btn-try:btn-try, btn-clear:btn-clear, btn-clear-resp:btn-clear-resp,
            tab-panel:tab-panel, tab-btn:tab-btn, tab-btn-row:tab-btn-row, tab-coontent:tab-content, 
            file-input:file-input, textbox:textbox, textbox-param:textbox-param, textarea:textarea, textarea-param:textarea-param, 
            anchor:anchor, anchor-param-example:anchor-param-example, schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
          > </api-request>

          ${path.callbacks ? callbackTemplate.call(this, path.callbacks) : ''}
        </div>  

        <api-response
          class = "${this.renderStyle}-mode"
          style = "width:100%;"
          webhook = "${path.isWebhook}"
          .responses="${path.responses}"
          active-schema-tab = "${this.defaultSchemaTab}" 
          render-style="${this.renderStyle}" 
          schema-style="${this.schemaStyle}"
          schema-expand-level = "${this.schemaExpandLevel}"
          schema-description-expanded = "${this.schemaDescriptionExpanded}"
          allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
          schema-hide-read-only = "${this.schemaHideReadOnly === 'never' ? 'false' : path.isWebhook ? 'true' : 'false'}"
          schema-hide-write-only = "${this.schemaHideWriteOnly === 'never' ? 'false' : path.isWebhook ? 'false' : 'true'}"
          selected-status = "${Object.keys(path.responses || {})[0] || ''}"
          exportparts = "btn:btn, btn-fill:btn-fill, btn-outline:btn-outline, btn-try:btn-try, file-input:file-input, 
            textbox:textbox, textbox-param:textbox-param, textarea:textarea, textarea-param:textarea-param, anchor:anchor, anchor-param-example:anchor-param-example, btn-clear-resp:btn-clear-resp,
            tab-panel:tab-panel, tab-btn:tab-btn, tab-btn-row:tab-btn-row, tab-coontent:tab-content, 
            schema-description:schema-description, schema-multiline-toggle:schema-multiline-toggle"
        > </api-response>
      </div>
  </div>`;
}
function endpointTemplate(isMini = false, pathsExpanded = false) {
  if (!this.resolvedSpec) {
    return '';
  }
  return ke`
    ${isMini ? '' : ke`
        <div style="display:flex; justify-content:flex-end;"> 
          <span @click="${e => onExpandCollapseAll(e, 'expand-all')}" style="color:var(--primary-color); cursor:pointer;">
            Expand all
          </span> 
          &nbsp;|&nbsp; 
          <span @click="${e => onExpandCollapseAll(e, 'collapse-all')}" style="color:var(--primary-color); cursor:pointer;" >
            Collapse all
          </span> 
          &nbsp; sections
        </div>`}
    ${this.resolvedSpec.tags.map(tag => ke`
      ${isMini ? ke`
          <div class='section-tag-body'>
          ${tag.paths.filter(path => {
    if (this.searchVal) {
      return getMatchedPaths(this.searchVal, path, tag.name);
    }
    return true;
  }).map(path => ke`
            <section id='${path.elementId}' class='m-endpoint regular-font ${path.method} ${pathsExpanded || path.expanded ? 'expanded' : 'collapsed'}'>
              ${endpointHeadTemplate.call(this, path, pathsExpanded)}      
              ${pathsExpanded || path.expanded ? endpointBodyTemplate.call(this, path) : ''}
            </section>`)}
          </div>
        ` : ke` 
          <div class='regular-font section-gap section-tag ${tag.expanded ? 'expanded' : 'collapsed'}'> 
            <div class='section-tag-header' @click="${() => {
    tag.expanded = !tag.expanded;
    this.requestUpdate();
  }}">
              <div id='${tag.elementId}' class="sub-title tag" style="color:var(--primary-color)">${tag.displayName || tag.name}</div>
            </div>
            <div class='section-tag-body'>
              <slot name="${tag.elementId}"></slot>
              <div class="regular-font regular-font-size m-markdown" style="padding-bottom:12px">
                ${unsafe_html_ae(marked(tag.description || ''))}
              </div>
              ${tag.paths.filter(v => {
    if (this.searchVal) {
      return getMatchedPaths(this.searchVal, v, tag.name);
    }
    return true;
  }).map(path => ke`
                <section part="section-endpoint" id='${path.elementId}' class='m-endpoint regular-font ${path.method} ${pathsExpanded || path.expanded ? 'expanded' : 'collapsed'}'>
                  ${endpointHeadTemplate.call(this, path, pathsExpanded)}      
                  ${pathsExpanded || path.expanded ? endpointBodyTemplate.call(this, path) : ''}
                </section>`)}
            </div>
          </div>
        `}
  `)}`;
}
/* eslint-enable indent */
;// ./src/templates/logo-template.js


/* eslint-disable indent */
function logoTemplate(style) {
  return ke`
  <div style=${style}>
    <svg viewBox="1 0 511 512">
      <path d="M351 411a202 202 0 01-350 0 203 203 0 01333-24 203 203 0 0117 24zm0 0" fill="#adc165"/>
      <path d="M334 387a202 202 0 01-216-69 202 202 0 01216 69zm78 32H85a8 8 0 01-8-8 8 8 0 018-8h327a8 8 0 017 8 8 8 0 01-7 8zm0 0" fill="#99aa52"/>
      <path d="M374 338l-5 30a202 202 0 01-248-248 203 203 0 01253 218zm0 0" fill="#ffc73b"/>
      <path d="M374 338a202 202 0 01-100-197 203 203 0 01100 197zm38 81l-6-2-231-231a8 8 0 0111-11l231 230a8 8 0 01-5 14zm0 0" fill="#efb025"/>
      <path d="M311 175c0 75 40 140 101 175a202 202 0 000-350 202 202 0 00-101 175zm0 0" fill="#ff903e"/>
      <path d="M412 419a8 8 0 01-8-8V85a8 8 0 0115 0v326a8 8 0 01-7 8zm0 0" fill="#e87425"/>
    </svg>
  </div>    
`;
}
/* eslint-enable indent */
;// ./src/templates/header-template.js



/* eslint-disable indent */
function headerTemplate() {
  return ke`
  <header class="row main-header regular-font" part="section-header" style="padding:8px 4px 8px 4px;min-height:48px;">
    <div class="only-large-screen-flex" style="align-items: center;">
      <slot name="logo" class="logo" part="section-logo">
        ${logoTemplate('height:36px;width:36px;margin-left:5px')}
        <!-- m-logo style="height:36px;width:36px;margin-left:5px"></m-logo -->
      </slot>  
      <div class="header-title" part="label-header-title">${this.headingText}</div>
    </div>  
    <div style="margin: 0px 8px;display:flex;flex:1">
      ${this.allowSpecUrlLoad === 'false' ? '' : ke`
          <input id="spec-url" 
            type="text" 
            style="font-size:var(--font-size-small)" 
            class="header-input mono-font"
            part="textbox textbox-spec-url" 
            placeholder="Spec URL" 
            value="${this.specUrl || ''}" 
            @change="${this.onSpecUrlChange}" 
            spellcheck="false"
          >
          <div style="margin: 6px 5px 0 -24px; font-size:var(--font-size-regular); cursor:pointer;">&#x21a9;</div> 
        `} 
      ${this.allowSpecFileLoad === 'false' ? '' : ke`
          <input id="spec-file" 
            part = "file-input"
            type="file" 
            style="display:none" 
            value="${this.specFile || ''}" 
            @change="${this.onSpecFileChange}" 
            spellcheck="false"
           >
          <button class="m-btn primary only-large-screen" style="margin-left:10px;" part="btn btn-fill" @click="${this.onFileLoadClick}"> LOCAL JSON FILE </button>
        `}
      <slot name="header"></slot>
      ${this.allowSearch === 'false' || 'read focused'.includes(this.renderStyle) ? '' : ke`  
          <input id="search" class="header-input" type="text" part="textbox textbox-header-filter" placeholder="Filter" @change="${this.onSearchChange}" style="max-width:130px;margin-left:10px;" spellcheck="false" >
          <div style="margin: 6px 5px 0 -24px; font-size:var(--font-size-regular); cursor:pointer;">&#x21a9;</div>
        `}
      
      ${this.allowAdvancedSearch === 'false' || 'read focused'.includes(this.renderStyle) ? '' : ke`
          <button class="m-btn primary only-large-screen" part="btn btn-fill btn-search" style="margin-left:10px;" @click="${this.onShowSearchModalClicked}">
            Search
          </button>
        `}
    </div>
    </header>`;
}
/* eslint-enable indent */
;// ./src/styles/dialog-box-styles.js

/* harmony default export */ const dialog_box_styles = (i`
  *, *:before, *:after { box-sizing: border-box; }

  .dialog-box-overlay {
    background-color: var(--overlay-bg);
    position: fixed;
    left: 0;
    top: 0;
    width: 100vw;
    height: 100vh;
    overflow: hidden;
    z-index: var(--dialog-z-index);
  }
  
  .dialog-box {
    position: fixed;
    top: 100px;
    left: 50%;
    transform: translate(-50%, 0%);
    display: flex;
    flex-direction: column;
    width: 70vw;
    background-color: var(--bg2);
    color: var(--fg2);
    border-radius: 4px;
    max-height: 500px;
    overflow: hidden;
    border: 1px solid var(--border-color);
    box-shadow: 0 14px 28px rgba(0,0,0,0.25), 0 10px 10px rgba(0,0,0,0.22);
  }
  
  .dialog-box-header {
    position: sticky;
    top: 0;
    align-self: stretch;
    display: flex;
    align-items: center;
    padding: 0px 16px;
    min-height: 60px;
    max-height: 60px;
    border-bottom: 1px solid var(--light-border-color);
    overflow: hidden;
  }
  
  .dialog-box-header button {
    font-size: 1.5rem;
    font-weight: 700;
    line-height: 1;
    color: var(--fg);
    border: none;
    outline: none;
    background-color: transparent;
    cursor:pointer;
    border: 1px solid transparent;
    border-radius: 50%;
    margin-right: -8px;
  }
  .dialog-box-header button:hover {
    border-color: var(--primary-color);
  }

  .dialog-box-content {
    padding: 16px;
    display:block;
    overflow: auto;
    height: 100%;
  }

  .dialog-box-title {
    flex-grow: 1;
    font-size:24px;
  }
`);
;// ./src/components/dialog-box.js


class DialogBox extends lit_element_h {
  static get properties() {
    return {
      heading: {
        type: String,
        attribute: 'heading'
      },
      show: {
        type: String,
        attribute: 'show'
      }
    };
  }
  static get styles() {
    return [dialog_box_styles];
  }
  connectedCallback() {
    super.connectedCallback();
    document.addEventListener('keydown', e => {
      if (e.code === 'Escape') {
        this.onClose();
      }
    });
  }
  attributeChangedCallback(name, oldVal, newVal) {
    if (oldVal !== newVal) {
      if (name === 'heading') {
        this.heading = newVal;
      }
      if (name === 'show') {
        this.show = newVal;
        if (newVal === 'true') {
          document.dispatchEvent(new CustomEvent('open', {
            bubbles: true,
            composed: true,
            detail: this
          }));
        }
      }
    }
    super.attributeChangedCallback(name, oldVal, newVal);
  }

  /* eslint-disable indent */
  render() {
    return ke`
    ${this.show === 'true' ? ke`
        <div class="dialog-box-overlay">
          <div class="dialog-box">
            <header class="dialog-box-header">
              <span class="dialog-box-title">${this.heading}</span>
              <button type="button" @click="${this.onClose}">&times;</button>
            </header>
            <div class="dialog-box-content">
              <slot></slot>
            </div>
          </div>
        </div>` : ''}`;
  }
  /* eslint-enable indent */

  onClose() {
    document.dispatchEvent(new CustomEvent('close', {
      bubbles: true,
      composed: true
    }));
  }
}
customElements.define('dialog-box', DialogBox);
;// ./src/templates/advance-search-template.js



/* eslint-disable indent */
function searchByPropertiesModalTemplate() {
  var _this$advancedSearchM;
  document.addEventListener('close', () => {
    this.showAdvancedSearchDialog = false;
  });
  document.addEventListener('open', this.onOpenSearchDialog);
  return ke`
    <dialog-box 
      heading="Search" 
      show="${!!this.showAdvancedSearchDialog}"
    >
      <span class="advanced-search-options">
        <input
          id="input-advanced-search-dialog"
          style="width:100%; padding-right:20px;"
          type="text"
          part="textbox textbox-search-dialog"
          placeholder="search text..."
          spellcheck="false"
          @keyup = "${e => this.onAdvancedSearch(e, 400)}"
        >
        <div style="display:flex; margin:8px 0 24px;">
          <div>
            <input style="cursor:pointer;" type="checkbox" part="checkbox checkbox-search-dialog" id="search-api-path" checked @change = "${e => this.onAdvancedSearch(e, 0)}">
            <label for="search-api-path" style="cursor:pointer;"> API Path </label>
            </div>
          <div style="margin-left: 16px;">
            <input style="cursor:pointer;" type="checkbox" part="checkbox checkbox-search-dialog" id="search-api-descr" checked @change = "${e => this.onAdvancedSearch(e, 0)}">
            <label style="cursor:pointer;" for="search-api-descr"> API Description </label>
          </div>
          <div style="margin-left: 16px;">
            <input style="cursor:pointer;" type="checkbox" part="checkbox checkbox-search-dialog" id="search-api-params" @change = "${e => this.onAdvancedSearch(e, 0)}">
            <label style="cursor:pointer;" for="search-api-params"> API Parameters </label>
          </div>
          <div style="margin-left: 16px;">
            <input style="cursor:pointer;" type="checkbox" part="checkbox checkbox-search-dialog" id="search-api-request-body" @change = "${e => this.onAdvancedSearch(e, 0)}">
            <label style="cursor:pointer;" for="search-api-request-body"> Request Body Parameters </label>
          </div>
          <div style="margin-left: 16px;">
            <input style="cursor:pointer;" type="checkbox" part="checkbox checkbox-search-dialog" id="search-api-resp-descr" @change = "${e => this.onAdvancedSearch(e, 0)}">
            <label style="cursor:pointer;" for="search-api-resp-descr"> Response Description </label>
          </div>
        </div>
      </span>
      
      ${(_this$advancedSearchM = this.advancedSearchMatches) === null || _this$advancedSearchM === void 0 ? void 0 : _this$advancedSearchM.map(path => ke`
      <div
        class="mono-font small-font-size hover-bg"
        style='padding: 5px; cursor: pointer; border-bottom: 1px solid var(--light-border-color); ${path.deprecated ? 'filter:opacity(0.5);' : ''}' 
        data-content-id='${path.elementId}'
        tabindex = '0'
        @click="${e => {
    this.searchVal = ''; // clear quick filter if applied
    this.showAdvancedSearchDialog = false; // Hide Search Dialog
    this.requestUpdate();
    this.scrollToEventTarget(e, true);
  }}"
      > 
        <span style="pointer-events: none" class="upper bold-text method-fg ${path.method}">${path.method}</span> 
        <span style="pointer-events: none">${path.path}</span>
        <span style="pointer-events: none" class="regular-font gray-text">${path.summary}</span>
      </div>
    `)}
    </dialog-box>
  `;
}
/* eslint-enable indent */
;// ./src/utils/color-utils.js
/* harmony default export */ const color_utils = ({
  color: {
    inputReverseFg: '#fff',
    inputReverseBg: '#333',
    headerBg: '#444',
    getRgb(hex) {
      if (hex.indexOf('#') === 0) {
        hex = hex.slice(1, 7);
      }
      // convert 3-digit hex to 6-digits.
      if (hex.length === 3 || hex.length === 4) {
        hex = hex[0] + hex[0] + hex[1] + hex[1] + hex[2] + hex[2];
      }
      if (hex.length !== 6) {
        throw new Error('Invalid HEX color.');
      }
      return {
        r: parseInt(hex.slice(0, 2), 16),
        g: parseInt(hex.slice(2, 4), 16),
        b: parseInt(hex.slice(4, 6), 16)
      };
    },
    luminanace(hexColorCode) {
      const rgb = this.getRgb(hexColorCode);
      return rgb.r * 0.299 + rgb.g * 0.587 + rgb.b * 0.114;
    },
    invert(hexColorCode) {
      return this.luminanace(hexColorCode) > 135 ? '#000' : '#fff'; // compare with `>=128`, but giving little more preference to white over black
    },
    opacity(hex, opacity) {
      const rgb = this.getRgb(hex);
      return `rgba(${rgb.r}, ${rgb.g}, ${rgb.b}, ${opacity})`;
    },
    brightness(hex, amt) {
      const rgb = this.getRgb(hex);
      rgb.r += amt;
      rgb.g += amt;
      rgb.b += amt;
      if (rgb.r > 255) rgb.r = 255;else if (rgb.r < 0) rgb.r = 0;
      if (rgb.g > 255) rgb.g = 255;else if (rgb.g < 0) rgb.g = 0;
      if (rgb.b > 255) rgb.b = 255;else if (rgb.b < 0) rgb.b = 0;
      return `#${rgb.r.toString(16).padStart(2, '0')}${rgb.g.toString(16).padStart(2, '0')}${rgb.b.toString(16).padStart(2, '0')}`;
    },
    hasGoodContrast(hexColorCode1, hexColorCode2) {
      const lum1 = this.luminanace(hexColorCode1);
      const lum2 = this.luminanace(hexColorCode2);
      return lum1 - lum2;
    }
  }
});
function isValidHexColor(colorCode) {
  return /^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3}|[A-Fa-f0-9]{8}|[A-Fa-f0-9]{4})$/i.test(colorCode);
}
;// ./src/utils/theme.js


/* Generates an schema object containing type and constraint info */
function setTheme(baseTheme, theme = {}) {
  let newTheme = {};

  // Common Theme colors
  const primaryColor = theme.primaryColor ? theme.primaryColor : baseTheme === 'dark' ? '#f76b39' : '#ff591e';
  const primaryColorInvert = color_utils.color.invert(primaryColor);
  const primaryColorTrans = color_utils.color.opacity(primaryColor, '0.4');

  // Dark and Light Theme colors
  if (baseTheme === 'dark') {
    const bg1 = theme.bg1 ? theme.bg1 : '#2a2b2c';
    const fg1 = theme.fg1 ? theme.fg1 : '#bbb';
    const bg2 = theme.bg2 ? theme.bg2 : color_utils.color.brightness(bg1, 5); // or #383838;
    const bg3 = theme.bg3 ? theme.bg3 : color_utils.color.brightness(bg1, 17); // or #444;
    const lightBg = theme.bg3 ? theme.bg3 : color_utils.color.brightness(bg1, 35);
    const fg2 = theme.fg2 ? theme.fg2 : color_utils.color.brightness(fg1, -15); // or #ababab
    const fg3 = theme.fg3 ? theme.fg3 : color_utils.color.brightness(fg1, -20); // or #aaa
    const lightFg = theme.fg3 ? theme.fg3 : color_utils.color.brightness(fg1, -65); // or #777
    const inlineCodeFg = theme.inlineCodeFg ? theme.inlineCodeFg : '#aaa';
    const selectionBg = fg2;
    const selectionFg = bg2;
    const headerColor = theme.headerColor ? theme.headerColor : color_utils.color.brightness(bg1, 10);
    const navBgColor = theme.navBgColor ? theme.navBgColor : color_utils.color.brightness(bg1, 10);
    const navTextColor = theme.navTextColor ? theme.navTextColor : color_utils.color.opacity(color_utils.color.invert(navBgColor), '0.50');
    const navHoverBgColor = theme.navHoverBgColor ? theme.navHoverBgColor : color_utils.color.brightness(navBgColor, -15);
    const navHoverTextColor = theme.navHoverTextColor ? theme.navHoverTextColor : color_utils.color.invert(navBgColor);
    const navAccentColor = theme.navAccentColor ? theme.navAccentColor : color_utils.color.brightness(primaryColor, 25);
    const navAccentTextColor = theme.navAccentTextColor ? theme.navAccenttextColor : color_utils.color.invert(navAccentColor);
    const overlayBg = 'rgba(80, 80, 80, 0.4)';
    newTheme = {
      bg1,
      bg2,
      bg3,
      lightBg,
      fg1,
      fg2,
      fg3,
      lightFg,
      inlineCodeFg,
      primaryColor,
      primaryColorTrans,
      primaryColorInvert,
      selectionBg,
      selectionFg,
      overlayBg,
      navBgColor,
      navTextColor,
      navHoverBgColor,
      navHoverTextColor,
      navAccentColor,
      navAccentTextColor,
      headerColor,
      headerColorInvert: color_utils.color.invert(headerColor),
      headerColorDarker: color_utils.color.brightness(headerColor, -20),
      headerColorBorder: color_utils.color.brightness(headerColor, 10),
      borderColor: theme.borderColor || color_utils.color.brightness(bg1, 20),
      // #555
      lightBorderColor: theme.lightBorderColor || color_utils.color.brightness(bg1, 15),
      // #444
      codeBorderColor: theme.codeBorderColor || color_utils.color.brightness(bg1, 30),
      inputBg: theme.inputBg || color_utils.color.brightness(bg1, -5),
      // #2f2f2f
      placeHolder: theme.placeHolder || color_utils.color.opacity(fg1, '0.3'),
      hoverColor: theme.hoverColor || color_utils.color.brightness(bg1, -10),
      // #2a2a2a

      red: theme.red ? theme.red : '#F06560',
      lightRed: theme.lightRed ? theme.lightRed : color_utils.color.brightness(bg1, -10),
      // #2a2a2a

      pink: theme.pink ? theme.pink : '#ffb2b2',
      lightPink: theme.lightPink || color_utils.color.brightness(bg1, -10),
      green: theme.green || '#7ec699',
      lightGreen: theme.lightGreen || color_utils.color.brightness(bg1, -10),
      // #2a2a2a

      blue: theme.blue || '#71b7ff',
      lightBlue: theme.lightBlue || color_utils.color.brightness(bg1, -10),
      // #2a2a2a

      orange: theme.orange ? theme.orange : '#f08d49',
      lightOrange: theme.lightOrange || color_utils.color.brightness(bg1, -10),
      // #2a2a2a

      yellow: theme.yellow || '#827717',
      lightYellow: theme.lightYellow || color_utils.color.brightness(bg1, -10),
      // #2a2a2a

      purple: theme.purple || '#786FF1',
      brown: theme.brown || '#D4AC0D',
      codeBg: theme.codeBg || color_utils.color.opacity(color_utils.color.brightness(bg1, -15), 0.7),
      codeFg: theme.codeFg || '#aaa',
      codePropertyColor: theme.codePropertyColor || '#f8c555',
      codeKeywordColor: theme.codeKeywordColor || '#cc99cd',
      codeOperatorColor: theme.codeOperatorColor || '#67cdcc'
    };
  } else {
    const bg1 = theme.bg1 ? theme.bg1 : '#fafbfc';
    const fg1 = theme.fg1 ? theme.fg1 : '#444444';
    const bg2 = theme.bg2 ? theme.bg2 : color_utils.color.brightness(bg1, -5); // or '#fafafa'
    const bg3 = theme.bg3 ? theme.bg3 : color_utils.color.brightness(bg1, -15); // or '#f6f6f6'
    const lightBg = theme.bg3 ? theme.bg3 : color_utils.color.brightness(bg1, -45);
    const fg2 = theme.fg2 ? theme.fg2 : color_utils.color.brightness(fg1, 17); // or '#555'
    const fg3 = theme.fg3 ? theme.fg3 : color_utils.color.brightness(fg1, 30); // or #666
    const lightFg = theme.fg3 ? theme.fg3 : color_utils.color.brightness(fg1, 70); // or #999
    const inlineCodeFg = theme.inlineCodeFg ? theme.inlineCodeFg : 'brown';
    const selectionBg = fg2;
    const selectionFg = bg2;
    const headerColor = theme.headerColor ? theme.headerColor : color_utils.color.brightness(bg1, -180);

    /*
    const navBgColor = theme.navBgColor ? theme.navBgColor : ColorUtils.color.brightness(bg1, -10);
    const navTextColor = theme.navTextColor ? theme.navTextColor : ColorUtils.color.brightness(fg1, 5);
    const navHoverBgColor = theme.navHoverBgColor ? theme.navHoverBgColor : bg1;
    const navHoverTextColor = theme.navHoverTextColor ? theme.navHoverTextColor : primaryColor;
    const navAccentColor = theme.navAccentColor ? theme.navAccentColor : primaryColor;
    */
    const navBgColor = theme.navBgColor ? theme.navBgColor : color_utils.color.brightness(bg1, -200);
    const navTextColor = theme.navTextColor ? theme.navTextColor : color_utils.color.opacity(color_utils.color.invert(navBgColor), '0.65');
    const navHoverBgColor = theme.navHoverBgColor ? theme.navHoverBgColor : color_utils.color.brightness(navBgColor, -15);
    const navHoverTextColor = theme.navHoverTextColor ? theme.navHoverTextColor : color_utils.color.invert(navBgColor);
    const navAccentColor = theme.navAccentColor ? theme.navAccentColor : color_utils.color.brightness(primaryColor, 25);
    const navAccentTextColor = theme.navAccentTextColor ? theme.navAccenttextColor : color_utils.color.invert(navAccentColor);
    const overlayBg = 'rgba(0, 0, 0, 0.4)';
    newTheme = {
      bg1,
      bg2,
      bg3,
      lightBg,
      fg1,
      fg2,
      fg3,
      lightFg,
      inlineCodeFg,
      primaryColor,
      primaryColorTrans,
      primaryColorInvert,
      selectionBg,
      selectionFg,
      overlayBg,
      navBgColor,
      navTextColor,
      navHoverBgColor,
      navHoverTextColor,
      navAccentColor,
      navAccentTextColor,
      headerColor,
      headerColorInvert: color_utils.color.invert(headerColor),
      headerColorDarker: color_utils.color.brightness(headerColor, -20),
      headerColorBorder: color_utils.color.brightness(headerColor, 10),
      borderColor: theme.borderColor || color_utils.color.brightness(bg1, -38),
      lightBorderColor: theme.lightBorderColor || color_utils.color.brightness(bg1, -23),
      codeBorderColor: theme.codeBorderColor || 'transparent',
      inputBg: theme.inputBg || color_utils.color.brightness(bg1, 10),
      // #fff
      placeHolder: theme.placeHolder || color_utils.color.brightness(lightFg, 20),
      // #dedede
      hoverColor: theme.hoverColor || color_utils.color.brightness(bg1, -5),
      // # f1f1f1

      red: theme.red || '#F06560',
      lightRed: theme.lightRed || '#fff0f0',
      pink: theme.pink ? theme.pink : '#990055',
      lightPink: theme.lightPink ? theme.lightPink : '#ffb2b2',
      green: theme.green || '#690',
      lightGreen: theme.lightGreen || '#fbfff0',
      blue: theme.blue || '#47AFE8',
      lightBlue: theme.lightBlue || '#eff8fd',
      orange: theme.orange || '#FF9900',
      lightOrange: theme.lightOrange || '#fff5e6',
      yellow: theme.yellow || '#827717',
      lightYellow: theme.lightYellow || '#fff5cc',
      purple: theme.purple || '#786FF1',
      brown: theme.brown || '#D4AC0D',
      codeBg: theme.codeBg || color_utils.color.opacity(color_utils.color.brightness(bg1, -15), 0.7),
      codeFg: theme.codeFg || '#666',
      codePropertyColor: theme.codePropertyColor || '#905',
      codeKeywordColor: theme.codeKeywordColor || '#07a',
      codeOperatorColor: theme.codeOperatorColor || '#9a6e3a'
    };
  }
  return ke`
  <style>
  *, *:before, *:after { box-sizing: border-box; }
  
  :host {
    /* Common Styles - irrespective of themes */  
    --border-radius: 2px;
    --layout: ${this.layout || 'row'};
    --font-mono: ${this.monoFont || 'Monaco, "Andale Mono", "Roboto Mono", Consolas, monospace'};
    --font-regular: ${this.regularFont || '"Open Sans", Avenir, "Segoe UI", Arial, sans-serif'};
    --scroll-bar-width: 8px;
    --nav-item-padding: ${this.navItemSpacing === 'relaxed' ? '10px 16px 10px 10px' : this.navItemSpacing === 'compact' ? '5px 16px 5px 10px' : '7px 16px 7px 10px'};
    
    --resp-area-height: ${this.responseAreaHeight};
    --font-size-small: ${this.fontSize === 'default' ? '12px' : this.fontSize === 'large' ? '13px' : '14px'};
    --font-size-mono: ${this.fontSize === 'default' ? '13px' : this.fontSize === 'large' ? '14px' : '15px'};
    --font-size-regular: ${this.fontSize === 'default' ? '14px' : this.fontSize === 'large' ? '15px' : '16px'};
    --dialog-z-index: 1000;

    --focus-shadow: 0 0 0 1px transparent, 0 0 0 3px ${newTheme.primaryColorTrans};

    /* Theme specific styles */  
    --bg:${newTheme.bg1};
    --bg2:${newTheme.bg2};
    --bg3:${newTheme.bg3};
    --light-bg:${newTheme.lightBg};
    --fg:${newTheme.fg1};
    --fg2:${newTheme.fg2};
    --fg3:${newTheme.fg3};
    --light-fg:${newTheme.lightFg};
    --selection-bg:${newTheme.selectionBg};
    --selection-fg:${newTheme.selectionFg};
    --overlay-bg:${newTheme.overlayBg};
    
    /* Border Colors */
    --border-color:${newTheme.borderColor};
    --light-border-color:${newTheme.lightBorderColor};
    --code-border-color:${newTheme.codeBorderColor};

    --input-bg:${newTheme.inputBg};
    --placeholder-color:${newTheme.placeHolder};
    --hover-color:${newTheme.hoverColor};
    --red:${newTheme.red};
    --light-red:${newTheme.lightRed};
    --pink:${newTheme.pink};
    --light-pink:${newTheme.lightPink};
    --green:${newTheme.green};
    --light-green:${newTheme.lightGreen};
    --blue:${newTheme.blue};
    --light-blue:${newTheme.lightBlue};
    --orange:${newTheme.orange};
    --light-orange:${newTheme.lightOrange};
    --yellow:${newTheme.yellow};
    --light-yellow:${newTheme.lightYellow};
    --purple:${newTheme.purple};
    --brown:${newTheme.brown};

    /* Header Color */
    --header-bg:${newTheme.headerColor};
    --header-fg:${newTheme.headerColorInvert};
    --header-color-darker:${newTheme.headerColorDarker};
    --header-color-border:${newTheme.headerColorBorder};

    /* Nav Colors */  
    --nav-bg-color:${newTheme.navBgColor};
    --nav-text-color:${newTheme.navTextColor};
    --nav-hover-bg-color:${newTheme.navHoverBgColor};
    --nav-hover-text-color:${newTheme.navHoverTextColor};
    --nav-accent-color:${newTheme.navAccentColor};
    --nav-accent-text-color:${newTheme.navAccentTextColor};

    /* Nav API Method Colors*/
    --nav-get-color:${newTheme.blue};
    --nav-put-color:${newTheme.orange};
    --nav-post-color:${newTheme.green};
    --nav-delete-color:${newTheme.red};
    --nav-head-color:${newTheme.yellow};

    /* Primary Colors */  
    --primary-color:${newTheme.primaryColor};
    --primary-color-invert:${newTheme.primaryColorInvert};
    --primary-color-trans:${newTheme.primaryColorTrans};

    /*Code Syntax Color*/
    --code-bg:${newTheme.codeBg};
    --code-fg:${newTheme.codeFg};
    --inline-code-fg:${newTheme.inlineCodeFg};
    --code-property-color:${newTheme.codePropertyColor};
    --code-keyword-color:${newTheme.codeKeywordColor};
    --code-operator-color:${newTheme.codeOperatorColor};
  }
  </style>`;
}
;// ./src/templates/main-body-template.js


// Templates











function mainBodyTemplate(isMini = false, pathsExpanded = false) {
  if (!this.resolvedSpec) {
    return '';
  }
  if (this.persistAuth === 'true') {
    recoverPersistedApiKeys.call(this);
  }
  const newTheme = {
    bg1: isValidHexColor(this.bgColor) ? this.bgColor : '',
    fg1: isValidHexColor(this.textColor) ? this.textColor : '',
    headerColor: isValidHexColor(this.headerColor) ? this.headerColor : '',
    primaryColor: isValidHexColor(this.primaryColor) ? this.primaryColor : '',
    navBgColor: isValidHexColor(this.navBgColor) ? this.navBgColor : '',
    navTextColor: isValidHexColor(this.navTextColor) ? this.navTextColor : '',
    navHoverBgColor: isValidHexColor(this.navHoverBgColor) ? this.navHoverBgColor : '',
    navHoverTextColor: isValidHexColor(this.navHoverTextColor) ? this.navHoverTextColor : '',
    navAccentColor: isValidHexColor(this.navAccentColor) ? this.navAccentColor : '',
    navAccentTextColor: isValidHexColor(this.navAccentTextColor) ? this.navAccentTextColor : ''
  };
  /* eslint-disable indent */
  if (this.resolvedSpec.specLoadError) {
    return ke`
      ${this.theme === 'dark' ? setTheme.call(this, 'dark', newTheme) : setTheme.call(this, 'light', newTheme)}
      <div id="spec-not-found" style='display:flex; align-items:center; justify-content: center; border:1px dashed var(--border-color); height:42px; padding:5px; font-size:var(--font-size-small); color:var(--red); font-family:var(--font-mono)'> 
        ${this.resolvedSpec.info.description} 
      </div>
    `;
  }
  if (this.resolvedSpec.isSpecLoading) {
    return ke`
      ${this.theme === 'dark' ? setTheme.call(this, 'dark', newTheme) : setTheme.call(this, 'light', newTheme)}
      <main class='main-content regular-font' part='section-main-content'>
        <slot></slot>
        <div class='main-content-inner--${this.renderStyle}-mode'>
          <div class='loader'></div>
        </div>
      </main>
    `;
  }
  return ke`
    ${this.theme === 'dark' ? setTheme.call(this, 'dark', newTheme) : setTheme.call(this, 'light', newTheme)}

    <!-- Header -->
    ${this.showHeader === 'false' ? '' : headerTemplate.call(this)}
    
    <!-- Advanced Search -->
    ${this.allowAdvancedSearch === 'false' ? '' : searchByPropertiesModalTemplate.call(this)}

    <div id='the-main-body' class='body ${this.cssClasses}' dir='${this.pageDirection}' >
      <!-- Side Nav -->
      ${(this.renderStyle === 'read' || this.renderStyle === 'focused') && this.showSideNav === 'true' && this.resolvedSpec ? navbarTemplate.call(this) : ''}

      <!-- Main Content -->
      <main class='main-content regular-font' tabindex='-1' part='section-main-content'>
        <slot></slot>
        <div class='main-content-inner--${this.renderStyle}-mode'>
          ${this.loading === true ? ke`<div class='loader'></div>` : ke`
              ${this.loadFailed === true ? ke`<div style='text-align: center;margin: 16px;'> Unable to load the Spec</div>` : ke`
                  <div class='operations-root' @click='${e => {
    this.handleHref(e);
  }}'>
                  ${this.renderStyle === 'focused' ? ke`${focusedEndpointTemplate.call(this)}` : ke`
                      ${this.showInfo === 'true' ? overviewTemplate.call(this) : ''}
                      ${this.allowServerSelection === 'true' ? serverTemplate.call(this) : ''}
                      ${this.allowAuthentication === 'true' ? securitySchemeTemplate.call(this) : ''}
                      <div id='operations-top' class='observe-me'>
                        <slot name='operations-top'></slot>
                      </div>  
                      ${this.renderStyle === 'read' ? expandedEndpointTemplate.call(this) : endpointTemplate.call(this, isMini, pathsExpanded)}
                    `}
                  </div>
                `}`}
        </div>
        <slot name='footer'></slot>
      </main>
    </div>  
  `;
}
/* eslint-enable indent */
;// ./src/rapidoc.js













// Styles










// import { expandCollapseNavBarTag } from '@/templates/navbar-template';





class RapiDoc extends lit_element_h {
  constructor() {
    super();
    const intersectionObserverOptions = {
      root: this.getRootNode().host,
      rootMargin: '-50px 0px -50px 0px',
      // when the element is visible 100px from bottom
      threshold: 0
    };
    this.showSummaryWhenCollapsed = true;
    // Will activate intersection observer only after spec load and hash analyze
    // to scroll to the proper element without being reverted by observer behavior
    this.isIntersectionObserverActive = false;
    this.intersectionObserver = new IntersectionObserver(entries => {
      this.onIntersect(entries);
    }, intersectionObserverOptions);
  }
  static get properties() {
    return {
      // Heading
      headingText: {
        type: String,
        attribute: 'heading-text'
      },
      gotoPath: {
        type: String,
        attribute: 'goto-path'
      },
      // Spec
      updateRoute: {
        type: String,
        attribute: 'update-route'
      },
      routePrefix: {
        type: String,
        attribute: 'route-prefix'
      },
      specUrl: {
        type: String,
        attribute: 'spec-url'
      },
      sortTags: {
        type: String,
        attribute: 'sort-tags'
      },
      sortSchemas: {
        type: String,
        attribute: 'sort-schemas'
      },
      generateMissingTags: {
        type: String,
        attribute: 'generate-missing-tags'
      },
      sortEndpointsBy: {
        type: String,
        attribute: 'sort-endpoints-by'
      },
      specFile: {
        type: String,
        attribute: false
      },
      // UI Layouts
      layout: {
        type: String
      },
      renderStyle: {
        type: String,
        attribute: 'render-style'
      },
      defaultSchemaTab: {
        type: String,
        attribute: 'default-schema-tab'
      },
      responseAreaHeight: {
        type: String,
        attribute: 'response-area-height'
      },
      fillRequestFieldsWithExample: {
        type: String,
        attribute: 'fill-request-fields-with-example'
      },
      persistAuth: {
        type: String,
        attribute: 'persist-auth'
      },
      onNavTagClick: {
        type: String,
        attribute: 'on-nav-tag-click'
      },
      // Schema Styles
      schemaStyle: {
        type: String,
        attribute: 'schema-style'
      },
      schemaExpandLevel: {
        type: Number,
        attribute: 'schema-expand-level'
      },
      schemaDescriptionExpanded: {
        type: String,
        attribute: 'schema-description-expanded'
      },
      schemaHideReadOnly: {
        type: String,
        attribute: 'schema-hide-read-only'
      },
      schemaHideWriteOnly: {
        type: String,
        attribute: 'schema-hide-write-only'
      },
      // API Server
      apiKeyName: {
        type: String,
        attribute: 'api-key-name'
      },
      apiKeyLocation: {
        type: String,
        attribute: 'api-key-location'
      },
      apiKeyValue: {
        type: String,
        attribute: 'api-key-value'
      },
      defaultApiServerUrl: {
        type: String,
        attribute: 'default-api-server'
      },
      serverUrl: {
        type: String,
        attribute: 'server-url'
      },
      oauthReceiver: {
        type: String,
        attribute: 'oauth-receiver'
      },
      // Hide/Show Sections & Enable Disable actions
      showHeader: {
        type: String,
        attribute: 'show-header'
      },
      showSideNav: {
        type: String,
        attribute: 'show-side-nav'
      },
      showInfo: {
        type: String,
        attribute: 'show-info'
      },
      allowAuthentication: {
        type: String,
        attribute: 'allow-authentication'
      },
      allowTry: {
        type: String,
        attribute: 'allow-try'
      },
      showCurlBeforeTry: {
        type: String,
        attribute: 'show-curl-before-try'
      },
      allowSpecUrlLoad: {
        type: String,
        attribute: 'allow-spec-url-load'
      },
      allowSpecFileLoad: {
        type: String,
        attribute: 'allow-spec-file-load'
      },
      allowSpecFileDownload: {
        type: String,
        attribute: 'allow-spec-file-download'
      },
      allowSearch: {
        type: String,
        attribute: 'allow-search'
      },
      allowAdvancedSearch: {
        type: String,
        attribute: 'allow-advanced-search'
      },
      allowServerSelection: {
        type: String,
        attribute: 'allow-server-selection'
      },
      allowSchemaDescriptionExpandToggle: {
        type: String,
        attribute: 'allow-schema-description-expand-toggle'
      },
      showComponents: {
        type: String,
        attribute: 'show-components'
      },
      pageDirection: {
        type: String,
        attribute: 'page-direction'
      },
      scrollBehavior: {
        type: String,
        attribute: 'scroll-behavior'
      },
      // Main Colors and Font
      theme: {
        type: String
      },
      bgColor: {
        type: String,
        attribute: 'bg-color'
      },
      textColor: {
        type: String,
        attribute: 'text-color'
      },
      headerColor: {
        type: String,
        attribute: 'header-color'
      },
      primaryColor: {
        type: String,
        attribute: 'primary-color'
      },
      fontSize: {
        type: String,
        attribute: 'font-size'
      },
      regularFont: {
        type: String,
        attribute: 'regular-font'
      },
      monoFont: {
        type: String,
        attribute: 'mono-font'
      },
      loadFonts: {
        type: String,
        attribute: 'load-fonts'
      },
      cssFile: {
        type: String,
        attribute: 'css-file'
      },
      cssClasses: {
        type: String,
        attribute: 'css-classes'
      },
      // Nav Bar Colors
      navBgColor: {
        type: String,
        attribute: 'nav-bg-color'
      },
      navTextColor: {
        type: String,
        attribute: 'nav-text-color'
      },
      navHoverBgColor: {
        type: String,
        attribute: 'nav-hover-bg-color'
      },
      navHoverTextColor: {
        type: String,
        attribute: 'nav-hover-text-color'
      },
      navAccentColor: {
        type: String,
        attribute: 'nav-accent-color'
      },
      navAccentTextColor: {
        type: String,
        attribute: 'nav-accent-text-color'
      },
      navActiveItemMarker: {
        type: String,
        attribute: 'nav-active-item-marker'
      },
      navItemSpacing: {
        type: String,
        attribute: 'nav-item-spacing'
      },
      showMethodInNavBar: {
        type: String,
        attribute: 'show-method-in-nav-bar'
      },
      usePathInNavBar: {
        type: String,
        attribute: 'use-path-in-nav-bar'
      },
      infoDescriptionHeadingsInNavBar: {
        type: String,
        attribute: 'info-description-headings-in-navbar'
      },
      // Fetch Options
      fetchCredentials: {
        type: String,
        attribute: 'fetch-credentials'
      },
      // Filters
      matchPaths: {
        type: String,
        attribute: 'match-paths'
      },
      matchType: {
        type: String,
        attribute: 'match-type'
      },
      removeEndpointsWithBadgeLabelAs: {
        type: String,
        attribute: 'remove-endpoints-with-badge-label-as'
      },
      // Internal Properties
      loading: {
        type: Boolean
      },
      // indicates spec is being loaded
      focusedElementId: {
        type: String
      },
      // updating the focusedElementId will automatically render appropriate section in focused mode
      showAdvancedSearchDialog: {
        type: Boolean
      },
      advancedSearchMatches: {
        type: Object
      },
      searchVal: {
        type: String
      }
    };
  }
  static get styles() {
    return [font_styles, input_styles, flex_styles, table_styles, endpoint_styles, prism_styles, tab_styles, nav_styles, info_styles, i`
      :host {
        all: initial;
        display:flex;
        flex-direction: column;
        min-width:360px;
        width:100%;
        height:100%;
        margin:0;
        padding:0;
        overflow: hidden;
        letter-spacing:normal;
        color:var(--fg);
        background-color:var(--bg);
        font-family:var(--font-regular);
        container-type: inline-size;
      }
      :where(button, input[type="checkbox"], [tabindex="0"]):focus-visible { box-shadow: var(--focus-shadow); }
      :where(input[type="text"], input[type="password"], select, textarea):focus-visible { border-color: var(--primary-color); }
      .body {
        display:flex;
        height:100%;
        width:100%;
        overflow:hidden;
      }
      .main-content { 
        margin:0;
        padding: 0; 
        display:block;
        flex:1;
        height:100%;
        overflow-y: auto;
        overflow-x: hidden;
        scrollbar-width: thin;
        scrollbar-color: var(--border-color) transparent;
      }

      .main-content-inner--view-mode {
        padding: 0 8px;
      }
      .main-content::-webkit-scrollbar {
        width: 8px;
        height: 8px;
      }
      .main-content::-webkit-scrollbar-track {
        background:transparent;
      }
      .main-content::-webkit-scrollbar-thumb {
        background-color: var(--border-color);
      }

      .section-gap.section-tag {
        border-bottom:1px solid var(--border-color);
      }
      .section-gap,
      .section-gap--focused-mode,
      .section-gap--read-mode { 
        padding: 0px 4px; 
      }
      .section-tag-header {
        position:relative;
        cursor: n-resize;
        padding: 12px 0;
      }
      .collapsed .section-tag-header:hover {
        cursor: s-resize;
      }

      .section-tag-header:hover {
        background-image: linear-gradient(to right, rgba(0,0,0,0), var(--border-color), rgba(0,0,0,0));
      }

      .section-tag-header:hover::after {
        position:absolute;
        margin-left:-24px;
        font-size:20px;
        top: calc(50% - 14px);
        color:var(--primary-color);
        content: '⬆'; 
      }

      .collapsed .section-tag-header::after {
        position:absolute;
        margin-left:-24px;
        font-size:20px;
        top: calc(50% - 14px);
        color: var(--border-color);
        content: '⬇'; 
      }
      .collapsed .section-tag-header:hover::after {
        color:var(--primary-color);
      }

      .collapsed .section-tag-body {
        display:none;
      }

      .logo {
        height:36px;
        width:36px;
        margin-left:5px; 
      }
      .only-large-screen-flex,
      .only-large-screen {
        display:none;
      }
      .tag.title {
        text-transform: uppercase;
      }
      .main-header {
        background-color:var(--header-bg);
        color:var(--header-fg);
        width:100%;
      }
      .header-title {
        font-size:calc(var(--font-size-regular) + 8px); 
        padding:0 8px;
      }
      input.header-input{
        background:var(--header-color-darker);
        color:var(--header-fg);
        border:1px solid var(--header-color-border);
        flex:1; 
        padding-right:24px;
        border-radius:3px;
      }
      input.header-input::placeholder {
        opacity:0.4;
      }
      .loader {
        margin: 16px auto 16px auto; 
        border: 4px solid var(--bg3);
        border-radius: 50%;
        border-top: 4px solid var(--primary-color);
        width: 36px;
        height: 36px;
        animation: spin 2s linear infinite;
      }
      .expanded-endpoint-body { 
        position: relative;
        padding: 6px 0px; 
      }
      .expanded-endpoint-body .tag-description {
        background: var(--code-bg);
        border-radius: var(--border-radius);
        transition: max-height .2s ease-out;
      }
      .expanded-endpoint-body .tag-icon {
        transition: transform .2s ease-out;
      }
      .expanded-endpoint-body .tag-icon.expanded {
        transform: rotate(180deg);
      }
      .divider { 
        border-top: 2px solid var(--border-color);
        margin: 24px 0;
        width:100%;
      }

      .tooltip {
        cursor:pointer;
        border: 1px solid var(--border-color);
        border-left-width: 4px;
        margin-left:2px;
      }
      .tooltip a {
        color: var(--fg2);
        text-decoration: none;
      }
      .tooltip-text {
        color: var(--fg2);
        max-width: 400px;
        position: absolute;
        z-index:1;
        background-color: var(--bg2);
        visibility: hidden;

        overflow-wrap: break-word;
      }
      .tooltip:hover {
        color: var(--primary-color);
        border-color: var(--primary-color);
      }
      .tooltip:hover a:hover {
        color: var(--primary-color);
      }

      .tooltip:hover .tooltip-text {
        visibility: visible;
      }

      @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
      }

      .nav-method { font-weight: bold; margin-right: 4px; font-size: calc(var(--font-size-small) - 2px); white-space: nowrap; }
      .nav-method.false { display: none; }

      .nav-method.as-colored-text.get { color:var(--nav-get-color); }
      .nav-method.as-colored-text.put { color:var(--nav-put-color); }
      .nav-method.as-colored-text.post { color:var(--nav-post-color); }
      .nav-method.as-colored-text.delete { color:var(--nav-delete-color); }
      .nav-method.as-colored-text.head, .nav-method.as-colored-text.patch, .nav-method.as-colored-text.options { color:var(--nav-head-color); }
      
      .nav-method.as-colored-block {
        padding: 1px 4px;
        min-width: 30px;
        border-radius: 4px 0 0 4px;
        color: #000;
      }
      .colored-block .nav-method.as-colored-block {
        outline: 1px solid;
      }

      .nav-method.as-colored-block.get { background-color: var(--blue); }
      .nav-method.as-colored-block.put { background-color: var(--orange); }
      .nav-method.as-colored-block.post { background-color: var(--green); }
      .nav-method.as-colored-block.delete { background-color: var(--red); }
      .nav-method.as-colored-block.head, .nav-method.as-colored-block.patch , .nav-method.as-colored-block.options { 
        background-color: var(--yellow); 
      }

      @container (min-width: 768px) {
        .nav-bar {
          width: 260px;
          display:flex;
        }
        .only-large-screen {
          display:block;
        }
        .only-large-screen-flex {
          display:flex;
        }
        .section-gap { 
          padding: 0 0 0 24px; 
        }
        .section-gap--focused-mode {
          padding: 24px 8px; 
        }
        .section-gap--read-mode { 
          padding: 24px 8px; 
        }
        .endpoint-body {
          position: relative;
          padding:36px 0 48px 0;
        }
      }

      @container (min-width: 1024px) {
        .nav-bar {
          width: ${r(this.fontSize === 'default' ? '300px' : this.fontSize === 'large' ? '315px' : '330px')};
          display:flex;
        }
        .section-gap--focused-mode { 
          padding: 12px 80px 12px 80px; 
        }
        .section-gap--read-mode { 
          padding: 24px 80px 12px 80px; 
        }
      }`, custom_styles];
  }

  // Startup
  connectedCallback() {
    super.connectedCallback();
    const parent = this.parentElement;
    if (parent) {
      if (parent.offsetWidth === 0 && parent.style.width === '') {
        parent.style.width = '100vw';
      }
      if (parent.offsetHeight === 0 && parent.style.height === '') {
        parent.style.height = '100vh';
      }
      if (parent.tagName === 'BODY') {
        if (!parent.style.marginTop) {
          parent.style.marginTop = '0';
        }
        if (!parent.style.marginRight) {
          parent.style.marginRight = '0';
        }
        if (!parent.style.marginBottom) {
          parent.style.marginBottom = '0';
        }
        if (!parent.style.marginLeft) {
          parent.style.marginLeft = '0';
        }
      }
    }
    if (this.loadFonts !== 'false') {
      const fontDescriptor = {
        family: 'Open Sans',
        style: 'normal',
        weight: '300',
        unicodeRange: 'U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD'
      };
      const fontWeight300 = new FontFace('Open Sans', "url(https://fonts.gstatic.com/s/opensans/v18/mem5YaGs126MiZpBA-UN_r8OUuhpKKSTjw.woff2) format('woff2')", fontDescriptor);
      fontDescriptor.weight = '600';
      const fontWeight600 = new FontFace('Open Sans', "url(https://fonts.gstatic.com/s/opensans/v18/mem5YaGs126MiZpBA-UNirkOUuhpKKSTjw.woff2) format('woff2')", fontDescriptor);
      fontWeight300.load().then(font => {
        document.fonts.add(font);
      });
      fontWeight600.load().then(font => {
        document.fonts.add(font);
      });
    }
    if (!this.layout || !'row, column,'.includes(`${this.layout},`)) {
      this.layout = 'row';
    }
    if (!this.renderStyle || !'read, view, focused,'.includes(`${this.renderStyle},`)) {
      this.renderStyle = 'focused';
    }
    if (!this.schemaStyle || !'tree, table,'.includes(`${this.schemaStyle},`)) {
      this.schemaStyle = 'tree';
    }
    if (!this.theme || !'light, dark,'.includes(`${this.theme},`)) {
      this.theme = window.matchMedia && window.matchMedia('(prefers-color-scheme: light)').matches ? 'light' : 'dark';
    }
    if (!this.defaultSchemaTab || !'example, schema, model,'.includes(`${this.defaultSchemaTab},`)) {
      this.defaultSchemaTab = 'example';
    } else if (this.defaultSchemaTab === 'model') {
      this.defaultSchemaTab = 'schema';
    }
    if (!this.schemaExpandLevel || this.schemaExpandLevel < 1) {
      this.schemaExpandLevel = 99999;
    }
    if (!this.schemaDescriptionExpanded || !'true, false,'.includes(`${this.schemaDescriptionExpanded},`)) {
      this.schemaDescriptionExpanded = 'false';
    }
    if (!this.schemaHideReadOnly || !'default, never,'.includes(`${this.schemaHideReadOnly},`)) {
      this.schemaHideReadOnly = 'default';
    }
    if (!this.schemaHideWriteOnly || !'default, never,'.includes(`${this.schemaHideWriteOnly},`)) {
      this.schemaHideWriteOnly = 'default';
    }
    if (!this.fillRequestFieldsWithExample || !'true, false,'.includes(`${this.fillRequestFieldsWithExample},`)) {
      this.fillRequestFieldsWithExample = 'true';
    }
    if (!this.persistAuth || !'true, false,'.includes(`${this.persistAuth},`)) {
      this.persistAuth = 'false';
    }
    if (!this.responseAreaHeight) {
      this.responseAreaHeight = '400px';
    }
    if (!this.allowSearch || !'true, false,'.includes(`${this.allowSearch},`)) {
      this.allowSearch = 'true';
    }
    if (!this.allowAdvancedSearch || !'true, false,'.includes(`${this.allowAdvancedSearch},`)) {
      this.allowAdvancedSearch = 'true';
    }
    if (!this.allowTry || !'true, false,'.includes(`${this.allowTry},`)) {
      this.allowTry = 'true';
    }
    if (!this.apiKeyValue) {
      this.apiKeyValue = '-';
    }
    if (!this.apiKeyLocation) {
      this.apiKeyLocation = 'header';
    }
    if (!this.apiKeyName) {
      this.apiKeyName = '';
    }
    if (!this.oauthReceiver) {
      this.oauthReceiver = 'oauth-receiver.html';
    }
    if (!this.updateRoute || !'true, false,'.includes(`${this.updateRoute},`)) {
      this.updateRoute = 'true';
    }
    if (!this.routePrefix) {
      this.routePrefix = '#';
    }
    if (!this.sortTags || !'true, false,'.includes(`${this.sortTags},`)) {
      this.sortTags = 'false';
    }
    if (!this.sortSchemas || !'true, false,'.includes(`${this.sortSchemas},`)) {
      this.sortSchemas = 'false';
    }
    if (!this.generateMissingTags || !'true, false,'.includes(`${this.generateMissingTags},`)) {
      this.generateMissingTags = 'false';
    }
    if (!this.sortEndpointsBy || !'method, path, summary, none,'.includes(`${this.sortEndpointsBy},`)) {
      this.sortEndpointsBy = 'path';
    }
    if (!this.onNavTagClick || !'expand-collapse, show-description,'.includes(`${this.onNavTagClick},`)) {
      this.onNavTagClick = 'expand-collapse';
    }
    if (!this.navItemSpacing || !'compact, relaxed, default,'.includes(`${this.navItemSpacing},`)) {
      this.navItemSpacing = 'default';
    }
    if (!this.showMethodInNavBar || !'false, as-plain-text, as-colored-text, as-colored-block,'.includes(`${this.showMethodInNavBar},`)) {
      this.showMethodInNavBar = 'false';
    }
    if (!this.usePathInNavBar || !'true, false,'.includes(`${this.usePathInNavBar},`)) {
      this.usePathInNavBar = 'false';
    }
    if (!this.navActiveItemMarker || !'left-bar, colored-block'.includes(`${this.navActiveItemMarker},`)) {
      this.navActiveItemMarker = 'left-bar';
    }
    if (!this.fontSize || !'default, large, largest,'.includes(`${this.fontSize},`)) {
      this.fontSize = 'default';
    }
    if (!this.showInfo || !'true, false,'.includes(`${this.showInfo},`)) {
      this.showInfo = 'true';
    }
    if (!this.allowServerSelection || !'true, false,'.includes(`${this.allowServerSelection},`)) {
      this.allowServerSelection = 'true';
    }
    if (!this.allowAuthentication || !'true, false,'.includes(`${this.allowAuthentication},`)) {
      this.allowAuthentication = 'true';
    }
    if (!this.allowSchemaDescriptionExpandToggle || !'true, false,'.includes(`${this.allowSchemaDescriptionExpandToggle},`)) {
      this.allowSchemaDescriptionExpandToggle = 'true';
    }
    if (!this.showSideNav || !'true false'.includes(this.showSideNav)) {
      this.showSideNav = 'true';
    }
    if (!this.showComponents || !'true false'.includes(this.showComponents)) {
      this.showComponents = 'false';
    }
    if (!this.infoDescriptionHeadingsInNavBar || !'true, false,'.includes(`${this.infoDescriptionHeadingsInNavBar},`)) {
      this.infoDescriptionHeadingsInNavBar = 'false';
    }
    if (!this.fetchCredentials || !'omit, same-origin, include,'.includes(`${this.fetchCredentials},`)) {
      this.fetchCredentials = '';
    }
    if (!this.scrollBehavior || !'smooth, auto,'.includes(`${this.scrollBehavior},`)) {
      this.scrollBehavior = 'auto';
    }
    if (!this.matchType || !'includes regex'.includes(this.matchType)) {
      this.matchType = 'includes';
    }
    if (!this.matchPaths) {
      this.matchPaths = '';
    }
    if (!this.removeEndpointsWithBadgeLabelAs) {
      this.removeEndpointsWithBadgeLabelAs = '';
    }
    if (!this.showAdvancedSearchDialog) {
      this.showAdvancedSearchDialog = false;
    }
    if (!this.cssFile) {
      this.cssFile = null;
    }
    if (!this.cssClasses) {
      this.cssClasses = '';
    }
    marked.setOptions({
      highlight: (code, lang) => {
        if ((prism_default()).languages[lang]) {
          return prism_default().highlight(code, (prism_default()).languages[lang], lang);
        }
        return code;
      }
    });
    window.addEventListener('hashchange', () => {
      this.scrollToPath(this.getElementIDFromURL());
    }, true);
  }

  // Cleanup
  disconnectedCallback() {
    if (this.intersectionObserver) {
      this.intersectionObserver.disconnect();
    }
    super.disconnectedCallback();
  }
  infoDescriptionHeadingRenderer() {
    const renderer = new marked.Renderer();
    renderer.heading = (text, level, raw, slugger) => `<h${level} class="observe-me" id="${slugger.slug(raw)}">${text}</h${level}>`;
    return renderer;
  }
  render() {
    // return render(mainBodyTemplate(this), this.shadowRoot, { eventContext: this });
    const cssLinkEl = document.querySelector(`link[href*="${this.cssFile}"]`);
    // adding custom style for RapiDoc
    if (cssLinkEl) {
      this.shadowRoot.appendChild(cssLinkEl.cloneNode());
    }
    return mainBodyTemplate.call(this);
  }
  observeExpandedContent() {
    // Main Container
    const observeOverviewEls = this.shadowRoot.querySelectorAll('.observe-me');
    observeOverviewEls.forEach(targetEl => {
      this.intersectionObserver.observe(targetEl);
    });
  }
  attributeChangedCallback(name, oldVal, newVal) {
    if (name === 'spec-url') {
      if (oldVal !== newVal) {
        // put it at the end of event-loop to load all the attributes
        window.setTimeout(async () => {
          await this.loadSpec(newVal);
          // If goto-path is provided and no location-hash is present then try to scroll there
          if (this.gotoPath && !window.location.hash) {
            this.scrollToPath(this.gotoPath);
          }
        }, 0);
      }
    }
    if (name === 'match-paths' || name === 'match-type' || name === 'remove-endpoints-with-badge-label-as') {
      if (oldVal !== newVal) {
        window.setTimeout(async () => {
          await this.loadSpec(this.specUrl);
        }, 0);
      }
    }
    if (name === 'render-style') {
      if (newVal === 'read') {
        window.setTimeout(() => {
          this.observeExpandedContent();
        }, 100);
      } else {
        this.intersectionObserver.disconnect();
      }
    }
    if (name === 'api-key-name' || name === 'api-key-location' || name === 'api-key-value') {
      let updateSelectedApiKey = false;
      let apiKeyName = '';
      let apiKeyLocation = '';
      let apiKeyValue = '';
      if (name === 'api-key-name') {
        if (this.getAttribute('api-key-location') && this.getAttribute('api-key-value')) {
          apiKeyName = newVal;
          apiKeyLocation = this.getAttribute('api-key-location');
          apiKeyValue = this.getAttribute('api-key-value');
          updateSelectedApiKey = true;
        }
      } else if (name === 'api-key-location') {
        if (this.getAttribute('api-key-name') && this.getAttribute('api-key-value')) {
          apiKeyLocation = newVal;
          apiKeyName = this.getAttribute('api-key-name');
          apiKeyValue = this.getAttribute('api-key-value');
          updateSelectedApiKey = true;
        }
      } else if (name === 'api-key-value') {
        if (this.getAttribute('api-key-name') && this.getAttribute('api-key-location')) {
          apiKeyValue = newVal;
          apiKeyLocation = this.getAttribute('api-key-location');
          apiKeyName = this.getAttribute('api-key-name');
          updateSelectedApiKey = true;
        }
      }
      if (updateSelectedApiKey) {
        if (this.resolvedSpec) {
          const rapiDocApiKey = this.resolvedSpec.securitySchemes.find(v => v.securitySchemeId === rapidocApiKey);
          if (!rapiDocApiKey) {
            this.resolvedSpec.securitySchemes.push({
              securitySchemeId: rapidocApiKey,
              description: 'api-key provided in rapidoc element attributes',
              type: 'apiKey',
              name: apiKeyName,
              in: apiKeyLocation,
              value: apiKeyValue,
              finalKeyValue: apiKeyValue
            });
          } else {
            rapiDocApiKey.name = apiKeyName;
            rapiDocApiKey.in = apiKeyLocation;
            rapiDocApiKey.value = apiKeyValue;
            rapiDocApiKey.finalKeyValue = apiKeyValue;
          }
          this.requestUpdate();
        }
      }
    }
    super.attributeChangedCallback(name, oldVal, newVal);
  }
  onSpecUrlChange() {
    this.setAttribute('spec-url', this.shadowRoot.getElementById('spec-url').value);
  }
  onSpecFileChange(e) {
    this.setAttribute('spec-file', this.shadowRoot.getElementById('spec-file').value);
    const specFile = e.target.files[0];
    const reader = new FileReader();
    reader.onload = () => {
      try {
        const specObj = JSON.parse(reader.result);
        this.loadSpec(specObj);
        this.shadowRoot.getElementById('spec-url').value = '';
      } catch {
        console.error('RapiDoc: Unable to read or parse json'); // eslint-disable-line no-console
      }
    };
    // Read the Text file
    reader.readAsText(specFile);
  }
  onFileLoadClick() {
    this.shadowRoot.getElementById('spec-file').click();
  }
  onSearchChange(e) {
    // this.matchPaths = e.target.value;
    this.searchVal = e.target.value;
    this.resolvedSpec.tags.forEach(tag => tag.paths.filter(path => {
      if (this.searchVal) {
        if (getMatchedPaths(this.searchVal, path, tag.name)) {
          tag.expanded = true;
        }
      }
    }));
    this.resolvedSpec.components.forEach(component => component.subComponents.filter(v => {
      v.expanded = false;
      if (getMatchedComponents(this.searchVal, v)) {
        v.expanded = true;
      }
    }));
    this.requestUpdate();
  }
  onClearSearch() {
    const searchEl = this.shadowRoot.getElementById('nav-bar-search');
    searchEl.value = '';
    this.searchVal = '';
    this.resolvedSpec.components.forEach(component => component.subComponents.filter(v => {
      v.expanded = true;
    }));
  }
  onShowSearchModalClicked() {
    this.showAdvancedSearchDialog = true;
  }

  // Event Handler on Dialog-Box is opened
  async onOpenSearchDialog(e) {
    // Set focus to text input
    const inputEl = e.detail.querySelector('input');
    await sleep(0);
    if (inputEl) {
      inputEl.focus();
    }
  }

  // Public Method
  async loadSpec(specUrl) {
    if (!specUrl) {
      return;
    }
    this.searchVal = '';
    try {
      this.resolvedSpec = {
        specLoadError: false,
        isSpecLoading: true,
        tags: []
      };
      this.loading = true;
      this.loadFailed = false;
      const spec = await ProcessSpec.call(this, specUrl, this.generateMissingTags === 'true', this.sortTags === 'true', this.sortSchemas === 'true', this.getAttribute('sort-endpoints-by'), this.getAttribute('api-key-name'), this.getAttribute('api-key-location'), this.getAttribute('api-key-value'), this.getAttribute('server-url'), this.matchPaths, this.matchType, this.removeEndpointsWithBadgeLabelAs);
      this.loading = false;
      this.afterSpecParsedAndValidated(spec);
    } catch (err) {
      this.loading = false;
      this.loadFailed = true;
      this.resolvedSpec = null;
      console.error(`RapiDoc: Unable to resolve the API spec..  ${err.message}`); // eslint-disable-line no-console
    }
  }
  async afterSpecParsedAndValidated(spec) {
    this.resolvedSpec = spec;
    this.selectedServer = undefined;
    if (this.defaultApiServerUrl) {
      if (this.defaultApiServerUrl === this.serverUrl) {
        this.selectedServer = {
          url: this.serverUrl,
          computedUrl: this.serverUrl
        };
      } else if (this.resolvedSpec.servers) {
        this.selectedServer = this.resolvedSpec.servers.find(v => v.url === this.defaultApiServerUrl);
      }
    }
    if (!this.selectedServer) {
      if (this.resolvedSpec.servers) {
        this.selectedServer = this.resolvedSpec.servers[0]; // eslint-disable-line prefer-destructuring
      }
    }
    this.requestUpdate();
    // eslint-disable-next-line no-await-in-loop
    while (!(await this.updateComplete));
    const specLoadedEvent = new CustomEvent('spec-loaded', {
      detail: spec
    });
    this.dispatchEvent(specLoadedEvent);

    // Initiate IntersectionObserver and put it at the end of event loop, to allow loading all the child elements (must for larger specs)
    this.intersectionObserver.disconnect();
    if (this.renderStyle === 'read') {
      await sleep(100);
      this.observeExpandedContent(); // This will auto-highlight the selected nav-item in read-mode
    }
    this.isIntersectionObserverActive = true;

    // On first time Spec load, try to navigate to location hash if provided
    const elementId = this.getElementIDFromURL();
    if (elementId) {
      if (this.renderStyle === 'view') {
        this.expandAndGotoOperation(elementId, true, true);
      } else {
        this.scrollToPath(elementId);
      }
    } else if (this.renderStyle === 'focused') {
      // If goto-path is provided and no location-hash is present then try to scroll to default element
      if (!this.gotoPath) {
        var _this$resolvedSpec$ta;
        const defaultElementId = this.showInfo ? 'overview' : (_this$resolvedSpec$ta = this.resolvedSpec.tags[0]) === null || _this$resolvedSpec$ta === void 0 ? void 0 : _this$resolvedSpec$ta.paths[0];
        this.scrollToPath(defaultElementId);
      }
    }
  }

  /**
   * Return the URL from where is served the RapiDoc component, removing any hash and route prefix
   */
  getComponentBaseURL() {
    const {
      href
    } = window.location;

    // Remove end of string # or /
    const cleanRouterPrefix = this.routePrefix.replace(/(#|\/)$/, '');
    if (!cleanRouterPrefix) {
      return href.split('#')[0];
    }
    const indexOfRoutePrefix = href.lastIndexOf(cleanRouterPrefix);
    if (indexOfRoutePrefix === -1) {
      return href;
    }
    return href.slice(0, indexOfRoutePrefix);
  }

  /**
   * From the URL return the ID of the element whether it is in the hash or if used a router prefix without a hash
   */
  getElementIDFromURL() {
    const baseURL = this.getComponentBaseURL();
    const elementId = window.location.href.replace(baseURL + this.routePrefix, '');
    return elementId;
  }
  replaceHistoryState(hashId) {
    const baseURL = this.getComponentBaseURL();
    window.history.replaceState(null, null, `${baseURL}${this.routePrefix || '#'}${hashId}`);
  }
  expandAndGotoOperation(elementId, scrollToElement = true) {
    if (!this.resolvedSpec) {
      return;
    }
    // Expand full operation and tag
    let isExpandingNeeded = true;
    const tmpElementId = elementId.indexOf('#') === -1 ? elementId : elementId.substring(1);
    if (tmpElementId.startsWith('overview') || tmpElementId === 'servers' || tmpElementId === 'auth') {
      isExpandingNeeded = false;
    } else {
      for (let i = 0; i < ((_this$resolvedSpec$ta2 = this.resolvedSpec.tags) === null || _this$resolvedSpec$ta2 === void 0 ? void 0 : _this$resolvedSpec$ta2.length); i++) {
        var _this$resolvedSpec$ta2, _tag$paths;
        const tag = this.resolvedSpec.tags[i];
        const path = (_tag$paths = tag.paths) === null || _tag$paths === void 0 ? void 0 : _tag$paths.find(p => p.elementId === elementId);
        if (path) {
          if (path.expanded && tag.expanded) {
            isExpandingNeeded = false;
          } else {
            path.expanded = true;
            tag.expanded = true;
          }
        }
      }
    }
    if (scrollToElement) {
      // requestUpdate() and delay required, else we cant find element
      if (isExpandingNeeded) {
        this.requestUpdate();
      }
      window.setTimeout(() => {
        const gotoEl = this.shadowRoot.getElementById(tmpElementId);
        if (gotoEl) {
          gotoEl.scrollIntoView({
            behavior: this.scrollBehavior,
            block: 'start'
          });
          if (this.updateRoute === 'true') {
            this.replaceHistoryState(tmpElementId);
          }
        }
      }, isExpandingNeeded ? 150 : 0);
    }
  }
  isValidTopId(id) {
    return id.startsWith('overview') || id === 'servers' || id === 'auth';
  }
  isValidPathId(id) {
    var _this$resolvedSpec2;
    if (id === 'overview' && this.showInfo) {
      return true;
    }
    if (id === 'servers' && this.allowServerSelection) {
      return true;
    }
    if (id === 'auth' && this.allowAuthentication) {
      return true;
    }
    if (id.startsWith('tag--')) {
      var _this$resolvedSpec;
      return (_this$resolvedSpec = this.resolvedSpec) === null || _this$resolvedSpec === void 0 || (_this$resolvedSpec = _this$resolvedSpec.tags) === null || _this$resolvedSpec === void 0 ? void 0 : _this$resolvedSpec.find(tag => tag.elementId === id);
    }
    return (_this$resolvedSpec2 = this.resolvedSpec) === null || _this$resolvedSpec2 === void 0 || (_this$resolvedSpec2 = _this$resolvedSpec2.tags) === null || _this$resolvedSpec2 === void 0 ? void 0 : _this$resolvedSpec2.find(tag => tag.paths.find(path => path.elementId === id));
  }
  onIntersect(entries) {
    if (this.isIntersectionObserverActive === false) {
      return;
    }
    entries.forEach(entry => {
      if (entry.isIntersecting && entry.intersectionRatio > 0) {
        const oldNavEl = this.shadowRoot.querySelector('.nav-bar-tag.active, .nav-bar-path.active, .nav-bar-info.active, .nav-bar-h1.active, .nav-bar-h2.active, .operations.active');
        const newNavEl = this.shadowRoot.getElementById(`link-${entry.target.id}`);

        // Add active class in the new element
        if (newNavEl) {
          if (this.updateRoute === 'true') {
            this.replaceHistoryState(entry.target.id);
          }
          newNavEl.scrollIntoView({
            behavior: this.scrollBehavior,
            block: 'center'
          });
          newNavEl.classList.add('active');
          newNavEl.part.add('section-navbar-active-item');
        }

        // Remove active class from previous element
        // if it is different from the new one (edge case on loading in read render style)
        if (oldNavEl && oldNavEl !== newNavEl) {
          oldNavEl.classList.remove('active');
          oldNavEl.part.remove('section-navbar-active-item');
        }
      }
    });
  }

  // Called by anchor tags created using markdown
  handleHref(e) {
    if (e.target.tagName.toLowerCase() === 'a') {
      if (e.target.getAttribute('href').startsWith('#')) {
        const gotoEl = this.shadowRoot.getElementById(e.target.getAttribute('href').replace('#', ''));
        if (gotoEl) {
          gotoEl.scrollIntoView({
            behavior: this.scrollBehavior,
            block: 'start'
          });
        }
      }
    }
  }

  /**
   * Called by
   *  - onClick of Navigation Bar
   *  - onClick of Advanced Search items
   *
   * Functionality:
   *  1. First deactivate IntersectionObserver
   *  2. Scroll to the element
   *  3. Activate IntersectionObserver (after little delay)
   *
  */
  async scrollToEventTarget(event, scrollNavItemToView = true) {
    if (!(event.type === 'click' || event.type === 'keyup' && event.keyCode === 13)) {
      return;
    }
    const navEl = event.target;
    if (!navEl.dataset.contentId) {
      return;
    }
    this.isIntersectionObserverActive = false;
    if (this.renderStyle === 'focused') {
      const requestEl = this.shadowRoot.querySelector('api-request');
      if (requestEl) {
        requestEl.beforeNavigationFocusedMode();
      }
    }
    this.scrollToPath(navEl.dataset.contentId, true, scrollNavItemToView);
    setTimeout(() => {
      this.isIntersectionObserverActive = true;
    }, 300);
  }

  // Public Method (scrolls to a given path and highlights the left-nav selection)
  async scrollToPath(elementId, expandPath = true, scrollNavItemToView = true) {
    if (this.renderStyle === 'focused') {
      // for focused mode update this.focusedElementId to update the rendering, else it wont find the needed html elements
      // focusedElementId will get validated in the template
      this.focusedElementId = elementId;
      await sleep(0);
    }
    if (this.renderStyle === 'view') {
      this.expandAndGotoOperation(elementId, expandPath, true);
    } else {
      let isValidElementId = false;
      const contentEl = this.shadowRoot.getElementById(elementId);
      if (contentEl) {
        isValidElementId = true;
        contentEl.scrollIntoView({
          behavior: this.scrollBehavior,
          block: 'start'
        });
      } else {
        isValidElementId = false;
      }
      if (isValidElementId) {
        // for focused style it is important to reset request-body-selection and response selection which maintains the state for in case of multiple req-body or multiple response mime-type
        if (this.renderStyle === 'focused') {
          const requestEl = this.shadowRoot.querySelector('api-request');
          if (requestEl) {
            requestEl.afterNavigationFocusedMode();
          }
          const responseEl = this.shadowRoot.querySelector('api-response');
          if (responseEl) {
            responseEl.resetSelection();
          }
        }

        // Update Location Hash
        if (this.updateRoute === 'true') {
          this.replaceHistoryState(elementId);
        }

        // Update NavBar View and Styles
        const newNavEl = this.shadowRoot.getElementById(`link-${elementId}`);
        if (newNavEl) {
          if (scrollNavItemToView) {
            newNavEl.scrollIntoView({
              behavior: this.scrollBehavior,
              block: 'center'
            });
          }
          await sleep(0);
          const oldNavEl = this.shadowRoot.querySelector('.nav-bar-tag.active, .nav-bar-path.active, .nav-bar-info.active, .nav-bar-h1.active, .nav-bar-h2.active, .operations.active');
          if (oldNavEl) {
            oldNavEl.classList.remove('active');
            oldNavEl.part.remove('active');
            oldNavEl.part.remove('section-navbar-active-item');
          }
          newNavEl.classList.add('active'); // must add the class after scrolling
          newNavEl.part.add('section-navbar-active-item');
          // this.requestUpdate();
        }
      }
    }
  }

  // Public Method - to update security-scheme of type http
  setHttpUserNameAndPassword(securitySchemeId, username, password) {
    return applyApiKey.call(this, securitySchemeId, username, password);
  }

  // Public Method - to update security-scheme of type apiKey or OAuth
  setApiKey(securitySchemeId, apiKeyValue) {
    return applyApiKey.call(this, securitySchemeId, '', '', apiKeyValue);
  }

  // Public Method
  removeAllSecurityKeys() {
    return onClearAllApiKeys.call(this);
  }

  // Public Method
  setApiServer(apiServerUrl) {
    // return apiServerUrl;
    return setApiServer.call(this, apiServerUrl);
  }

  // Event handler for Advanced Search text-inputs and checkboxes
  onAdvancedSearch(ev, delay) {
    const eventTargetEl = ev.target;
    clearTimeout(this.timeoutId);
    this.timeoutId = setTimeout(() => {
      let searchInputEl;
      if (eventTargetEl.type === 'text') {
        searchInputEl = eventTargetEl;
      } else {
        searchInputEl = eventTargetEl.closest('.advanced-search-options').querySelector('input[type=text]');
      }
      const searchOptions = [...eventTargetEl.closest('.advanced-search-options').querySelectorAll('input:checked')].map(v => v.id);
      this.advancedSearchMatches = advancedSearch(searchInputEl.value, this.resolvedSpec.tags, searchOptions);
    }, delay);
  }
}
customElements.define('rapi-doc', RapiDoc);
;// ./src/rapidoc-mini.js













// Styles














class RapiDocMini extends lit_element_h {
  constructor() {
    super();
    this.isMini = true;
    this.updateRoute = 'false';
    this.renderStyle = 'view';
    this.showHeader = 'false';
    this.allowAdvancedSearch = 'false';
  }
  static get properties() {
    return {
      // Spec
      specUrl: {
        type: String,
        attribute: 'spec-url'
      },
      sortEndpointsBy: {
        type: String,
        attribute: 'sort-endpoints-by'
      },
      // UI Layouts
      layout: {
        type: String
      },
      pathsExpanded: {
        type: String,
        attribute: 'paths-expanded'
      },
      defaultSchemaTab: {
        type: String,
        attribute: 'default-schema-tab'
      },
      responseAreaHeight: {
        type: String,
        attribute: 'response-area-height'
      },
      showSummaryWhenCollapsed: {
        type: String,
        attribute: 'show-summary-when-collapsed'
      },
      fillRequestFieldsWithExample: {
        type: String,
        attribute: 'fill-request-fields-with-example'
      },
      persistAuth: {
        type: String,
        attribute: 'persist-auth'
      },
      // Schema Styles
      schemaStyle: {
        type: String,
        attribute: 'schema-style'
      },
      schemaExpandLevel: {
        type: Number,
        attribute: 'schema-expand-level'
      },
      schemaDescriptionExpanded: {
        type: String,
        attribute: 'schema-description-expanded'
      },
      // API Server
      apiKeyName: {
        type: String,
        attribute: 'api-key-name'
      },
      apiKeyLocation: {
        type: String,
        attribute: 'api-key-location'
      },
      apiKeyValue: {
        type: String,
        attribute: 'api-key-value'
      },
      defaultApiServerUrl: {
        type: String,
        attribute: 'default-api-server'
      },
      serverUrl: {
        type: String,
        attribute: 'server-url'
      },
      oauthReceiver: {
        type: String,
        attribute: 'oauth-receiver'
      },
      allowTry: {
        type: String,
        attribute: 'allow-try'
      },
      showCurlBeforeTry: {
        type: String,
        attribute: 'show-curl-before-try'
      },
      // Main Colors and Font
      theme: {
        type: String
      },
      bgColor: {
        type: String,
        attribute: 'bg-color'
      },
      textColor: {
        type: String,
        attribute: 'text-color'
      },
      primaryColor: {
        type: String,
        attribute: 'primary-color'
      },
      fontSize: {
        type: String,
        attribute: 'font-size'
      },
      regularFont: {
        type: String,
        attribute: 'regular-font'
      },
      monoFont: {
        type: String,
        attribute: 'mono-font'
      },
      loadFonts: {
        type: String,
        attribute: 'load-fonts'
      },
      // Fetch Options
      fetchCredentials: {
        type: String,
        attribute: 'fetch-credentials'
      },
      // Filters
      matchPaths: {
        type: String,
        attribute: 'match-paths'
      },
      matchType: {
        type: String,
        attribute: 'match-type'
      },
      removeEndpointsWithBadgeLabelAs: {
        type: String,
        attribute: 'remove-endpoints-with-badge-label-as'
      },
      // Internal Properties
      loading: {
        type: Boolean
      } // indicates spec is being loaded
    };
  }
  static get styles() {
    return [font_styles, input_styles, flex_styles, table_styles, endpoint_styles, prism_styles, tab_styles, nav_styles, info_styles, i`
      :host {
        all: initial;
        display:flex;
        flex-direction: column;
        min-width:360px;
        width:100%;
        height:100%;
        margin:0;
        padding:0;
        overflow: hidden;
        letter-spacing:normal;
        color:var(--fg);
        background-color:var(--bg);
        font-family:var(--font-regular);
        container-type: inline-size;
      }

      @container (min-width: 768px) {
        .only-large-screen {
          display:block;
        }
        .only-large-screen-flex {
          display:flex;
        }
      }`];
  }

  // Startup
  connectedCallback() {
    super.connectedCallback();
    if (this.loadFonts !== 'false') {
      const fontDescriptor = {
        family: 'Open Sans',
        style: 'normal',
        weight: '300',
        unicodeRange: 'U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD'
      };
      const fontWeight300 = new FontFace('Open Sans', "url(https://fonts.gstatic.com/s/opensans/v18/mem5YaGs126MiZpBA-UN_r8OUuhpKKSTjw.woff2) format('woff2')", fontDescriptor);
      fontDescriptor.weight = '600';
      const fontWeight600 = new FontFace('Open Sans', "url(https://fonts.gstatic.com/s/opensans/v18/mem5YaGs126MiZpBA-UNirkOUuhpKKSTjw.woff2) format('woff2')", fontDescriptor);
      fontWeight300.load().then(font => {
        document.fonts.add(font);
      });
      fontWeight600.load().then(font => {
        document.fonts.add(font);
      });
    }
    if (!this.showSummaryWhenCollapsed || !'true, false,'.includes(`${this.showSummaryWhenCollapsed},`)) {
      this.showSummaryWhenCollapsed = 'true';
    }
    if (!this.layout || !'row, column,'.includes(`${this.layout},`)) {
      this.layout = 'row';
    }
    if (!this.schemaStyle || !'tree, table,'.includes(`${this.schemaStyle},`)) {
      this.schemaStyle = 'tree';
    }
    if (!this.theme || !'light, dark,'.includes(`${this.theme},`)) {
      this.theme = window.matchMedia && window.matchMedia('(prefers-color-scheme: light)').matches ? 'light' : 'dark';
    }
    if (!this.defaultSchemaTab || !'example, schema, model,'.includes(`${this.defaultSchemaTab},`)) {
      this.defaultSchemaTab = 'example';
    } else if (this.defaultSchemaTab === 'model') {
      this.defaultSchemaTab = 'schema';
    }
    this.pathsExpanded = this.pathsExpanded === 'true';
    if (!this.schemaExpandLevel || this.schemaExpandLevel < 1) {
      this.schemaExpandLevel = 99999;
    }
    if (!this.schemaDescriptionExpanded || !'true, false,'.includes(`${this.schemaDescriptionExpanded},`)) {
      this.schemaDescriptionExpanded = 'false';
    }
    if (!this.fillRequestFieldsWithExample || !'true, false,'.includes(`${this.fillRequestFieldsWithExample},`)) {
      this.fillRequestFieldsWithExample = 'true';
    }
    if (!this.persistAuth || !'true, false,'.includes(`${this.persistAuth},`)) {
      this.persistAuth = 'false';
    }
    if (!this.responseAreaHeight) {
      this.responseAreaHeight = '300px';
    }
    if (!this.allowTry || !'true, false,'.includes(`${this.allowTry},`)) {
      this.allowTry = 'true';
    }
    if (!this.apiKeyValue) {
      this.apiKeyValue = '-';
    }
    if (!this.apiKeyLocation) {
      this.apiKeyLocation = 'header';
    }
    if (!this.apiKeyName) {
      this.apiKeyName = '';
    }
    if (!this.oauthReceiver) {
      this.oauthReceiver = 'oauth-receiver.html';
    }
    if (!this.sortTags || !'true, false,'.includes(`${this.sortTags},`)) {
      this.sortTags = 'false';
    }
    if (!this.sortEndpointsBy || !'method, path, summary,'.includes(`${this.sortEndpointsBy},`)) {
      this.sortEndpointsBy = 'path';
    }
    if (!this.fontSize || !'default, large, largest,'.includes(`${this.fontSize},`)) {
      this.fontSize = 'default';
    }
    if (!this.matchType || !'includes regex'.includes(this.matchType)) {
      this.matchType = 'includes';
    }
    if (!this.matchPaths) {
      this.matchPaths = '';
    }
    if (!this.removeEndpointsWithBadgeLabelAs) {
      this.removeEndpointsWithBadgeLabelAs = '';
    }
    if (!this.allowSchemaDescriptionExpandToggle || !'true, false,'.includes(`${this.allowSchemaDescriptionExpandToggle},`)) {
      this.allowSchemaDescriptionExpandToggle = 'true';
    }
    if (!this.fetchCredentials || !'omit, same-origin, include,'.includes(`${this.fetchCredentials},`)) {
      this.fetchCredentials = '';
    }
    marked.setOptions({
      highlight: (code, lang) => {
        if ((prism_default()).languages[lang]) {
          return prism_default().highlight(code, (prism_default()).languages[lang], lang);
        }
        return code;
      }
    });
  }
  render() {
    return mainBodyTemplate.call(this, true, this.pathsExpanded);
  }
  attributeChangedCallback(name, oldVal, newVal) {
    if (name === 'spec-url') {
      if (oldVal !== newVal) {
        // put it at the end of event-loop to load all the attributes
        window.setTimeout(async () => {
          await this.loadSpec(newVal);
        }, 0);
      }
    }
    if (name === 'match-paths' || name === 'match-type' || name === 'remove-endpoints-with-badge-label-as') {
      if (oldVal !== newVal) {
        window.setTimeout(async () => {
          await this.loadSpec(this.specUrl);
        }, 0);
      }
    }
    if (name === 'api-key-name' || name === 'api-key-location' || name === 'api-key-value') {
      let updateSelectedApiKey = false;
      let apiKeyName = '';
      let apiKeyLocation = '';
      let apiKeyValue = '';
      if (name === 'api-key-name') {
        if (this.getAttribute('api-key-location') && this.getAttribute('api-key-value')) {
          apiKeyName = newVal;
          apiKeyLocation = this.getAttribute('api-key-location');
          apiKeyValue = this.getAttribute('api-key-value');
          updateSelectedApiKey = true;
        }
      } else if (name === 'api-key-location') {
        if (this.getAttribute('api-key-name') && this.getAttribute('api-key-value')) {
          apiKeyLocation = newVal;
          apiKeyName = this.getAttribute('api-key-name');
          apiKeyValue = this.getAttribute('api-key-value');
          updateSelectedApiKey = true;
        }
      } else if (name === 'api-key-value') {
        if (this.getAttribute('api-key-name') && this.getAttribute('api-key-location')) {
          apiKeyValue = newVal;
          apiKeyLocation = this.getAttribute('api-key-location');
          apiKeyName = this.getAttribute('api-key-name');
          updateSelectedApiKey = true;
        }
      }
      if (updateSelectedApiKey) {
        if (this.resolvedSpec) {
          const rapiDocApiKey = this.resolvedSpec.securitySchemes.find(v => v.securitySchemeId === rapidocApiKey);
          if (!rapiDocApiKey) {
            this.resolvedSpec.securitySchemes.push({
              apiKeyId: rapidocApiKey,
              description: 'api-key provided in rapidoc element attributes',
              type: 'apiKey',
              name: apiKeyName,
              in: apiKeyLocation,
              value: apiKeyValue,
              finalKeyValue: apiKeyValue
            });
          } else {
            rapiDocApiKey.name = apiKeyName;
            rapiDocApiKey.in = apiKeyLocation;
            rapiDocApiKey.value = apiKeyValue;
            rapiDocApiKey.finalKeyValue = apiKeyValue;
          }
          this.requestUpdate();
        }
      }
    }
    super.attributeChangedCallback(name, oldVal, newVal);
  }
  onSpecUrlChange() {
    this.setAttribute('spec-url', this.shadowRoot.getElementById('spec-url').value);
  }

  // Public Method
  async loadSpec(specUrl) {
    if (!specUrl) {
      return;
    }
    try {
      this.resolvedSpec = {
        specLoadError: false,
        isSpecLoading: true,
        tags: []
      };
      this.loading = true;
      this.loadFailed = false;
      this.requestUpdate();
      const spec = await ProcessSpec.call(this, specUrl, this.generateMissingTags === 'true', this.sortTags === 'true', this.sortSchemas === 'true', this.getAttribute('sort-endpoints-by'), this.getAttribute('api-key-name'), this.getAttribute('api-key-location'), this.getAttribute('api-key-value'), this.getAttribute('server-url'), this.matchPaths, this.matchType, this.removeEndpointsWithBadgeLabelAs);
      this.loading = false;
      this.afterSpecParsedAndValidated(spec);
    } catch (err) {
      this.loading = false;
      this.loadFailed = true;
      this.resolvedSpec = null;
      console.error(`RapiDoc: Unable to resolve the API spec..  ${err.message}`); // eslint-disable-line no-console
    }
  }

  // Public Method - to update security-scheme of type http
  setHttpUserNameAndPassword(securitySchemeId, username, password) {
    return applyApiKey.call(this, securitySchemeId, username, password);
  }

  // Public Method - to update security-scheme of type apiKey or OAuth
  setApiKey(securitySchemeId, apiKeyValue) {
    return applyApiKey.call(this, securitySchemeId, '', '', apiKeyValue);
  }

  // Public Method
  removeAllSecurityKeys() {
    return onClearAllApiKeys.call(this);
  }

  // Public Method
  setApiServer(apiServerUrl) {
    // return apiServerUrl;
    return setApiServer.call(this, apiServerUrl);
  }
  async afterSpecParsedAndValidated(spec) {
    this.resolvedSpec = spec;
    this.selectedServer = undefined;
    if (this.defaultApiServerUrl) {
      if (this.defaultApiServerUrl === this.serverUrl) {
        this.selectedServer = {
          url: this.serverUrl,
          computedUrl: this.serverUrl
        };
      } else if (this.resolvedSpec.servers) {
        this.selectedServer = this.resolvedSpec.servers.find(v => v.url === this.defaultApiServerUrl);
      }
    }
    if (!this.selectedServer) {
      if (this.resolvedSpec.servers) {
        this.selectedServer = this.resolvedSpec.servers[0]; // eslint-disable-line prefer-destructuring
      }
    }
    this.requestUpdate();
    // eslint-disable-next-line no-await-in-loop
    while (!(await this.updateComplete));
    const specLoadedEvent = new CustomEvent('spec-loaded', {
      detail: spec
    });
    this.dispatchEvent(specLoadedEvent);
  }

  // Called by anchor tags created using markdown
  handleHref(e) {
    if (e.target.tagName.toLowerCase() === 'a') {
      if (e.target.getAttribute('href').startsWith('#')) {
        const gotoEl = this.shadowRoot.getElementById(e.target.getAttribute('href').replace('#', ''));
        if (gotoEl) {
          gotoEl.scrollIntoView({
            behavior: 'auto',
            block: 'start'
          });
        }
      }
    }
  }
}
customElements.define('rapi-doc-mini', RapiDocMini);
;// ./src/oauth-receiver.js
class OauthReceiver extends HTMLElement {
  connectedCallback() {
    this.receiveAuthParms();
    window.addEventListener('storage', e => this.receiveStorage(e), true);
  }

  /**
   * Read OAuth2 parameters and sends them off
   * to the window opener through `window.postMessage`.
   */
  receiveAuthParms() {
    let authData = {};
    if (document.location.search) {
      // Applies to authorizationCode flow
      const params = new URLSearchParams(document.location.search);
      const code = params.get('code');
      const error = params.get('error');
      const state = params.get('state');
      authData = {
        code,
        error,
        state,
        responseType: 'code'
      };
    } else if (window.location.hash) {
      // Applies to Implicit flow
      const token_type = this.parseQueryString(window.location.hash.substring(1), 'token_type'); // eslint-disable-line camelcase
      const access_token = this.parseQueryString(window.location.hash.substring(1), 'access_token'); // eslint-disable-line camelcase
      authData = {
        token_type,
        access_token,
        responseType: 'token'
      }; // eslint-disable-line camelcase
    }
    if (window.opener) {
      window.opener.postMessage(authData, this.target);
      return;
    }
    sessionStorage.setItem('rapidoc-oauth-data', JSON.stringify(authData)); // Fallback to session storage if window.opener dont exist
  }
  relayAuthParams(e) {
    if (window.parent) {
      if (e.key === 'rapidoc-oauth-data') {
        const authData = JSON.parse(e.newValue);
        window.parent.postMessage(authData, this.target);
      }
    }
  }
  parseQueryString(queryString, key) {
    const vars = queryString.split('&');
    for (let i = 0; i < vars.length; i++) {
      const pair = vars[i].split('=');
      if (decodeURIComponent(pair[0]) === key) {
        return decodeURIComponent(pair[1]);
      }
    }
  }
}
customElements.define('oauth-receiver', OauthReceiver);
;// ./src/templates/json-schema-viewer-template.js

 // eslint-disable-line import/extensions


// Templates








/* eslint-disable indent */
// Json Schema Nav Template
function jsonSchemaNavTemplate() {
  return ke`
  <nav class='nav-bar' part="section-navbar">
    <slot name="nav-logo" class="logo"></slot>
    <div style="display:flex;line-height:22px; padding:8px">
      <input id="nav-bar-search" 
        part = "textbox textbox-nav-filter"
        style = "width:100%; height: 26px; padding-right:20px; color:var(--nav-hover-text-color); border-color:var(--nav-accent-color); background-color:var(--nav-hover-bg-color)" 
        type = "text"
        placeholder = "Filter" 
        @change = "${this.onSearchChange}"  
        spellcheck = "false" 
      >
      <div style="margin: 6px 5px 0 -24px; font-size:var(--font-size-regular); cursor:pointer;">&#x21a9;</div>
    </div>
    <nav style="flex:1" class='nav-scroll' part="section-navbar-scroll">
      ${this.resolvedSpec.schemaAndExamples.map(v => ke`
        <div class='nav-bar-path' data-content-id='${v.elementId}' id='link-${v.elementId}'
          @click = '${e => {
    this.scrollToEventTarget(e, false);
  }}'
        > 
          ${v.name}
        </div>`)}
    </nav>  
  </nav>
  `;
}

// Json Schema Body Template
function jsonSchemaBodyTemplate() {
  return ke`
    ${this.showInfo === 'true' ? overviewTemplate.call(this) : ''}
    <div style="font-size:var(--font-size-regular);">
    ${this.resolvedSpec.schemaAndExamples.map(jSchemaBody => {
    var _examplesObj$;
    const examplesObj = generateExample(jSchemaBody.schema, 'json', standardizeExample(jSchemaBody.examples), standardizeExample(jSchemaBody.example), true, false, 'json', true);
    jSchemaBody.selectedExample = (_examplesObj$ = examplesObj[0]) === null || _examplesObj$ === void 0 ? void 0 : _examplesObj$.exampleId;
    return ke`
        <section id='${jSchemaBody.elementId}' class='json-schema-and-example regular-font' style="display:flex; flex-direction: column; border:1px solid var(--border-color); margin-bottom:32px; border-top: 5px solid var(--border-color)">
          <div style="padding:16px; border-bottom: 1px solid var(--border-color)">
            <div style="font-size:var(--font-size-small); font-weight:bold">${jSchemaBody.name}</div>
            <span class="json-schema-description m-markdown ">${unsafe_html_ae(marked(jSchemaBody.description || ''))}</span>
          </div>  
          <div style="display:flex; flex-direction: row; gap:16px;">
            <div class="json-schema-def" style="flex:1; padding:16px 0 16px 16px; ">
              <schema-tree
                .data = "${schemaInObjectNotation(jSchemaBody.schema, {})}"
                schema-expand-level = "${this.schemaExpandLevel}"
                schema-description-expanded = "${this.schemaDescriptionExpanded}"
                allow-schema-description-expand-toggle = "${this.allowSchemaDescriptionExpandToggle}"
                schema-hide-read-only = "false"
                schema-hide-write-only = "false"
              > </schema-tree>
            </div>
            <div class="json-schema-example-panel" style="width:400px; background-color: var(--input-bg); padding:16px 0 16px 16px; border-left: 1px dashed var(--border-color);">
              ${examplesObj.length > 1 ? ke`<select style="min-width:100px; max-width:100%" @change='${e => this.onSelectExample(e, jSchemaBody)}'>
                    ${examplesObj.map(v => ke`
                      <option value="${v.exampleId}" ?selected=${v.exampleId === jSchemaBody.selectedExample}> 
                        ${v.exampleSummary.length > 80 ? v.exampleId : v.exampleSummary}
                      </option>`)}
                  </select>` : ke`<div style="font-size: var(--font-size-small);font-weight:700; margin:5px 0"> ${examplesObj[0].exampleSummary}</div>`}
              ${examplesObj.map(v => ke`
                <json-tree 
                  .data = "${v.exampleValue}"
                  data-example = "${v.exampleId}"
                  class = "example"
                  style = "margin-top:16px; display: ${v.exampleId === jSchemaBody.selectedExample ? 'flex' : 'none'}"
                ></json-tree>`)}
            </div>
          </div>
        </section>`;
  })}
    </div>
  `;
}
/* eslint-enable indent */

// Json Schema Root Template
function jsonSchemaViewerTemplate(isMini = false) {
  // export default function jsonSchemaViewerTemplate(isMini = false, pathsExpanded = false) {
  if (!this.resolvedSpec) {
    return '';
  }
  const newTheme = {
    bg1: isValidHexColor(this.bgColor) ? this.bgColor : '',
    fg1: isValidHexColor(this.textColor) ? this.textColor : '',
    headerColor: isValidHexColor(this.headerColor) ? this.headerColor : '',
    primaryColor: isValidHexColor(this.primaryColor) ? this.primaryColor : '',
    navBgColor: isValidHexColor(this.navBgColor) ? this.navBgColor : '',
    navTextColor: isValidHexColor(this.navTextColor) ? this.navTextColor : '',
    navHoverBgColor: isValidHexColor(this.navHoverBgColor) ? this.navHoverBgColor : '',
    navHoverTextColor: isValidHexColor(this.navHoverTextColor) ? this.navHoverTextColor : '',
    navAccentColor: isValidHexColor(this.navAccentColor) ? this.navAccentColor : '',
    navAccenttextColor: isValidHexColor(this.navAccentTextColor) ? this.navAccentTextColor : ''
  };
  /* eslint-disable indent */
  if (this.resolvedSpec.specLoadError) {
    if (isMini) {
      return ke`
        ${this.theme === 'dark' ? setTheme.call(this, 'dark', newTheme) : setTheme.call(this, 'light', newTheme)}
        <div style="display:flex; align-items:center; border:1px dashed var(--border-color); height:42px; padding:5px; font-size:var(--font-size-small); color:var(--red); font-family:var(--font-mono)"> ${this.resolvedSpec.info.description} </div>
      `;
    }
    return ke`
      ${this.theme === 'dark' ? setTheme.call(this, 'dark', newTheme) : setTheme.call(this, 'light', newTheme)}
      <!-- Header -->
      ${headerTemplate.call(this)}
      <h1> Header </h1>
      <main class="main-content regular-font" part="section-main-content">
        <slot></slot>
        <div style="margin:24px; text-align: center;">
          <h1 style="color: var(--red)"> ${this.resolvedSpec.info.title} </h1>
          <div style="font-family:var(--font-mono)"> ${this.resolvedSpec.info.description} </div>
        </div>
      </main>  
    `;
  }
  if (this.resolvedSpec.isSpecLoading) {
    return ke`
      ${this.theme === 'dark' ? setTheme.call(this, 'dark', newTheme) : setTheme.call(this, 'light', newTheme)}
      <main class="main-content regular-font" part="section-main-content">
        <slot></slot>
        <div class="main-content-inner--${this.renderStyle}-mode">
          <div class="loader"></div>
        </div>
      </main>  
    `;
  }
  return ke`
    ${this.theme === 'dark' ? setTheme.call(this, 'dark', newTheme) : setTheme.call(this, 'light', newTheme)}

    <!-- Header -->
    ${this.showHeader === 'false' ? '' : headerTemplate.call(this)}
    
    <div id='the-main-body' class="body ${this.cssClasses}" dir= ${this.pageDirection}>

      <!-- Side Nav -->
      ${jsonSchemaNavTemplate.call(this)}

      <!-- Main Content -->
      <main class="main-content regular-font" part="section-main-content">
        <slot></slot>
        <div class="main-content-inner--${this.renderStyle}-mode">
          ${this.loading === true ? ke`<div class="loader"></div>` : ke`
              ${this.loadFailed === true ? ke`<div style="text-align: center;margin: 16px;"> Unable to load the Spec</div>` : ke`
                  <div class="operations-root" @click="${e => {
    this.handleHref(e);
  }}">
                    ${jsonSchemaBodyTemplate.call(this)}
                  </div>
                `}`}
        </div>
        <slot name="footer"></slot>
      </main>
    </div>  
  `;
}
/* eslint-enable indent */
;// ./src/json-schema-viewer.js













// Styles











class JsonSchemaViewer extends lit_element_h {
  constructor() {
    super();
    this.isMini = false;
    this.updateRoute = 'false';
    this.renderStyle = 'focused';
    this.showHeader = 'true';
    this.allowAdvancedSearch = 'false';
    this.selectedExampleForEachSchema = {};
  }
  static get properties() {
    return {
      // Spec
      specUrl: {
        type: String,
        attribute: 'spec-url'
      },
      // Schema Styles
      schemaStyle: {
        type: String,
        attribute: 'schema-style'
      },
      schemaExpandLevel: {
        type: Number,
        attribute: 'schema-expand-level'
      },
      schemaDescriptionExpanded: {
        type: String,
        attribute: 'schema-description-expanded'
      },
      allowSchemaDescriptionExpandToggle: {
        type: String,
        attribute: 'allow-schema-description-expand-toggle'
      },
      // Hide/show Sections
      showHeader: {
        type: String,
        attribute: 'show-header'
      },
      showSideNav: {
        type: String,
        attribute: 'show-side-nav'
      },
      showInfo: {
        type: String,
        attribute: 'show-info'
      },
      // Allow or restrict features
      allowSpecUrlLoad: {
        type: String,
        attribute: 'allow-spec-url-load'
      },
      allowSpecFileLoad: {
        type: String,
        attribute: 'allow-spec-file-load'
      },
      allowSpecFileDownload: {
        type: String,
        attribute: 'allow-spec-file-download'
      },
      allowSearch: {
        type: String,
        attribute: 'allow-search'
      },
      // Main Colors and Font
      theme: {
        type: String
      },
      bgColor: {
        type: String,
        attribute: 'bg-color'
      },
      textColor: {
        type: String,
        attribute: 'text-color'
      },
      primaryColor: {
        type: String,
        attribute: 'primary-color'
      },
      fontSize: {
        type: String,
        attribute: 'font-size'
      },
      regularFont: {
        type: String,
        attribute: 'regular-font'
      },
      monoFont: {
        type: String,
        attribute: 'mono-font'
      },
      loadFonts: {
        type: String,
        attribute: 'load-fonts'
      },
      // Internal Properties
      loading: {
        type: Boolean
      } // indicates spec is being loaded
    };
  }
  static get styles() {
    return [font_styles, input_styles, flex_styles, table_styles, endpoint_styles, prism_styles, tab_styles, nav_styles, info_styles, i`
      :host {
        all: initial;
        display:flex;
        flex-direction: column;
        min-width:360px;
        width:100%;
        height:100%;
        margin:0;
        padding:0;
        overflow: hidden;
        letter-spacing:normal;
        color:var(--fg);
        background-color:var(--bg);
        font-family:var(--font-regular);
        container-type: inline-size;
      }
      .body {
        display:flex;
        height:100%;
        width:100%;
        overflow:hidden;
      }
      .nav-bar {
        width: 230px;
        display:flex;
      }

      .main-content { 
        margin:0;
        padding: 16px; 
        display:block;
        flex:1;
        height:100%;
        overflow-y: auto;
        overflow-x: hidden;
        scrollbar-width: thin;
        scrollbar-color: var(--border-color) transparent;
      }
      .main-content-inner--view-mode {
        padding: 0 8px;
      }
      .main-content::-webkit-scrollbar {
        width: 8px;
        height: 8px;
      }
      .main-content::-webkit-scrollbar-track {
        background:transparent;
      }
      .main-content::-webkit-scrollbar-thumb {
        background-color: var(--border-color);
      }
      .main-header {
        background-color:var(--header-bg);
        color:var(--header-fg);
        width:100%;
      }
      .header-title {
        font-size:calc(var(--font-size-regular) + 8px); 
        padding:0 8px;
      }
      input.header-input{
        background:var(--header-color-darker);
        color:var(--header-fg);
        border:1px solid var(--header-color-border);
        flex:1; 
        padding-right:24px;
        border-radius:3px;
      }
      input.header-input::placeholder {
        opacity:0.4;
      }
      .loader {
        margin: 16px auto 16px auto; 
        border: 4px solid var(--bg3);
        border-radius: 50%;
        border-top: 4px solid var(--primary-color);
        width: 36px;
        height: 36px;
        animation: spin 2s linear infinite;
      }
      @container (min-width: 768px) {
        .only-large-screen{
          display:block;
        }
        .only-large-screen-flex {
          display:flex;
        }
      }`];
  }

  // Startup
  connectedCallback() {
    super.connectedCallback();
    const parent = this.parentElement;
    if (parent) {
      if (parent.offsetWidth === 0 && parent.style.width === '') {
        parent.style.width = '100vw';
      }
      if (parent.offsetHeight === 0 && parent.style.height === '') {
        parent.style.height = '100vh';
      }
      if (parent.tagName === 'BODY') {
        if (!parent.style.marginTop) {
          parent.style.marginTop = '0';
        }
        if (!parent.style.marginRight) {
          parent.style.marginRight = '0';
        }
        if (!parent.style.marginBottom) {
          parent.style.marginBottom = '0';
        }
        if (!parent.style.marginLeft) {
          parent.style.marginLeft = '0';
        }
      }
    }
    if (this.loadFonts !== 'false') {
      const fontDescriptor = {
        family: 'Open Sans',
        style: 'normal',
        weight: '300',
        unicodeRange: 'U+0000-00FF, U+0131, U+0152-0153, U+02BB-02BC, U+02C6, U+02DA, U+02DC, U+2000-206F, U+2074, U+20AC, U+2122, U+2191, U+2193, U+2212, U+2215, U+FEFF, U+FFFD'
      };
      const fontWeight300 = new FontFace('Open Sans', "url(https://fonts.gstatic.com/s/opensans/v18/mem5YaGs126MiZpBA-UN_r8OUuhpKKSTjw.woff2) format('woff2')", fontDescriptor);
      fontDescriptor.weight = '600';
      const fontWeight600 = new FontFace('Open Sans', "url(https://fonts.gstatic.com/s/opensans/v18/mem5YaGs126MiZpBA-UNirkOUuhpKKSTjw.woff2) format('woff2')", fontDescriptor);
      fontWeight300.load().then(font => {
        document.fonts.add(font);
      });
      fontWeight600.load().then(font => {
        document.fonts.add(font);
      });
    }
    this.renderStyle = 'focused';
    this.pathsExpanded = this.pathsExpanded === 'true';
    if (!this.showInfo || !'true, false,'.includes(`${this.showInfo},`)) {
      this.showInfo = 'true';
    }
    if (!this.showSideNav || !'true false'.includes(this.showSideNav)) {
      this.showSideNav = 'true';
    }
    if (!this.showHeader || !'true, false,'.includes(`${this.showHeader},`)) {
      this.showHeader = 'true';
    }
    if (!this.schemaStyle || !'tree, table,'.includes(`${this.schemaStyle},`)) {
      this.schemaStyle = 'tree';
    }
    if (!this.theme || !'light, dark,'.includes(`${this.theme},`)) {
      this.theme = window.matchMedia && window.matchMedia('(prefers-color-scheme: light)').matches ? 'light' : 'dark';
    }
    if (!this.allowSearch || !'true, false,'.includes(`${this.allowSearch},`)) {
      this.allowSearch = 'true';
    }
    if (!this.schemaExpandLevel || this.schemaExpandLevel < 1) {
      this.schemaExpandLevel = 99999;
    }
    if (!this.schemaDescriptionExpanded || !'true, false,'.includes(`${this.schemaDescriptionExpanded},`)) {
      this.schemaDescriptionExpanded = 'false';
    }
    if (!this.fontSize || !'default, large, largest,'.includes(`${this.fontSize},`)) {
      this.fontSize = 'default';
    }
    if (!this.matchType || !'includes regex'.includes(this.matchType)) {
      this.matchType = 'includes';
    }
    if (!this.allowSchemaDescriptionExpandToggle || !'true, false,'.includes(`${this.allowSchemaDescriptionExpandToggle},`)) {
      this.allowSchemaDescriptionExpandToggle = 'true';
    }
    marked.setOptions({
      highlight: (code, lang) => {
        if ((prism_default()).languages[lang]) {
          return prism_default().highlight(code, (prism_default()).languages[lang], lang);
        }
        return code;
      }
    });
  }
  render() {
    return jsonSchemaViewerTemplate.call(this, true, false, false, this.pathsExpanded);
  }
  attributeChangedCallback(name, oldVal, newVal) {
    if (name === 'spec-url') {
      if (oldVal !== newVal) {
        // put it at the end of event-loop to load all the attributes
        window.setTimeout(async () => {
          await this.loadSpec(newVal);
        }, 0);
      }
    }
    super.attributeChangedCallback(name, oldVal, newVal);
  }
  onSpecUrlChange() {
    this.setAttribute('spec-url', this.shadowRoot.getElementById('spec-url').value);
  }
  onSearchChange(e) {
    // Todo: Filter Search
    this.matchPaths = e.target.value;
  }

  // Public Method
  async loadSpec(specUrl) {
    if (!specUrl) {
      return;
    }
    try {
      this.resolvedSpec = {
        specLoadError: false,
        isSpecLoading: true,
        tags: []
      };
      this.loading = true;
      this.loadFailed = false;
      this.requestUpdate();
      const spec = await ProcessSpec.call(this, specUrl, this.generateMissingTags === 'true', this.sortTags === 'true', this.sortSchemas === 'true', this.getAttribute('sort-endpoints-by'), this.getAttribute('match-paths'), this.getAttribute('match-type'), this.getAttribute('remove-endpoints-with-badge-label-as'));
      this.loading = false;
      this.afterSpecParsedAndValidated(spec);
    } catch (err) {
      this.loading = false;
      this.loadFailed = true;
      this.resolvedSpec = null;
      console.error(`RapiDoc: Unable to resolve the API spec..  ${err.message}`); // eslint-disable-line no-console
    }
  }
  async afterSpecParsedAndValidated(spec) {
    this.resolvedSpec = spec;
    const specLoadedEvent = new CustomEvent('spec-loaded', {
      detail: spec
    });
    this.dispatchEvent(specLoadedEvent);
  }

  // Called by anchor tags created using markdown
  handleHref(e) {
    if (e.target.tagName.toLowerCase() === 'a') {
      if (e.target.getAttribute('href').startsWith('#')) {
        const gotoEl = this.shadowRoot.getElementById(e.target.getAttribute('href').replace('#', ''));
        if (gotoEl) {
          gotoEl.scrollIntoView({
            behavior: 'auto',
            block: 'start'
          });
        }
      }
    }
  }

  // Example Dropdown @change Handler
  onSelectExample(e) {
    const exampleContainerEl = e.target.closest('.json-schema-example-panel');
    const exampleEls = [...exampleContainerEl.querySelectorAll('.example')];
    exampleEls.forEach(v => {
      v.style.display = v.dataset.example === e.target.value ? 'flex' : 'none';
    });
  }
  async scrollToEventTarget(event) {
    const navEl = event.currentTarget;
    if (!navEl.dataset.contentId) {
      return;
    }
    const contentEl = this.shadowRoot.getElementById(navEl.dataset.contentId);
    if (contentEl) {
      contentEl.scrollIntoView({
        behavior: 'auto',
        block: 'start'
      });
    }
  }
}
customElements.define('json-schema-viewer', JsonSchemaViewer);
;// ./src/index.js




/* harmony default export */ const src = ({
  RapiDoc: RapiDoc
});


/***/ }),

/***/ 526:
/***/ ((__unused_webpack_module, exports) => {

"use strict";


exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}


/***/ }),

/***/ 287:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {

"use strict";
var __webpack_unused_export__;
/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <https://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



const base64 = __webpack_require__(526)
const ieee754 = __webpack_require__(251)
const customInspectSymbol =
  (typeof Symbol === 'function' && typeof Symbol['for'] === 'function') // eslint-disable-line dot-notation
    ? Symbol['for']('nodejs.util.inspect.custom') // eslint-disable-line dot-notation
    : null

exports.hp = Buffer
__webpack_unused_export__ = SlowBuffer
exports.IS = 50

const K_MAX_LENGTH = 0x7fffffff
__webpack_unused_export__ = K_MAX_LENGTH

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Print warning and recommend using `buffer` v4.x which has an Object
 *               implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * We report that the browser does not support typed arrays if the are not subclassable
 * using __proto__. Firefox 4-29 lacks support for adding new properties to `Uint8Array`
 * (See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438). IE 10 lacks support
 * for __proto__ and has a buggy typed array implementation.
 */
Buffer.TYPED_ARRAY_SUPPORT = typedArraySupport()

if (!Buffer.TYPED_ARRAY_SUPPORT && typeof console !== 'undefined' &&
    typeof console.error === 'function') {
  console.error(
    'This browser lacks typed array (Uint8Array) support which is required by ' +
    '`buffer` v5.x. Use `buffer` v4.x if you require old browser support.'
  )
}

function typedArraySupport () {
  // Can typed array instances can be augmented?
  try {
    const arr = new Uint8Array(1)
    const proto = { foo: function () { return 42 } }
    Object.setPrototypeOf(proto, Uint8Array.prototype)
    Object.setPrototypeOf(arr, proto)
    return arr.foo() === 42
  } catch (e) {
    return false
  }
}

Object.defineProperty(Buffer.prototype, 'parent', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.buffer
  }
})

Object.defineProperty(Buffer.prototype, 'offset', {
  enumerable: true,
  get: function () {
    if (!Buffer.isBuffer(this)) return undefined
    return this.byteOffset
  }
})

function createBuffer (length) {
  if (length > K_MAX_LENGTH) {
    throw new RangeError('The value "' + length + '" is invalid for option "size"')
  }
  // Return an augmented `Uint8Array` instance
  const buf = new Uint8Array(length)
  Object.setPrototypeOf(buf, Buffer.prototype)
  return buf
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new TypeError(
        'The "string" argument must be of type string. Received type number'
      )
    }
    return allocUnsafe(arg)
  }
  return from(arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

function from (value, encodingOrOffset, length) {
  if (typeof value === 'string') {
    return fromString(value, encodingOrOffset)
  }

  if (ArrayBuffer.isView(value)) {
    return fromArrayView(value)
  }

  if (value == null) {
    throw new TypeError(
      'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
      'or Array-like Object. Received type ' + (typeof value)
    )
  }

  if (isInstance(value, ArrayBuffer) ||
      (value && isInstance(value.buffer, ArrayBuffer))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof SharedArrayBuffer !== 'undefined' &&
      (isInstance(value, SharedArrayBuffer) ||
      (value && isInstance(value.buffer, SharedArrayBuffer)))) {
    return fromArrayBuffer(value, encodingOrOffset, length)
  }

  if (typeof value === 'number') {
    throw new TypeError(
      'The "value" argument must not be of type number. Received type number'
    )
  }

  const valueOf = value.valueOf && value.valueOf()
  if (valueOf != null && valueOf !== value) {
    return Buffer.from(valueOf, encodingOrOffset, length)
  }

  const b = fromObject(value)
  if (b) return b

  if (typeof Symbol !== 'undefined' && Symbol.toPrimitive != null &&
      typeof value[Symbol.toPrimitive] === 'function') {
    return Buffer.from(value[Symbol.toPrimitive]('string'), encodingOrOffset, length)
  }

  throw new TypeError(
    'The first argument must be one of type string, Buffer, ArrayBuffer, Array, ' +
    'or Array-like Object. Received type ' + (typeof value)
  )
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(value, encodingOrOffset, length)
}

// Note: Change prototype *after* Buffer.from is defined to workaround Chrome bug:
// https://github.com/feross/buffer/pull/148
Object.setPrototypeOf(Buffer.prototype, Uint8Array.prototype)
Object.setPrototypeOf(Buffer, Uint8Array)

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be of type number')
  } else if (size < 0) {
    throw new RangeError('The value "' + size + '" is invalid for option "size"')
  }
}

function alloc (size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpreted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(size).fill(fill, encoding)
      : createBuffer(size).fill(fill)
  }
  return createBuffer(size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(size, fill, encoding)
}

function allocUnsafe (size) {
  assertSize(size)
  return createBuffer(size < 0 ? 0 : checked(size) | 0)
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(size)
}

function fromString (string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('Unknown encoding: ' + encoding)
  }

  const length = byteLength(string, encoding) | 0
  let buf = createBuffer(length)

  const actual = buf.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    buf = buf.slice(0, actual)
  }

  return buf
}

function fromArrayLike (array) {
  const length = array.length < 0 ? 0 : checked(array.length) | 0
  const buf = createBuffer(length)
  for (let i = 0; i < length; i += 1) {
    buf[i] = array[i] & 255
  }
  return buf
}

function fromArrayView (arrayView) {
  if (isInstance(arrayView, Uint8Array)) {
    const copy = new Uint8Array(arrayView)
    return fromArrayBuffer(copy.buffer, copy.byteOffset, copy.byteLength)
  }
  return fromArrayLike(arrayView)
}

function fromArrayBuffer (array, byteOffset, length) {
  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('"offset" is outside of buffer bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('"length" is outside of buffer bounds')
  }

  let buf
  if (byteOffset === undefined && length === undefined) {
    buf = new Uint8Array(array)
  } else if (length === undefined) {
    buf = new Uint8Array(array, byteOffset)
  } else {
    buf = new Uint8Array(array, byteOffset, length)
  }

  // Return an augmented `Uint8Array` instance
  Object.setPrototypeOf(buf, Buffer.prototype)

  return buf
}

function fromObject (obj) {
  if (Buffer.isBuffer(obj)) {
    const len = checked(obj.length) | 0
    const buf = createBuffer(len)

    if (buf.length === 0) {
      return buf
    }

    obj.copy(buf, 0, 0, len)
    return buf
  }

  if (obj.length !== undefined) {
    if (typeof obj.length !== 'number' || numberIsNaN(obj.length)) {
      return createBuffer(0)
    }
    return fromArrayLike(obj)
  }

  if (obj.type === 'Buffer' && Array.isArray(obj.data)) {
    return fromArrayLike(obj.data)
  }
}

function checked (length) {
  // Note: cannot use `length < K_MAX_LENGTH` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= K_MAX_LENGTH) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + K_MAX_LENGTH.toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return b != null && b._isBuffer === true &&
    b !== Buffer.prototype // so Buffer.isBuffer(Buffer.prototype) will be false
}

Buffer.compare = function compare (a, b) {
  if (isInstance(a, Uint8Array)) a = Buffer.from(a, a.offset, a.byteLength)
  if (isInstance(b, Uint8Array)) b = Buffer.from(b, b.offset, b.byteLength)
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError(
      'The "buf1", "buf2" arguments must be one of type Buffer or Uint8Array'
    )
  }

  if (a === b) return 0

  let x = a.length
  let y = b.length

  for (let i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!Array.isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  let i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  const buffer = Buffer.allocUnsafe(length)
  let pos = 0
  for (i = 0; i < list.length; ++i) {
    let buf = list[i]
    if (isInstance(buf, Uint8Array)) {
      if (pos + buf.length > buffer.length) {
        if (!Buffer.isBuffer(buf)) buf = Buffer.from(buf)
        buf.copy(buffer, pos)
      } else {
        Uint8Array.prototype.set.call(
          buffer,
          buf,
          pos
        )
      }
    } else if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    } else {
      buf.copy(buffer, pos)
    }
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (ArrayBuffer.isView(string) || isInstance(string, ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    throw new TypeError(
      'The "string" argument must be one of type string, Buffer, or ArrayBuffer. ' +
      'Received type ' + typeof string
    )
  }

  const len = string.length
  const mustMatch = (arguments.length > 2 && arguments[2] === true)
  if (!mustMatch && len === 0) return 0

  // Use a for loop to avoid recursion
  let loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) {
          return mustMatch ? -1 : utf8ToBytes(string).length // assume utf8
        }
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  let loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coercion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// This property is used by `Buffer.isBuffer` (and the `is-buffer` npm package)
// to detect a Buffer instance. It's not possible to use `instanceof Buffer`
// reliably in a browserify context because there could be multiple different
// copies of the 'buffer' package in use. This method works even for Buffer
// instances that were created from another copy of the `buffer` package.
// See: https://github.com/feross/buffer/issues/154
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  const i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  const len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (let i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  const len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (let i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  const len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (let i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  const length = this.length
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.toLocaleString = Buffer.prototype.toString

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  let str = ''
  const max = exports.IS
  str = this.toString('hex', 0, max).replace(/(.{2})/g, '$1 ').trim()
  if (this.length > max) str += ' ... '
  return '<Buffer ' + str + '>'
}
if (customInspectSymbol) {
  Buffer.prototype[customInspectSymbol] = Buffer.prototype.inspect
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (isInstance(target, Uint8Array)) {
    target = Buffer.from(target, target.offset, target.byteLength)
  }
  if (!Buffer.isBuffer(target)) {
    throw new TypeError(
      'The "target" argument must be one of type Buffer or Uint8Array. ' +
      'Received type ' + (typeof target)
    )
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  let x = thisEnd - thisStart
  let y = end - start
  const len = Math.min(x, y)

  const thisCopy = this.slice(thisStart, thisEnd)
  const targetCopy = target.slice(start, end)

  for (let i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset // Coerce to Number.
  if (numberIsNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [val], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  let indexSize = 1
  let arrLength = arr.length
  let valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  let i
  if (dir) {
    let foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      let found = true
      for (let j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOf