"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = OkButton;

var _react = require("react");

var _react2 = _interopRequireDefault(_react);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function OkButton(_ref) {
  var prefixCls = _ref.prefixCls;
  var locale = _ref.locale;
  var okDisabled = _ref.okDisabled;
  var onOk = _ref.onOk;

  var className = prefixCls + "-ok-btn";
  if (okDisabled) {
    className += " " + prefixCls + "-ok-btn-disabled";
  }
  return _react2["default"].createElement(
    "a",
    {
      className: className,
      role: "button",
      onClick: okDisabled ? null : onOk
    },
    locale.ok
  );
}
module.exports = exports['default'];