'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = TodayButton;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _util = require('../util/');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function TodayButton(_ref) {
  var prefixCls = _ref.prefixCls;
  var locale = _ref.locale;
  var value = _ref.value;
  var timePicker = _ref.timePicker;
  var disabled = _ref.disabled;
  var disabledDate = _ref.disabledDate;
  var onToday = _ref.onToday;
  var text = _ref.text;

  var localeNow = (!text && timePicker ? locale.now : text) || locale.today;
  var disabledToday = disabledDate && !(0, _util.isAllowedDate)((0, _util.getTodayTime)(value), disabledDate);
  var isDisabled = disabledToday || disabled;
  var disabledTodayClass = isDisabled ? prefixCls + '-today-btn-disabled' : '';
  return _react2["default"].createElement(
    'a',
    {
      className: prefixCls + '-today-btn ' + disabledTodayClass,
      role: 'button',
      onClick: isDisabled ? null : onToday,
      title: (0, _util.getTodayTimeStr)(value)
    },
    localeNow
  );
}
module.exports = exports['default'];