'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

var DateInput = _react2["default"].createClass({
  displayName: 'DateInput',

  propTypes: {
    prefixCls: _react.PropTypes.string,
    timePicker: _react.PropTypes.object,
    value: _react.PropTypes.object,
    disabledTime: _react.PropTypes.any,
    format: _react.PropTypes.string,
    locale: _react.PropTypes.object,
    disabledDate: _react.PropTypes.func,
    onChange: _react.PropTypes.func,
    onClear: _react.PropTypes.func,
    placeholder: _react.PropTypes.string,
    onSelect: _react.PropTypes.func,
    selectedValue: _react.PropTypes.object
  },

  getInitialState: function getInitialState() {
    var selectedValue = this.props.selectedValue;
    return {
      str: selectedValue && selectedValue.format(this.props.format) || '',
      invalid: false
    };
  },
  componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
    // when popup show, click body will call this, bug!
    var selectedValue = nextProps.selectedValue;
    this.setState({
      str: selectedValue && selectedValue.format(nextProps.format) || '',
      invalid: false
    });
  },
  onInputChange: function onInputChange(event) {
    var str = event.target.value;
    this.setState({
      str: str
    });
    var value = void 0;
    var _props = this.props;
    var disabledDate = _props.disabledDate;
    var format = _props.format;
    var onChange = _props.onChange;

    if (str) {
      var parsed = (0, _moment2["default"])(str, format, true);
      if (!parsed.isValid()) {
        this.setState({
          invalid: true
        });
        return;
      }
      value = this.props.value.clone();
      value.year(parsed.year()).month(parsed.month()).date(parsed.date()).hour(parsed.hour()).minute(parsed.minute()).second(parsed.second());

      if (value && (!disabledDate || !disabledDate(value))) {
        var originalValue = this.props.selectedValue;
        if (originalValue && value) {
          if (!originalValue.isSame(value)) {
            onChange(value);
          }
        } else if (originalValue !== value) {
          onChange(value);
        }
      } else {
        this.setState({
          invalid: true
        });
        return;
      }
    } else {
      onChange(null);
    }
    this.setState({
      invalid: false
    });
  },
  onClear: function onClear() {
    this.setState({
      str: ''
    });
    this.props.onClear(null);
  },
  getRootDOMNode: function getRootDOMNode() {
    return _reactDom2["default"].findDOMNode(this);
  },
  focus: function focus() {
    this.refs.dateInput.focus();
  },
  render: function render() {
    var props = this.props;
    var _state = this.state;
    var invalid = _state.invalid;
    var str = _state.str;
    var locale = props.locale;
    var prefixCls = props.prefixCls;
    var placeholder = props.placeholder;

    var invalidClass = invalid ? prefixCls + '-input-invalid' : '';
    return _react2["default"].createElement(
      'div',
      { className: prefixCls + '-input-wrap' },
      _react2["default"].createElement(
        'div',
        { className: prefixCls + '-date-input-wrap' },
        _react2["default"].createElement('input', {
          ref: 'dateInput',
          className: prefixCls + '-input  ' + invalidClass,
          value: str,
          disabled: props.disabled,
          placeholder: placeholder,
          onChange: this.onInputChange
        })
      ),
      props.showClear ? _react2["default"].createElement('a', {
        className: prefixCls + '-clear-btn',
        role: 'button',
        title: locale.clear,
        onClick: this.onClear
      }) : null
    );
  }
});

exports["default"] = DateInput;
module.exports = exports['default'];