'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _MonthPanel = require('../month/MonthPanel');

var _MonthPanel2 = _interopRequireDefault(_MonthPanel);

var _YearPanel = require('../year/YearPanel');

var _YearPanel2 = _interopRequireDefault(_YearPanel);

var _mapSelf = require('rc-util/lib/Children/mapSelf');

var _mapSelf2 = _interopRequireDefault(_mapSelf);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function goMonth(direction) {
  var next = this.props.value.clone();
  next.add(direction, 'months');
  this.props.onValueChange(next);
}

function goYear(direction) {
  var next = this.props.value.clone();
  next.add(direction, 'years');
  this.props.onValueChange(next);
}

function showIf(condition, el) {
  return condition ? el : null;
}

var CalendarHeader = _react2["default"].createClass({
  displayName: 'CalendarHeader',

  propTypes: {
    prefixCls: _react.PropTypes.string,
    value: _react.PropTypes.object,
    onValueChange: _react.PropTypes.func,
    showTimePicker: _react.PropTypes.bool,
    showMonthPanel: _react.PropTypes.bool,
    showYearPanel: _react.PropTypes.bool,
    onPanelChange: _react.PropTypes.func,
    locale: _react.PropTypes.object,
    enablePrev: _react.PropTypes.any,
    enableNext: _react.PropTypes.any
  },

  getDefaultProps: function getDefaultProps() {
    return {
      enableNext: 1,
      enablePrev: 1,
      onPanelChange: function onPanelChange() {},
      onValueChange: function onValueChange() {}
    };
  },
  getInitialState: function getInitialState() {
    this.nextMonth = goMonth.bind(this, 1);
    this.previousMonth = goMonth.bind(this, -1);
    this.nextYear = goYear.bind(this, 1);
    this.previousYear = goYear.bind(this, -1);
    var _props = this.props,
        showMonthPanel = _props.showMonthPanel,
        showYearPanel = _props.showYearPanel;

    return { showMonthPanel: showMonthPanel, showYearPanel: showYearPanel };
  },
  componentWillReceiveProps: function componentWillReceiveProps() {
    var props = this.props;
    if ('showMonthpanel' in props) {
      this.setState({ showMonthPanel: props.showMonthPanel });
    }
    if ('showYearpanel' in props) {
      this.setState({ showYearPanel: props.showYearPanel });
    }
  },
  onSelect: function onSelect(value) {
    this.triggerPanelChange({
      showMonthPanel: 0,
      showYearPanel: 0
    });
    this.props.onValueChange(value);
  },
  triggerPanelChange: function triggerPanelChange(panelStatus) {
    if (!('showMonthPanel' in this.props)) {
      this.setState({ showMonthPanel: panelStatus.showMonthPanel });
    }
    if (!('showYearPanel' in this.props)) {
      this.setState({ showYearPanel: panelStatus.showYearPanel });
    }
    this.props.onPanelChange(panelStatus);
  },
  monthYearElement: function monthYearElement(showTimePicker) {
    var props = this.props;
    var prefixCls = props.prefixCls;
    var locale = props.locale;
    var value = props.value;
    var localeData = value.localeData();
    var monthBeforeYear = locale.monthBeforeYear;
    var selectClassName = prefixCls + '-' + (monthBeforeYear ? 'my-select' : 'ym-select');
    var year = _react2["default"].createElement(
      'a',
      {
        className: prefixCls + '-year-select',
        role: 'button',
        onClick: showTimePicker ? null : this.showYearPanel,
        title: locale.yearSelect
      },
      value.format(locale.yearFormat)
    );
    var month = _react2["default"].createElement(
      'a',
      {
        className: prefixCls + '-month-select',
        role: 'button',
        onClick: showTimePicker ? null : this.showMonthPanel,
        title: locale.monthSelect
      },
      localeData.months(value)
    );
    var day = void 0;
    if (showTimePicker) {
      day = _react2["default"].createElement(
        'a',
        {
          className: prefixCls + '-day-select',
          role: 'button'
        },
        value.format(locale.dayFormat)
      );
    }
    var my = [];
    if (monthBeforeYear) {
      my = [month, day, year];
    } else {
      my = [year, month, day];
    }
    return _react2["default"].createElement(
      'span',
      { className: selectClassName },
      (0, _mapSelf2["default"])(my)
    );
  },
  showMonthPanel: function showMonthPanel() {
    this.triggerPanelChange({
      showMonthPanel: 1,
      showYearPanel: 0
    });
  },
  showYearPanel: function showYearPanel() {
    this.triggerPanelChange({
      showMonthPanel: 0,
      showYearPanel: 1
    });
  },
  render: function render() {
    var props = this.props;
    var enableNext = props.enableNext,
        enablePrev = props.enablePrev,
        prefixCls = props.prefixCls,
        locale = props.locale,
        value = props.value,
        showTimePicker = props.showTimePicker;

    var state = this.state;
    var PanelClass = null;
    if (state.showMonthPanel) {
      PanelClass = _MonthPanel2["default"];
    } else if (state.showYearPanel) {
      PanelClass = _YearPanel2["default"];
    }
    var panel = void 0;
    if (PanelClass) {
      panel = _react2["default"].createElement(PanelClass, {
        locale: locale,
        defaultValue: value,
        rootPrefixCls: prefixCls,
        onSelect: this.onSelect
      });
    }
    return _react2["default"].createElement(
      'div',
      { className: prefixCls + '-header' },
      _react2["default"].createElement(
        'div',
        { style: { position: 'relative' } },
        showIf(enablePrev && !showTimePicker, _react2["default"].createElement('a', {
          className: prefixCls + '-prev-year-btn',
          role: 'button',
          onClick: this.previousYear,
          title: locale.previousYear
        })),
        showIf(enablePrev && !showTimePicker, _react2["default"].createElement('a', {
          className: prefixCls + '-prev-month-btn',
          role: 'button',
          onClick: this.previousMonth,
          title: locale.previousMonth
        })),
        this.monthYearElement(showTimePicker),
        showIf(enableNext && !showTimePicker, _react2["default"].createElement('a', {
          className: prefixCls + '-next-month-btn',
          onClick: this.nextMonth,
          title: locale.nextMonth
        })),
        showIf(enableNext && !showTimePicker, _react2["default"].createElement('a', {
          className: prefixCls + '-next-year-btn',
          onClick: this.nextYear,
          title: locale.nextYear
        }))
      ),
      panel
    );
  }
});

exports["default"] = CalendarHeader;
module.exports = exports['default'];