import React from 'react';
import createReactClass from 'create-react-class';
import PropTypes from 'prop-types';
import KeyCode from 'rc-util/es/KeyCode';
import MonthPanel from './month/MonthPanel';
import CalendarMixin from './mixin/CalendarMixin';
import CommonMixin from './mixin/CommonMixin';

var MonthCalendar = createReactClass({
  displayName: 'MonthCalendar',

  propTypes: {
    monthCellRender: PropTypes.func,
    dateCellRender: PropTypes.func
  },
  mixins: [CommonMixin, CalendarMixin],

  onKeyDown: function onKeyDown(event) {
    var keyCode = event.keyCode;
    var ctrlKey = event.ctrlKey || event.metaKey;
    var stateValue = this.state.value;
    var disabledDate = this.props.disabledDate;

    var value = stateValue;
    switch (keyCode) {
      case KeyCode.DOWN:
        value = stateValue.clone();
        value.add(3, 'months');
        break;
      case KeyCode.UP:
        value = stateValue.clone();
        value.add(-3, 'months');
        break;
      case KeyCode.LEFT:
        value = stateValue.clone();
        if (ctrlKey) {
          value.add(-1, 'years');
        } else {
          value.add(-1, 'months');
        }
        break;
      case KeyCode.RIGHT:
        value = stateValue.clone();
        if (ctrlKey) {
          value.add(1, 'years');
        } else {
          value.add(1, 'months');
        }
        break;
      case KeyCode.ENTER:
        if (!disabledDate || !disabledDate(stateValue)) {
          this.onSelect(stateValue);
        }
        event.preventDefault();
        return 1;
      default:
        return undefined;
    }
    if (value !== stateValue) {
      this.setValue(value);
      event.preventDefault();
      return 1;
    }
  },
  render: function render() {
    var props = this.props;
    var children = React.createElement(MonthPanel, {
      locale: props.locale,
      disabledDate: props.disabledDate,
      style: { position: 'relative' },
      value: this.state.value,
      cellRender: props.monthCellRender,
      contentRender: props.monthCellContentRender,
      rootPrefixCls: props.prefixCls,
      onChange: this.setValue,
      onSelect: this.onSelect
    });
    return this.renderRoot({
      children: children
    });
  }
});

export default MonthCalendar;