import React from 'react';
import createReactClass from 'create-react-class';
import PropTypes from 'prop-types';
import MonthPanel from '../month/MonthPanel';
import YearPanel from '../year/YearPanel';
import toFragment from 'rc-util/es/Children/mapSelf';

function goMonth(direction) {
  var next = this.props.value.clone();
  next.add(direction, 'months');
  this.props.onValueChange(next);
}

function goYear(direction) {
  var next = this.props.value.clone();
  next.add(direction, 'years');
  this.props.onValueChange(next);
}

function showIf(condition, el) {
  return condition ? el : null;
}

var CalendarHeader = createReactClass({
  displayName: 'CalendarHeader',

  propTypes: {
    prefixCls: PropTypes.string,
    value: PropTypes.object,
    onValueChange: PropTypes.func,
    showTimePicker: PropTypes.bool,
    showMonthPanel: PropTypes.bool,
    showYearPanel: PropTypes.bool,
    onPanelChange: PropTypes.func,
    locale: PropTypes.object,
    enablePrev: PropTypes.any,
    enableNext: PropTypes.any,
    disabledMonth: PropTypes.func
  },

  getDefaultProps: function getDefaultProps() {
    return {
      enableNext: 1,
      enablePrev: 1,
      onPanelChange: function onPanelChange() {},
      onValueChange: function onValueChange() {}
    };
  },
  getInitialState: function getInitialState() {
    this.nextMonth = goMonth.bind(this, 1);
    this.previousMonth = goMonth.bind(this, -1);
    this.nextYear = goYear.bind(this, 1);
    this.previousYear = goYear.bind(this, -1);
    var _props = this.props,
        showMonthPanel = _props.showMonthPanel,
        showYearPanel = _props.showYearPanel;

    return { showMonthPanel: showMonthPanel, showYearPanel: showYearPanel };
  },
  componentWillReceiveProps: function componentWillReceiveProps() {
    var props = this.props;
    if ('showMonthpanel' in props) {
      this.setState({ showMonthPanel: props.showMonthPanel });
    }
    if ('showYearpanel' in props) {
      this.setState({ showYearPanel: props.showYearPanel });
    }
  },
  onSelect: function onSelect(value) {
    this.triggerPanelChange({
      showMonthPanel: 0,
      showYearPanel: 0
    });
    this.props.onValueChange(value);
  },
  triggerPanelChange: function triggerPanelChange(panelStatus) {
    if (!('showMonthPanel' in this.props)) {
      this.setState({ showMonthPanel: panelStatus.showMonthPanel });
    }
    if (!('showYearPanel' in this.props)) {
      this.setState({ showYearPanel: panelStatus.showYearPanel });
    }
    this.props.onPanelChange(panelStatus);
  },
  monthYearElement: function monthYearElement(showTimePicker) {
    var props = this.props;
    var prefixCls = props.prefixCls;
    var locale = props.locale;
    var value = props.value;
    var localeData = value.localeData();
    var monthBeforeYear = locale.monthBeforeYear;
    var selectClassName = prefixCls + '-' + (monthBeforeYear ? 'my-select' : 'ym-select');
    var year = React.createElement(
      'a',
      {
        className: prefixCls + '-year-select',
        role: 'button',
        onClick: showTimePicker ? null : this.showYearPanel,
        title: locale.yearSelect
      },
      value.format(locale.yearFormat)
    );
    var month = React.createElement(
      'a',
      {
        className: prefixCls + '-month-select',
        role: 'button',
        onClick: showTimePicker ? null : this.showMonthPanel,
        title: locale.monthSelect
      },
      localeData.monthsShort(value)
    );
    var day = void 0;
    if (showTimePicker) {
      day = React.createElement(
        'a',
        {
          className: prefixCls + '-day-select',
          role: 'button'
        },
        value.format(locale.dayFormat)
      );
    }
    var my = [];
    if (monthBeforeYear) {
      my = [month, day, year];
    } else {
      my = [year, month, day];
    }
    return React.createElement(
      'span',
      { className: selectClassName },
      toFragment(my)
    );
  },
  showMonthPanel: function showMonthPanel() {
    this.triggerPanelChange({
      showMonthPanel: 1,
      showYearPanel: 0
    });
  },
  showYearPanel: function showYearPanel() {
    this.triggerPanelChange({
      showMonthPanel: 0,
      showYearPanel: 1
    });
  },
  render: function render() {
    var props = this.props,
        state = this.state;
    var prefixCls = props.prefixCls,
        locale = props.locale,
        value = props.value,
        showTimePicker = props.showTimePicker,
        enableNext = props.enableNext,
        enablePrev = props.enablePrev,
        disabledMonth = props.disabledMonth;


    var panel = null;
    if (state.showMonthPanel) {
      panel = React.createElement(MonthPanel, {
        locale: locale,
        defaultValue: value,
        rootPrefixCls: prefixCls,
        onSelect: this.onSelect,
        disabledDate: disabledMonth
      });
    } else if (state.showYearPanel) {
      panel = React.createElement(YearPanel, {
        locale: locale,
        defaultValue: value,
        rootPrefixCls: prefixCls,
        onSelect: this.onSelect
      });
    }

    return React.createElement(
      'div',
      { className: prefixCls + '-header' },
      React.createElement(
        'div',
        { style: { position: 'relative' } },
        showIf(enablePrev && !showTimePicker, React.createElement('a', {
          className: prefixCls + '-prev-year-btn',
          role: 'button',
          onClick: this.previousYear,
          title: locale.previousYear
        })),
        showIf(enablePrev && !showTimePicker, React.createElement('a', {
          className: prefixCls + '-prev-month-btn',
          role: 'button',
          onClick: this.previousMonth,
          title: locale.previousMonth
        })),
        this.monthYearElement(showTimePicker),
        showIf(enableNext && !showTimePicker, React.createElement('a', {
          className: prefixCls + '-next-month-btn',
          onClick: this.nextMonth,
          title: locale.nextMonth
        })),
        showIf(enableNext && !showTimePicker, React.createElement('a', {
          className: prefixCls + '-next-year-btn',
          onClick: this.nextYear,
          title: locale.nextYear
        }))
      ),
      panel
    );
  }
});

export default CalendarHeader;