import React from 'react';
import createReactClass from 'create-react-class';
import PropTypes from 'prop-types';
import YearPanel from '../year/YearPanel';
import MonthTable from './MonthTable';

function goYear(direction) {
  var next = this.state.value.clone();
  next.add(direction, 'year');
  this.setAndChangeValue(next);
}

function noop() {}

var MonthPanel = createReactClass({
  displayName: 'MonthPanel',

  propTypes: {
    onChange: PropTypes.func,
    disabledDate: PropTypes.func,
    onSelect: PropTypes.func
  },

  getDefaultProps: function getDefaultProps() {
    return {
      onChange: noop,
      onSelect: noop
    };
  },
  getInitialState: function getInitialState() {
    var props = this.props;
    // bind methods
    this.nextYear = goYear.bind(this, 1);
    this.previousYear = goYear.bind(this, -1);
    this.prefixCls = props.rootPrefixCls + '-month-panel';
    return {
      value: props.value || props.defaultValue
    };
  },
  componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
    if ('value' in nextProps) {
      this.setState({
        value: nextProps.value
      });
    }
  },
  onYearPanelSelect: function onYearPanelSelect(current) {
    this.setState({
      showYearPanel: 0
    });
    this.setAndChangeValue(current);
  },
  setAndChangeValue: function setAndChangeValue(value) {
    this.setValue(value);
    this.props.onChange(value);
  },
  setAndSelectValue: function setAndSelectValue(value) {
    this.setValue(value);
    this.props.onSelect(value);
  },
  setValue: function setValue(value) {
    if (!('value' in this.props)) {
      this.setState({
        value: value
      });
    }
  },
  showYearPanel: function showYearPanel() {
    this.setState({
      showYearPanel: 1
    });
  },
  render: function render() {
    var props = this.props;
    var value = this.state.value;
    var cellRender = props.cellRender;
    var contentRender = props.contentRender;
    var locale = props.locale;
    var year = value.year();
    var prefixCls = this.prefixCls;
    var yearPanel = void 0;
    if (this.state.showYearPanel) {
      yearPanel = React.createElement(YearPanel, {
        locale: locale,
        value: value,
        rootPrefixCls: props.rootPrefixCls,
        onSelect: this.onYearPanelSelect
      });
    }
    return React.createElement(
      'div',
      { className: prefixCls, style: props.style },
      React.createElement(
        'div',
        null,
        React.createElement(
          'div',
          { className: prefixCls + '-header' },
          React.createElement('a', {
            className: prefixCls + '-prev-year-btn',
            role: 'button',
            onClick: this.previousYear,
            title: locale.previousYear
          }),
          React.createElement(
            'a',
            {
              className: prefixCls + '-year-select',
              role: 'button',
              onClick: this.showYearPanel,
              title: locale.yearSelect
            },
            React.createElement(
              'span',
              { className: prefixCls + '-year-select-content' },
              year
            ),
            React.createElement(
              'span',
              { className: prefixCls + '-year-select-arrow' },
              'x'
            )
          ),
          React.createElement('a', {
            className: prefixCls + '-next-year-btn',
            role: 'button',
            onClick: this.nextYear,
            title: locale.nextYear
          })
        ),
        React.createElement(
          'div',
          { className: prefixCls + '-body' },
          React.createElement(MonthTable, {
            disabledDate: props.disabledDate,
            onSelect: this.setAndSelectValue,
            locale: locale,
            value: value,
            cellRender: cellRender,
            contentRender: contentRender,
            prefixCls: prefixCls
          })
        )
      ),
      yearPanel
    );
  }
});

export default MonthPanel;