'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _DateConstants = require('./DateConstants');

var _DateConstants2 = _interopRequireDefault(_DateConstants);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var DateTHead = function (_React$Component) {
  (0, _inherits3['default'])(DateTHead, _React$Component);

  function DateTHead() {
    (0, _classCallCheck3['default'])(this, DateTHead);
    return (0, _possibleConstructorReturn3['default'])(this, (DateTHead.__proto__ || Object.getPrototypeOf(DateTHead)).apply(this, arguments));
  }

  (0, _createClass3['default'])(DateTHead, [{
    key: 'render',
    value: function render() {
      var props = this.props;
      var value = props.value;
      var localeData = value.localeData();
      var prefixCls = props.prefixCls;
      var veryShortWeekdays = [];
      var weekDays = [];
      var firstDayOfWeek = localeData.firstDayOfWeek();
      var showWeekNumberEl = void 0;
      var now = (0, _moment2['default'])();
      for (var dateColIndex = 0; dateColIndex < _DateConstants2['default'].DATE_COL_COUNT; dateColIndex++) {
        var index = (firstDayOfWeek + dateColIndex) % _DateConstants2['default'].DATE_COL_COUNT;
        now.day(index);
        veryShortWeekdays[dateColIndex] = localeData.weekdaysMin(now);
        weekDays[dateColIndex] = localeData.weekdaysShort(now);
      }

      if (props.showWeekNumber) {
        showWeekNumberEl = _react2['default'].createElement(
          'th',
          {
            role: 'columnheader',
            className: prefixCls + '-column-header ' + prefixCls + '-week-number-header'
          },
          _react2['default'].createElement(
            'span',
            { className: prefixCls + '-column-header-inner' },
            'x'
          )
        );
      }
      var weekDaysEls = weekDays.map(function (day, xindex) {
        return _react2['default'].createElement(
          'th',
          {
            key: xindex,
            role: 'columnheader',
            title: day,
            className: prefixCls + '-column-header'
          },
          _react2['default'].createElement(
            'span',
            { className: prefixCls + '-column-header-inner' },
            veryShortWeekdays[xindex]
          )
        );
      });
      return _react2['default'].createElement(
        'thead',
        null,
        _react2['default'].createElement(
          'tr',
          { role: 'row' },
          showWeekNumberEl,
          weekDaysEls
        )
      );
    }
  }]);
  return DateTHead;
}(_react2['default'].Component);

exports['default'] = DateTHead;
module.exports = exports['default'];