import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import React from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import moment from 'moment';
import { isAllowedDate, getTodayTime } from '../util/index';

function noop() {}

export function getNowByCurrentStateValue(value) {
  var ret = void 0;
  if (value) {
    ret = getTodayTime(value);
  } else {
    ret = moment();
  }
  return ret;
}

export var calendarMixinPropTypes = {
  value: PropTypes.object,
  defaultValue: PropTypes.object,
  onKeyDown: PropTypes.func
};

export var calendarMixinDefaultProps = {
  onKeyDown: noop
};

export var calendarMixinWrapper = function calendarMixinWrapper(ComposeComponent) {
  var _class, _temp2;

  return _temp2 = _class = function (_ComposeComponent) {
    _inherits(_class, _ComposeComponent);

    function _class() {
      var _temp, _this, _ret;

      _classCallCheck(this, _class);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, _ComposeComponent.call.apply(_ComposeComponent, [this].concat(args))), _this), _this.onSelect = function (value, cause) {
        if (value) {
          _this.setValue(value);
        }
        _this.setSelectedValue(value, cause);
      }, _this.renderRoot = function (newProps) {
        var _className;

        var props = _this.props;
        var prefixCls = props.prefixCls;

        var className = (_className = {}, _className[prefixCls] = 1, _className[prefixCls + '-hidden'] = !props.visible, _className[props.className] = !!props.className, _className[newProps.className] = !!newProps.className, _className);

        return React.createElement(
          'div',
          {
            ref: _this.saveRoot,
            className: '' + classnames(className),
            style: _this.props.style,
            tabIndex: '0',
            onKeyDown: _this.onKeyDown
          },
          newProps.children
        );
      }, _this.setSelectedValue = function (selectedValue, cause) {
        // if (this.isAllowedDate(selectedValue)) {
        if (!('selectedValue' in _this.props)) {
          _this.setState({
            selectedValue: selectedValue
          });
        }
        if (_this.props.onSelect) {
          _this.props.onSelect(selectedValue, cause);
        }
        // }
      }, _this.setValue = function (value) {
        var originalValue = _this.state.value;
        if (!('value' in _this.props)) {
          _this.setState({
            value: value
          });
        }
        if (originalValue && value && !originalValue.isSame(value) || !originalValue && value || originalValue && !value) {
          _this.props.onChange(value);
        }
      }, _this.isAllowedDate = function (value) {
        var disabledDate = _this.props.disabledDate;
        var disabledTime = _this.props.disabledTime;
        return isAllowedDate(value, disabledDate, disabledTime);
      }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _class.getDerivedStateFromProps = function getDerivedStateFromProps(nextProps, prevState) {
      // Use origin function if provided
      if (ComposeComponent.getDerivedStateFromProps) {
        return ComposeComponent.getDerivedStateFromProps(nextProps, prevState);
      }

      var value = nextProps.value,
          selectedValue = nextProps.selectedValue;

      var newState = {};

      if ('value' in nextProps) {
        newState.value = value || nextProps.defaultValue || getNowByCurrentStateValue(prevState.value);
      }
      if ('selectedValue' in nextProps) {
        newState.selectedValue = selectedValue;
      }

      return newState;
    };

    return _class;
  }(ComposeComponent), _class.displayName = 'CalendarMixinWrapper', _class.defaultProps = ComposeComponent.defaultProps, _temp2;
};