'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _rcTrigger = require('rc-trigger');

var _rcTrigger2 = _interopRequireDefault(_rcTrigger);

var _Menus = require('./Menus');

var _Menus2 = _interopRequireDefault(_Menus);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _defaults(obj, defaults) { var keys = Object.getOwnPropertyNames(defaults); for (var i = 0; i < keys.length; i++) { var key = keys[i]; var value = Object.getOwnPropertyDescriptor(defaults, key); if (value && value.configurable && obj[key] === undefined) { Object.defineProperty(obj, key, value); } } return obj; }

function _objectWithoutProperties(obj, keys) { var target = {}; for (var i in obj) { if (keys.indexOf(i) >= 0) continue; if (!Object.prototype.hasOwnProperty.call(obj, i)) continue; target[i] = obj[i]; } return target; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : _defaults(subClass, superClass); }

var BUILT_IN_PLACEMENTS = {
  bottomLeft: {
    points: ['tl', 'bl'],
    offset: [0, 4],
    overflow: {
      adjustX: 1,
      adjustY: 1
    }
  },
  topLeft: {
    points: ['bl', 'tl'],
    offset: [0, -4],
    overflow: {
      adjustX: 1,
      adjustY: 1
    }
  },
  bottomRight: {
    points: ['tr', 'br'],
    offset: [0, 4],
    overflow: {
      adjustX: 1,
      adjustY: 1
    }
  },
  topRight: {
    points: ['br', 'tr'],
    offset: [0, -4],
    overflow: {
      adjustX: 1,
      adjustY: 1
    }
  }
};

var Cascader = function (_React$Component) {
  _inherits(Cascader, _React$Component);

  function Cascader(props) {
    _classCallCheck(this, Cascader);

    var _this = _possibleConstructorReturn(this, _React$Component.call(this, props));

    _this.setPopupVisible = function (popupVisible) {
      if (!('popupVisible' in _this.props)) {
        _this.setState({ popupVisible: popupVisible });
      }
      // sync activeValue with value when panel open
      if (popupVisible && !_this.state.visible) {
        _this.setState({
          activeValue: _this.state.value
        });
      }
      _this.props.onPopupVisibleChange(popupVisible);
    };

    _this.handleChange = function (options, setProps) {
      _this.props.onChange(options.map(function (o) {
        return o.value;
      }), options);
      _this.setPopupVisible(setProps.visible);
    };

    _this.handlePopupVisibleChange = function (popupVisible) {
      _this.setPopupVisible(popupVisible);
    };

    _this.handleSelect = function (_ref) {
      var info = _objectWithoutProperties(_ref, []);

      if ('value' in _this.props) {
        delete info.value;
      }
      _this.setState(info);
    };

    var initialValue = [];
    if ('value' in props) {
      initialValue = props.value || [];
    } else if ('defaultValue' in props) {
      initialValue = props.defaultValue || [];
    }

    _this.state = {
      popupVisible: props.popupVisible,
      activeValue: initialValue,
      value: initialValue
    };
    return _this;
  }

  Cascader.prototype.componentWillReceiveProps = function componentWillReceiveProps(nextProps) {
    if ('value' in nextProps && this.props.value !== nextProps.value) {
      var newValues = {
        value: nextProps.value || [],
        activeValue: nextProps.value || []
      };
      // allow activeValue diff from value
      // https://github.com/ant-design/ant-design/issues/2767
      if ('loadData' in nextProps) {
        delete newValues.activeValue;
      }
      this.setState(newValues);
    }
    if ('popupVisible' in nextProps) {
      this.setState({
        popupVisible: nextProps.popupVisible
      });
    }
  };

  Cascader.prototype.getPopupDOMNode = function getPopupDOMNode() {
    return this.refs.trigger.getPopupDomNode();
  };

  Cascader.prototype.render = function render() {
    var props = this.props;
    var prefixCls = props.prefixCls;
    var transitionName = props.transitionName;
    var popupClassName = props.popupClassName;
    var popupPlacement = props.popupPlacement;

    var restProps = _objectWithoutProperties(props, ['prefixCls', 'transitionName', 'popupClassName', 'popupPlacement']);
    // Did not show popup when there is no options


    var menus = _react2["default"].createElement('div', null);
    var emptyMenuClassName = '';
    if (props.options && props.options.length > 0) {
      menus = _react2["default"].createElement(_Menus2["default"], _extends({}, props, {
        value: this.state.value,
        activeValue: this.state.activeValue,
        onSelect: this.handleSelect,
        onChange: this.handleChange,
        visible: this.state.popupVisible
      }));
    } else {
      emptyMenuClassName = ' ' + prefixCls + '-menus-empty';
    }
    return _react2["default"].createElement(
      _rcTrigger2["default"],
      _extends({ ref: 'trigger'
      }, restProps, {
        popupPlacement: popupPlacement,
        builtinPlacements: BUILT_IN_PLACEMENTS,
        popupTransitionName: transitionName,
        action: props.disabled ? [] : ['click'],
        popupVisible: props.disabled ? false : this.state.popupVisible,
        onPopupVisibleChange: this.handlePopupVisibleChange,
        prefixCls: prefixCls + '-menus',
        popupClassName: popupClassName + emptyMenuClassName,
        popup: menus
      }),
      props.children
    );
  };

  return Cascader;
}(_react2["default"].Component);

Cascader.defaultProps = {
  options: [],
  onChange: function onChange() {},
  onPopupVisibleChange: function onPopupVisibleChange() {},

  disabled: false,
  transitionName: '',
  prefixCls: 'rc-cascader',
  popupClassName: '',
  popupPlacement: 'bottomLeft'
};

Cascader.propTypes = {
  value: _react2["default"].PropTypes.array,
  defaultValue: _react2["default"].PropTypes.array,
  options: _react2["default"].PropTypes.array.isRequired,
  onChange: _react2["default"].PropTypes.func,
  onPopupVisibleChange: _react2["default"].PropTypes.func,
  popupVisible: _react2["default"].PropTypes.bool,
  disabled: _react2["default"].PropTypes.bool,
  transitionName: _react2["default"].PropTypes.string,
  popupClassName: _react2["default"].PropTypes.string,
  popupPlacement: _react2["default"].PropTypes.string,
  prefixCls: _react2["default"].PropTypes.string,
  dropdownMenuColumnStyle: _react2["default"].PropTypes.object
};

exports["default"] = Cascader;
module.exports = exports['default'];