import * as React from 'react';
import type { TreeSelectProps } from 'rc-tree-select';
import type { Placement } from 'rc-select/lib/generate';
import type { CascaderValueType, DataNode, FieldNames, ShowSearchType } from './interface';
interface BaseCascaderProps extends Omit<TreeSelectProps, 'value' | 'defaultValue' | 'filterTreeNode' | 'labelInValue' | 'loadData' | 'multiple' | 'showCheckedStrategy' | 'showSearch' | 'treeCheckable' | 'treeCheckStrictly' | 'treeDataSimpleMode' | 'treeNodeFilterProp' | 'treeNodeLabelProp' | 'treeDefaultExpandAll' | 'treeDefaultExpandedKeys' | 'treeExpandedKeys' | 'treeIcon' | 'onChange'> {
    options?: DataNode[];
    children?: React.ReactElement;
    value?: CascaderValueType | CascaderValueType[];
    defaultValue?: CascaderValueType | CascaderValueType[];
    changeOnSelect?: boolean;
    allowClear?: boolean;
    disabled?: boolean;
    fieldNames?: FieldNames;
    displayRender?: (label: React.ReactNode[], selectedOptions: DataNode[]) => React.ReactNode;
    showSearch?: boolean | ShowSearchType;
    searchValue?: string;
    onSearch?: (search: string) => void;
    /** @deprecated Use `open` instead */
    popupVisible?: boolean;
    /** @deprecated Use `dropdownClassName` instead */
    popupClassName?: string;
    dropdownClassName?: string;
    /** @deprecated Use `placement` instead */
    popupPlacement?: Placement;
    placement?: Placement;
    /** @deprecated Use `onDropdownVisibleChange` instead */
    onPopupVisibleChange?: (open: boolean) => void;
    onDropdownVisibleChange?: (open: boolean) => void;
    expandTrigger?: 'hover' | 'click';
    dropdownMenuColumnStyle?: React.CSSProperties;
    /** @private Internal usage. Do not use in your production. */
    dropdownPrefixCls?: string;
    loadData?: (selectOptions: DataNode[]) => void;
    expandIcon?: React.ReactNode;
    loadingIcon?: React.ReactNode;
}
declare type OnSingleChange = (value: CascaderValueType, selectOptions: DataNode[]) => void;
declare type OnMultipleChange = (value: CascaderValueType[], selectOptions: DataNode[][]) => void;
interface SingleCascaderProps extends BaseCascaderProps {
    checkable?: false;
    onChange?: OnSingleChange;
}
interface MultipleCascaderProps extends BaseCascaderProps {
    checkable: true | React.ReactNode;
    onChange?: OnMultipleChange;
}
export declare type CascaderProps = SingleCascaderProps | MultipleCascaderProps;
interface CascaderRef {
    focus: () => void;
    blur: () => void;
}
declare const Cascader: React.ForwardRefExoticComponent<CascaderProps & React.RefAttributes<CascaderRef>>;
export default Cascader;
