import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import * as React from 'react';
import classNames from 'classnames';
import { isLeaf } from '../util';
import CascaderContext from '../context';
import Checkbox from './Checkbox';
export default function Column(_ref) {
  var prefixCls = _ref.prefixCls,
      index = _ref.index,
      multiple = _ref.multiple,
      options = _ref.options,
      openKey = _ref.openKey,
      onSelect = _ref.onSelect,
      onOpen = _ref.onOpen,
      onToggleOpen = _ref.onToggleOpen,
      checkedSet = _ref.checkedSet,
      halfCheckedSet = _ref.halfCheckedSet,
      loadingKeys = _ref.loadingKeys;
  var menuPrefixCls = "".concat(prefixCls, "-menu");
  var menuItemPrefixCls = "".concat(prefixCls, "-menu-item");

  var _React$useContext = React.useContext(CascaderContext),
      changeOnSelect = _React$useContext.changeOnSelect,
      expandTrigger = _React$useContext.expandTrigger,
      expandIcon = _React$useContext.expandIcon,
      loadingIcon = _React$useContext.loadingIcon,
      dropdownMenuColumnStyle = _React$useContext.dropdownMenuColumnStyle;

  var hoverOpen = expandTrigger === 'hover'; // ============================ Render ============================

  return /*#__PURE__*/React.createElement("ul", {
    className: menuPrefixCls,
    role: "menu"
  }, options.map(function (option) {
    var _classNames;

    var disabled = option.disabled,
        value = option.value,
        node = option.node;
    var isMergedLeaf = isLeaf(option);
    var isLoading = loadingKeys.includes(value); // >>>>> checked

    var checked = checkedSet.has(value); // >>>>> Open

    var triggerOpenPath = function triggerOpenPath() {
      if (!disabled && (!hoverOpen || !isMergedLeaf)) {
        onOpen(index, value);
      }
    }; // >>>>> Selection


    var triggerSelect = function triggerSelect() {
      if (!disabled && (isMergedLeaf || changeOnSelect || multiple)) {
        onSelect(value, isMergedLeaf);
      }
    }; // >>>>> Title


    var title;

    if (typeof (node === null || node === void 0 ? void 0 : node.title) === 'string') {
      title = node.title;
    } else if (typeof option.title === 'string') {
      title = option.title;
    } // >>>>> Render


    return /*#__PURE__*/React.createElement("li", {
      key: value,
      className: classNames(menuItemPrefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(menuItemPrefixCls, "-expand"), !isMergedLeaf), _defineProperty(_classNames, "".concat(menuItemPrefixCls, "-active"), openKey === value), _defineProperty(_classNames, "".concat(menuItemPrefixCls, "-disabled"), disabled), _defineProperty(_classNames, "".concat(menuItemPrefixCls, "-loading"), isLoading), _classNames)),
      style: dropdownMenuColumnStyle,
      role: "menuitemcheckbox",
      title: title,
      "aria-checked": checked,
      "data-value": value,
      onClick: function onClick() {
        triggerOpenPath();

        if (!multiple || isMergedLeaf) {
          triggerSelect();
        }
      },
      onDoubleClick: function onDoubleClick() {
        if (changeOnSelect) {
          onToggleOpen(false);
        }
      },
      onMouseEnter: function onMouseEnter() {
        if (hoverOpen) {
          triggerOpenPath();
        }
      }
    }, multiple && /*#__PURE__*/React.createElement(Checkbox, {
      prefixCls: "".concat(prefixCls, "-checkbox"),
      checked: checked,
      halfChecked: halfCheckedSet.has(value),
      disabled: disabled,
      onClick: function onClick() {
        triggerSelect();
      }
    }), /*#__PURE__*/React.createElement("div", {
      className: "".concat(menuItemPrefixCls, "-content")
    }, option.title), !isLoading && expandIcon && !isMergedLeaf && /*#__PURE__*/React.createElement("div", {
      className: "".concat(menuItemPrefixCls, "-expand-icon")
    }, expandIcon), isLoading && loadingIcon && /*#__PURE__*/React.createElement("div", {
      className: "".concat(menuItemPrefixCls, "-loading-icon")
    }, loadingIcon));
  }));
}