import * as React from 'react';
/**
 * Work like `componentDidUpdate`
 */

export default function useUpdateEffect(updater, condition) {
  var prepareRef = React.useRef(true);
  React.useEffect(function () {
    if (prepareRef.current) {
      prepareRef.current = false;
      return;
    } // eslint-disable-next-line consistent-return


    return updater();
  }, condition);
}