import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import { fillFieldNames } from "rc-tree-select/es/utils/valueUtil";
var VALUE_SPLIT = '__RC_CASCADER_SPLIT__';
export { fillFieldNames };
/**
 * Convert entity back to path & options
 * @returns
 */

export function restoreCompatibleValue(entity, fieldNames) {
  var path = [];
  var options = [];
  var current = entity;

  while (current) {
    path.unshift(current.data.node[fieldNames.value]);
    options.unshift(current.data.node);
    current = current.parent;
  }

  return {
    path: path,
    options: options
  };
}
export function isLeaf(option) {
  var children = option.children,
      node = option.node;
  var leaf = node === null || node === void 0 ? void 0 : node.isLeaf;
  return leaf !== undefined ? leaf : !(children === null || children === void 0 ? void 0 : children.length);
}
/**
 * We will connect path value to a string. e.g.
 * ['little', 'bamboo'] => 'little__bamboo'
 *
 * zombieJ: It's better to deprecate the same key in the nest tree. Maybe next major version.
 */

export function connectValue(value) {
  return (value || []).join(VALUE_SPLIT);
}
/**
 * Reverse of `connectValue`
 */

export function splitValue(str) {
  return str.split(VALUE_SPLIT);
}
/**
 * Fill options with fully value by path to avoid nest entity with same value.
 * Which means we need another round to get origin node back!
 * This is slow perf on large list. We should abandon same value in nest in future.
 */

export function convertOptions(options, _ref) {
  var fieldValue = _ref.value,
      fieldChildren = _ref.children;

  function injectValue(list) {
    var parentValue = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
    return (list || []).map(function (option) {
      var _objectSpread2;

      var newValue = option[fieldValue];

      if (parentValue) {
        newValue = connectValue([parentValue, option[fieldValue]]);
      } else if (typeof newValue === 'number') {
        // Since we will convert all the value to string, we need get this
        newValue = String(newValue);
      }

      var cloneOption = _objectSpread(_objectSpread({}, option), {}, (_objectSpread2 = {}, _defineProperty(_objectSpread2, fieldValue, newValue), _defineProperty(_objectSpread2, "node", option), _objectSpread2));

      if (cloneOption[fieldChildren]) {
        cloneOption[fieldChildren] = injectValue(cloneOption[fieldChildren], newValue);
      }

      return cloneOption;
    });
  }

  return injectValue(options);
}