import * as React from 'react';
import type { OptionDataNode } from '../interface';
export interface ColumnProps {
    prefixCls: string;
    index: number;
    multiple?: boolean;
    options: OptionDataNode[];
    /** Current Column opened item key */
    openKey?: React.Key;
    onSelect: (value: React.Key, isLeaf: boolean) => void;
    onOpen: (index: number, value: React.Key) => void;
    onToggleOpen: (open: boolean) => void;
    checkedSet: Set<React.Key>;
    halfCheckedSet: Set<React.Key>;
    loadingKeys: React.Key[];
}
export default function Column({ prefixCls, index, multiple, options, openKey, onSelect, onOpen, onToggleOpen, checkedSet, halfCheckedSet, loadingKeys, }: ColumnProps): JSX.Element;
