"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useSearchResult;

var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));

var React = _interopRequireWildcard(require("react"));

var _util = require("../util");

var defaultFilter = function defaultFilter(search, options, _ref) {
  var label = _ref.label;
  return options.some(function (opt) {
    return String(opt[label]).toLowerCase().includes(search.toLowerCase());
  });
};

var defaultRender = function defaultRender(inputValue, path, prefixCls, fieldNames) {
  return path.map(function (opt) {
    return opt[fieldNames.label];
  }).join(' / ');
};

function useSearchResult(resultConfig) {
  var searchConfig = resultConfig.searchConfig,
      flattenOptions = resultConfig.flattenOptions,
      fieldNames = resultConfig.fieldNames,
      changeOnSelect = resultConfig.changeOnSelect,
      searchValue = resultConfig.searchValue,
      prefixCls = resultConfig.prefixCls; // ============================== MISC ==============================

  var filterOption = searchConfig.filter || defaultFilter;
  var renderOption = searchConfig.render || defaultRender; // ============================= Filter =============================
  // Do filter

  var filteredEntityList = React.useMemo(function () {
    if (!searchValue) {
      return [];
    } // Normalize list


    var normalizeList = flattenOptions.map(function (option) {
      var _restoreCompatibleVal = (0, _util.restoreCompatibleValue)(option, fieldNames),
          options = _restoreCompatibleVal.options;

      var originOptionList = options.map(function (opt) {
        return opt.node;
      });
      return {
        option: option,
        originOptionList: originOptionList
      };
    }); // Not keep parent node when !changeOnSelect

    if (!changeOnSelect) {
      normalizeList = normalizeList.filter(function (_ref2) {
        var option = _ref2.option;
        return (0, _util.isLeaf)(option.data);
      });
    } // Filter


    var filteredList = [];

    for (var i = 0; i < normalizeList.length; i += 1) {
      // Perf saving if enabled
      if (!searchConfig.sort && filteredList.length >= searchConfig.limit) {
        break;
      } // Do filter


      var optGrp = normalizeList[i];

      if (filterOption(searchValue, optGrp.originOptionList, fieldNames)) {
        filteredList.push(optGrp);
      }
    } // Sort: When searchConfig.sort is enabled. We have to filter all the list


    if (searchConfig.sort) {
      filteredList.sort(function (a, b) {
        return searchConfig.sort(a.originOptionList, b.originOptionList, searchValue, fieldNames);
      });
    }

    return filteredList;
  }, [flattenOptions, fieldNames, searchValue, filterOption, changeOnSelect, searchConfig]); // ======================== Generate Options ========================
  // Wrap with connected label

  var options = React.useMemo(function () {
    return filteredEntityList.map(function (_ref3) {
      var option = _ref3.option,
          originOptionList = _ref3.originOptionList;
      var title = renderOption(searchValue, originOptionList, prefixCls, fieldNames);
      return (0, _objectSpread2.default)((0, _objectSpread2.default)({}, option.data), {}, {
        title: title
      });
    });
  }, [searchValue, renderOption, filteredEntityList, fieldNames, prefixCls]);
  return options;
}