"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useUpdateEffect;

var React = _interopRequireWildcard(require("react"));

/**
 * Work like `componentDidUpdate`
 */
function useUpdateEffect(updater, condition) {
  var prepareRef = React.useRef(true);
  React.useEffect(function () {
    if (prepareRef.current) {
      prepareRef.current = false;
      return;
    } // eslint-disable-next-line consistent-return


    return updater();
  }, condition);
}