/// <reference types="react" />
import type { FlattenDataNode } from 'rc-tree-select/lib/interface';
import { fillFieldNames } from 'rc-tree-select/lib/utils/valueUtil';
import type { CascaderValueType, DataNode, FieldNames, InternalDataNode, OptionDataNode } from './interface';
export { fillFieldNames };
/**
 * Convert entity back to path & options
 * @returns
 */
export declare function restoreCompatibleValue(entity: FlattenDataNode, fieldNames: FieldNames): {
    path: CascaderValueType;
    options: InternalDataNode[];
};
export declare function isLeaf(option: OptionDataNode): boolean;
/**
 * We will connect path value to a string. e.g.
 * ['little', 'bamboo'] => 'little__bamboo'
 *
 * zombieJ: It's better to deprecate the same key in the nest tree. Maybe next major version.
 */
export declare function connectValue(value: React.Key[]): string;
/**
 * Reverse of `connectValue`
 */
export declare function splitValue(str: string): string[];
/**
 * Fill options with fully value by path to avoid nest entity with same value.
 * Which means we need another round to get origin node back!
 * This is slow perf on large list. We should abandon same value in nest in future.
 */
export declare function convertOptions(options: DataNode[], { value: fieldValue, children: fieldChildren }: FieldNames): InternalDataNode[];
