import type { BaseSelectPropsWithoutPrivate, BaseSelectRef } from 'rc-select';
import type { Placement } from 'rc-select/lib/BaseSelect';
import * as React from 'react';
import { SHOW_CHILD, SHOW_PARENT } from './utils/commonUtil';
export interface ShowSearchType<OptionType extends BaseOptionType = DefaultOptionType> {
    filter?: (inputValue: string, options: OptionType[], fieldNames: FieldNames) => boolean;
    render?: (inputValue: string, path: OptionType[], prefixCls: string, fieldNames: FieldNames) => React.ReactNode;
    sort?: (a: OptionType[], b: OptionType[], inputValue: string, fieldNames: FieldNames) => number;
    matchInputWidth?: boolean;
    limit?: number | false;
}
export interface FieldNames {
    label?: string;
    value?: string;
    children?: string;
}
export interface InternalFieldNames extends Required<FieldNames> {
    key: string;
}
export type SingleValueType = (string | number)[];
export type ValueType = SingleValueType | SingleValueType[];
export type ShowCheckedStrategy = typeof SHOW_PARENT | typeof SHOW_CHILD;
export interface BaseOptionType {
    disabled?: boolean;
    [name: string]: any;
}
export interface DefaultOptionType extends BaseOptionType {
    label: React.ReactNode;
    value?: string | number | null;
    children?: DefaultOptionType[];
}
interface BaseCascaderProps<OptionType extends BaseOptionType = DefaultOptionType> extends Omit<BaseSelectPropsWithoutPrivate, 'tokenSeparators' | 'labelInValue' | 'mode' | 'showSearch'> {
    id?: string;
    prefixCls?: string;
    fieldNames?: FieldNames;
    children?: React.ReactElement;
    value?: ValueType;
    defaultValue?: ValueType;
    changeOnSelect?: boolean;
    displayRender?: (label: string[], selectedOptions?: OptionType[]) => React.ReactNode;
    checkable?: boolean | React.ReactNode;
    showCheckedStrategy?: ShowCheckedStrategy;
    showSearch?: boolean | ShowSearchType<OptionType>;
    searchValue?: string;
    onSearch?: (value: string) => void;
    expandTrigger?: 'hover' | 'click';
    options?: OptionType[];
    /** @private Internal usage. Do not use in your production. */
    dropdownPrefixCls?: string;
    loadData?: (selectOptions: OptionType[]) => void;
    /** @deprecated Use `open` instead */
    popupVisible?: boolean;
    /** @deprecated Use `dropdownClassName` instead */
    popupClassName?: string;
    dropdownClassName?: string;
    dropdownMenuColumnStyle?: React.CSSProperties;
    /** @deprecated Use `placement` instead */
    popupPlacement?: Placement;
    placement?: Placement;
    /** @deprecated Use `onDropdownVisibleChange` instead */
    onPopupVisibleChange?: (open: boolean) => void;
    onDropdownVisibleChange?: (open: boolean) => void;
    expandIcon?: React.ReactNode;
    loadingIcon?: React.ReactNode;
}
type OnSingleChange<OptionType> = (value: SingleValueType, selectOptions: OptionType[]) => void;
type OnMultipleChange<OptionType> = (value: SingleValueType[], selectOptions: OptionType[][]) => void;
export interface SingleCascaderProps<OptionType extends BaseOptionType = DefaultOptionType> extends BaseCascaderProps<OptionType> {
    checkable?: false;
    onChange?: OnSingleChange<OptionType>;
}
export interface MultipleCascaderProps<OptionType extends BaseOptionType = DefaultOptionType> extends BaseCascaderProps<OptionType> {
    checkable: true | React.ReactNode;
    onChange?: OnMultipleChange<OptionType>;
}
export type CascaderProps<OptionType extends BaseOptionType = DefaultOptionType> = SingleCascaderProps<OptionType> | MultipleCascaderProps<OptionType>;
export type InternalCascaderProps<OptionType extends BaseOptionType = DefaultOptionType> = Omit<SingleCascaderProps<OptionType> | MultipleCascaderProps<OptionType>, 'onChange'> & {
    onChange?: (value: SingleValueType | SingleValueType[], selectOptions: OptionType[] | OptionType[][]) => void;
};
export type CascaderRef = Omit<BaseSelectRef, 'scrollTo'>;
declare const Cascader: (<OptionType extends DefaultOptionType | BaseOptionType = DefaultOptionType>(props: React.PropsWithChildren<CascaderProps<OptionType>> & {
    ref?: React.Ref<BaseSelectRef>;
}) => React.ReactElement) & {
    displayName?: string;
    SHOW_PARENT: typeof SHOW_PARENT;
    SHOW_CHILD: typeof SHOW_CHILD;
};
export default Cascader;
