import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _classCallCheck from "@babel/runtime/helpers/esm/classCallCheck";
import _createClass from "@babel/runtime/helpers/esm/createClass";
import _inherits from "@babel/runtime/helpers/esm/inherits";
import _createSuper from "@babel/runtime/helpers/esm/createSuper";

/* eslint-disable react/prop-types */
import * as React from 'react';
import classNames from 'classnames';
import CSSMotion from 'rc-motion';
import shallowEqual from 'shallowequal';
import PanelContent from './PanelContent';

var CollapsePanel = /*#__PURE__*/function (_React$Component) {
  _inherits(CollapsePanel, _React$Component);

  var _super = _createSuper(CollapsePanel);

  function CollapsePanel() {
    var _this;

    _classCallCheck(this, CollapsePanel);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _this.handleItemClick = function () {
      var _this$props = _this.props,
          onItemClick = _this$props.onItemClick,
          panelKey = _this$props.panelKey;

      if (typeof onItemClick === 'function') {
        onItemClick(panelKey);
      }
    };

    _this.handleKeyPress = function (e) {
      if (e.key === 'Enter' || e.keyCode === 13 || e.which === 13) {
        _this.handleItemClick();
      }
    };

    return _this;
  }

  _createClass(CollapsePanel, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      return !shallowEqual(this.props, nextProps);
    }
  }, {
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _this2 = this;

      var _this$props2 = this.props,
          className = _this$props2.className,
          id = _this$props2.id,
          style = _this$props2.style,
          prefixCls = _this$props2.prefixCls,
          header = _this$props2.header,
          headerClass = _this$props2.headerClass,
          children = _this$props2.children,
          isActive = _this$props2.isActive,
          showArrow = _this$props2.showArrow,
          destroyInactivePanel = _this$props2.destroyInactivePanel,
          accordion = _this$props2.accordion,
          forceRender = _this$props2.forceRender,
          openMotion = _this$props2.openMotion,
          expandIcon = _this$props2.expandIcon,
          extra = _this$props2.extra,
          collapsible = _this$props2.collapsible;
      var disabled = collapsible === 'disabled';
      var headerCls = classNames("".concat(prefixCls, "-header"), (_classNames = {}, _defineProperty(_classNames, headerClass, headerClass), _defineProperty(_classNames, "".concat(prefixCls, "-header-collapsible-only"), collapsible === 'header'), _classNames));
      var itemCls = classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls, "-item"), true), _defineProperty(_classNames2, "".concat(prefixCls, "-item-active"), isActive), _defineProperty(_classNames2, "".concat(prefixCls, "-item-disabled"), disabled), _classNames2), className);
      var icon = /*#__PURE__*/React.createElement("i", {
        className: "arrow"
      });

      if (showArrow && typeof expandIcon === 'function') {
        icon = expandIcon(this.props);
      }

      var ifExtraExist = extra !== null && extra !== undefined && typeof extra !== 'boolean';
      return /*#__PURE__*/React.createElement("div", {
        className: itemCls,
        style: style,
        id: id
      }, /*#__PURE__*/React.createElement("div", {
        className: headerCls,
        onClick: function onClick() {
          return collapsible !== 'header' && _this2.handleItemClick();
        },
        role: accordion ? 'tab' : 'button',
        tabIndex: disabled ? -1 : 0,
        "aria-expanded": isActive,
        onKeyPress: this.handleKeyPress
      }, showArrow && icon, collapsible === 'header' ? /*#__PURE__*/React.createElement("span", {
        onClick: this.handleItemClick,
        className: "".concat(prefixCls, "-header-text")
      }, header) : header, ifExtraExist && /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefixCls, "-extra")
      }, extra)), /*#__PURE__*/React.createElement(CSSMotion, _extends({
        visible: isActive,
        leavedClassName: "".concat(prefixCls, "-content-hidden")
      }, openMotion, {
        forceRender: forceRender,
        removeOnLeave: destroyInactivePanel
      }), function (_ref, ref) {
        var motionClassName = _ref.className,
            motionStyle = _ref.style;
        return /*#__PURE__*/React.createElement(PanelContent, {
          ref: ref,
          prefixCls: prefixCls,
          className: motionClassName,
          style: motionStyle,
          isActive: isActive,
          forceRender: forceRender,
          role: accordion ? 'tabpanel' : null
        }, children);
      }));
    }
  }]);

  return CollapsePanel;
}(React.Component);

CollapsePanel.defaultProps = {
  showArrow: true,
  isActive: false,
  onItemClick: function onItemClick() {},
  headerClass: '',
  forceRender: false
};
export default CollapsePanel;