"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard");

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _createSuper2 = _interopRequireDefault(require("@babel/runtime/helpers/createSuper"));

var React = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _rcMotion = _interopRequireDefault(require("rc-motion"));

var _shallowequal = _interopRequireDefault(require("shallowequal"));

var _PanelContent = _interopRequireDefault(require("./PanelContent"));

/* eslint-disable react/prop-types */
var CollapsePanel = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(CollapsePanel, _React$Component);

  var _super = (0, _createSuper2.default)(CollapsePanel);

  function CollapsePanel() {
    var _this;

    (0, _classCallCheck2.default)(this, CollapsePanel);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _this.handleItemClick = function () {
      var _this$props = _this.props,
          onItemClick = _this$props.onItemClick,
          panelKey = _this$props.panelKey;

      if (typeof onItemClick === 'function') {
        onItemClick(panelKey);
      }
    };

    _this.handleKeyPress = function (e) {
      if (e.key === 'Enter' || e.keyCode === 13 || e.which === 13) {
        _this.handleItemClick();
      }
    };

    return _this;
  }

  (0, _createClass2.default)(CollapsePanel, [{
    key: "shouldComponentUpdate",
    value: function shouldComponentUpdate(nextProps) {
      return !(0, _shallowequal.default)(this.props, nextProps);
    }
  }, {
    key: "render",
    value: function render() {
      var _classNames,
          _classNames2,
          _this2 = this;

      var _this$props2 = this.props,
          className = _this$props2.className,
          id = _this$props2.id,
          style = _this$props2.style,
          prefixCls = _this$props2.prefixCls,
          header = _this$props2.header,
          headerClass = _this$props2.headerClass,
          children = _this$props2.children,
          isActive = _this$props2.isActive,
          showArrow = _this$props2.showArrow,
          destroyInactivePanel = _this$props2.destroyInactivePanel,
          accordion = _this$props2.accordion,
          forceRender = _this$props2.forceRender,
          openMotion = _this$props2.openMotion,
          expandIcon = _this$props2.expandIcon,
          extra = _this$props2.extra,
          collapsible = _this$props2.collapsible;
      var disabled = collapsible === 'disabled';
      var headerCls = (0, _classnames.default)("".concat(prefixCls, "-header"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, headerClass, headerClass), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-header-collapsible-only"), collapsible === 'header'), _classNames));
      var itemCls = (0, _classnames.default)((_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-item"), true), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-item-active"), isActive), (0, _defineProperty2.default)(_classNames2, "".concat(prefixCls, "-item-disabled"), disabled), _classNames2), className);
      var icon = /*#__PURE__*/React.createElement("i", {
        className: "arrow"
      });

      if (showArrow && typeof expandIcon === 'function') {
        icon = expandIcon(this.props);
      }

      var ifExtraExist = extra !== null && extra !== undefined && typeof extra !== 'boolean';
      return /*#__PURE__*/React.createElement("div", {
        className: itemCls,
        style: style,
        id: id
      }, /*#__PURE__*/React.createElement("div", {
        className: headerCls,
        onClick: function onClick() {
          return collapsible !== 'header' && _this2.handleItemClick();
        },
        role: accordion ? 'tab' : 'button',
        tabIndex: disabled ? -1 : 0,
        "aria-expanded": isActive,
        onKeyPress: this.handleKeyPress
      }, showArrow && icon, collapsible === 'header' ? /*#__PURE__*/React.createElement("span", {
        onClick: this.handleItemClick,
        className: "".concat(prefixCls, "-header-text")
      }, header) : header, ifExtraExist && /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefixCls, "-extra")
      }, extra)), /*#__PURE__*/React.createElement(_rcMotion.default, (0, _extends2.default)({
        visible: isActive,
        leavedClassName: "".concat(prefixCls, "-content-hidden")
      }, openMotion, {
        forceRender: forceRender,
        removeOnLeave: destroyInactivePanel
      }), function (_ref, ref) {
        var motionClassName = _ref.className,
            motionStyle = _ref.style;
        return /*#__PURE__*/React.createElement(_PanelContent.default, {
          ref: ref,
          prefixCls: prefixCls,
          className: motionClassName,
          style: motionStyle,
          isActive: isActive,
          forceRender: forceRender,
          role: accordion ? 'tabpanel' : null
        }, children);
      }));
    }
  }]);
  return CollapsePanel;
}(React.Component);

CollapsePanel.defaultProps = {
  showArrow: true,
  isActive: false,
  onItemClick: function onItemClick() {},
  headerClass: '',
  forceRender: false
};
var _default = CollapsePanel;
exports.default = _default;