import _slicedToArray from '@babel/runtime/helpers/esm/slicedToArray';
import _toConsumableArray from '@babel/runtime/helpers/esm/toConsumableArray';
import _typeof from '@babel/runtime/helpers/esm/typeof';
import classNames from 'classnames';
import toArray from 'rc-util/es/Children/toArray';
import useMergedState from 'rc-util/es/hooks/useMergedState';
import React from 'react';
import CollapsePanel from './Panel';
function getActiveKeysArray(activeKey) {
  var currentActiveKey = activeKey;
  if (!Array.isArray(currentActiveKey)) {
    var activeKeyType = _typeof(currentActiveKey);
    currentActiveKey =
      activeKeyType === 'number' || activeKeyType === 'string' ? [currentActiveKey] : [];
  }
  return currentActiveKey.map(function (key) {
    return String(key);
  });
}
var Collapse = /*#__PURE__*/ React.forwardRef(function (props, ref) {
  var _props$prefixCls = props.prefixCls,
    prefixCls = _props$prefixCls === void 0 ? 'rc-collapse' : _props$prefixCls,
    _props$destroyInactiv = props.destroyInactivePanel,
    destroyInactivePanel = _props$destroyInactiv === void 0 ? false : _props$destroyInactiv,
    style = props.style,
    accordion = props.accordion,
    className = props.className,
    rawChildren = props.children,
    collapsible = props.collapsible,
    openMotion = props.openMotion,
    expandIcon = props.expandIcon,
    rawActiveKey = props.activeKey,
    defaultActiveKey = props.defaultActiveKey,
    _onChange = props.onChange;
  var collapseClassName = classNames(prefixCls, className);
  var _useMergedState = useMergedState([], {
      value: rawActiveKey,
      onChange: function onChange(v) {
        return _onChange === null || _onChange === void 0 ? void 0 : _onChange(v);
      },
      defaultValue: defaultActiveKey,
      postState: getActiveKeysArray,
    }),
    _useMergedState2 = _slicedToArray(_useMergedState, 2),
    activeKey = _useMergedState2[0],
    setActiveKey = _useMergedState2[1];
  var onClickItem = function onClickItem(key) {
    return setActiveKey(function () {
      if (accordion) {
        return activeKey[0] === key ? [] : [key];
      }
      var index = activeKey.indexOf(key);
      var isActive = index > -1;
      if (isActive) {
        return activeKey.filter(function (item) {
          return item !== key;
        });
      }
      return [].concat(_toConsumableArray(activeKey), [key]);
    });
  };

  // ======================== Children ========================
  var getNewChild = function getNewChild(child, index) {
    if (!child) return null;
    var key = child.key || String(index);
    var _child$props = child.props,
      header = _child$props.header,
      headerClass = _child$props.headerClass,
      childDestroyInactivePanel = _child$props.destroyInactivePanel,
      childCollapsible = _child$props.collapsible,
      childOnItemClick = _child$props.onItemClick;
    var isActive = false;
    if (accordion) {
      isActive = activeKey[0] === key;
    } else {
      isActive = activeKey.indexOf(key) > -1;
    }
    var mergeCollapsible =
      childCollapsible !== null && childCollapsible !== void 0 ? childCollapsible : collapsible;
    var handleItemClick = function handleItemClick(value) {
      if (mergeCollapsible === 'disabled') return;
      onClickItem(value);
      childOnItemClick === null || childOnItemClick === void 0 ? void 0 : childOnItemClick(value);
    };
    var childProps = {
      key: key,
      panelKey: key,
      header: header,
      headerClass: headerClass,
      isActive: isActive,
      prefixCls: prefixCls,
      destroyInactivePanel:
        childDestroyInactivePanel !== null && childDestroyInactivePanel !== void 0
          ? childDestroyInactivePanel
          : destroyInactivePanel,
      openMotion: openMotion,
      accordion: accordion,
      children: child.props.children,
      onItemClick: handleItemClick,
      expandIcon: expandIcon,
      collapsible: mergeCollapsible,
    };

    // https://github.com/ant-design/ant-design/issues/20479
    if (typeof child.type === 'string') {
      return child;
    }
    Object.keys(childProps).forEach(function (propName) {
      if (typeof childProps[propName] === 'undefined') {
        delete childProps[propName];
      }
    });
    return /*#__PURE__*/ React.cloneElement(child, childProps);
  };
  var children = toArray(rawChildren).map(getNewChild);

  // ======================== Render ========================
  return /*#__PURE__*/ React.createElement(
    'div',
    {
      ref: ref,
      className: collapseClassName,
      style: style,
      role: accordion ? 'tablist' : undefined,
    },
    children,
  );
});
export default Object.assign(Collapse, {
  Panel: CollapsePanel,
});
