"use strict";

var _interopRequireWildcard = require("@babel/runtime/helpers/interopRequireWildcard").default;

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault").default;

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = useDom;

var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var React = _interopRequireWildcard(require("react"));

var _useLayoutEffect = _interopRequireDefault(require("rc-util/lib/hooks/useLayoutEffect"));

var _canUseDom = _interopRequireDefault(require("rc-util/lib/Dom/canUseDom"));

var _Context = _interopRequireDefault(require("./Context"));

var EMPTY_LIST = [];
/**
 * Will add `div` to document. Nest call will keep order
 * @param render Render DOM in document
 */

function useDom(render, debug) {
  var _React$useState = React.useState(function () {
    if (!(0, _canUseDom.default)()) {
      return null;
    }

    var defaultEle = document.createElement('div');

    if (process.env.NODE_ENV !== 'production' && debug) {
      defaultEle.setAttribute('data-debug', debug);
    }

    return defaultEle;
  }),
      _React$useState2 = (0, _slicedToArray2.default)(_React$useState, 1),
      ele = _React$useState2[0]; // ========================== Order ==========================


  var appendedRef = React.useRef(false);
  var queueCreate = React.useContext(_Context.default);

  var _React$useState3 = React.useState(EMPTY_LIST),
      _React$useState4 = (0, _slicedToArray2.default)(_React$useState3, 2),
      queue = _React$useState4[0],
      setQueue = _React$useState4[1];

  var mergedQueueCreate = queueCreate || (appendedRef.current ? undefined : function (appendFn) {
    setQueue(function (origin) {
      var newQueue = [appendFn].concat((0, _toConsumableArray2.default)(origin));
      return newQueue;
    });
  }); // =========================== DOM ===========================

  function append() {
    if (!ele.parentElement) {
      document.body.appendChild(ele);
    }

    appendedRef.current = true;
  }

  function cleanup() {
    var _ele$parentElement;

    (_ele$parentElement = ele.parentElement) === null || _ele$parentElement === void 0 ? void 0 : _ele$parentElement.removeChild(ele);
    appendedRef.current = false;
  }

  (0, _useLayoutEffect.default)(function () {
    if (render) {
      if (queueCreate) {
        queueCreate(append);
      } else {
        append();
      }
    } else {
      cleanup();
    }

    return cleanup;
  }, [render]);
  (0, _useLayoutEffect.default)(function () {
    if (queue.length) {
      queue.forEach(function (appendFn) {
        return appendFn();
      });
      setQueue(EMPTY_LIST);
    }
  }, [queue]);
  return [ele, mergedQueueCreate];
}