/// <reference types="react" />
import * as React from 'react';
import IDialogPropTypes from './IDialogPropTypes';
export default class Dialog extends React.Component<IDialogPropTypes, any> {
    static defaultProps: {
        className: string;
        mask: boolean;
        visible: boolean;
        keyboard: boolean;
        closable: boolean;
        maskClosable: boolean;
        destroyOnClose: boolean;
        prefixCls: string;
    };
    private inTransition;
    private titleId;
    private openTime;
    private lastOutSideFocusNode;
    private wrap;
    private dialog;
    private sentinel;
    private bodyIsOverflowing;
    private scrollbarWidth;
    componentWillMount(): void;
    componentDidMount(): void;
    componentDidUpdate(prevProps: IDialogPropTypes): void;
    componentWillUnmount(): void;
    onAnimateLeave: () => void;
    onMaskClick: (e: React.MouseEvent<HTMLDivElement>) => void;
    onKeyDown: (e: React.KeyboardEvent<HTMLDivElement>) => void;
    getDialogElement: () => JSX.Element;
    getZIndexStyle: () => any;
    getWrapStyle: () => any;
    getMaskStyle: () => any;
    getMaskElement: () => JSX.Element | undefined;
    getMaskTransitionName: () => string | undefined;
    getTransitionName: () => string | undefined;
    setScrollbar: () => void;
    addScrollingEffect: () => void;
    removeScrollingEffect: () => void;
    close: (e: any) => void;
    checkScrollbar: () => void;
    resetScrollbar: () => void;
    adjustDialog: () => void;
    resetAdjustments: () => void;
    saveRef: (name: string) => (node: any) => void;
    render(): JSX.Element;
}
