'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _defineProperty2 = require('babel-runtime/helpers/defineProperty');

var _defineProperty3 = _interopRequireDefault(_defineProperty2);

var _classCallCheck2 = require('babel-runtime/helpers/classCallCheck');

var _classCallCheck3 = _interopRequireDefault(_classCallCheck2);

var _createClass2 = require('babel-runtime/helpers/createClass');

var _createClass3 = _interopRequireDefault(_createClass2);

var _possibleConstructorReturn2 = require('babel-runtime/helpers/possibleConstructorReturn');

var _possibleConstructorReturn3 = _interopRequireDefault(_possibleConstructorReturn2);

var _inherits2 = require('babel-runtime/helpers/inherits');

var _inherits3 = _interopRequireDefault(_inherits2);

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _classnames2 = require('classnames');

var _classnames3 = _interopRequireDefault(_classnames2);

var _ContainerRender = require('rc-util/lib/ContainerRender');

var _ContainerRender2 = _interopRequireDefault(_ContainerRender);

var _getScrollBarSize = require('rc-util/lib/getScrollBarSize');

var _getScrollBarSize2 = _interopRequireDefault(_getScrollBarSize);

var _utils = require('./utils');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var IS_REACT_16 = 'createPortal' in _reactDom2['default'];

var currentDrawer = {};
var windowIsUndefined = !(typeof window !== 'undefined' && window.document && window.document.createElement);

var Drawer = function (_React$PureComponent) {
  (0, _inherits3['default'])(Drawer, _React$PureComponent);

  function Drawer(props) {
    (0, _classCallCheck3['default'])(this, Drawer);

    var _this = (0, _possibleConstructorReturn3['default'])(this, (Drawer.__proto__ || Object.getPrototypeOf(Drawer)).call(this, props));

    _initialiseProps.call(_this);

    _this.levelDom = [];
    _this.contentDom = null;
    _this.maskDom = null;
    _this.handlerdom = null;
    _this.firstEnter = props.firstEnter; // 记录首次进入.
    _this.timeout = null;
    _this.drawerId = Number((Date.now() + Math.random()).toString().replace('.', Math.round(Math.random() * 9))).toString(16);
    var open = props.open !== undefined ? props.open : !!props.defaultOpen;
    currentDrawer[_this.drawerId] = open;
    _this.state = {
      open: open
    };
    return _this;
  }

  (0, _createClass3['default'])(Drawer, [{
    key: 'componentDidMount',
    value: function componentDidMount() {
      if (!windowIsUndefined) {
        var passiveSupported = false;
        window.addEventListener('test', null, Object.defineProperty({}, 'passive', {
          get: function get() {
            passiveSupported = true;
            return null;
          }
        }));
        this.passive = passiveSupported ? { passive: false } : false;
      }
      var open = this.getOpen();
      if (this.props.handler || open || this.firstEnter) {
        this.getDefault(this.props);
        if (open) {
          this.isOpenChange = true;
        }
        this.forceUpdate();
      }
    }
  }, {
    key: 'componentWillReceiveProps',
    value: function componentWillReceiveProps(nextProps) {
      var open = nextProps.open,
          placement = nextProps.placement;

      if (open !== undefined && open !== this.props.open) {
        this.isOpenChange = true;
        // 没渲染 dom 时，获取默认数据;
        if (!this.container) {
          this.getDefault(nextProps);
        }
        this.setState({
          open: open
        });
      }
      if (placement !== this.props.placement) {
        // test 的 bug, 有动画过场，删除 dom
        this.contentDom = null;
      }
      if (this.props.level !== nextProps.level) {
        this.getParentAndLevelDom(nextProps);
      }
    }
  }, {
    key: 'componentDidUpdate',
    value: function componentDidUpdate() {
      // dom 没渲染时，重走一遍。
      if (!this.firstEnter && this.container) {
        this.forceUpdate();
        this.firstEnter = true;
      }
    }
  }, {
    key: 'componentWillUnmount',
    value: function componentWillUnmount() {
      delete currentDrawer[this.drawerId];
      delete this.isOpenChange;
      if (this.container) {
        if (this.state.open) {
          this.setLevelDomTransform(false, true);
        }
        document.body.style.overflow = '';
        // 拦不住。。直接删除；
        if (this.props.getContainer) {
          this.container.parentNode.removeChild(this.container);
        }
      }
      this.firstEnter = false;
      clearTimeout(this.timeout);
      // suppport react15
      // 需要 didmount 后也会渲染，直接 unmount 将不会渲染，加上判断.
      if (this.renderComponent && !IS_REACT_16) {
        this.renderComponent({
          afterClose: this.removeContainer,
          onClose: function onClose() {},

          visible: false
        });
      }
    }
  }, {
    key: 'render',
    value: function render() {
      var _this2 = this;

      var _props = this.props,
          getContainer = _props.getContainer,
          wrapperClassName = _props.wrapperClassName;

      var open = this.getOpen();
      currentDrawer[this.drawerId] = open ? this.container : open;
      var children = this.getChildToRender(this.firstEnter ? open : false);
      if (!getContainer) {
        return _react2['default'].createElement(
          'div',
          {
            className: wrapperClassName,
            ref: function ref(c) {
              _this2.container = c;
            }
          },
          children
        );
      }
      if (!this.container || !open && !this.firstEnter) {
        return null;
      }
      // suppport react15
      if (!IS_REACT_16) {
        return _react2['default'].createElement(
          _ContainerRender2['default'],
          {
            parent: this,
            visible: true,
            autoMount: true,
            autoDestroy: false,
            getComponent: function getComponent() {
              return children;
            },
            getContainer: this.getContainer
          },
          function (_ref) {
            var renderComponent = _ref.renderComponent,
                removeContainer = _ref.removeContainer;

            _this2.renderComponent = renderComponent;
            _this2.removeContainer = removeContainer;
            return null;
          }
        );
      }
      return _reactDom2['default'].createPortal(children, this.container);
    }
  }]);
  return Drawer;
}(_react2['default'].PureComponent);

Drawer.defaultProps = {
  prefixCls: 'drawer',
  placement: 'left',
  getContainer: 'body',
  level: 'all',
  duration: '.3s',
  ease: 'cubic-bezier(0.78, 0.14, 0.15, 0.86)',
  onChange: function onChange() {},
  onMaskClick: function onMaskClick() {},
  onHandleClick: function onHandleClick() {},
  handler: _react2['default'].createElement(
    'div',
    { className: 'drawer-handle' },
    _react2['default'].createElement('i', { className: 'drawer-handle-icon' })
  ),
  firstEnter: false,
  showMask: true,
  maskStyle: {},
  wrapperClassName: '',
  className: ''
};

var _initialiseProps = function _initialiseProps() {
  var _this3 = this;

  this.onMaskTouchEnd = function (e) {
    _this3.props.onMaskClick(e);
    _this3.onTouchEnd(e, true);
  };

  this.onIconTouchEnd = function (e) {
    _this3.props.onHandleClick(e);
    _this3.onTouchEnd(e);
  };

  this.onTouchEnd = function (e, close) {
    if (_this3.props.open !== undefined) {
      return;
    }
    var open = close || _this3.state.open;
    _this3.isOpenChange = true;
    _this3.setState({
      open: !open
    });
  };

  this.onWrapperTransitionEnd = function (e) {
    if (e.target === _this3.contentWrapper) {
      _this3.dom.style.transition = '';
      if (!_this3.state.open && _this3.getCurrentDrawerSome()) {
        document.body.style.overflowX = '';
        if (_this3.maskDom) {
          _this3.maskDom.style.left = '';
          _this3.maskDom.style.width = '';
        }
      }
    }
  };

  this.getDefault = function (props) {
    _this3.getParentAndLevelDom(props);
    if (props.getContainer || props.parent) {
      _this3.container = _this3.defaultGetContainer();
    }
  };

  this.getCurrentDrawerSome = function () {
    return !Object.keys(currentDrawer).some(function (key) {
      return currentDrawer[key];
    });
  };

  this.getContainer = function () {
    return _this3.container;
  };

  this.getParentAndLevelDom = function (props) {
    if (windowIsUndefined) {
      return;
    }
    var level = props.level,
        getContainer = props.getContainer;

    _this3.levelDom = [];
    if (getContainer) {
      if (typeof getContainer === 'string') {
        var dom = document.querySelectorAll(getContainer)[0];
        _this3.parent = dom;
      }
      if (typeof getContainer === 'function') {
        _this3.parent = getContainer();
      }
      if (typeof getContainer === 'object' && getContainer instanceof window.HTMLElement) {
        _this3.parent = getContainer;
      }
    }
    if (!getContainer && _this3.container) {
      _this3.parent = _this3.container.parentNode;
    }
    if (level === 'all') {
      var children = Array.prototype.slice.call(_this3.parent.children);
      children.forEach(function (child) {
        if (child.nodeName !== 'SCRIPT' && child.nodeName !== 'STYLE' && child.nodeName !== 'LINK' && child !== _this3.container) {
          _this3.levelDom.push(child);
        }
      });
    } else if (level) {
      (0, _utils.dataToArray)(level).forEach(function (key) {
        document.querySelectorAll(key).forEach(function (item) {
          _this3.levelDom.push(item);
        });
      });
    }
  };

  this.setLevelDomTransform = function (open, openTransition, placementName, value) {
    var _props2 = _this3.props,
        placement = _props2.placement,
        levelMove = _props2.levelMove,
        duration = _props2.duration,
        ease = _props2.ease,
        onChange = _props2.onChange,
        getContainer = _props2.getContainer;

    if (!windowIsUndefined) {
      _this3.levelDom.forEach(function (dom) {
        if (_this3.isOpenChange || openTransition) {
          /* eslint no-param-reassign: "error" */
          dom.style.transition = 'transform ' + duration + ' ' + ease;
          (0, _utils.addEventListener)(dom, _utils.transitionEnd, _this3.transitionEnd);
          var levelValue = open ? value : 0;
          if (levelMove) {
            var $levelMove = (0, _utils.transformArguments)(levelMove, { target: dom, open: open });
            levelValue = open ? $levelMove[0] : $levelMove[1] || 0;
          }
          var $value = typeof levelValue === 'number' ? levelValue + 'px' : levelValue;
          var placementPos = placement === 'left' || placement === 'top' ? $value : '-' + $value;
          dom.style.transform = levelValue ? placementName + '(' + placementPos + ')' : '';
          dom.style.msTransform = levelValue ? placementName + '(' + placementPos + ')' : '';
        }
      });
      // 处理 body 滚动
      if (getContainer === 'body') {
        var eventArray = ['touchstart'];
        var domArray = [document.body, _this3.maskDom, _this3.handlerdom, _this3.contentDom];
        var right = document.body.scrollHeight > (window.innerHeight || document.documentElement.clientHeight) && window.innerWidth > document.body.offsetWidth ? (0, _getScrollBarSize2['default'])(1) : 0;
        var widthTransition = 'width ' + duration + ' ' + ease;
        var trannsformTransition = 'transform ' + duration + ' ' + ease;
        if (open && document.body.style.overflow !== 'hidden') {
          document.body.style.overflow = 'hidden';
          if (right) {
            document.body.style.position = 'relative';
            document.body.style.width = 'calc(100% - ' + right + 'px)';
            _this3.dom.style.transition = 'none';
            switch (placement) {
              case 'right':
                _this3.dom.style.transform = 'translateX(-' + right + 'px)';
                _this3.dom.style.msTransform = 'translateX(-' + right + 'px)';
                break;
              case 'top':
              case 'bottom':
                _this3.dom.style.width = 'calc(100% - ' + right + 'px)';
                _this3.dom.style.transform = 'translateZ(0)';
                break;
              default:
                break;
            }
            clearTimeout(_this3.timeout);
            _this3.timeout = setTimeout(function () {
              _this3.dom.style.transition = trannsformTransition + ',' + widthTransition;
              _this3.dom.style.width = '';
              _this3.dom.style.transform = '';
              _this3.dom.style.msTransform = '';
            });
          }
          // 手机禁滚
          domArray.forEach(function (item, i) {
            if (!item) {
              return;
            }
            (0, _utils.addEventListener)(item, eventArray[i] || 'touchmove', i ? _this3.removeMoveHandler : _this3.removeStartHandler, _this3.passive);
          });
        } else if (_this3.getCurrentDrawerSome()) {
          document.body.style.overflow = '';
          if ((_this3.isOpenChange || openTransition) && right) {
            document.body.style.position = '';
            document.body.style.width = '';
            if (_utils.transitionStr) {
              document.body.style.overflowX = 'hidden';
            }
            _this3.dom.style.transition = 'none';
            var heightTransition = void 0;
            switch (placement) {
              case 'right':
                {
                  _this3.dom.style.transform = 'translateX(' + right + 'px)';
                  _this3.dom.style.msTransform = 'translateX(' + right + 'px)';
                  _this3.dom.style.width = '100%';
                  widthTransition = 'width 0s ' + ease + ' ' + duration;
                  if (_this3.maskDom) {
                    _this3.maskDom.style.left = '-' + right + 'px';
                    _this3.maskDom.style.width = 'calc(100% + ' + right + 'px)';
                  }
                  break;
                }
              case 'top':
              case 'bottom':
                {
                  _this3.dom.style.width = 'calc(100% + ' + right + 'px)';
                  _this3.dom.style.height = '100%';
                  _this3.dom.style.transform = 'translateZ(0)';
                  heightTransition = 'height 0s ' + ease + ' ' + duration;
                  break;
                }
              default:
                break;
            }
            clearTimeout(_this3.timeout);
            _this3.timeout = setTimeout(function () {
              _this3.dom.style.transition = trannsformTransition + ',' + (heightTransition ? heightTransition + ',' : '') + widthTransition;
              _this3.dom.style.transform = '';
              _this3.dom.style.msTransform = '';
              _this3.dom.style.width = '';
              _this3.dom.style.height = '';
            });
          }
          domArray.forEach(function (item, i) {
            if (!item) {
              return;
            }
            (0, _utils.removeEventListener)(item, eventArray[i] || 'touchmove', i ? _this3.removeMoveHandler : _this3.removeStartHandler, _this3.passive);
          });
        }
      }
    }
    if (onChange && _this3.isOpenChange && _this3.firstEnter) {
      onChange(open);
      _this3.isOpenChange = false;
    }
  };

  this.getChildToRender = function (open) {
    var _classnames;

    var _props3 = _this3.props,
        className = _props3.className,
        prefixCls = _props3.prefixCls,
        style = _props3.style,
        placement = _props3.placement,
        children = _props3.children,
        handler = _props3.handler,
        showMask = _props3.showMask,
        maskStyle = _props3.maskStyle,
        width = _props3.width,
        height = _props3.height;

    var wrapperClassname = (0, _classnames3['default'])(prefixCls, (_classnames = {}, (0, _defineProperty3['default'])(_classnames, prefixCls + '-' + placement, true), (0, _defineProperty3['default'])(_classnames, prefixCls + '-open', open), (0, _defineProperty3['default'])(_classnames, className, !!className), _classnames));
    var isOpenChange = _this3.isOpenChange;
    var isHorizontal = placement === 'left' || placement === 'right';
    var placementName = 'translate' + (isHorizontal ? 'X' : 'Y');
    // 百分比与像素动画不同步，第一次打用后全用像素动画。
    // const defaultValue = !this.contentDom || !level ? '100%' : `${value}px`;
    var placementPos = placement === 'left' || placement === 'top' ? '-100%' : '100%';
    var transform = open ? '' : placementName + '(' + placementPos + ')';
    if (isOpenChange === undefined || isOpenChange) {
      var contentValue = _this3.contentDom ? _this3.contentDom.getBoundingClientRect()[isHorizontal ? 'width' : 'height'] : 0;
      var value = (isHorizontal ? width : height) || contentValue;
      _this3.setLevelDomTransform(open, false, placementName, value);
    }
    var handlerChildren = handler && _react2['default'].cloneElement(handler, {
      onClick: function onClick(e) {
        if (handler.props.onClick) {
          handler.props.onClick();
        }
        _this3.onIconTouchEnd(e);
      },
      ref: function ref(c) {
        _this3.handlerdom = c;
      }
    });
    return _react2['default'].createElement(
      'div',
      {
        className: wrapperClassname,
        style: style,
        ref: function ref(c) {
          _this3.dom = c;
        },
        onTransitionEnd: _this3.onWrapperTransitionEnd
      },
      showMask && _react2['default'].createElement('div', {
        className: prefixCls + '-mask',
        onClick: _this3.onMaskTouchEnd,
        style: maskStyle,
        ref: function ref(c) {
          _this3.maskDom = c;
        }
      }),
      _react2['default'].createElement(
        'div',
        {
          className: prefixCls + '-content-wrapper',
          style: {
            transform: transform,
            msTransform: transform,
            width: (0, _utils.isNumeric)(width) ? width + 'px' : width,
            height: (0, _utils.isNumeric)(height) ? height + 'px' : height
          },
          ref: function ref(c) {
            _this3.contentWrapper = c;
          }
        },
        _react2['default'].createElement(
          'div',
          {
            className: prefixCls + '-content',
            ref: function ref(c) {
              _this3.contentDom = c;
            },
            onTouchStart: open ? _this3.removeStartHandler : null // 跑用例用
            , onTouchMove: open ? _this3.removeMoveHandler : null // 跑用例用
          },
          children
        ),
        handlerChildren
      )
    );
  };

  this.getOpen = function () {
    return _this3.props.open !== undefined ? _this3.props.open : _this3.state.open;
  };

  this.getTouchParentScroll = function (root, currentTarget, differX, differY) {
    if (!currentTarget || currentTarget === document) {
      return false;
    }
    // root 为 drawer-content 设定了 overflow, 判断为 root 的 parent 时结束滚动；
    if (currentTarget === root.parentNode) {
      return true;
    }

    var isY = Math.max(Math.abs(differX), Math.abs(differY)) === Math.abs(differY);
    var isX = Math.max(Math.abs(differX), Math.abs(differY)) === Math.abs(differX);

    var scrollY = currentTarget.scrollHeight - currentTarget.clientHeight;
    var scrollX = currentTarget.scrollWidth - currentTarget.clientWidth;
    /**
     * <div style="height: 300px">
     *   <div style="height: 900px"></div>
     * </div>
     * 在没设定 overflow: auto 或 scroll 时，currentTarget 里获取不到 scrollTop 或 scrollLeft,
     * 预先用 scrollTo 来滚动，如果取出的值跟滚动前取出不同，则 currnetTarget 被设定了 overflow; 否则就是上面这种。
     */
    var t = currentTarget.scrollTop;
    var l = currentTarget.scrollLeft;
    if (currentTarget.scrollTo) {
      currentTarget.scrollTo(currentTarget.scrollLeft + 1, currentTarget.scrollTop + 1);
    }
    var currentT = currentTarget.scrollTop;
    var currentL = currentTarget.scrollLeft;
    if (currentTarget.scrollTo) {
      currentTarget.scrollTo(currentTarget.scrollLeft - 1, currentTarget.scrollTop - 1);
    }
    if (isY && (!scrollY || !(currentT - t) || scrollY && (currentTarget.scrollTop >= scrollY && differY < 0 || currentTarget.scrollTop <= 0 && differY > 0)) || isX && (!scrollX || !(currentL - l) || scrollX && (currentTarget.scrollLeft >= scrollX && differX < 0 || currentTarget.scrollLeft <= 0 && differX > 0))) {
      return _this3.getTouchParentScroll(root, currentTarget.parentNode, differX, differY);
    }
    return false;
  };

  this.removeStartHandler = function (e) {
    if (e.touches.length > 1) {
      return;
    }
    _this3.startPos = {
      x: e.touches[0].clientX,
      y: e.touches[0].clientY
    };
  };

  this.removeMoveHandler = function (e) {
    if (e.changedTouches.length > 1) {
      return;
    }
    var currentTarget = e.currentTarget;
    var differX = e.changedTouches[0].clientX - _this3.startPos.x;
    var differY = e.changedTouches[0].clientY - _this3.startPos.y;
    if (currentTarget === _this3.maskDom || currentTarget === _this3.handlerdom || currentTarget === _this3.contentDom && _this3.getTouchParentScroll(currentTarget, e.target, differX, differY)) {
      e.preventDefault();
    }
  };

  this.transitionEnd = function (e) {
    (0, _utils.removeEventListener)(e.target, _utils.transitionEnd, _this3.transitionEnd);
    e.target.style.transition = '';
  };

  this.defaultGetContainer = function () {
    if (windowIsUndefined) {
      return null;
    }
    var container = document.createElement('div');
    _this3.parent.appendChild(container);
    if (_this3.props.wrapperClassName) {
      container.className = _this3.props.wrapperClassName;
    }
    return container;
  };
};

Drawer.propTypes = {
  wrapperClassName: _propTypes2['default'].string,
  className: _propTypes2['default'].string,
  children: _propTypes2['default'].node,
  style: _propTypes2['default'].object,
  width: _propTypes2['default'].any,
  height: _propTypes2['default'].any,
  defaultOpen: _propTypes2['default'].bool,
  firstEnter: _propTypes2['default'].bool,
  open: _propTypes2['default'].bool,
  prefixCls: _propTypes2['default'].string,
  placement: _propTypes2['default'].string,
  level: _propTypes2['default'].oneOfType([_propTypes2['default'].string, _propTypes2['default'].array]),
  levelMove: _propTypes2['default'].oneOfType([_propTypes2['default'].number, _propTypes2['default'].func, _propTypes2['default'].array]),
  ease: _propTypes2['default'].string,
  duration: _propTypes2['default'].string,
  getContainer: _propTypes2['default'].oneOfType([_propTypes2['default'].string, _propTypes2['default'].func, _propTypes2['default'].object, _propTypes2['default'].bool]),
  handler: _propTypes2['default'].any,
  onChange: _propTypes2['default'].func,
  onMaskClick: _propTypes2['default'].func,
  onHandleClick: _propTypes2['default'].func,
  showMask: _propTypes2['default'].bool,
  maskStyle: _propTypes2['default'].object
};

exports['default'] = Drawer;
module.exports = exports['default'];