'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports["default"] = exportContent;

var _draftJs = require('draft-js');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function encodeContent(text) {
  return text.split('&').join('&amp;').split('<').join('&lt;').split('>').join('&gt;').split('\xA0').join('&nbsp;').split('\n').join('<br >' + '\n');
}

var MentionGenerator = function () {
  function MentionGenerator(contentState, options) {
    _classCallCheck(this, MentionGenerator);

    this.contentState = contentState;
    this.options = options;
  }

  MentionGenerator.prototype.generate = function generate() {
    var contentRaw = (0, _draftJs.convertToRaw)(this.contentState);
    return this.processContent(contentRaw);
  };

  MentionGenerator.prototype.processContent = function processContent(contentRaw) {
    var blocks = contentRaw.blocks;
    var encode = this.options.encode;

    return blocks.map(function (block) {
      return encode ? encodeContent(block.text) : block.text;
    }).join(encode ? '<br />\n' : '\n');
  };

  return MentionGenerator;
}();

function exportContent(editorState) {
  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var content = editorState.getCurrentContent();
  return new MentionGenerator(content, options).generate();
}
module.exports = exports['default'];