'use strict';

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _enzyme = require('enzyme');

var _Mention = require('../Mention.react');

var _Mention2 = _interopRequireDefault(_Mention);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

describe('Mention.react', function () {
  describe('Basic rendering', function () {
    it('render correctly', function () {
      var block = (0, _enzyme.mount)(_react2["default"].createElement(_Mention2["default"], { prefix: 'test' }));

      expect(block.find('.test-wrapper')).not.toBe(null);
    });

    it('Basic suggestion', function () {
      jest.useFakeTimers();
      var handleSearch = jest.fn();
      var block = (0, _enzyme.mount)(_react2["default"].createElement(_Mention2["default"], {
        suggestions: ['afc163', 'raohai'],
        onSearchChange: handleSearch
      }));

      block.find('DraftEditor').node.focus();
      block.find('.public-DraftEditor-content').simulate('beforeInput', { data: '@a' });
      jest.runAllTimers();
      expect(handleSearch).toBeCalledWith('a', '@');
    });
  });
});