"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _ = require(".");

var _warning = _interopRequireDefault(require("rc-util/lib/warning"));

var _FieldContext = require("./FieldContext");

var _react = require("react");

var _valueUtil = require("./utils/valueUtil");

function useWatch() {
  var dependencies = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
  var form = arguments.length > 1 ? arguments[1] : undefined;

  var _useState = (0, _react.useState)(),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      value = _useState2[0],
      setValue = _useState2[1];

  var valueCacheRef = (0, _react.useRef)();
  valueCacheRef.current = value;
  var fieldContext = (0, _react.useContext)(_.FieldContext);
  var formInstance = form || fieldContext;
  var isValidForm = formInstance && formInstance._init; // Warning if not exist form instance

  if (process.env.NODE_ENV !== 'production') {
    (0, _warning.default)(isValidForm, 'useWatch requires a form instance since it can not auto detect from context.');
  }

  var namePath = (0, _valueUtil.getNamePath)(dependencies);
  var namePathRef = (0, _react.useRef)(namePath);
  namePathRef.current = namePath;
  (0, _react.useEffect)(function () {
    // Skip if not exist form instance
    if (!isValidForm) {
      return;
    }

    var getFieldsValue = formInstance.getFieldsValue,
        getInternalHooks = formInstance.getInternalHooks;

    var _getInternalHooks = getInternalHooks(_FieldContext.HOOK_MARK),
        registerWatch = _getInternalHooks.registerWatch;

    var cancelRegister = registerWatch(function (store) {
      var newValue = (0, _valueUtil.getValue)(store, namePathRef.current);

      if (valueCacheRef.current !== newValue) {
        setValue(newValue);
      }
    }); // TODO: We can improve this perf in future

    var initialValue = (0, _valueUtil.getValue)(getFieldsValue(), namePathRef.current);
    setValue(initialValue);
    return cancelRegister;
  }, // We do not need re-register since namePath content is the same
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  return value;
}

var _default = useWatch;
exports.default = _default;