'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; };

exports.argumentContainer = argumentContainer;
exports.getValueFromEvent = getValueFromEvent;
exports.getErrorStrs = getErrorStrs;
exports.isEmptyObject = isEmptyObject;
exports.flattenArray = flattenArray;
exports.mirror = mirror;
exports.hasRules = hasRules;
exports.startsWith = startsWith;
exports.getParams = getParams;
exports.getNameKeyStr = getNameKeyStr;
exports.getNameKeyObj = getNameKeyObj;
exports.flatFields = flatFields;
exports.flatFieldNames = flatFieldNames;
exports.clearVirtualField = clearVirtualField;

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function getDisplayName(WrappedComponent) {
  return WrappedComponent.displayName || WrappedComponent.name || 'WrappedComponent';
}

function argumentContainer(Container, WrappedComponent) {
  /* eslint no-param-reassign:0 */
  Container.displayName = 'Form(' + getDisplayName(WrappedComponent) + ')';
  Container.WrappedComponent = WrappedComponent;
  return (0, _hoistNonReactStatics2["default"])(Container, WrappedComponent);
}

function getValueFromEvent(e) {
  // support custom element
  if (!e || !e.target) {
    return e;
  }
  var target = e.target;

  return target.type === 'checkbox' ? target.checked : target.value;
}

function getErrorStrs(errors) {
  if (errors) {
    return errors.map(function (e) {
      if (e && e.message) {
        return e.message;
      }
      return e;
    });
  }
  return errors;
}

function isEmptyObject(obj) {
  return Object.keys(obj).length === 0;
}

function flattenArray(arr) {
  return Array.prototype.concat.apply([], arr);
}

function mirror(obj) {
  return obj;
}

function hasRules(validate) {
  if (validate) {
    return validate.some(function (item) {
      return !!item.rules && item.rules.length;
    });
  }
  return false;
}

function startsWith(str, prefix) {
  return str.lastIndexOf(prefix, 0) === 0;
}

function getParams(ns, opt, cb) {
  var names = ns;
  var callback = cb;
  var options = opt;
  if (cb === undefined) {
    if (typeof names === 'function') {
      callback = names;
      options = {};
      names = undefined;
    } else if (Array.isArray(ns)) {
      if (typeof options === 'function') {
        callback = options;
        options = {};
      } else {
        options = options || {};
      }
    } else {
      callback = options;
      options = names || {};
      names = undefined;
    }
  }
  return {
    names: names,
    callback: callback,
    options: options
  };
}

var NAME_KEY_SEP = '.';

function getNameKeyStr(name, key) {
  if (key) {
    return '' + name + NAME_KEY_SEP + key;
  }
  return name;
}

function getNameKeyObj(str) {
  var index = str.indexOf(NAME_KEY_SEP);
  if (str.indexOf(NAME_KEY_SEP) !== -1) {
    var name = str.slice(0, index);
    var key = str.slice(index + NAME_KEY_SEP.length);
    return {
      name: name,
      key: key
    };
  }
  return {
    name: str
  };
}

function flatFields(fields_, fieldsMeta) {
  var fields = _extends({}, fields_);
  Object.keys(fields).forEach(function (k) {
    if (fieldsMeta[k] && fieldsMeta[k].virtual) {
      var value = fields[k];
      // flatten
      for (var k2 in value) {
        if (value.hasOwnProperty(k2)) {
          fields[getNameKeyStr(k, k2)] = value[k2];
        }
      }
      delete fields[k];
    }
  });
  return fields;
}

function flatFieldNames(names) {
  var ret = {};
  names.forEach(function (n) {
    ret[getNameKeyObj(n).name] = 1;
  });
  return Object.keys(ret);
}

function clearVirtualField(name, fields, fieldsMeta) {
  if (fieldsMeta[name] && fieldsMeta[name].virtual) {
    /* eslint no-loop-func:0 */
    Object.keys(fields).forEach(function (ok) {
      if (getNameKeyObj(ok).name === name) {
        delete fields[ok];
      }
    });
  }
}