'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.argumentContainer = argumentContainer;
exports.getValueFromEvent = getValueFromEvent;
exports.getErrorStrs = getErrorStrs;
exports.isEmptyObject = isEmptyObject;
exports.flattenArray = flattenArray;
exports.mirror = mirror;
exports.hasRules = hasRules;
exports.startsWith = startsWith;
exports.getParams = getParams;
exports.getNameIfNested = getNameIfNested;
exports.flatFieldNames = flatFieldNames;
exports.clearVirtualField = clearVirtualField;
exports.getVirtualPaths = getVirtualPaths;

var _hoistNonReactStatics = require('hoist-non-react-statics');

var _hoistNonReactStatics2 = _interopRequireDefault(_hoistNonReactStatics);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function getDisplayName(WrappedComponent) {
  return WrappedComponent.displayName || WrappedComponent.name || 'WrappedComponent';
}

function argumentContainer(Container, WrappedComponent) {
  /* eslint no-param-reassign:0 */
  Container.displayName = 'Form(' + getDisplayName(WrappedComponent) + ')';
  Container.WrappedComponent = WrappedComponent;
  return (0, _hoistNonReactStatics2["default"])(Container, WrappedComponent);
}

function getValueFromEvent(e) {
  // support custom element
  if (!e || !e.target) {
    return e;
  }
  var target = e.target;

  return target.type === 'checkbox' ? target.checked : target.value;
}

function getErrorStrs(errors) {
  if (errors) {
    return errors.map(function (e) {
      if (e && e.message) {
        return e.message;
      }
      return e;
    });
  }
  return errors;
}

function isEmptyObject(obj) {
  return Object.keys(obj).length === 0;
}

function flattenArray(arr) {
  return Array.prototype.concat.apply([], arr);
}

function mirror(obj) {
  return obj;
}

function hasRules(validate) {
  if (validate) {
    return validate.some(function (item) {
      return !!item.rules && item.rules.length;
    });
  }
  return false;
}

function startsWith(str, prefix) {
  return str.lastIndexOf(prefix, 0) === 0;
}

function getParams(ns, opt, cb) {
  var names = ns;
  var callback = cb;
  var options = opt;
  if (cb === undefined) {
    if (typeof names === 'function') {
      callback = names;
      options = {};
      names = undefined;
    } else if (Array.isArray(ns)) {
      if (typeof options === 'function') {
        callback = options;
        options = {};
      } else {
        options = options || {};
      }
    } else {
      callback = options;
      options = names || {};
      names = undefined;
    }
  }
  return {
    names: names,
    callback: callback,
    options: options
  };
}

var NAME_KEY_SEP = '.';
var NAME_INDEX_OPEN_SEP = '[';

function getNameIfNested(str) {
  var keyIndex = str.indexOf(NAME_KEY_SEP);
  var arrayIndex = str.indexOf(NAME_INDEX_OPEN_SEP);

  var index = void 0;

  if (keyIndex === -1 && arrayIndex === -1) {
    return {
      name: str
    };
  } else if (keyIndex === -1) {
    index = arrayIndex;
  } else if (arrayIndex === -1) {
    index = keyIndex;
  } else {
    index = Math.min(keyIndex, arrayIndex);
  }

  return {
    name: str.slice(0, index),
    isNested: true
  };
}

function flatFieldNames(names) {
  var ret = {};
  names.forEach(function (n) {
    ret[getNameIfNested(n).name] = 1;
  });
  return Object.keys(ret);
}

function clearVirtualField(name, fields, fieldsMeta) {
  if (fieldsMeta[name] && fieldsMeta[name].virtual) {
    /* eslint no-loop-func:0 */
    Object.keys(fields).forEach(function (ok) {
      if (getNameIfNested(ok).name === name) {
        delete fields[ok];
      }
    });
  }
}

function getVirtualPaths(fieldsMeta) {
  var virtualPaths = {};
  for (var name in fieldsMeta) {
    if (fieldsMeta.hasOwnProperty(name)) {
      var leadingName = fieldsMeta[name].leadingName;
      if (leadingName && fieldsMeta[leadingName].virtual) {
        if (leadingName in virtualPaths) {
          virtualPaths[leadingName].push(name);
        } else {
          virtualPaths[leadingName] = [name];
        }
      }
    }
  }
  return virtualPaths;
}