import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { useState, useRef } from 'react';
import raf from "rc-util/es/raf";
import { getClientSize } from "rc-util/es/Dom/css";
import { MIN_SCALE, MAX_SCALE } from "../previewConfig";
var initialTransform = {
  x: 0,
  y: 0,
  rotate: 0,
  scale: 1
};
export default function useImageTransform(imgRef) {
  var frame = useRef(null);
  var queue = useRef([]);

  var _useState = useState(initialTransform),
      _useState2 = _slicedToArray(_useState, 2),
      transform = _useState2[0],
      setTransform = _useState2[1];

  var resetTransform = function resetTransform() {
    setTransform(initialTransform);
  };
  /** Direct update transform */


  var updateTransform = function updateTransform(newTransform) {
    if (frame.current === null) {
      queue.current = [];
      frame.current = raf(function () {
        setTransform(function (preState) {
          var memoState = preState;
          queue.current.forEach(function (queueState) {
            memoState = _objectSpread(_objectSpread({}, memoState), queueState);
          });
          frame.current = null;
          return memoState;
        });
      });
    }

    queue.current.push(_objectSpread(_objectSpread({}, transform), newTransform));
  };
  /** Scale according to the position of clientX and clientY */


  var dispatchZoonChange = function dispatchZoonChange(ratio, clientX, clientY) {
    var _imgRef$current = imgRef.current,
        width = _imgRef$current.width,
        height = _imgRef$current.height,
        offsetWidth = _imgRef$current.offsetWidth,
        offsetHeight = _imgRef$current.offsetHeight,
        offsetLeft = _imgRef$current.offsetLeft,
        offsetTop = _imgRef$current.offsetTop;
    var newRatio = ratio;
    var newScale = transform.scale * ratio;

    if (newScale > MAX_SCALE) {
      newRatio = MAX_SCALE / transform.scale;
      newScale = MAX_SCALE;
    } else if (newScale < MIN_SCALE) {
      newRatio = MIN_SCALE / transform.scale;
      newScale = MIN_SCALE;
    }
    /** Default center point scaling */


    var mergedClientX = clientX !== null && clientX !== void 0 ? clientX : innerWidth / 2;
    var mergedClientY = clientY !== null && clientY !== void 0 ? clientY : innerHeight / 2;
    var diffRatio = newRatio - 1;
    /** Deviation calculated from image size */

    var diffImgX = diffRatio * width * 0.5;
    var diffImgY = diffRatio * height * 0.5;
    /** The difference between the click position and the edge of the document */

    var diffOffsetLeft = diffRatio * (mergedClientX - transform.x - offsetLeft);
    var diffOffsetTop = diffRatio * (mergedClientY - transform.y - offsetTop);
    /** Final positioning */

    var newX = transform.x - (diffOffsetLeft - diffImgX);
    var newY = transform.y - (diffOffsetTop - diffImgY);
    /**
     * When zooming the image
     * When the image size is smaller than the width and height of the window, the position is initialized
     */

    if (ratio < 1 && newScale === 1) {
      var mergedWidth = offsetWidth * newScale;
      var mergedHeight = offsetHeight * newScale;

      var _getClientSize = getClientSize(),
          clientWidth = _getClientSize.width,
          clientHeight = _getClientSize.height;

      if (mergedWidth <= clientWidth && mergedHeight <= clientHeight) {
        newX = 0;
        newY = 0;
      }
    }

    updateTransform({
      x: newX,
      y: newY,
      scale: newScale
    });
  };

  return {
    transform: transform,
    resetTransform: resetTransform,
    updateTransform: updateTransform,
    dispatchZoonChange: dispatchZoonChange
  };
}
;