"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _KeyCode = _interopRequireDefault(require("rc-util/lib/KeyCode"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Date.prototype.toString.call(Reflect.construct(Date, [], function () {})); return true; } catch (e) { return false; } }

function noop() {}

function preventDefault(e) {
  e.preventDefault();
}

var defaultParser = function defaultParser(input) {
  return input.replace(/[^\w.-]+/g, '');
};
/**
 * When click and hold on a button - the speed of auto changin the value.
 */


var SPEED = 200;
/**
 * When click and hold on a button - the delay before auto changin the value.
 */

var DELAY = 600;
/**
 * Max Safe Integer -- on IE this is not available, so manually set the number in that case.
 * The reason this is used, instead of Infinity is because numbers above the MSI are unstable
 */

var MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || Math.pow(2, 53) - 1;

var isValidProps = function isValidProps(value) {
  return value !== undefined && value !== null;
};

var isEqual = function isEqual(oldValue, newValue) {
  return newValue === oldValue || typeof newValue === 'number' && typeof oldValue === 'number' && isNaN(newValue) && isNaN(oldValue);
};

var InputNumber = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(InputNumber, _React$Component);

  var _super = _createSuper(InputNumber);

  function InputNumber(props) {
    var _this;

    (0, _classCallCheck2.default)(this, InputNumber);
    _this = _super.call(this, props);

    _this.onKeyDown = function (e) {
      var _this$props = _this.props,
          onKeyDown = _this$props.onKeyDown,
          onPressEnter = _this$props.onPressEnter;

      if (e.keyCode === _KeyCode.default.UP) {
        var ratio = _this.getRatio(e);

        _this.up(e, ratio, null);

        _this.stop();
      } else if (e.keyCode === _KeyCode.default.DOWN) {
        var _ratio = _this.getRatio(e);

        _this.down(e, _ratio, null);

        _this.stop();
      } else if (e.keyCode === _KeyCode.default.ENTER && onPressEnter) {
        onPressEnter(e);
      } // Trigger user key down


      _this.recordCursorPosition();

      _this.lastKeyCode = e.keyCode;

      if (onKeyDown) {
        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
          args[_key - 1] = arguments[_key];
        }

        onKeyDown.apply(void 0, [e].concat(args));
      }
    };

    _this.onKeyUp = function (e) {
      var onKeyUp = _this.props.onKeyUp;

      _this.stop();

      _this.recordCursorPosition(); // Trigger user key up


      if (onKeyUp) {
        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
          args[_key2 - 1] = arguments[_key2];
        }

        onKeyUp.apply(void 0, [e].concat(args));
      }
    };

    _this.onChange = function (e) {
      var onChange = _this.props.onChange;

      if (_this.state.focused) {
        _this.inputting = true;
      }

      _this.rawInput = _this.props.parser(_this.getValueFromEvent(e));

      _this.setState({
        inputValue: _this.rawInput
      });

      onChange(_this.toNumber(_this.rawInput)); // valid number or invalid string
    };

    _this.onMouseUp = function () {
      var onMouseUp = _this.props.onMouseUp;

      _this.recordCursorPosition();

      if (onMouseUp) {
        onMouseUp.apply(void 0, arguments);
      }
    };

    _this.onFocus = function () {
      var _this$props2;

      _this.setState({
        focused: true
      });

      (_this$props2 = _this.props).onFocus.apply(_this$props2, arguments);
    };

    _this.onBlur = function () {
      var onBlur = _this.props.onBlur;
      _this.inputting = false;

      _this.setState({
        focused: false
      });

      var value = _this.getCurrentValidValue(_this.state.inputValue);

      var newValue = _this.setValue(value, noop);

      if (onBlur) {
        var originValue = _this.input.value;

        var displayValue = _this.getInputDisplayValue({
          focus: false,
          value: newValue
        });

        _this.input.value = displayValue ? Number(displayValue) : displayValue;
        onBlur.apply(void 0, arguments);
        _this.input.value = originValue;
      }
    };

    _this.getRatio = function (e) {
      var ratio = 1;

      if (e.metaKey || e.ctrlKey) {
        ratio = 0.1;
      } else if (e.shiftKey) {
        ratio = 10;
      }

      return ratio;
    };

    _this.getFullNum = function (num) {
      if (isNaN(num)) {
        return num;
      }

      if (!/e/i.test(String(num))) {
        return num;
      }

      return Number(num).toFixed(18).replace(/\.?0+$/, '');
    };

    _this.getPrecision = function (value) {
      if (isValidProps(_this.props.precision)) {
        return _this.props.precision;
      }

      var valueString = String(value);

      if (valueString.indexOf('e-') >= 0) {
        return parseInt(valueString.slice(valueString.indexOf('e-') + 2), 10);
      }

      var precision = 0;

      if (valueString.indexOf('.') >= 0) {
        precision = valueString.length - valueString.indexOf('.') - 1;
      }

      return precision;
    };

    _this.getInputDisplayValue = function (state) {
      var _ref = state || _this.state,
          focused = _ref.focused,
          inputValue = _ref.inputValue,
          value = _ref.value;

      var inputDisplayValue;

      if (focused) {
        inputDisplayValue = inputValue;
      } else {
        inputDisplayValue = _this.toPrecisionAsStep(value);
      }

      if (inputDisplayValue === undefined || inputDisplayValue === null) {
        inputDisplayValue = '';
      }

      var inputDisplayValueFormat = _this.formatWrapper(inputDisplayValue);

      if (isValidProps(_this.props.decimalSeparator)) {
        inputDisplayValueFormat = inputDisplayValueFormat.toString().replace('.', _this.props.decimalSeparator);
      }

      return inputDisplayValueFormat;
    };

    _this.recordCursorPosition = function () {
      // Record position
      try {
        _this.cursorStart = _this.input.selectionStart;
        _this.cursorEnd = _this.input.selectionEnd;
        _this.currentValue = _this.input.value;
        _this.cursorBefore = _this.input.value.substring(0, _this.cursorStart);
        _this.cursorAfter = _this.input.value.substring(_this.cursorEnd);
      } catch (e) {// Fix error in Chrome:
        // Failed to read the 'selectionStart' property from 'HTMLInputElement'
        // http://stackoverflow.com/q/21177489/3040605
      }
    };

    _this.restoreByAfter = function (str) {
      if (str === undefined) return false;
      var fullStr = _this.input.value;
      var index = fullStr.lastIndexOf(str);
      if (index === -1) return false;
      var prevCursorPos = _this.cursorBefore.length;

      if (_this.lastKeyCode === _KeyCode.default.DELETE && _this.cursorBefore.charAt(prevCursorPos - 1) === str[0]) {
        _this.fixCaret(prevCursorPos, prevCursorPos);

        return true;
      }

      if (index + str.length === fullStr.length) {
        _this.fixCaret(index, index);

        return true;
      }

      return false;
    };

    _this.partRestoreByAfter = function (str) {
      if (str === undefined) return false; // For loop from full str to the str with last char to map. e.g. 123
      // -> 123
      // -> 23
      // -> 3

      return Array.prototype.some.call(str, function (_, start) {
        var partStr = str.substring(start);
        return _this.restoreByAfter(partStr);
      });
    }; // '1.' '1x' 'xx' '' => are not complete numbers


    _this.isNotCompleteNumber = function (num) {
      return isNaN(num) || num === '' || num === null || num && num.toString().indexOf('.') === num.toString().length - 1;
    };

    _this.stop = function () {
      if (_this.autoStepTimer) {
        clearTimeout(_this.autoStepTimer);
      }
    };

    _this.down = function (e, ratio, recursive) {
      _this.pressingUpOrDown = true;

      _this.step('down', e, ratio, recursive);
    };

    _this.up = function (e, ratio, recursive) {
      _this.pressingUpOrDown = true;

      _this.step('up', e, ratio, recursive);
    };

    _this.saveInput = function (node) {
      _this.input = node;
    };

    var value = props.value;

    if (value === undefined) {
      value = props.defaultValue;
    }

    _this.state = {
      focused: props.autoFocus
    };

    var validValue = _this.getValidValue(_this.toNumber(value));

    _this.state = _objectSpread(_objectSpread({}, _this.state), {}, {
      inputValue: _this.toPrecisionAsStep(validValue),
      value: validValue
    });
    return _this;
  }

  (0, _createClass2.default)(InputNumber, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      this.componentDidUpdate(null);
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps) {
      var _this$props3 = this.props,
          value = _this$props3.value,
          onChange = _this$props3.onChange,
          max = _this$props3.max,
          min = _this$props3.min;
      var focused = this.state.focused; // Don't trigger in componentDidMount

      if (prevProps) {
        if (!isEqual(prevProps.value, value) || !isEqual(prevProps.max, max) || !isEqual(prevProps.min, min)) {
          var validValue = focused ? value : this.getValidValue(value);
          var nextInputValue;

          if (this.pressingUpOrDown) {
            nextInputValue = validValue;
          } else if (this.inputting) {
            nextInputValue = this.rawInput;
          } else {
            nextInputValue = this.toPrecisionAsStep(validValue);
          }

          this.setState({
            // eslint-disable-line
            value: validValue,
            inputValue: nextInputValue
          });
        } // Trigger onChange when max or min change
        // https://github.com/ant-design/ant-design/issues/11574


        var nextValue = 'value' in this.props ? value : this.state.value; // ref: null < 20 === true
        // https://github.com/ant-design/ant-design/issues/14277

        if ('max' in this.props && prevProps.max !== max && typeof nextValue === 'number' && nextValue > max && onChange) {
          onChange(max);
        }

        if ('min' in this.props && prevProps.min !== min && typeof nextValue === 'number' && nextValue < min && onChange) {
          onChange(min);
        }
      } // Restore cursor


      try {
        // Firefox set the input cursor after it get focused.
        // This caused that if an input didn't init with the selection,
        // set will cause cursor not correct when first focus.
        // Safari will focus input if set selection. We need skip this.
        if (this.cursorStart !== undefined && this.state.focused) {
          // In most cases, the string after cursor is stable.
          // We can move the cursor before it
          if ( // If not match full str, try to match part of str
          !this.partRestoreByAfter(this.cursorAfter) && this.state.value !== this.props.value) {
            // If not match any of then, let's just keep the position
            // TODO: Logic should not reach here, need check if happens
            var pos = this.cursorStart + 1; // If not have last string, just position to the end

            if (!this.cursorAfter) {
              pos = this.input.value.length;
            } else if (this.lastKeyCode === _KeyCode.default.BACKSPACE) {
              pos = this.cursorStart - 1;
            } else if (this.lastKeyCode === _KeyCode.default.DELETE) {
              pos = this.cursorStart;
            }

            this.fixCaret(pos, pos);
          } else if (this.currentValue === this.input.value) {
            // Handle some special key code
            switch (this.lastKeyCode) {
              case _KeyCode.default.BACKSPACE:
                this.fixCaret(this.cursorStart - 1, this.cursorStart - 1);
                break;

              case _KeyCode.default.DELETE:
                this.fixCaret(this.cursorStart + 1, this.cursorStart + 1);
                break;

              default: // Do nothing

            }
          }
        }
      } catch (e) {// Do nothing
      } // Reset last key


      this.lastKeyCode = null; // pressingUpOrDown is true means that someone just click up or down button

      if (!this.pressingUpOrDown) {
        return;
      }

      if (this.props.focusOnUpDown && this.state.focused) {
        if (document.activeElement !== this.input) {
          this.focus();
        }
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      this.stop();
    }
  }, {
    key: "getCurrentValidValue",
    value: function getCurrentValidValue(value) {
      var val = value;

      if (val === '') {
        val = '';
      } else if (!this.isNotCompleteNumber(parseFloat(val))) {
        val = this.getValidValue(val);
      } else {
        val = this.state.value;
      }

      return this.toNumber(val);
    }
  }, {
    key: "getValueFromEvent",
    value: function getValueFromEvent(e) {
      // optimize for chinese input expierence
      // https://github.com/ant-design/ant-design/issues/8196
      var value = e.target.value.trim().replace(/。/g, '.');

      if (isValidProps(this.props.decimalSeparator)) {
        value = value.replace(this.props.decimalSeparator, '.');
      }

      return value;
    }
  }, {
    key: "getValidValue",
    value: function getValidValue(value) {
      var min = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.props.min;
      var max = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : this.props.max;
      var val = parseFloat(value); // https://github.com/ant-design/ant-design/issues/7358

      if (isNaN(val)) {
        return value;
      }

      if (val < min) {
        val = min;
      }

      if (val > max) {
        val = max;
      }

      return val;
    }
  }, {
    key: "setValue",
    value: function setValue(v, callback) {
      // trigger onChange
      var precision = this.props.precision;
      var newValue = this.isNotCompleteNumber(parseFloat(v)) ? null : parseFloat(v);
      var _this$state$value = this.state.value,
          value = _this$state$value === void 0 ? null : _this$state$value;
      var _this$state$inputValu = this.state.inputValue,
          inputValue = _this$state$inputValu === void 0 ? null : _this$state$inputValu; // https://github.com/ant-design/ant-design/issues/7363
      // https://github.com/ant-design/ant-design/issues/16622

      var newValueInString = typeof newValue === 'number' ? newValue.toFixed(precision) : "".concat(newValue);
      var changed = newValue !== value || newValueInString !== "".concat(inputValue);

      if (!('value' in this.props)) {
        this.setState({
          value: newValue,
          inputValue: this.toPrecisionAsStep(v)
        }, callback);
      } else {
        // always set input value same as value
        inputValue = this.toPrecisionAsStep(this.state.value);
        this.setState({
          inputValue: inputValue
        }, callback);
      }

      if (changed) {
        this.props.onChange(newValue);
      }

      return newValue;
    } // step={1.0} value={1.51}
    // press +
    // then value should be 2.51, rather than 2.5
    // if this.props.precision is undefined
    // https://github.com/react-component/input-number/issues/39

  }, {
    key: "getMaxPrecision",
    value: function getMaxPrecision(currentValue) {
      var ratio = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var _this$props4 = this.props,
          precision = _this$props4.precision,
          step = _this$props4.step;

      if (isValidProps(precision)) {
        return precision;
      }

      var ratioPrecision = this.getPrecision(ratio);
      var stepPrecision = this.getPrecision(step);
      var currentValuePrecision = this.getPrecision(currentValue);

      if (!currentValue) {
        return ratioPrecision + stepPrecision;
      }

      return Math.max(currentValuePrecision, ratioPrecision + stepPrecision);
    }
  }, {
    key: "getPrecisionFactor",
    value: function getPrecisionFactor(currentValue) {
      var ratio = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 1;
      var precision = this.getMaxPrecision(currentValue, ratio);
      return Math.pow(10, precision);
    }
  }, {
    key: "focus",
    value: function focus() {
      this.input.focus();
      this.recordCursorPosition();
    }
  }, {
    key: "blur",
    value: function blur() {
      this.input.blur();
    }
  }, {
    key: "select",
    value: function select() {
      this.input.select();
    }
  }, {
    key: "formatWrapper",
    value: function formatWrapper(num) {
      // http://2ality.com/2012/03/signedzero.html
      // https://github.com/ant-design/ant-design/issues/9439
      if (this.props.formatter) {
        return this.props.formatter(num);
      }

      return num;
    }
  }, {
    key: "toPrecisionAsStep",
    value: function toPrecisionAsStep(num) {
      if (this.isNotCompleteNumber(num) || num === '') {
        return num;
      }

      var precision = Math.abs(this.getMaxPrecision(num));

      if (!isNaN(precision)) {
        return Number(num).toFixed(precision);
      }

      return num.toString();
    }
  }, {
    key: "toNumber",
    value: function toNumber(num) {
      var precision = this.props.precision;
      var focused = this.state.focused; // num.length > 16 => This is to prevent input of large numbers

      var numberIsTooLarge = num && num.length > 16 && focused;

      if (this.isNotCompleteNumber(num) || numberIsTooLarge) {
        return num;
      }

      if (isValidProps(precision)) {
        return Math.round(num * Math.pow(10, precision)) / Math.pow(10, precision);
      }

      return Number(num);
    }
  }, {
    key: "upStep",
    value: function upStep(val, rat) {
      var step = this.props.step;
      var precisionFactor = this.getPrecisionFactor(val, rat);
      var precision = Math.abs(this.getMaxPrecision(val, rat));
      var result = ((precisionFactor * val + precisionFactor * step * rat) / precisionFactor).toFixed(precision);
      return this.toNumber(result);
    }
  }, {
    key: "downStep",
    value: function downStep(val, rat) {
      var step = this.props.step;
      var precisionFactor = this.getPrecisionFactor(val, rat);
      var precision = Math.abs(this.getMaxPrecision(val, rat));
      var result = ((precisionFactor * val - precisionFactor * step * rat) / precisionFactor).toFixed(precision);
      return this.toNumber(result);
    }
  }, {
    key: "step",
    value: function step(type, e) {
      var _this2 = this;

      var ratio = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 1;
      var recursive = arguments.length > 3 ? arguments[3] : undefined;
      this.stop();

      if (e) {
        e.persist();
        e.preventDefault();
      }

      var props = this.props;

      if (props.disabled) {
        return;
      }

      var value = this.getCurrentValidValue(this.state.inputValue) || 0;

      if (this.isNotCompleteNumber(value)) {
        return;
      }

      var val = this["".concat(type, "Step")](value, ratio);
      var outOfRange = val > props.max || val < props.min;

      if (val > props.max) {
        val = props.max;
      } else if (val < props.min) {
        val = props.min;
      }

      this.setValue(val, null);
      this.setState({
        focused: true
      }, function () {
        _this2.pressingUpOrDown = false;
      });

      if (outOfRange) {
        return;
      }

      this.autoStepTimer = setTimeout(function () {
        _this2[type](e, ratio, true);
      }, recursive ? SPEED : DELAY);
    }
  }, {
    key: "fixCaret",
    value: function fixCaret(start, end) {
      if (start === undefined || end === undefined || !this.input || !this.input.value) {
        return;
      }

      try {
        var currentStart = this.input.selectionStart;
        var currentEnd = this.input.selectionEnd;

        if (start !== currentStart || end !== currentEnd) {
          this.input.setSelectionRange(start, end);
        }
      } catch (e) {// Fix error in Chrome:
        // Failed to read the 'selectionStart' property from 'HTMLInputElement'
        // http://stackoverflow.com/q/21177489/3040605
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _classNames;

      var _this$props5 = this.props,
          prefixCls = _this$props5.prefixCls,
          disabled = _this$props5.disabled,
          readOnly = _this$props5.readOnly,
          useTouch = _this$props5.useTouch,
          autoComplete = _this$props5.autoComplete,
          upHandler = _this$props5.upHandler,
          downHandler = _this$props5.downHandler,
          className = _this$props5.className,
          max = _this$props5.max,
          min = _this$props5.min,
          style = _this$props5.style,
          title = _this$props5.title,
          onMouseEnter = _this$props5.onMouseEnter,
          onMouseLeave = _this$props5.onMouseLeave,
          onMouseOver = _this$props5.onMouseOver,
          onMouseOut = _this$props5.onMouseOut,
          required = _this$props5.required,
          onClick = _this$props5.onClick,
          tabIndex = _this$props5.tabIndex,
          type = _this$props5.type,
          placeholder = _this$props5.placeholder,
          id = _this$props5.id,
          inputMode = _this$props5.inputMode,
          pattern = _this$props5.pattern,
          step = _this$props5.step,
          maxLength = _this$props5.maxLength,
          autoFocus = _this$props5.autoFocus,
          name = _this$props5.name,
          onPaste = _this$props5.onPaste,
          rest = (0, _objectWithoutProperties2.default)(_this$props5, ["prefixCls", "disabled", "readOnly", "useTouch", "autoComplete", "upHandler", "downHandler", "className", "max", "min", "style", "title", "onMouseEnter", "onMouseLeave", "onMouseOver", "onMouseOut", "required", "onClick", "tabIndex", "type", "placeholder", "id", "inputMode", "pattern", "step", "maxLength", "autoFocus", "name", "onPaste"]);
      var _this$state = this.state,
          value = _this$state.value,
          focused = _this$state.focused;
      var classes = (0, _classnames.default)(prefixCls, (_classNames = {}, (0, _defineProperty2.default)(_classNames, className, !!className), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-disabled"), disabled), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-focused"), focused), _classNames));
      var dataOrAriaAttributeProps = {};
      Object.keys(rest).forEach(function (key) {
        if (key.substr(0, 5) === 'data-' || key.substr(0, 5) === 'aria-' || key === 'role') {
          dataOrAriaAttributeProps[key] = rest[key];
        }
      });
      var editable = !readOnly && !disabled; // focus state, show input value
      // unfocus state, show valid value

      var inputDisplayValue = this.getInputDisplayValue(null);
      var upDisabled = (value || value === 0) && (isNaN(value) || Number(value) >= max);
      var downDisabled = (value || value === 0) && (isNaN(value) || Number(value) <= min);
      var isUpDisabled = upDisabled || disabled || readOnly;
      var isDownDisabled = downDisabled || disabled || readOnly;
      var upClassName = (0, _classnames.default)("".concat(prefixCls, "-handler"), "".concat(prefixCls, "-handler-up"), (0, _defineProperty2.default)({}, "".concat(prefixCls, "-handler-up-disabled"), isUpDisabled));
      var downClassName = (0, _classnames.default)("".concat(prefixCls, "-handler"), "".concat(prefixCls, "-handler-down"), (0, _defineProperty2.default)({}, "".concat(prefixCls, "-handler-down-disabled"), isDownDisabled));
      var upEvents = useTouch ? {
        onTouchStart: isUpDisabled ? noop : this.up,
        onTouchEnd: this.stop
      } : {
        onMouseDown: isUpDisabled ? noop : this.up,
        onMouseUp: this.stop,
        onMouseLeave: this.stop
      };
      var downEvents = useTouch ? {
        onTouchStart: isDownDisabled ? noop : this.down,
        onTouchEnd: this.stop
      } : {
        onMouseDown: isDownDisabled ? noop : this.down,
        onMouseUp: this.stop,
        onMouseLeave: this.stop
      };
      return _react.default.createElement("div", {
        className: classes,
        style: style,
        title: title,
        onMouseEnter: onMouseEnter,
        onMouseLeave: onMouseLeave,
        onMouseOver: onMouseOver,
        onMouseOut: onMouseOut,
        onFocus: function onFocus() {
          return null;
        },
        onBlur: function onBlur() {
          return null;
        }
      }, _react.default.createElement("div", {
        className: "".concat(prefixCls, "-handler-wrap")
      }, _react.default.createElement("span", Object.assign({
        unselectable: "on"
      }, upEvents, {
        role: "button",
        "aria-label": "Increase Value",
        "aria-disabled": isUpDisabled,
        className: upClassName
      }), upHandler || _react.default.createElement("span", {
        unselectable: "on",
        className: "".concat(prefixCls, "-handler-up-inner"),
        onClick: preventDefault
      })), _react.default.createElement("span", Object.assign({
        unselectable: "on"
      }, downEvents, {
        role: "button",
        "aria-label": "Decrease Value",
        "aria-disabled": isDownDisabled,
        className: downClassName
      }), downHandler || _react.default.createElement("span", {
        unselectable: "on",
        className: "".concat(prefixCls, "-handler-down-inner"),
        onClick: preventDefault
      }))), _react.default.createElement("div", {
        className: "".concat(prefixCls, "-input-wrap")
      }, _react.default.createElement("input", Object.assign({
        role: "spinbutton",
        "aria-valuemin": min,
        "aria-valuemax": max,
        "aria-valuenow": value,
        required: required,
        type: type,
        placeholder: placeholder,
        onPaste: onPaste,
        onClick: onClick,
        onMouseUp: this.onMouseUp,
        className: "".concat(prefixCls, "-input"),
        tabIndex: tabIndex,
        autoComplete: autoComplete,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        onKeyDown: editable ? this.onKeyDown : noop,
        onKeyUp: editable ? this.onKeyUp : noop,
        autoFocus: autoFocus,
        maxLength: maxLength,
        readOnly: readOnly,
        disabled: disabled,
        max: max,
        min: min,
        step: step,
        name: name,
        title: title,
        id: id,
        onChange: this.onChange,
        ref: this.saveInput,
        value: this.getFullNum(inputDisplayValue),
        pattern: pattern,
        inputMode: inputMode
      }, dataOrAriaAttributeProps))));
    }
  }]);
  return InputNumber;
}(_react.default.Component);

InputNumber.defaultProps = {
  focusOnUpDown: true,
  useTouch: false,
  prefixCls: 'rc-input-number',
  max: MAX_SAFE_INTEGER,
  min: -MAX_SAFE_INTEGER,
  step: 1,
  style: {},
  onChange: noop,
  onKeyDown: noop,
  onPressEnter: noop,
  onFocus: noop,
  onBlur: noop,
  parser: defaultParser,
  required: false,
  autoComplete: 'off'
};
var _default = InputNumber;
exports.default = _default;